-- This software is supplied under the terms of a license agreement or
-- nondisclosure agreement and may not be copied or disclosed except 
-- in accordance with the terms of that agreement.
--
--      Copyright (c) 1996-2005
--      All Rights Reserved.
-----------------------------------------------------------------------------

macroscript CivilizationIVTextureExportAddAll category:"CivilizationIV Tools" 
	buttonText:"Add Texture Export Attributes To All Materials" 
	toolTip:"Add Texture Export Attributes To All Materials" Icon:#("CivilizationIV", 23)
(
	include "CivilizationIV/NiShaderHelpers.ms"
	include "CivilizationIV/TextureExportCustAttribs.ms"
	include "CivilizationIV/MipMapCustAttribs.ms"

	on execute do
	(
		for mtl in sceneMaterials do
		(
			allTexMaps = #()
			allTexMaps = GetAllTexMapsFromMaterial mtl allTexMaps

			for currentTexMap in allTexMaps do
			(
				if currentTexMap != undefined do
				(	
					iCACount = custAttributes.count currentTexMap
					iFoundIndexTexExport = -1
					iFoundIndexMipMap = -1

					for i = 1 to iCACount do
					(
						TempCA = custAttributes.getdef currentTexMap i
						if TempCA != undefined and TempCA.name == TextureExportCA.name do
						(
							iFoundIndexTexExport = i
						)
					) 

					if iFoundIndexTexExport <= 0 do
					(
						custAttributes.add currentTexMap TextureExportCA						
					)

					iCACount = custAttributes.count currentTexMap
					for i = 1 to iCACount do
					(
						TempCA = custAttributes.getdef currentTexMap i
						if TempCA != undefined and TempCA.name == MipMapPyramidCA.name do
						(
							iFoundIndexMipMap = i
						)
					) 
					
					if iFoundIndexMipMap <= 0 do
					(
						custAttributes.add currentTexMap MipMapPyramidCA
					)
				)
			)				
		)
	)
)