-- This software is supplied under the terms of a license agreement or
-- nondisclosure agreement and may not be copied or disclosed except 
-- in accordance with the terms of that agreement.
--
--      Copyright (c) 1996-2005
--      All Rights Reserved.
-----------------------------------------------------------------------------

utility CivilizationIVMaxUtils "CivilizationIV Misc Utilities"  -- define the utility name and description string 
( 
	label 		lblName			 "CivilizationIV Max Utils"		pos:[40, 17]
	label 		lblVersion		 "   Version: 1.0"		pos:[40, 41]
	button 		RecurseAndExport "Recursive Export" 	pos:[20, 72] 	width:122 	height:20

-- FIRAXIS BATCH PREVIEW ADDITION - MOOSE
	button 		GeneratePreviews "Generate Preview AVIs" 	pos:[20, 103] 	width:122 	height:20
	
	function recursiveExport sourceDir exportDir bPrompt = 
	(
	  for f in getFiles (sourceDir + "*.max") do 
	  (
	    if loadMaxFile f then
		(
		  if exportDir == undefined then 
			  nifFile = sourceDir + getFilenameFile f + ".nif"
	      else
		  	  nifFile = exportDir + getFilenameFile f + ".nif"
		  if bPrompt then
		      exportFile nifFile
		  else exportFile nifFile #noPrompt
	    )
	  )
	  for d in getDirectories (sourceDir + "*") do
	    recursiveExport d exportDir bPrompt
	)

	on RecurseAndExport pressed do
	(
		sourceRoot = getSavePath caption:"All MAX files in the folder you choose and its subfolders will be exported to NIF."
		if sourceRoot != undefined then 
		(
			exportDir = getSavePath caption:"Select export directory for NIF files, or click Cancel to use the same folder as the MAX file."
		
			message = "Do you wish to see the NIF Export Options dialog for each MAX file?\n" +
							   "If not, the options you selected for the most recent NIF export will be used.\n" + 
							   "Or, if you have not yet exported to NIF during this MAX session, the default options will be used."
			bPrompt = queryBox message beep:no
			if bPrompt then
			   promptYN = "will"
			else
			   promptYN = "will not"
		
			if exportDir == undefined then
			   exportDirMsg = "the same folder as the MAX file."
			else
		    (
			   if exportDir[exportDir.count] != "\\" then
			      exportDir = exportDir + "\\"
		       exportDirMsg = exportDir
			)
			if sourceRoot[sourceRoot.count] != "\\" then
			   sourceRoot = sourceRoot + "\\"
			   
			message = "You have chosen to export all MAX files in\n" +
				sourceRoot + 
				"\nand its subfolders.  The NIF files will be saved in\n" +

				exportDirMsg +
				"\n\nYou " + promptYN + " be prompted for NIF export options.\n\nDo you wish to continue?"
				
			if queryBox message beep:no then
				recursiveExport sourceRoot exportDir bPrompt
		)
	)
	

    include "CivilizationIV/ZBufferHelpers.ms"
    include "CivilizationIV/BillboardHelpers.ms"


	
	on CivilizationIVMaxUtils open do 
	( 
		addRollout ZBufferPanel 
		addRollout BillboardPanel 
	) 

	on CivilizationIVMaxUtils close do 
	( 
		removeRollout ZBufferPanel 
		removeRollout BillboardPanel 
	) 
	
-- FIRAXIS BATCH PREVIEW ADDITION BEGIN - MOOSE
    include "CivilizationIV/AnimationHelpers.ms"
	global vp_info
	
	fn vp_info =
	(
		t = slidertime+1
		write_string = (((t.frame as integer) as string))

		y = (gw.getwinsizey() - 15) 
		x = (write_string.count*5.5) * 3
		
		bx = box2 0 y x 32
		gw.setTransform (matrix3 1)
		gw.clearScreen bx useBkg:true
		gw.enlargeUpdateRect bx
		gw.htext [3,3,100] write_string color:(color 0 0 0)
		gw.updatescreen()
	)

	fn renderAvi startFrame endFrame outFile =
	(
		myanim = render fromframe:startFrame toframe:endFrame outputfile:outFile
		undisplay myanim
	)

	fn renderAvi2 startFrame endFrame outFile = 
	(	
		--registerRedrawViewsCallback vp_info
		view_size = getViewSize() 			
		anim_bmp = bitmap view_size.x view_size.y filename:outFile 	
		for t = startFrame to endFrame do 			
		( 		
			sliderTime = t 			
			dib = gw.getViewportDib() 			
			copy dib anim_bmp 			
			save anim_bmp 			
		) 			
		close anim_bmp 
		unregisterRedrawViewsCallback vp_info
		gc()
	)
	
	fn renderAvi3 startFrame endFrame outFile =
	(
--		CreatePreview()
		max preview
		ok = deleteFile outFile
		format "ok1=%\n" ok
		
		ok = renameFile "C:\\3dsmax7\\previews\\_scene.avi" outFile
		format "ok2=%\n" ok
	)
	
	on GeneratePreviews pressed do
	(		
		savepath = getSavePath caption:"Select destination folder for all AVIs"		
		if savePath != undefined then
		(
			-- Get number of sequences
			nd = getNodeByName "MD"
			nt = getNoteTrack nd 1
			seqCount = GetSequenceCount nt
			format "seqCount=%\n" seqCount
						
--			seqCount = 2	-- TEMP
			(
				-- Loop over each sequence, creating avis
				for i = 1 to seqCount do
				(
					-- Make Time Range Fit
					startKey = GetStartKey nt i
					endKey = GetEndKey nt startKey	
					animationRange = (interval startKey.time endKey.time)
									
					seqName = GetSequenceName startKey
					preview_name = savePath+"\\"+seqName+".avi"
					format "%. generating avi, name=%\n" i preview_name
					
--					messageBox "Hit OK"
					renderAvi3 animationrange.start animationrange.end preview_name
				)
			)	
		)
	)
-- FIRAXIS BATCH PREVIEW ADDITION END - MOOSE
)
