-- This software is supplied under the terms of a license agreement or
-- nondisclosure and may not be copied or disclosed except in accordance 
-- with the terms of that agreement.
--
--      Copyright (c) 1996-2005.
--      All Rights Reserved.
-----------------------------------------------------------------------------
-- DO NOT EDIT THIS FILE!!! 
-- This file is essential "as-is" for the shader system to function properly
-----------------------------------------------------------------------------

global TempCA = undefined

-----------------------------------------------------------------------------
function GetAllTexMapsFromMaterial mtl texmapList=
(
	if mtl == undefined then return undefined
	if texmapList == undefined then texmapList = #()

	if IsKindOf mtl StandardMaterial do
	(
		currentTexMap = undefined
		
		for texmap in mtl.maps do
		(
			if texmap != undefined do
			(
				append texmapList texmap 
			)
		)
	
	)

	if isKindOf mtl MultiMaterial do
	(
		mm = mtl
		for submtl in mm.materialList do 
		(
			texmapList = GetAllTexMapsFromMaterial submtl texmapList
		)
	)

	if isKindOf mtl CivilizationIV_XPlatform_Material do
	(
		texmapList = GetAllTexMapsFromMaterial mtl.PCMaterial texmapList
		
		texmapList = GetAllTexMapsFromMaterial mtl.XenonMaterial texmapList
	)

	ThisMaxVersion = maxVersion() 

	if ThisMaxVersion[1] >= 5000 do
	(
		if isKindOf mtl Shell_Material do
		(
			texmapList = GetAllTexMapsFromMaterial mtl.bakedMaterial texmapList
			
			texmapList = GetAllTexMapsFromMaterial mtl.originalMaterial texmapList
		)
	)

	iCACount = custAttributes.count mtl
	
	for i = 1 to iCACount do
	(
		for j = 0 to (NiGetCustAttribCount mtl "NiShaderCustAttribs") do
		(
			retVal = NiGetCustAttrib mtl j "NiShaderCustAttribs"
			if isKindOf retVal textureMap then
				append texmapList retVal
		)
	) 

	return texmapList
)
-----------------------------------------------------------------------------
function GetActiveTexMapFromMaterial mtl =
(
	if mtl == undefined then return undefined
	--print "GetActiveTexMapFromMaterial "

	print mtl
	if IsKindOf mtl StandardMaterial do
	(
		--print "Standard Material"
		currentTexMap = undefined
		
		for texmap in mtl.maps do
		(
			if texmap != undefined do
			(
				--print texmap
				flags = getMTLMEditFlags texmap
				if flags[1] == true do
				(
					--print "Found current tex map"
					currentTexMap = texmap
					return currentTexMap
				)
			)
		)
	
	)

	if isKindOf mtl MultiMaterial do
	(
		--print "MultiMaterial"
		mm = mtl
		for submtl in mm.materialList do 
		(
			tempMtl = GetActiveTexMapFromMaterial submtl
			if tempMtl != undefined then return tempMtl
		)
	)

	if isKindOf mtl CivilizationIV_XPlatform_Material do
	(
		--print "XPlatform Material"
		tempMtl = GetActiveTexMapFromMaterial mtl.PCMaterial
		if tempMtl != undefined then return tempMtl

		tempMtl = GetActiveTexMapFromMaterial mtl.XenonMaterial
		if tempMtl != undefined then return tempMtl
	)

	ThisMaxVersion = maxVersion() 

	if ThisMaxVersion[1] >= 5000 do
	(
		if isKindOf mtl Shell_Material do
		(
			tempMtl = GetActiveTexMapFromMaterial mtl.bakedMaterial
			if tempMtl != undefined then return tempMtl

			tempMtl = GetActiveTexMapFromMaterial mtl.originalMaterial
			if tempMtl != undefined then return tempMtl
		)
	)

	iCACount = custAttributes.count mtl
	--print "Searching through ca's"
	for i = 1 to iCACount do
	(
		for j = 0 to (NiGetCustAttribCount mtl "NiShaderCustAttribs") do
		(
			texmap = NiGetCustAttrib mtl j "NiShaderCustAttribs"
			if isKindOf texmap textureMap then
			(
				flags = getMTLMEditFlags texmap
				if flags[1] == true do
				(
					return texmap
				)
			)
		)
	) 

	return undefined
)
-----------------------------------------------------------------------------
function GetActiveBitmapTexture =
(
	currentMaterial = meditMaterials[medit.GetActiveMtlSlot()]
	--print currentMaterial
	return GetActiveTexMapFromMaterial currentMaterial
)

-----------------------------------------------------------------------------
mapped fn ShowAttributes obj = 
( 
	format "%\n" obj.name 
	for objDef in (custAttributes.getDefs obj) do 
	( 
		format "\t%\n" objDef 
		format "\tname: %\n" objDef.name 
		format "\tattribute id: %\n" objDef.attribID 
		format "\tParameter Blocks:" 
		pbArray = custAttributes.getPBlockDefs objdef 
		for a = 1 to pbArray.count do 
		( 
			itms = pbArray[a] 
			format "\n\t\tname = %\n" itms[1] 
			format "\t\tid = %\n" itms[2] 
			format "\t\towners reference number = %\n" itms[3] 
			keywordParams = itms[4] 
			format "\t\tparameter block keywords:\n" 
			for x = 1 to keywordParams.Count/2 do 
			( 
				format "\t\t\t% = %\n" keywordParams[x] keywordParams[x+1] 
				x = x+1 
			) 
			format "\t\tparameters:" 
			for y = 5 to itms.Count do 
			( 
				format "\n\t\t\t#name = %\n" itms[y][1] 
				for z = 1 to itms[y][2].Count by 2 do 
				( 
					format "\t\t\t% = %\n" itms[y][2][z] itms[y][2][z+1] 
				) 
			) 
		) 
	) 
)
-----------------------------------------------------------------------------
function GetNiShaderCustAttribDef mtlTemp =
(
	bHasOldDef = false
	old_attr_def = undefined
	count = custAttributes.count mtlTemp
	print count
	for i = 1 to custAttributes.count mtlTemp do
	(
		old_attr_def = custAttributes.getdef mtlTemp i
		if old_attr_def != undefined and old_attr_def.name == "NiShaderCustAttribs" do 
		(
			bHasOldDef = true
			return old_attr_def	
		)
	)
	return undefined
)

-----------------------------------------------------------------------------
function NeedsReassignment mtl strShaderName =
(
	if mtl == undefined then return false
	
	if isKindOf mtl StandardMaterial do 
	(
		if mtl.shaderbyname == "CivilizationIV Shader" do
		(
			if mtl.customshader != "Default Shader" do
			(
				shadersrc = GetSourceForShader strShaderName
				old_attr_def = GetNiShaderCustAttribDef mtl
				if shadersrc == undefined then return true 
				if old_attr_def == undefined then return true
				if old_attr_def.source == shadersrc then return false
			)	
		)
	) 
	return true
)

-----------------------------------------------------------------------------
function RedefineShaderCustomAttributes mtl strShaderName =
(
	print "Redefining custom attributes for:"
	print mtl
	old_attr_def = GetNiShaderCustAttribDef mtl
	if old_attr_def != undefined do
	(
		custAttributes.makeUnique mtl old_attr_def
		old_attr_def = GetNiShaderCustAttribDef mtl
		new_attr_def_src = GetSourceForShader strShaderName
		
		if new_attr_def_src != undefined do
		(
			custAttributes.redefine old_attr_def new_attr_def_src
			return true
		)
		if new_attr_def_src == undefined do
		(
			strError = "Unable to find shader definition, "
			strError = strError + strShaderName
			strError = strError + ".\nPlease verify that this shader exists in your shader library path."
			messageBox strError title:"Unable to find shader definition!" beep:true 
			return false

		)
	)
	return false
)
-----------------------------------------------------------------------------
function AddShaderCustomAttributes mtl strShaderName =
(
	print "adding custom attributes for:"
	print mtl
	old_attr_def = GetNiShaderCustAttribDef mtl
	if old_attr_def == undefined do
	(
		new_attr_def_src = GetSourceForShader strShaderName
		if new_attr_def_src != undefined do
		(
			new_attr_def = execute(new_attr_def_src)
			if new_attr_def != undefined do
			(
				custAttributes.add mtl new_attr_def #unique
				return true
			)
		)
	)
	return false
)
-----------------------------------------------------------------------------
function AddOrRedefineShaderCustomAttributes mtl strShaderName =
(
	bAdded = AddShaderCustomAttributes mtl strShaderName
	if bAdded == false do
	(
		bNeedsReassignment = NeedsReassignment mtl strShaderName
		if bNeedsReassignment == true do
		(
			 bAdded = RedefineShaderCustomAttributes mtl strShaderName 
		)
		
		if bNeedsReassignment == false do
		(
			bAdded = true
		)
	)
	
	if bAdded == false do 
	(
		strMsg = "Error in adding \"" + strShaderName + "\" to material: \"" + mtl.name + "\""
	)
)

-----------------------------------------------------------------------------
function ReassignMaterial mtl = 
(	
	if mtl == undefined then return false
	if isKindOf mtl StandardMaterial do 
	(
		if mtl.shaderbyname == "CivilizationIV Shader" do
		(
			if mtl.customshader != "Default Shader" do
			(
				bNeedsReassignment = NeedsReassignment mtl mtl.customshader
				if bNeedsReassignment == true do
				(
					RedefineShaderCustomAttributes mtl mtl.customshader
				)
			)	
		)
	) 

	if isKindOf mtl MultiMaterial do
	(
		mm = mtl
		for mtl in mm.materialList do ReassignMaterial mtl
	)

	if isKindOf mtl CivilizationIV_XPlatform_Material do
	(
		ReassignMaterial mtl.PCMaterial
		ReassignMaterial mtl.XenonMaterial
	)
)


-----------------------------------------------------------------------------
function ReassignMatchingNiShadersInScene = 
(
	for mtl in sceneMaterials do 
	(
		ReassignMaterial mtl
	)
)
-----------------------------------------------------------------------------

function ReassignMatchingNiShadersInBrowser = 
(
	for mtl in meditMaterials do
	(
		ReassignMaterial mtl
	)
)
-----------------------------------------------------------------------------
function GetInternalMatchingMaterial mtl mtlName = 
(
	if mtl == undefined then return undefined
	if isKindOf mtl StandardMaterial do 
	(
		if mtl.name == mtlName then return mtl else return undefined
	) 

	if isKindOf mtl MultiMaterial do
	(
		mm = mtl
		for mtl in mm.materialList do 
		(
			newmtl = GetInternalMatchingMaterial mtl mtlName 
			if newmtl != undefined then return newmtl
		)
	)

	if isKindOf mtl CivilizationIV_XPlatform_Material do
	(
		newmtl = GetInternalMatchingMaterial mtl.PCMaterial mtlName 
		if newmtl != undefined then return newmtl

		newmtl = GetInternalMatchingMaterial mtl.XenonMaterial mtlName 
		if newmtl != undefined then return newmtl
	)
	return undefined
) 
-----------------------------------------------------------------------------
