## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
##
## Implementaion of miscellaneous game functions

import CvUtil
from CvPythonExtensions import *
import CvEventInterface
import Popup as PyPopup
import PyHelpers
# Cybah: BASE fr 6.3 B - Philosophical Trait / Scriptdata START
import SdToolKitCustom as SDTK
# Cybah: BASE fr 6.3 B - Philosophical Trait / Scriptdata END

# globals
gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo
PyCity = PyHelpers.PyCity
PyGame = PyHelpers.PyGame

class CvGameUtils:
	"Miscellaneous game functions"
	def __init__(self): 
		pass
	
	def isVictoryTest(self):
		return CyGame().getElapsedGameTurns() > 10

	def isVictory(self, argsList):
		eVictory = argsList[0]
		return True

	def isPlayerResearch(self, argsList):
		ePlayer = argsList[0]
		return True

	def getExtraCost(self, argsList):
		ePlayer = argsList[0]
		return 0

	def createBarbarianCities(self):
		return False
		
	def createBarbarianUnits(self):
		return False
		
	def skipResearchPopup(self,argsList):
		ePlayer = argsList[0]
		return False
		
	def showTechChooserButton(self,argsList):
		ePlayer = argsList[0]
		return True

	def getFirstRecommendedTech(self,argsList):
		ePlayer = argsList[0]
		return TechTypes.NO_TECH

	def getSecondRecommendedTech(self,argsList):
		ePlayer = argsList[0]
		eFirstTech = argsList[1]
		return TechTypes.NO_TECH
	
	def canRazeCity(self,argsList):
		iRazingPlayer, pCity = argsList
		return True
	
	def canDeclareWar(self,argsList):
		iAttackingTeam, iDefendingTeam = argsList
		return True
	
	def skipProductionPopup(self,argsList):
		pCity = argsList[0]
		return False
		
	def showExamineCityButton(self,argsList):
		pCity = argsList[0]
		return True

	def getRecommendedUnit(self,argsList):
		pCity = argsList[0]
		return UnitTypes.NO_UNIT

	def getRecommendedBuilding(self,argsList):
		pCity = argsList[0]
		return BuildingTypes.NO_BUILDING

	def updateColoredPlots(self):
		return False

	def isActionRecommended(self,argsList):
		pUnit = argsList[0]
		iAction = argsList[1]
		return False

	def unitCannotMoveInto(self,argsList):
		ePlayer = argsList[0]		
		iUnitId = argsList[1]
		iPlotX = argsList[2]
		iPlotY = argsList[3]
		return False

	def cannotHandleAction(self,argsList):
		pPlot = argsList[0]
		iAction = argsList[1]
		bTestVisible = argsList[2]
		return False

	def canBuild(self,argsList):
		iX, iY, iBuild, iPlayer = argsList

# ZE: Indianer Start -----------------------------------------------------------------------------------------------
#		if iBuild == gc.getInfoTypeForString("BUILD_NOMAD_CAMP"):
#			pPlayer = gc.getPlayer(iPlayer)
#			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
#				iTech = gc.getInfoTypeForString("TECH_NATIVE_AMERICA")
#				pPlot = CyMap().plot(iX, iY)
#				if gc.getPlayer(pPlot.getOwner()) == pPlayer and gc.getTeam(pPlayer.getTeam()).isHasTech(iTech) and pPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_SNOW") and not pPlot.isHills() and not pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_NOMAD_CAMP"):
#					return 1
#				else:
#					return -1
# ZE: Indianer End -----------------------------------------------------------------------------------------------
#
#		else:
		return -1	# Returning -1 means ignore; 0 means Build cannot be performed; 1 or greater means it can

	def cannotFoundCity(self,argsList):
		iPlayer, iPlotX, iPlotY = argsList
		return False

	def cannotSelectionListMove(self,argsList):
		pPlot = argsList[0]
		bAlt = argsList[1]
		bShift = argsList[2]
		bCtrl = argsList[3]
		return False

	def cannotSelectionListGameNetMessage(self,argsList):
		eMessage = argsList[0]
		iData2 = argsList[1]
		iData3 = argsList[2]
		iData4 = argsList[3]
		iFlags = argsList[4]
		bAlt = argsList[5]
		bShift = argsList[6]
		return False

	def cannotDoControl(self,argsList):
		eControl = argsList[0]
		return False

	def canResearch(self,argsList):
		ePlayer = argsList[0]
		eTech = argsList[1]
		bTrade = argsList[2]
		return False

	def cannotResearch(self,argsList):
		ePlayer = argsList[0]
		eTech = argsList[1]
		bTrade = argsList[2]
		return False

	def canDoCivic(self,argsList):
		ePlayer = argsList[0]
		eCivic = argsList[1]
		return False

	def cannotDoCivic(self,argsList):
		ePlayer = argsList[0]
		eCivic = argsList[1]
		return False
		
	def canTrain(self,argsList):
		pCity = argsList[0]
		eUnit = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]
		bIgnoreCost = argsList[4]
		bIgnoreUpgrades = argsList[5]
		return False

	def cannotTrain(self,argsList):
		pCity = argsList[0]
		eUnit = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]
		bIgnoreCost = argsList[4]
		bIgnoreUpgrades = argsList[5]
		return False

	def canConstruct(self,argsList):
		pCity = argsList[0]
		eBuilding = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]
		bIgnoreCost = argsList[4]
		return False

	def cannotConstruct(self,argsList):
		pCity = argsList[0]
		eBuilding = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]
		bIgnoreCost = argsList[4]

		pPlayer = gc.getPlayer(pCity.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())
		pCapital = pPlayer.getCapitalCity()

		# player can't build an arcology if they have shielding or advanced shielding
		if eBuilding == gc.getInfoTypeForString("BUILDING_ARCOLOGY"):
			# if pCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING")) or pCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_DEFLECTOR_SHIELDING")):
			if pCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING")):
				return True
		
		## player can't build shielding if they have advanced
		#if eBuilding == gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING"):
			#if pCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_DEFLECTOR_SHIELDING")):
				#return True

## Artistic Trait Start ##
		lgleicheBC = []
		buildingClassType = gc.getBuildingInfo(eBuilding).getBuildingClassType()
		for i in range(gc.getNumBuildingInfos()):
			if ( buildingClassType == gc.getBuildingInfo(i).getBuildingClassType() ):
				lgleicheBC.append(i)

		if ( len(lgleicheBC) >= 2 ):
			if ( eBuilding == lgleicheBC[0] ):
				for i in range(len(lgleicheBC)-1):
					if ( pCity.getNumActiveBuilding(lgleicheBC[i +1])==true ):
						return True
## Artistic Trait End ##
## Cybah: BASE fr 6.2 D - ZE: Byzanz START
		if eBuilding ==gc.getInfoTypeForString("BUILDING_PALACE"):
			if ((not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_UNLIMITED_NATIONAL_WONDERS)) and pCapital.isNationalWondersMaxed()):
				return True
## Cybah: BASE fr 6.2 D - ZE: Byzanz END
## Great Wall Forbidden Start ##
		if eBuilding ==gc.getInfoTypeForString("BUILDING_GREAT_WALL"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_GREAT_WALL):
				return True
## Great Wall Forbidden End ##
## Area 51 Forbidden Start ##
		if eBuilding ==gc.getInfoTypeForString("BUILDING_AREA51"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_AREA51):
				return True
## Area 51 Forbidden End ##
## Codex Forbidden Start ##
#		if eBuilding ==gc.getInfoTypeForString("BUILDING_CODE_OF_HAMMURABI"):
#			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_ESPIONAGE):
#				return True
## Codex Forbidden End ##
## Game Option No Corporations Start ##
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_1"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_2"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_3"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_4"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_5"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_6"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
		if eBuilding ==gc.getInfoTypeForString("BUILDING_CORPORATION_7"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CORPORATIONS):
				return True
## Game Option No Corporations End ##
## Triumpfbogen Start ##
		if eBuilding ==gc.getInfoTypeForString("BUILDING_ARC_DE_TRIOMPHE"):
			if pPlayer.getGreatGeneralsCreated() < 2:
				return True
## Triumpfbogen End ##
## Petra Start ##
		if eBuilding ==gc.getInfoTypeForString("BUILDING_PETRA"):
			pCityPlot = pCity.plot()
			# Cybah: BASE fr 6.3 - Nur noch 4 Wstenfelder, Stadtfeld egal
			# if pCityPlot.getTerrainType() != gc.getInfoTypeForString( 'TERRAIN_DESERT' ):
				# return True
			# else:
			iDesertPlots = 0
			for i in xrange(gc.getNUM_CITY_PLOTS()):
				pPlotX = pCity.getCityIndexPlot(i)
				if pPlotX and not pPlotX.isNone():
					if pPlotX.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_DESERT' ) and pPlotX.isOwned() and pPlotX.getOwner() == pPlayer.getID() and not pPlotX.isPeak():
						# Cybah: BASE fr 6.2 C - Petra geht jetzt auch mit Savanne und Oase (siehe auch CvPlot.cpp)
						# if pPlotX.getFeatureType() == FeatureTypes.NO_FEATURE:
						if pPlotX.getFeatureType() == FeatureTypes.NO_FEATURE or pPlotX.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_SAVANNA' ) or pPlotX.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_OASIS' ):
							iDesertPlots += 1
			# Stadtfeld zhlt mit
			if iDesertPlots < 4: return True
## Petra End ##
## Samurai-Burg Himeji Start ##
# Cybah: BASE fr 6.1 E - Nicht mehr ntig, weil es jetzt auch einen Offensiveffekt gibt
		# if eBuilding ==gc.getInfoTypeForString("BUILDING_HIMEJI_CASTLE"):
			# if pPlayer.getNumCities() < 2:
				# return True
## Samurai-Burg Himeji End ##
		return False

	def canCreate(self,argsList):
		pCity = argsList[0]
		eProject = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]
		return False

	def cannotCreate(self,argsList):
		pCity = argsList[0]
		eProject = argsList[1]
		bContinue = argsList[2]
		bTestVisible = argsList[3]

		pPlayer = gc.getPlayer(pCity.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())

## GEOGRAPHIKE_HYPHEGESIS Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_GEOGRAPHIKE_HYPHEGESIS"): 
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_SATELLITES")):
				return True
## GEOGRAPHIKE_HYPHEGESIS End --------------------------------------------------------------------------------------------------------
## SETI Project Forbidden Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_SETI"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_SETI):
				return True
## SETI Project Forbidden End --------------------------------------------------------------------------------------------------------
## Manhattan Project Forbidden Start --------------------------------------------------------------------------------------------------------
## BASE fr 6.3 - erfordert jetzt auch Uran
		if eProject == gc.getInfoTypeForString("PROJECT_MANHATTAN_PROJECT"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_MANHATTAN_PROJECT) or not pCity.hasBonus(gc.getInfoTypeForString("BONUS_URANIUM")):
				return True
## Manhattan Project Forbidden End --------------------------------------------------------------------------------------------------------
## BASE fr 6.3 C - Dead Hand Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_DEAD_HAND"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_MANHATTAN_PROJECT) or not pCity.hasBonus(gc.getInfoTypeForString("BONUS_URANIUM")):
				return True
## BASE fr 6.3 C - Dead Hand End --------------------------------------------------------------------------------------------------------
## World War Forbidden Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_WORLD_WAR"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ALWAYS_WAR) or gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_WORLD_WAR) or gc.getGame().countCivTeamsAlive() < 3:
				return True
## World War Forbidden End --------------------------------------------------------------------------------------------------------
## The Internet Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_THE_INTERNET"):
			if gc.getGame().countCivTeamsAlive() < 3:
				return True
## The Internet End --------------------------------------------------------------------------------------------------------
## Broadband Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_BROADBAND"):
			if (pTeam.getProjectCount(gc.getInfoTypeForString("PROJECT_THE_INTERNET")) > 0) or (gc.getGame().countCivTeamsAlive() < 4):
				return True
## Broadband End --------------------------------------------------------------------------------------------------------
## Nobel Prize Acceptance Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_NOBEL_ACCEPTANCE"):
			if pTeam.getProjectCount(gc.getInfoTypeForString("PROJECT_NOBEL")) > 0:
				return True
## Nobel Prize Acceptance End --------------------------------------------------------------------------------------------------------
## GMMR Forbidden Start --------------------------------------------------------------------------------------------------------
		if eProject == gc.getInfoTypeForString("PROJECT_GMMR"):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_FUTURE_ERA):
				return True
## GMMR Forbidden End --------------------------------------------------------------------------------------------------------

		return False

	def canMaintain(self,argsList):
		pCity = argsList[0]
		eProcess = argsList[1]
		bContinue = argsList[2]

		pPlayer = gc.getPlayer(pCity.getOwner())

## Better Culture Prod Start ##
		CultureProdTech = gc.getInfoTypeForString("TECH_MASS_MEDIA")
		if eProcess == gc.getInfoTypeForString("PROCESS_CULTURE2"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(CultureProdTech):
				return true
## Better Culture Prod End ##
## Better Espionage Prod Start ##
		EspionageProdTech = gc.getInfoTypeForString("TECH_DETECTION_TECHNIQUES")
		if eProcess == gc.getInfoTypeForString("PROCESS_ESPIONAGE2"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(EspionageProdTech):
				return true
## Better Espionage Prod End ##
## Better Research Prod Start ##
		ResearchProdTech = gc.getInfoTypeForString("TECH_SCIENTIFIC_METHOD")
		if eProcess == gc.getInfoTypeForString("PROCESS_RESEARCH2"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(ResearchProdTech):
				return true
## Better Research Prod End ##
## Better Wealth Prod Start ##
		WealthProdTech = gc.getInfoTypeForString("TECH_TOURISM")
		if eProcess == gc.getInfoTypeForString("PROCESS_WEALTH2"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(WealthProdTech):
				return true
## Better Wealth Prod End ##

		return False

	def cannotMaintain(self,argsList):
		pCity = argsList[0]
		eProcess = argsList[1]
		bContinue = argsList[2]

		pPlayer = gc.getPlayer(pCity.getOwner())

## Exploitation Start ##
		if eProcess == gc.getInfoTypeForString("PROCESS_WEALTH0"):
			iTechCurrency = gc.getInfoTypeForString("TECH_CURRENCY")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechCurrency):
				return True
## Exploitation End ##
## Better Culture Prod Start ##

		CultureProdTech = gc.getInfoTypeForString("TECH_MASS_MEDIA")
		if eProcess == gc.getInfoTypeForString("PROCESS_CULTURE"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(CultureProdTech):
				return True
		if eProcess == gc.getInfoTypeForString("PROCESS_CULTURE2"):
			if not gc.getTeam(pPlayer.getTeam()).isHasTech(CultureProdTech):
				return True

## Better Culture Prod End ##
## Better Espionage Prod Start ##

		EspionageProdTech = gc.getInfoTypeForString("TECH_DETECTION_TECHNIQUES")
		if eProcess == gc.getInfoTypeForString("PROCESS_ESPIONAGE"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(EspionageProdTech):
				return True
		if eProcess == gc.getInfoTypeForString("PROCESS_ESPIONAGE2"):
			if not gc.getTeam(pPlayer.getTeam()).isHasTech(EspionageProdTech):
				return True

## Better Espionage Prod End ##
## Better Research Prod Start ##

		ResearchProdTech = gc.getInfoTypeForString("TECH_SCIENTIFIC_METHOD")
		if eProcess == gc.getInfoTypeForString("PROCESS_RESEARCH"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(ResearchProdTech):
				return True
		if eProcess == gc.getInfoTypeForString("PROCESS_RESEARCH2"):
			if not gc.getTeam(pPlayer.getTeam()).isHasTech(ResearchProdTech):
				return True

## Better Research Prod End ##
## Better Wealth Prod Start ##

		WealthProdTech = gc.getInfoTypeForString("TECH_TOURISM")
		if eProcess == gc.getInfoTypeForString("PROCESS_WEALTH"):
			if gc.getTeam(pPlayer.getTeam()).isHasTech(WealthProdTech):
				return True
		if eProcess == gc.getInfoTypeForString("PROCESS_WEALTH2"):
			if not gc.getTeam(pPlayer.getTeam()).isHasTech(WealthProdTech):
				return True

## Better Wealth Prod End ##

		return False

	def AI_chooseTech(self,argsList):
		ePlayer = argsList[0]
		bFree = argsList[1]
		pPlayer = gc.getPlayer(ePlayer)
		iCiv = pPlayer.getCivilizationType()
		eTeam = gc.getTeam(pPlayer.getTeam())
		iTech = -1
		
## AI Adjust ##
		# rucivfan_ai_auto_play raap[
		#if not pPlayer.isHuman():
		if not pPlayer.isHumanActive():
		# ]rucivfan_ai_auto_play raap		
			#Rad sptestens mit (tierzucht oder bronze) und (lawi oder fischen)
			if ((eTeam.isHasTech(gc.getInfoTypeForString('TECH_BRONZE_WORKING')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_ANIMAL_HUSBANDRY'))) and (eTeam.isHasTech(gc.getInfoTypeForString('TECH_AGRICULTURE')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_FISHING')))):
				iTech = gc.getInfoTypeForString('TECH_THE_WHEEL')	
				if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
					return iTech
		
			# Finanzielle Schwierigkeiten
			#rucivfan_better_ai rbai[
			#if pPlayer.AI_isFinancialTrouble():
			if pPlayer.AI_isPoorFinancial():
			#]rucivfan_better_ai rbai
				if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_CURRENCY')):
					iTroubleTech = gc.getInfoTypeForString('TECH_CURRENCY')					
					if pPlayer.canResearch(iTroubleTech, false):
						return iTroubleTech
				if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_CODE_OF_LAWS')):
					iTroubleTech = gc.getInfoTypeForString('TECH_CODE_OF_LAWS')
					if pPlayer.canResearch(iTroubleTech, false):
						return iTroubleTech
						
			# Whrung wichtiger
			if (eTeam.isHasTech(gc.getInfoTypeForString('TECH_CONSTRUCTION')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_ALPHABET'))):
				iTech = gc.getInfoTypeForString('TECH_CURRENCY')	
				if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
					return iTech
		
			# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_RUTHLESS_AI):
			
			# Traitspezifische Prferenzen
			bTraitTechForced = False
			
			# Deaktiviert mit 6.2 D - wurde oft zu frh erforscht
			# if pPlayer.hasTrait(gc.getInfoTypeForString('TRAIT_SCIENTIFIC')) or pPlayer.hasTrait(gc.getInfoTypeForString('TRAIT_PHILOSOPHICAL')):
				# iTech = gc.getInfoTypeForString('TECH_WRITING')
				# if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
					# bTraitTechForced = True
					# return iTech
					
			if not bTraitTechForced and pPlayer.hasTrait(gc.getInfoTypeForString('TRAIT_SPIRITUAL')):
				iTech = gc.getInfoTypeForString('TECH_TOURISM')
				if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
					bTraitTechForced = True
					return iTech
			
			# Zivilisationsspezifische Prferenzen
			iPrefTech1 = -1
			iPrefTech2 = -1
			iPrefTech3 = -1
			iPrefTech4 = -1
			iPrefTech5 = -1

			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_RIFLING')
				if eTeam.isHasTech(iPrefTech1): iPrefTech2 = gc.getInfoTypeForString('TECH_INDUSTRIALISM')
				iPrefTech3 = gc.getInfoTypeForString('TECH_ROCKETRY')
				if eTeam.isHasTech(iPrefTech3): iPrefTech4 = gc.getInfoTypeForString('TECH_DETECTION_TECHNIQUES')
				iPrefTech5 = gc.getInfoTypeForString('TECH_REFRIGERATION')		
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_WRITING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_CHEMISTRY')
				if eTeam.isHasTech(iPrefTech1): iPrefTech3 = gc.getInfoTypeForString('TECH_GUILDS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MUSIC')
				if eTeam.isHasTech(iPrefTech1): iPrefTech3 = gc.getInfoTypeForString('TECH_INDUSTRIALISM')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AZTEC"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CODE_OF_LAWS')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_RIFLING')
				if eTeam.isHasTech(iPrefTech2): iPrefTech3 = gc.getInfoTypeForString('TECH_INDUSTRIALISM')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				iPrefTech3 = gc.getInfoTypeForString('TECH_ASTRONOMY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech5 = gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_LIBERALISM')
				iPrefTech3 = gc.getInfoTypeForString('TECH_RADIO')
				if eTeam.isHasTech(iPrefTech2) and eTeam.isHasTech(iPrefTech3): iPrefTech4 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech5 = gc.getInfoTypeForString('TECH_ELECTRICITY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_ADVANCED_SAILING')
				iPrefTech3 = gc.getInfoTypeForString('TECH_MACHINERY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_CIVIL_SERVICE')
				iPrefTech5 = gc.getInfoTypeForString('TECH_GUILDS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MUSIC')
				iPrefTech3 = gc.getInfoTypeForString('TECH_ASTRONOMY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')

			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_COMPASS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_DRAMA')
				iPrefTech2 = gc.getInfoTypeForString('TECH_FEUDALISM')
				iPrefTech3 = gc.getInfoTypeForString('TECH_MACHINERY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_ADVANCED_SAILING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_STEAM_POWER')
				iPrefTech2 = gc.getInfoTypeForString('TECH_ASTRONOMY')
				iPrefTech3 = gc.getInfoTypeForString('TECH_RIFLING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech3 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUNPOWDER')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')): iPrefTech4 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')

			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_FEUDALISM')
				iPrefTech2 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech3 = gc.getInfoTypeForString('TECH_BANKING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				iPrefTech3 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech4 = gc.getInfoTypeForString('TECH_ARTILLERY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech2 = gc.getInfoTypeForString('TECH_OPTICS')
				iPrefTech3 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech4 = gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')): iPrefTech1 = gc.getInfoTypeForString('TECH_RIFLING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')): iPrefTech2 = gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_INDUSTRIALISM')): iPrefTech4 = gc.getInfoTypeForString('TECH_ARTILLERY')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_INDUSTRIALISM')): iPrefTech5 = gc.getInfoTypeForString('TECH_RADIO')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_INDUSTRIALISM')): iPrefTech3 = gc.getInfoTypeForString('TECH_COMBUSTION')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_METAL_CASTING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CODE_OF_LAWS')
				iPrefTech2 = gc.getInfoTypeForString('TECH_FEUDALISM')
				if eTeam.isHasTech(iPrefTech2): iPrefTech3 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(iPrefTech2): iPrefTech4 = gc.getInfoTypeForString('TECH_THEOLOGY')
				iPrefTech5 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech3 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				iPrefTech4 = gc.getInfoTypeForString('TECH_RIFLING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
				iPrefTech1 = -1
				iPrefTech2 = -1
				iPrefTech3 = -1
				iPrefTech4 = -1
				iPrefTech5 = -1
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech2 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech3 = gc.getInfoTypeForString('TECH_CONSTITUTION')
				iPrefTech4 = gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CIVIL_SERVICE')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_MONOTHEISM')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MEDICINE')
				iPrefTech3 = gc.getInfoTypeForString('TECH_FISSION')
				iPrefTech4 = gc.getInfoTypeForString('TECH_FUSION')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CIVIL_SERVICE')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MACHINERY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_MATHEMATICS')
				iPrefTech2 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_CONSTRUCTION')): iPrefTech3 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				iPrefTech4 = gc.getInfoTypeForString('TECH_RAILROAD')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech3 = gc.getInfoTypeForString('TECH_EDUCATION')
				iPrefTech4 = gc.getInfoTypeForString('TECH_CHEMISTRY')
				iPrefTech5 = gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')

			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_METAL_CASTING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_FEUDALISM')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_FEUDALISM')): iPrefTech3 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_MACHINERY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				iPrefTech3 = gc.getInfoTypeForString('TECH_GUILDS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_PHILOSOPHY')): iPrefTech1 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_PHILOSOPHY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CIVIL_SERVICE')
				iPrefTech2 = gc.getInfoTypeForString('TECH_METAL_CASTING')
				iPrefTech3 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				iPrefTech4 = gc.getInfoTypeForString('TECH_ADVANCED_SAILING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_MATHEMATICS')
				iPrefTech2 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech3 = gc.getInfoTypeForString('TECH_GUILDS')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUILDS')): iPrefTech4 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech1 = gc.getInfoTypeForString('TECH_CONSTRUCTION')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_CONSTRUCTION')): iPrefTech2 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUILDS')): iPrefTech3 = gc.getInfoTypeForString('TECH_CURRENCY')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_CURRENCY')): iPrefTech4 = gc.getInfoTypeForString('TECH_GUILDS')
				iPrefTech5 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLAND"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_CODE_OF_LAWS')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')): iPrefTech3 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')): iPrefTech4 = gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')): iPrefTech5 = gc.getInfoTypeForString('TECH_RIFLING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_GUNPOWDER')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_STEEL')
				iPrefTech3 = gc.getInfoTypeForString('TECH_CARTOGRAPHY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_OPTICS')
				iPrefTech5 = gc.getInfoTypeForString('TECH_ECONOMICS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_IRON_WORKING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_MONARCHY')): iPrefTech2 = gc.getInfoTypeForString('TECH_METAL_CASTING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_METAL_CASTING')): iPrefTech3 = gc.getInfoTypeForString('TECH_MONARCHY')
				iPrefTech4 = gc.getInfoTypeForString('TECH_CURRENCY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_DIVINE_RIGHT')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')): iPrefTech1 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				iPrefTech3 = gc.getInfoTypeForString('TECH_RIFLING')
				iPrefTech4 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				iPrefTech5 = gc.getInfoTypeForString('TECH_BIOLOGY')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCOTLAND"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_CIVIL_SERVICE')): iPrefTech1 = gc.getInfoTypeForString('TECH_MACHINERY')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_METAL_CASTING')): iPrefTech2 = gc.getInfoTypeForString('TECH_CIVIL_SERVICE')
				iPrefTech3 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				iPrefTech4 = gc.getInfoTypeForString('TECH_MUSIC')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_ENGINEERING')
				iPrefTech2 = gc.getInfoTypeForString('TECH_GUNPOWDER')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')): iPrefTech3 = gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech4 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SUMERIA"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_PRIESTHOOD')
				iPrefTech2 = gc.getInfoTypeForString('TECH_WRITING')
				iPrefTech3 = gc.getInfoTypeForString('TECH_MATHEMATICS')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_TIBET"):
				iPrefTech1 = gc.getInfoTypeForString('TECH_EDUCATION')
				iPrefTech2 = gc.getInfoTypeForString('TECH_DIVINE_RIGHT')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_METAL_CASTING')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech3 = gc.getInfoTypeForString('TECH_FEUDALISM')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_FEUDALISM')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech4 = gc.getInfoTypeForString('TECH_METAL_CASTING')
			
			elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU"):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech1 = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_HORSEBACK_RIDING')): iPrefTech2 = gc.getInfoTypeForString('TECH_RIFLING')
		
			if iPrefTech1 != -1 and not eTeam.isHasTech(iPrefTech1) and pPlayer.canResearch(iPrefTech1, false):
				return iPrefTech1
			if iPrefTech2 != -1 and not eTeam.isHasTech(iPrefTech2) and pPlayer.canResearch(iPrefTech2, false):
				return iPrefTech2
			if iPrefTech3 != -1 and not eTeam.isHasTech(iPrefTech3) and pPlayer.canResearch(iPrefTech3, false):
				return iPrefTech3
			if iPrefTech4 != -1 and not eTeam.isHasTech(iPrefTech4) and pPlayer.canResearch(iPrefTech4, false):
				return iPrefTech4
			if iPrefTech5 != -1 and not eTeam.isHasTech(iPrefTech5) and pPlayer.canResearch(iPrefTech5, false):
				return iPrefTech5
				
			# Drall bei Militrwesen
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUNPOWDER')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_REPLACEABLE_PARTS')):
					iTech = gc.getInfoTypeForString('TECH_RIFLING')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
						
			# Ersatzteile ohne Chemie aber mit Druckerpresse soll Drall-Linie bevorzugen
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_REPLACEABLE_PARTS')) and not eTeam.isHasTech(gc.getInfoTypeForString('TECH_CHEMISTRY')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUNPOWDER')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_PRINTING_PRESS')):
					iTech = gc.getInfoTypeForString('TECH_REPLACEABLE_PARTS')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
		
			# Militrwissenschaft und Drall
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')) and not eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_GUNPOWDER')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_REPLACEABLE_PARTS')):
					iTech = gc.getInfoTypeForString('TECH_RIFLING')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
				elif eTeam.isHasTech(gc.getInfoTypeForString('TECH_CHEMISTRY')):
					iTech = gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
					
			# Militrwesen
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_NATIONALISM')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_MUSIC')):
					iTech = gc.getInfoTypeForString('TECH_MILITARY_TRADITION')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
					
			# Stahl			
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_STEEL')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_CHEMISTRY')) and (eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_TRADITION')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_SCIENCE'))):
					iTech = gc.getInfoTypeForString('TECH_STEEL')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
						
			# Flieband bei Drall oder Militrwissenschaft
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')) and (eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')) or eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_SCIENCE'))):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_STEEL')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_CORPORATION')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_STEAM_POWER')):
					iTech = gc.getInfoTypeForString('TECH_ASSEMBLY_LINE')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
						
			# Artillerie				
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_ARTILLERY')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_INDUSTRIALISM')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_MILITARY_SCIENCE')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_RIFLING')):
					iTech = gc.getInfoTypeForString('TECH_ARTILLERY')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
						
			# Satellitentechnik				
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_SATELLITES')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_INDUSTRIALISM')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_DETECTION_TECHNIQUES')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_ROCKETRY')):
					iTech = gc.getInfoTypeForString('TECH_SATELLITES')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
			
			# ----------- Zukunft ------------
			# Astronavigation				
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASTROGATION')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_METAMATERIALS')):
					iTech = gc.getInfoTypeForString('TECH_ASTROGATION')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
						
			# Metamaterialien				
			if not eTeam.isHasTech(gc.getInfoTypeForString('TECH_METAMATERIALS')):
				if eTeam.isHasTech(gc.getInfoTypeForString('TECH_ASTROGATION')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_SUPERCONDUCTORS')) and eTeam.isHasTech(gc.getInfoTypeForString('TECH_STEALTH')):
					iTech = gc.getInfoTypeForString('TECH_METAMATERIALS')
					if iTech != -1 and not eTeam.isHasTech(iTech) and pPlayer.canResearch(iTech, false):
						return iTech
					
		return TechTypes.NO_TECH

	def AI_chooseProduction(self,argsList):
		pCity = argsList[0]
   		iOwner = pCity.getOwner()
		pPlayer = gc.getPlayer(iOwner)
		pTeam = gc.getTeam(pPlayer.getTeam())

## AI Adjust ##
		# rucivfan_ai_auto_play raap[
		#if not pCity.isOccupation() and (not pPlayer.isHuman() or (pPlayer.isHuman() and pPlayer.isOption(PlayerOptionTypes.PLAYEROPTION_MODDER_3))):
		if not pCity.isOccupation() and (not pPlayer.isHumanActive() or (pPlayer.isHumanActive() and pPlayer.isOption(PlayerOptionTypes.PLAYEROPTION_MODDER_3))):
		# ]rucivfan_ai_auto_play raap		

## AI Project Adjust ##
			#iEra == max(1, pPlayer.getCurrentEra())
			#iGameSpeedFactor == (gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100)
			if CyGame().getElapsedGameTurns() >= (300 * (gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100) / max(4, pPlayer.getCurrentEra())):
			# WORLD_WAR
				if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_WORLD_WAR) and pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_WORLD_WAR')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_WORLD_WAR'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID():
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_WORLD_WAR" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# SETI
				elif not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_SETI) and pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_SETI')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_SETI'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_SETI" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# THE_INTERNET
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_THE_INTERNET')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_THE_INTERNET'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_THE_INTERNET" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# MANHATTAN_PROJECT
				elif not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_MANHATTAN_PROJECT) and pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_MANHATTAN_PROJECT')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_MANHATTAN_PROJECT'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_MANHATTAN_PROJECT" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# DEAD_HAND
				elif not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_MANHATTAN_PROJECT) and pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_DEAD_HAND')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_DEAD_HAND'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_DEAD_HAND" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# BROADBAND
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_BROADBAND')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_BROADBAND'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_BROADBAND" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# HACKER_ATTACK
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_HACKER_ATTACK')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_HACKER_ATTACK'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_HACKER_ATTACK" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# GMMR
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_GMMR')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_GMMR'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_GMMR" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# NOBEL
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_NOBEL')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_NOBEL'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_NOBEL" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# NOBEL_ACCEPTANCE
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_NOBEL_ACCEPTANCE')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_NOBEL_ACCEPTANCE'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_NOBEL_ACCEPTANCE" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True

			# GEOGRAPHIKE_HYPHEGESIS
				elif pTeam.getProjectCount(gc.getInfoTypeForString('PROJECT_GEOGRAPHIKE_HYPHEGESIS')) < 1 and pPlayer.canCreate(gc.getInfoTypeForString('PROJECT_GEOGRAPHIKE_HYPHEGESIS'),0,0):
					iBestProduction = 0
					pMaybeBestProdCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestProdCity):
						iCityOwner = pMaybeBestProdCity.getOwner() 
						if not pMaybeBestProdCity.isNone() and iCityOwner == pPlayer.getID(): 
							if iBestProduction < pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION):
								iBestProduction = pMaybeBestProdCity.getYieldRate(YieldTypes.YIELD_PRODUCTION)
								pBestProdCity = pMaybeBestProdCity
						pMaybeBestProdCity, iter = pPlayer.nextCity(iter, false)

					iProject = CvUtil.findInfoTypeNum(gc.getProjectInfo,gc.getNumProjectInfos(), "PROJECT_GEOGRAPHIKE_HYPHEGESIS" )
					if pBestProdCity.canCreate(iProject,0,0) and not pBestProdCity.isProductionProject():
						gc.getMap().plot(pBestProdCity.getX(), pBestProdCity.getY()).getPlotCity().pushOrder(OrderTypes.ORDER_CREATE, iProject, -1, False, False, False, True)
						return True
## AI Project Adjust ##
## AI Building Adjust ##
				if pCity.canConstruct(gc.getInfoTypeForString("BUILDING_MILITARY_ACADEMY"),0,0,0) and not pTeam.getAtWarCount(True) > 0:
					pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, gc.getInfoTypeForString("BUILDING_MILITARY_ACADEMY"), -1, False, False, False, True)
					return True
					
				# 6.3 C - Raketensilo	
				if pCity.canConstruct(gc.getInfoTypeForString("BUILDING_SILO"),0,0,0) and not pTeam.getAtWarCount(True) > 0:
					pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, gc.getInfoTypeForString("BUILDING_SILO"), -1, False, False, False, True)
					return True
## AI Building Adjust
## AI Unit Adjust ## ----------------------------------------------------------------------------------------------------------------------------------------------------------------

			if not pCity.isProductionProject() and not pCity.isProductionBuilding() and not pCity.isProductionProcess():

			# LIMITIERTE EINHEITEN HABEN PRIORITT START ---------------------------------------------------------------------------------------------
				pBestXPCity = pCity
				iBestXP = 0
				pMaybeBestXPCity, iter = pPlayer.firstCity(false)
				while(pMaybeBestXPCity):
					iCityOwner = pMaybeBestXPCity.getOwner() 
					if not pMaybeBestXPCity.isNone() and iCityOwner == pPlayer.getID():
						iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
# ZE: Zulu 2/2 Start -----------------------------------------------------------------------------------------------
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pPlayer.getID() == pMaybeBestXPCity.getOriginalOwner():
							# iXP += 5
# ZE: Zulu 2/2 End -----------------------------------------------------------------------------------------------
						if iBestXP < iXP: 
							iBestXP = iXP
							pBestXPCity = pMaybeBestXPCity
					pMaybeBestXPCity, iter = pPlayer.nextCity(iter, false)

				if pBestXPCity != -1:

					iWestpoint = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_WEST_POINT" )
					iHeroic = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_HEROIC_EPIC" )
					iIron = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_IRON_WORKS" )

					if not pBestXPCity.isNationalWondersMaxed():

						if pBestXPCity.canConstruct(iWestpoint,0,0,0):
							pBestXPCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iWestpoint, -1, False, False, False, True)
							return True

						elif pBestXPCity.canConstruct(iHeroic,0,0,0) or pBestXPCity.canConstruct(iIron,0,0,0) and (pBestXPCity.getNumRealBuilding(iHeroic) < 1 and pBestXPCity.getNumRealBuilding(iIron) < 1):

							#if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_WEST_POINT")) > 0:

							if pBestXPCity.canConstruct(iHeroic,0,0,0):
								if pBestXPCity.isProductionBuilding():
									pB = pBestXPCity.getProductionBuilding()
									if pB > -1:						
										if pBestXPCity.getNumRealBuilding(iIron) < 1 and not gc.getBuildingInfo(pB).getBuildingClassType() == gc.getInfoTypeForString("BUILDINGCLASS_WEST_POINT") and not gc.getBuildingInfo(pB).getBuildingClassType() == gc.getInfoTypeForString("BUILDINGCLASS_IRON_WORKS"):
											pBestXPCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iHeroic, -1, False, False, False, True)
											return True
								elif pBestXPCity.getNumRealBuilding(iHeroic) < 1 and pBestXPCity.getNumRealBuilding(iIron) < 1:
									pBestXPCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iHeroic, -1, False, False, False, True)
									return True

							elif pBestXPCity.canConstruct(iIron,0,0,0):
								if pBestXPCity.isProductionBuilding():
									pB = pBestXPCity.getProductionBuilding()
									if pB > -1:						
										if pBestXPCity.getNumRealBuilding(iHeroic) < 1 and not gc.getBuildingInfo(pB).getBuildingClassType() == gc.getInfoTypeForString("BUILDINGCLASS_WEST_POINT") and not gc.getBuildingInfo(pB).getBuildingClassType() == gc.getInfoTypeForString("BUILDINGCLASS_HEROIC_EPIC"):
											pBestXPCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iIron, -1, False, False, False, True)
											return True
								elif pBestXPCity.getNumRealBuilding(iHeroic) < 1 and pBestXPCity.getNumRealBuilding(iIron) < 1:

									# --- Testnachricht ---
									#strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_WINNER", (pBestXPCity.getName(), (1)))
									#CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pBestXPCity.getX(), pBestXPCity.getY(), True, True)

									pBestXPCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iIron, -1, False, False, False, True)
									return True

						elif pBestXPCity.isProductionUnit():
							pU = pBestXPCity.getProductionUnit()
							if pU > -1:
								if not isNationalUnitClass(gc.getUnitInfo(pU).getUnitClassType()):
									for iUnit in xrange(gc.getNumUnitInfos()):
										if isNationalUnitClass(gc.getUnitInfo(iUnit).getUnitClassType()):
											if gc.getUnitInfo(iUnit).getCombat() > 0:
												if pBestXPCity.canTrain(iUnit,0,0):
													pBestXPCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnit, -1, False, False, False, True)
													return True

					elif pBestXPCity.isProductionUnit():
						pU = pBestXPCity.getProductionUnit()
						if pU > -1:
							if not isNationalUnitClass(gc.getUnitInfo(pU).getUnitClassType()):
								for iUnit in xrange(gc.getNumUnitInfos()):
									if isNationalUnitClass(gc.getUnitInfo(iUnit).getUnitClassType()):
										if gc.getUnitInfo(iUnit).getCombat() > 0:
											if pBestXPCity.canTrain(iUnit,0,0):
												pBestXPCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnit, -1, False, False, False, True)
												return True
			# LIMITIERTE EINHEITEN HABEN PRIORITT END ---------------------------------------------------------------------------------------------
			
			# # 6.3 B WORKER
			
				# # --------------------------------------------------------------------------------------------------------------
				# # Die KI sollte bis inklusive Mittelalter mindestens 2 Bautrupps auf 1 Stadt haben
				# # --------------------------------------------------------------------------------------------------------------
				# if ((pPlayer.getCurrentEra() < 4) and pCity.getPopulation() > 2 and pPlayer.getNumCities() > 1 and not pCity.isCapital() and not pTeam.getAtWarCount(True) > 0):
					# iOverride = CyGame().getSorenRandNum(100, "Random")
					# estiEnd = CyGame().getEstimateEndTurn()
					# if estiEnd >= 1000:
						# iOverride *= 10
						# iOverride /= 5
					# elif estiEnd >= 700:
						# iOverride *= 7
						# iOverride /= 5
					# elif estiEnd >= 500:
						# iOverride *= 5
						# iOverride /= 5
					# elif estiEnd >= 300:
						# iOverride *= 3
						# iOverride /= 5
					# elif estiEnd < 300:
						# iOverride *= 3
						# iOverride /= 5

					# #  25% Chance bei normaler Spielgeschwindigkeit
					# # -------------------------------------------------------
					# # if ((iOverride < 25) and (not pCity.isProductionUnit() or pCity.getProductionUnit() != CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_SETTLER" ))):
					# if ((iOverride >= 0) and (not pCity.isProductionUnit() or pCity.getProductionUnit() != CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_SETTLER" ))):
					
						# iWorkers = pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_WORKER'))
						# iWorkerRatio = ((iWorkers * 100) / pPlayer.getNumCities())
						# if iWorkerRatio < 200:
							# iBT1 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_WORKER" )
							# iBT2 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_INDIAN_FAST_WORKER" )
							# iBT3 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_MALINESE_WORKER" )
							# if pCity.canTrain(iBT1,0,0):
								# pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBT1, -1, False, False, False, True)
								# return True
							# elif pCity.canTrain(iBT2,0,0):
								# pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBT2, -1, False, False, False, True)
								# return True
							# elif pCity.canTrain(iBT3,0,0):
								# pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBT3, -1, False, False, False, True)
								# return True

				# Sonstiger Code, erst ab Moderne
				if ((pPlayer.getCurrentEra() > 5) and (pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) >= 20)):

					iOverride = CyGame().getSorenRandNum(100, "Random")
					estiEnd = CyGame().getEstimateEndTurn()
					if estiEnd >= 1000:
						iOverride *= 10
						iOverride /= 5
					elif estiEnd >= 700:
						iOverride *= 7
						iOverride /= 5
					elif estiEnd >= 500:
						iOverride *= 5
						iOverride /= 5
					elif estiEnd >= 300:
						iOverride *= 3
						iOverride /= 5
					elif estiEnd < 300:
						iOverride *= 3
						iOverride /= 5

					#  25% Chance bei normaler Spielgeschwindigkeit
					# -------------------------------------------------------
					if iOverride < 25:
					# if iOverride >= 0:
					
						iCurrentBombers = (pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_STEALTH_BOMBER')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_GAA')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_UAV')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_UAV_FUTURE')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_SPACE_BOMBER')))
						iCurrentFighters = (pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_JET_FIGHTER')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_STEALTH_JET_FIGHTER')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_SPACE_FIGHTER')))
						iCurrentMissiles = (pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_ROCKET')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_GUIDED_MISSILE')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_TACTICAL_NUKE')))
						iCurrentMissileCarriers = (pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_MISSILE_CRUISER')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_MISSILE_SUBMARINE')))
						iCurrentParatroopers = (pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_PARATROOPER')) + pPlayer.getUnitClassCountPlusMaking(gc.getInfoTypeForString('UNITCLASS_PARATROOPER_FUTURE')))
						
						iBomber1 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_RUSSIAN_SU25" )
						iBomber2 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_GAA" )
						iBomber3 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_STEALTH_BOMBER" )
						iBomber4 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_SPACE_BOMBER" )
						iUAV1 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_UAV" )
						iUAV2 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_UAV_FUTURE" )
						
						iFighter1 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_JET_FIGHTER" )
						iFighter2 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_SPANISH_EUROFIGHTER" )
						iFighter3 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_STEALTH_JET_FIGHTER" )
						iFighter4 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_SPACE_FIGHTER" )

						iGuidedMissile1 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_AMERICAN_TOMAHAWK" )
						iGuidedMissile2 = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_GUIDED_MISSILE" )
						iRocket = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_ROCKET" )
						
						iPara = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_PARATROOPER" )
						iSAS = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_ENGLISH_SAS" )
						iParaFuture = CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(), "UNIT_PARATROOPER_FUTURE" )

			# RUSSIAN_SU25 / GAA / STEALTH_BOMBER / SPACE_BOMBER

						# --------------------------------------------------------------------------------------------------------------
						# 1 von 10 Militreinheiten sollte ein Bomber sein
						# --------------------------------------------------------------------------------------------------------------
						if (pCity.canTrain(iUAV1,0,0) or pCity.canTrain(iUAV2,0,0) or pCity.canTrain(iBomber1,0,0) or pCity.canTrain(iBomber2,0,0) or pCity.canTrain(iBomber3,0,0) or pCity.canTrain(iBomber4,0,0)) and (iCurrentBombers < (pPlayer.getNumMilitaryUnits() / 10)):

							if pCity.canTrain(iUAV2,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUAV2, -1, False, False, False, True)
								return True
								
							elif pCity.canTrain(iUAV1,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUAV1, -1, False, False, False, True)
								return True
								
							elif pCity.canTrain(iBomber4,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber4, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iBomber1,0,0) and pCity.canTrain(iBomber3,0,0):
								iWhichOne = CyGame().getSorenRandNum(3, "Random")
								if iWhichOne < 2:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber3, -1, False, False, False, True)
									return True
								else:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber1, -1, False, False, False, True)
									return True

							elif pCity.canTrain(iBomber2,0,0) and pCity.canTrain(iBomber3,0,0):
								iWhichOne = CyGame().getSorenRandNum(4, "Random")
								if iWhichOne < 3:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber3, -1, False, False, False, True)
									return True
								else:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber2, -1, False, False, False, True)
									return True

							elif pCity.canTrain(iBomber2,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber2, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iBomber3,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iBomber3, -1, False, False, False, True)
								return True
								
			# JET_FIGHTER / SPANISH_EUROFIGHTER / STEALTH_JET_FIGHTER / SPACE_FIGHTER

						# --------------------------------------------------------------------------------------------------------------
						# 1 von 20 Militreinheiten sollte ein Jger sein
						# --------------------------------------------------------------------------------------------------------------
						if (pCity.canTrain(iFighter1,0,0) or pCity.canTrain(iFighter2,0,0) or pCity.canTrain(iFighter3,0,0) or pCity.canTrain(iFighter4,0,0)) and (iCurrentFighters < (pPlayer.getNumMilitaryUnits() / 20)):

							if pCity.canTrain(iFighter1,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iFighter1, -1, False, False, False, True)
								return True
								
							elif pCity.canTrain(iFighter2,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iFighter2, -1, False, False, False, True)
								return True
								
							elif pCity.canTrain(iFighter3,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iFighter3, -1, False, False, False, True)
								return True
								
							elif pCity.canTrain(iFighter4,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iFighter4, -1, False, False, False, True)
								return True
								
			# PARATROOPER / ENGLISH_SAS / PARATROOPER_FUTURE

						# --------------------------------------------------------------------------------------------------------------
						# 1 von 30 Militreinheiten sollte ein Fallschirmjger sein
						# --------------------------------------------------------------------------------------------------------------
						elif (pCity.canTrain(iPara,0,0) or pCity.canTrain(iSAS,0,0) or pCity.canTrain(iParaFuture,0,0)) and (iCurrentParatroopers < (pPlayer.getNumMilitaryUnits() / 30)):

							if pCity.canTrain(iParaFuture,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iParaFuture, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iSAS,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iSAS, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iPara,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iPara, -1, False, False, False, True)
								return True

			# AMERICAN_TOMAHAWK / GUIDED_MISSILE / ROCKET

						# --------------------------------------------------------------------------------------------------------------
						# 1 von 20 Militreinheiten sollte eine Rakete sein und jeder Raketentrger sollte bestckt sein (dann maximal 1 von 15)
						# --------------------------------------------------------------------------------------------------------------
						elif (pCity.canTrain(iGuidedMissile1,0,0) or pCity.canTrain(iGuidedMissile2,0,0) or pCity.canTrain(iRocket,0,0)) and ((iCurrentMissiles < (iCurrentMissileCarriers * 4)) and (iCurrentMissiles < (pPlayer.getNumMilitaryUnits() / 15))) or ((pPlayer.getNumMilitaryUnits() / 20) > iCurrentMissiles):

							if pCity.canTrain(iGuidedMissile1,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iGuidedMissile1, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iGuidedMissile2,0,0) and pCity.canTrain(iRocket,0,0):
								iWhichOne = CyGame().getSorenRandNum(3, "Random")
								if iWhichOne < 2:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iGuidedMissile2, -1, False, False, False, True)
									return True
								else:
									pCity.pushOrder(OrderTypes.ORDER_TRAIN, iRocket, -1, False, False, False, True)
									return True

							elif pCity.canTrain(iGuidedMissile2,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iGuidedMissile2, -1, False, False, False, True)
								return True

							elif pCity.canTrain(iRocket,0,0):
								pCity.pushOrder(OrderTypes.ORDER_TRAIN, iRocket, -1, False, False, False, True)
								return True
## AI Unit Adjust ## ----------------------------------------------------------------------------------------------------------------------------------------------------------------
## AI Building Adjust ## ----------------------------------------------------------------------------------------------------------------------------------------------------------------

						# Bei mittelmiger Produktion nur im Frieden
						# -------------------------------------------------------
						elif (pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) >= 40 and pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) < 80 and not pTeam.getAtWarCount(True) > 0) or pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) >= 80:
							iColdFusionPlant = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_COLDFUSION_PLANT" )
							iTransformer = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_TRANSFORMER" )
							
							if pCity.canConstruct(iColdFusionPlant,0,0,0):
								pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iColdFusionPlant, -1, False, False, False, True)
								return True

							elif pCity.canConstruct(iTransformer,0,0,0):
								pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iTransformer, -1, False, False, False, True)
								return True

					# Sofortiger Bau bei sehr starker Produktion
					# -------------------------------------------------------
					elif pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) >= 100:
						iColdFusionPlant = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_COLDFUSION_PLANT" )
						iTransformer = CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(), "BUILDING_TRANSFORMER" )
						
						if pCity.canConstruct(iColdFusionPlant,0,0,0):
							pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iColdFusionPlant, -1, False, False, False, True)
							return True

						elif pCity.canConstruct(iTransformer,0,0,0):
							pCity.pushOrder(OrderTypes.ORDER_CONSTRUCT, iTransformer, -1, False, False, False, True)
							return True
## AI Building Adjust ## ----------------------------------------------------------------------------------------------------------------------------------------------------------------
		return False

	def AI_unitUpdate(self,argsList):
		pUnit = argsList[0]
		return False

	def AI_doWar(self,argsList):
		eTeam = argsList[0]
		return False

	def AI_doDiplo(self,argsList):
		ePlayer = argsList[0]
		return False

	def calculateScore(self,argsList):
		ePlayer = argsList[0]
		bFinal = argsList[1]
		bVictory = argsList[2]
		
		iPopulationScore = CvUtil.getScoreComponent(gc.getPlayer(ePlayer).getPopScore(), gc.getGame().getInitPopulation(), gc.getGame().getMaxPopulation(), gc.getDefineINT("SCORE_POPULATION_FACTOR"), True, bFinal, bVictory)
		iLandScore = CvUtil.getScoreComponent(gc.getPlayer(ePlayer).getLandScore(), gc.getGame().getInitLand(), gc.getGame().getMaxLand(), gc.getDefineINT("SCORE_LAND_FACTOR"), True, bFinal, bVictory)
		iTechScore = CvUtil.getScoreComponent(gc.getPlayer(ePlayer).getTechScore(), gc.getGame().getInitTech(), gc.getGame().getMaxTech(), gc.getDefineINT("SCORE_TECH_FACTOR"), True, bFinal, bVictory)
		iWondersScore = CvUtil.getScoreComponent(gc.getPlayer(ePlayer).getWondersScore(), gc.getGame().getInitWonders(), gc.getGame().getMaxWonders(), gc.getDefineINT("SCORE_WONDER_FACTOR"), False, bFinal, bVictory)
		return int(iPopulationScore + iLandScore + iWondersScore + iTechScore)

	def doHolyCity(self):

		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_LIMITED_RELIGIONS):
			return False

		else:
			return True
		

	def doHolyCityTech(self,argsList):
		eTeam = argsList[0]
		ePlayer = argsList[1]
		eTech = argsList[2]
		bFirst = argsList[3]

		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_LIMITED_RELIGIONS):
			
			iPlayer =  argsList[1]

			apCityList = PyPlayer(iPlayer).getCityList()
			for pCity in apCityList:
				iReligionLoop=0				
				for iReligionLoop in range(gc.getNumReligionInfos()):
					if pCity.isHolyCityByType(iReligionLoop):
						return True
					
				if iReligionLoop == 0:
					return False	


	def doGold(self,argsList):
		ePlayer = argsList[0]
		return False

	def doResearch(self,argsList):
		ePlayer = argsList[0]
		return False

	def doGoody(self,argsList):
		ePlayer = argsList[0]
		pPlot = argsList[1]
		pUnit = argsList[2]
		return False

	def doGrowth(self,argsList):
		pCity = argsList[0]
		return False

	def doProduction(self,argsList):
		pCity = argsList[0]
		return False

	def doCulture(self,argsList):
		pCity = argsList[0]
		return False

	def doPlotCulture(self,argsList):
		pCity = argsList[0]
		bUpdate = argsList[1]
		ePlayer = argsList[2]
		iCultureRate = argsList[3]
		return False

	def doReligion(self,argsList):
		pCity = argsList[0]
		return False

	def cannotSpreadReligion(self,argsList):
		iOwner, iUnitID, iReligion, iX, iY = argsList[0]
		return False

	def doGreatPeople(self,argsList):
		pCity = argsList[0]
		return False

	def doMeltdown(self,argsList):
		pCity = argsList[0]
		return False
	
	def doReviveActivePlayer(self,argsList):
		"allows you to perform an action after an AIAutoPlay"
		iPlayer = argsList[0]
		return False
	
	def doPillageGold(self, argsList):
		"controls the gold result of pillaging"
		pPlot = argsList[0]
		pUnit = argsList[1]

		pPlayer = gc.getPlayer(pUnit.getOwner())
		iPillageGold = 0

# Original Code
		iPillageGold = CyGame().getSorenRandNum(gc.getImprovementInfo(pPlot.getImprovementType()).getPillageGold(), "Pillage Gold 1")
# ZE: Ungarn Start (DEAKTIVIERT MIT 6.3 C) -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_HUNGARY")):
			# # +10 Gold
			# # iPillageGold = (10 + CyGame().getSorenRandNum(gc.getImprovementInfo(pPlot.getImprovementType()).getPillageGold(), "Pillage Gold 1"))
			# # +10 und +5 Basis pro ra ab Klassik
			# iBonusGold = (10 + (pPlayer.getCurrentEra() * 5))
			# iPillageGold = (iBonusGold + CyGame().getSorenRandNum(gc.getImprovementInfo(pPlot.getImprovementType()).getPillageGold(), "Pillage Gold 1"))
		# else:
			# iPillageGold = CyGame().getSorenRandNum(gc.getImprovementInfo(pPlot.getImprovementType()).getPillageGold(), "Pillage Gold 1")
# ZE: Ungarn End -----------------------------------------------------------------------------------------------

		iPillageGold += CyGame().getSorenRandNum(gc.getImprovementInfo(pPlot.getImprovementType()).getPillageGold(), "Pillage Gold 2")
		iPillageGold += (pUnit.getPillageChange() * iPillageGold) / 100

# Synergiert so nicht mit den Plnderertrgen der Modernisierungen (wird also nachtrglich hinzugerechnet)
# (alte Version): ZE: Berber Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
#			iTech = gc.getInfoTypeForString("TECH_BERBER")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTech):
#				iPillageGold += 100
# ZE: Berber End -----------------------------------------------------------------------------------------------
		
		return iPillageGold
	
	def doCityCaptureGold(self, argsList):
		"controls the gold result of capturing a city"
		
		pOldCity = argsList[0]
		
		iCaptureGold = 0
		
		iCaptureGold += gc.getDefineINT("BASE_CAPTURE_GOLD")
		iCaptureGold += (pOldCity.getPopulation() * gc.getDefineINT("CAPTURE_GOLD_PER_POPULATION"))
		iCaptureGold += CyGame().getSorenRandNum(gc.getDefineINT("CAPTURE_GOLD_RAND1"), "Capture Gold 1")
		iCaptureGold += CyGame().getSorenRandNum(gc.getDefineINT("CAPTURE_GOLD_RAND2"), "Capture Gold 2")

		if (gc.getDefineINT("CAPTURE_GOLD_MAX_TURNS") > 0):
			iCaptureGold *= cyIntRange((CyGame().getGameTurn() - pOldCity.getGameTurnAcquired()), 0, gc.getDefineINT("CAPTURE_GOLD_MAX_TURNS"))
			iCaptureGold /= gc.getDefineINT("CAPTURE_GOLD_MAX_TURNS")
		
		return iCaptureGold
	
	def citiesDestroyFeatures(self,argsList):
		iX, iY= argsList
		return True
		
	def canFoundCitiesOnWater(self,argsList):
		iX, iY= argsList
		return False
		
	def doCombat(self,argsList):
		pSelectionGroup, pDestPlot = argsList
		return False

	# rucivfan_conscript_extended rce[
	def getConscriptUnitType(self, argsList):
		iPlayer, pCity, bNoDefensiveOnly = argsList
	# ]rucivfan_conscript_extended rce
		iConscriptUnitType = -1 #return this with the value of the UNIT TYPE you want to be conscripted, -1 uses default system
		
		return iConscriptUnitType

	def getCityFoundValue(self, argsList):
		iPlayer, iPlotX, iPlotY = argsList
		iFoundValue = -1 # Any value besides -1 will be used
		
		return iFoundValue
		
	def canPickPlot(self, argsList):
		pPlot = argsList[0]
		return true
		
	def getUnitCostMod(self, argsList):
		iPlayer, iCityID, iUnit = argsList
		iCostMod = -1 # Any value > 0 will be used
		
		return iCostMod

	def getBuildingCostMod(self, argsList):
		iPlayer, iCityID, iBuilding = argsList
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCityID)		
		iCostMod = -1 # Any value > 0 will be used
		
		return iCostMod
		
	def canUpgradeAnywhere(self, argsList):
		pUnit = argsList
		bCanUpgradeAnywhere = 0

		return bCanUpgradeAnywhere
		
	def getWidgetHelp(self, argsList):
		eWidgetType, iData1, iData2, bOption = argsList
## Religion Screen ##
		if eWidgetType == WidgetTypes.WIDGET_HELP_RELIGION:
			if iData1 == -1:
				return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
## Platy Builder ##
		elif eWidgetType == WidgetTypes.WIDGET_PYTHON:
			if iData1 == 1027:
				return CyTranslator().getText("TXT_KEY_WB_PLOT_DATA",())
			elif iData1 == 1028:
				return gc.getGameOptionInfo(iData2).getHelp()
			elif iData1 == 1029:
				if iData2 == 0:
					sText = CyTranslator().getText("TXT_KEY_WB_PYTHON", ())
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onFirstContact"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onChangeWar"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onVassalState"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCityAcquired"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCityBuilt"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCultureExpansion"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onGoldenAge"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onEndGoldenAge"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onGreatPersonBorn"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onPlayerChangeStateReligion"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onReligionFounded"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onReligionSpread"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onReligionRemove"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCorporationFounded"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCorporationSpread"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onCorporationRemove"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onUnitCreated"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onUnitLost"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onUnitPromoted"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onBuildingBuilt"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onProjectBuilt"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onTechAcquired"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onImprovementBuilt"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onImprovementDestroyed"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onRouteBuilt"
					sText += "\n" + CyTranslator().getText("[ICON_BULLET]", ()) + "onPlotRevealed"
					return sText
				elif iData2 == 1:
					return CyTranslator().getText("TXT_KEY_WB_PLAYER_DATA",())
				elif iData2 == 2:
					return CyTranslator().getText("TXT_KEY_WB_TEAM_DATA",())
				elif iData2 == 3:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_TECH",())
				elif iData2 == 4:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_PROJECT",())
				elif iData2 == 5:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_UNIT", ()) + " + " + CyTranslator().getText("TXT_KEY_CONCEPT_CITIES", ())
				elif iData2 == 6:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_PROMOTION",())
				elif iData2 == 7:
					return CyTranslator().getText("TXT_KEY_WB_CITY_DATA2",())
				elif iData2 == 8:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_BUILDING",())
				elif iData2 == 9:
					return "Platy Builder\nVersion: 4.13b"
				elif iData2 == 10:
					return CyTranslator().getText("TXT_KEY_CONCEPT_EVENTS",())
				elif iData2 == 11:
					return CyTranslator().getText("TXT_KEY_WB_RIVER_PLACEMENT",())
				elif iData2 == 12:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_IMPROVEMENT",())
				elif iData2 == 13:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_BONUS",())
				elif iData2 == 14:
					return CyTranslator().getText("TXT_KEY_WB_PLOT_TYPE",())
				elif iData2 == 15:
					return CyTranslator().getText("TXT_KEY_CONCEPT_TERRAIN",())
				elif iData2 == 16:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_ROUTE",())
				elif iData2 == 17:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_FEATURE",())
				elif iData2 == 18:
					return CyTranslator().getText("TXT_KEY_MISSION_BUILD_CITY",())
				elif iData2 == 19:
					return CyTranslator().getText("TXT_KEY_WB_ADD_BUILDINGS",())
				elif iData2 == 20:
					return CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_RELIGION",())
				elif iData2 == 21:
					return CyTranslator().getText("TXT_KEY_CONCEPT_CORPORATIONS",())
				elif iData2 == 22:
					return CyTranslator().getText("TXT_KEY_ESPIONAGE_CULTURE",())
				elif iData2 == 23:
					return CyTranslator().getText("TXT_KEY_PITBOSS_GAME_OPTIONS",())
				elif iData2 == 24:
					return CyTranslator().getText("TXT_KEY_WB_SENSIBILITY",())
				elif iData2 == 27:
					return CyTranslator().getText("TXT_KEY_WB_ADD_UNITS",())
				elif iData2 == 28:
					return CyTranslator().getText("TXT_KEY_WB_TERRITORY",())
				elif iData2 == 29:
					return CyTranslator().getText("TXT_KEY_WB_ERASE_ALL_PLOTS",())
				elif iData2 == 30:
					return CyTranslator().getText("TXT_KEY_WB_REPEATABLE",())
				elif iData2 == 31:
					return CyTranslator().getText("TXT_KEY_PEDIA_HIDE_INACTIVE", ())
				elif iData2 == 32:
					return CyTranslator().getText("TXT_KEY_WB_STARTING_PLOT", ())
				elif iData2 == 33:
					return CyTranslator().getText("TXT_KEY_INFO_SCREEN", ())
				elif iData2 == 34:
					return CyTranslator().getText("TXT_KEY_CONCEPT_TRADE", ())
			elif iData1 > 1029 and iData1 < 1040:
				if iData1 %2:
					return "-"
				return "+"
			elif iData1 == 1041:
				return CyTranslator().getText("TXT_KEY_WB_KILL",())
			elif iData1 == 1042:
				return CyTranslator().getText("TXT_KEY_MISSION_SKIP",())
			elif iData1 == 1043:
				if iData2 == 0:
					return CyTranslator().getText("TXT_KEY_WB_DONE",())
				elif iData2 == 1:
					return CyTranslator().getText("TXT_KEY_WB_FORTIFY",())
				elif iData2 == 2:
					return CyTranslator().getText("TXT_KEY_WB_WAIT",())
			elif iData1 == 6782:
				return CyGameTextMgr().parseCorporationInfo(iData2, False)
			elif iData1 == 6785:
				return CyGameTextMgr().getProjectHelp(iData2, False, CyCity())
			elif iData1 == 6787:
				return gc.getProcessInfo(iData2).getDescription()
			elif iData1 == 6788:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
				return gc.getRouteInfo(iData2).getDescription()
## City Hover Text ##
			elif iData1 > 7199 and iData1 < 7300:
				iPlayer = iData1 - 7200
				pPlayer = gc.getPlayer(iPlayer)
				pCity = pPlayer.getCity(iData2)
				if CyGame().GetWorldBuilderMode():
					sText = "<font=3>"
					if pCity.isCapital():
						sText += CyTranslator().getText("[ICON_STAR]", ())
					elif pCity.isGovernmentCenter():
						sText += CyTranslator().getText("[ICON_SILVER_STAR]", ())
					sText += u"%s: %d<font=2>" %(pCity.getName(), pCity.getPopulation())
					sTemp = ""
					if pCity.isConnectedToCapital(iPlayer):
						sTemp += CyTranslator().getText("[ICON_TRADE]", ())
					for i in xrange(gc.getNumReligionInfos()):
						if pCity.isHolyCityByType(i):
							sTemp += u"%c" %(gc.getReligionInfo(i).getHolyCityChar())
						elif pCity.isHasReligion(i):
							sTemp += u"%c" %(gc.getReligionInfo(i).getChar())

					for i in xrange(gc.getNumCorporationInfos()):
						if pCity.isHeadquartersByType(i):
							sTemp += u"%c" %(gc.getCorporationInfo(i).getHeadquarterChar())
						elif pCity.isHasCorporation(i):
							sTemp += u"%c" %(gc.getCorporationInfo(i).getChar())
					if len(sTemp) > 0:
						sText += "\n" + sTemp

					iMaxDefense = pCity.getTotalDefense(False)
					if iMaxDefense > 0:
						sText += u"\n%s: " %(CyTranslator().getText("[ICON_DEFENSE]", ()))
						iCurrent = pCity.getDefenseModifier(False)
						if iCurrent != iMaxDefense:
							sText += u"%d/" %(iCurrent)
						sText += u"%d%%" %(iMaxDefense)

					sText += u"\n%s: %d/%d" %(CyTranslator().getText("[ICON_FOOD]", ()), pCity.getFood(), pCity.growthThreshold())
					iFoodGrowth = pCity.foodDifference(True)
					if iFoodGrowth != 0:
						sText += u" %+d" %(iFoodGrowth)

					if pCity.isProduction():
						sText += u"\n%s:" %(CyTranslator().getText("[ICON_PRODUCTION]", ()))
						if not pCity.isProductionProcess():
							sText += u" %d/%d" %(pCity.getProduction(), pCity.getProductionNeeded())
							iProduction = pCity.getCurrentProductionDifference(False, True)
							if iProduction != 0:
								sText += u" %+d" %(iProduction)
						sText += u" (%s)" %(pCity.getProductionName())

					iGPRate = pCity.getGreatPeopleRate()
					iProgress = pCity.getGreatPeopleProgress()
					if iGPRate > 0 or iProgress > 0:
						sText += u"\n%s: %d/%d %+d" %(CyTranslator().getText("[ICON_GREATPEOPLE]", ()), iProgress, pPlayer.greatPeopleThreshold(False), iGPRate)

					sText += u"\n%s: %d/%d (%s)" %(CyTranslator().getText("[ICON_CULTURE]", ()), pCity.getCulture(iPlayer), pCity.getCultureThreshold(), gc.getCultureLevelInfo(pCity.getCultureLevel()).getDescription())

					lTemp = []
					for i in xrange(CommerceTypes.NUM_COMMERCE_TYPES):
						iAmount = pCity.getCommerceRateTimes100(i)
						if iAmount <= 0: continue
						sTemp = u"%d.%02d%c" %(pCity.getCommerceRate(i), pCity.getCommerceRateTimes100(i)%100, gc.getCommerceInfo(i).getChar())
						lTemp.append(sTemp)
					if len(lTemp) > 0:
						sText += "\n"
						for i in xrange(len(lTemp)):
							sText += lTemp[i]
							if i < len(lTemp) - 1:
								sText += ", "

					iMaintenance = pCity.getMaintenanceTimes100()
					if iMaintenance != 0:
						sText += "\n" + CyTranslator().getText("[COLOR_WARNING_TEXT]", ()) + CyTranslator().getText("INTERFACE_CITY_MAINTENANCE", ()) + " </color>"
						sText += u"-%d.%02d%c" %(iMaintenance/100, iMaintenance%100, gc.getCommerceInfo(CommerceTypes.COMMERCE_GOLD).getChar())

					lBuildings = []
					lWonders = []
					for i in xrange(gc.getNumBuildingInfos()):
						if pCity.isHasBuilding(i):
							Info = gc.getBuildingInfo(i)
							if isLimitedWonderClass(Info.getBuildingClassType()):
								lWonders.append(Info.getDescription())
							else:
								lBuildings.append(Info.getDescription())
					if len(lBuildings) > 0:
						lBuildings.sort()
						sText += "\n" + CyTranslator().getText("[COLOR_BUILDING_TEXT]", ()) + CyTranslator().getText("TXT_KEY_PEDIA_CATEGORY_BUILDING", ()) + ": </color>"
						for i in xrange(len(lBuildings)):
							sText += lBuildings[i]
							if i < len(lBuildings) - 1:
								sText += ", "
					if len(lWonders) > 0:
						lWonders.sort()
						sText += "\n" + CyTranslator().getText("[COLOR_SELECTED_TEXT]", ()) + CyTranslator().getText("TXT_KEY_CONCEPT_WONDERS", ()) + ": </color>"
						for i in xrange(len(lWonders)):
							sText += lWonders[i]
							if i < len(lWonders) - 1:
								sText += ", "
					sText += "</font>"
					return sText
## Religion Widget Text##
			elif iData1 == 7869:
				return CyGameTextMgr().parseReligionInfo(iData2, False)
## Building Widget Text##
			elif iData1 == 7870:
				return CyGameTextMgr().getBuildingHelp(iData2, False, False, False, None)
## Tech Widget Text##
			elif iData1 == 7871:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
				return CyGameTextMgr().getTechHelp(iData2, False, False, False, False, -1)
## Civilization Widget Text##
			elif iData1 == 7872:
				iCiv = iData2 % 10000
				return CyGameTextMgr().parseCivInfos(iCiv, False)
## Promotion Widget Text##
			elif iData1 == 7873:
				return CyGameTextMgr().getPromotionHelp(iData2, False)
## Feature Widget Text##
			elif iData1 == 7874:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
				iFeature = iData2 % 10000
				return CyGameTextMgr().getFeatureHelp(iFeature, False)
## Terrain Widget Text##
			elif iData1 == 7875:
				return CyGameTextMgr().getTerrainHelp(iData2, False)
## Leader Widget Text##
			elif iData1 == 7876:
				iLeader = iData2 % 10000
				return CyGameTextMgr().parseLeaderTraits(iLeader, -1, False, False)
## Improvement Widget Text##
			elif iData1 == 7877:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
				return CyGameTextMgr().getImprovementHelp(iData2, False)
## Bonus Widget Text##
			elif iData1 == 7878:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_CULTURELEVEL_NONE", ())
				return CyGameTextMgr().getBonusHelp(iData2, False)
## Specialist Widget Text##
			elif iData1 == 7879:
				return CyGameTextMgr().getSpecialistHelp(iData2, False)
## Yield Text##
			elif iData1 == 7880:
				return gc.getYieldInfo(iData2).getDescription()
## Commerce Text##
			elif iData1 == 7881:
				return gc.getCommerceInfo(iData2).getDescription()
## Corporation Screen ##
			elif iData1 == 8201:
				return CyGameTextMgr().parseCorporationInfo(iData2, False)
## Military Screen ##
			elif iData1 == 8202:
				if iData2 == -1:
					return CyTranslator().getText("TXT_KEY_PEDIA_ALL_UNITS", ())
				return CyGameTextMgr().getUnitHelp(iData2, False, False, False, None)
			elif iData1 > 8299 and iData1 < 8400:
				iPlayer = iData1 - 8300
				pUnit = gc.getPlayer(iPlayer).getUnit(iData2)
				sText = CyGameTextMgr().getSpecificUnitHelp(pUnit, True, False)
				if CyGame().GetWorldBuilderMode():
					sText += "\n" + CyTranslator().getText("TXT_KEY_WB_UNIT", ()) + " ID: " + str(iData2)
					sText += "\n" + CyTranslator().getText("TXT_KEY_WB_GROUP", ()) + " ID: " + str(pUnit.getGroupID())
					sText += "\n" + "X: " + str(pUnit.getX()) + ", Y: " + str(pUnit.getY())
					sText += "\n" + CyTranslator().getText("TXT_KEY_WB_AREA_ID", ()) + ": "  + str(pUnit.plot().getArea())
				return sText
## Civics Screen ##
			elif iData1 == 8205 or iData1 == 8206:
				sText = CyGameTextMgr().parseCivicInfo(iData2, False, True, False)
				if gc.getCivicInfo(iData2).getUpkeep() > -1:
					sText += "\n" + gc.getUpkeepInfo(gc.getCivicInfo(iData2).getUpkeep()).getDescription()
				else:
					sText += "\n" + CyTranslator().getText("TXT_KEY_CIVICS_SCREEN_NO_UPKEEP", ())
				return sText
## Ultrapack ##
###### Cybah: BASE - Unit Buttons START ----------------------------------------------------------------------------------------------------------------------------

		# Groer Staatsmann

		# DEAKTIVIERT (eigentlich 9000)
		if iData1 == 9999:
			iPlayer = iData2
			pPlayer = gc.getPlayer(iPlayer)
			iBaseGold = (1000 * (pPlayer.getCurrentEra() +1))
			estiEnd = CyGame().getEstimateEndTurn()
			if estiEnd >= 1000:
				iBaseGold *= 2
				iAnarchy = 10
			elif estiEnd >= 700:
				iBaseGold *= 7
				iBaseGold /= 5
				iAnarchy = 7
			elif estiEnd >= 500:
				iBaseGold *= 1
				iAnarchy = 5
			elif estiEnd >= 300:
				iBaseGold *= 3
				iBaseGold /= 5
				iAnarchy = 3
			return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_ASSASSINATION",(iAnarchy, iBaseGold,))

		# Aufstndische untersttzen ist deaktiviert
		# if iData1 == 9000:
			# return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_INSURGENCE",())
			
		if iData1 == 9001:
			iPlayer = iData2
			pUnitOwner = gc.getPlayer(iPlayer)
			iUnitOwnerTeam = pUnitOwner.getTeam()
			pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
					
			iAidTechResearch = 0
			l_AidTechs = []
			for iTechX in xrange(gc.getNumTechInfos()):
				bTechXKnownTeam = False
				iTechXCount = 0
				if pUnitOwnerTeam.isHasTech(iTechX) or not gc.getTechInfo(iTechX).isTrade(): continue
				for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
					pTeamX = gc.getTeam(iTeamX)
					if pTeamX.isAlive():
						if pTeamX.isHasTech(iTechX):
							iTechXCount += 1
							if pUnitOwnerTeam.isHasMet(iTeamX):
								bTechXKnownTeam = True
				# Hlfte aller Spieler muss die Tech haben
				if bTechXKnownTeam == True and iTechXCount >= ((gc.getGame().countCivTeamsAlive() + 1) / 2):
					# Tech zur Liste der mglichen Techs hinzufgen
					l_AidTechs.append(iTechX)

			if len(l_AidTechs) > 3:
				for iTech in xrange(len(l_AidTechs)):
					# 33% der verbleibenden Kolben
					iTechKolben = (pUnitOwnerTeam.getResearchLeft(l_AidTechs[iTech]) / 3)
					# Kolben fr Anzeige aufsummieren
					iAidTechResearch += iTechKolben
						
			# return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_DEVELOPMENT",())
			return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_DEVELOPMENT",(len(l_AidTechs), iAidTechResearch))
			
		if iData1 == 9002:
			return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_PEACE",())
			
		# MOBILISIEREN IST DEAKTIVIERT
		# if iData1 == 9003:
			# return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_MOBILIZE",())
			
		if iData1 == 9004:
			iPlayer = iData2
			pUnitOwner = gc.getPlayer(iPlayer)
			iUnitOwnerTeam = pUnitOwner.getTeam()
			pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
			iTheSpeed = CyGame().getGameSpeedType()
			TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
			iTrainPercent = TheSpeed.getTrainPercent()
			# Marathonmodifikator +50 weil Einheiten nur 200, Gebude 300
			if iTrainPercent == 200: iTrainPercent += 50
			fRedeProd = (1.5 * ((pUnitOwner.getCurrentEra() + 1) * iTrainPercent / 100))
			
			#Militreinheiten zhlen
			iMilitaryUnits = 0
			(loopUnit, iter) = pUnitOwner.firstUnit(False)
			while(loopUnit):
				if loopUnit.getUnitCombatType() > -1 and (loopUnit.airBaseCombatStr() > 0 or loopUnit.baseCombatStr() > 0):
					if loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_ALIEN' ) and loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_MISC' ):
						iMilitaryUnits += 1
				(loopUnit, iter) = pUnitOwner.nextUnit(iter, False)
			
			iGARounds = (pUnitOwner.getGoldenAgeLength() * 2)
			# return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_SPEECH",())
			return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_SPEECH",(iMilitaryUnits, u"%.1f" % fRedeProd, iGARounds))
			
		if iData1 == 9005:
			iPlayer = iData2
			pUnitOwner = gc.getPlayer(iPlayer)
			iUnitOwnerTeam = pUnitOwner.getTeam()
			pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
			pBestXPCity = pUnitOwner.getCapitalCity()
			iBestXP = 0
			pMaybeBestXPCity, iter = pUnitOwner.firstCity(false)
			while(pMaybeBestXPCity):
				iCityOwner = pMaybeBestXPCity.getOwner() 
				if not pMaybeBestXPCity.isNone() and iCityOwner == pUnitOwner.getID():
					iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
# ZE: Zulu 2/2 Start -----------------------------------------------------------------------------------------------
					# if pUnitOwner.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and gc.getTeam(pUnitOwner.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pUnitOwner.getID() == pMaybeBestXPCity.getOriginalOwner():
						# iXP += 5
# ZE: Zulu 2/2 End -----------------------------------------------------------------------------------------------
					if iBestXP < iXP: 
						iBestXP = iXP
						pBestXPCity = pMaybeBestXPCity
				pMaybeBestXPCity, iter = pUnitOwner.nextCity(iter, false)

			if pBestXPCity != -1 and pUnitOwner.getNumCities() > 1:

				# rucivfan_conscript_extended rce[
				#iConscriptUnit = pBestXPCity.getConscriptUnit()
				iConscriptUnit = pBestXPCity.getConscriptUnit(true) # true fr keine reinen Verteidigungseinheiten
				# ]rucivfan_conscript_extended rce
				
				iTheSpeed = CyGame().getGameSpeedType()
				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
				pHandicapInfo = gc.getHandicapInfo(gc.getGame().getHandicapType())
				# rucivfan_ai_auto_play raap[
				#if pUnitOwner.isHuman(): iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)
				if pUnitOwner.isHumanActive(): iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)
				# ]rucivfan_ai_auto_play raap
				else: iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent() * pHandicapInfo.getAIUnitCostPercent()) / 10000)

				# - Spieloption erhhte Einheitenproduktionskosten -
				if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
					if gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()) > 0:
						iEra = gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()).getEra()
					else:	
						iEra = 0
					for k in range(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")):
						iPrereqX = gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)
						if iPrereqX >= 0:
							iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)).getEra())
					if iEra > 5:
						iEra = 5
					iConscriptUnitCost *= 100 + iEra * 10
					iConscriptUnitCost /= 100

				# "NEW_HURRY_MODIFIER"
				# iConscriptUnitCost *= 3
				# iConscriptUnitCost /= 2

				# Gold per Production
				iConscriptUnitCost *= 3

				# Gold fr XP - 2% pro 1 XP
				# iConscriptUnitCostTotal = (iConscriptUnitCost * (100 + (iBestXP * 2)))
				# iConscriptUnitCostTotal /= 100
				iConscriptUnitCostTotal = iConscriptUnitCost

				# Nachtrgliche BASE Modifikatoren
				# - Im Frieden 25% Rabatt -
				if not pUnitOwnerTeam.getAtWarCount(True) > 0:
					iConscriptUnitCostTotal *= 3
					iConscriptUnitCostTotal /= 4

				# - Endmodifikator zum schnellen Anpassen: 33% billiger -
				# iConscriptUnitCostTotal *= 2
				# iConscriptUnitCostTotal /= 3

				# 6.3 B - auf 10 beschrnkt
				iMercs = min(10,(pUnitOwner.getGold() / iConscriptUnitCostTotal))

				if iMercs > 0:
					return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_MERCENARIES",(gc.getUnitInfo(iConscriptUnit).getDescription(), iMercs, (iConscriptUnitCostTotal * iMercs), iBestXP))

		if iData1 == 9006:
			iPlayer = iData2
			pPlayer = gc.getPlayer(iPlayer)

			# 250 ab Klassik
			iBaseGold = 250
			# Mittelalter
			if pPlayer.getCurrentEra() > 1: iBaseGold += 250
			# Renaissance
			if pPlayer.getCurrentEra() > 2: iBaseGold += 500
			# Industriezeitalter
			if pPlayer.getCurrentEra() > 3: iBaseGold += 1000
			# Moderne
			if pPlayer.getCurrentEra() > 4: iBaseGold += 2000
			# Zukunft
			if pPlayer.getCurrentEra() > 5: iBaseGold += 4000
			
			estiEnd = CyGame().getEstimateEndTurn()
			if estiEnd >= 1000:
				iBaseGold *= 2
			elif estiEnd >= 700:
				iBaseGold *= 7
				iBaseGold /= 5
			elif estiEnd >= 500:
				iBaseGold *= 1
			elif estiEnd >= 300:
				iBaseGold *= 3
				iBaseGold /= 5
			iMaxGold = 4 * iBaseGold
			return CyTranslator().getText("TXT_KEY_STATESMAN_ACTION_WORLDTRADE",(iBaseGold, iMaxGold))

# Cybah: BASE fr 6.2 D - Philosophisch START				
		# < ---- GP: Opferung ---->
		if iData1 == 9007:
			# Cybah: BASE fr 6.3 B - abwechselnd Gold und Prod beim Propheten
			iPlayer = iData2
			pPlayer = gc.getPlayer(iPlayer)
			if (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iProphet')) % 2 == 0):
				return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_PROPHET_GOLD",(1, 1))
			else:
				return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_PROPHET_PROD",(1, 1))
				
		if iData1 == 9008:
			return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_ENGINEER",(1, 1))
			
		if iData1 == 9009:
			# Cybah: BASE fr 6.3 B - abwechselnd Gold und Kultur beim Knstler
			iPlayer = iData2
			pPlayer = gc.getPlayer(iPlayer)
			if (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iArtist')) % 2 == 0):
				return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_ARTIST_GOLD",(1, 1))
			else:
				return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_ARTIST_CULTURE",(1, 1))
				
		if iData1 == 9010:
			return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_MERCHANT",(1, 1))
				
		if iData1 == 9011:
			return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_SCIENTIST",(1, 1))
				
		if iData1 == 9012:
			# Cybah: BASE fr 6.3 B - von 1 auf 2 erhht
			return CyTranslator().getText("TXT_KEY_GP_ACTION_SACRIFICE_GREAT_SPY",(2, 2))
# Cybah: BASE fr 6.2 D - Philosophisch END
###### Cybah: BASE - Unit Buttons END ----------------------------------------------------------------------------------------------------------------------------

		return u""

		
#############################################################################		
# rucivfan: Wurde per CallBack USE_ON_UNIT_UPGRADE_PRICE_CALLBACK deaktiviert		
	def getUpgradePriceOverride(self, argsList):
		iPlayer, iUnitID, iUnitTypeUpgrade = argsList
		return 0
#############################################################################

	
	def getExperienceNeeded(self, argsList):
		# use this function to set how much experience a unit needs
		iLevel, iOwner = argsList
		
		iExperienceNeeded = 0

		# regular epic game experience		
		iExperienceNeeded = iLevel * iLevel + 1

		iModifier = gc.getPlayer(iOwner).getLevelExperienceModifier()
		
# ZE: Heilig-Rom Start -----------------------------------------------------------------------------------------------
		if gc.getPlayer(iOwner).getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
			iTechZEHOLY = gc.getInfoTypeForString("TECH_HOLY_ROMAN")
			if gc.getTeam(gc.getPlayer(iOwner).getTeam()).isHasTech(iTechZEHOLY):
				iModifier -= 10
# ZE: Heilig-Rom End -----------------------------------------------------------------------------------------------
		
		if (0 != iModifier):
			iExperienceNeeded += (iExperienceNeeded * iModifier + 99) / 100   # ROUND UP
			
		return iExperienceNeeded
		