## TraitUtil
##
## Utilities for dealing with Traits and TraitInfos.
##
## Notes
##   - Must be initialized externally by calling init()
##
## Copyright (c) 2008 The BUG Mod.
##
## Author: EmperorFool

from CvPythonExtensions import *

GENERIC_ICON = "*"
TRAIT_ICONS = {}

GENERIC_BUTTON = "Art/Interface/Buttons/TechTree/"
TRAIT_BUTTONS = {}

gc = CyGlobalContext()

def init():
	"Performs one-time initialization after the game starts up."
	game = gc.getGame()
	global GENERIC_ICON
	GENERIC_ICON = u"%c" % game.getSymbolID(FontSymbols.MAP_CHAR)
	
	# addTrait("ADAPTIVE", game.getSymbolID(FontSymbols.MAP_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	addTrait("AGGRESSIVE", game.getSymbolID(FontSymbols.STRENGTH_CHAR), "Art/Interface/Buttons/Promotions/Combat1.dds")
	addTrait("CHARISMATIC", game.getSymbolID(FontSymbols.HAPPY_CHAR), "Art/Interface/Buttons/TechTree/MassMedia.dds")
	addTrait("DIPLOMATIC", game.getSymbolID(FontSymbols.TRADE_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	# addTrait("DIPLOMATIC", game.getSymbolID(FontSymbols.DEFENSIVE_PACT_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	#addTrait("DIPLOMATIC", game.getSymbolID(FontSymbols.MAP_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	addTrait("EXPANSIVE", game.getSymbolID(FontSymbols.MAP_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	# addTrait("EXPANSIVE", game.getSymbolID(FontSymbols.HEALTHY_CHAR), "Art/Interface/Buttons/Actions/Heal.dds")
	##addTrait("EXPANSIVE", gc.getYieldInfo(YieldTypes.YIELD_FOOD).getChar(), "Art/Interface/Buttons/Actions/Heal.dds")
	addTrait("FINANCIAL", gc.getCommerceInfo(CommerceTypes.COMMERCE_GOLD).getChar(), "Art/Interface/Buttons/TechTree/Banking.dds")
	##addTrait("FINANCIAL", gc.getYieldInfo(YieldTypes.YIELD_COMMERCE).getChar(), "Art/Interface/Buttons/TechTree/Banking.dds")
	addTrait("IMPERIALIST", (CyGame().getSymbolID(FontSymbols.GREAT_GENERAL_CHAR)), "Art/Interface/Buttons/Actions/FoundCity.dds")
	addTrait("INDUSTRIOUS", gc.getYieldInfo(YieldTypes.YIELD_PRODUCTION).getChar(), "Art/Interface/Buttons/TechTree/Industrialism.dds")	
	addTrait("CREATIVE", game.getSymbolID(FontSymbols.POWER_CHAR), "Art/Interface/Buttons/TechTree/Music.dds")
	addTrait("ARTISTIC", gc.getCommerceInfo(CommerceTypes.COMMERCE_CULTURE).getChar(), "Art/Interface/Buttons/TechTree/Music.dds")
	addTrait("CUNNING", gc.getCommerceInfo(CommerceTypes.COMMERCE_ESPIONAGE).getChar(), "Art/Interface/Buttons/TechTree/Banking.dds")
	addTrait("MILITANT", game.getSymbolID(FontSymbols.SILVER_STAR_CHAR), "Art/Interface/Buttons/Promotions/Combat1.dds")
	addTrait("ORGANIZED", game.getSymbolID(FontSymbols.HEALTHY_CHAR), "Art/Interface/Buttons/Buildings/Courthouse.dds")
	# addTrait("ORGANIZED", game.getSymbolID(FontSymbols.TRADE_CHAR), "Art/Interface/Buttons/Buildings/Courthouse.dds")
	##addTrait("ORGANIZED", gc.getCommerceInfo(CommerceTypes.COMMERCE_GOLD).getChar(), "Art/Interface/Buttons/Buildings/Courthouse.dds")
	addTrait("PHILOSOPHICAL", game.getSymbolID(FontSymbols.GREAT_PEOPLE_CHAR), "Art/Interface/Buttons/TechTree/Philosophy.dds")
	addTrait("POPULIST", game.getSymbolID(FontSymbols.ANGRY_POP_CHAR), "Art/Interface/Buttons/TechTree/Philosophy.dds")
	addTrait("REPRESSIVE", game.getSymbolID(FontSymbols.OCCUPATION_CHAR), "Art/Interface/Buttons/TechTree/Banking.dds")
	addTrait("PROTECTIVE", game.getSymbolID(FontSymbols.DEFENSE_CHAR), "Art/Interface/Buttons/TechTree/Philosophy.dds")
	addTrait("SPIRITUAL", game.getSymbolID(FontSymbols.RELIGION_CHAR), "Art/Interface/Buttons/TechTree/Meditation.dds")
	addTrait("SCIENTIFIC", gc.getCommerceInfo(CommerceTypes.COMMERCE_RESEARCH).getChar(), "Art/Interface/Buttons/TechTree/Meditation.dds")

def addTrait(trait, icon, button):
	eTrait = gc.getInfoTypeForString("TRAIT_" + trait)
	if eTrait != -1:
		if icon is not None:
			TRAIT_ICONS[eTrait] = u"%c" % icon
		if button is not None:
			TRAIT_BUTTONS[eTrait] = button


def getIcon(eTrait):
	if eTrait in TRAIT_ICONS:
		return TRAIT_ICONS[eTrait]
	else:
		return GENERIC_ICON

def getButton(eTrait):
	if eTrait in TRAIT_BUTTONS:
		return TRAIT_BUTTONS[eTrait]
	else:
		return GENERIC_BUTTON
