#
# MAD Nukes Manager Mod
# By: The Lopez
# CvMADNukesManager
# 

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import time
import PyHelpers
import Popup as PyPopup
import math

PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

OUTGOING_WARHEADS = "OutgoingWarheads"
INCOMING_WARHEADS = "IncomingWarheads"

OUTGOING_WARHEADS_PANEL = "OutgoingWarheadsPanel"
OUTGOING_WARHEADS_INNER_PANEL = "OutgoingWarheadsInnerPanel"
OUTGOING_LABEL_PANEL = "OutgoingLabelPanel"
OUTGOING_SUMMARY_PANEL = "OutgoingSummaryPanel"

OUTGOING_SUMMARY_INNER_PANEL = "OutgoingSummaryInnerPanel"
OUTGOING_SUMMARY_LABEL_PANEL = "OutgoingSummaryLabelPanel"

INCOMING_WARHEADS_PANEL = "IncomingWarheadsPanel"
INCOMING_WARHEADS_INNER_PANEL = "IncomingWarheadsInnerPanel"
INCOMING_LABEL_PANEL = "IncomingLabelPanel"
INCOMING_SUMMARY_PANEL = "IncomingSummaryPanel"

INCOMING_SUMMARY_INNER_PANEL = "IncomingSummaryInnerPanel"
INCOMING_SUMMARY_LABEL_PANEL = "IncomingSummaryLabelPanel"
			
g_bDebug = false

class CvMADNukesManager:
	"MAD Nukes Manager"
	
	iNetMessage_launch = 0
	
	def __init__(self, screenId):
		self.screenId = screenId
		
		self.currentScreen = OUTGOING_WARHEADS
		
		self.MAD_NUKES_MANAGER_SCREEN_NAME = "MADNukesManager"
		self.BACKGROUND_ID = "MADNukesManagerBackground"
		
		self.OUTGOING_ID = "MADNukesManagerOutgoingWidget"
		self.OUTGOING_SUMMARY_LABEL_ID = "MADNukesManagerOutgoingSummaryLabelWidget"
		self.OUTGOING_LABEL_ID = "MADNukesManagerOutgoingLabelWidget"

		self.INCOMING_ID = "MADNukesManagerIncomingWidget"
		self.INCOMING_SUMMARY_LABEL_ID = "MADNukesManagerOutgoingSummaryLabelWidget"
		self.INCOMING_LABEL_ID = "MADNukesManagerOutgoingLabelWidget"
		
		self.LAUNCH_ID = "MADNukesManagerLaunchWidget"
		self.LAUNCH_SUMMARY_LABEL_ID = "MADNukesManagerLaunchSummaryLabelWidget"
		self.LAUNCH_LABEL_ID = "MADNukesManagerLaunchLabelWidget"

		self.EXIT_ID = "MADNukesManagerExitWidget"

		self.WIDGET_ID = "MADNukesManagerWidget"

		self.Z_BACKGROUND = -2.1
		self.Z_CONTROLS = self.Z_BACKGROUND - 0.2

		self.X_SCREEN = 500
		self.Y_SCREEN = 396
		self.W_SCREEN = 1024
		self.H_SCREEN = 768
		self.Y_TITLE = 8
		self.BORDER_WIDTH = 4
		self.W_HELP_AREA = 200
		
		self.X_OUTGOING = 30
		self.Y_OUTGOING = 726

		self.X_INCOMING = 325
		self.Y_INCOMING = 726
		
		self.X_LAUNCH = 620
		self.Y_LAUNCH = 726

		self.X_EXIT = 994
		self.Y_EXIT = 726
								
		self.nWidgetCount = 0
		self.selectedUnitHash = {}
		self.selectedCityHash = {}
		
		self.X_MAP = 420
		self.Y_MAP = 60
		self.W_MAP = 580
		self.H_MAP_MAX = 500
		self.MAP_MARGIN = 20
		
		self.X_TEXT = 625
		self.Y_TEXT = 190
		self.W_TEXT = 380
		self.H_TEXT = 500
						
		self.iShiftKeyDown = 0
					
	def getScreen(self):
		return CyGInterfaceScreen(self.MAD_NUKES_MANAGER_SCREEN_NAME, self.screenId) 


	def hideScreen(self):
		screen = self.getScreen()
		screen.hideScreen()
		self.bFirst = true

		
	# Screen construction function
	def interfaceScreen(self, iLaunchMessageID):
		
		# Create a new screen
		screen = self.getScreen()
		
		#MAD_TODO: There HAS to be a better way to pass this variable than this...
		self.iNetMessage_launch = iLaunchMessageID
		
		if screen.isActive():
			return
			
		if(g_bDebug):
			self.showDebugScreen()
			return
				
		self.nWidgetCount = 0

		screen.setDimensions(screen.centerX(0), screen.centerY(0), self.W_SCREEN, self.H_SCREEN)
		screen.addDDSGFC(self.BACKGROUND_ID, ArtFileMgr.getInterfaceArtInfo("MAD_NUKES_MANAGER_BACKGROUND").getPath(), 0, 0, self.W_SCREEN, self.H_SCREEN, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		self.initMinimap(screen)
			
		# Draw the top bar
		self.drawScreenTop(screen)

		# Draw the bottom bar
		self.drawScreenBottom(screen)
		
		self.drawOutgoingWarheadsContent(screen)
			
		screen.setRenderInterfaceOnly(True);
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)
		screen.showWindowBackground(False)

		self.currentScreen = OUTGOING_WARHEADS


	# Draws the top bar of the "Nuclear Warhead Manager" screens
	def drawScreenTop(self, screen):
		screen.addPanel( "TechTopPanel", u"", u"", True, False, 0, 0, self.W_SCREEN, 55, PanelStyles.PANEL_STYLE_TOPBAR )
												
		# Header...
		self.szHeader = self.getNextWidgetName()
		screen.setText(self.szHeader, "Background", u"<font=4b>" + localText.getText("TXT_KEY_WARHEAD_MANAGER", ()) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, self.X_SCREEN, self.Y_TITLE, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setHitTest(self.szHeader,HitTestTypes.HITTEST_NOHIT)
		
		
	# Draws the bottom bar of the "Nuclear Warhead Manager" screens
	def drawScreenBottom(self, screen):
	
		self.EXIT_TEXT = u"<font=4>" + localText.getText("TXT_KEY_PEDIA_SCREEN_EXIT", ()).upper() + "</font>"
	
		screen.addPanel( "TechBottomPanel", u"", u"", True, False, 0, 713, self.W_SCREEN, 55, PanelStyles.PANEL_STYLE_BOTTOMBAR )
		screen.setText(self.OUTGOING_ID, "Background", u"<font=4>" + localText.getText("TXT_KEY_OUTGOING_WARHEADS", ()) + u"</font>", CvUtil.FONT_LEFT_JUSTIFY, self.X_OUTGOING, self.Y_OUTGOING, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setText(self.INCOMING_ID, "Background", u"<font=4>" + localText.getText("TXT_KEY_INCOMING_WARHEADS", ()) + u"</font>", CvUtil.FONT_LEFT_JUSTIFY, self.X_INCOMING, self.Y_INCOMING, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setText(self.LAUNCH_ID, "Background", u"<font=4>" + localText.getText("TXT_KEY_LAUNCH", ()) + u"</font>", CvUtil.FONT_LEFT_JUSTIFY, self.X_LAUNCH, self.Y_LAUNCH, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setText(self.EXIT_ID, "Background", self.EXIT_TEXT, CvUtil.FONT_RIGHT_JUSTIFY, self.X_EXIT, self.Y_EXIT, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1 )
	
	
	def initMinimap(self, screen):
		# Minimap initialization
		self.H_MAP = (self.W_MAP * CyMap().getGridHeight()) / CyMap().getGridWidth()
		if (self.H_MAP > self.H_MAP_MAX):
			self.W_MAP = (self.H_MAP_MAX * CyMap().getGridWidth()) / CyMap().getGridHeight()
			self.H_MAP = self.H_MAP_MAX
		
		screen.addPanel("Minimap", u"", "", False, False, self.X_MAP, self.Y_MAP, self.W_MAP, self.H_MAP, PanelStyles.PANEL_STYLE_MAIN)
				
		screen.initMinimap(self.X_MAP + self.MAP_MARGIN, self.X_MAP + self.W_MAP - self.MAP_MARGIN, self.Y_MAP + self.MAP_MARGIN, self.Y_MAP + self.H_MAP - self.MAP_MARGIN, self.Z_CONTROLS)
		screen.updateMinimapSection(False, False)

		screen.updateMinimapColorFromMap(MinimapModeTypes.MINIMAPMODE_TERRITORY, 0.3)

		screen.setMinimapMode(MinimapModeTypes.MINIMAPMODE_MILITARY)
				
		iOldMode = CyInterface().getShowInterface()
		CyInterface().setShowInterface(InterfaceVisibility.INTERFACE_MINIMAP_ONLY)
		screen.updateMinimapVisibility()
		CyInterface().setShowInterface(iOldMode)
	
	
	def clearScreen(self, screen):
		if(self.currentScreen == OUTGOING_WARHEADS):
			screen.minimapClearAllFlashingTiles()
			screen.deleteWidget(OUTGOING_WARHEADS_PANEL)
			screen.deleteWidget(OUTGOING_WARHEADS_INNER_PANEL)
			screen.deleteWidget(OUTGOING_LABEL_PANEL)
			screen.deleteWidget(self.OUTGOING_LABEL_ID)
			
			screen.deleteWidget(OUTGOING_SUMMARY_PANEL)
			screen.deleteWidget(OUTGOING_SUMMARY_INNER_PANEL)
			screen.deleteWidget(OUTGOING_SUMMARY_LABEL_PANEL)
			screen.deleteWidget(self.OUTGOING_SUMMARY_LABEL_ID)
			self.selectedUnitHash = {}
		
		elif(self.currentScreen == INCOMING_WARHEADS):
			screen.minimapClearAllFlashingTiles()
			screen.deleteWidget(INCOMING_WARHEADS_PANEL)
			screen.deleteWidget(INCOMING_WARHEADS_INNER_PANEL)
			screen.deleteWidget(INCOMING_LABEL_PANEL)
			screen.deleteWidget(self.INCOMING_LABEL_ID)
			
			screen.deleteWidget(INCOMING_SUMMARY_PANEL)
			screen.deleteWidget(INCOMING_SUMMARY_INNER_PANEL)
			screen.deleteWidget(INCOMING_SUMMARY_LABEL_PANEL)
			screen.deleteWidget(self.INCOMING_SUMMARY_LABEL_ID)
			self.selectedCityHash = {}
		
		
	def drawOutgoingWarheadsContent(self, screen):
	
		self.H_MAP = (self.W_MAP * CyMap().getGridHeight()) / CyMap().getGridWidth()
		if (self.H_MAP > self.H_MAP_MAX):
			self.W_MAP = (self.H_MAP_MAX * CyMap().getGridWidth()) / CyMap().getGridHeight()
			self.H_MAP = self.H_MAP_MAX
			
		screen.addPanel(OUTGOING_WARHEADS_PANEL, u"", "", False, False, 24, 60, 390, 708-60, PanelStyles.PANEL_STYLE_MAIN)
		screen.addPanel(OUTGOING_WARHEADS_INNER_PANEL, u"", "", True, True, 34, 60+10+40, 370, 708-(70+15+35), PanelStyles.PANEL_STYLE_IN)
		screen.addPanel(OUTGOING_LABEL_PANEL, u"", "", False, False, 29, 60+10, 380, 35, PanelStyles.PANEL_STYLE_MAIN)
		screen.setText(self.OUTGOING_LABEL_ID, "Background", u"<font=3b>" + localText.getText("TXT_KEY_OUTGOING_WARHEADS", ()) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, 24+(350/2), 60+10+7, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setHitTest(self.OUTGOING_LABEL_ID,HitTestTypes.HITTEST_NOHIT)
		
		screen.addPanel(OUTGOING_SUMMARY_PANEL, u"", "", False, False, 420, self.Y_MAP+self.H_MAP+5, 580, self.H_SCREEN-(self.Y_MAP+self.H_MAP+5)-60, PanelStyles.PANEL_STYLE_MAIN)
		screen.addPanel(OUTGOING_SUMMARY_INNER_PANEL, u"", "", True, False, 425+5, self.Y_MAP+self.H_MAP+15+40, 580-20, self.H_SCREEN-(self.Y_MAP+self.H_MAP+5)-(70+35+15), PanelStyles.PANEL_STYLE_IN)
		screen.addPanel(OUTGOING_SUMMARY_LABEL_PANEL, u"", "", False, False, 425, self.Y_MAP+self.H_MAP+15, 570, 35, PanelStyles.PANEL_STYLE_MAIN)
		screen.setText(self.OUTGOING_SUMMARY_LABEL_ID, "Background", u"<font=3b>" + localText.getText("TXT_KEY_NUCLEAR_ARSENAL_SUMMARY", ()) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, 425+(570/2), self.Y_MAP+self.H_MAP+15+7, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setHitTest(self.OUTGOING_SUMMARY_LABEL_ID,HitTestTypes.HITTEST_NOHIT)
		
		iCounter = 0
		iTotalNukeCount = 0		
		
		for iUnitIter in range(gc.getPlayer(gc.getGame().getActivePlayer()).getNumMADUnits()):
			# Note: iUnitIter may return a different unit than perviously if
			#	   a unit is deleted from the list.  The unit's ID, however,
			#	   may be used to retrieve a unit object at a later time
			#	   with a call to CvPlayer::getUnit(iUnitID), regardless of
			#	   other changes to the unit list.  iUnitID and ::getUnit should be
			#	   used at any point past this to retrieve a unit object rather than
			#	   iUnitIter and ::getMADUnit.
			
			targetText = " "
			ownerText = " "
			locatedText = " "
			
			objUnit = gc.getPlayer(gc.getGame().getActivePlayer()).getMADUnit(iUnitIter)
			
			# If objUnit is invalid, continue
			if(objUnit == None or objUnit.isNone()):
				continue
				
			# If this is not a valid MAD Nuke, continue
			if(objUnit.isMADNuke() == False):
				continue
				
			# Get the unit's ID
			iUnitID = objUnit.getID()
			
			self.selectedUnitHash[iUnitID] = false;
			
			iTotalNukeCount += 1
			
			if(objUnit.getMADTargetPlot() == None):
				continue

			if(objUnit.getMADTargetPlot().isNone()):
				continue
			
			targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": "

			if(objUnit.getMADTargetPlot().isRevealed(gc.getGame().getActiveTeam(),False) == False):					   
				targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": " + localText.getText("TXT_KEY_TARGET_UNKNOWN", ()) 
				
			if(objUnit.getMADTargetPlot().isRevealed(gc.getGame().getActiveTeam(),False) == True and objUnit.getMADTargetPlot().isActiveVisible(False) == False):					   
				if(objUnit.getMADTargetPlot().isCity() == True):
					targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": %s" %(objUnit.getMADTargetPlot().getPlotCity().getName())
				if not(objUnit.getMADTargetPlot().isCity() == True):
					targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": "
					# hier  nun Koordinaten
					
					iLongDeg = objUnit.getMADTargetPlot().getCoordLongitudeDegrees()
					iLongMin = abs(objUnit.getMADTargetPlot().getCoordLongitudeMinutes())
					
					bWest = False

					if (iLongDeg < 0):
						iLongDeg = abs(iLongDeg)
						bWest = true
					
					targetText += "%d" %(iLongDeg) + localText.getText("TXT_KEY_DEGREE_TEXT", ()) + " %d" %(iLongMin) + localText.getText("TXT_KEY_MINUTE_TEXT", ()) + " "								 

					if (bWest == True):
						targetText += localText.getText("TXT_KEY_LATLONG_WEST", ())
					else:
						targetText += localText.getText("TXT_KEY_LATLONG_EAST", ())

					targetText += localText.getText(", ", ())

					iLatDeg = objUnit.getMADTargetPlot().getCoordLatitudeDegrees()
					iLatMin = abs(objUnit.getMADTargetPlot().getCoordLatitudeMinutes())
					
					bSouth = False

					if (iLatDeg < 0):			
						iLatDeg = abs(iLatDeg)
						bSouth = True

					targetText += "%d" %(iLatDeg) + localText.getText("TXT_KEY_DEGREE_TEXT", ()) + " %d" %(iLatMin) + localText.getText("TXT_KEY_MINUTE_TEXT", ()) + " "								   

					if (bSouth == True):
						targetText += localText.getText("TXT_KEY_LATLONG_SOUTH", ())
					else:
						targetText += localText.getText("TXT_KEY_LATLONG_NORTH", ())															   
										
					#if (objUnit.getMADTargetPlot().isIce() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_ICE", ())
					#if (objUnit.getMADTargetPlot().isJungle() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_JUNGLE", ())
					#if (objUnit.getMADTargetPlot().isForest() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_FOREST", ())
					#if (objUnit.getMADTargetPlot().isIce() == False and objUnit.getMADTargetPlot().isJungle() == False and objUnit.getMADTargetPlot().isForest() == False):
					#	targetText += "%s" %(gc.getTerrainInfo(objUnit.getMADTargetPlot().getTerrainType()).getDescription())														
			if(objUnit.getMADTargetPlot().isRevealed(gc.getGame().getActiveTeam(),False) == True and objUnit.getMADTargetPlot().isActiveVisible(False) == True):					   
				if(objUnit.getMADTargetPlot().isCity() == True):
					targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": %s" %(objUnit.getMADTargetPlot().getPlotCity().getName())
					#if (objUnit.getMADTargetPlot().getBonusType(objUnit.getMADTargetPlot().getOwner()) != -1):
					#	targetText += ", %s" %(gc.getBonusInfo(objUnit.getMADTargetPlot().getBonusType(objUnit.getMADTargetPlot().getOwner())).getDescription())				
				
				if not(objUnit.getMADTargetPlot().isCity() == True):
					targetText = "			 " + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": "
					# hier  nun Koordinaten

					iLongDeg = objUnit.getMADTargetPlot().getCoordLongitudeDegrees()
					iLongMin = abs(objUnit.getMADTargetPlot().getCoordLongitudeMinutes())
					
					bWest = False

					if (iLongDeg < 0):
						iLongDeg = abs(iLongDeg)
						bWest = true
					
					targetText += "%d" %(iLongDeg) + localText.getText("TXT_KEY_DEGREE_TEXT", ()) + " %d" %(iLongMin) + localText.getText("TXT_KEY_MINUTE_TEXT", ()) + " "									   

					if (bWest == True):
						targetText += localText.getText("TXT_KEY_LATLONG_WEST", ())
					else:
						targetText += localText.getText("TXT_KEY_LATLONG_EAST", ())

					targetText += localText.getText(", ", ())

					iLatDeg = objUnit.getMADTargetPlot().getCoordLatitudeDegrees()
					iLatMin = abs(objUnit.getMADTargetPlot().getCoordLatitudeMinutes())
					
					bSouth = False

					if (iLatDeg < 0):			
						iLatDeg = abs(iLatDeg)
						bSouth = True

					targetText += "%d" %(iLatDeg) + localText.getText("TXT_KEY_DEGREE_TEXT", ()) + " %d" %(iLatMin) + localText.getText("TXT_KEY_MINUTE_TEXT", ()) + " "

					if (bSouth == True):
						targetText += localText.getText("TXT_KEY_LATLONG_SOUTH", ())
					else:
						targetText += localText.getText("TXT_KEY_LATLONG_NORTH", ()) 
												
					#if (gc.getImprovementInfo(objUnit.getMADTargetPlot().getImprovementType()) != None):
					#	targetText += "%s" %(gc.getImprovementInfo(objUnit.getMADTargetPlot().getImprovementType()).getDescription())
					#	if (objUnit.getMADTargetPlot().getBonusType(objUnit.getMADTargetPlot().getOwner()) != -1):
					#		targetText += ", %s" %(gc.getBonusInfo(objUnit.getMADTargetPlot().getBonusType(objUnit.getMADTargetPlot().getOwner())).getDescription())																		
					#if (objUnit.getMADTargetPlot().isIce() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_ICE", ())
					#if (objUnit.getMADTargetPlot().isJungle() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_JUNGLE", ())
					#if (objUnit.getMADTargetPlot().isForest() == True):
					#	targetText += localText.getText("TXT_KEY_FEATURE_FOREST", ())
					#if (objUnit.getMADTargetPlot().isIce() == False and objUnit.getMADTargetPlot().isJungle() == False and objUnit.getMADTargetPlot().isForest() == False):
					#	targetText += "%s" %(gc.getTerrainInfo(objUnit.getMADTargetPlot().getTerrainType()).getDescription())

			ownedText = "			 " + localText.getText("TXT_KEY_PLOT_OWNED_BY", ()) + ": "
			if(objUnit.getMADTargetPlot().getOwner() != -1):
				ownerText = "			 " + localText.getText("TXT_KEY_PLOT_OWNED_BY", ()) + ": %s" %(gc.getPlayer(objUnit.getMADTargetPlot().getOwner()).getCivilizationDescription(0))
			
			#locatedText = "			" + localText.getText("TXT_KEY_LOCATED_AT", ()) + ": "
			if(objUnit.plot().isCity() == True):
				if ("%s" %(objUnit.getTransportUnit().getName()) != ""):										
					locatedText = "			 " + localText.getText("TXT_KEY_LOCATED_AT", ()) + ": %s, %s" %(objUnit.plot().getPlotCity().getName(), objUnit.getTransportUnit().getName())
				else: 
					locatedText = "			 " + localText.getText("TXT_KEY_LOCATED_AT", ()) + ": %s" %(objUnit.plot().getPlotCity().getName())
			#if(objUnit.plot().isCity() == True):
			#	locatedText = "			" + localText.getText("TXT_KEY_LOCATED_AT", ()) + ": %s" %(objUnit.plot().getPlotCity().getName())
			if(objUnit.plot().isCity() == False):
				locatedText = "			 " + localText.getText("TXT_KEY_LOCATED_AT", ()) + ": %s" %(objUnit.getTransportUnit().getName())
						
			screen.attachPanel(OUTGOING_WARHEADS_INNER_PANEL, "UnitPanel%s" %(iUnitID), "", "", True, False, PanelStyles.PANEL_STYLE_OUT)

			screen.attachPanel("UnitPanel%s" %(iUnitID), "UnitInnerPanel%s" %(iUnitID), "", "", True, False, PanelStyles.PANEL_STYLE_EMPTY)
			screen.attachLabel( "UnitInnerPanel%s" %(iUnitID), "UnitInnerPanel%sfill1" %(iUnitID), locatedText)
			screen.attachLabel( "UnitInnerPanel%s" %(iUnitID), "UnitInnerPanel%sfill2" %(iUnitID), targetText)
			screen.attachLabel( "UnitInnerPanel%s" %(iUnitID), "UnitInnerPanel%sfill3" %(iUnitID), ownerText)

#			#screen.attachLabel( "UnitPanel%s" %(iUnitID), "UnitPanel%sfill1" %(iUnitID), "			" )
			screen.addCheckBoxGFCAt( "UnitPanel%s" %(iUnitID), "UnitCheckbox%s" %(iUnitID)
								# rucivfan: Korrektur richtiger Button Start
								, objUnit.getButton()
								# rucivfan: Korrektur richtiger Button Ende								
								, ArtFileMgr.getInterfaceArtInfo("BUTTON_HILITE_SQUARE").getPath()
								, 1, 7, 46, 46, WidgetTypes.WIDGET_GENERAL, iUnitID, iUnitID, ButtonStyles.BUTTON_STYLE_LABEL, False)
			iCounter +=1
			
		if(iCounter <= 10):
			iTempCounter = 10 - iCounter
			
			for iDummy in range(iTempCounter):
				screen.attachPanel(OUTGOING_WARHEADS_INNER_PANEL, "DummyPanel%s" %(iDummy), "", "", True, False, PanelStyles.PANEL_STYLE_EMPTY)
				screen.attachLabel( "DummyPanel%s" %(iDummy), "UnitPanel%sfill1" %(iDummy), "			" )
				screen.attachLabel( "DummyPanel%s" %(iDummy), "UnitPanel%sfill2" %(iDummy), "			" )
				screen.attachLabel( "DummyPanel%s" %(iDummy), "UnitPanel%sfill3" %(iDummy), "			" )

		if (iTotalNukeCount == 1):		
			szText1 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_TOTAL_NUCLEAR_WARHEADS_SINGULAR", ()) + u"</FONT>"
		else:
			szText1 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_TOTAL_NUCLEAR_WARHEADS_PLURAL", ()) + u"</FONT>"
		if (iCounter == 1):		
			szText2 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_OUTGOING_NUCLEAR_WARHEADS_SINGULAR", ()) + u"</FONT>"
		else:
			szText2 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_OUTGOING_NUCLEAR_WARHEADS_PLURAL", ()) + u"</FONT>"
		if (iTotalNukeCount - iCounter == 1):		
			szText3 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_AVAILABLE_NUCLEAR_WARHEADS_SINGULAR", ()) + u"</FONT>"
		else:
			szText3 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_AVAILABLE_NUCLEAR_WARHEADS_PLURAL", ()) + u"</FONT>"
		
		screen.attachLabel( OUTGOING_SUMMARY_INNER_PANEL, "TotalNukes", szText1 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalNukeCount) )
		screen.attachLabel( OUTGOING_SUMMARY_INNER_PANEL, "TotalOutgoingNukes", szText2 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iCounter) )
		screen.attachLabel( OUTGOING_SUMMARY_INNER_PANEL, "TotalNukesAvailable", szText3 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalNukeCount-iCounter) )
		

	def drawIncomingWarheadsContent(self, screen):

		self.H_MAP = (self.W_MAP * CyMap().getGridHeight()) / CyMap().getGridWidth()
		if (self.H_MAP > self.H_MAP_MAX):
			self.W_MAP = (self.H_MAP_MAX * CyMap().getGridWidth()) / CyMap().getGridHeight()
			self.H_MAP = self.H_MAP_MAX
			
		screen.addPanel(INCOMING_WARHEADS_PANEL, u"", "", False, False, 24, 60, 390, 708-60, PanelStyles.PANEL_STYLE_MAIN)
		screen.addPanel(INCOMING_WARHEADS_INNER_PANEL, u"", "", True, True, 34, 60+10+40, 370, 708-(70+15+35), PanelStyles.PANEL_STYLE_IN)
		screen.addPanel(INCOMING_LABEL_PANEL, u"", "", False, False, 29, 60+10, 380, 35, PanelStyles.PANEL_STYLE_MAIN)
		screen.setText(self.INCOMING_LABEL_ID, "Background", u"<font=3b>" + localText.getText("TXT_KEY_INCOMING_WARHEADS", ()) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, 24+(350/2), 60+10+7, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setHitTest(self.INCOMING_LABEL_ID,HitTestTypes.HITTEST_NOHIT)
		
		screen.addPanel(INCOMING_SUMMARY_PANEL, u"", "", False, False, 420, self.Y_MAP+self.H_MAP+5, 580, self.H_SCREEN-(self.Y_MAP+self.H_MAP+5)-60, PanelStyles.PANEL_STYLE_MAIN)
		screen.addPanel(INCOMING_SUMMARY_INNER_PANEL, u"", "", True, True, 425+5, self.Y_MAP+self.H_MAP+15+40, 580-20, self.H_SCREEN-(self.Y_MAP+self.H_MAP+5)-(70+35+15), PanelStyles.PANEL_STYLE_IN)
		screen.addPanel(INCOMING_SUMMARY_LABEL_PANEL, u"", "", False, False, 425, self.Y_MAP+self.H_MAP+15, 570, 35, PanelStyles.PANEL_STYLE_MAIN)
		screen.setText(self.INCOMING_SUMMARY_LABEL_ID, "Background", u"<font=3b>" + localText.getText("TXT_KEY_NUCLEAR_THREAT_SUMMARY", ()) + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, 425+(570/2), self.Y_MAP+self.H_MAP+15+7, self.Z_CONTROLS, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setHitTest(self.INCOMING_SUMMARY_LABEL_ID,HitTestTypes.HITTEST_NOHIT)
		
		iCounter = 0
		iTotalCityCount = 0
		iTotalThreatCount = 0
		iActivePlayer = gc.getGame().getActivePlayer()
		
		for iCityID in range(gc.getPlayer(iActivePlayer).getNumCities()):
			objCity = gc.getPlayer(iActivePlayer).getCity(iCityID)

			if (objCity >= -1):
								continue
			
			self.selectedCityHash[iCityID] = false;
						
			iTotalCityCount += 1
			
			if(objCity.plot().getMADIncoming() == 0):
				continue

			screen.attachPanel(INCOMING_WARHEADS_INNER_PANEL, "CityPanel%s" %(iCityID), "", "", True, False, PanelStyles.PANEL_STYLE_OUT)

			screen.attachPanel("CityPanel%s" %(iCityID), "CityInnerPanel%s" %(iCityID), "", "", True, False, PanelStyles.PANEL_STYLE_EMPTY)
			screen.attachLabel( "CityInnerPanel%s" %(iCityID), "CityInnerPanel%sfill1" %(iCityID), "			" + localText.getText("TXT_KEY_TARGET_TEXT", ()) + ": %s" %(objCity.getName()))
			if (objCity.plot().getMADIncoming() == 1):
				TargetCountText = localText.getText("TXT_KEY_TARGET_COUNT_SINGULAR", ())
			else:
				TargetCountText = localText.getText("TXT_KEY_TARGET_COUNT_PLURAL", ())								
			screen.attachLabel( "CityInnerPanel%s" %(iCityID), "CityInnerPanel%sfill2" %(iCityID), "			" + TargetCountText + ": %s" %(objCity.plot().getMADIncoming()))
			screen.attachLabel( "CityInnerPanel%s" %(iCityID), "CityInnerPanel%sfill3" %(iCityID), "			")

#			screen.attachLabel( "CityPanel%s" %(iCityID), "CityPanel%sfill1" %(iCityID), "			" )
			screen.addCheckBoxGFCAt( "CityPanel%s" %(iCityID), "CityCheckbox%s" %(iCityID)
									   , gc.getMissionInfo(gc.getInfoTypeForString("MISSION_PRETARGET_NUKE")).getButton()
									   , ArtFileMgr.getInterfaceArtInfo("BUTTON_HILITE_SQUARE").getPath()
									   , 1, 2, 46, 46, WidgetTypes.WIDGET_GENERAL, iCityID, iCityID, ButtonStyles.BUTTON_STYLE_LABEL, False)
			iCounter +=1
			iTotalThreatCount += objCity.plot().getMADIncoming()
		
		if(iCounter <= 10):
			iTempCounter = 10 - iCounter
			
			for iDummy in range(iTempCounter):
				screen.attachPanel(INCOMING_WARHEADS_INNER_PANEL, "DummyPanel%s" %(iDummy), "", "", True, False, PanelStyles.PANEL_STYLE_EMPTY)
				screen.attachLabel( "DummyPanel%s" %(iDummy), "CityPanel%sfill1" %(iDummy), "			" )
				screen.attachLabel( "DummyPanel%s" %(iDummy), "CityPanel%sfill2" %(iDummy), "			" )
				screen.attachLabel( "DummyPanel%s" %(iDummy), "CityPanel%sfill3" %(iDummy), "			" )
		
		
		self.updateIncomingSummaryText()
		#IncomingSummaryText = ""
		#IncomingSummaryText = IncomingSummaryText + u"%c<FONT=3b>%s Cities</FONT>\n" %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalCityCount)
		#IncomingSummaryText = IncomingSummaryText + u"%c<FONT=3b>%s Threatened Cities</FONT>\n" %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iCounter)
		#IncomingSummaryText = IncomingSummaryText + u"%c<FONT=3b>%s Untargeted Cities</FONT>\n" %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalCityCount-iCounter)
		#IncomingSummaryText = IncomingSummaryText + u"%c<FONT=3b>%s Total Threat Count</FONT>\n" %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalThreatCount)
		
		#for iPlayerID in range(gc.getMAX_PLAYERS()):
		#	if (iPlayerID == iActivePlayer):
		#		continue
			
		#	objPlayer = gc.getPlayer(iPlayerID)
			
			# Continue if objPlayer is invalid
		#	if (objPlayer == None or objPlayer.isNone() == True):
		#		continue
				
			# Continue if objPlayer is not alive
		#	if (objPlayer.isAlive() == False):
		#		continue
			
		#	IncomingSummaryText = IncomingSummaryText + u"\t%c<FONT=3b>%s Total Threat Count [%s]</FONT>\n" %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), objPlayer.getMADOutgoingAt(PlayerTypes(iActivePlayer)), objPlayer.getName())
			
		#screen.attachMultilineText( INCOMING_SUMMARY_INNER_PANEL, "IncomingSummaryText", IncomingSummaryText, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)

		
																									
	# returns a unique ID for a widget in this screen
	def getNextWidgetName(self):
		szName = self.WIDGET_ID + str(self.nWidgetCount)
		self.nWidgetCount += 1
		return szName
						
	def updateMinimap(self):

		# Get the instance of the screen
		screen = self.getScreen()

		screen.minimapClearAllFlashingTiles()
		
		objPlayer = gc.getPlayer(gc.getGame().getActivePlayer())
		iPlayer = gc.getGame().getActivePlayer()
		
		iTargetColor = gc.getInfoTypeForString("COLOR_RED")
				
		for iUnitID in self.selectedUnitHash.keys():

			if(not self.selectedUnitHash[iUnitID]):
				continue
				
			if(not screen.getCheckBoxState("UnitCheckbox%s" %(iUnitID))):
				self.selectedUnitHash[iUnitID] = false
				continue
				
			objUnit = objPlayer.getUnit(iUnitID)
			iColor = gc.getPlayerColorInfo(gc.getPlayer(iPlayer).getPlayerColor()).getColorTypePrimary()
			
			#screen.setMinimapColor(MinimapModeTypes.MINIMAPMODE_MILITARY, objUnit.getX(), objUnit.getY(), iColor, 0.6)
			
			screen.minimapFlashPlot(objUnit.getX(), objUnit.getY(), iColor, -1)
			screen.minimapFlashPlot(objUnit.getMADTargetPlot().getX(), objUnit.getMADTargetPlot().getY(), iTargetColor, -1)
		

		for iCityID in self.selectedCityHash.keys():

			if(not self.selectedCityHash[iCityID]):
				continue
				
			if(not screen.getCheckBoxState("CityCheckbox%s" %(iCityID))):
				self.selectedCityHash[iCityID] = false
				continue
				
			objCity = objPlayer.getCity(iCityID)
			iColor = gc.getPlayerColorInfo(gc.getPlayer(iPlayer).getPlayerColor()).getColorTypePrimary()
			
			screen.minimapFlashPlot(objCity.getX(), objCity.getY(), iColor, -1)
			
			# Continue if objCity is invalid
			if(objCity == None or objCity.isNone == True):
				continue
			
			# Flash all incoming warhead locations
			for iUnitIndex in range(objCity.plot().getNumMADIncomingWarheads()):
				objUnit = objCity.plot().getMADIncomingWarhead(iUnitIndex)
				
				if(objUnit == None or objUnit.isNone() == True):
					continue
				
				screen.minimapFlashPlot(objUnit.plot().getX(), objUnit.plot().getY(), iTargetColor, -1)
				
		self.updateIncomingSummaryText()
			

	def updateIncomingSummaryText(self):
		screen = self.getScreen()
		
		iCounter = 0
		iTotalCityCount = 0
		iTotalThreatCount = 0
		iActivePlayer = gc.getGame().getActivePlayer()
		objActivePlayer = gc.getPlayer(iActivePlayer)
		
		for iCityID in range(objActivePlayer.getNumCities()):
			objCity = objActivePlayer.getCity(iCityID)

			if (objCity == None):
				continue
						
			iTotalCityCount += 1
			
			if(objCity.plot().getMADIncoming() == 0):
				continue
				
			iCounter +=1
			iTotalThreatCount += objCity.plot().getMADIncoming()

		if (iTotalCityCount == 1):		
			szText4 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_CITIES_SINGULAR", ()) + u"</FONT>\n"
		else:
			szText4 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_CITIES_PLURAL", ()) + u"</FONT>\n"
		if (iCounter == 1):		
			szText5 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_THREATENED_CITIES_SINGULAR", ()) + u"</FONT>\n"
		else:
			szText5 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_THREATENED_CITIES_PLURAL", ()) + u"</FONT>\n"
		if (iTotalCityCount-iCounter == 1):		
			szText6 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_UNTARGETED_CITIES_SINGULAR", ()) + u"</FONT>\n"
		else:
			szText6 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_UNTARGETED_CITIES_PLURAL", ()) + u"</FONT>\n"
		if (iTotalThreatCount == 1):		
			szText7 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_SINGULAR", ()) + u"</FONT>\n"
		else:
			szText7 = u"<FONT=3b>%c%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_PLURAL", ()) + u"</FONT>\n"
			
		IncomingSummaryText = ""
		IncomingSummaryText = IncomingSummaryText + szText4 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalCityCount)
		IncomingSummaryText = IncomingSummaryText + szText5 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iCounter)
		IncomingSummaryText = IncomingSummaryText + szText6 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalCityCount-iCounter)
		IncomingSummaryText = IncomingSummaryText + szText7 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), iTotalThreatCount)
	
		for iPlayerID in range(gc.getMAX_PLAYERS()):
			if (iPlayerID == iActivePlayer):
				continue
			
			objPlayer = gc.getPlayer(iPlayerID)
			
			# Continue if objPlayer is invalid
			if (objPlayer == None or objPlayer.isNone() == True):
				continue
				
			# Continue if objPlayer is not alive
			if (objPlayer.isAlive() == False):
				continue
				
			if (objPlayer.getMADOutgoingAt(PlayerTypes(iActivePlayer)) == 0):
				continue
			
			if (objPlayer.getMADOutgoingAt(PlayerTypes(iActivePlayer)) == 1):		
				szText8 = u"\t%c<FONT=3>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_SINGULAR", ()) + u" [%s]</FONT>\n"
			else:
				szText8 = u"\t%c<FONT=3>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_PLURAL", ()) + u" [%s]</FONT>\n"
			IncomingSummaryText = IncomingSummaryText + szText8 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), objPlayer.getMADOutgoingAt(PlayerTypes(iActivePlayer)), objPlayer.getName())		
			
		for iCityID in self.selectedCityHash.keys():	
			if(not self.selectedCityHash[iCityID]):
				continue
				
			if(not screen.getCheckBoxState("CityCheckbox%s" %(iCityID))):
				self.selectedCityHash[iCityID] = false
				continue
				
			objCity = objActivePlayer.getCity(iCityID)

			if (objCity == None):
				continue
				
			# Initalize our hash for this city
			PlayerTotalsHash = {}
			
			for iPlayerID in range(gc.getMAX_PLAYERS()):
				if (iPlayerID == iActivePlayer):
					continue
			
				objPlayer = gc.getPlayer(iPlayerID)
			
				# Continue if objPlayer is invalid
				if (objPlayer == None or objPlayer.isNone() == True):
					continue
					
				PlayerTotalsHash[iPlayerID] = 0
			
			for iUnitIndex in range(objCity.plot().getNumMADIncomingWarheads()):
				objUnit = objCity.plot().getMADIncomingWarhead(iUnitIndex)
				
				if(objUnit == None or objUnit.isNone() == True):
					continue
					
				PlayerTotalsHash[objUnit.getOwner()] += 1
				
			if (objCity.plot().getMADIncoming() == 1):		
				szText9 = u"%c<FONT=3b>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_SINGULAR", ()) + u" [%s]</FONT>\n"
			else:
				szText9 = u"%c<FONT=3b>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_PLURAL", ()) + u" [%s]</FONT>\n"			
			IncomingSummaryText = IncomingSummaryText + szText9 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), objCity.plot().getMADIncoming(), objCity.getName())
			
			for iPlayerID in PlayerTotalsHash.keys():
				objPlayer = gc.getPlayer(iPlayerID)
				
				# Continue if objPlayer is invalid
				if (objPlayer == None or objPlayer.isNone() == True):
					continue
				
				# Continue if objPlayer is not alive
				if (objPlayer.isAlive() == False):
					continue
					
				if (PlayerTotalsHash[iPlayerID] == 0):
					continue
				
				if (PlayerTotalsHash[iPlayerID] == 1):		
					szText10 = u"\t%c<FONT=3>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_SINGULAR", ()) + u" [%s]</FONT>\n"
				else:
					szText10 = u"\t%c<FONT=3>%s " + localText.getText("TXT_KEY_TOTAL_THREAT_COUNT_PLURAL", ()) + u" [%s]</FONT>\n"					
				IncomingSummaryText = IncomingSummaryText + szText10 %(CyGame().getSymbolID(FontSymbols.BULLET_CHAR), PlayerTotalsHash[iPlayerID], objPlayer.getName())
		
		screen.attachMultilineText( INCOMING_SUMMARY_INNER_PANEL, "IncomingSummaryText", IncomingSummaryText, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)

	def update(self, fDelta):
		screen = self.getScreen()
			
																					
	# handle the input for this screen...
	def handleInput (self, inputClass):

		# Get the instance of the screen
		screen = self.getScreen()
		

		if(inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED):
			if(inputClass.getFunctionName() == "UnitCheckbox"):
				
				#screen.setText( "TopPanelDebugMsg", "TopPanel", inputClass.getFunctionName()+"%s %s %s" %(inputClass.getData1(),(inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED), screen.getCheckBoxState(inputClass.getFunctionName()+"%s" %(inputClass.getData1())))
				#			, CvUtil.FONT_RIGHT_JUSTIFY, 1010, 20, -10, FontTypes.SMALL_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )

											
				self.selectedUnitHash[inputClass.getData1()] = screen.getCheckBoxState(inputClass.getFunctionName()+"%s" %(inputClass.getData1()))
				self.updateMinimap()	
				
			if(inputClass.getFunctionName() == "CityCheckbox"):
				
				#screen.setText( "TopPanelDebugMsg", "TopPanel", inputClass.getFunctionName()+"%s %s %s" %(inputClass.getData1(),(inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED), screen.getCheckBoxState(inputClass.getFunctionName()+"%s" %(inputClass.getData1())))
				#			, CvUtil.FONT_RIGHT_JUSTIFY, 1010, 20, -10, FontTypes.SMALL_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )

											
				self.selectedCityHash[inputClass.getData1()] = screen.getCheckBoxState(inputClass.getFunctionName()+"%s" %(inputClass.getData1()))
				self.updateMinimap()						
			
			if((inputClass.getFunctionName() == self.OUTGOING_ID  or inputClass.getFunctionName() == "") and self.currentScreen != OUTGOING_WARHEADS):
				self.clearScreen(screen)
				self.currentScreen = OUTGOING_WARHEADS
				self.drawOutgoingWarheadsContent(screen)
				return 0

			if((inputClass.getFunctionName() == self.INCOMING_ID or inputClass.getFunctionName() == "") and self.currentScreen != INCOMING_WARHEADS):
				self.clearScreen(screen)
				self.currentScreen = INCOMING_WARHEADS
				self.drawIncomingWarheadsContent(screen)
				return 0
				
			if((inputClass.getFunctionName() == self.LAUNCH_ID or inputClass.getFunctionName() == "") and self.currentScreen == OUTGOING_WARHEADS):
				self.launchSelectedNukes(screen)
				return 0
			
			if(inputClass.getFunctionName() == self.EXIT_ID):
				self.currentScreen = OUTGOING_WARHEADS
				
		return 0

	# Launches all currently selected nukes
	def launchSelectedNukes(self, screen):
		
		# Return if MAD is currently disabled
		if ( gc.getGame().isMADEnabled() == False ):
			return
		
		objPlayer = gc.getPlayer(gc.getGame().getActivePlayer())
		iPlayer = gc.getGame().getActivePlayer()
		bReloadScreen = False
		
		for iUnitID in self.selectedUnitHash.keys():

			if(not self.selectedUnitHash[iUnitID]):
				continue
				
			if(not screen.getCheckBoxState("UnitCheckbox%s" %(iUnitID))):
				self.selectedUnitHash[iUnitID] = false
				continue
				
			objUnit = objPlayer.getUnit(iUnitID)
			
			# Continue if this is not a valid unit
			if(objUnit == None or objUnit.isNone()):
				continue
				
			# Continue if this is not a valid MAD Nuke
			if(objUnit.isMADNuke() == False):
				continue
				
			# Continue if the target for this unit is not set
			if(objUnit.isMADTargetSet() == False):
				continue
				
			# Launch the nuke!!
			CyMessageControl().sendModNetMessage(self.iNetMessage_launch, objUnit.getID(), objUnit.getOwner(), 0, 0)
			
	#Updates the OUTGOING WARHEADS screen if it is currently selected
	def updateOutgoingWarheads(self):
		if (self.getScreen().isActive()):
			if (self.currentScreen == OUTGOING_WARHEADS):
				self.clearScreen(self.getScreen())
				self.drawOutgoingWarheadsContent(self.getScreen())


	# Adds a 100 x 100 panel for each panel style available
	def showDebugScreen(self):
		
		screen = self.getScreen()
		screen.addPanel("BACKGROUND", "", "", false, false, 0, 0, screen.getXResolution(), screen.getYResolution(), PanelStyles.PANEL_STYLE_SOLID)

		screen.setPanelColor("BACKGROUND",255,255,255)

		iRow = 5		
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_STANDARD", false, false, iRow, 5, 100, 100, PanelStyles.PANEL_STYLE_STANDARD)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_SOLID", false, false, 110, iRow, 100, 100, PanelStyles.PANEL_STYLE_SOLID)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_EMPTY", false, false, 215, iRow, 100, 100, PanelStyles.PANEL_STYLE_EMPTY)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_FLAT", false, false, 320, iRow, 100, 100, PanelStyles.PANEL_STYLE_FLAT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_IN", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_IN)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_OUT", false, false, 530, iRow, 100, 100, PanelStyles.PANEL_STYLE_OUT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_EXTERNAL", false, false, 635, iRow, 100, 100, PanelStyles.PANEL_STYLE_EXTERNAL)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_DEFAULT", false, false, 740, iRow, 100, 100, PanelStyles.PANEL_STYLE_DEFAULT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CIVILPEDIA", false, false, 845, iRow, 100, 100, PanelStyles.PANEL_STYLE_CIVILPEDIA)

		iRow += 105
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_STONE", false, false, 5, iRow, 100, 100, PanelStyles.PANEL_STYLE_STONE)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_BLUELARGE", false, false, iRow, 110, 100, 100, PanelStyles.PANEL_STYLE_BLUELARGE)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_UNITSTAT", false, false, 215, iRow, 100, 100, PanelStyles.PANEL_STYLE_UNITSTAT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_BLUE50", false, false, 320, iRow, 100, 100, PanelStyles.PANEL_STYLE_BLUE50)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_TOPBAR", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_TOPBAR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_BOTTOMBAR", false, false, 530, iRow, 100, 100, PanelStyles.PANEL_STYLE_BOTTOMBAR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_TECH", false, false, 635, iRow, 100, 100, PanelStyles.PANEL_STYLE_TECH)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAMEHUD_LEFT", false, false, 740, iRow, 100, 100, PanelStyles.PANEL_STYLE_GAMEHUD_LEFT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAMEHUD_RIGHT", false, false, 845, iRow, 100, 100, PanelStyles.PANEL_STYLE_GAMEHUD_RIGHT)

		iRow += 105
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAMEHUD_CENTER", false, false, 5, iRow, 100, 100, PanelStyles.PANEL_STYLE_GAMEHUD_CENTER)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAMEHUD_STATS", false, false, 110, iRow, 100, 100, PanelStyles.PANEL_STYLE_GAMEHUD_STATS)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAME_MAP", false, false, iRow, 215, 100, 100, PanelStyles.PANEL_STYLE_GAME_MAP)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_GAME_TOPBAR", false, false, 320, iRow, 100, 100, PanelStyles.PANEL_STYLE_GAME_TOPBAR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_HUD_HELP", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_HUD_HELP)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_LEFT", false, false, 530, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_LEFT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_RIGHT", false, false, 635, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_RIGHT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_TOP", false, false, 740, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_TOP)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_TANSHADE", false, false, 845, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_TANSHADE)

		iRow += 105
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_INFO", false, false, 5, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_INFO)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_TANTL", false, false, 110, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_TANTL)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_TANTR", false, false, 215, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_TANTR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_COLUMNL", false, false, iRow, 320, 100, 100, PanelStyles.PANEL_STYLE_CITY_COLUMNL)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_COLUMNC", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_COLUMNC)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_COLUMNR", false, false, 530, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_COLUMNR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_CITY_TITLE", false, false, 635, iRow, 100, 100, PanelStyles.PANEL_STYLE_CITY_TITLE)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_DAWN", false, false, 740, iRow, 100, 100, PanelStyles.PANEL_STYLE_DAWN)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_DAWNTOP", false, false, 845, iRow, 100, 100, PanelStyles.PANEL_STYLE_DAWNTOP)

		iRow += 105
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_DAWNBOTTOM", false, false, 5, iRow, 100, 100, PanelStyles.PANEL_STYLE_DAWNBOTTOM)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN", false, false, 110, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_BLACK25", false, false, 215, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_BLACK25)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_BLACK50", false, false, iRow, 320, 100, 100, PanelStyles.PANEL_STYLE_MAIN_BLACK50)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_WHITE", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_WHITE)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_WHITETAB", false, false, 530, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_WHITETAB)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TAN", false, false, 635, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TAN)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TAN15", false, false, 740, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TAN15)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TANL", false, false, 845, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TANL)

		iRow += 105
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TANR", false, false, 5, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TANR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TANT", false, false, 110, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TANT)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_TANB", false, false, 215, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_TANB)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_BOTTOMBAR", false, false, iRow, 320, 100, 100, PanelStyles.PANEL_STYLE_MAIN_BOTTOMBAR)
		screen.addPanel(self.getNextWidgetName(), "", "PANEL_STYLE_MAIN_SELECT", false, false, 425, iRow, 100, 100, PanelStyles.PANEL_STYLE_MAIN_SELECT)
