# Sid Meier's Civilization 4
# Copyright Firaxis Games 2005

#
# Sevopedia 2.3
#   sevotastic.blogspot.com
#   sevotastic@yahoo.com
#
# additional work by Gaurav, Progor, Ket, Vovan, Fitchn, LunarMongoose
# see ReadMe for details
#

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import SevoScreenEnums
import string

gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

class SevoPediaReligion:

	def __init__(self, main):
		self.iReligion = -1
		self.top = main

		self.W_REQUIRES = 84
		self.X_REQUIRES = self.top.R_PEDIA_PAGE - self.W_REQUIRES - 116
		self.Y_REQUIRES = self.top.Y_PEDIA_PAGE
		self.H_REQUIRES = 116

		self.X_MAIN_PANE = self.top.X_PEDIA_PAGE
		self.Y_MAIN_PANE = self.top.Y_PEDIA_PAGE
		self.W_MAIN_PANE = self.top.W_PEDIA_PAGE - self.W_REQUIRES - 126
		self.H_MAIN_PANE = 116

		self.W_ICON = 100
		self.H_ICON = 100
		self.X_ICON = self.X_MAIN_PANE + (self.H_MAIN_PANE - self.H_ICON) / 2
		self.Y_ICON = self.Y_MAIN_PANE + (self.H_MAIN_PANE - self.H_ICON) / 2
		self.ICON_SIZE = 64

		self.X_SPECIAL = self.X_MAIN_PANE
		self.Y_SPECIAL = self.Y_MAIN_PANE + self.H_MAIN_PANE + 10
		self.W_SPECIAL = self.top.R_PEDIA_PAGE - self.X_SPECIAL
		self.H_SPECIAL = 116

		self.X_BUILDING_PANE = self.X_MAIN_PANE
		self.Y_BUILDING_PANE = self.Y_SPECIAL + self.H_SPECIAL + 10
		self.W_BUILDING_PANE = (self.top.R_PEDIA_PAGE - self.X_SPECIAL) * 2 / 3 - 5
		self.H_BUILDING_PANE = 110

		self.X_UNIT = self.X_BUILDING_PANE + self.W_BUILDING_PANE + 10
		self.Y_UNIT = self.Y_SPECIAL + self.H_SPECIAL + 10
		self.W_UNIT = (self.top.R_PEDIA_PAGE - self.X_SPECIAL) / 3 - 5
		self.H_UNIT = 110

		self.X_TEXT = self.X_MAIN_PANE
		self.Y_TEXT = self.Y_UNIT + self.H_UNIT + 10
		self.W_TEXT = self.top.R_PEDIA_PAGE - self.X_MAIN_PANE
		self.H_TEXT = self.top.B_PEDIA_PAGE - self.Y_TEXT



	def interfaceScreen(self, iReligion):
		self.iReligion = iReligion
		screen = self.top.getScreen()

		screen.addPanel( self.top.getNextWidgetName(), "", "", False, False, self.X_MAIN_PANE, self.Y_MAIN_PANE, self.W_MAIN_PANE, self.H_MAIN_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.addPanel(self.top.getNextWidgetName(), "", "", False, False, self.X_ICON, self.Y_ICON, self.W_ICON, self.H_ICON, PanelStyles.PANEL_STYLE_MAIN)
		screen.addDDSGFC(self.top.getNextWidgetName(), gc.getReligionInfo(self.iReligion).getButton(), self.X_ICON + self.W_ICON/2 - self.ICON_SIZE/2, self.Y_ICON + self.H_ICON/2 - self.ICON_SIZE/2, self.ICON_SIZE, self.ICON_SIZE, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		self.placeSpecial()
		self.placeBuilding()
		self.placeUnit()
		self.placeRequires()
		self.placeText()



	def placeRequires(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel( panelName, localText.getText("TXT_KEY_PEDIA_REQUIRES", ()), "", False, True, self.X_REQUIRES, self.Y_REQUIRES, self.W_REQUIRES, self.H_REQUIRES, PanelStyles.PANEL_STYLE_BLUE50 )
		screen.attachLabel(panelName, "", "  ")
		iTech = gc.getReligionInfo(self.iReligion).getTechPrereq()
		if (iTech > -1):
			screen.attachImageButton( panelName, "", gc.getTechInfo(iTech).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_TECH, iTech, 1, False )



	def placeSpecial(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel( panelName, localText.getText("TXT_KEY_PEDIA_EFFECTS", ()), "", True, False, self.X_SPECIAL, self.Y_SPECIAL, self.W_SPECIAL, self.H_SPECIAL, PanelStyles.PANEL_STYLE_BLUE50 )
		listName = self.top.getNextWidgetName()
		screen.attachListBoxGFC( panelName, listName, "", TableStyles.TABLE_STYLE_EMPTY )
		screen.enableSelect(listName, False)
		szSpecialText = u"<font=2>" + CyGameTextMgr().parseReligionInfo(self.iReligion, True) + u"</font>"
		screen.addMultilineText(listName, szSpecialText, self.X_SPECIAL+5, self.Y_SPECIAL+12, self.W_SPECIAL-10, self.H_SPECIAL-35, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)



	def placeBuilding(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_BUILDINGS_ENABLED", ()), "", False, True, self.X_BUILDING_PANE, self.Y_BUILDING_PANE, self.W_BUILDING_PANE, self.H_BUILDING_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")

		# Sortierung
		iSlot1 = 0
		iSlot2 = 0
		iSlot3 = 0
		iSlot4 = 0

		for eLoopBuilding in range(gc.getNumBuildingInfos()):
			if (eLoopBuilding != -1):
				if (gc.getBuildingInfo(eLoopBuilding).getReligionType() == self.iReligion):

					# Unsortiert reicht folgende Zeile, dann ALLES weitere in placeBuildings auskommentieren!
					# screen.attachImageButton(panelName, "", gc.getBuildingInfo(eLoopBuilding).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, eLoopBuilding, 1, False)

					if (gc.getBuildingInfo(eLoopBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_MONASTERY")):
						iSlot1 = eLoopBuilding

					elif (gc.getBuildingInfo(eLoopBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_TEMPLE")):
						iSlot2 = eLoopBuilding

					elif (gc.getBuildingInfo(eLoopBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_CATHEDRAL")):
						iSlot3 = eLoopBuilding

					else:
						iSlot4 = eLoopBuilding
						
		if iSlot1 != iSlot2 and iSlot1 != iSlot3 and iSlot1 != iSlot4 and iSlot2 != iSlot3 and iSlot2 != iSlot4 and iSlot3 != iSlot4:
			screen.attachImageButton(panelName, "", gc.getBuildingInfo(iSlot1).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, iSlot1, 1, False)
			screen.attachImageButton(panelName, "", gc.getBuildingInfo(iSlot2).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, iSlot2, 1, False)
			screen.attachImageButton(panelName, "", gc.getBuildingInfo(iSlot3).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, iSlot3, 1, False)
			screen.attachImageButton(panelName, "", gc.getBuildingInfo(iSlot4).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_BUILDING, iSlot4, 1, False)



	def placeUnit(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_UNITS_ENABLED", ()), "", False, True, self.X_UNIT, self.Y_UNIT, self.W_UNIT, self.H_UNIT, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")
		for eLoopUnit in range(gc.getNumUnitInfos()):
			if (eLoopUnit != -1):
				if (gc.getUnitInfo(eLoopUnit).getPrereqReligion() == self.iReligion):
					screen.attachImageButton(panelName, "", gc.getUnitInfo(eLoopUnit).getButton(), GenericButtonSizes.BUTTON_SIZE_CUSTOM, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, eLoopUnit, 1, False)



	def placeText(self):
		screen = self.top.getScreen()
		panelName = self.top.getNextWidgetName()
		screen.addPanel( panelName, "", "", True, True, self.X_TEXT, self.Y_TEXT, self.W_TEXT, self.H_TEXT, PanelStyles.PANEL_STYLE_BLUE50 )
		szText = u"<font=2>" + gc.getReligionInfo(self.iReligion).getCivilopedia() + u"</font>"
		screen.attachMultilineText( panelName, "Text", szText, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)



	def handleInput (self, inputClass):
		return 0
