# Sid Meier's Civilization 4
# Copyright Firaxis Games 2006
# 
# CvEventManager
# This class is passed an argsList from CvAppInterface.onEvent
# The argsList can contain anything from mouse location to key info
# The EVENTLIST that are being notified can be found
# ---------------------
# Edited by Cybah, Germany 2009-2015

#
# ColorTypes()
# 1,3 = schwarz
# 2 = weiss
# 4 = dunkelgrau
# 5,6 = grau
# 7 = rot
# 8 = gruen
# 9 = blau
# 10 = tuerkis
# 11 = gelb
# 12 = lila
# 13 = orange
# 14 = graublau
#

from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import PyHelpers
import Popup as PyPopup
import CvCameraControls
import CvTopCivs
import sys
import CvAdvisorUtils
import CvTechChooser
import CvGameUtils
#Starting points part 1 start#
import StartingPoints
#Starting points part 1 end#
from math import sqrt

# rucivfan_profile_help rph[
import profile_help
# ]rucivfan_profile_help rph

## Platy Builder ##
import WBCityEditScreen
import WBUnitScreen
import WBPlayerScreen
import WBGameDataScreen
import WBPlotScreen
import CvPlatyBuilderScreen
## Platy Builder ##

# OOS logging.
import OOSLogger
# OOS logging.

import SdToolKitCustom as SDTK
import BugUtil

# 6.4 C
import random

gc = CyGlobalContext()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo
PyCity = PyHelpers.PyCity
PyGame = PyHelpers.PyGame


# globals
#
class CvEventManager:
	def __init__(self):
		# ON EVENT MAP #
		#print "EVENTMANAGER INIT"
				
		self.bCtrl = False
		self.bShift = False
		self.bAlt = False
		self.bAllowCheats = False
		
		# OnEvent Enums
		self.EventLButtonDown=1
		self.EventLcButtonDblClick=2
		self.EventRButtonDown=3
		self.EventBack=4
		self.EventForward=5
		self.EventKeyDown=6
		self.EventKeyUp=7
	
		self.__LOG_MOVEMENT = 0
		self.__LOG_BUILDING = 0
		self.__LOG_COMBAT = 0
		self.__LOG_CONTACT = 0
		self.__LOG_IMPROVEMENT =0
		self.__LOG_CITYLOST = 0
		self.__LOG_CITYBUILDING = 0
		self.__LOG_TECH = 0
		self.__LOG_UNITBUILD = 0
		self.__LOG_UNITKILLED = 1
		self.__LOG_UNITLOST = 0
		self.__LOG_UNITPROMOTED = 0
		self.__LOG_UNITSELECTED = 0
		self.__LOG_UNITPILLAGE = 0
		self.__LOG_GOODYRECEIVED = 0
		self.__LOG_GREATPERSON = 0
		self.__LOG_RELIGION = 0
		self.__LOG_RELIGIONSPREAD = 0
		self.__LOG_GOLDENAGE = 0
		self.__LOG_ENDGOLDENAGE = 0
		self.__LOG_WARPEACE = 0
		self.__LOG_PUSH_MISSION = 0
		
## Cybah: BASE fr 6.1 E - Kreativ Counter ##
		self.iHGA = 200
## Cybah: BASE fr 6.1 E - Kreativ Counter ##
		
		# Next War tracks cities that have been razed
		self.iArcologyCityID = -1
		
		# EVENTLIST
		self.EventHandlerMap = {
			'mouseEvent'			: self.onMouseEvent,
			'kbdEvent' 				: self.onKbdEvent,
			'ModNetMessage'					: self.onModNetMessage,
			'Init'					: self.onInit,
			'Update'				: self.onUpdate,
			'UnInit'				: self.onUnInit,
			'OnSave'				: self.onSaveGame,
			'OnPreSave'				: self.onPreSave,
			'OnLoad'				: self.onLoadGame,
			'GameStart'				: self.onGameStart,
			'GameEnd'				: self.onGameEnd,
			'plotRevealed' 			: self.onPlotRevealed,
			'plotFeatureRemoved' 	: self.onPlotFeatureRemoved,
			'plotPicked'			: self.onPlotPicked,
			'nukeExplosion'			: self.onNukeExplosion,
			'gotoPlotSet'			: self.onGotoPlotSet,
			'BeginGameTurn'			: self.onBeginGameTurn,
			'EndGameTurn'			: self.onEndGameTurn,
			'BeginPlayerTurn'		: self.onBeginPlayerTurn,
			'EndPlayerTurn'			: self.onEndPlayerTurn,
			'endTurnReady'			: self.onEndTurnReady,
			'combatResult' 			: self.onCombatResult,
		  'combatLogCalc'	 		: self.onCombatLogCalc,
		  'combatLogHit'				: self.onCombatLogHit,
			'improvementBuilt' 		: self.onImprovementBuilt,
			'improvementDestroyed' 		: self.onImprovementDestroyed,
			'routeBuilt' 		: self.onRouteBuilt,
			'firstContact' 			: self.onFirstContact,
			'cityBuilt' 			: self.onCityBuilt,
			'cityRazed'				: self.onCityRazed,
			'cityAcquired' 			: self.onCityAcquired,
			'cityAcquiredAndKept' 	: self.onCityAcquiredAndKept,
			'cityLost'				: self.onCityLost,
			'cultureExpansion' 		: self.onCultureExpansion,
			'cityGrowth' 			: self.onCityGrowth,
			'cityDoTurn' 			: self.onCityDoTurn,
			'cityBuildingUnit'	: self.onCityBuildingUnit,
			'cityBuildingBuilding'	: self.onCityBuildingBuilding,
			'cityRename'				: self.onCityRename,
			'cityHurry'				: self.onCityHurry,
			'selectionGroupPushMission'		: self.onSelectionGroupPushMission,
			'unitMove' 				: self.onUnitMove,
			'unitSetXY' 			: self.onUnitSetXY,
			'unitCreated' 			: self.onUnitCreated,
			'unitBuilt' 			: self.onUnitBuilt,
			'unitKilled'			: self.onUnitKilled,
			'unitLost'				: self.onUnitLost,
			'unitPromoted'			: self.onUnitPromoted,
			'unitSelected'			: self.onUnitSelected, 
			'UnitRename'				: self.onUnitRename,
			'unitPillage'				: self.onUnitPillage,
			'unitSpreadReligionAttempt'	: self.onUnitSpreadReligionAttempt,
			'unitGifted'				: self.onUnitGifted,
			'unitBuildImprovement'				: self.onUnitBuildImprovement,
			'goodyReceived'			: self.onGoodyReceived,
			'greatPersonBorn'	  	: self.onGreatPersonBorn,
			'buildingBuilt' 		: self.onBuildingBuilt,
			'projectBuilt' 			: self.onProjectBuilt,
			'techAcquired'			: self.onTechAcquired,
			'techSelected'			: self.onTechSelected,
			'religionFounded'		: self.onReligionFounded,
			'religionSpread'		: self.onReligionSpread, 
			'religionRemove'		: self.onReligionRemove, 
			'corporationFounded'	: self.onCorporationFounded,
			'corporationSpread'		: self.onCorporationSpread, 
			'corporationRemove'		: self.onCorporationRemove, 
			'goldenAge'				: self.onGoldenAge,
			'endGoldenAge'			: self.onEndGoldenAge,
			'chat' 					: self.onChat,
			'victory'				: self.onVictory,
			'vassalState'			: self.onVassalState,
			'changeWar'				: self.onChangeWar,
			'setPlayerAlive'		: self.onSetPlayerAlive,
			'playerChangeStateReligion'		: self.onPlayerChangeStateReligion,
			'playerGoldTrade'		: self.onPlayerGoldTrade,
			'windowActivation'		: self.onWindowActivation,
			'gameUpdate'			: self.onGameUpdate,		# sample generic event
		}

		# Events List #
		#
		# Dictionary of Events, indexed by EventID (also used at popup context id)
		#   entries have name, beginFunction, applyFunction [, randomization weight...]
		#
		# Normal events first, random events after
		#	
		# Events List #
		self.Events={
			CvUtil.EventEditCityName : ('EditCityName', self.__eventEditCityNameApply, self.__eventEditCityNameBegin),
			CvUtil.EventPlaceObject : ('PlaceObject', self.__eventPlaceObjectApply, self.__eventPlaceObjectBegin),
			CvUtil.EventAwardTechsAndGold: ('AwardTechsAndGold', self.__eventAwardTechsAndGoldApply, self.__eventAwardTechsAndGoldBegin),
			CvUtil.EventEditUnitName : ('EditUnitName', self.__eventEditUnitNameApply, self.__eventEditUnitNameBegin),
## Platy Builder ##
			CvUtil.EventWBLandmarkPopup : ('WBLandmarkPopup', self.__eventWBLandmarkPopupApply, self.__eventWBScriptPopupBegin),
			CvUtil.EventShowWonder: ('ShowWonder', self.__eventShowWonderApply, self.__eventShowWonderBegin),
			1111 : ('WBPlayerScript', self.__eventWBPlayerScriptPopupApply, self.__eventWBScriptPopupBegin),
			2222 : ('WBCityScript', self.__eventWBCityScriptPopupApply, self.__eventWBScriptPopupBegin),
			3333 : ('WBUnitScript', self.__eventWBUnitScriptPopupApply, self.__eventWBScriptPopupBegin),
			4444 : ('WBGameScript', self.__eventWBGameScriptPopupApply, self.__eventWBScriptPopupBegin),
			5555 : ('WBPlotScript', self.__eventWBPlotScriptPopupApply, self.__eventWBScriptPopupBegin),
## Platy Builder ##
		}	
# EVENT STARTERS #
	def handleEvent(self, argsList):
		'EventMgr entry point'
		# extract the last 6 args in the list, the first arg has already been consumed
		self.origArgsList = argsList	# point to original
		tag = argsList[0]				# event type string
		idx = len(argsList)-6
		bDummy = false
		self.bDbg, bDummy, self.bAlt, self.bCtrl, self.bShift, self.bAllowCheats = argsList[idx:]
		ret = 0
		if self.EventHandlerMap.has_key(tag):
			fxn = self.EventHandlerMap[tag]
			ret = fxn(argsList[1:idx])
		return ret
		
# EVENT APPLY #	
	def beginEvent( self, context, argsList=-1 ):
		'Begin Event'
		entry = self.Events[context]
		return entry[2]( argsList )
	
	def applyEvent( self, argsList ):
		'Apply the effects of an event '
		context, playerID, netUserData, popupReturn = argsList
		
		if context == CvUtil.PopupTypeEffectViewer:
			return CvDebugTools.g_CvDebugTools.applyEffectViewer( playerID, netUserData, popupReturn )
		
		entry = self.Events[context]
				
		if ( context not in CvUtil.SilentEvents ):
			self.reportEvent(entry, context, (playerID, netUserData, popupReturn) )
		return entry[1]( playerID, netUserData, popupReturn )   # the apply function

	def reportEvent(self, entry, context, argsList):
		'Report an Event to Events.log '
		if (gc.getGame().getActivePlayer() != -1):
			message = "DEBUG Event: %s (%s)" %(entry[0], gc.getActivePlayer().getName())
			CyInterface().addImmediateMessage(message,"")
			CvUtil.pyPrint(message)
		return 0
		
# ON EVENTS #
	# rucivfan_profile_help rph[
	#@profile_help.profile_func(output_dir="test",  mode="a", strip_dirs=True, sort_by="time") 
	# ]rucivfan_profile_help rph
	def onKbdEvent(self, argsList):
		'keypress handler - return 1 if the event was consumed'

		eventType,key,mx,my,px,py = argsList
		game = gc.getGame()
		
		if (self.bAllowCheats):
			# notify debug tools of input to allow it to override the control
			argsList = (eventType,key,self.bCtrl,self.bShift,self.bAlt,mx,my,px,py,gc.getGame().isNetworkMultiPlayer())
			if ( CvDebugTools.g_CvDebugTools.notifyInput(argsList) ):
				pass
				#return 0
		
		if ( eventType == self.EventKeyDown ):
			theKey=int(key)
			
			CvCameraControls.g_CameraControls.handleInput( theKey )
			
			if (self.bAllowCheats):
				# Shift - T (Debug - No MP)
				if (theKey == int(InputTypes.KB_T)):
					if ( self.bShift ):
						self.beginEvent(CvUtil.EventAwardTechsAndGold)
						#self.beginEvent(CvUtil.EventCameraControlPopup)
						#return 1
							
				elif (theKey == int(InputTypes.KB_W)):
					if ( self.bShift and self.bCtrl):
						self.beginEvent(CvUtil.EventShowWonder)
						#return 1
							
				# Shift - ] (Debug - currently mouse-overd unit, health += 10
				elif (theKey == int(InputTypes.KB_LBRACKET) and self.bShift ):
					unit = CyMap().plot(px, py).getUnit(0)
					if ( not unit.isNone() ):
						d = min( unit.maxHitPoints()-1, unit.getDamage() + 10 )
						unit.setDamage( d, PlayerTypes.NO_PLAYER )
					
				# Shift - [ (Debug - currently mouse-overd unit, health -= 10
				elif (theKey == int(InputTypes.KB_RBRACKET) and self.bShift ):
					unit = CyMap().plot(px, py).getUnit(0)
					if ( not unit.isNone() ):
						d = max( 0, unit.getDamage() - 10 )
						unit.setDamage( d, PlayerTypes.NO_PLAYER )
					
				elif (theKey == int(InputTypes.KB_F1)):
					if ( self.bShift ):
						CvScreensInterface.replayScreen.showScreen(False)
						#return 1
					# don't return 1 unless you want the input consumed
				
				elif (theKey == int(InputTypes.KB_F2)):
					if ( self.bShift ):
						import CvDebugInfoScreen
						CvScreensInterface.showDebugInfoScreen()
						#return 1
				
				elif (theKey == int(InputTypes.KB_F3)):
					if ( self.bShift ):
						CvScreensInterface.showDanQuayleScreen(())
						#return 1
						
				elif (theKey == int(InputTypes.KB_F4)):
					if ( self.bShift ):
						CvScreensInterface.showUnVictoryScreen(())
						#return 1
											
		#return 0

	def onModNetMessage(self, argsList):
		'Called whenever CyMessageControl().sendModNetMessage() is called - this is all for you modders!'
		
		iData1, iData2, iData3, iData4, iData5 = argsList
		
		print("Modder's net message!")
		
		CvUtil.pyPrint( 'onModNetMessage' )

# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung START ----------------------------------------------------------------------------------------------------------------------------
		if iData1 == 777:
		
			iPlayer = iData2
			pPlayer = gc.getPlayer(iData2)
			pTeam = CyGlobalContext().getTeam(pPlayer.getTeam())
			
			if not CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(iData4):
				iTechCost = pTeam.getResearchCost(iData4)
				iXPlayerNum = 0
				for iXPlayer in xrange(CyGlobalContext().getMAX_CIV_PLAYERS()):
					pXPlayer = CyGlobalContext().getPlayer(iXPlayer)
					if pXPlayer.isAlive() and pXPlayer.getTeam() == pPlayer.getTeam():
						iXPlayerNum += 1
				pTeam.changeResearchProgress(iData4, (iTechCost / iXPlayerNum), iData2)
				if (pTeam.getResearchCost(iData4) - pTeam.getResearchProgress(iData4)) == 1: pTeam.changeResearchProgress(iData4, 1, iData2)
				# Bei ontechacquired
				# if iData4 == CyGlobalContext().getInfoTypeForString('TECH_THE_WHEEL'):
					# (loopUnit, iter) = pPlayer.firstUnit(False)
					# while(loopUnit):
						# if loopUnit.getUnitType() == CyGlobalContext().getInfoTypeForString('UNIT_SETTLER'):
							# loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MOBILITY"),True)
						# (loopUnit, iter) = pPlayer.nextUnit(iter, False)
				
				# neuer Popup:
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
				popupInfo.setText(CyTranslator().getText("TXT_KEY_SELECT_TECH2",()))
				popupInfo.setData1(iData2)
				popupInfo.setData2(iData3)
				# popupInfo.setData3(iData4)
				popupInfo.setOnClickedPythonCallback("selectTech2")
				szText = CyTranslator().getText("TXT_KEY_TECH_MINING", ())
				if CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(CyGlobalContext().getInfoTypeForString('TECH_MINING')):
					szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
				popupInfo.addPythonButton(szText, "")
				szText = CyTranslator().getText("TXT_KEY_TECH_FISHING", ())
				if CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(CyGlobalContext().getInfoTypeForString('TECH_FISHING')):
					szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
				popupInfo.addPythonButton(szText, "")
				szText = CyTranslator().getText("TXT_KEY_TECH_HUNTING", ())
				if CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(CyGlobalContext().getInfoTypeForString('TECH_HUNTING')):
					szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
				popupInfo.addPythonButton(szText, "")
				szText = CyTranslator().getText("TXT_KEY_TECH_AGRICULTURE", ())
				if CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(CyGlobalContext().getInfoTypeForString('TECH_AGRICULTURE')):
					szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
				popupInfo.addPythonButton(szText, "")
				szText = CyTranslator().getText("TXT_KEY_TECH_THE_WHEEL", ())
				if CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(CyGlobalContext().getInfoTypeForString('TECH_THE_WHEEL')):
					szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
				popupInfo.addPythonButton(szText, "")
				popupInfo.addPopup(iData2)
			else:
				self.starttechpopup(iData2, iData3)

		if iData1 == 778:

			iPlayer = iData2
			pPlayer = gc.getPlayer(iData2)
			pTeam = CyGlobalContext().getTeam(pPlayer.getTeam())
			
			if not CyGlobalContext().getTeam(pPlayer.getTeam()).isHasTech(iData4):
				iTechCost = pTeam.getResearchCost(iData4)
				iXPlayerNum = 0
				for iXPlayer in xrange(CyGlobalContext().getMAX_CIV_PLAYERS()):
					pXPlayer = CyGlobalContext().getPlayer(iXPlayer)
					if pXPlayer.isAlive() and pXPlayer.getTeam() == pPlayer.getTeam():
						iXPlayerNum += 1
				pTeam.changeResearchProgress(iData4, (iTechCost / iXPlayerNum), iData2)
				if (pTeam.getResearchCost(iData4) - pTeam.getResearchProgress(iData4)) == 1: pTeam.changeResearchProgress(iData4, 1, iData2)
				# Bei ontechacquired
				# if iData4 == CyGlobalContext().getInfoTypeForString('TECH_THE_WHEEL'):
					# (loopUnit, iter) = pPlayer.firstUnit(False)
					# while(loopUnit):
						# if loopUnit.getUnitType() == CyGlobalContext().getInfoTypeForString('UNIT_SETTLER'):
							# loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MOBILITY"),True)
						# (loopUnit, iter) = pPlayer.nextUnit(iter, False)
			else:
				self.starttechpopup2(iData2, iData3)	
				
# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung END ----------------------------------------------------------------------------------------------------------------------------
###### Cybah: BASE - Unit Buttons START ----------------------------------------------------------------------------------------------------------------------------

		#iData1 = iMessageID (!)

		# Deaktiviert
		# # < ---- Aufstndische untersttzen ---->
   		# if iData1 == 9000:
			# iPlayer = iData4
			# pPlayer = gc.getPlayer(iData4)
			# pUnit = pPlayer.getUnit(iData5)
			
			# if pUnit and not pUnit.isNone() and not gc.getGame().isPbem() and not gc.getGame().isNetworkMultiPlayer() and not gc.getGame().isGameMultiPlayer() and not gc.getGame().isPitboss():			
				# iUnitType = pUnit.getUnitType()
				# iUnitOwnerTeam = pPlayer.getTeam()
				# pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)

				# l_Victims = []
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# iTeamX = pPlayerX.getTeam()
					# if pPlayerX.isAlive() and pUnitOwnerTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID():
						# pCity, iter = pPlayerX.firstCity(false)
						# while(pCity):
							# if not pCity.isNone() and pCity.getOwner() == pPlayerX.getID() and ((pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()) - pCity.happyLevel()) > 0 and not pPlayerX in l_Victims and not pPlayerX.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_GREAT_WALL")) > 0:
								# l_Victims.append(pPlayerX)
							# pCity, iter = pPlayerX.nextCity(iter, false)
				# if len(l_Victims) >= 1:
					# iVictimPlayer = CyGame().getSorenRandNum(len(l_Victims), "Random Victim")
					# pVictimPlayer = l_Victims[iVictimPlayer]
					# pCity, iter = pVictimPlayer.firstCity(false)
					# while(pCity):
						# if not pCity.isNone() and pCity.getOwner() == pVictimPlayer.getID() and ((pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()) - pCity.happyLevel()) > 0:
							# iRebels = min((pCity.getPopulation() - 1), ((pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()) - pCity.happyLevel()))

							# # rucivfan_conscript_extended rce[
							# #iConscriptUnit = pCity.getConscriptUnit()
							# iConscriptUnit = pCity.getConscriptUnit(true)	# true fr keine reinen Verteidigungseinheiten
							# # ]rucivfan_conscript_extended rce
							
							# iX = pCity.getX()
							# iY = pCity.getY()
							# spawnX = []
							# spawnY = []
							# for iXLoop in xrange(iX - 1, iX + 2):
								# for iYLoop in xrange(iY - 1, iY + 2):
									# pPlot = CyMap().plot(iXLoop, iYLoop)
									# if not pPlot.isCity() and not pPlot.isWater() and not pPlot.isImpassable():
										# spawnX.append(iXLoop)
										# spawnY.append(iYLoop)
							# spawn = CyGame().getSorenRandNum(len(spawnX), "where")
							# bPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
							# if spawn and bPlayer and iRebels > 0:
								# for i in xrange(iRebels):
									# pNewUnit = bPlayer.initUnit( iConscriptUnit, spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK, DirectionTypes.NO_DIRECTION )
								# pCity.changePopulation(-iRebels)
						# pCity, iter = pVictimPlayer.nextCity(iter, false)
					# pUnit.kill(False, -1)

		# < ---- Attentter beauftragen ---->
		# DEAKTIVIERT (eigentlich 9000)
   		if iData1 == 9999:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():			
				iUnitType = pUnit.getUnitType()
				iUnitOwnerTeam = pPlayer.getTeam()
				pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)

				# Kosten
				iBaseGold = (1000 * (pPlayer.getCurrentEra() +1))
				estiEnd = CyGame().getEstimateEndTurn()
				if estiEnd >= 1000:
					iBaseGold *= 2
					iAnarchy = 10
				elif estiEnd >= 700:
					iBaseGold *= 7
					iBaseGold /= 5
					iAnarchy = 7
				elif estiEnd >= 500:
					iBaseGold *= 1
					iAnarchy = 5
				elif estiEnd >= 300:
					iBaseGold *= 3
					iBaseGold /= 5
					iAnarchy = 3

				# Wenn genug Gold vorhanden
				if pPlayer.getGold() >= iBaseGold:
					# test
					# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iBaseGold,iBaseGold,)),'',0,'',-1,-1,-1,false,false)
					l_Victims = []
					for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
						pPlayerX = gc.getPlayer(iPlayerX)
						iTeamX = pPlayerX.getTeam()
						if pPlayerX.isAlive() and pUnitOwnerTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID() and not pPlayerX.isGoldenAge() and not pPlayerX.isAnarchy():
							l_Victims.append(pPlayerX)

					# Wenn Opfer vorhanden
					if len(l_Victims) > 0:
						# test
						# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(len(l_Victims),len(l_Victims),)),'',0,'',-1,-1,-1,false,false)
						iVictimPlayer = CyGame().getSorenRandNum(len(l_Victims), "Random Victim")
						pVictimPlayer = l_Victims[iVictimPlayer]
						pVictimPlayer.changeAnarchyTurns( iAnarchy )
						pPlayer.changeGold( -iBaseGold )
						pUnit.kill(False, -1)

		# < ---- Entwicklungshilfe ---->
   		if iData1 == 9001:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():			
				iUnitType = pUnit.getUnitType()
				iUnitOwnerTeam = pPlayer.getTeam()
				pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
				
				iAidTechResearch = 0
				l_AidTechs = []
				for iTechX in xrange(gc.getNumTechInfos()):
					bTechXKnownTeam = False
					iTechXCount = 0
					if pUnitOwnerTeam.isHasTech(iTechX) or not gc.getTechInfo(iTechX).isTrade(): continue
					for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
						pTeamX = gc.getTeam(iTeamX)
						if pTeamX.isAlive():
							if pTeamX.isHasTech(iTechX):
								iTechXCount += 1
								if pUnitOwnerTeam.isHasMet(iTeamX):
									bTechXKnownTeam = True
					# Hlfte aller Spieler muss die Tech haben
					if bTechXKnownTeam == True and iTechXCount >= ((gc.getGame().countCivTeamsAlive() + 1) / 2):
						# Tech zur Liste der mglichen Techs hinzufgen
						l_AidTechs.append(iTechX)

				if len(l_AidTechs) > 3:
					# BASE 6.1 F - Kill nach hier oben verschoben, weil anders kein Staatsmann bei rawechsel durch Entwicklungshilfe erschienen ist
					pUnit.kill(False, -1)
					for iTech in xrange(len(l_AidTechs)):
						# 33% der verbleibenden Kolben
						iTechKolben = (pUnitOwnerTeam.getResearchLeft(l_AidTechs[iTech]) / 3)
						pUnitOwnerTeam.changeResearchProgress(l_AidTechs[iTech], iTechKolben, iPlayer)

		# < ---- Frieden stiften ---->
   		if iData1 == 9002:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				iUnitOwnerTeam = pPlayer.getTeam()
				pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
				bDone = 0

				# # Reparationszahlungen - DEAKTIVIERT
				# l_Players = []
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# iTeamX = pPlayerX.getTeam()
					# if pPlayerX.isAlive() and pUnitOwnerTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID():

						# iWarWearinessPercentAnger = pUnitOwnerTeam.getWarWeariness(iTeamX) * max(0, 100 + pUnitOwnerTeam.getEnemyWarWearinessModifier())

						# iWarWearinessPercentAnger *= gc.getDefineINT("BASE_WAR_WEARINESS_MULTIPLIER")

						# if (gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ALWAYS_WAR) or gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CHANGING_WAR_PEACE)):
							# iWarWearinessPercentAnger *= max(0, (gc.getDefineINT("FORCED_WAR_WAR_WEARINESS_MODIFIER") + 100))
							# iWarWearinessPercentAnger /= 100

						# if gc.getGame().isGameMultiPlayer():
							# iWarWearinessPercentAnger *= max(0, (gc.getDefineINT("MULTIPLAYER_WAR_WEARINESS_MODIFIER") + 100))

						# iWarWearinessPercentAnger *= max(0, (gc.getWorldInfo(gc.getMap().getWorldSize()).getWarWearinessModifier() + 100))
						# iWarWearinessPercentAnger /= 100

						## rucivfan_ai_auto_play raap[
						## if not pPlayer.isHuman() and not pPlayer.isBarbarian() and not pPlayer.isMinorCiv():
						# if not pPlayer.isHumanActive() and not pPlayer.isBarbarian() and not pPlayer.isMinorCiv():
						## ]rucivfan_ai_auto_play raap
							# iWarWearinessPercentAnger *= gc.getHandicapInfo(gc.getGame().getHandicapType()).getAIWarWearinessPercent()
							# iWarWearinessPercentAnger /= 100

							# iWarWearinessPercentAnger *= max(0, ((gc.getHandicapInfo(gc.getGame().getHandicapType()).getAIPerEraModifier() * pPlayer.getCurrentEra()) + 100))
							# iWarWearinessPercentAnger /= 100

						# if (iWarWearinessPercentAnger / 10000 > 0):
							# iWarWearinessPercentAnger /= 10000

							# # test
							# # CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iWarWearinessPercentAnger,iWarWearinessPercentAnger,)),'',0,'',-1,-1,-1,false,false)

							# iWWGold = min(iWarWearinessPercentAnger, pPlayerX.getGold())
							# if iWWGold > 0 and not pPlayerX in l_Players:
								# pPlayer.changeGold(iWWGold)
								# pPlayerX.changeGold(-iWWGold)
								# l_Players.append(pPlayerX)

				# Kriegsmdigkeit nachtrglich halbieren
				for iTeamY in xrange(gc.getMAX_CIV_TEAMS()):
					iWarW = pUnitOwnerTeam.getWarWeariness(iTeamY)
					pUnitOwnerTeam.setWarWeariness(iTeamY, (iWarW /2))

				# Frieden erzwingen
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					iTeamX = pPlayerX.getTeam()
					pTeamX = gc.getTeam(iTeamX)
					if pPlayerX.isAlive() and pUnitOwnerTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID() and (pTeamX.getPower(True) < (pUnitOwnerTeam.getPower(True) * 2)) and not pTeamX.isAVassal():

						# DEAKTIVIERT
						# # Eine selbst gegrndete und verlorene Stadt je Feind zurckgeben
						# l_AcquireCities = []
						# pCity, iter = pPlayerX.firstCity(false)
						# while(pCity):
							# if not pCity.isNone() and pCity.getOwner() == pPlayerX.getID() and pCity.getOriginalOwner() == pPlayer.getID():
								# l_AcquireCities.append(pCity)							
							# pCity, iter = pPlayerX.nextCity(iter, false)

						# # Wenn zurckgebbare Stdte vorhanden
						# if len(l_AcquireCities) > 0:
							# # test
							# # CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(len(l_AcquireCities),len(l_AcquireCities),)),'',0,'',-1,-1,-1,false,false)
							# iAcquireCity = CyGame().getSorenRandNum(len(l_AcquireCities), "Random City")
							# pAcquireCity = l_AcquireCities[iAcquireCity]
							# pPlayer.acquireCity(pAcquireCity, False, True)

						# Friedensschluss
						pPlayerX.forcePeace(iPlayer)
						bDone = 1

				# Einheit auflsen und Scoreboard aktualisieren
				if bDone > 0:
					CyInterface().toggleScoresMinimized() # to reload the scores 1/2
						# pUnit.getGroup().setActivityType(-1) # to reload the map
					# pUnit.finishMoves()
					pUnit.kill(False, -1)
					CyInterface().toggleScoresMinimized() # to reload the scores 2/2

		# MOBILISIEREN IST DEAKTIVIERT
		# # < ---- Mobilisieren ---->
   		# elif iData1 == 9003:
			# iPlayer = iData4
			# pPlayer = gc.getPlayer(iData4)
			# pUnit = pPlayer.getUnit(iData5)
			
			# if pUnit and not pUnit.isNone():			
				# iUnitOwnerTeam = pPlayer.getTeam()
				# pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)
				
				# pCity, iter = pPlayer.firstCity(false)  
				# while(pCity):
					# if not pCity.isNone() and pCity.getOwner() == pPlayer.getID():
		
						# # rucivfan_conscript_extended rce[
						# #if pCity.getPopulation() >= (pCity.getConscriptPopulation() + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) and pCity.calculateTeamCulturePercent(iUnitOwnerTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():
						# #	iConscriptUnit = pCity.getConscriptUnit()
						# #	pNewUnit = pPlayer.initUnit( iConscriptUnit, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# #	pCity.addProductionExperience(pNewUnit, false)
						# #	pCity.changePopulation(-pCity.getConscriptPopulation())

						# # Hinweis: intern ruft getConscriptPopulation getConscriptUnit auf! -> iConscriptUnit = pCity.getConscriptUnit(true) wird vor if-Abfrage verschoben aus Optimierungsgrnden
						# # iConscriptUnit kann direkt getConscriptPopulation bergeben werden ohne das intern getConscriptUnit aufgerufen wird.
						# # (pCity.getConscriptPopulation(iConscriptUnit, true) + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) ist gleich pCity.conscriptMinCityPopulation(iConscriptUnit, true)!
						# iConscriptUnit = pCity.getConscriptUnit(false)	# true fr keine reinen Verteidigungseinheiten
						# if pCity.getPopulation() >= pCity.conscriptMinCityPopulation(iConscriptUnit, false) and pCity.calculateTeamCulturePercent(iUnitOwnerTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():
							# pNewUnit = pPlayer.initUnit( iConscriptUnit, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pCity.addProductionExperience(pNewUnit, false)
							# pCity.changePopulation(-pCity.getConscriptPopulation(iConscriptUnit, false))
						# # ]rucivfan_conscript_extended rce							

							# iAnger = gc.getDefineINT("CONSCRIPT_ANGER_DIVISOR")
							# iAnger *= gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getHurryConscriptAngerPercent()
							# iAnger /= 100 
							# # if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_REPRESSIVE")): iAnger /= 2
							# iConscriptAngerTimer = max(1, iAnger)
							# pCity.changeConscriptAngerTimer(iConscriptAngerTimer)
							# pCity.setDrafted(1)

							# # test
							# # CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",((((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent())) / gc.getDefineINT("CONSCRIPT_POPULATION_PER_COST")),iPopLoss,)),'',0,'',-1,-1,-1,false,false)

					# pCity, iter = pPlayer.nextCity(iter, false)
				# pUnit.setDamage(100, False)

		# < ---- Rede an die Nation ---->
   		elif iData1 == 9004:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
			
				pCity, iter = pPlayer.firstCity(false)  
				while(pCity):
					if not pCity.isNone() and pCity.getOwner() == pPlayer.getID():
						pCity.changeHappinessTimer(pPlayer.getGoldenAgeLength() * 2)
						iTheSpeed = CyGame().getGameSpeedType()
						TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
						iTrainPercent = TheSpeed.getTrainPercent()
						# Marathonmodifikator +50 weil Einheiten nur 200, Gebude 300
						if iTrainPercent == 200: iTrainPercent += 50
						iRedeProd = ((pPlayer.getCurrentEra() + 1) * pCity.getPopulation() * iTrainPercent / 100)
						# Modifikator fr 1.5 Prod
						iRedeProd *= 3
						iRedeProd /= 2
						if pCity.isProductionBuilding() or pCity.isProductionProject() or pCity.isProductionUnit(): pCity.changeProduction(iRedeProd)
						else: pPlayer.changeGold(iRedeProd)
					pCity, iter = pPlayer.nextCity(iter, false)
				(loopUnit, iter) = pPlayer.firstUnit(False)
				while(loopUnit):
					if loopUnit.getUnitCombatType() > -1 and (loopUnit.airBaseCombatStr() > 0 or loopUnit.baseCombatStr() > 0):
						if loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_ALIEN' ) and loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_MISC' ):
							loopUnit.changeExperience(1, -1, False, False, False)
						# Alte Effekte
						#if loopUnit.getDamage() == 0:
							#if loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_ALIEN' ) and loopUnit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_MISC' ):
								#loopUnit.changeExperience(1, -1, False, False, False)
						#elif loopUnit.getDamage() < 100:
							#loopUnit.setDamage(0, False)
					(loopUnit, iter) = pPlayer.nextUnit(iter, False)
				pUnit.kill(False, -1)

		# < ---- Sldner anheuern ---->
   		elif iData1 == 9005:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
			
				iUnitOwnerTeam = pPlayer.getTeam()
				pUnitOwnerTeam = gc.getTeam(iUnitOwnerTeam)

				pBestXPCity = pPlayer.getCapitalCity()
				iBestXP = 0
				pMaybeBestXPCity, iter = pPlayer.firstCity(false)
				while(pMaybeBestXPCity):
					iCityOwner = pMaybeBestXPCity.getOwner() 
					if not pMaybeBestXPCity.isNone() and iCityOwner == pPlayer.getID():
						iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
	# ZE: Zulu 2/2 Start -----------------------------------------------------------------------------------------------
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pPlayer.getID() == pMaybeBestXPCity.getOriginalOwner():
							# iXP += 5
	# ZE: Zulu 2/2 End -----------------------------------------------------------------------------------------------
						if iBestXP < iXP: 
							iBestXP = iXP
							pBestXPCity = pMaybeBestXPCity
					pMaybeBestXPCity, iter = pPlayer.nextCity(iter, false)

				if pBestXPCity != -1 and pPlayer.getNumCities() > 1 and pUnitOwnerTeam.isHasTech(gc.getInfoTypeForString("TECH_CURRENCY")):
					
					# rucivfan_conscript_extended rce[
					#iConscriptUnit = pBestXPCity.getConscriptUnit()
					iConscriptUnit = pBestXPCity.getConscriptUnit(true)	# true fr keine reinen Verteidigungseinheiten
					# ]rucivfan_conscript_extended rce
					
					iTheSpeed = CyGame().getGameSpeedType()
					TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
					pHandicapInfo = gc.getHandicapInfo(gc.getGame().getHandicapType())
					## rucivfan_ai_auto_play raap[
					#if pPlayer.isHuman(): iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)
					if pPlayer.isHumanActive(): iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)
					## ]rucivfan_ai_auto_play raap					
					else: iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent() * pHandicapInfo.getAIUnitCostPercent()) / 10000)

					# - Spieloption erhhte Einheitenproduktionskosten -
					if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
						if gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()) > 0:
							iEra = gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()).getEra()
						else:	
							iEra = 0
						for k in xrange(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")):
							iPrereqX = gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)
							if iPrereqX >= 0:
								iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)).getEra())
						if iEra > 5:
							iEra = 5
						iConscriptUnitCost *= 100 + iEra * 10
						iConscriptUnitCost /= 100

					# "NEW_HURRY_MODIFIER"
					# iConscriptUnitCost *= 3
					# iConscriptUnitCost /= 2

					# Gold per Production
					iConscriptUnitCost *= 3

					# Gold fr XP - 2% pro 1 XP 
					# iConscriptUnitCostTotal = (iConscriptUnitCost * (100 + (iBestXP * 2)))
					# iConscriptUnitCostTotal /= 100
					iConscriptUnitCostTotal = iConscriptUnitCost

					# Nachtrgliche BASE Modifikatoren
					# - Im Frieden 25% Rabatt -
					if not pUnitOwnerTeam.getAtWarCount(true) > 0:
						iConscriptUnitCostTotal *= 3
						iConscriptUnitCostTotal /= 4

					# - Endmodifikator zum schnellen Anpassen: 33% billiger -
					# iConscriptUnitCostTotal *= 2
					# iConscriptUnitCostTotal /= 3

					# test
					# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iConscriptUnitCost,iConscriptUnitCostTotal,)),'',0,'',-1,-1,-1,false,false)

					# 6.3 B  - auf 10 beschrnkt
					iMercs = min(10,(pPlayer.getGold() / iConscriptUnitCostTotal))
					if iMercs > 1:
						l_Cities = []
						pCity, iter = pPlayer.firstCity(false)  
						while(pCity):
							if not pCity.isNone() and pCity.getOwner() == pPlayer.getID():

								# Fehler inzwischen behoben: Absturz wenn Staatsmann in Stadt der erzeugten Einheit (deshalb setDamage anstelle kill)
								# if (pCity.getX() != pUnit.getX() or pCity.getY() != pUnit.getY()):

								l_Cities.append(pCity)
							pCity, iter = pPlayer.nextCity(iter, false)

						if len(l_Cities) >= 1:
							iCity = CyGame().getSorenRandNum(len(l_Cities), "Random City")
							pXCity = l_Cities[iCity]
							for i in xrange(iMercs):
								pNewUnit = pPlayer.initUnit( iConscriptUnit, pXCity.getX(), pXCity.getY(), UnitAITypes.UNITAI_ATTACK, DirectionTypes.NO_DIRECTION )
								pBestXPCity.addProductionExperience(pNewUnit, false)
								pPlayer.changeGold(-iConscriptUnitCostTotal)
							pUnit.setDamage(100, False)
							# pUnit.kill(False, -1)

		# < ---- Welthandelsmission ---->
   		elif iData1 == 9006:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
			
				# iWorldGold = 0	
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getID() != pPlayer.getID():
						# iWorldGold += pPlayerX.getGold()

				# if iWorldGold >= gc.getGame().countCivPlayersAlive():
					# iEveryPlayerGold = (iWorldGold / gc.getGame().countCivPlayersAlive())
				# else:
					# iEveryPlayerGold = 0

				# if iEveryPlayerGold > 0:
					# for iPlayerY in xrange(gc.getMAX_CIV_PLAYERS()):
						# pPlayerY = gc.getPlayer(iPlayerY)
						# if pPlayerY.getID() != pPlayer.getID():
							# if pPlayerY.getGold() < iEveryPlayerGold:
								# pPlayerY.AI_changeAttitudeExtra(iPlayer, 1)
							# pPlayerY.changeGold(-pPlayerY.getGold())
							# pPlayerY.changeGold(iEveryPlayerGold)

					# test
					# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",((250 * (pPlayer.getCurrentEra() +1)),(iEveryPlayerGold * 2),)),'',0,'',-1,-1,-1,false,false)
					
				# Obiger Code deaktiviert, deshalb iEveryPlayerGold = 0, sonst muss die kommende Zeile weg und der nachfolgende Code um 1 TAB erweitert werden
				iEveryPlayerGold = 0

				# 250 ab Klassik
				iBaseGold = 250				
				# Mittelalter
				if pPlayer.getCurrentEra() > 1: iBaseGold += 250
				# Renaissance
				if pPlayer.getCurrentEra() > 2: iBaseGold += 500
				# Industriezeitalter
				if pPlayer.getCurrentEra() > 3: iBaseGold += 1000
				# Moderne
				if pPlayer.getCurrentEra() > 4: iBaseGold += 2000
				# Zukunft
				if pPlayer.getCurrentEra() > 5: iBaseGold += 4000
				
				estiEnd = CyGame().getEstimateEndTurn()
				if estiEnd >= 1000:
					iBaseGold *= 2
				elif estiEnd >= 700:
					iBaseGold *= 7
					iBaseGold /= 5
				elif estiEnd >= 500:
					iBaseGold *= 1
				elif estiEnd >= 300:
					iBaseGold *= 3
					iBaseGold /= 5
				iMaxGold = 2 * iBaseGold
				iTemp1 = max(iBaseGold, iEveryPlayerGold * 2)
				iTemp2 = min(iTemp1, iMaxGold)
				pPlayer.changeGold(iTemp2)
				pUnit.kill(False, -1)

# Cybah: BASE fr 6.2 D - Philosophisch START				
		# < ---- GP: Opferung ---->
   		elif iData1 == 9007:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				if iUnitType == gc.getInfoTypeForString("UNIT_PROPHET"):
					# Cybah: BASE fr 6.3 B - abwechselnd Gold und Prod beim Propheten					
					if (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iProphet')) % 2 == 0):
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_PRIEST"), CommerceTypes.COMMERCE_GOLD, 1)
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_PRIEST"), CommerceTypes.COMMERCE_GOLD, 1)
					else:
						pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_PRIEST"), YieldTypes.YIELD_PRODUCTION, 1)
						pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_GREAT_PRIEST"), YieldTypes.YIELD_PRODUCTION, 1)
				# 6.3 B - nur noch 1x pro Typ und ra
				pUnit.kill(False, -1)
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iProphet')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iProphet', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iProphet', 1)
				
   		elif iData1 == 9008:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				if iUnitType == gc.getInfoTypeForString("UNIT_ENGINEER"):
					pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_ENGINEER"), YieldTypes.YIELD_PRODUCTION, 1)
					pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_GREAT_ENGINEER"), YieldTypes.YIELD_PRODUCTION, 1)
				pUnit.kill(False, -1)
				# 6.3 B - nur noch 1x pro Typ und ra
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iEngineer')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iEngineer', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iEngineer', 1)
				
   		elif iData1 == 9009:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()				
				if iUnitType == gc.getInfoTypeForString("UNIT_ARTIST"):
					# Cybah: BASE fr 6.3 B - abwechselnd Gold und Kultur beim Knstler				
					if (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iArtist')) % 2 == 0):
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_ARTIST"), CommerceTypes.COMMERCE_GOLD, 1)
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_GOLD, 1)
					else:
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_ARTIST"), CommerceTypes.COMMERCE_CULTURE, 1)
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_CULTURE, 1)
				pUnit.kill(False, -1)
				# 6.3 B - nur noch 1x pro Typ und ra
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iArtist')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iArtist', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iArtist', 1)
				
   		elif iData1 == 9010:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				if iUnitType == gc.getInfoTypeForString("UNIT_MERCHANT"):
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_MERCHANT"), CommerceTypes.COMMERCE_GOLD, 1)
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_MERCHANT"), CommerceTypes.COMMERCE_GOLD, 1)
				pUnit.kill(False, -1)
				# 6.3 B - nur noch 1x pro Typ und ra
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iMerchant')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iMerchant', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iMerchant', 1)
				
   		elif iData1 == 9011:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				if iUnitType == gc.getInfoTypeForString("UNIT_SCIENTIST"):
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_SCIENTIST"), CommerceTypes.COMMERCE_RESEARCH, 1)
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_SCIENTIST"), CommerceTypes.COMMERCE_RESEARCH, 1)
				pUnit.kill(False, -1)
				# 6.3 B - nur noch 1x pro Typ und ra
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iScientist')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iScientist', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iScientist', 1)
				
   		elif iData1 == 9012:
			iPlayer = iData4
			pPlayer = gc.getPlayer(iData4)
			pUnit = pPlayer.getUnit(iData5)
			
			if pUnit and not pUnit.isNone():
				iUnitType = pUnit.getUnitType()
				if iUnitType == gc.getInfoTypeForString("UNIT_GREAT_SPY"):
					# Cybah: BASE fr 6.3 B - von 1 auf 2 erhht
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_SPY"), CommerceTypes.COMMERCE_ESPIONAGE, 2)
					pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_SPY"), CommerceTypes.COMMERCE_ESPIONAGE, 2)
				pUnit.kill(False, -1)
				# 6.3 B - nur noch 1x pro Typ und ra
				if SDTK.sdObjectExists( "Philo", pPlayer ):
					iCurrent = (max(0, SDTK.sdObjectGetVal( "Philo", pPlayer, 'iSpy')) + 1)
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iSpy', iCurrent)
				else:
					SDTK.sdObjectInit('Philo', pPlayer, {})
					SDTK.sdObjectSetVal( "Philo", pPlayer, 'iSpy', 1)
# Cybah: BASE fr 6.2 D - Philosophisch END
###### Cybah: BASE - Unit Buttons END ----------------------------------------------------------------------------------------------------------------------------

	def onInit(self, argsList):
		'Called when Civ starts up'
		CvUtil.pyPrint( 'OnInit' )
		
	def onUpdate(self, argsList):
		'Called every frame'
		fDeltaTime = argsList[0]
		
		# allow camera to be updated
		CvCameraControls.g_CameraControls.onUpdate( fDeltaTime )
		
	def onWindowActivation(self, argsList):
		'Called when the game window activates or deactivates'
		bActive = argsList[0]
		
	def onUnInit(self, argsList):
		'Called when Civ shuts down'
		CvUtil.pyPrint('OnUnInit')
	
	def onPreSave(self, argsList):
		"called before a game is actually saved"
		CvUtil.pyPrint('OnPreSave')
	
	def onSaveGame(self, argsList):
		"return the string to be saved - Must be a string"
		return ""

	def onLoadGame(self, argsList):

		#OOS logging.
		OOSLogger.doReset()
		#OOS logging.

# Cybah: BASE fr 6.1 F - Rundentimer START -----------------------------------------------------------------------------------------------
		# CyMap().plot(0, 0).setScriptData(str(CyGame().getMinutesPlayed()))
		# sTurns = str(CyGame().getGameTurn())
		# CyMap().plot(1, 1).setScriptData(sTurns)
# Cybah: BASE fr 6.1 F - Rundentimer END -----------------------------------------------------------------------------------------------
# Expansive Trait Start -----------------------------------------------------------------------------------------------
		if gc.getGame().getReadSaveBaseVersion() < 60003:
			for iPlayer in xrange(gc.getMAX_PLAYERS()):
				pPlayer = gc.getPlayer(iPlayer)
				if pPlayer and not pPlayer.isNone() and pPlayer.isAlive():
					if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_EXPANSIVE")):
						pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GRANARY"), -1)
						pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), -1)
						pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_LIGHTHOUSE"), -1)
						pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_SUPERMARKET"), -1)
# Expansive Trait End -----------------------------------------------------------------------------------------------
# Feldermodifikationen START -----------------------------------------------------------------------------------------------
		MapH = CyMap().getGridHeight()
		MapW = CyMap().getGridWidth()
		for i in xrange (MapW):
			for j in xrange (MapH):
				pPlot = CyMap().plot(i, j)
# Savannen am Fluss in Schwemmland umwandeln Start -----------------------------------------------------------------------------------------------
				if (pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_SAVANNA' ) and pPlot.isRiver()):
				# if (pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_SAVANNA' )):
					pPlot.setFeatureType(-1, 0)
					if pPlot.canHaveFeature(gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' )):
						pPlot.setFeatureType(gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' ), 1)
# Savannen am Fluss in Schwemmland umwandeln End -----------------------------------------------------------------------------------------------
# Feldermodifikationen END -----------------------------------------------------------------------------------------------
		CvAdvisorUtils.resetNoLiberateCities()
		return 0

	def onGameStart(self, argsList):
		'Called at the start of the game'

		#OOS logging.
		OOSLogger.doReset()
		#OOS logging.

		#Starting points part 2 start#
		StartingPoints.onGameStart(argsList)
		#Starting points part 2 end#

# Cybah: BASE fr 6.1 F - Rundentimer START -----------------------------------------------------------------------------------------------
		# if (gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR")):
			# CyMap().plot(0, 0).setScriptData(str(CyGame().getMinutesPlayed()))
			# sTurns = str(CyGame().getGameTurn())
			# CyMap().plot(1, 1).setScriptData(sTurns)
# Cybah: BASE fr 6.1 F - Rundentimer END -----------------------------------------------------------------------------------------------
# Test Ressourcenzhler
		# BonusFoodEarly = [gc.getInfoTypeForString("BONUS_CORN"), gc.getInfoTypeForString("BONUS_RICE"), gc.getInfoTypeForString("BONUS_WHEAT"), gc.getInfoTypeForString("BONUS_COW"), gc.getInfoTypeForString("BONUS_BISON"), gc.getInfoTypeForString("BONUS_PIG"), gc.getInfoTypeForString("BONUS_SHEEP"), gc.getInfoTypeForString("BONUS_CLAM"), gc.getInfoTypeForString("BONUS_CRAB"), gc.getInfoTypeForString("BONUS_SHRIMP"), gc.getInfoTypeForString("BONUS_FISH"), gc.getInfoTypeForString("BONUS_DEER")]
		# BonusFoodEarlyGood = [gc.getInfoTypeForString("BONUS_CORN"), gc.getInfoTypeForString("BONUS_RICE"), gc.getInfoTypeForString("BONUS_COW"), gc.getInfoTypeForString("BONUS_BISON"), gc.getInfoTypeForString("BONUS_PIG"), gc.getInfoTypeForString("BONUS_SHRIMP"), gc.getInfoTypeForString("BONUS_FISH"), gc.getInfoTypeForString("BONUS_DEER")]
		# BonusHappyEarly = [gc.getInfoTypeForString("BONUS_PEARLS"), gc.getInfoTypeForString("BONUS_FUR"), gc.getInfoTypeForString("BONUS_GEMS"), gc.getInfoTypeForString("BONUS_GOLD"), gc.getInfoTypeForString("BONUS_SILVER"), gc.getInfoTypeForString("BONUS_IVORY")]
		# BonusStrategicEarly = [gc.getInfoTypeForString("BONUS_COPPER"), gc.getInfoTypeForString("BONUS_IRON"), gc.getInfoTypeForString("BONUS_HORSE")]
		# BonusStrategicMid = [gc.getInfoTypeForString("BONUS_IVORY"), gc.getInfoTypeForString("BONUS_SALPETER")]
		# BonusStrategicLate = [gc.getInfoTypeForString("BONUS_ALUMINUM"), gc.getInfoTypeForString("BONUS_COAL"), gc.getInfoTypeForString("BONUS_OIL"), gc.getInfoTypeForString("BONUS_URANIUM"), gc.getInfoTypeForString("BONUS_RARE_EARTH_ELEMENTS")]
		# #BonusFoodLate = 
		# #BonusHappyLate = 

		# pActivePlayer = gc.getActivePlayer()
		# iActivePlayer = pActivePlayer.getID()
		# if pActivePlayer:
			# pPlot = pActivePlayer.getStartingPlot()
			# iRessourcenTotal = 0
			# iRessourcenEarly = 0
			# iRessourcenLate = 0
			# iX = pPlot.getX()
			# iY = pPlot.getY()
			# for x in xrange (iX - 2, iX + 3):
				# for y in xrange (iY - 2, iY + 3):
					# pPlotX = CyMap().plot(x,y)
					# if plotDistance(pPlot.getX(), pPlot.getY(), pPlotX.getX(), pPlotX.getY()) < 3:
						# if pPlotX.getBonusType(-1) != -1:
							# CyInterface().addMessage(iActivePlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(pPlotX.getX(),pPlotX.getY())),'',0,'',-1,-1,-1,false,false)
							# iRessourcenTotal += 1
							# iRessourcenEarly += 1
							# if pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_BANANA') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_DYE') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_INCENSE') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_SILK') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_SPICES') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_SUGAR') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_WINE') or pPlotX.getBonusType(-1) == gc.getInfoTypeForString('BONUS_WHALE'):
								# iRessourcenLate += 1
								# iRessourcenEarly -= 1
				
			# CyInterface().addMessage(iActivePlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iRessourcenTotal,iRessourcenEarly,iRessourcenLate,pPlot.getX(),pPlot.getY())),'',0,'',-1,-1,-1,false,false)	

				# # if pPlot.isNone(): continue
				# # if pPlot.isWater(): continue
				# # if pPlot.isImpassable(): continue
				# # if pPlot.getOwner() == iPlayer:	
# Test Ressourcenzhler

		if (gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR") and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ADVANCED_START)):
			for iPlayer in xrange(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				## rucivfan_ai_auto_play raap[
				#if (player.isAlive() and player.isHuman()):
				if (player.isAlive() and player.isHumanActive()):
				## ]rucivfan_ai_auto_play raap				
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
					popupInfo.setText(u"showDawnOfMan")
					popupInfo.addPopup(iPlayer)
		if not gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR") or gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ADVANCED_START):
			CyInterface().setSoundSelectionReady(true)

		if gc.getGame().isPbem():
			for iPlayer in xrange(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				## rucivfan_ai_auto_play raap[
				#if (player.isAlive() and player.isHuman()):
				if (player.isAlive() and player.isHumanActive()):
				## ]rucivfan_ai_auto_play raap
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_DETAILS)
					popupInfo.setOption1(true)
					popupInfo.addPopup(iPlayer)

# Feldermodifikationen START -----------------------------------------------------------------------------------------------
		MapH = CyMap().getGridHeight()
		MapW = CyMap().getGridWidth()
		for i in xrange (MapW):
			for j in xrange (MapH):
				pPlot = CyMap().plot(i, j)
# Savannen am Fluss in Schwemmland umwandeln Start -----------------------------------------------------------------------------------------------
				if (pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_SAVANNA' ) and pPlot.isRiver()):
				# if (pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_SAVANNA' )):
					pPlot.setFeatureType(-1, 0)
					if pPlot.canHaveFeature(gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' )):
						pPlot.setFeatureType(gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' ), 1)
# Savannen am Fluss in Schwemmland umwandeln End -----------------------------------------------------------------------------------------------
# 6.4 B - Wald von Wildfeldern entfernen (darf trotzdem nachwachsen, wenn man Glck hat) START ## IDEE VERWORFEN WEGEN DER KI, die holzt einfach Nachbarfelder ab
				# if (pPlot.getBonusType(-1) == gc.getInfoTypeForString('BONUS_DEER') and pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_FOREST' )):
					# pPlot.setFeatureType(-1, 0)
# 6.4 B - Wald von Wildfeldern entfernen (darf trotzdem nachwachsen, wenn man Glck hat) END -----------------------------------------------------------------------------------------------
# Feldermodifikationen END -----------------------------------------------------------------------------------------------

# Multiple Research Start -----------------------------------------------------------------------------------------------
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_AI_TECH_SUPPORT):
			CyGame().setOption(gc.getInfoTypeForString("GAMEOPTION_MULTIPLE_RESEARCH"), False)
# Multiple Research End -----------------------------------------------------------------------------------------------
# Limited Religions Start -----------------------------------------------------------------------------------------------
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_PICK_RELIGION):
			CyGame().setOption(gc.getInfoTypeForString("GAMEOPTION_LIMITED_RELIGIONS"), False)
# Limited Religions End -----------------------------------------------------------------------------------------------
# Less AI Human Contacts Start -----------------------------------------------------------------------------------------------
		# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_RUTHLESS_AI):
			# CyGame().setOption(gc.getInfoTypeForString("GAMEOPTION_LESS_AI_HUMAN_CONTACTS"), False)
# Less AI Human Contacts End -----------------------------------------------------------------------------------------------
# # Real Always War Start -----------------------------------------------------------------------------------------------
# # Ist in das SDK gewandert und GAMEOPTION_REAL_ALWAYS_WAR hat ohne GAMEOPTION_ALWAYS_WAR keine Auswirkung dort.
		# if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ALWAYS_WAR):
			# CyGame().setOption(gc.getInfoTypeForString("GAMEOPTION_REAL_ALWAYS_WAR"), False)
# # Real Always War End -----------------------------------------------------------------------------------------------

		for iPlayerLoop in xrange(gc.getMAX_CIV_PLAYERS()):
			pPlayer = gc.getPlayer(iPlayerLoop)
			iPlayer = pPlayer.getID()
			pTeam = gc.getTeam(pPlayer.getTeam())
			if pPlayer.isAlive():

# NO STARTING TECHS START -----------------------------------------------------------------------------------------------
				if (gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR") and gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_STARTING_TECHS)):
					iTech1 = gc.getInfoTypeForString("TECH_FISHING")
					iTech2 = gc.getInfoTypeForString("TECH_THE_WHEEL")
					iTech3 = gc.getInfoTypeForString("TECH_AGRICULTURE")
					iTech4 = gc.getInfoTypeForString("TECH_HUNTING")
					iTech5 = gc.getInfoTypeForString("TECH_MINING")
					pTeam.setHasTech(iTech1, false, iPlayer, false, false)
					pTeam.setHasTech(iTech2, false, iPlayer, false, false)
					pTeam.setHasTech(iTech3, false, iPlayer, false, false)
					pTeam.setHasTech(iTech4, false, iPlayer, false, false)
					pTeam.setHasTech(iTech5, false, iPlayer, false, false)
					# pTeam.setResearchProgress(iTech1, (pTeam.getResearchCost(iTech1) * 2/5), pPlayer.getID())
					# pTeam.setResearchProgress(iTech2, (pTeam.getResearchCost(iTech2) * 2/5), pPlayer.getID())
					# pTeam.setResearchProgress(iTech3, (pTeam.getResearchCost(iTech3) * 2/5), pPlayer.getID())
					# pTeam.setResearchProgress(iTech4, (pTeam.getResearchCost(iTech4) * 2/5), pPlayer.getID())
					# pTeam.setResearchProgress(iTech5, (pTeam.getResearchCost(iTech5) * 2/5), pPlayer.getID())
# NO STARTING TECHS END -----------------------------------------------------------------------------------------------
# Spiritual Trait Start ----------------------------------------------------------------------------------------------- 
				if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_SPIRITUAL")):
					iTech = gc.getInfoTypeForString("TECH_MYSTICISM")
					pTeam.setHasTech(iTech, true, iPlayer, false, false)
# Spiritual Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.2 B - ZE: Indonesien START -----------------------------------------------------------------------------------------------
				# ersetzt in 6.3 B (siehe onreligionfounded)
				# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA") and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS):
					# pTeam.setHasTech(gc.getInfoTypeForString("TECH_MYSTICISM"), true, iPlayer, false, false)
# Cybah: BASE fr 6.2 B - ZE: Indonesien END -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.2 A - Industriell Trait START ----------------------------------------------------------------------------------------------- deaktiviert
				# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")):
					# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_WORKSHOP"), YieldTypes.YIELD_PRODUCTION, 1)
# Cybah: BASE fr 6.2 A - Industriell Trait END -----------------------------------------------------------------------------------------------
# ZE: NO CIV TRAITS START -----------------------------------------------------------------------------------------------
				if gc.getGame().getGameTurnYear() != gc.getDefineINT("START_YEAR"): CyGame().setOption(gc.getInfoTypeForString("GAMEOPTION_NO_CIV_TRAITS"), True)
				if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS) or gc.getGame().getGameTurnYear() != gc.getDefineINT("START_YEAR"):
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_AMERICA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ARABIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_AUSTRIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_AZTEC"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_BABYLON"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_BERBER"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_BRAZIL"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_BYZANTIUM"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_CARIBBEAN"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_CARTHAGE"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_CELT"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_CHINA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_NETHERLANDS"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_EGYPT"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ENGLAND"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ETHIOPIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_FRANCE"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_GERMANY"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_GREECE"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_HOLY_ROMAN"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_HUNGARY"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_INCA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_INDIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_INDONESIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ISRAEL"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_JAPAN"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_KHMER"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_KOREA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_MALI"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_MAYA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_MONGOL"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_NATIVE_AMERICA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_VIKING"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_OTTOMAN"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_PERSIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_POLAND"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_POLYNESIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_PORTUGAL"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ROME"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_RUSSIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_SCOTLAND"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_SPAIN"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_SUMERIA"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_TIBET"), false, iPlayer, false, false)
					pTeam.setHasTech(gc.getInfoTypeForString("TECH_ZULU"), false, iPlayer, false, false)
				elif not(gc.getGame().isMapRegenerate()):
# rucivfan: Abfrage gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR") im folgenden entfernt. -> Grund: Es ist hier der else-Zweig, damit kann nur Start-Jahr gleich gc.getDefineINT("START_YEAR") sein.
# ZE: Brasilien 1/3 Start ----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_LUMBERMILL"), YieldTypes.YIELD_PRODUCTION, 2)
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PLANTATION"), YieldTypes.YIELD_FOOD, 1)
#						iZEBTech = gc.getInfoTypeForString("TECH_IRON_WORKING")
#						iZEBTechCost = pTeam.getResearchCost(iZEBTech)
#						iZEBTechPoints = (iZEBTechCost / 2)
#						pTeam.changeResearchProgress(iZEBTech, iZEBTechPoints, pPlayer.getID())
# ZE: Brasilien 1/3 End ----------------------------------------------------------------------------------------------
# # ZE: Arabien Start -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
						# iZEARATech = gc.getInfoTypeForString("TECH_THE_WHEEL")
						# iZEARATechCost = pTeam.getResearchCost(iZESTech2)
						# iZEARATechPoints = ((iZEARATechCost / 2) / pTeam.getNumMembers())
						# if (iZEARATechPoints * 2) < iZEARATechCost: iZEARATechPoints += 1
						# pTeam.changeResearchProgress(iZEARATech, iZEARATechPoints, pPlayer.getID())
# # ZE: Arabien End -----------------------------------------------------------------------------------------------
# ZE: Sumer Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SUMERIA"):
						iZESTech1 = gc.getInfoTypeForString("TECH_WRITING")
						iZESTech2 = gc.getInfoTypeForString("TECH_MATHEMATICS")
						iZESTechCost1 = pTeam.getResearchCost(iZESTech1)
						iZESTechCost2 = pTeam.getResearchCost(iZESTech2)
						iZESTechPoints1 = ((iZESTechCost1 / 2) / pTeam.getNumMembers())
						iZESTechPoints2 = ((iZESTechCost2 / 2) / pTeam.getNumMembers())
						if (iZESTechPoints1 * 2) < iZESTechCost1: iZESTechPoints1 += 1
						if (iZESTechPoints2 * 2) < iZESTechCost2: iZESTechPoints2 += 1
						pTeam.changeResearchProgress(iZESTech1, iZESTechPoints1, pPlayer.getID())
						pTeam.changeResearchProgress(iZESTech2, iZESTechPoints2, pPlayer.getID())
# ZE: Sumer End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - ZE: Hethiter Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.4 A
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
						# iZEHITTech1 = gc.getInfoTypeForString("TECH_METAL_CASTING")
						# iZEHITTechCost1 = pTeam.getResearchCost(iZEHITTech1)
						# iZEHITTechPoints1 = ((iZEHITTechCost1 / 2) / pTeam.getNumMembers())
						# if (iZEHITTechPoints1 * 2) < iZEHITTechCost1: iZEHITTechPoints1 += 1
						# pTeam.changeResearchProgress(iZEHITTech1, iZEHITTechPoints1, pPlayer.getID())
# Cybah: BASE fr 6.1 E - ZE: Hethiter -----------------------------------------------------------------------------------------------
# ZE: Heilig-Rom Start - ERSETZT in 6.3 C -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
						# iZEHRRTech1 = gc.getInfoTypeForString("TECH_FEUDALISM")
						# iZEHRRTech2 = gc.getInfoTypeForString("TECH_THEOLOGY")
						# iZEHRRTechCost1 = pTeam.getResearchCost(iZEHRRTech1)
						# iZEHRRTechCost2 = pTeam.getResearchCost(iZEHRRTech2)
						# iZEHRRTechPoints1 = ((iZEHRRTechCost1 / 2) / pTeam.getNumMembers())
						# iZEHRRTechPoints2 = ((iZEHRRTechCost2 / 2) / pTeam.getNumMembers())
						# if (iZEHRRTechPoints1 * 2) < iZEHRRTechCost1: iZEHRRTechPoints1 += 1
						# if (iZEHRRTechPoints2 * 2) < iZEHRRTechCost2: iZEHRRTechPoints2 += 1
						# pTeam.changeResearchProgress(iZEHRRTech1, iZEHRRTechPoints1, pPlayer.getID())
						# pTeam.changeResearchProgress(iZEHRRTech2, iZEHRRTechPoints2, pPlayer.getID())
# ZE: Heilig-Rom End -----------------------------------------------------------------------------------------------
# ZE: Osmanen Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
						iZEOTTOTech1 = gc.getInfoTypeForString("TECH_GUNPOWDER")
						iZEOTTOTechCost1 = pTeam.getResearchCost(iZEOTTOTech1)
						iZEOTTOTechPoints1 = ((iZEOTTOTechCost1 / 2) / pTeam.getNumMembers())
						if (iZEOTTOTechPoints1 * 2) < iZEOTTOTechCost1: iZEOTTOTechPoints1 += 1
						pTeam.changeResearchProgress(iZEOTTOTech1, iZEOTTOTechPoints1, pPlayer.getID())
# ZE: Osmanen End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - ZE: Israel Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
						iZEISRAELTech = gc.getInfoTypeForString("TECH_MONOTHEISM")
						iZEISRAELTechCost = pTeam.getResearchCost(iZEISRAELTech)
						iZEISRAELTechPoints = ((iZEISRAELTechCost / 2) / pTeam.getNumMembers())
						if (iZEISRAELTechPoints * 2) < iZEISRAELTechCost: iZEISRAELTechPoints += 1
						pTeam.changeResearchProgress(iZEISRAELTech, iZEISRAELTechPoints, pPlayer.getID())
# Cybah: BASE fr 6.3 C - ZE: Israel End -----------------------------------------------------------------------------------------------
# ZE: Mali Start -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"):
						# iZEMALITech1 = gc.getInfoTypeForString("TECH_CURRENCY")
						# iZEMALITechCost1 = pTeam.getResearchCost(iZEMALITech1)
						# iZEMALITechPoints1 = ((iZEMALITechCost1 / 2) / pTeam.getNumMembers())
						# if (iZEMALITechPoints1 * 2) < iZEMALITechCost1: iZEMALITechPoints1 += 1
						# pTeam.changeResearchProgress(iZEMALITech1, iZEMALITechPoints1, pPlayer.getID())
# ZE: Mali End -----------------------------------------------------------------------------------------------
# ZE: Arabien 1/3 Start -----------------------------------------------------------------------------------------------
# rucivfan: Abfrage pPlayer.getStateReligionUnitProductionModifier() < 10 problematisch -> Man codet so, dass eine nderung andere nderungen nicht verndert. Das ist hier nicht sichergestellt. Funktion wird durch elif not(gc.getGame().isMapRegenerate()): abgenommen
#					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
#						pPlayer.changeStateReligionUnitProductionModifier(10)
#						pPlayer.changeStateReligionBuildingProductionModifier(10)
# ZE: Arabien 1/3 End -----------------------------------------------------------------------------------------------
# ZE: Khmer Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
						for eBuilding in xrange ( gc.getNumBuildingInfos() ):
							# 6.2 D - MONASTERY mit TEMPLE getauscht
							# if (gc.getBuildingInfo(eBuilding).getSpecialBuildingType() != -1 and gc.getBuildingInfo(eBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_MONASTERY")):
							if (gc.getBuildingInfo(eBuilding).getSpecialBuildingType() != -1 and gc.getBuildingInfo(eBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_TEMPLE")):
								pPlayer.changeExtraBuildingClassHealth(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
# ZE: Khmer End -----------------------------------------------------------------------------------------------
# ZE: Deutschland Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_VILLAGE"), YieldTypes.YIELD_PRODUCTION, 1)
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_TOWN"), YieldTypes.YIELD_PRODUCTION, 1)
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_WORKSHOP"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Deutschland End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 F - ZE: thiopien Start (Zweiter Teil im SDK) deaktiviert -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPA"):
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_TOWN"), YieldTypes.YIELD_COMMERCE, -1)
# Cybah: BASE fr 6.1 F - ZE: thiopien End (Zweiter Teil im SDK) -----------------------------------------------------------------------------------------------
# ZE: England Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_FISHING_BOATS"), YieldTypes.YIELD_COMMERCE, 1)
# ZE: England End -----------------------------------------------------------------------------------------------
# ZE: Berber Start ----------------------------------------------------------------------------------------------- // DEAKTIVIERT MIT 6.3 C (jetzt im SDK)
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_NOMAD_CAMP"), YieldTypes.YIELD_COMMERCE, 2)
# ZE: Berber End -----------------------------------------------------------------------------------------------
# ZE: Indianer 1/2 Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
						pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_NOMAD_CAMP"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Indianer 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Ungarn Start (ersetzt in 6.3 C) -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_FOOD, 1)
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_PRODUCTION, 1)
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_COMMERCE, 1)
# ZE: Ungarn End -----------------------------------------------------------------------------------------------
# ZE: gypten Start ----------------------------------------------------------------------------------------------- Inka: jetzt +1 GPP pro Weltwunder (SDK)
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT"):
						for eBuilding in xrange ( gc.getNumBuildingInfos() ):
							if isWorldWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()):
								pPlayer.changeExtraBuildingClassHappiness(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
								
							# # Cybah: BASE fr 6.1 D - Nationalwunderbonus // deaktiviert mit 6.1 F
							# # if eBuilding != gc.getInfoTypeForString("BUILDING_PALACE") and isNationalWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()):
								# # pPlayer.changeExtraBuildingClassHappiness(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
# ZE: gypten End -----------------------------------------------------------------------------------------------
# ZE: Babylon 1/2 Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
						pPlayer.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_WALLS"), 1)
						pPlayer.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_COURTHOUSE"), 1)
# ZE: Babylon 1/2 Start -----------------------------------------------------------------------------------------------
# ZE: Maya 6.3 C Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
						pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_SLAVE"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Maya 6.3 C End -----------------------------------------------------------------------------------------------
# ZE: China Start -----------------------------------------------------------------------------------------------
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
						# 6.3 C - Gendert zu 2 Produktion
						# pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), CommerceTypes.COMMERCE_RESEARCH, 3)
						pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), YieldTypes.YIELD_PRODUCTION, 2)
						pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), CommerceTypes.COMMERCE_ESPIONAGE, 6)
# ZE: China End -----------------------------------------------------------------------------------------------
# ZE: sterreich Start -----------------------------------------------------------------------------------------------
					# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
						# # pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_GOLD, 3)
						# pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_CULTURE, 3)
# ZE: sterreich End -----------------------------------------------------------------------------------------------
# ZE: NO CIV TRAITS END -----------------------------------------------------------------------------------------------
# # Expansive Trait Start -----------------------------------------------------------------------------------------------
					# iTraitExp = gc.getInfoTypeForString("TRAIT_EXPANSIVE")
					# if pPlayer.hasTrait(iTraitExp):
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GRANARY"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_LIGHTHOUSE"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_SUPERMARKET"), 1)
# # Expansive Trait End -----------------------------------------------------------------------------------------------

		CvAdvisorUtils.resetNoLiberateCities()
																	
	def onGameEnd(self, argsList):
		'Called at the End of the game'
		print("Game is ending")
		return

	def onBeginGameTurn(self, argsList):
		'Called at the beginning of the end of each turn'
		iGameTurn = argsList[0]

		# rucivfan_ai_auto_play raap[
		# if( game.getAIAutoPlay() == 0 ) :
			# CvTopCivs.CvTopCivs().turnChecker(iGameTurn)

		game = gc.getGame()
		if not game.isPlayerAIAutoPlay(game.getActivePlayer()):
			CvTopCivs.CvTopCivs().turnChecker(iGameTurn)
		# ]rucivfan_ai_auto_play raap
		
# # Cybah: BASE fr 6.3 B - Barbarenankndigung START ----------------------------------------------------------------------------------------------- (mit 6.4 A zu BeginPlayerTurn verschoben)
		# if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_BARBARIANS) and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ONLY_ANIMALS):
			# iBarbCreationTurn = ((gc.getHandicapInfo(gc.getGame().getHandicapType()).getBarbarianCreationTurnsElapsed() * max(130, gc.getWorldInfo(gc.getMap().getWorldSize()).getResearchPercent()) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getBarbPercent()) / 13000)
			# if iGameTurn == 0:
				# szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_WILL_SPAWN_MESSAGE", (iBarbCreationTurn,))
				# CyInterface().addImmediateMessage( szTitle , None)
			# elif iGameTurn == (iBarbCreationTurn - 1):
				# # szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE", (10,))
				# iBarbQuote = CyGame().getSorenRandNum(10, "Barbarian Quote")
				# if iBarbQuote == 0: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE1", (10,))
				# elif iBarbQuote == 1: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE2", (10,))
				# elif iBarbQuote == 2: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE3", (10,))
				# elif iBarbQuote == 3: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE4", (10,))
				# elif iBarbQuote == 4: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE5", (10,))
				# elif iBarbQuote == 5: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE6", (10,))
				# elif iBarbQuote == 6: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE7", (10,))
				# elif iBarbQuote == 7: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE8", (10,))
				# elif iBarbQuote == 8: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE9", (10,))
				# elif iBarbQuote == 9: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE10", (10,))
				# else: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE", (10,))
				# CyInterface().addImmediateMessage( szTitle , None)
# # Cybah: BASE fr 6.3 B - Barbarenankndigung END -----------------------------------------------------------------------------------------------

	def onEndGameTurn(self, argsList):
		'Called at the end of the end of each turn'
		iGameTurn = argsList[0]
		
		# Test
		# Get number of seconds remaining
		# int iTurnSecondsRemaining = ((int)floorf((float)(iTurnSlicesRemaining-1) * ((float)gDLL->getMillisecsPerTurn()/1000.0f)) + 1);
		# int iTurnMinutesRemaining = (int)(iTurnSecondsRemaining/60);
		# iTurnSecondsRemaining = (iTurnSecondsRemaining%60);
		# int iTurnHoursRemaining = (int)(iTurnMinutesRemaining/60);
		# iTurnMinutesRemaining = (iTurnMinutesRemaining%60);
		# for iPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
			# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(CyGame().getTurnSlice(),CyGame().getTurnSlice(),)),'',0,'',-1,-1,-1,false,false)
		# CyGame().changeTurnSlice(-CyGame().getTurnSlice())
		
# Cybah: BASE fr 6.1 F - Rundentimer START -----------------------------------------------------------------------------------------------
		# # if (gc.getGame().isNetworkMultiPlayer() or gc.getGame().isGameMultiPlayer()) and not gc.getGame().isPitboss() and not gc.getGame().isPbem():

		# iRunden = (CyGame().getGameTurn() + 1)
		# iRundenThisLoad = ((CyGame().getGameTurn() + 1) - int(CyMap().plot(1, 1).getScriptData()))
				
		# iMinutesPlayed = CyGame().getMinutesPlayed()
		# iMinutesPlayedThisLoad = (CyGame().getMinutesPlayed() - int(CyMap().plot(0, 0).getScriptData()))
		# iMinutesPlayed2 = iMinutesPlayed
		# iMinutesPlayedThisLoad2 = iMinutesPlayedThisLoad
				
		# fRundenschnitt = float(iMinutesPlayed2 / max(1,iRunden))
		# fRundenschnittThisLoad = float(iMinutesPlayedThisLoad2 / max(1,iRundenThisLoad))
				
		# iHoursPlayed = max(0,(iMinutesPlayed / 60))
		# if iHoursPlayed > 0: iMinutesPlayed -= (iHoursPlayed * 60)
				
		# iHoursPlayedThisLoad = max(0,(iMinutesPlayedThisLoad / 60))
		# if iHoursPlayedThisLoad > 0: iMinutesPlayedThisLoad -= (iHoursPlayedThisLoad * 60)

		# for iPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
			# pPlayerX = gc.getPlayer(iPlayer)
			# if pPlayerX.getNameKey() == "Cybah":
		
				# # CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TURN_MINUTES_COMBINED",(u"%.0f" % fRundenschnitt,u"%.0f" % fRundenschnittThisLoad,iRunden,iRundenThisLoad,iMinutesPlayed,iMinutesPlayedThisLoad,iHoursPlayed,iHoursPlayedThisLoad)),'',0,'',-1,-1,-1,false,false)
				# if iRundenThisLoad != iRunden: CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TURN_MINUTES_COMBINED",(u"%.0f" % fRundenschnitt,u"%.0f" % fRundenschnittThisLoad,iRunden,iRundenThisLoad,iMinutesPlayed,iMinutesPlayedThisLoad,iHoursPlayed,iHoursPlayedThisLoad)),'',0,'',-1,-1,-1,false,false)
				# else:
					# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TURN_MINUTES",(u"%.0f" % fRundenschnitt,iRunden,iMinutesPlayed,iHoursPlayed)),'',0,'',-1,-1,-1,false,false)
					# ##if fRundenschnittThisLoad != fRundenschnitt: CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TURN_MINUTES_THIS_LOAD",(u"%.0f" % fRundenschnittThisLoad,iRundenThisLoad,iMinutesPlayedThisLoad,iHoursPlayedThisLoad)),'',0,'',-1,-1,-1,false,false)
# Cybah: BASE fr 6.1 F - Rundentimer END -----------------------------------------------------------------------------------------------
		
	def onBeginPlayerTurn(self, argsList):
		'Called at the beginning of a players turn'
		iGameTurn, iPlayer = argsList

		pPlayer = gc.getPlayer(iPlayer)
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		estiEnd = CyGame().getEstimateEndTurn()
		capital = pPlayer.getCapitalCity()
		
		# test
		# iEvent = CvUtil.findInfoTypeNum(gc.getEventTriggerInfo, gc.getNumEventTriggerInfos(),'EVENTTRIGGER_PARTISANS')
		# if iEvent != -1 and gc.getGame().isEventActive(iEvent):
			# iGameTurnX = gc.getGame().getGameTurn()
			# iBarbCreationTurn = ((gc.getHandicapInfo(gc.getGame().getHandicapType()).getBarbarianCreationTurnsElapsed() * max(130, gc.getWorldInfo(gc.getMap().getWorldSize()).getResearchPercent()) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getBarbPercent()) / 13000)
			# if iGameTurnX >= iBarbCreationTurn:
				# triggerData = pPlayer.initTriggeredData(iEvent, True, -1, capital.getX(), capital.getY(), iPlayer, capital.getID(), -1, -1, -1, -1)
		
# Cybah: BASE fr 6.4 A - Barbarenankndigung START -----------------------------------------------------------------------------------------------
		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_BARBARIANS) and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ONLY_ANIMALS):
			iBarbCreationTurn = ((gc.getHandicapInfo(gc.getGame().getHandicapType()).getBarbarianCreationTurnsElapsed() * max(130, gc.getWorldInfo(gc.getMap().getWorldSize()).getResearchPercent()) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getBarbPercent()) / 13000)
			if iGameTurn == 0:
				szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_WILL_SPAWN_MESSAGE", (iBarbCreationTurn,))
				CyInterface().addMessage(pPlayer.getID(), True, 20, szTitle, "", 0,'',-1,-1,-1, True, True)

			elif iGameTurn == (iBarbCreationTurn - 1):
				# szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE", (10,))
				iBarbQuote = CyGame().getSorenRandNum(10, "Barbarian Quote")
				if iBarbQuote == 0: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE1", (10,))
				elif iBarbQuote == 1: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE2", (10,))
				elif iBarbQuote == 2: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE3", (10,))
				elif iBarbQuote == 3: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE4", (10,))
				elif iBarbQuote == 4: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE5", (10,))
				elif iBarbQuote == 5: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE6", (10,))
				elif iBarbQuote == 6: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE7", (10,))
				elif iBarbQuote == 7: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE8", (10,))
				elif iBarbQuote == 8: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE9", (10,))
				elif iBarbQuote == 9: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE10", (10,))
				else: szTitle = CyTranslator().getText("TXT_KEY_BARBARIANS_CREATION_MESSAGE", (10,))
				CyInterface().addMessage(pPlayer.getID(), True, 20, szTitle, "", 0,'',-1,-1,-1, True, True)
# Cybah: BASE fr 6.4 A - Barbarenankndigung END -----------------------------------------------------------------------------------------------

# test		CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(pPlayer.calculateResearchRate(pPlayer.getCurrentResearch()),pPlayer.calculateResearchRate(pPlayer.getCurrentResearch()),)),'',0,'',-1,-1,-1,false,false)
# Gameoption Hegemon Shares Tech Start -----------------------------------------------------------------------------------------------

		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_VASSAL_STATES):
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HEGEMON_SHARES_TECHS):
				pPlayer = gc.getPlayer(iPlayer)
				iTeam = pPlayer.getTeam()
				pTeam = gc.getTeam(iTeam)
				if pTeam.isAVassal():				
					for iSharePlayer in xrange(gc.getMAX_CIV_PLAYERS()):
						vPlayer = gc.getPlayer(iSharePlayer)
						vTeam = gc.getTeam(vPlayer.getTeam())	
						if vPlayer.isAlive():
							if pTeam.isVassal(vPlayer.getTeam()):
								for iTechType in xrange(gc.getNumTechInfos()):
									if gc.getTechInfo(iTechType).isTrade():
										if vTeam.isHasTech(iTechType):
											pTeam.changeResearchProgress(iTechType, pTeam.getResearchCost(iTechType) - pTeam.getResearchProgress(iTechType), iPlayer)
											# pTeam.setHasTech(iTechType, true, iPlayer, false, false)

# Gameoption Hegemon Shares Tech End -----------------------------------------------------------------------------------------------
# Gameoption Vassal Shares Tech Start -----------------------------------------------------------------------------------------------

			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_VASSAL_SHARES_TECHS):
				pPlayer = gc.getPlayer(iPlayer)
				iTeam = pPlayer.getTeam()
				pTeam = gc.getTeam(iTeam)
				if not pTeam.isAVassal():				
					for iSharePlayer in xrange(gc.getMAX_CIV_PLAYERS()):
						vPlayer = gc.getPlayer(iSharePlayer)
						vTeam = gc.getTeam(vPlayer.getTeam())	
						if vPlayer.isAlive():
							if vTeam.isVassal(pPlayer.getTeam()):
								for iTechType in xrange(gc.getNumTechInfos()):
									if gc.getTechInfo(iTechType).isTrade():
										if vTeam.isHasTech(iTechType):
											pTeam.changeResearchProgress(iTechType, pTeam.getResearchCost(iTechType) - pTeam.getResearchProgress(iTechType), iPlayer)
											# pTeam.setHasTech(iTechType, true, iPlayer, false, false)

# Gameoption Vassal Shares Tech End -----------------------------------------------------------------------------------------------
# Terracotta Start -----------------------------------------------------------------------------------------------

		b_Terra = gc.getInfoTypeForString("BUILDING_TERRACOTTA_ARMY")
		obsoleteTechTerra = gc.getBuildingInfo(b_Terra).getObsoleteTech()
		if obsoleteTechTerra == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTechTerra):
			if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_TERRACOTTA_ARMY")) > 0:
				if estiEnd >= 1000:
					if iGameTurn % 10 == 0:
						pPlayer.changeCombatExperience( +3 )
				elif estiEnd >= 700:
					if iGameTurn % 7 == 0:
						pPlayer.changeCombatExperience( +3 )
				elif estiEnd >= 500:
					if iGameTurn % 5 == 0:
						pPlayer.changeCombatExperience( +3 )
				elif estiEnd >= 300:
					if iGameTurn % 3 == 0:
						pPlayer.changeCombatExperience( +3 )
				elif estiEnd < 300:
					if iGameTurn % 3 == 0:
						pPlayer.changeCombatExperience( +3 )

# Terracotta End -----------------------------------------------------------------------------------------------
# SETI Start -----------------------------------------------------------------------------------------------
		pTeam = gc.getTeam(pPlayer.getTeam())
		# if pPlayer.isAlive() and not pPlayer.isBarbarian():	
		if pTeam.getProjectCount(gc.getInfoTypeForString("PROJECT_SETI")) > 0 and pPlayer.isAlive() and not pPlayer.isBarbarian():	
			alienhelp = CyGame().getSorenRandNum(100, "Alien Help Yes or No")
			
			# # Test ---------------------- [
			# # 10% Chance, Weapon Upgrade for a Unit
			# # Neu: +10% Grundstrke
			# if alienhelp < 100:
				# numOwnUnits = pPlayer.getNumMilitaryUnits()
				# weaponupgrade = CyGame().getSorenRandNum(numOwnUnits, "Weapon Upgrade")
				# pUnit = pPlayer.getUnit(weaponupgrade)
				# if not pUnit.isNone():
					# iUnit = pUnit.getUnitType()
					# unitX = PyInfo.UnitInfo(pUnit.getUnitType())
					# if pUnit.baseCombatStr() >= 10:							
						# newstrength = int(pUnit.baseCombatStr() * 11 / 10)
						# pUnit.setBaseCombatStr(newstrength)				
						# strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_WEAPON_UPGRADE", (unitX.getDescription(), pPlayer.getName(), pPlayer.getName()))
						# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), pUnit.getX(), pUnit.getY(), True, True)
			# # Test ---------------------- ]
			
			# 25% Chance for any Alien Action
			if alienhelp > 50 and alienhelp < 76:

				# Roll a Random Number to decide what happens
				alien = CyGame().getSorenRandNum(1000, "Alien Help")

				# 2.5% Chance // War: Make Peace With Stronger Rivals // Peace: Free Tech
				if alien <25:
					
					# Part 1: War: Make Peace With Stronger Rivals
					if pTeam.getAtWarCount(true) > 0 and not pTeam.isAVassal():
						for iPlayer2 in xrange(gc.getMAX_CIV_PLAYERS()):
							pPlayer2 = gc.getPlayer(iPlayer2)
							iTeam2 = pPlayer2.getTeam()
							if pPlayer2.isAlive() and not pPlayer2.isBarbarian():
								if pTeam.isAtWar(iTeam2) and (pPlayer2.getPower() >= (pPlayer.getPower() * 4 / 3)):
									pPlayer.forcePeace(iPlayer2)
									strMessage1 = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_PEACE1", (pPlayer2.getName(), pPlayer.getName(), pPlayer.getName()))
									CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0,'',-1,-1,-1, True, True)
									strMessage2 = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_PEACE2", (pPlayer.getName(), pPlayer2.getName(), pPlayer.getName()))
									CyInterface().addMessage(pPlayer2.getID(), True, 20, strMessage2, "", 0,'',-1,-1,-1, True, True)
									
					# Part 2: Peace: Free Tech
					else:
						if not pPlayer.getCurrentResearch() == gc.getInfoTypeForString("TECH_FUTURE_TECH"):
							strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_TECH", (pPlayer.getName(), pPlayer.getName(), pPlayer.getName()))
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
							## rucivfan_ai_auto_play raap[
							#if pPlayer.isHuman():
							if pPlayer.isHumanActive():
							## ]rucivfan_ai_auto_play raap							
								pPlayer.chooseTech(1,'',True)
							else:
								techs = []
								team = gc.getTeam(pPlayer.getTeam())
								for iTech in xrange(gc.getNumTechInfos()):
									if pPlayer.canResearch(iTech, false):
										iCost = team.getResearchLeft(iTech)
										if iCost > 0:
											techs.append((-iCost, iTech))
								if techs:
									techs.sort()
									iTech = techs[0][1]
									team.changeResearchProgress(iTech, team.getResearchCost(iTech) - team.getResearchProgress(iTech), iPlayer)
									# team.setHasTech(iTech, True, iPlayer, false, false)	

				# 2.5% Chance, Aliens Backstab Player
				elif alien <50:
					if not pTeam.isAVassal():
						bPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())					
						iX = capital.getX()
						iY = capital.getY()
						spawnX = []
						spawnY = []
						for iXLoop in xrange(iX - 1, iX + 2):
							for iYLoop in xrange(iY - 1, iY + 2):
								pPlot = CyMap().plot(iXLoop, iYLoop)
								if not pPlot.isCity() and not pPlot.isWater() and not pPlot.isImpassable():
									spawnX.append(iXLoop)
									spawnY.append(iYLoop)
						spawn = CyGame().getSorenRandNum(len(spawnX), "where")
						if spawn:
							szTitle = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (capital.getName(),))
							CyInterface().addImmediateMessage( szTitle , None)
							# strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (capital.getName(), pPlayer.getName(), pPlayer.getName()))
							# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(7), spawnX[spawn], spawnY[spawn], True, True)
							iHostileAliensStrength = 1
							# Backstabbing immer nur mit Strke 1
							for j in xrange (iHostileAliensStrength):
								iHostileAliens = CyGame().getSorenRandNum(10, "Hostile Alien Unit Types")
								if iHostileAliens == 0:
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 1:
									for i in xrange (5):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 2:
									for i in xrange (4):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 3:
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 4:
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 5:
									for i in xrange (3):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 6:
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 7:
									for i in xrange (5):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (2):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 8:
									for i in xrange (3):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (3):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
								elif iHostileAliens == 9:
									for i in xrange (4):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
									for i in xrange (1):
										pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
										pNewUnit.setImmobileTimer(2)
							
						# Insel-Hauptstadt
						else:
							spawnX = []
							spawnY = []
							for iXLoop in xrange(iX - 1, iX + 2):
								for iYLoop in xrange(iY - 1, iY + 2):
									pPlot = CyMap().plot(iXLoop, iYLoop)
									if not pPlot.isCity() and not pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_OCEAN' ) and not pPlot.isImpassable():
										spawnX.append(iXLoop)
										spawnY.append(iYLoop)
							spawn = CyGame().getSorenRandNum(len(spawnX), "where")
							if spawn:
								szTitle = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (capital.getName(),))
								CyInterface().addImmediateMessage( szTitle , None)
								# strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (capital.getName(), pPlayer.getName(), pPlayer.getName()))
								# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(7), spawnX[spawn], spawnY[spawn], True, True)
								for i in xrange (2):
									pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
									pNewUnit.setImmobileTimer(2)
								for i in xrange (2):
									pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
									pNewUnit.setImmobileTimer(2)

				# 5% Chance // War: Aliens Spawn Near Stronger Rivals' Capitals // Peace: Production Acceleration In All Cities
				elif alien <100:
					
					# Part 1: War: Aliens Spawn Near Stronger Rivals' Capitals
					if pTeam.getAtWarCount(true) > 0 and not pTeam.isAVassal():
						bPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
						for iPlayer2 in xrange(gc.getMAX_CIV_PLAYERS()):
							pPlayer2 = gc.getPlayer(iPlayer2)
							if pPlayer2.isAlive() and not pPlayer2.isBarbarian():
								iTeam2 = pPlayer2.getTeam()
								pTeam2 = gc.getTeam(iTeam2)
								if pTeam.isAtWar(iTeam2):
									team2capital = pPlayer2.getCapitalCity()
									iX2 = team2capital.getX()
									iY2 = team2capital.getY()
									spawnX = []
									spawnY = []
									for iXLoop in xrange(iX2 - 1, iX2 + 2):
										for iYLoop in xrange(iY2 - 1, iY2 + 2):
											pPlot = CyMap().plot(iXLoop, iYLoop)
											if not pPlot.isCity() and not pPlot.isWater() and not pPlot.isImpassable():
												spawnX.append(iXLoop)
												spawnY.append(iYLoop)
									spawn = CyGame().getSorenRandNum(len(spawnX), "where")
									if spawn:
										szTitle = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (team2capital.getName(),))
										CyInterface().addImmediateMessage( szTitle , None)
										# strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (team2capital.getName(), pPlayer2.getName(), pPlayer.getName()))
										# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), spawnX[spawn], spawnY[spawn], True, True)
										# CyInterface().addMessage(pPlayer2.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(7), spawnX[spawn], spawnY[spawn], True, True)
										
										# Alien-Grundstrke: 1 bis 3
										iHostileAliensStrength = (1 + CyGame().getSorenRandNum(3, "Hostile Alien Strength"))
										
										# Keine Grundstrke 3 wenn der Gegner schwcher ist
										if pTeam2.getPower(True) < pTeam.getPower(True): iHostileAliensStrength = min(2, iHostileAliensStrength)
										
										# 6.4 D - +1 wenn Gegner auch in Moderne und +2 wenn Gegner in Zukunft
										if pPlayer2.getCurrentEra() > 4: iHostileAliensStrength += 1
										if pPlayer2.getCurrentEra() > 5: iHostileAliensStrength += 1										
										
										for j in xrange (iHostileAliensStrength):
											iHostileAliens = CyGame().getSorenRandNum(10, "Hostile Alien Unit Types")
											if iHostileAliens == 0:
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 1:
												for i in xrange (5):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 2:
												for i in xrange (4):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 3:
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 4:
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 5:
												for i in xrange (3):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 6:
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 7:
												for i in xrange (5):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 8:
												for i in xrange (3):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (3):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
											elif iHostileAliens == 9:
												for i in xrange (4):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (1):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
									
									# Insel-Hauptstadt
									else:
										spawnX = []
										spawnY = []
										for iXLoop in xrange(iX2 - 1, iX2 + 2):
											for iYLoop in xrange(iY2 - 1, iY2 + 2):
												pPlot = CyMap().plot(iXLoop, iYLoop)
												if not pPlot.isCity() and not pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_OCEAN' ) and not pPlot.isImpassable():
													spawnX.append(iXLoop)
													spawnY.append(iYLoop)
										spawn = CyGame().getSorenRandNum(len(spawnX), "where")
										if spawn:
											szTitle = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (team2capital.getName(),))
											CyInterface().addImmediateMessage( szTitle , None)
											# strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ASSAULT", (team2capital.getName(), pPlayer2.getName(), pPlayer.getName()))
											# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), spawnX[spawn], spawnY[spawn], True, True)
											# CyInterface().addMessage(pPlayer2.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(7), spawnX[spawn], spawnY[spawn], True, True)
											
											# Alien-Grundstrke: 1 bis 3
											iHostileAliensStrength = (1 + CyGame().getSorenRandNum(3, "Hostile Alien Strength"))
											
											# Keine Grundstrke 3 wenn der Gegner schwcher ist
											if pTeam2.getPower(True) < pTeam.getPower(True): iHostileAliensStrength = min(2, iHostileAliensStrength)
											
											# 6.4 D - +1 wenn Gegner auch in Moderne und +2 wenn Gegner in Zukunft
											if pPlayer2.getCurrentEra() > 4: iHostileAliensStrength += 1
											if pPlayer2.getCurrentEra() > 5: iHostileAliensStrength += 1	
											
											for j in xrange (iHostileAliensStrength):
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
												for i in xrange (2):
													pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), spawnX[spawn], spawnY[spawn], UnitAITypes.UNITAI_ATTACK_CITY, DirectionTypes.NO_DIRECTION )
													pNewUnit.setImmobileTimer(2)
									
					# Part 2: Peace: Production Acceleration In All Cities
					else:
						strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_PRODUCTION_CITIES", (pPlayer.getName(), pPlayer.getName(), pPlayer.getName()))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
						
						# 6.3 B - 5 zufllige Stdte
						AccCities = []
						
						pCityAlienHelp, iter = pPlayer.firstCity(false)  
						while(pCityAlienHelp):	  
							if not pCityAlienHelp.isNone() and pCityAlienHelp.getOwner() == pPlayer.getID():
								if pCityAlienHelp.isProductionBuilding() or pCityAlienHelp.isProductionProject() or pCityAlienHelp.isProductionUnit():
									# 6.3 B - 5 zufllige Stdte
									# pCityAlienHelp.changeProduction(pCityAlienHelp.productionLeft())
									AccCities.append(pCityAlienHelp)
							pCityAlienHelp, iter = pPlayer.nextCity(iter, false)

						# 6.3 B - 5 zufllige Stdte
						if len(AccCities) > 0:
							iStadt1 = CyGame().getSorenRandNum(len(AccCities), "Stadt1")
							AccCities[iStadt1].changeProduction(AccCities[iStadt1].productionLeft())
							AccCities.remove(AccCities[iStadt1])

						if len(AccCities) > 0:
							iStadt2 = CyGame().getSorenRandNum(len(AccCities), "Stadt2")
							AccCities[iStadt2].changeProduction(AccCities[iStadt2].productionLeft())
							AccCities.remove(AccCities[iStadt2])

						if len(AccCities) > 0:
							iStadt3 = CyGame().getSorenRandNum(len(AccCities), "Stadt3")
							AccCities[iStadt3].changeProduction(AccCities[iStadt3].productionLeft())
							AccCities.remove(AccCities[iStadt3])

						if len(AccCities) > 0:
							iStadt4 = CyGame().getSorenRandNum(len(AccCities), "Stadt4")
							AccCities[iStadt4].changeProduction(AccCities[iStadt4].productionLeft())
							AccCities.remove(AccCities[iStadt4])

						if len(AccCities) > 0:
							iStadt5 = CyGame().getSorenRandNum(len(AccCities), "Stadt5")
							AccCities[iStadt5].changeProduction(AccCities[iStadt5].productionLeft())
							AccCities.remove(AccCities[iStadt5])

				# 5% Chance, 1 Alien Unit
				elif alien <150:
					alienunit = CyGame().getSorenRandNum(100, "Alien Unit Type")
					# 2% Chance, Avenger
					if alienunit <2:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 4% Chance, Marauder
					elif alienunit <6:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 6% Chance, Spider II
					elif alienunit <12:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 8% Chance, Spider I
					elif alienunit <20:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 10% Chance, Goliath
					elif alienunit <30:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 10% Chance, Predator
					elif alienunit <40:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 12% Chance, Locust
					elif alienunit <52:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 14% Chance, Sentinel
					elif alienunit <66:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SENTINEL' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 16% Chance, Trooper
					elif alienunit <82:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# 18% Chance, UFO
					elif alienunit <100:
						pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_UFO' ), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_UNIT", (capital.getName(), pPlayer.getName(), pPlayer.getName()))
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), capital.getX(), capital.getY(), True, True)
						
				# 10% Chance // War: Random Unit Killed from Each Rival at War with Player // Peace: Replication Of A Unit
				elif alien <250:

					# Part 1: War: Random Unit Killed from Each Rival at War with Player
					if pTeam.getAtWarCount(true) > 0:
						for iPlayer2 in xrange(gc.getMAX_CIV_PLAYERS()):
							pPlayer2 = gc.getPlayer(iPlayer2)
							if pPlayer2.isAlive() and not pPlayer2.isBarbarian():
								iTeam2 = pPlayer2.getTeam()
								if pTeam.isAtWar(iTeam2):
									numUnits = pPlayer2.getNumUnits()
									abduction = CyGame().getSorenRandNum(numUnits, "Abduction")
									p2Unit = pPlayer2.getUnit(abduction)
									if not p2Unit.isNone():
										unitX = PyInfo.UnitInfo(p2Unit.getUnitType())
										p2Unit.kill( 0, -1 )
										strMessage1 = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ABDUCTION", (unitX.getDescription(), pPlayer2.getName(), pPlayer.getName()))
										CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0,'',-1,-1,-1, True, True)
										strMessage2 = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ABDUCTION2", (unitX.getDescription(), pPlayer2.getName(), pPlayer.getName()))
										CyInterface().addMessage(pPlayer2.getID(), True, 20, strMessage2, "", 0,'',-1,-1,-1, True, True)
				
					# Part 2: Peace: Replication Of A Unit
					else:
						numOwnUnits = pPlayer.getNumUnits()
						replication = CyGame().getSorenRandNum(numOwnUnits, "Replication")
						pUnit = pPlayer.getUnit(replication)
						if not pUnit.isNone():
							iUnit = pUnit.getUnitType()
							unitX = PyInfo.UnitInfo(pUnit.getUnitType())
							for i in xrange (2):
								pNewUnit = pPlayer.initUnit( iUnit, pUnit.getX(), pUnit.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )	
								pNewUnit.convert(pUnit)
								pNewUnit.finishMoves()
							strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_REPLICATION", (unitX.getDescription(), pPlayer.getName(), pPlayer.getName()))
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), pUnit.getX(), pUnit.getY(), True, True)
							
				# 25% Chance, Nanoids Promotion for a Unit
				elif alien <500:
					numOwnUnits = pPlayer.getNumMilitaryUnits()
					nanoids = CyGame().getSorenRandNum(numOwnUnits, "Nanoids")
					pUnit = pPlayer.getUnit(nanoids)
					if not pUnit.isNone():
						iUnit = pUnit.getUnitType()
						unitX = PyInfo.UnitInfo(pUnit.getUnitType())
						if pUnit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_NANOIDS")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_NANOIDS")):
							pUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_NANOIDS"), True)
							strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_NANOIDS", (unitX.getDescription(), pPlayer.getName(), pPlayer.getName()))
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), pUnit.getX(), pUnit.getY(), True, True)
							
				# 10% Chance, Absorption Promotion for a Unit
				elif alien <600:
					numOwnUnits = pPlayer.getNumMilitaryUnits()
					absorption = CyGame().getSorenRandNum(numOwnUnits, "Absorption")
					pUnit = pPlayer.getUnit(absorption)
					if not pUnit.isNone():
						iUnit = pUnit.getUnitType()
						unitX = PyInfo.UnitInfo(pUnit.getUnitType())
						if pUnit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_ABSORPTION")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ABSORPTION")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_REPLICATION")):
							pUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_ABSORPTION"), True)
							strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_ABSORPTION", (unitX.getDescription(), pPlayer.getName(), pPlayer.getName()))
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), pUnit.getX(), pUnit.getY(), True, True)
							
				# 10% Chance, Weapon Upgrade for a Unit
				# 6.4 D: Jetzt +20% Grundstrke
				elif alien <700:
					numOwnUnits = pPlayer.getNumMilitaryUnits()
					weaponupgrade = CyGame().getSorenRandNum(numOwnUnits, "Weapon Upgrade")
					pUnit = pPlayer.getUnit(weaponupgrade)
					if not pUnit.isNone():
						iUnit = pUnit.getUnitType()
						unitX = PyInfo.UnitInfo(pUnit.getUnitType())
						if pUnit.baseCombatStr() >= 10:							
							newstrength = int(pUnit.baseCombatStr() * 12 / 10)
							pUnit.setBaseCombatStr(newstrength)				
							strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_WEAPON_UPGRADE", (unitX.getDescription(), pPlayer.getName(), pPlayer.getName()))
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_SETI")).getButton(), ColorTypes(8), pUnit.getX(), pUnit.getY(), True, True)

				# 25% Chance // War: +50 Great General Points // Peace: +500 Gold
				elif alien <950:
					
					# Part 1: 6.4 D: Jetzt +25 per Era
					if pTeam.getAtWarCount(true) > 0:
						iAlienCombatXP = 25 * (pPlayer.getCurrentEra() + 1)
						pPlayer.changeCombatExperience(iAlienCombatXP)
						strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_GG", (pPlayer.getName(), pPlayer.getName(), pPlayer.getName()))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
						
					# Part 2: 6.4 D: Jetzt +250 per Era
					else:
						iAlienBonusGold = 250 * (pPlayer.getCurrentEra() + 1)
						pPlayer.changeGold(iAlienBonusGold)
						strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_GOLD", (pPlayer.getGold(), pPlayer.getName(), pPlayer.getName()))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)	

				# 5% Chance, Heal All Units
				elif alien <1000:
					strMessage = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_HEAL", (pPlayer.getName(), pPlayer.getName(), pPlayer.getName()))
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)	
					for i in xrange(pPlayer.getNumMilitaryUnits()):
						pUnit = pPlayer.getUnit(i)
						pUnit.setDamage(0, False)				
									
# SETI End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - ZE: Israel START -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_ISRAEL")):
			
				# Israeli hat eine Staatsreligion
				iIsraelReligion = pPlayer.getStateReligion()
				if not iIsraelReligion == -1:
				
					# Bedingung mit 6.4 A entfernt
					# und ist im Besitz der heiligen Stadt
					# if pPlayer.hasHolyCity(iIsraelReligion):
					
					# Zufallschance
					estiEnd = CyGame().getEstimateEndTurn()
					if ( estiEnd >= 1000 ):
						iIsraelRand = CyGame().getSorenRandNum(900, "Israel Random Population Gain")
					elif ( estiEnd >= 700 ):
						iIsraelRand = CyGame().getSorenRandNum(450, "Israel Random Population Gain")
					elif ( estiEnd >= 500 ):
						iIsraelRand = CyGame().getSorenRandNum(300, "Israel Random Population Gain")
					elif ( estiEnd >= 300 ):
						iIsraelRand = CyGame().getSorenRandNum(200, "Israel Random Population Gain")
						
					# Nur zum Testen
					# iIsraelRand = 0
						
					if iIsraelRand < 18:
						IsraelCities = []
						pCityIsrael, iter = pPlayer.firstCity(false)  
						while(pCityIsrael):	  
							if not pCityIsrael.isNone() and pCityIsrael.getOwner() == pPlayer.getID():
								# Stadt hat die Religion
								if pCityIsrael.isHasReligion(iIsraelReligion):
									# Stadt hat Zufriedenheitsberschuss
									if (pCityIsrael.happyLevel() > pCityIsrael.unhappyLevel(0)):
										IsraelCities.append(pCityIsrael)
							pCityIsrael, iter = pPlayer.nextCity(iter, false)

						# Zufllige Auswahl der in Frage kommenden Stadt
						if len(IsraelCities) > 0:
							iStadt = CyGame().getSorenRandNum(len(IsraelCities), "Stadt")
							IsraelCities[iStadt].changePopulation(1)
							strMessage = CyTranslator().getText("TXT_KEY_ISRAEL_BONUS_POPULATION", (IsraelCities[iStadt].getName(), IsraelCities[iStadt].getName(), IsraelCities[iStadt].getName()))
							# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getReligionInfo(iIsraelReligion).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							
							if iIsraelReligion == 0: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_JEWISH_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 1: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_CHRISTIAN_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 2: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_ISLAMIC_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 3: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_HINDU_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 4: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_BUDDHIST_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 5: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_CONFUCIAN_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 6: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_TAOIST_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 7: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_OLYMP_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 8: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_ASEN_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 9: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_VOODOO_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 10: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_SHINTO_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 11: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_ZORO_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 12: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_RA_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 13: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_TOLTEC_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 14: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_SHAMAN_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 15: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_FREEM_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
							elif iIsraelReligion == 16: CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getUnitInfo(gc.getInfoTypeForString("UNIT_DRUID_MISSIONARY")).getButton(), ColorTypes(8), IsraelCities[iStadt].getX(), IsraelCities[iStadt].getY(), True, True)
# Cybah: BASE fr 6.3 C - ZE: Israel END -----------------------------------------------------------------------------------------------
# ZE: Maya Start (ersetzt in 6.3 C) -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
			# iTechZEM = gc.getInfoTypeForString("TECH_MAYA")
			# if pTeam.isHasTech(iTechZEM):

				# pCity, iter = pPlayer.firstCity(false)  
				# while(pCity): 

					# if pCity.isProductionBuilding() and not pCity.isDisorder():
						# pB = pCity.getProductionBuilding()
						# if pB > -1:
							# if not isWorldWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()) and not isNationalWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()):

								# if pCity.productionLeft() > 0:
									# iCityPopProd = (pCity.getPopulation() / 2)
									# if iCityPopProd == 0: iCityPopProd = 1
									# pCity.changeProduction(iCityPopProd)
											
					# pCity, iter = pPlayer.nextCity(iter, false)
# ZE: Maya End -----------------------------------------------------------------------------------------------
# ZE: Portugal Start -----------------------------------------------------------------------------------------------
		# if (gc.getGame().getElapsedGameTurns() % 100 == 0):
			# if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
				# MapH = CyMap().getGridHeight()
				# MapW = CyMap().getGridWidth()
				# for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
					# pTeamX = gc.getTeam(iTeamX)
					# if pTeamX.isAlive() and gc.getTeam(pPlayer.getTeam()).isHasMet(iTeamX):
						# for i in xrange (MapW):
							# for j in xrange (MapH):
								# pPlot = CyMap().plot(i, j)
								# if pPlot.isVisible (iTeamX, 0): pPlot.setRevealed (pPlayer.getTeam(), 1,0,-1)
# ZE: Portugal End -----------------------------------------------------------------------------------------------

	def onEndPlayerTurn(self, argsList):
		'Called at the end of a players turn'
		iGameTurn, iPlayer = argsList
		pPlayer = gc.getPlayer(iPlayer)
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		
# Cybah: BASE fr 6.1 E - Tiere rausbeamen START
		# if pPlayer.isBarbarian():
			# (loopUnit, iter) = pPlayer.firstUnit(False)
			# while(loopUnit):
				# if loopUnit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_ANIMAL' ):
					# pPlotX = loopUnit.plot()
					# if pPlotX.isOwned():
						# if pPlotX.getTeam() != pPlayer.getTeam():
							# # Rausbeamen
							# loopUnit.jumpToNearestValidPlot()
							
							# # # Zufllige Bewegung - geht nicht
							# # MovePlotX = []
							# # MovePlotY = []
							# # iX2 = pPlotX.getX()
							# # iY2 = pPlotX.getY()
							# # for iXLoop in xrange(iX2 - 1, iX2 + 2):
								# # for iYLoop in xrange(iY2 - 1, iY2 + 2):
									# # pPlot = CyMap().plot(iXLoop, iYLoop)
									# # if not pPlot.isCity() and not pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_OCEAN' ) and not pPlot.isImpassable() and not pPlot.getNumUnits() > 0:
										# # # if loopUnit.canMoveInto(pPlot, True, False, False, True):
										# # MovePlotX.append(iXLoop)
										# # MovePlotY.append(iYLoop)
							# # iMovePlot = CyGame().getSorenRandNum(len(MovePlotX), "where")
							# # if iMovePlot:
								# # # test
								# # # CyInterface().addMessage(0,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(MovePlotX[iMovePlot],MovePlotY[iMovePlot],)),'',0,'',-1,-1,-1,false,false)
								# # # loopUnit.getGroup().pushMoveToMission(MovePlotX[iMovePlot], MovePlotY[iMovePlot])
						
				# (loopUnit, iter) = pPlayer.nextUnit(iter, False)
# Cybah: BASE fr 6.1 E - Tiere rausbeamen END
## Cybah: BASE fr 6.1 E - Kreativ Counter - DEAKTIVIERT
		# iKreTrait = gc.getInfoTypeForString("TRAIT_CREATIVE")
		# if pPlayer.hasTrait(iKreTrait) and pPlayer.isAlive():
			# sScript = pPlayer.getScriptData()
			# sHappy = sScript[:sScript.find("Split")]

			# if sHappy.find("HGA") == -1:
				# iCurrent = 0
				# iThreshold = self.iHGA * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getGreatPeoplePercent() / 100
			# else:
				# iCurrent = int(sHappy[:sHappy.find("HGA")])
				# iThreshold = int(sHappy[sHappy.find("HGA") +3:])
				
			# # iCurrent = max(0, iCurrent + pPlayer.calculateTotalCityHappiness() - pPlayer.calculateTotalCityUnhappiness())
			
			# iOwnWorldWonders = 0
			# iOtherWorldWondersTotal = 0
			# iMostWorldWonders = 0
			
			# for iTeamX in xrange(gc.getMAX_TEAMS()):
				# pTeamX = gc.getTeam(iTeamX)
				# iOtherWorldWonders = 0
				
				# for iBuilding in xrange(gc.getNumBuildingInfos()):
					# if isWorldWonderClass(gc.getBuildingInfo(iBuilding).getBuildingClassType()) and gc.getBuildingInfo(iBuilding).getReligionType() == -1 and gc.getBuildingInfo(iBuilding).getFoundsCorporation() == -1 and gc.getBuildingInfo(iBuilding).getProductionCost() > 0:
						# iBuildings = pTeamX.getBuildingClassCount(gc.getBuildingInfo(iBuilding).getBuildingClassType())
						# if iBuildings > 0:
							# if iTeamX == pPlayer.getTeam(): iOwnWorldWonders += iBuildings
							# else: iOtherWorldWonders += iBuildings

				# iOtherWorldWondersTotal += iOtherWorldWonders
				# if iOtherWorldWonders > iMostWorldWonders: iMostWorldWonders = iOtherWorldWonders
				
			# # for iPlayerX in xrange(gc.getMAX_PLAYERS()):
				# # pPlayerX = gc.getPlayer(iPlayerX)
				# # if pPlayerX.getID() == pPlayer.getID():
					# # pCityX, iter = pPlayerX.firstCity(false)
					# # while(pCityX):
						# # if pCityX.getNumWorldWonders() > 0:
							# # iOwnWorldWonders += pCityX.getNumWorldWonders()
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_JEWISH_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CHRISTIAN_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ISLAMIC_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_HINDU_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_BUDDHIST_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CONFUCIAN_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_TAOIST_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_OLYMP_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ASEN_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_VOODOO_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_SHINTO_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ZORO_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_RA_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_TOLTEC_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_SHAMAN_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_FREEM_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_DRUID_SHRINE' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_1' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_2' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_3' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_4' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_5' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_6' )))
							# # iOwnWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_7' )))
						# # pCityX, iter = pPlayerX.nextCity(iter, false)
				# # elif pPlayerX.isAlive():
					# # iOtherWorldWonders = 0
					# # pCityX, iter = pPlayerX.firstCity(false)
					# # while(pCityX):
						# # if pCityX.getNumWorldWonders() > 0:
							# # iOtherWorldWonders += pCityX.getNumWorldWonders()
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_JEWISH_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CHRISTIAN_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ISLAMIC_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_HINDU_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_BUDDHIST_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CONFUCIAN_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_TAOIST_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_OLYMP_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ASEN_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_VOODOO_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_SHINTO_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_ZORO_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_RA_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_TOLTEC_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_SHAMAN_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_FREEM_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_DRUID_SHRINE' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_1' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_2' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_3' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_4' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_5' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_6' )))
							# # iOtherWorldWonders -= max(0, pCityX.getNumBuilding(gc.getInfoTypeForString( 'BUILDING_CORPORATION_7' )))
						# # pCityX, iter = pPlayerX.nextCity(iter, false)	
					# # iOtherWorldWondersTotal += iOtherWorldWonders
					# # if iOtherWorldWonders > iMostWorldWonders: iMostWorldWonders = iOtherWorldWonders
			
			# iCurrent += max(0, iMostWorldWonders - iOwnWorldWonders) 
			# # iCurrent = max(0, iCurrent + max(0, (iMostWorldWonders - iOwnWorldWonders)))
			# # iCurrent = max(0, iCurrent + iOtherWorldWondersTotal - iOwnWorldWonders)
			
			# if iCurrent >= iThreshold:
				# iThreshold += self.iHGA * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getGreatPeoplePercent() / 100
				# pCapital = pPlayer.getCapitalCity()
				# pCapital.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_ARCHITECT' ), False, False)
				# #pPlayer.changeGoldenAgeTurns(pPlayer.getGoldenAgeLength())
				# iCurrent = 0
				# #CyInterface().addMessage(iPlayer,True,15,CyTranslator().getText("TXT_KEY_TRIGGER_GOLDEN_AGE",()),'',0, '', -1, -1, -1, True,True)
			# sHappy = str(iCurrent) + "HGA" + str(iThreshold)

			# sScript = sHappy + "Split"
			# pPlayer.setScriptData(sScript)
## Cybah: BASE fr 6.1 E - Kreativ Counter		
# Aggressive Trait Start -----------------------------------------------------------------------------------------------
#		iAggTrait = gc.getInfoTypeForString("TRAIT_AGGRESSIVE")
#		if pPlayer.hasTrait(iAggTrait) and pPlayer.isAlive():
#			UnhappyCities = []
#			HappyCities = []
#			pAggCity, iter = pPlayer.firstCity(false)  
#			while(pAggCity):	  
#				if not pAggCity.isNone() and pAggCity.getOwner() == pPlayer.getID():
#					if pAggCity.happyLevel() < pAggCity.unhappyLevel(0):
#						UnhappyCities.append(pAggCity)
#						#strMessage = CyTranslator().getText("TXT_KEY_TRAIT_AGGRESSIVE_RESETTLEMENT", (pAggCity.getName(), pPlayer.getName(), pPlayer.getName()))
#						#CyInterface().addMessage(iPlayer, True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
#					elif pAggCity.happyLevel() > pAggCity.unhappyLevel(0):
#						HappyCities.append(pAggCity)
#						#strMessage = CyTranslator().getText("TXT_KEY_TRAIT_AGGRESSIVE_RESETTLEMENT", (pAggCity.getName(), pPlayer.getName(), pPlayer.getName()))
#						#CyInterface().addMessage(iPlayer, True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
#
#				pAggCity, iter = pPlayer.nextCity(iter, false)
#
#			if UnhappyCities:
#				if HappyCities:
#					iUnhappyCity = self.getRandomNumber( len(UnhappyCities) )
#					iHappyCity = self.getRandomNumber( len(HappyCities) )
#					UnhappyCities[iUnhappyCity].changePopulation(-1)
#					HappyCities[iHappyCity].changePopulation(1)
#					strMessage = CyTranslator().getText("TXT_KEY_TRAIT_AGGRESSIVE_RESETTLEMENT", (UnhappyCities[iUnhappyCity].getName(), HappyCities[iHappyCity].getName(), pPlayer.getName()))
#					CyInterface().addMessage(iPlayer, True, 20, strMessage, "", 0,'',-1,-1,-1, True, True)
# Aggressive Trait End -----------------------------------------------------------------------------------------------
# Philosophic Trait Start -----------------------------------------------------------------------------------------------
#		iPhiTrait = gc.getInfoTypeForString("TRAIT_PHILOSOPHICAL")	
#		if pPlayer.hasTrait(iPhiTrait) and pPlayer.isAlive():
#			if pPlayer.isGoldenAge():
#				if pPlayer.getNumUnitGoldenAges() > 3:
#					pPlayer.changeNumUnitGoldenAges(3 - pPlayer.getNumUnitGoldenAges())
# Philosophic Trait End -----------------------------------------------------------------------------------------------

		if (gc.getGame().getElapsedGameTurns() == 1):
			## rucivfan_ai_auto_play raap[
			#if (gc.getPlayer(iPlayer).isHuman()):
			if (gc.getPlayer(iPlayer).isHumanActive()):
			## ]rucivfan_ai_auto_play raap			
				if (gc.getPlayer(iPlayer).canRevolution(0)):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_CHANGECIVIC)
					popupInfo.addPopup(iPlayer)

		CvAdvisorUtils.resetAdvisorNags()
		CvAdvisorUtils.endTurnFeats(iPlayer)

# # +++++ MAP Reveal disable - Kriegsnebel - Fog of War (FoW) - Karte schwarz zurueckfaerben - OPTION WURDE ENTFERNT
		# if gc.getPlayer(iPlayer) != None:
			## rucivfan_ai_auto_play raap[
			## if gc.getPlayer(iPlayer).isHuman() and gc.getGame().isOption(GameOptionTypes.GAMEOPTION_FOG_OF_WAR):
			# if gc.getPlayer(iPlayer).isHumanActive() and gc.getGame().isOption(GameOptionTypes.GAMEOPTION_FOG_OF_WAR):
			## ]rucivfan_ai_auto_play raap
# #			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_FOG_OF_WAR):

				# MapH = CyMap().getGridHeight()
				# MapW = CyMap().getGridWidth()

				# iKartographie = gc.getInfoTypeForString("TECH_CARTOGRAPHY")
				# iTeam = gc.getPlayer(iPlayer).getTeam()
				# team = gc.getTeam(iTeam)
				# if team.isHasTech(iKartographie): bTechKarto = True
				# else: bTechKarto = False

				# for i in xrange (MapW):
					# for j in xrange (MapH):
						# pPlot = CyMap().plot(i, j)

						# if not pPlot.isVisible (iTeam, 0):
							# bGoBlack = true

							# # schwarz werden lassen
							# if pPlot.isCity():
								# pCity = pPlot.getPlotCity()
								# if pCity.getNumWorldWonders() > 0: bGoBlack = false

							# if bGoBlack:
								# if not bTechKarto: pPlot.setRevealed (iTeam,0,0,-1)
# # +++ -------

	def onEndTurnReady(self, argsList):
		iGameTurn = argsList[0]

	def onFirstContact(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Contact'
		iTeamX,iHasMetTeamY = argsList

		if gc.getGame().isFinalInitialized():
			TeamX = gc.getTeam(iTeamX)
			TeamY = gc.getTeam(iHasMetTeamY)
			LeaderX = TeamX.getLeaderID()
			LeaderY = TeamY.getLeaderID()
			PlayerX = gc.getPlayer(LeaderX)
			PlayerY = gc.getPlayer(LeaderY)
			pTeam = gc.getTeam(iTeamX)
			
# # Real Always War Start
# # Ist in das SDK gewandert
			# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ALWAYS_WAR) and gc.getGame().isOption(GameOptionTypes.GAMEOPTION_REAL_ALWAYS_WAR):
				## rucivfan_ai_auto_play raap[
				## if not TeamX.isHuman() and not TeamY.isHuman() and not pTeam.isAVassal() and not TeamY.isAVassal():
				# if not TeamX.isHumanActive() and not TeamY.isHumanActive() and not pTeam.isAVassal() and not TeamY.isAVassal():
				## ]rucivfan_ai_auto_play raap
					# iRandom = self.getRandomNumber(2)
					# if iRandom == 0:
						# TeamX.declareWar(iHasMetTeamY,False,WarPlanTypes.WARPLAN_TOTAL)
						# TeamX.setPermanentWarPeace(iHasMetTeamY,True)
						# TeamY.declareWar(iTeamX,False,WarPlanTypes.WARPLAN_TOTAL)
						# TeamY.setPermanentWarPeace(iTeamX,True)
					# else:
						# TeamY.declareWar(iTeamX,False,WarPlanTypes.WARPLAN_TOTAL)
						# TeamY.setPermanentWarPeace(iTeamX,True)
						# TeamX.declareWar(iHasMetTeamY,False,WarPlanTypes.WARPLAN_TOTAL)
						# TeamX.setPermanentWarPeace(iHasMetTeamY,True)
# # Real Always War End
# Diplomatic Trait Start -----------------------------------------------------------------------------------------------
#
# - DEAKTIVIERT WEGEN GROSSER STAATSMNNER
#			if PlayerX.hasTrait(gc.getInfoTypeForString('TRAIT_DIPLOMATIC')):
#				PlayerY.AI_changeAttitudeExtra(LeaderX, 2)
# Diplomatic Trait End -----------------------------------------------------------------------------------------------

			if pTeam.isVassal(iHasMetTeamY):
				pPlayer = gc.getPlayer(pTeam.getLeaderID())
				if pPlayer.isAlive():
# Cybah: BASE fr 6.2 A - ZE: Industriell Trait START ----------------------------------------------------------------------------------------------- deaktiviert
					# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")):
						# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_WORKSHOP"), YieldTypes.YIELD_PRODUCTION, 1)
# Cybah: BASE fr 6.2 A - ZE: Industriell Trait END -----------------------------------------------------------------------------------------------
# # Expansive Trait Start -----------------------------------------------------------------------------------------------
					# iTraitExp = gc.getInfoTypeForString("TRAIT_EXPANSIVE")
					# if pPlayer.hasTrait(iTraitExp):
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GRANARY"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_LIGHTHOUSE"), 1)
						# pPlayer.changeExtraBuildingClassHealth(gc.getInfoTypeForString("BUILDINGCLASS_SUPERMARKET"), 1)
# # Expansive Trait End -----------------------------------------------------------------------------------------------
# ZE: Zivilisationseigenschaften Start -----------------------------------------------------------------------------------------------
					if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS):
# ZE: Khmer Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
							for eBuilding in xrange ( gc.getNumBuildingInfos() ):
								# 6.2 D - MONASTERY mit TEMPLE getauscht
								# if (gc.getBuildingInfo(eBuilding).getSpecialBuildingType() != -1 and gc.getBuildingInfo(eBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_MONASTERY")):
								if (gc.getBuildingInfo(eBuilding).getSpecialBuildingType() != -1 and gc.getBuildingInfo(eBuilding).getSpecialBuildingType() == gc.getInfoTypeForString("SPECIALBUILDING_TEMPLE")):
									pPlayer.changeExtraBuildingClassHealth(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
# ZE: Khmer End -----------------------------------------------------------------------------------------------
# ZE: Inka 2/3 Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT - jetzt +1 GPP pro Weltwunder (SDK)
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
							# for eBuilding in xrange ( gc.getNumBuildingInfos() ):
								# # if isWorldWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()):
									# # pPlayer.changeExtraBuildingClassHappiness(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
									
								# # Cybah: BASE fr 6.1 D - Nationalwunderbonus anstelle des Goldeffekts // deaktiviert mit 6.1 F
								# # if eBuilding != gc.getInfoTypeForString("BUILDING_PALACE") and isNationalWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()):
									# # pPlayer.changeExtraBuildingClassHappiness(gc.getBuildingInfo(eBuilding).getBuildingClassType(), 1)
# ZE: Inka 2/3 End -----------------------------------------------------------------------------------------------
# ZE: Deutschland Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_VILLAGE"), YieldTypes.YIELD_PRODUCTION, 1)
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_TOWN"), YieldTypes.YIELD_PRODUCTION, 1)
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_WORKSHOP"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Deutschland End -----------------------------------------------------------------------------------------------
# ZE: Brasilien 3/3 Start ----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_LUMBERMILL"), YieldTypes.YIELD_PRODUCTION, 2)
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PLANTATION"), YieldTypes.YIELD_FOOD, 1)
# ZE: Brasilien 3/3 End ----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 F - ZE: thiopien Start (Zweiter Teil im SDK) deaktiviert -----------------------------------------------------------------------------------------------
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPA"):
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_TOWN"), YieldTypes.YIELD_COMMERCE, -1)
# Cybah: BASE fr 6.1 F - ZE: thiopien End (Zweiter Teil im SDK) -----------------------------------------------------------------------------------------------
# ZE: England Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_FISHING_BOATS"), YieldTypes.YIELD_COMMERCE, 1)
# ZE: England End -----------------------------------------------------------------------------------------------
# ZE: Berber Start ----------------------------------------------------------------------------------------------- // DEAKTIVIERT MIT 6.3 C (jetzt im SDK)
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_NOMAD_CAMP"), YieldTypes.YIELD_COMMERCE, 2)
# ZE: Berber End -----------------------------------------------------------------------------------------------
# ZE: Indianer 1/2 Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
							pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_NOMAD_CAMP"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Indianer 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Ungarn Start (ersetzt in 6.3 C) -----------------------------------------------------------------------------------------------
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_FOOD, 1)
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_PRODUCTION, 1)
							# pPlayer.changeImprovementYieldChange(gc.getInfoTypeForString("IMPROVEMENT_PASTURE"), YieldTypes.YIELD_COMMERCE, 1)
# ZE: Ungarn End -----------------------------------------------------------------------------------------------
# ZE: Babylon 1/2 Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
							pPlayer.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_WALLS"), 1)
							pPlayer.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_COURTHOUSE"), 1)
# ZE: Babylon 1/2 Start -----------------------------------------------------------------------------------------------
# ZE: Maya 6.3 C - Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
							pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_SLAVE"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Maya 6.3 C - End -----------------------------------------------------------------------------------------------
# ZE: China Start -----------------------------------------------------------------------------------------------
						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
							# 6.3 C - Gendert zu 2 Produktion
							# pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), CommerceTypes.COMMERCE_RESEARCH, 3)
							pPlayer.changeSpecialistExtraYield(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), YieldTypes.YIELD_PRODUCTION, 2)
							pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_GENERAL"), CommerceTypes.COMMERCE_ESPIONAGE, 6)
# ZE: China End -----------------------------------------------------------------------------------------------
# ZE: sterreich Start -----------------------------------------------------------------------------------------------
						# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
							# # pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_GOLD, 3)
							# pPlayer.changeSpecialistExtraCommerce(gc.getInfoTypeForString("SPECIALIST_GREAT_ARTIST"), CommerceTypes.COMMERCE_CULTURE, 3)
# ZE: sterreich End -----------------------------------------------------------------------------------------------
# ZE: Portugal Start -----------------------------------------------------------------------------------------------
			if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS) and PlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
				MapH = CyMap().getGridHeight()
				MapW = CyMap().getGridWidth()
				for i in xrange (MapW):
					for j in xrange (MapH):
						pPlot = CyMap().plot(i, j)
						if pPlot.isVisible (iHasMetTeamY, 0): pPlot.setRevealed (iTeamX, 1,0,-1)
# ZE: Portugal End -----------------------------------------------------------------------------------------------
# ZE: NO CIV TRAITS START -----------------------------------------------------------------------------------------------
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS):
			pTeam = gc.getTeam(iTeamX)
			iPlayer = pTeam.getLeaderID()
			if pTeam.isVassal(iHasMetTeamY):
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_AMERICA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ARABIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_AUSTRIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_AZTEC"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_BABYLON"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_BERBER"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_BRAZIL"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_BYZANTIUM"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_CARIBBEAN"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_CARTHAGE"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_CELT"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_CHINA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_NETHERLANDS"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_EGYPT"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ENGLAND"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ETHIOPIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_FRANCE"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_GERMANY"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_GREECE"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_HOLY_ROMAN"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_HUNGARY"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_INCA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_INDIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_INDONESIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ISRAEL"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_JAPAN"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_KHMER"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_KOREA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_MALI"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_MAYA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_MONGOL"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_NATIVE_AMERICA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_VIKING"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_OTTOMAN"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_PERSIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_POLAND"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_POLYNESIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_PORTUGAL"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ROME"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_RUSSIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_SCOTLAND"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_SPAIN"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_SUMERIA"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_TIBET"), false, iPlayer, false, false)
				pTeam.setHasTech(gc.getInfoTypeForString("TECH_ZULU"), false, iPlayer, false, false)
# ZE: NO CIV TRAITS END -----------------------------------------------------------------------------------------------
# ZE: Zivilisationseigenschaften End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_CONTACT):
			return
		CvUtil.pyPrint('Team %d has met Team %d' %(iTeamX, iHasMetTeamY))
	
	def onCombatResult(self, argsList):
		'Combat Result'
# Cybah: BASE fr 6.4 C - bool bWinnerIsAttacker hinzugefgt
		# pWinner,pLoser = argsList
		pWinner, pLoser, bWinnerIsAttacker = argsList
		playerX = PyPlayer(pWinner.getOwner())
		unitX = PyInfo.UnitInfo(pWinner.getUnitType())
		playerY = PyPlayer(pLoser.getOwner())
		unitY = PyInfo.UnitInfo(pLoser.getUnitType())

		pPlayer = gc.getPlayer(pWinner.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())
		ppPlayer = gc.getPlayer(pLoser.getOwner())
		ppTeam = gc.getTeam(ppPlayer.getTeam())
		bWinnerGotHeroicPromo = False

# Ordnungshoheit / Schutz vor Revolten / Pharaonengarde Start -----------------------------------------------------------------------------------------------

		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_RIOTPOLICE")) and not pWinner.isMadeAttack():
			pCombatPlot1 = CyMap().plot(pLoser.getX(), pLoser.getY())
			pCombatPlot2 = CyMap().plot(pWinner.getX(), pWinner.getY())
			if pCombatPlot2.isCity():
				pCity = pCombatPlot2.getPlotCity()
				if pCity.getOwner() == pWinner.getOwner() and pCity.calculateTeamCulturePercent(pPlayer.getTeam()) >= 10:

					# 5% Chance pro Bevlkerung
					# iReinforcements = min(100, (pCity.getPopulation() * 5))
					# test
					iReinforcements = min(100, (pCity.getPopulation() * 100))
					iRandom = self.getRandomNumber(100)

					if iReinforcements > iRandom:
						for i in xrange(1):

							# rucivfan_conscript_extended rce[
							#pUnitID = pCity.getConscriptUnit()
							pUnitID = pCity.getConscriptUnit(false)	# true fr keine reinen Verteidigungseinheiten
							# ]rucivfan_conscript_extended rce
							
							pNewUnit = pPlayer.initUnit( pUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							pCity.addProductionExperience(pNewUnit, false)

							strMessage = CyTranslator().getText( "TXT_KEY_TRAIT_PROTECTIVE_SUPPORT", (pPlayer.getName(),pNewUnit.getName(),pCity.getName() ) )
							strMessage2 = CyTranslator().getText( "TXT_KEY_TRAIT_PROTECTIVE_SUPPORT_ENEMY", (pPlayer.getName(),pNewUnit.getName(),pCity.getName() ) )
							# rucivfan: Korrektur richtiger Button Start
							CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, pNewUnit.getButton(), ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
							CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage2, "", 0, pNewUnit.getButton(), ColorTypes(7), pCity.getX(), pCity.getY(), True, True)
							# rucivfan: Korrektur richtiger Button Ende

# Ordnungshoheit / Schutz vor Revolten / Pharaonengarde End -----------------------------------------------------------------------------------------------
# Trafalgar Square Start -----------------------------------------------------------------------------------------------

		if unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL") and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
			b_Trafal = gc.getInfoTypeForString("BUILDING_TRAFALGAR_SQUARE")
			obsoleteTech = gc.getBuildingInfo(b_Trafal).getObsoleteTech()
			if obsoleteTech == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTech):
				if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_TRAFALGAR_SQUARE")) > 0:
					pWinner.changeExperience(1,-1,True,False,False)

# Trafalgar Square End -----------------------------------------------------------------------------------------------
# Flavisches Amphitheater Start -----------------------------------------------------------------------------------------------

		if not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
			b_Flavian = gc.getInfoTypeForString("BUILDING_FLAVIAN")
			obsoleteTech2 = gc.getBuildingInfo(b_Flavian).getObsoleteTech()
			if obsoleteTech2 == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTech2):
				if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_FLAVIAN")) > 0:
					pWinner.changeExperience(1,-1,True,False,False)

# Flavisches Amphitheater End -----------------------------------------------------------------------------------------------
# ZE: Tibet Start -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_TIBET") and pPlayer.isAlive():
			# iTechZETIBET = gc.getInfoTypeForString("TECH_TIBET")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZETIBET):
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and unitY.getDomainType() == DomainTypes.DOMAIN_LAND:
					# if pWinner.baseCombatStr() < pLoser.baseCombatStr():
						# iStrDiff = int(pLoser.baseCombatStr() - pWinner.baseCombatStr())
						# pPlayer.changeCombatExperience(iStrDiff)
# ZE: Tibet End -----------------------------------------------------------------------------------------------
# ZE: Persien Start (Bewegungsbonus whrend GZ ist im SDK)  -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA") and pPlayer.isGoldenAge():
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PERSIA")):
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND:
					# if pWinner.baseCombatStr() > 0:
						# pWinner.changeExperience(1,-1,True,False,False)
# ZE: Persien End (Bewegungsbonus whrend GZ ist im SDK)  -----------------------------------------------------------------------------------------------		
# ZE: Kelten 1/2 Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.3 C (ersetzt durch neuen SDK Effekt)
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
			# iTechZECELT = gc.getInfoTypeForString("TECH_CELT")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZECELT):
				# pZECombatPlot1 = CyMap().plot(pLoser.getX(), pLoser.getY())
				# pZECombatPlot2 = CyMap().plot(pWinner.getX(), pWinner.getY())
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and (pZECombatPlot1.isHills() or pZECombatPlot2.isHills()):
					# # rucivfan: Korrektur richtiger Button Start
					# CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_IMPERIALIST_GET_XP",()),'',0, pWinner.getButton(),ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
					# # rucivfan: Korrektur richtiger Button Ende
					# pWinner.changeExperience(1,-1,False,False,False)
# ZE: Kelten 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Schottland Start ----------------------------------------------------------------------------------------------- ersetzt durch neue Eigenschaft in 6.1 F
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCOTLAND"):
			# iTechZESCOT = gc.getInfoTypeForString("TECH_SCOTLAND")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESCOT):
				# pZECombatPlot1 = CyMap().plot(pLoser.getX(), pLoser.getY())
				# pZECombatPlot2 = CyMap().plot(pWinner.getX(), pWinner.getY())
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and (pZECombatPlot1.isCity() or pZECombatPlot2.isCity()):
					# pWinner.changeExperience(1,-1,False,False,False)
					# # rucivfan: Korrektur richtiger Button Start
					# CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_IMPERIALIST_GET_XP",()),'',0,pWinner.getButton(),ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
					# # rucivfan: Korrektur richtiger Button Ende
# ZE: Schottland End -----------------------------------------------------------------------------------------------
# ZE: thiopien 1/2 Start -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA"):
			# iTechETHI = gc.getInfoTypeForString("TECH_ETHIOPIA")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechETHI):
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA:
					# #if pPlayer.getNumCities() < ppPlayer.getNumCities():
						# #pWinner.changeExperience(2,-1,False,False,False)
						# # rucivfan: Korrektur richtiger Button Start
						# CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_IMPERIALIST_GET_XP",()),'',0,pWinner.getButton(),ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
						# # rucivfan: Korrektur richtiger Button Ende
					# if ppPlayer.getPower() > pPlayer.getPower():
						# iBraveryTech = gc.getInfoTypeForString("TECH_IRON_WORKING")
						# if gc.getTeam(pPlayer.getTeam()).isHasTech(iBraveryTech):
							# if not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")) and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")): 
								# pWinner.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), true)
								# bWinnerGotHeroicPromo = True
# ZE: thiopien 1/2 End -----------------------------------------------------------------------------------------------
# # ZE: Ungarn Start -----------------------------------------------------------------------------------------------
		# if unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOUNTED") and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
			# iTechZEHUN = gc.getInfoTypeForString("TECH_HUNGARY")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHUN) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
				# pWinner.changeExperience(1,-1,False,False,False)
				# # rucivfan: Korrektur richtiger Button Start
				# CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_IMPERIALIST_GET_XP",()),'',0,pWinner.getButton(),ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
				# # rucivfan: Korrektur richtiger Button Ende
# # ZE: Ungarn End -----------------------------------------------------------------------------------------------
# ZE: Rom Start (DEAKTIVIERT IN 6.3 C) -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ROME")):
			# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA:
				# if not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER") and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
					# pPlayer.changeCombatExperience(1)
# ZE: Rom End -----------------------------------------------------------------------------------------------
# ZE: Karthago Start -----------------------------------------------------------------------------------------------
#		if unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOUNTED") and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
#			iTechZECA = gc.getInfoTypeForString("TECH_CARTHAGE")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZECA) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
#				if pPlayer.isGoldenAge():
#					pPlayer.changeCombatExperience(3)
#				else:
#					pPlayer.changeCombatExperience(1)
# ZE: Karthago End -----------------------------------------------------------------------------------------------
# (Imperialist Trait Start) Great Generals Start -----------------------------------------------------------------------------------------------

		if pPlayer.isAlive() and not ppPlayer.isBarbarian():
			iImpExpGet = self.getRandomNumber( 1000 )
			
			# Cybah: BASE fr 6.1 E  - Imp haben auch hhere Chance (~50%)
			iTraitImp = gc.getInfoTypeForString("TRAIT_IMPERIALIST")
			if pPlayer.hasTrait(iTraitImp): iImpExpGet = self.getRandomNumber( 666 )
			
			if iImpExpGet >= 0 and iImpExpGet <= 332:
				pCombatPlot = CyMap().plot(pWinner.getX(), pWinner.getY())
				for iUnit in xrange(pCombatPlot.getNumUnits()):
					if pCombatPlot.getUnit(iUnit).isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):
						pWinner.changeExperience(1,-1,False,False,False)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_IMPERIALIST_GET_XP",()),'',0,gc.getPromotionInfo(gc.getInfoTypeForString("PROMOTION_LEADER")).getButton(),ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
						break

# (Imperialist Trait End) Great Generals End -----------------------------------------------------------------------------------------------
# Bravery Start -----------------------------------------------------------------------------------------------

		if pTeam.isHasTech(gc.getInfoTypeForString("TECH_IRON_WORKING")) and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):

			iBraveryChance = self.getRandomNumber( 1000 )
# Militrwesen 1/2 Start -----------------------------------------------------------------------------------------------
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_MILITARY_TRADITION")):
				iBraveryChance *= 2
				iBraveryChance /= 3
# Militrwesen 1/2 End -----------------------------------------------------------------------------------------------
# Charismatic Start -----------------------------------------------------------------------------------------------
			iTraitCha = gc.getInfoTypeForString("TRAIT_CHARISMATIC")
			if pPlayer.hasTrait(iTraitCha) and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
				if not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")) and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")): 
					pWinner.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), true)
					bWinnerGotHeroicPromo = True
# Charismatic End -----------------------------------------------------------------------------------------------

			# Test - ansonsten auskommentieren
			# iBraveryChance = 0

			if bWinnerGotHeroicPromo != True and not unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):

				# if (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARCHER")) or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR")) or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MECHANIZED")) or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER")) or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MELEE"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOTORIZED"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOUNTED"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SPECIAL"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SUBMARINE"))  or (unitX.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH")):

				if not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")):
					if iBraveryChance <= 29 and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")):
						iBravery1 = gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")
						pWinner.setHasPromotion(iBravery1, true)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_HEROIC_STRENGTH",()),'',0,'Art/Interface/Buttons/Promotions/Military1.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)

				elif pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")) and not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH2")):
					if iBraveryChance <= 39 and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH2")):
						iBravery2 = gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH2")
						pWinner.setHasPromotion(iBravery2, true)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_HEROIC_STRENGTH",()),'',0,'Art/Interface/Buttons/Promotions/Military2.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)

				elif pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH2")) and not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH3")):
					if iBraveryChance <= 49 and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH3")):
						iBravery3 = gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH3")
						pWinner.setHasPromotion(iBravery3, true)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_HEROIC_STRENGTH",()),'',0,'Art/Interface/Buttons/Promotions/Military3.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)

				elif pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH3")) and not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH4")):
					if iBraveryChance <= 59 and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH4")):
						iBravery4 = gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH4")
						pWinner.setHasPromotion(iBravery4, true)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_HEROIC_STRENGTH",()),'',0,'Art/Interface/Buttons/Promotions/Military4.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)

				elif pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH4")) and not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH5")):
					if iBraveryChance <= 69 and pWinner.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH5")):
						iBravery5 = gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH5")
						pWinner.setHasPromotion(iBravery5, true)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_HEROIC_STRENGTH",()),'',0,'Art/Interface/Buttons/Promotions/Military5.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
						
				# 6.4 A - Ab Tapferkeit 5 besteht eine 1% Chance dass ein groer General geboren wird
				elif pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH5")) and pPlayer.isAlive():
					iGreatGeneralChance = self.getRandomNumber( 1000 )
					if iGreatGeneralChance >= 990:
						pCapital = pPlayer.getCapitalCity()
						# kein createGreatPeople, damit es keine doppelten mit Triumpfbogen gibt
						newGeneral = pPlayer.initUnit(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), pCapital.getX(), pCapital.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.NO_DIRECTION)
						strMessage1 = CyTranslator().getText("TXT_KEY_MISC_GP_BORN_BASE", (newGeneral.getName(), pCapital.getName(), pPlayer.getName()))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0, newGeneral.getButton(), ColorTypes(11), pCapital.getX(), pCapital.getY(), True, True)
						pActivePlayer = gc.getActivePlayer()
						if pActivePlayer:
							if pActivePlayer.getID() == pPlayer.getID(): CyAudioGame().Play2DSound("AS2D_UNIT_GREATPEOPLE")

# Bravery End -----------------------------------------------------------------------------------------------
# Ghazi Start -----------------------------------------------------------------------------------------------

		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GHAZI")) and unitX.getDomainType() == DomainTypes.DOMAIN_LAND and unitY.getDomainType() == DomainTypes.DOMAIN_LAND:
			iGold = playerY.getGold()
			if iGold >= 500:
				iGoldStolen1 = 100
				iGoldStolen2 = 100
				playerY.changeGold( -iGoldStolen1 )
				playerX.changeGold( +iGoldStolen2 )
				strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_WINNER", (playerY.getName(), (iGoldStolen2)))
				strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_LOSER", (playerX.getName(), (iGoldStolen1)))
				CyInterface().addMessage(playerX.getID(), True, 20, strMessage1, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)
				CyInterface().addMessage(playerY.getID(), True, 20, strMessage2, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(7), pLoser.getX(), pLoser.getY(), True, True)
			elif iGold >= 50:
				iGoldStolen1 = ( iGold//5 )
				iGoldStolen2 = max(10, iGoldStolen1)
				playerY.changeGold( -iGoldStolen1 )
				playerX.changeGold( +iGoldStolen2 )
				strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_WINNER", (playerY.getName(), (iGoldStolen2)))
				strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_LOSER", (playerX.getName(), (iGoldStolen1)))
				CyInterface().addMessage(playerX.getID(), True, 20, strMessage1, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)
				CyInterface().addMessage(playerY.getID(), True, 20, strMessage2, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(7), pLoser.getX(), pLoser.getY(), True, True)
			else:
				if iGold >= 20:
					iGoldStolen1 = ( iGold//5 )
					playerY.changeGold( -iGoldStolen1 )	
					strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_LOSER", (playerX.getName(), (iGoldStolen1)))
					CyInterface().addMessage(playerY.getID(), True, 20, strMessage2, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(7), pLoser.getX(), pLoser.getY(), True, True)						
				iGoldStolen2 = max(10, ( iGold//5 ))
				playerX.changeGold( +iGoldStolen2 )
				strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_WINNER", (playerY.getName(), (iGoldStolen2)))
				CyInterface().addMessage(playerX.getID(), True, 20, strMessage1, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)

		# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and unitY.getDomainType() == DomainTypes.DOMAIN_LAND:
			# pCombatPlot = CyMap().plot(pWinner.getX(), pWinner.getY())
			# for iUnit in xrange(pCombatPlot.getNumUnits()):
				# if pCombatPlot.getUnit(iUnit).isHasPromotion(gc.getInfoTypeForString("PROMOTION_GHAZI")):
					# iGold = playerY.getGold()
					# if iGold >= 500:
						# playerY.changeGold( -20 )
						# playerX.changeGold( +20 )
						# break
					# elif iGold >= 25:
						# iGoldStolen1 = ( iGold//25 )
						# iGoldStolen2 = min(20, (5 + iGoldStolen1))
						# playerY.changeGold( -iGoldStolen1 )
						# playerX.changeGold( +iGoldStolen2 )
						# break

# Ghazi End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - ZE: Karibik START - Runderneuert, jetzt abhngig von den Produktionskosten besiegter Einheiten -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_WORKER") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
			iTechZECA = gc.getInfoTypeForString("TECH_CARIBBEAN")
			if (gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZECA) and (unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA)):
				iUnit = pLoser.getUnitType()
				iProdCost = gc.getUnitInfo(iUnit).getProductionCost()
				if iProdCost > 0:
				
					iProdCost1000 = 1000 * iProdCost
				
					# Speed Modifier				
					iTheSpeed = CyGame().getGameSpeedType()
					TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
					iProdCost1000 *= (TheSpeed.getTrainPercent() / 100)
					
					# - Spieloption erhhte Einheitenproduktionskosten -
					if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
						# ra der besiegten Einheit feststellen
						if gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()) > 0: iEra = gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()).getEra()
						else: iEra = 0
						for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
							iPrereqX = gc.getUnitInfo(iUnit).getPrereqAndTechs(k)
							if iPrereqX >= 0:
								iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTechs(k)).getEra())
						iEraFaktor = iEra
						if iEra > 5: iEraFaktor = 5
						iProdCost1000 *= 100 + iEraFaktor * 10
						iProdCost1000 /= 100
				
					# Random Range des Goldes festlegen
					if not pPlayer.isGoldenAge():
						iKaribikGold = (1000 + self.getRandomNumber(iProdCost1000))
						iKaribikGold /= 1000
					
					# im Goldenen Zeitalter stets das Maximum
					else: iKaribikGold = (iProdCost1000 / 1000)
					
					# Maximal 1 Gold fr je 2 Produktionskosten
					if (iKaribikGold > 1):
						iKaribikGold /= 2
						
					iEnemyTreasure = max(0, (playerY.getGold() - iKaribikGold))
				
					playerX.changeGold(+iKaribikGold)
					playerY.setGold(iEnemyTreasure)
					#strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_WINNER", (ppPlayer.getName(), (iGoldStolen)))
					#strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_MARAUDER_LOSER", (pPlayer.getName(), (iGoldStolen)))
					#CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)
					#CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage2, "", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(7), pLoser.getX(), pLoser.getY(), True, True)

# Cybah: BASE fr 6.3 C - ZE: Karibik END -----------------------------------------------------------------------------------------------
# Charismatic Trait LANDEINHEITEN and Slave Unit Start -----------------------------------------------------------------------------------------------

		if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and unitY.getDomainType() == DomainTypes.DOMAIN_LAND and pPlayer.isAlive() and not pPlayer.isBarbarian():

			if (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANTIAIR")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARCHER")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MECHANIZED")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN"))or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MELEE")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOTORIZED")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_RECON")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SIEGE")):

				iGetSlave = self.getRandomNumber( 1000 )
# ZE: Maya 6.3 C Start -----------------------------------------------------------------------------------------------
				iTechZESTECH1 = gc.getInfoTypeForString("TECH_MAYA")
				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESTECH1) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
					iGetSlave /= 2
# ZE: Maya 6.3 C End -----------------------------------------------------------------------------------------------
# Prtorianer Start -----------------------------------------------------------------------------------------------
				# 6.4 C - Statt immer 10-fache Chance nur noch bei eigenen Angriffen
				# if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ROYAL_GUARD")) and iGetSlave < 250:
					# iGetSlave = 1
				if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ROYAL_GUARD")) and bWinnerIsAttacker and iGetSlave < 250:
					iGetSlave = 1
# Prtorianer End -----------------------------------------------------------------------------------------------
				pPlotLoser = CyMap().plot(pLoser.getX(), pLoser.getY())
				pPlotWinner = CyMap().plot(pWinner.getX(), pWinner.getY())
				if iGetSlave < 25 and not pPlotLoser.isWater() and not pPlotWinner.isWater():
# ZE: Rom 1/2 Start -----------------------------------------------------------------------------------------------
					iTechZERO = gc.getInfoTypeForString("TECH_ROME")
					if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZERO) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME") and (pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_ANCIENT") or pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_CLASSICAL") or pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MEDIEVAL")):
						pSlaveUnit = pPlayer.initUnit(gc.getInfoTypeForString('UNIT_GLADIATOR'), pWinner.getX(), pWinner.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.DIRECTION_SOUTH)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_GET_SLAVE_WINNER",()),'',0,'Art/Units/Gladiator/button_gladiator.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)				
					else:
						pSlaveUnit = pPlayer.initUnit(gc.getInfoTypeForString('UNIT_SLAVE'), pWinner.getX(), pWinner.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.DIRECTION_SOUTH)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_GET_SLAVE_WINNER",()),'',0,'Art/Units/Slave/button_slave.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
# ZE: Rom 1/2 End -----------------------------------------------------------------------------------------------
# Slave Unit End -----------------------------------------------------------------------------------------------

				elif not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FEARLESS")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GHAZI")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ROYAL_GUARD")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPARTAN")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPOILS_OF_WAR")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_RAGE")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GRANDMASTER")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_TERROR")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_INSPIRATION")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PIERCE")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FAITH_HEALING")):

					bGoOver = False
					iTrait = gc.getInfoTypeForString("TRAIT_CHARISMATIC")
					iGoOver = self.getRandomNumber( 1000 )
					pTeam = gc.getTeam(pPlayer.getTeam())

					# --- Zum Testen ---
					# iGoOver = 1
					
					# Kein berlaufen wenn Limit der Klasse erreicht ist
					if pTeam.isUnitClassMaxedOut(unitY.getUnitClassType(), (pTeam.getUnitClassMaking(unitY.getUnitClassType()))) or pPlayer.isUnitClassMaxedOut(unitY.getUnitClassType(), (pPlayer.getUnitClassMaking(unitY.getUnitClassType()))):
						iGoOver = -1

					# --- 10% Chance ---
					# if iGoOver >= 0 and iGoOver <= 99 and pPlayer.hasTrait(iTrait):

					# --- 25% Chance ---
					if iGoOver >= 0 and iGoOver <= 249 and pPlayer.hasTrait(iTrait):

						bGoOver = True

						iUnit = pLoser.getUnitType()
						newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
						pLoser.setDamage(90, False)
						
						# --- Fracht tten ---
						if pLoser.hasCargo():
							pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
							for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
								pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
								if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
									if pLoopUnit.isCargo():
										pTransportUnit = pLoopUnit.getTransportUnit()
										pTransID = pTransportUnit.getID()
										if pTransID == pLoser.getID():
											pLoopUnit.setDamage(100, false)

						# --- Vollstndige Heilung beider Einheiten - deaktiviert ---
						# pLoser.setDamage(0, False)
						# pWinner.setDamage(0, False)

						newUnit.convert(pLoser)
						pLoser.setDamage(100, False)
						newUnit.finishMoves()
						newUnit.setExperience(0, -1)
						
						if not pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING") or not gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_VIKING")):
							newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_VIKING"), False)

						#iTechMETALL = gc.getInfoTypeForString("TECH_IRON_WORKING")
						#if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechMETALL):
							#if newUnit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")) and not newUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")):
								#newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), True)

						# --- berlufer-Befrderung ---
						newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_LAND"), True)

						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_WINNER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
						CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_LOSER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)

# Charismatic Trait LANDEINHEITEN End -----------------------------------------------------------------------------------------------
# ZE: Mongolei 1/2 Start -----------------------------------------------------------------------------------------------

					if bGoOver == False and unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MOUNTED") and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
						iTechZE13 = gc.getInfoTypeForString("TECH_MONGOL")
						if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZE13):

							iGoOver = self.getRandomNumber( 400 )
							pTeam = gc.getTeam(pPlayer.getTeam())

							# --- Zum Testen ---
							# iGoOver = 1
							
							# Kein berlaufen wenn Limit der Klasse erreicht ist
							if pTeam.isUnitClassMaxedOut(unitY.getUnitClassType(), (pTeam.getUnitClassMaking(unitY.getUnitClassType()))) or pPlayer.isUnitClassMaxedOut(unitY.getUnitClassType(), (pPlayer.getUnitClassMaking(unitY.getUnitClassType()))):
								iGoOver = -1

							if iGoOver >= 0 and iGoOver <= 99:

								bGoOver = True

								iUnit = pLoser.getUnitType()
								newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
								pLoser.setDamage(90, False)
								
								# --- Fracht tten ---
								if pLoser.hasCargo():
									pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
									for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
										pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
										if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
											if pLoopUnit.isCargo():
												pTransportUnit = pLoopUnit.getTransportUnit()
												pTransID = pTransportUnit.getID()
												if pTransID == pLoser.getID():
													pLoopUnit.setDamage(100, false)

								# --- Vollstndige Heilung beider Einheiten - deaktiviert ---
								# pLoser.setDamage(0, False)
								# pWinner.setDamage(0, False)

								newUnit.convert(pLoser)
								pLoser.setDamage(100, False)
								newUnit.finishMoves()
								
								if not pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING") or not gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_VIKING")):
									newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_VIKING"), False)
								
								CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_WINNER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
								CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_LOSER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)

# ZE: Mongolei 1/2 End -----------------------------------------------------------------------------------------------
# Khan's Guard / Inspiration Start -----------------------------------------------------------------------------------------------
					if bGoOver == False and pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_INSPIRATION")):

						iGoOver = self.getRandomNumber( 200 )
						pTeam = gc.getTeam(pPlayer.getTeam())

						# --- Zum Testen ---
						# iGoOver = 1
						
						# Kein berlaufen wenn Limit der Klasse erreicht ist
						if pTeam.isUnitClassMaxedOut(unitY.getUnitClassType(), (pTeam.getUnitClassMaking(unitY.getUnitClassType()))) or pPlayer.isUnitClassMaxedOut(unitY.getUnitClassType(), (pPlayer.getUnitClassMaking(unitY.getUnitClassType()))):
							iGoOver = -1

						if iGoOver >= 0 and iGoOver <= 99:

							bGoOver = True

							iUnit = pLoser.getUnitType()
							newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
							pLoser.setDamage(90, False)
							
							# --- Fracht tten ---
							if pLoser.hasCargo():
								pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
								for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
									pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
									if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
										if pLoopUnit.isCargo():
											pTransportUnit = pLoopUnit.getTransportUnit()
											pTransID = pTransportUnit.getID()
											if pTransID == pLoser.getID():
												pLoopUnit.setDamage(100, false)

							# --- Vollstndige Heilung beider Einheiten - deaktiviert ---
							# pLoser.setDamage(0, False)
							# pWinner.setDamage(0, False)

							newUnit.convert(pLoser)
							pLoser.setDamage(100, False)
							newUnit.finishMoves()
							
							if not pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING") or not gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_VIKING")):
								newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_VIKING"), False)
							
							CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_INSPIRATION_WINNER",()),'',0,'Art/Interface/Buttons/Promotions/inspiration.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
							CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_INSPIRATION_LOSER",()),'',0,'Art/Interface/Buttons/Promotions/inspiration.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)

# Khan's Guard / Inspiration End -----------------------------------------------------------------------------------------------
# Wasser-Kriegsgefangene and Charismatic Trait WASSEREINHEITEN and Pirate Promotion Start -----------------------------------------------------------------------------------------------

		if unitX.getDomainType() == DomainTypes.DOMAIN_SEA and unitY.getDomainType() == DomainTypes.DOMAIN_SEA and pPlayer.isAlive():

			if (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL")) or (unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SUBMARINE")):

				bGoOver = False
				bGetSlave = False
				iGetSlave = self.getRandomNumber( 1000 )

# ZE: Maya 6.3 C Start -----------------------------------------------------------------------------------------------
				iTechZESTECH1 = gc.getInfoTypeForString("TECH_MAYA")
				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESTECH1) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
					iGetSlave /= 2
# ZE: Maya 6.3 C End -----------------------------------------------------------------------------------------------
				
				if iGetSlave < 25 and not pPlayer.isBarbarian():
					bGetSlave = True
					pCapital = pPlayer.getCapitalCity()
					
# ZE: Rom 1/2 Start -----------------------------------------------------------------------------------------------
					iTechZERO = gc.getInfoTypeForString("TECH_ROME")
					if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZERO) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME") and (pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_ANCIENT") or pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_CLASSICAL") or pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MEDIEVAL")):
						pSlaveUnit = pPlayer.initUnit(gc.getInfoTypeForString('UNIT_GLADIATOR'), pCapital.getX(), pCapital.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.DIRECTION_SOUTH)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_GET_SLAVE_WINNER",()),'',0,'Art/Units/Gladiator/button_gladiator.dds',ColorTypes(8), pCapital.getX(), pCapital.getY(), True,True)				
					else:
						pSlaveUnit = pPlayer.initUnit(gc.getInfoTypeForString('UNIT_SLAVE'), pCapital.getX(), pCapital.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.DIRECTION_SOUTH)
						CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_GET_SLAVE_WINNER",()),'',0,'Art/Units/Slave/button_slave.dds',ColorTypes(8), pCapital.getX(), pCapital.getY(), True,True)
# ZE: Rom 1/2 End -----------------------------------------------------------------------------------------------

# Pirate Promotion Start -----------------------------------------------------------------------------------------------
				if bGetSlave == False and pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):

					bNoPirate = False
# ZE: Nordreich 2/2 Start -----------------------------------------------------------------------------------------------
					# iTechZEVIKI = gc.getInfoTypeForString("TECH_VIKING")
					# if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEVIKI) and ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"):
						# bNoPirate = True
# ZE: Nordreich 2/2 End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Itsukushima-Torii Start -----------------------------------------------------------------------------------------------
					b_Torii = gc.getInfoTypeForString("BUILDING_TORII")
					obsoleteTech = gc.getBuildingInfo(b_Torii).getObsoleteTech()
					if obsoleteTech == -1 or not gc.getTeam(ppPlayer.getTeam()).isHasTech(obsoleteTech):
						if ppPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_TORII")) > 0:
							bNoPirate = True
# Cybah: BASE fr 6.1 E - Itsukushima-Torii End -----------------------------------------------------------------------------------------------

					if bNoPirate == False and pWinner.isBarbarian():
					
						# if unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"):
						# Barbaren haben jetzt auch nur noch eine Chance von 25%
						iBoardEnemyShip = self.getRandomNumber( 4 )
						if iBoardEnemyShip == 0 and unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"):
							bGoOver = True
							iUnit = pLoser.getUnitType()
							newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
							pLoser.setDamage(90, False)
							
							# --- Fracht tten ---
							if pLoser.hasCargo():
								pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
								for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
									pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
									if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
										if pLoopUnit.isCargo():
											pTransportUnit = pLoopUnit.getTransportUnit()
											pTransID = pTransportUnit.getID()
											if pTransID == pLoser.getID():
												pLoopUnit.setDamage(100, false)
							
							newUnit.convert(pLoser)
							pLoser.setDamage(100, False)
							newUnit.finishMoves()
							newUnit.setExperience(0, -1)
							
							# --- Gekapert-Befrderung = DEFECTOR_SEA ---
							newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_SEA"), True)
							newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_LAND"), False)
							
							CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_PIRATE_LOSER",()),'',0,'Art/Interface/Buttons/Promotions/pirate.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)

					elif bNoPirate == False and not pWinner.isBarbarian():
						bGoOver = False
						iBoardEnemyShip = self.getRandomNumber( 4 )
						if iBoardEnemyShip == 0:
							if unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"):
								bGoOver = True
								iUnit = pLoser.getUnitType()
								newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)	
								pLoser.setDamage(90, False)
								
								# --- Fracht tten ---
								if pLoser.hasCargo():
									pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
									for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
										pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
										if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
											if pLoopUnit.isCargo():
												pTransportUnit = pLoopUnit.getTransportUnit()
												pTransID = pTransportUnit.getID()
												if pTransID == pLoser.getID():
													pLoopUnit.setDamage(100, false)
								
								newUnit.convert(pLoser)
								pLoser.setDamage(100, False)
								newUnit.finishMoves()
								newUnit.setExperience(0, -1)
								
								# --- Gekapert-Befrderung = DEFECTOR_SEA ---
								newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_SEA"), True)
								newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_LAND"), False)
								
								CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_PIRATE_WINNER",()),'',0,'Art/Interface/Buttons/Promotions/pirate.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
								CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_PIRATE_LOSER",()),'',0,'Art/Interface/Buttons/Promotions/pirate.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)						

# Pirate Promotion End -----------------------------------------------------------------------------------------------
# Charismatic Trait Start -----------------------------------------------------------------------------------------------

				if bGetSlave == False and bGoOver == False and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_LAND")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_SEA")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):

					bGoOver = False

					iTrait = gc.getInfoTypeForString("TRAIT_CHARISMATIC")
					iGoOver = self.getRandomNumber( 1000 )
					pTeam = gc.getTeam(pPlayer.getTeam())

					# --- Zum Testen ---
					# iGoOver = 1
					
					# Kein berlaufen wenn Limit der Klasse erreicht ist
					if pTeam.isUnitClassMaxedOut(unitY.getUnitClassType(), (pTeam.getUnitClassMaking(unitY.getUnitClassType()))) or pPlayer.isUnitClassMaxedOut(unitY.getUnitClassType(), (pPlayer.getUnitClassMaking(unitY.getUnitClassType()))):
						iGoOver = -1

					# --- 10% Chance ---
					# if iGoOver >= 0 and iGoOver <= 99 and pPlayer.hasTrait(iTrait):

					# --- 25% Chance ---
					if iGoOver >= 0 and iGoOver <= 249 and pPlayer.hasTrait(iTrait):

						bGoOver = True

						iUnit = pLoser.getUnitType()
						newUnit = pPlayer.initUnit(iUnit, pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
						pLoser.setDamage(90, False)
						
						# --- Fracht tten ---
						if pLoser.hasCargo():
							pLoserPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
							for iLoopUnit in xrange(pLoserPlot.getNumUnits()):
								pLoopUnit = pLoserPlot.getUnit(iLoopUnit)
								if pLoopUnit and not pLoopUnit.isNone() and not pLoopUnit.isDead():
									if pLoopUnit.isCargo():
										pTransportUnit = pLoopUnit.getTransportUnit()
										pTransID = pTransportUnit.getID()
										if pTransID == pLoser.getID():
											pLoopUnit.setDamage(100, false)

						# --- Vollstndige Heilung beider Einheiten - deaktiviert ---
						# pLoser.setDamage(0, False)
						# pWinner.setDamage(0, False)

						newUnit.convert(pLoser)
						pLoser.setDamage(100, False)
						newUnit.finishMoves()
						newUnit.setExperience(0, -1)

						#iTechMETALL = gc.getInfoTypeForString("TECH_IRON_WORKING")
						#if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechMETALL):
							#if newUnit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")) and not newUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1")):
								#newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), True)

						# --- Gekapert-Befrderung (SEA) im Frieden bzw bei immer feindlichem Sieger, berlufer im Krieg (LAND) ---
						if pWinner.isAlwaysHostile() or not gc.getTeam(ppPlayer.getTeam()).isAtWar(pPlayer.getTeam()):
							newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_SEA"), True)
							CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_PIRATE_WINNER",()),'',0,'Art/Interface/Buttons/Promotions/pirate.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
							CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_PROMOTION_PIRATE_LOSER",()),'',0,'Art/Interface/Buttons/Promotions/pirate.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)
							
						elif gc.getTeam(ppPlayer.getTeam()).isAtWar(pPlayer.getTeam()):
							newUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFECTOR_LAND"), True)
							CyInterface().addMessage(pWinner.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_WINNER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(8), pWinner.getX(), pWinner.getY(), True,True)
							CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_TRAIT_CHARISMATIC_GO_OVER_LOSER",()),'',0,'Art/Interface/Buttons/whiteflag.dds',ColorTypes(7), pLoser.getX(), pLoser.getY(), True,True)
						
# Charismatic Trait End -----------------------------------------------------------------------------------------------
# Wasser-Kriegsgefangene and Charismatic Trait and Pirate Promotion End -----------------------------------------------------------------------------------------------
# Aggressive Trait Start -----------------------------------------------------------------------------------------------
		# if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SKIRMISHER")) and pLoser.canFight():
			# if not pWinner.canMove():
				# pWinner.setMoves(pWinner.maxMoves())
			
			# iMoveChange = 60
			# if(pWinner.getMoves() < iMoveChange):
				# pWinner.changeMoves(-pWinner.getMoves())
			# else:
				# pWinner.changeMoves(-iMoveChange)
				
		# rucivfan_movement_system_extended rmse[
		# iMoves entspricht dem alten iMovesLeft
		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SKIRMISHER")) and pLoser.canFight():
			pWinner.changeTempFlatMoves(1)
		# ]rucivfan_movement_system_extended rmse
# Aggressive Trait End -----------------------------------------------------------------------------------------------
# Cunning Trait Start -----------------------------------------------------------------------------------------------

		iTraitCun = gc.getInfoTypeForString("TRAIT_CUNNING")
		
		# Gewinner ist Listig ----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(iTraitCun) and pPlayer.isAlive() and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_WORKER") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ALIEN"):
 
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
			OtherPossibleTechsAlternate = []
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
			iUnit = pLoser.getUnitType()
			PrereqTechs = []
			iPrereqTech = gc.getUnitInfo(iUnit).getPrereqAndTech()
			if iPrereqTech >= 0 and not pTeam.isHasTech(iPrereqTech) and gc.getTechInfo(iPrereqTech).getEra() <= pPlayer.getCurrentEra():
				PrereqTechs.append(iPrereqTech)
			
			for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
				iPrereqAndTech = gc.getUnitInfo(iUnit).getPrereqAndTechs(k)
				if iPrereqAndTech >= 0 and not pTeam.isHasTech(iPrereqAndTech) and gc.getTechInfo(iPrereqAndTech).getEra() <= pPlayer.getCurrentEra():
					PrereqTechs.append(iPrereqAndTech)
					
			iFinalTech = -1
			iFinalTechPointsLeft = 0
			
			# Wenn man Kolben fr ne Prereq Tech bekommen kann
			if PrereqTechs:
				for i in xrange(len(PrereqTechs)):
					if pTeam.getResearchLeft(PrereqTechs[i]) > 0 and ((pTeam.getResearchLeft(PrereqTechs[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
						iFinalTechPointsLeft = pTeam.getResearchLeft(PrereqTechs[i])
						iFinalTech = PrereqTechs[i]
						
			# Wenn man KEINE Kolben fr ne Prereq Tech bekommen kann
			else:
				OtherPossibleTechs = []
				for iTechType in xrange(gc.getNumTechInfos()):							
					if gc.getTechInfo(iTechType).isTrade() and ppTeam.isHasTech(iTechType) and not pTeam.isHasTech(iTechType):
						if gc.getTechInfo(iTechType).getEra() <= pPlayer.getCurrentEra():
							OtherPossibleTechs.append(iTechType)
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
						else:
							OtherPossibleTechsAlternate.append(iTechType)
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
						
				if OtherPossibleTechs:
					for i in xrange(len(OtherPossibleTechs)):
						if pTeam.getResearchLeft(OtherPossibleTechs[i]) > 0 and ((pTeam.getResearchLeft(OtherPossibleTechs[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
							iFinalTechPointsLeft = pTeam.getResearchLeft(OtherPossibleTechs[i])
							iFinalTech = OtherPossibleTechs[i]
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
				elif OtherPossibleTechsAlternate:
					for i in xrange(len(OtherPossibleTechsAlternate)):
						if pTeam.getResearchLeft(OtherPossibleTechsAlternate[i]) > 0 and ((pTeam.getResearchLeft(OtherPossibleTechsAlternate[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
							iFinalTechPointsLeft = pTeam.getResearchLeft(OtherPossibleTechsAlternate[i])
							iFinalTech = OtherPossibleTechsAlternate[i]				
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
		
			if iFinalTech != -1 and iFinalTechPointsLeft > 0:
				
				iProdCost = gc.getUnitInfo(iUnit).getProductionCost()
					
				# Minimum: 8 Kolben pro 10 Produktion
				# iTechPoints1000 = 1000 * iProdCost * 8 / 10
				# JETZT (6.3 C): 20 Kolben pro 10 Produktion
				iTechPoints1000 = 1000 * iProdCost * 20 / 10
				
				# ra-Bonus (automatisch erhht mit 6.3 C, weil in Abhngigkeit von iTechPoints1000, was erhht wurde auf 20)
				iTechPointsPerEra = (iTechPoints1000 / 4)				
				iTechPoints1000 += (pPlayer.getCurrentEra() * iTechPointsPerEra)				
				
				# Speed Modifier				
				iTheSpeed = CyGame().getGameSpeedType()
				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
				iTechPoints1000 *= (TheSpeed.getTrainPercent() / 100)
				
				# ra der besiegten Einheit feststellen
				if gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()) > 0:
					iEra = gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()).getEra()
				else:	
					iEra = 0
				for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
					iPrereqX = gc.getUnitInfo(iUnit).getPrereqAndTechs(k)
					if iPrereqX >= 0:
						iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTechs(k)).getEra())

				# - Spieloption erhhte Einheitenproduktionskosten -
				if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
					iEraFaktor = iEra
					if iEra > 5: iEraFaktor = 5
					iTechPoints1000 *= 100 + iEraFaktor * 10
					iTechPoints1000 /= 100
					
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
				# Malus fr raunterschied
				# 100 = kein Malus
				iPossibleMalusModPercent = 100
				iEraDifference = max(0, (gc.getTechInfo(iFinalTech).getEra() - pPlayer.getCurrentEra()))
				if iEraDifference == 1: iPossibleMalusModPercent = 200
				elif iEraDifference == 2: iPossibleMalusModPercent = 400
				elif iEraDifference == 3: iPossibleMalusModPercent = 800
				elif iEraDifference == 4: iPossibleMalusModPercent = 1600
				elif iEraDifference == 5: iPossibleMalusModPercent = 3200
				elif iEraDifference == 6: iPossibleMalusModPercent = 6400
				elif iEraDifference >= 7: iPossibleMalusModPercent = 12800
				iTechPoints1000 *= 100
				iTechPoints1000 /= iPossibleMalusModPercent
# Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
					
				iTechPoints = (iTechPoints1000 / 1000)				
				if iTechPoints > 0:
					# Text generieren
					iTechCost = pTeam.getResearchCost(iFinalTech)
					iCurrentTechPoints = pTeam.getResearchProgress(iFinalTech)
					iPrePercents = (iCurrentTechPoints * 100) / iTechCost
					iPrePercents100 = (iCurrentTechPoints * 10000) / iTechCost
					iAfterPercents = min(100, (((iCurrentTechPoints + iTechPoints) * 100) / iTechCost))
					iAfterPercents100 = min(10000, (((iCurrentTechPoints + iTechPoints) * 10000) / iTechCost))
					iAfterTechPointsLeft = max(0, (pTeam.getResearchLeft(iFinalTech) - iTechPoints))
					if (iPrePercents100 < 1 and iAfterPercents100 > 0 and iAfterPercents < 100) or (iPrePercents < 25 and iAfterPercents >= 25 and iAfterPercents < 100) or (iPrePercents < 50 and iAfterPercents >= 50 and iAfterPercents < 100) or (iPrePercents < 75 and iAfterPercents >= 75 and iAfterPercents < 100):					
						strMessage = CyTranslator().getText("TXT_KEY_TRAIT_CUNNING_RESEARCH", (gc.getTechInfo(iFinalTech).getDescription(), iAfterPercents, iAfterTechPointsLeft))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getTechInfo(iFinalTech).getButton(), ColorTypes(11), pWinner.getX(), pWinner.getY(), True, True)
					# Techpunkte verteilen
					pTeam.changeResearchProgress(iFinalTech, iTechPoints, playerX.getID())
					
					# 6.3 C - Cunning Listig Counter
					if not SDTK.sdObjectExists( "Listig", pPlayer ):
						if iTechPoints > pTeam.getResearchLeft(iFinalTech):
							iStolenResearch = pTeam.getResearchLeft(iFinalTech)
						else:
							iStolenResearch = iTechPoints
						SDTK.sdObjectInit('Listig', pPlayer, {})
						SDTK.sdObjectSetVal( "Listig", pPlayer, 'iStolenResearch', iStolenResearch)
						
					else:
						# BugUtil.warn("Listig Script existiert")
						if SDTK.sdObjectGetVal( "Listig", pPlayer, 'iStolenResearch') == None or SDTK.sdObjectGetVal( "Listig", pPlayer, 'iStolenResearch') < 0:
							# BugUtil.warn("Inhalt von Listig Script ist None")
							if iTechPoints > pTeam.getResearchLeft(iFinalTech):
								iStolenResearch = pTeam.getResearchLeft(iFinalTech)
							else:
								iStolenResearch = iTechPoints
						else:
							if iTechPoints > pTeam.getResearchLeft(iFinalTech):
								iStolenResearch = (SDTK.sdObjectGetVal( "Listig", pPlayer, 'iStolenResearch') + pTeam.getResearchLeft(iFinalTech))
							else:
								iStolenResearch = (SDTK.sdObjectGetVal( "Listig", pPlayer, 'iStolenResearch') + iTechPoints)

					SDTK.sdObjectSetVal( "Listig", pPlayer, 'iStolenResearch', iStolenResearch)

		# # DEAKTIVIERT MIT 6.3 C	
		# # Verlierer ist Listig ----------------------------------------------------------------------------------------------
		# if ppPlayer.hasTrait(iTraitCun) and ppPlayer.isAlive() and unitX.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL") and unitX.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ALIEN"):
 
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
			# OtherPossibleTechsAlternate = []
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
			# iUnit = pLoser.getUnitType()
			# iUnit2 = pWinner.getUnitType()
			# PrereqTechs = []
			# iPrereqTech = gc.getUnitInfo(iUnit2).getPrereqAndTech()
			# if iPrereqTech >= 0 and not ppTeam.isHasTech(iPrereqTech) and gc.getTechInfo(iPrereqTech).getEra() <= ppPlayer.getCurrentEra():
				# PrereqTechs.append(iPrereqTech)
			
			# for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
				# iPrereqAndTech = gc.getUnitInfo(iUnit2).getPrereqAndTechs(k)
				# if iPrereqAndTech >= 0 and not ppTeam.isHasTech(iPrereqAndTech) and gc.getTechInfo(iPrereqAndTech).getEra() <= ppPlayer.getCurrentEra():
					# PrereqTechs.append(iPrereqAndTech)
					
			# iFinalTech = -1
			# iFinalTechPointsLeft = 0
			
			# # Wenn man Kolben fr ne Prereq Tech bekommen kann
			# if PrereqTechs:
				# for i in xrange(len(PrereqTechs)):
					# if ppTeam.getResearchLeft(PrereqTechs[i]) > 0 and ((ppTeam.getResearchLeft(PrereqTechs[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
						# iFinalTechPointsLeft = ppTeam.getResearchLeft(PrereqTechs[i])
						# iFinalTech = PrereqTechs[i]
						
			# # Wenn man KEINE Kolben fr ne Prereq Tech bekommen kann
			# else:
				# OtherPossibleTechs = []		
				# for iTechType in xrange(gc.getNumTechInfos()):							
					# if gc.getTechInfo(iTechType).isTrade() and pTeam.isHasTech(iTechType) and not ppTeam.isHasTech(iTechType):
						# if gc.getTechInfo(iTechType).getEra() <= ppPlayer.getCurrentEra():
							# OtherPossibleTechs.append(iTechType)
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
						# else:
							# OtherPossibleTechsAlternate.append(iTechType)
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
						
				# if OtherPossibleTechs:
					# for i in xrange(len(OtherPossibleTechs)):
						# if ppTeam.getResearchLeft(OtherPossibleTechs[i]) > 0 and ((ppTeam.getResearchLeft(OtherPossibleTechs[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
							# iFinalTechPointsLeft = ppTeam.getResearchLeft(OtherPossibleTechs[i])
							# iFinalTech = OtherPossibleTechs[i]
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
				# elif OtherPossibleTechsAlternate:
					# for i in xrange(len(OtherPossibleTechsAlternate)):
						# if ppTeam.getResearchLeft(OtherPossibleTechsAlternate[i]) > 0 and ((ppTeam.getResearchLeft(OtherPossibleTechsAlternate[i]) < iFinalTechPointsLeft) or (iFinalTech == -1)):
							# iFinalTechPointsLeft = ppTeam.getResearchLeft(OtherPossibleTechsAlternate[i])
							# iFinalTech = OtherPossibleTechsAlternate[i]				
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
						
			# if iFinalTech != -1 and iFinalTechPointsLeft > 0:
				
				# iProdCost = gc.getUnitInfo(iUnit).getProductionCost()
					
				# # Minimum: 8 Kolben pro 10 Produktion
				# iTechPoints1000 = 1000 * iProdCost * 8 / 10
				
				# # ra-Bonus
				# iTechPointsPerEra = (iTechPoints1000 / 4)			
				# iTechPoints1000 += (ppPlayer.getCurrentEra() * iTechPointsPerEra)
				
				# # Speed Modifier				
				# iTheSpeed = CyGame().getGameSpeedType()
				# TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
				# iTechPoints1000 *= (TheSpeed.getTrainPercent() / 100)
					
				# # - Spieloption erhhte Einheitenproduktionskosten -
				# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
					# if gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()) > 0:
						# iEra = gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()).getEra()
					# else:	
						# iEra = 0
					# for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
						# iPrereqX = gc.getUnitInfo(iUnit).getPrereqAndTechs(k)
						# if iPrereqX >= 0:
							# iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTechs(k)).getEra())		
					# iEraFaktor = iEra
					# if iEra > 5: iEraFaktor = 5
					# iTechPoints1000 *= 100 + iEra * 10
					# iTechPoints1000 /= 100

# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz START
				# # Malus fr raunterschied
				# # 100 = kein Malus
				# iPossibleMalusModPercent = 100
				# iEraDifference = max(0, (gc.getTechInfo(iFinalTech).getEra() - ppPlayer.getCurrentEra()))
				# if iEraDifference == 1: iPossibleMalusModPercent = 200
				# elif iEraDifference == 2: iPossibleMalusModPercent = 400
				# elif iEraDifference == 3: iPossibleMalusModPercent = 800
				# elif iEraDifference == 4: iPossibleMalusModPercent = 1600
				# elif iEraDifference == 5: iPossibleMalusModPercent = 3200
				# elif iEraDifference == 6: iPossibleMalusModPercent = 6400
				# elif iEraDifference >= 7: iPossibleMalusModPercent = 12800
				# iTechPoints1000 *= 100
				# iTechPoints1000 /= iPossibleMalusModPercent
# # Cybah: BASE fr 6.3 - auch Techs auerhalb der eigenen ra mit 50% Malus pro radifferenz END
						
				# iTechPoints = (iTechPoints1000 / 1000)				
				# if iTechPoints > 0:
					# # Text generieren
					# iTechCost = ppTeam.getResearchCost(iFinalTech)
					# iCurrentTechPoints = ppTeam.getResearchProgress(iFinalTech)
					# iPrePercents = (iCurrentTechPoints * 100) / iTechCost
					# iPrePercents100 = (iCurrentTechPoints * 10000) / iTechCost
					# iAfterPercents = min(100, (((iCurrentTechPoints + iTechPoints) * 100) / iTechCost))
					# iAfterPercents100 = min(10000, (((iCurrentTechPoints + iTechPoints) * 10000) / iTechCost))
					# iAfterTechPointsLeft = max(0, (ppTeam.getResearchLeft(iFinalTech) - iTechPoints))
					# if (iPrePercents100 < 1 and iAfterPercents100 > 0 and iAfterPercents < 100) or (iPrePercents < 25 and iAfterPercents >= 25 and iAfterPercents < 100) or (iPrePercents < 50 and iAfterPercents >= 50 and iAfterPercents < 100) or (iPrePercents < 75 and iAfterPercents >= 75 and iAfterPercents < 100):					
						# strMessage = CyTranslator().getText("TXT_KEY_TRAIT_CUNNING_RESEARCH", (gc.getTechInfo(iFinalTech).getDescription(), iAfterPercents, iAfterTechPointsLeft))
						# CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage, "", 0, gc.getTechInfo(iFinalTech).getButton(), ColorTypes(11), pLoser.getX(), pLoser.getY(), True, True)
					# # Techpunkte verteilen
					# ppTeam.changeResearchProgress(iFinalTech, iTechPoints, playerY.getID())

# ZE: Babylon 2/2 Start -----------------------------------------------------------------------------------------------
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
			iTechZEBABY = gc.getInfoTypeForString("TECH_BABYLON")
			if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEBABY):
				pZECombatPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
				if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and pZECombatPlot.isCity():
				# if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and pZECombatPlot.isCity() and not pWinner.ignoreBuildingDefense():
					pCombatCity = pZECombatPlot.getPlotCity()

					# if pCombatCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_WALLS")) > 0 or pCombatCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_CELTIC_DUN")) > 0:

					#- Halbierung verbliebener TP -
					if pWinner.getDamage() <= 98:
						iBabyDamage = int((100 - pWinner.getDamage()) / 2)
						pWinner.changeDamage(iBabyDamage, false)
					
					# - Verdopplung des vorhandenen Schadens bis zu einem Maximum von 90% -
					# if pWinner.getDamage() > 1 and pWinner.getDamage() < 99:
					#	iBabyDamage = int(pWinner.getDamage() * 2)
					#	if iBabyDamage > 90:
					#		pWinner.setDamage(90, False)
					#	else:							
					#		pWinner.changeDamage(pWinner.getDamage(), false)
# ZE: Babylon 2/2 End -----------------------------------------------------------------------------------------------
# Persian Immortal 1/2 Start -----------------------------------------------------------------------------------------------
		if ppPlayer.isAlive() and pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")) and not pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):

			ppCity = ppPlayer.getCapitalCity()
			pNearestCity = gc.getMap().findCity(pLoser.getX(), pLoser.getY(), ppPlayer.getID(), ppPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
			if pNearestCity != -1: ppCity = pNearestCity
					
			newImmortalUnit = ppPlayer.initUnit(pLoser.getUnitType(), ppCity.getX(), ppCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
			pLoser.setDamage(0, False)
			newImmortalUnit.convert(pLoser)
			newImmortalUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL"), false)
# Persian Immortal 1/2 End -----------------------------------------------------------------------------------------------
# Vom SDK ins Python ausgelagerte Nachricht, dass ein General gestorben ist Start -----------------------------------------------------------------------------------------------
		if pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):
			LeaderUnitType = pLoser.getLeaderUnitType()
			if (LeaderUnitType):
				szTitle = CyTranslator().getText("TXT_KEY_MISC_GENERAL_KILLED", (pLoser.getNameKey(),))
				CyInterface().addImmediateMessage( szTitle , None)
# Vom SDK ins Python ausgelagerte Nachricht, dass ein General gestorben ist End -----------------------------------------------------------------------------------------------
# Besiegter General gibt mehr XP Start -----------------------------------------------------------------------------------------------
			if pLoser.getLevel() > 0:
				pWinner.changeExperience(pLoser.getLevel(),-1,False,False,False)
				pPlayer.changeCombatExperience(pLoser.getLevel())
# Besiegter General gibt mehr XP End -----------------------------------------------------------------------------------------------
# Generle knnen gerettet werden Start ----------------------------------------------------------------------------------------------
#			iGeneralProtection = self.getRandomNumber( 8 )
#			# if iGeneralProtection >= 0:
#			if iGeneralProtection >= 4:
#				ppcapital = ppPlayer.getCapitalCity()
#				pPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
#				if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and not pPlot.getPlotCity() == ppcapital:
#					GeneralUnit = ppPlayer.initUnit(pLoser.getUnitType(), ppcapital.getX(), ppcapital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
#					pLoser.setDamage(90, False)
#					GeneralUnit.convert(pLoser)
#					pLoser.setDamage(100, False)
#					GeneralUnit.finishMoves()
#					CyInterface().addMessage(pLoser.getOwner(),False,15,CyTranslator().getText("TXT_KEY_GREAT_GENERAL_SAVED",()),'',0,gc.getPromotionInfo(gc.getInfoTypeForString("PROMOTION_LEADER")).getButton(),ColorTypes(8), ppcapital.getX(), ppcapital.getY(), True,True)
# Generle knnen gerettet werden End -----------------------------------------------------------------------------------------------
# Persian Immortal 2/2 Start -----------------------------------------------------------------------------------------------
#			elif pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")):
			if pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")):
				if ppPlayer.isAlive():

					ppCity = ppPlayer.getCapitalCity()
					pNearestCity = gc.getMap().findCity(pLoser.getX(), pLoser.getY(), ppPlayer.getID(), ppPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
					if pNearestCity != -1: ppCity = pNearestCity

					newImmortalUnit = ppPlayer.initUnit(pLoser.getUnitType(), ppCity.getX(), ppCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
					pLoser.setDamage(0, False)
					newImmortalUnit.convert(pLoser)
					newImmortalUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL"), false)
# Persian Immortal 1/2 End -----------------------------------------------------------------------------------------------
# ZE: China 1/3 Start -----------------------------------------------------------------------------------------------
			else:
				if ppPlayer.isAlive():
					iTechZECH = gc.getInfoTypeForString("TECH_CHINA")
					if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZECH) and ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
						# 6.3 C - Jetzt +50 Generalspunkte anstelle einer neuen Generalseinheit
						ppPlayer.changeCombatExperience(50)
					
						# Ersetzt in 6.3 C durch obigen Effekt
						# ppcapital = ppPlayer.getCapitalCity()
						# # kein createGreatPeople, damit es keine doppelten mit Triumpfbogen gibt
						# newGeneral = ppPlayer.initUnit(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), ppcapital.getX(), ppcapital.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.NO_DIRECTION)
						# strMessage1 = CyTranslator().getText("TXT_KEY_MISC_GP_BORN_BASE", (newGeneral.getName(), ppcapital.getName(), ppPlayer.getName()))
						# CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage1, "", 0, newGeneral.getButton(), ColorTypes(11), ppcapital.getX(), ppcapital.getY(), True, True)
						# pActivePlayer = gc.getActivePlayer()
						# if pActivePlayer:
							# if pActivePlayer.getID() == ppPlayer.getID(): CyAudioGame().Play2DSound("AS2D_UNIT_GREATPEOPLE")
# ZE: China 1/3 End -----------------------------------------------------------------------------------------------
# Absorption Shield Start -----------------------------------------------------------------------------------------------
		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ABSORPTION")) and (unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA):
			if unitY.getDomainType() == DomainTypes.DOMAIN_LAND or unitY.getDomainType() == DomainTypes.DOMAIN_SEA: 
				if (pWinner.baseCombatStr() * 100 * (100 - pWinner.getDamage()) / 10000) < pLoser.baseCombatStr():
					pWinner.setDamage(0, False)
					StrDiff = int(pLoser.baseCombatStr() - (pWinner.baseCombatStr() * 100 * (100 - pWinner.getDamage()) / 10000))
					newstrength = max(pWinner.baseCombatStr(), (pWinner.baseCombatStr() + StrDiff))
					pWinner.setBaseCombatStr(newstrength)	
			elif unitY.getDomainType() == DomainTypes.DOMAIN_AIR: 
				if (pWinner.baseCombatStr() * 100 * (100 - pWinner.getDamage()) / 10000) < pLoser.airBaseCombatStr():
					pWinner.setDamage(0, False)
					StrDiff = int(pLoser.airBaseCombatStr() - (pWinner.baseCombatStr() * 100 * (100 - pWinner.getDamage()) / 10000))
					newstrengthAbsorb = max(pWinner.baseCombatStr(), (pWinner.baseCombatStr() + StrDiff))
					pWinner.setBaseCombatStr(newstrengthAbsorb)
# Absorption Shield End -----------------------------------------------------------------------------------------------
# Replicators Start -----------------------------------------------------------------------------------------------
		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_REPLICATION")) and pWinner.baseCombatStr() > 4 and pWinner.getDamage() <= 50:
			for i in xrange (2):
				pReplicatedUnit = pPlayer.initUnit(pWinner.getUnitType(), pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
				pReplicatedUnit.convert(pWinner)
				pReplicatedUnit.finishMoves()
				# pReplicatedUnit.setBaseCombatStr(pWinner.baseCombatStr() - 10)
				pReplicatedUnit.setBaseCombatStr(int(pWinner.baseCombatStr() * 4 / 5))
# Replicators End -----------------------------------------------------------------------------------------------
# ZE: Japan Start -----------------------------------------------------------------------------------------------
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
			iTechZEJAP = gc.getInfoTypeForString("TECH_JAPAN")
			if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEJAP):
				if pWinner.baseCombatStr() > 0 and (unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA):

					# Arithm. Mittel
					# min(pWinner.baseCombatStr(), ((pLoser.baseCombatStr() + pWinner.baseCombatStr()) / 2))
					
					if pLoser.baseCombatStr() > 0:
						# Geom. Mittel
						iGeoM = sqrt((pLoser.baseCombatStr() * pWinner.baseCombatStr()))					
						iMaximum = min(pWinner.baseCombatStr(), iGeoM) # Das Maximum soll nicht mehr sein als pWinner.baseCombatStr(), dadurch ist iMaximum / pWinner.baseCombatStr() nie grer 1
						iRatio100 = ((100 * iMaximum / pWinner.baseCombatStr()) * 25)		
						iJapanDamage = int((100 - pWinner.getDamage()) * iRatio100 / 10000)
						if iJapanDamage > 0: pWinner.changeDamage(iJapanDamage, false)
						
					elif pLoser.airBaseCombatStr() > 0 and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_MISSILE"):
						# Geom. Mittel
						iGeoM = sqrt((pLoser.airBaseCombatStr() * pWinner.baseCombatStr()))					
						iMaximum = min(pWinner.baseCombatStr(), iGeoM) # Das Maximum soll nicht mehr sein als pWinner.baseCombatStr(), dadurch ist iMaximum / pWinner.baseCombatStr() nie grer 1
						iRatio100 = ((100 * iMaximum / pWinner.baseCombatStr()) * 25)		
						iJapanDamage = int((100 - pWinner.getDamage()) * iRatio100 / 10000)
						if iJapanDamage > 0: pWinner.changeDamage(iJapanDamage, false)
				
#					if pLoser.baseCombatStr() > 0:
#						#- bis max 25% Zusatzschaden -
#						iRatio = (min(100, (100 * pLoser.baseCombatStr() / pWinner.baseCombatStr())) * 25)
#						iJapanDamage = int((100 - pWinner.getDamage()) * iRatio / 10000)
#						if iJapanDamage > 0: pWinner.changeDamage(iJapanDamage, false)
#
#					elif pLoser.airBaseCombatStr() > 0 and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_MISSILE"):
#						#- bis max 25% Zusatzschaden -
#						iRatio = (min(100, (100 * pLoser.airBaseCombatStr() / pWinner.baseCombatStr())) * 25)
#						iJapanDamage = int((100 - pWinner.getDamage()) * iRatio / 10000)
#						if iJapanDamage > 0: pWinner.changeDamage(iJapanDamage, false)
# ZE: Japan End -----------------------------------------------------------------------------------------------
# Spartiat Start -----------------------------------------------------------------------------------------------
		# if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPARTAN")): # deaktiviert: Neuer Effekt jetzt im SDK (CvUnit.cpp)
			# # Neuer Effekt: Heilt 75% des Schadens
			# if pWinner.getDamage() > 0: pWinner.changeDamage(-((pWinner.getDamage() * 3) / 4), False)
			# # Alter Effekt: Heilt 25% der Gesamtstrke
			# # if pWinner.getDamage() < 50: pWinner.changeDamage(-25, false)
# Spartiat End -----------------------------------------------------------------------------------------------
		if pLoser.getUnitCombatType() > -1 and pLoser.getDomainType() == pWinner.getDomainType():
# Geistheilung / Faith Healing Start -----------------------------------------------------------------------------------------------
			# --						
			# -- Heilung nach Tod durch gestorbenen Geistheiler
			# --
			if pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FAITH_HEALING")):
				pCombatPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
				for iUnit in xrange(pCombatPlot.getNumUnits()):	
					pUnit = pCombatPlot.getUnit(iUnit)
					if pUnit.getOwner() == pLoser.getOwner() and not pUnit.isDead():
						pUnit.setDamage(max(0, (pUnit.getDamage() - 25)), False)
			# --						
			# -- Heilung nach Sieg durch andere Geistheiler
			# --
			if unitX.getDomainType() == DomainTypes.DOMAIN_LAND and unitY.getDomainType() == DomainTypes.DOMAIN_LAND:
				iFaithHealers = 0
				pCombatPlot = CyMap().plot(pWinner.getX(), pWinner.getY())
				for i in xrange(pCombatPlot.getNumUnits()):
					if pCombatPlot.getUnit(i).isHasPromotion(gc.getInfoTypeForString("PROMOTION_FAITH_HEALING")):
						iFaithHealers += 1
				if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FAITH_HEALING")):
					iFaithHealers -= 1
				if iFaithHealers > 0:
					# Neuer Effekt: Heilt 25% des Schadens
					if pWinner.getDamage() > 0: pWinner.changeDamage(-(pWinner.getDamage() / 4), False)

					# Alter Effekt: Heilt 10% der Gesamtstrke
					# pWinner.setDamage(max(0, (pWinner.getDamage() - 10)), False)
					### pWinner.setDamage(max(0, (pWinner.getDamage() - (10 * iFaithHealers))), False)
# Geistheilung / Faith Healing End -----------------------------------------------------------------------------------------------
# Persische Apotheke Start -----------------------------------------------------------------------------------------------
				pWinnerPlot = CyMap().plot(pWinner.getX(), pWinner.getY())
				if pWinnerPlot.isCity():
					pWinnerCity = pWinnerPlot.getPlotCity()
					if ((pWinnerCity.getOwner() == pWinner.getOwner()) and (pWinnerCity.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_PERSIAN_APOTHECARY")) > 0)):
						# Neuer Effekt: Heilt 25% des Schadens
						if pWinner.getDamage() > 0: pWinner.changeDamage(-(pWinner.getDamage() / 4), False)

						# Alter Effekt: Heilt 10% der Gesamtstrke
						# pWinner.setDamage(max(0, (pWinner.getDamage() - 10)), False)
# Persische Apotheke End -----------------------------------------------------------------------------------------------
# berlebensknstler Start -----------------------------------------------------------------------------------------------
			if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SURVIVOR3")):
				pWinner.setDamage(max(0, (pWinner.getDamage() - 10)), False)
# berlebensknstler End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 - Protective Trait START // verworfen wegen Spartiat
			# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_PROTECTIVE")) and (unitX.getDomainType() == DomainTypes.DOMAIN_LAND or unitX.getDomainType() == DomainTypes.DOMAIN_SEA):
				# pWinner.setDamage(max(0, (pWinner.getDamage() - 10)), False)
# Cybah: BASE fr 6.3 - Protective Trait END
# Gromeister / Grandmaster Start -----------------------------------------------------------------------------------------------
			if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GRANDMASTER")):

				# Alt: Maximal so viel wie das eigene Level (Minimum beider Level)
				# iCombatXP = min(pWinner.getLevel(), pLoser.getLevel())

				# Neu: So viel wie das Level der besiegten Einheiten
				iCombatXP = pLoser.getLevel()
				pPlayer.changeCombatExperience(iCombatXP)

			if pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GRANDMASTER")):
				iDeathXP = (pLoser.getExperience() * 2)
				if iDeathXP > 0:
					ppPlayer.changeCombatExperience(iDeathXP)
					Wish = []
					pPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
					for iUnit in xrange(pPlot.getNumUnits()):
						pUnit = pPlot.getUnit(iUnit)
						if not pUnit.isNone():
							if pUnit.getOwner() == pLoser.getOwner():
								if not pUnit.isDead() and pUnit.getUnitCombatType() > -1:
									if not pUnit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER"):
										Wish.append(pUnit)
					if Wish:
						for i in xrange(len(Wish)):
							iUnitXP = max(1, (iDeathXP / len(Wish)))
							iUnitXPTotal = min(iUnitXP, pLoser.getLevel())
							Wish[i].changeExperience(iUnitXPTotal,-1,False,False,False)
# Gromeister / Grandmaster End -----------------------------------------------------------------------------------------------
# Raubzug / Raid Start -----------------------------------------------------------------------------------------------
			if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPOILS_OF_WAR")):
				iPlayer = pWinner.getOwner()
				pPlayer = gc.getPlayer(iPlayer)
				iSpoils = 5 * pWinner.getLevel()
				pPlayer.changeGold(iSpoils)
# Raubzug / Raid End -----------------------------------------------------------------------------------------------
# Raserei / Rage Start -----------------------------------------------------------------------------------------------

			if pWinner.getUnitType() == gc.getInfoTypeForString("UNIT_VIKING_BESERKER"):
				if not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_RAGE")):
					iRageRand = (100 - pWinner.getDamage())
					iRageChance = self.getRandomNumber(iRageRand)
					if iRageChance < 25:
						pWinner.setDamage(0, False)

						pWinner.setHasPromotion(gc.getInfoTypeForString("PROMOTION_RAGE"), True)
				elif pWinner.getDamage() > 25:
					pWinner.setHasPromotion(gc.getInfoTypeForString("PROMOTION_RAGE"), False)

# Raserei / Rage End -----------------------------------------------------------------------------------------------
# Furchtlos / Fearless Start -----------------------------------------------------------------------------------------------
			if pLoser.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FEARLESS")):
				# iStrDiffPercent = int(100 * pLoser.baseCombatStr() / pWinner.baseCombatStr())
				# --						
				# -- Strke der besiegten Einheit muss 66% oder mehr Strke der siegreichen Einheit betragen - deaktiviert
				# --
				# if iStrDiffPercent >= 66:

				if not pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):
					pWinner.setDamage(100, false)
					strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_WINNER", (pLoser.getName(), pWinner.getName(), pWinner.getName()))
					strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_LOSER", (pLoser.getName(), pWinner.getName(), pWinner.getName()))
					# rucivfan: Korrektur richtiger Button Start
					CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage1, "", 0, pLoser.getButton(), ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)					
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage2, "", 0, pLoser.getButton(), ColorTypes(7), pWinner.getX(), pWinner.getY(), True, True)
					# rucivfan: Korrektur richtiger Button Ende
				else:
					pPlot = pWinner.plot()
					iPlayer = pWinner.getOwner()
					OpferRange = []
					for i in xrange(pPlot.getNumUnits()):
						pUnit = pPlot.getUnit(i)
						if pUnit.getOwner() == iPlayer and not pUnit.isDead() and not pUnit.getUnitCombatType() == -1 and not pUnit.getDomainType() != pLoser.getDomainType() and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")):
							OpferRange.append(pUnit)

					if OpferRange:
						iOpfer = self.getRandomNumber( len(OpferRange) )
						strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_WINNER", (pLoser.getName(), OpferRange[iOpfer].getName(), OpferRange[iOpfer].getName()))
						strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_LOSER", (pLoser.getName(), OpferRange[iOpfer].getName(), OpferRange[iOpfer].getName()))
						# rucivfan: Korrektur richtiger Button Start
						CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage1, "", 0, pLoser.getButton(), ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)					
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage2, "", 0, pLoser.getButton(), ColorTypes(7), pWinner.getX(), pWinner.getY(), True, True)
						# rucivfan: Korrektur richtiger Button Ende
						OpferRange[iOpfer].setDamage(100, false)
						pWinner.setDamage(99, false)
					else:
						strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_WINNER", (pLoser.getName(), pWinner.getName(), pWinner.getName()))
						strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_RAGE_LOSER", (pLoser.getName(), pWinner.getName(), pWinner.getName()))
						# rucivfan: Korrektur richtiger Button Start
						CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage1, "", 0, pLoser.getButton(), ColorTypes(8), pWinner.getX(), pWinner.getY(), True, True)					
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage2, "", 0, pLoser.getButton(), ColorTypes(7), pWinner.getX(), pWinner.getY(), True, True)
						# rucivfan: Korrektur richtiger Button Ende
						pWinner.setDamage(100, false)
# Furchtlos / Fearless End -----------------------------------------------------------------------------------------------
# Terror Start -----------------------------------------------------------------------------------------------
		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_TERROR")):
			pPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
			if pPlot.isCity():
				pCity = pPlot.getPlotCity()
				if pCity.getOwner() == pLoser.getOwner():			
						
					iRange = pCity.getCultureLevel()
					for iDX in xrange(-(iRange), (iRange + 1)):					
						for iDY in xrange(-(iRange), (iRange + 1)):
							if (pCity.cultureDistance(iDX, iDY) <= iRange):
								pPlot2 = CyMap().plot((pCity.getX() + iDX), (pCity.getY() + iDY))
								if pPlot2 and not pPlot2.isNone() and not pPlot2.isCity():								
									if (pPlot2.getOwner() == pCity.getOwner()):
										if (pPlot2.getNumCultureRangeCities(pCity.getOwner()) == 1):
											bForceUnowned = false									
											for iPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
												piPlayer = gc.getPlayer(iPlayer)
												if piPlayer.isAlive():
													if ((piPlayer.getTeam() != pPlayer.getTeam()) and (piPlayer.getTeam() != ppPlayer.getTeam())):						
														if (pPlot2.getNumCultureRangeCities(iPlayer) > 0):
															bForceUnowned = true
															break
											if bForceUnowned == true:
												pPlot2.setForceUnownedTimer((pCity.getOccupationTimer() + 1))
				
					pCity.changeOccupationTimer(1)
					#if pCity.getPopulation() > 1:
						#pCity.changePopulation(-1)
# Terror End -----------------------------------------------------------------------------------------------
# Durchschlagen Start -----------------------------------------------------------------------------------------------
		if pWinner.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PIERCE")):
			pPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
			ipWinnerStrength = ((pWinner.baseCombatStr() * (gc.getMAX_HIT_POINTS() - pWinner.getDamage())) / gc.getMAX_HIT_POINTS())
			OpferRange = []
			for i in xrange(pPlot.getNumUnits()):
				pUnit = pPlot.getUnit(i)
				if pUnit.getOwner() == pLoser.getOwner() and not pUnit.isDead() and not pUnit.getUnitCombatType() == -1 and not pUnit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_SPECIAL' ) and not pUnit.getDomainType() != pLoser.getDomainType() and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_LEADER")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FEARLESS")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GHAZI")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_ROYAL_GUARD")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPARTAN")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SPOILS_OF_WAR")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_RAGE")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_GRANDMASTER")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_TERROR")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_INSPIRATION")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PIERCE")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_FAITH_HEALING")):
					ipUnitStrength = ((pUnit.baseCombatStr() * (gc.getMAX_HIT_POINTS() - pUnit.getDamage())) / gc.getMAX_HIT_POINTS())
					if ipWinnerStrength > ipUnitStrength:
						OpferRange.append(pUnit)
			if OpferRange:
				iOpfer = self.getRandomNumber( len(OpferRange) )
				strMessage1 = CyTranslator().getText("TXT_KEY_PROMOTION_PIERCE_WINNER", (pWinner.getName(), OpferRange[iOpfer].getName(), OpferRange[iOpfer].getName()))
				strMessage2 = CyTranslator().getText("TXT_KEY_PROMOTION_PIERCE_LOSER", (pWinner.getName(), OpferRange[iOpfer].getName(), OpferRange[iOpfer].getName()))
				# rucivfan: Korrektur richtiger Button Start
				CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0, OpferRange[iOpfer].getButton(), ColorTypes(8), pLoser.getX(), pLoser.getY(), True, True)					
				CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage2, "", 0, OpferRange[iOpfer].getButton(), ColorTypes(7), pLoser.getX(), pLoser.getY(), True, True)
				# rucivfan: Korrektur richtiger Button Ende
				OpferRange[iOpfer].setDamage(100, false)
# Durchschlagen End -----------------------------------------------------------------------------------------------
# Food from Animals Start -----------------------------------------------------------------------------------------------
		iUnitType = PyInfo.UnitInfo(pLoser.getUnitType())
		if iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
			pNearestCity = gc.getMap().findCity(pLoser.getX(), pLoser.getY(), pPlayer.getID(), pPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
			if pNearestCity and pNearestCity.getOwner() == pWinner.getOwner():
			# if pNearestCity and pNearestCity.area().getID() == pWinner.area().getID():
				iAnimalFood = pLoser.baseCombatStr()
				if pTeam.isHasTech(gc.getInfoTypeForString("TECH_HUNTING")): iAnimalFood *= 2
				if iAnimalFood > 0:					
					iTheSpeed = CyGame().getGameSpeedType()
					TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
					iGrowthPercent = TheSpeed.getGrowthPercent()
					if iGrowthPercent < 100: iGrowthPercent = 100
					elif iGrowthPercent == 150: iGrowthPercent = 200
					iAnimalFood = (iAnimalFood * iGrowthPercent / 100)
					
# Cybah: BASE fr 6.1 F - Easter Eggs START -----------------------------------------------------------------------------------------------
					# Cybah: BASE fr 6.3 C - Nur noch bei aktivierten Zufallsereignissen
					if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_EVENTS):
						if pLoser.getNameKey() == "BadMoose": iAnimalFood *= 2
# Cybah: BASE fr 6.1 F - Easter Eggs END -----------------------------------------------------------------------------------------------			
# Maya Speerschleuderer Start ----------------------------------------------------------------------------------------------- # deaktiviert mit 6.4 D (im Rahmen des Bogenschtzen Nerfs)
					# if pWinner.getUnitType() == gc.getInfoTypeForString("UNIT_MAYA_ATLATL"):
						# iAnimalFood *= 3
						# iAnimalFood /= 2
# Maya Speerschleuderer End -----------------------------------------------------------------------------------------------
# ZE: sterreich 1/2 Start -----------------------------------------------------------------------------------------------
#						if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
#							iTechAUS = gc.getInfoTypeForString("TECH_AUSTRIA")
#							if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechAUS):
#								iAnimalFood *= 4
#								iAnimalFood /= 2
# ZE: sterreich 1/2 End -----------------------------------------------------------------------------------------------
					pNearestCity.changeFood(iAnimalFood)
					strMessageFFA = CyTranslator().getText( "TXT_KEY_FOOD_FROM_ANIMAL", (iAnimalFood,pLoser.getName(),pNearestCity.getName() ) )
					# rucivfan: Korrektur richtiger Button Start
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessageFFA, "", 0, pLoser.getButton(), ColorTypes(8), pLoser.getX(), pLoser.getY(), True, True)
					# rucivfan: Korrektur richtiger Button Ende
					
# Food from Animals End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Easter Eggs START -----------------------------------------------------------------------------------------------
		# Cybah: BASE fr 6.3 C - Nur noch bei aktivierten Zufallsereignissen
		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_EVENTS):
			if pLoser.getNameKey() == "Cybah" and unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
				ppPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
				if ppPlot.getImprovementType() == -1 and ppPlot.getBonusType(pPlayer.getTeam()) == -1:
					if ppPlot.canHaveBonus(gc.getInfoTypeForString("BONUS_IVORY"), True) or (ppPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS") and ppPlot.getFeatureType() == -1):
						ppPlot.setBonusType(gc.getInfoTypeForString("BONUS_IVORY"))
					elif ppPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_GRASS") and ppPlot.getFeatureType() != -1:
						ppPlot.setFeatureType(-1, 0)
						ppPlot.setBonusType(gc.getInfoTypeForString("BONUS_IVORY"))

				# #CyAudioGame().Play2DSound("AS2D_METEORSTRIKE")
				# #pPlotC = CyMap().plot(pLoser.getX(), pLoser.getY())
				# #CyEngine().triggerEffect(gc.getInfoTypeForString("EFFECT_ICBM_NUCLEAR_EXPLOSION"), pPlotC.getPoint())
				
			if pLoser.getNameKey() == "HeyI" and unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
				pWinner.changeExperience(pWinner.baseCombatStr(),-1,False,False,False)
				pWinner.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), True)
				
				# Test, geht nicht
				#pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GIANT_TORTOISE' ), pWinner.getX(), pWinner.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				#iLeaderPromo = gc.getInfoTypeForString("PROMOTION_LEADER")
				#pNewUnit.setHasPromotion(iLeaderPromo, true)
				#pNewUnit.lead(pWinner.getID())
				
			if pLoser.getNameKey() == "Rucivfan" and unitY.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
				ppPlot = CyMap().plot(pLoser.getX(), pLoser.getY())
				pActivePlayer = gc.getActivePlayer()
				if pActivePlayer.getID() == pPlayer.getID(): CyAudioGame().Play2DSound("AS2D_NUKE_EXPLODES")
				CyEngine().triggerEffect(gc.getInfoTypeForString("EFFECT_ICBM_NUCLEAR_EXPLOSION"), ppPlot.getPoint())
				
				iX = pLoser.getX()
				iY = pLoser.getY()
				for iXLoop in xrange(iX - 1, iX + 2, 1):
					for iYLoop in xrange(iY - 1, iY + 2, 1):
						pPlotX = CyMap().plot(iXLoop, iYLoop)
						if pPlotX.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_SNOW' ) and (not pPlotX.isOwned() or pPlotX.getOwner == pPlayer.getID()):
							pPlotX.setTerrainType(gc.getInfoTypeForString( 'TERRAIN_TUNDRA' ), True, True)
				
				# Eigenes Reich - deaktiviert
				# for iX2 in xrange(CyMap().getGridWidth()):
					# for iY2 in xrange(CyMap().getGridHeight()):	
						# pPlotX2 = CyMap().plot(iX2,iY2)
						# if pPlotX2.getOwner() == pPlayer.getID():
							# if pPlotX2.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_SNOW' ):
								# pPlotX2.setTerrainType(gc.getInfoTypeForString( 'TERRAIN_TUNDRA' ), True, True)
				
				# szTitle = CyTranslator().getText("TXT_KEY_MISC_RUCIVFAN_KILLED", (pLoser.getNameKey(),))
				# CyInterface().addImmediateMessage( szTitle , None)
		
			# Cybah: BASE fr 6.3 - Easter Egg: Vanguard
			if pLoser.getUnitType() == gc.getInfoTypeForString("UNIT_BERGZIEGE"):
				if pLoser.getNameKey() == "Vanguard":
				
					iBaseStrengthV = pLoser.baseCombatStr()
				
					# # Vanguard wechselt Position - deaktiviert mit 6.4 A (frs Aktivieren alles einkommentieren und changeCombatExperience einmal ausrcken)
					# # 6.4 A - Maximale Strke von 10
					# iBaseStrengthVNew = min(10, (iBaseStrengthV + 1))
					# # pPlayer.changeCombatExperience(iBaseStrengthV)
					# l_Vanguards = []
					# for iXV in xrange(CyMap().getGridWidth()):
						# for iYV in xrange(CyMap().getGridHeight()):
							# pPlotV = CyMap().plot(iXV,iYV)
							# for iUnitV in xrange(pPlotV.getNumUnits()):
								# pUnitV = pPlotV.getUnit(iUnitV)
								# iUnitTypeV = pUnitV.getUnitType()
								# if iUnitTypeV == gc.getInfoTypeForString("UNIT_BERGZIEGE") and pUnitV.getID() != pLoser.getID():
									# l_Vanguards.append(pUnitV)
									
					# if len(l_Vanguards) >= 1:
						# iVanguard = CyGame().getSorenRandNum(len(l_Vanguards), "Random for Vanguard")
						# pNewVanguard = l_Vanguards[iVanguard]
						# if pNewVanguard != None and not pNewVanguard.isNone():
							# pNewVanguard.setName("Vanguard")
							# pNewVanguard.setBaseCombatStr(iBaseStrengthVNew)
							# # pNewVanguard.setBaseMoves(2)
						
					# else:
						# # pCapitalV = pPlayer.getCapitalCity()
						# # pCapitalV.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), False, False)
					
					# 6.4 A - zweifache Kampferfahrung
					iVCombatExp = (iBaseStrengthV * 2)
					pPlayer.changeCombatExperience(iVCombatExp)
				
				# Gettete Bergziegen machen Vanguard strker
				else:
					for iXV in xrange(CyMap().getGridWidth()):
						for iYV in xrange(CyMap().getGridHeight()):	
							pPlotV = CyMap().plot(iXV,iYV)
							for iUnitV in xrange(pPlotV.getNumUnits()):
								pUnitV = pPlotV.getUnit(iUnitV)
								iUnitTypeV = pUnitV.getUnitType()
								if iUnitTypeV == gc.getInfoTypeForString("UNIT_BERGZIEGE") and pUnitV.getNameKey() == "Vanguard":
									iBaseStrengthV = pUnitV.baseCombatStr()
									# 6.4 A - Maximale Strke von 10
									iBaseStrengthVNew = min(10, (iBaseStrengthV + 1))
									pUnitV.setBaseCombatStr(iBaseStrengthVNew)
									
			# Cybah: BASE fr 6.4 C - Easter Egg: Sauron (siehe auch CvUnit.cpp)
			if pLoser.getUnitType() == gc.getInfoTypeForString("UNIT_LYNX"):
				if pLoser.getNameKey() == "Sauron":
					pCapitalSauronKiller = pPlayer.getCapitalCity()
					pNearestCity = gc.getMap().findCity(pLoser.getX(), pLoser.getY(), pPlayer.getID(), pPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
					if pNearestCity and pNearestCity.getOwner() == pWinner.getOwner():
						pNearestCity.changeExtraHappiness(1)
						pCapitalSauronKiller.changeExtraHappiness(1)
					else:
						pCapitalSauronKiller.changeExtraHappiness(2)

# Cybah: BASE fr 6.1 E - Easter Eggs END -----------------------------------------------------------------------------------------------
# ZE: Korea Start (ehemals Philosophical Trait) -----------------------------------------------------------------------------------------------
		# iTraitPhi = gc.getInfoTypeForString("TRAIT_PHILOSOPHICAL")
		# if pPlayer.hasTrait(iTraitPhi) and ppPlayer.isAlive():
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA") and pPlayer.isAlive():
			iTechKor = gc.getInfoTypeForString("TECH_KOREA")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechKor):

				if pLoser.baseCombatStr() > 0 and pWinner.baseCombatStr() > 0 and unitX.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
					iPhiGPP = pLoser.baseCombatStr()
					iPhiGPP1000 = (iPhiGPP * 1000)
					if iPhiGPP > 0:
					
						# Speed Modifier
						iTheSpeed = CyGame().getGameSpeedType()
						TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
						iPhiGPP1000 *= (TheSpeed.getTrainPercent() / 100)
						
						# - Spieloption erhhte Einheitenproduktionskosten -
						iUnit = pLoser.getUnitType()
						if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
							if gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()) > 0:
								iEra = gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTech()).getEra()
							else:	
								iEra = 0
							for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
								iPrereqX = gc.getUnitInfo(iUnit).getPrereqAndTechs(k)
								if iPrereqX >= 0:
									iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnit).getPrereqAndTechs(k)).getEra())
							if iEra > 5:
								iEra = 5
							iPhiGPP1000 *= 100 + iEra * 10
							iPhiGPP1000 /= 100
							
						# Nachtrglicher Modifikator (im Moment: 50%)
						iPhiGPP1000 *= 2
						iPhiGPP1000 /= 4
						
						# Endberechnung
						iPhiGPP = (iPhiGPP1000 / 1000)
						
						if iPhiGPP > 0:
							pCityPhi, iter = pPlayer.firstCity(false)  
							while(pCityPhi):	  
								if not pCityPhi.isNone() and pCityPhi.getOwner() == pPlayer.getID():
									pCityPhi.changeGreatPeopleProgress(iPhiGPP)
								pCityPhi, iter = pPlayer.nextCity(iter, false)
# ZE: Korea End -----------------------------------------------------------------------------------------------
			
			# Verlierer ist Philosophisch
			# if ppPlayer.hasTrait(iTraitPhi) and ppPlayer.isAlive():
				# if pLoser.baseCombatStr() > 0 and pWinner.baseCombatStr() > 0 and unitX.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL") and unitY.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):
					# iPhiGPP = pLoser.baseCombatStr()
					# iPhiGPP1000 = (iPhiGPP * 1000)
					# if iPhiGPP > 0:
					
						# # Speed Modifier				
						# iTheSpeed = CyGame().getGameSpeedType()
						# TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
						# iPhiGPP1000 *= (TheSpeed.getTrainPercent() / 100)
						
						# # - Spieloption erhhte Einheitenproduktionskosten -
						# iUnit2 = pLoser.getUnitType()
						# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
							# if gc.getTechInfo(gc.getUnitInfo(2).getPrereqAndTech()) > 0:
								# iEra = gc.getTechInfo(gc.getUnitInfo(iUnit2).getPrereqAndTech()).getEra()
							# else:	
								# iEra = 0
							# for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
								# iPrereqX = gc.getUnitInfo(iUnit2).getPrereqAndTechs(k)
								# if iPrereqX >= 0:
									# iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnit2).getPrereqAndTechs(k)).getEra())
							# if iEra > 5:
								# iEra = 5
							# iPhiGPP1000 *= 100 + iEra * 10
							# iPhiGPP1000 /= 100
						
						# iPhiGPP = (iPhiGPP1000 / 1000)
						# if iPhiGPP > 0:
							# ppCityPhi, iter = ppPlayer.firstCity(false)  
							# while(ppCityPhi):	  
								# if not ppCityPhi.isNone() and ppCityPhi.getOwner() == ppPlayer.getID():
									# ppCityPhi.changeGreatPeopleProgress(iPhiGPP)
								# ppCityPhi, iter = ppPlayer.nextCity(iter, false)
# Philosophical Trait End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_COMBAT):
			return
		if playerX and playerY and unitX and unitY:
			CvUtil.pyPrint('Player %d Civilization %s Unit %s has defeated Player %d Civilization %s Unit %s' 
				%(playerX.getID(), playerX.getCivilizationName(), unitX.getDescription(), 
				playerY.getID(), playerY.getCivilizationName(), unitY.getDescription()))

	def onCombatLogCalc(self, argsList):
		'Combat Result'	
		genericArgs = argsList[0][0]
		cdAttacker = genericArgs[0]
		cdDefender = genericArgs[1]
		iCombatOdds = genericArgs[2]
		CvUtil.combatMessageBuilder(cdAttacker, cdDefender, iCombatOdds)
		
	def onCombatLogHit(self, argsList):
		'Combat Message'
		global gCombatMessages, gCombatLog
		genericArgs = argsList[0][0]
		cdAttacker = genericArgs[0]
		cdDefender = genericArgs[1]
		iIsAttacker = genericArgs[2]
		iDamage = genericArgs[3]
		
		if cdDefender.eOwner == cdDefender.eVisualOwner:
			szDefenderName = gc.getPlayer(cdDefender.eOwner).getNameKey()
		else:
			szDefenderName = CyTranslator().getText("TXT_KEY_TRAIT_PLAYER_UNKNOWN", ())
		if cdAttacker.eOwner == cdAttacker.eVisualOwner:
			szAttackerName = gc.getPlayer(cdAttacker.eOwner).getNameKey()
		else:
			szAttackerName = CyTranslator().getText("TXT_KEY_TRAIT_PLAYER_UNKNOWN", ())

		# rucivfan_combat_system_extended rcse[	
		# if (iIsAttacker == 0):				
			# combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_HIT", (szDefenderName, cdDefender.sUnitName, iDamage, cdDefender.iCurrHitPoints, cdDefender.iMaxHitPoints))
			# CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			# CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			# if (cdDefender.iCurrHitPoints <= 0):
				# combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_DEFEATED", (szAttackerName, cdAttacker.sUnitName, szDefenderName, cdDefender.sUnitName))
				# CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				# CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
		# elif (iIsAttacker == 1):
			# combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_HIT", (szAttackerName, cdAttacker.sUnitName, iDamage, cdAttacker.iCurrHitPoints, cdAttacker.iMaxHitPoints))
			# CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			# CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			# if (cdAttacker.iCurrHitPoints <= 0):
				# combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_DEFEATED", (szDefenderName, cdDefender.sUnitName, szAttackerName, cdAttacker.sUnitName))
				# CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				# CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
				
		if (iIsAttacker == 0):				
			combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_SUFFERED_DAMAGE", (szDefenderName, cdDefender.sUnitName, iDamage, cdDefender.iCurrHitPoints, cdDefender.iMaxHitPoints))
			CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			if (cdDefender.iCurrHitPoints <= 0):
				combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_SUFFERED_DAMAGE_DEFEATED", (szAttackerName, cdAttacker.sUnitName, szDefenderName, cdDefender.sUnitName))
				CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
		elif (iIsAttacker == 1):
			combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_SUFFERED_DAMAGE", (szAttackerName, cdAttacker.sUnitName, iDamage, cdAttacker.iCurrHitPoints, cdAttacker.iMaxHitPoints))
			CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
			CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
			if (cdAttacker.iCurrHitPoints <= 0):
				combatMessage = CyTranslator().getText("TXT_KEY_COMBAT_MESSAGE_SUFFERED_DAMAGE_DEFEATED", (szDefenderName, cdDefender.sUnitName, szAttackerName, cdAttacker.sUnitName))
				CyInterface().addCombatMessage(cdAttacker.eOwner,combatMessage)
				CyInterface().addCombatMessage(cdDefender.eOwner,combatMessage)
		# ]rucivfan_combat_system_extended rcse
				
	def onImprovementBuilt(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Improvement Built'
		iImprovement, iX, iY = argsList
		
		pPlot = CyMap().plot(iX, iY)
		iPlayer = pPlot.getOwner()
		if (iPlayer != -1):
			pPlayer = gc.getPlayer(iPlayer)
			iTeam = pPlayer.getTeam()
			pTeam = gc.getTeam(iTeam)

# ZE: Indien Start -----------------------------------------------------------------------------------------------
#			if iImprovement == gc.getInfoTypeForString("IMPROVEMENT_TOWN"):
#				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDIA"):
#					iTech = gc.getInfoTypeForString("TECH_INDIA")
#					if gc.getTeam(pPlayer.getTeam()).isHasTech(iTech):
#						pTownCity = pPlot.getWorkingCity()
#						if(pTownCity):
#							pTownCity.changePopulation(1) 
# ZE: Indien End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Improvement %s was built at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))

	def onImprovementDestroyed(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Improvement Destroyed'
		iImprovement, iOwner, iX, iY = argsList
		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Improvement %s was Destroyed at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))

	def onRouteBuilt(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Route Built'
		iRoute, iX, iY = argsList
		if (not self.__LOG_IMPROVEMENT):
			return
		CvUtil.pyPrint('Route %s was built at %d, %d'
			%(gc.getRouteInfo(iRoute).getDescription(), iX, iY))

	def onPlotRevealed(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Plot Revealed'
		pPlot = argsList[0]
		iTeam = argsList[1]

	def onPlotFeatureRemoved(self, argsList):
		'Plot Revealed'
		pPlot = argsList[0]
		iFeatureType = argsList[1]
		pCity = argsList[2] # This can be null

		if pCity != -1:
			iPlayer = pCity.getOwner()
			if iPlayer != -1 and iFeatureType != -1:
				pPlayer = gc.getPlayer(iPlayer)
				pCapital = pPlayer.getCapitalCity()
# ZE: Brasilien 2/3 Start -----------------------------------------------------------------------------------------------
				if pPlayer.isAlive() and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL") :
					iTech = gc.getInfoTypeForString("TECH_BRAZIL")
					if gc.getTeam(pPlayer.getTeam()).isHasTech(iTech):

						if iFeatureType == gc.getInfoTypeForString("FEATURE_FOREST") or iFeatureType == gc.getInfoTypeForString("FEATURE_JUNGLE") or iFeatureType == gc.getInfoTypeForString("FEATURE_SAVANNA"):

							# Normale brasilianische Produktion abzglich Distanzmalus
							iPlotDistance = plotDistance(pPlot.getX(), pPlot.getY(), pCity.getX(), pCity.getY())
							if iFeatureType == gc.getInfoTypeForString("FEATURE_FOREST") or iFeatureType == gc.getInfoTypeForString("FEATURE_JUNGLE"):
								iExtraWood = (45 - (max(0, (iPlotDistance - 2)) * 5))
							elif iFeatureType == gc.getInfoTypeForString("FEATURE_SAVANNA"):
								iExtraWood = (30 - (max(0, (iPlotDistance - 2)) * 5))

							# Sonstige Berechnungen
							iExtraWood = iExtraWood * (100 + pPlayer.getFeatureProductionModifier()) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getFeatureProductionPercent() / 10000

							# Aus XML: - FEATURE_PRODUCTION_PERCENT -
							iExtraWood *= 67
							iExtraWood /= 100

							# Aus XML: - DIFFERENT_TEAM_FEATURE_PRODUCTION_PERCENT -
							if pPlot.getTeam() != pPlayer.getTeam():
								iExtraWood *= 67
								iExtraWood /= 100

							# 20% Hauptstadteffekt
							iExtraWood /= 5
					
							if iExtraWood > 0:
								pCapital.setOverflowProduction(pCapital.getOverflowProduction() + iExtraWood)
								# pCapital.changeProduction(iExtraWood)
								# CyInterface().addMessage(iPlayer,true,20,CyTranslator().getText("TXT_MOREWOOD",(iExtraWood,pCapital.getName(),)),'',0,'',-1,-1,-1, true,true)
# ZE: Brasilien 2/3 End -----------------------------------------------------------------------------------------------

	def onPlotPicked(self, argsList):
		'Plot Picked'
		pPlot = argsList[0]
		CvUtil.pyPrint('Plot was picked at %d, %d'
			%(pPlot.getX(), pPlot.getY()))

	def onNukeExplosion(self, argsList):
		'Nuke Explosion'
		pPlot, pNukeUnit = argsList
		CvUtil.pyPrint('Nuke detonated at %d, %d'
			%(pPlot.getX(), pPlot.getY()))

	def onGotoPlotSet(self, argsList):
		'Nuke Explosion'
		pPlot, iPlayer = argsList

	def onBuildingBuilt(self, argsList):
		'Building Completed'
		pCity, iBuildingType = argsList
		game = gc.getGame()
		
		pPlayer = gc.getPlayer(pCity.getOwner())
		pActivePlayer = gc.getActivePlayer()

		if (((not gc.getGame().isNetworkMultiPlayer()) or (pActivePlayer and pActivePlayer.isOption(PlayerOptionTypes.PLAYEROPTION_MP_TECH_SOUNDS_AS_SP))) and (pCity.getOwner() == gc.getGame().getActivePlayer()) and (isWorldWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType()) or isNationalWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType()))):
			# If this is a wonder...
	## Platy Builder ##
			if not CyGame().GetWorldBuilderMode():
	## Platy Builder ##
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
				popupInfo.setData1(iBuildingType)
				popupInfo.setData2(pCity.getID())
				popupInfo.setData3(0)
				popupInfo.setText(u"showWonderMovie")
				popupInfo.addPopup(pCity.getOwner())
# Anthems Start -----------------------------------------------------------------------------------------------
				
		if isWorldWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType()):
			if pActivePlayer:
				if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()) and pActivePlayer.isOption(PlayerOptionTypes.PLAYEROPTION_ANTHEMS):

					#CyInterface().addMessage(iNewOwner,false,15,CyTranslator().getText("TXT_KEY_ANTHEM_CITY_CONQUER",( pCity.getName(), PyHelpers.PyInfo.BuildingInfo(iUniqueBuilding).getDescription() , PyHelpers.PyInfo.BuildingInfo(iDefaultBuilding).getDescription() )),'',0,gc.getBuildingInfo(iUniqueBuilding).getButton(),ColorTypes(11),pCity.getX(),pCity.getY(),True,True)

					#strMessageAnthem = CyTranslator().getText("TXT_KEY_BUILDING_FORTKNOX_WINNER", (ppPlayer.getName(), (iConquestGold)))
					#CyInterface().addMessage(pPlayer.getID(), True, 20, strMessageAnthem, "AS2D_ANTHEM_AEGYPTEN", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), iX, iY, True, True)

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AMERICA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ARABIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AUSTRIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AZTEC"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AZTEC")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BABYLON")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BERBER")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BRAZIL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BYZANTIUM")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CARIBBEAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CARTHAGE")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CELT")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CHINA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_EGYPT")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ENGLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ETHIOPIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_FRANCE")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_GERMANY")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_GREECE")
						
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HITTITES")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HOLY_ROMAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HUNGARY")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INCA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INDIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INDONESIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ISRAEL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_JAPAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_KHMER")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_KOREA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MALI")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MAYA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MONGOL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_NATIVE_AMERICA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_NETHERLANDS")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_OTTOMAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_PERSIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_POLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_POLYNESIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_PORTUGAL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ROME")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_RUSSIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCOTLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SCOTLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCYTHS"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SCYTHS")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SPAIN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SUMERIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SUMERIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_TIBET"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_TIBET")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_VIKING")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ZULU")

# Anthems End -----------------------------------------------------------------------------------------------
# Versailles Start -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString( 'BUILDING_VERSAILLES' ):
			iTheSpeed = CyGame().getGameSpeedType()
			TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
			iVersaillesGold = ((1000 * TheSpeed.getUnitTradePercent()) / 100)
			pPlayer.changeGold(iVersaillesGold)
# Versailles End -----------------------------------------------------------------------------------------------
# Great Bath Start -----------------------------------------------------------------------------------------------
# rucivfan: Wird doch schon eine Weile ber XML und SDK geregelt
#		if iBuildingType == gc.getInfoTypeForString( 'BUILDING_GREAT_BATH' ):
#			pPID = pPlayer.getID()
#			pTID = pPlayer.getTeam()
#			iX = pCity.getX()
#			iY = pCity.getY()
#			pPlot = CyMap().plot(iX +0, iY +0)
#			pPlot.setFeatureType(gc.getInfoTypeForString( "FEATURE_RAINWATER_BASIN" ), 1)
# Great Bath End -----------------------------------------------------------------------------------------------
# KGB / Lubjanka Start -----------------------------------------------------------------------------------------------
		# if iBuildingType == gc.getInfoTypeForString( 'BUILDING_KGB' ):

			# if not gc.getGame().isNetworkMultiPlayer() and not gc.getGame().isGameMultiPlayer() and not gc.getGame().isPitboss():

				# iTrait = gc.getInfoTypeForString("TRAIT_REPRESSIVE")
				# iTeam = pPlayer.getTeam()

				# for iPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
					# ppPlayer = gc.getPlayer(iPlayer)
					# if ppPlayer.isAlive():
						# if not ppPlayer.hasTrait(iTrait) or ppPlayer.hasTrait(iTrait):
							# if not ppPlayer.isGoldenAge():
								# if ppPlayer.getTeam() != pPlayer.getTeam():
									# if not gc.getTeam(ppPlayer.getTeam()).isVassal(iTeam):

										# estiEnd = CyGame().getEstimateEndTurn()

										# if ( estiEnd >= 1000 ):
											# ppPlayer.changeAnarchyTurns( 9 )
											# ppPlayer.changeAnarchyTurns( 1 )
										# elif ( estiEnd >= 700 ):
											# ppPlayer.changeAnarchyTurns( 6 )
											# ppPlayer.changeAnarchyTurns( 1 )
										# elif ( estiEnd >= 500 ):
											# ppPlayer.changeAnarchyTurns( 4 )
											# ppPlayer.changeAnarchyTurns( 1 )
										# elif ( estiEnd >= 300 ):
											# ppPlayer.changeAnarchyTurns( 2 )
											# ppPlayer.changeAnarchyTurns( 1 )

				# # szTitle = CyTranslator().getText( "TXT_KEY_KGB_GLOBAL_ANARCHY", ( ) )
				# # CyInterface().addImmediateMessage( szTitle , None)

			# else:
				# if pPlayer.isGoldenAge(): iGALength = pPlayer.getGoldenAgeLength()
				# else: iGALength = (pPlayer.getGoldenAgeLength() + 1)
				# pPlayer.changeGoldenAgeTurns(iGALength)
# KGB / Lubjanka End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Hagia Sophia Start -----------------------------------------------------------------------------------------------

		if iBuildingType == gc.getInfoTypeForString("BUILDING_HAGIA_SOPHIA"):
			pCity.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_ARCHITECT' ), False, False)
			
# Cybah: BASE fr 6.1 E - Hagia Sophia End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Triumpfbogen Start -----------------------------------------------------------------------------------------------

		if iBuildingType == gc.getInfoTypeForString("BUILDING_ARC_DE_TRIOMPHE"):
			pCity.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), False, False)

# Cybah: BASE fr 6.1 E - Triumpfbogen End -----------------------------------------------------------------------------------------------
# The School of Confucius Schule des Konfuzius Start -----------------------------------------------------------------------------------------------

		if iBuildingType == gc.getInfoTypeForString("BUILDING_PALACE_CHINA"):

			iPID = pPlayer.getID()
			iTID = pPlayer.getTeam()
			iX = pCity.getX()
			iY = pCity.getY()
			b_school = gc.getInfoTypeForString("BUILDING_PALACE_CHINA")
			u_prophet = gc.getInfoTypeForString( 'UNIT_PROPHET' )
			u_artist = gc.getInfoTypeForString( 'UNIT_ARTIST' )
			u_scientist = gc.getInfoTypeForString( 'UNIT_SCIENTIST' )
			u_merchant = gc.getInfoTypeForString( 'UNIT_MERCHANT' )
			u_engineer = gc.getInfoTypeForString( 'UNIT_ENGINEER' )

			iGreatPeopleNumberOne = self.getRandomNumber( 5 )
			
			#6.3 C - neuer Code, damit Nachricht der Geburt im Log bleibt:
			if iGreatPeopleNumberOne == 0: pCity.createGreatPeople(u_prophet, False, False)
			elif iGreatPeopleNumberOne == 1: pCity.createGreatPeople(u_artist, False, False)
			elif iGreatPeopleNumberOne == 2: pCity.createGreatPeople(u_scientist, False, False)
			elif iGreatPeopleNumberOne == 3: pCity.createGreatPeople(u_merchant, False, False)
			elif iGreatPeopleNumberOne == 4: pCity.createGreatPeople(u_engineer, False, False)

			# for i in xrange(1):
				# if iGreatPeopleNumberOne == 0:
					# pNewUnit = pPlayer.initUnit( u_prophet, iX, iY, UnitAITypes.UNITAI_PROPHET, DirectionTypes.NO_DIRECTION )
					# pActivePlayer = gc.getActivePlayer()
					# if pActivePlayer:
						# if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()):
							# szTitle = CyTranslator().getText( "TXT_KEY_SCHOOL_PROPHET", ( ) )
							# CyInterface().addImmediateMessage( szTitle , None)
				# if iGreatPeopleNumberOne == 1:
					# pNewUnit = pPlayer.initUnit( u_artist, iX, iY, UnitAITypes.UNITAI_ARTIST, DirectionTypes.NO_DIRECTION )
					# pActivePlayer = gc.getActivePlayer()
					# if pActivePlayer:
						# if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()):
							# szTitle = CyTranslator().getText( "TXT_KEY_SCHOOL_ARTIST", ( ) )
							# CyInterface().addImmediateMessage( szTitle , None)
				# if iGreatPeopleNumberOne == 2:
					# pNewUnit = pPlayer.initUnit( u_scientist, iX, iY, UnitAITypes.UNITAI_SCIENTIST, DirectionTypes.NO_DIRECTION )
					# pActivePlayer = gc.getActivePlayer()
					# if pActivePlayer:
						# if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()):
							# szTitle = CyTranslator().getText( "TXT_KEY_SCHOOL_SCIENTIST", ( ) )
							# CyInterface().addImmediateMessage( szTitle , None)
				# if iGreatPeopleNumberOne == 3:
					# pNewUnit = pPlayer.initUnit( u_merchant, iX, iY, UnitAITypes.UNITAI_MERCHANT, DirectionTypes.NO_DIRECTION )
					# pActivePlayer = gc.getActivePlayer()
					# if pActivePlayer:
						# if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()):
							# szTitle = CyTranslator().getText( "TXT_KEY_SCHOOL_MERCHANT", ( ) )
							# CyInterface().addImmediateMessage( szTitle , None)
				# if iGreatPeopleNumberOne == 4:
					# pNewUnit = pPlayer.initUnit( u_engineer, iX, iY, UnitAITypes.UNITAI_ENGINEER, DirectionTypes.NO_DIRECTION )
					# pActivePlayer = gc.getActivePlayer()
					# if pActivePlayer:
						# if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()):
							# szTitle = CyTranslator().getText( "TXT_KEY_SCHOOL_ENGINEER", ( ) )
							# CyInterface().addImmediateMessage( szTitle , None)

# The School of Schule des Konfuzius Confucius End -----------------------------------------------------------------------------------------------
# Brandenburg Gate Start -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_BRANDENBURG_GATE"):
			for i in xrange(pPlayer.getNumUnits()):
				unit = pPlayer.getUnit(i)
				if unit.airBaseCombatStr() > 0 or unit.baseCombatStr() > 0:
					if unit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_ALIEN' ) and unit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_MISC' ) and unit.getUnitCombatType() != gc.getInfoTypeForString( 'UNITCOMBAT_WORKER' ):
						l_Promos = []
						for j in xrange(gc.getNumPromotionInfos()):
							if unit.canAcquirePromotion(j) and not unit.isHasPromotion(j) and not j == gc.getInfoTypeForString( 'PROMOTION_LEADER' ) and not j == gc.getInfoTypeForString( 'PROMOTION_POPULIST1' ) and not j == gc.getInfoTypeForString( 'PROMOTION_COVER2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_SHOCK2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_PINCH2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_FORMATION2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_ASSAULT2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_CHARGE2' ) and not j == gc.getInfoTypeForString( 'PROMOTION_AMBUSH2' ):
								l_Promos.append(j)
						if len(l_Promos) >= 1:
							iPromo = CyGame().getSorenRandNum(len(l_Promos), "Random for Promotions")
							unit.setHasPromotion(l_Promos[iPromo],True)
							
						# Cybah: BASE fr 6.1 F - einmalige Zusatzerfahrung in Hhe des Levels der Einheit
						unit.changeExperience(unit.getLevel(),-1,False,False,False)

						#if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CHARISMATIC")):
						#	iXPNeeded = (unit.getLevel() * unit.getLevel() + 1)
						#	iXPNeeded += ((iXPNeeded * pPlayer.getLevelExperienceModifier() + 99) / 100)
						#	iUnitXP = (iXPNeeded - unit.getExperience())
						#	unit.changeExperience(iUnitXP,-1,False,False,False)
						#	unit.setPromotionReady(1)				
						#else:
						#	iXPNeeded = (unit.getLevel() * unit.getLevel() + 1)
						#	iUnitXP = (iXPNeeded - unit.getExperience())
						#	unit.changeExperience(iUnitXP,-1,False,False,False)
						#	unit.setPromotionReady(1)
# Brandenburg Gate End -----------------------------------------------------------------------------------------------
# Area51 Start -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_AREA51"):
			iArea51Units = self.getRandomNumber( 21 )
			if iArea51Units == 0:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 1:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 2:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 3:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 4:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 5:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_LOCUST' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 6:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 7:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 8:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 9:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 10:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_PREDATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 11:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 12:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 13:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 14:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GOLIATH' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 15:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 16:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 17:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_I' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 18:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			elif iArea51Units == 19:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SPIDER_II' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			else:
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_MARAUDER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				for i in xrange (1):
					pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_AVENGER' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
# Area51 End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - Flavisches Amphitheater START -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_FLAVIAN"):
			pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GLADIATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.NO_DIRECTION )
			pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GLADIATOR' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_GENERAL, DirectionTypes.NO_DIRECTION )
# Cybah: BASE fr 6.3 C - Flavisches Amphitheater END -----------------------------------------------------------------------------------------------
# Ballturnierplatz Start -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_MAYA_BALL_COURT"):
			iReligion = pPlayer.getStateReligion()
			if not iReligion == -1:
				if not pCity.isHasReligion(iReligion): pCity.setHasReligion(iReligion,True,True,True)
				# Wenn Staatsreli vorhanden und auch schon verbreitet: Bekommt nen Missionar
				else:
					if iReligion == gc.getInfoTypeForString( 'RELIGION_JUDAISM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_JEWISH_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_CHRISTIANITY' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_CHRISTIAN_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_ISLAM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_ISLAMIC_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_HINDUISM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_HINDU_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_BUDDHISM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_BUDDHIST_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_CONFUCIANISM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_CONFUCIAN_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_TAOISM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TAOIST_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_OLYMP' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_OLYMP_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_ASEN' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_ASEN_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_VOODOO' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_VOODOO_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_SHINTO' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SHINTO_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_ZORO' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_ZORO_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_RA' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_RA_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_TOLTEC' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TOLTEC_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_SHAMAN' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_SHAMAN_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_FREEM' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_FREEM_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					elif iReligion == gc.getInfoTypeForString( 'RELIGION_DRUID' ): pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_DRUID_MISSIONARY' ), pCity.getX(), pCity.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
			# Wenn keine Staatsreli vorhanden: Gold in Hhe 50% der Gebudekosten
			else:
				iTheSpeed = CyGame().getGameSpeedType()
				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
				pHandicapInfo = gc.getHandicapInfo(gc.getGame().getHandicapType())
				# rucivfan_ai_auto_play raap[
				#if pPlayer.isHuman(): iBuildingCost = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 100)
				if pPlayer.isHumanActive(): iBuildingCost = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 100)
				# ]rucivfan_ai_auto_play raap
				else: iBuildingCost = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent() * pHandicapInfo.getAIConstructPercent()) / 10000)
				if iBuildingCost > 0:
					iBuildingCost /= 2
					pPlayer.changeGold(iBuildingCost)
# Ballturnierplatz End -----------------------------------------------------------------------------------------------
# Stele Start -----------------------------------------------------------------------------------------------
		# if iBuildingType == gc.getInfoTypeForString("BUILDING_ETHIOPIAN_STELE"):
			# pPID = pPlayer.getID()
			# estiEnd = CyGame().getEstimateEndTurn()
			# if estiEnd >= 1000:
				# if pCity.getCulture(pPID) < 30:
					# iSteleCult = int(30 - pCity.getCulture(pPID))
					# pCity.changeCulture(pPID, iSteleCult, true)
			# elif estiEnd >= 700:
				# if pCity.getCulture(pPID) < 15:
					# iSteleCult = int(15 - pCity.getCulture(pPID))
					# pCity.changeCulture(pPID, iSteleCult, true)
			# elif estiEnd >= 500:
				# if pCity.getCulture(pPID) < 10:
					# iSteleCult = int(10 - pCity.getCulture(pPID))
					# pCity.changeCulture(pPID, iSteleCult, true)
			# elif estiEnd >= 300:
				# if pCity.getCulture(pPID) < 5:
					# iSteleCult = int(5 - pCity.getCulture(pPID))
					# pCity.changeCulture(pPID, iSteleCult, true)
			# elif estiEnd < 300:
				# if pCity.getCulture(pPID) < 5:
					# iSteleCult = int(5 - pCity.getCulture(pPID))
					# pCity.changeCulture(pPID, iSteleCult, true)
# Stele End -----------------------------------------------------------------------------------------------
# Odeon Start -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_GREEK_ODEON"):
			pPID = pPlayer.getID()
			estiEnd = CyGame().getEstimateEndTurn()
			if estiEnd >= 1000:
				iCult = 1500
				pCity.changeCulture(pPID, iCult, true)
			elif estiEnd >= 700:
				iCult = 750
				pCity.changeCulture(pPID, iCult, true)
			elif estiEnd >= 400:
				iCult = 500
				pCity.changeCulture(pPID, iCult, true)
			elif estiEnd >= 300:
				iCult = 250
				pCity.changeCulture(pPID, iCult, true)
			elif estiEnd < 300:
				iCult = 250
				pCity.changeCulture(pPID, iCult, true)
# Odeon End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 - Skythischer Kurgan Start // Idee verworfen wegen Stonehenge! -----------------------------------------------------------------------------------------------
		# if iBuildingType == gc.getInfoTypeForString("BUILDING_SCYTHIAN_KURGAN"):
			# pPID = pPlayer.getID()
			# estiEnd = CyGame().getEstimateEndTurn()
			# if estiEnd >= 1000:
				# iCult = 300
				# pCity.changeCulture(pPID, iCult, true)
			# elif estiEnd >= 700:
				# iCult = 150
				# pCity.changeCulture(pPID, iCult, true)
			# elif estiEnd >= 400:
				# iCult = 100
				# pCity.changeCulture(pPID, iCult, true)
			# elif estiEnd >= 300:
				# iCult = 50
				# pCity.changeCulture(pPID, iCult, true)
			# elif estiEnd < 300:
				# iCult = 50
				# pCity.changeCulture(pPID, iCult, true)
# Cybah: BASE fr 6.3 - Skythischer Kurgan Start -----------------------------------------------------------------------------------------------
# Vegvar Start -----------------------------------------------------------------------------------------------
#		if iBuildingType == gc.getInfoTypeForString("BUILDING_HUNGARIAN_VEGVAR"):
#			# rucivfan_conscript_extended rce[
#			#pHSUnitID = pCity.getConscriptUnit()
#			pHSUnitID = pCity.getConscriptUnit(true)	# true fr keine reinen Verteidigungseinheiten
#			# ]rucivfan_conscript_extended rce
#			for i in xrange(1):
#				pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
#				pCity.addProductionExperience(pNewUnit, false)
# Vegvar End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E TEST - Populist Trait: Nationaler Feiertag auch bei Nationalwunderbau START -----------------------------------------------------------------------------------------------
		# if isNationalWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType()):
			# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_POPULIST")):
				# iPopGoldTotal = 0
				# pCityPop, iter = pPlayer.firstCity(false)
				# while(pCityPop):
					# if pCityPop.getOwner() == pPlayer.getID() and pCityPop.getPopulation() > 0 and not pCityPop.isNone() and not pCityPop.isWeLoveTheKingDay():
						# pCityPop.setWeLoveTheKingDay(true)
						# iPopGoldTotal += pCityPop.getPopulation()
						# # Cybah: BASE fr 6.1 D - Vier statt zwei einzelne Berechnungen fr weniger Random Spitzen
						# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
						# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
						# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
						# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					# pCityPop, iter = pPlayer.nextCity(iter, false)
						
				# if iPopGoldTotal > 0:
					# iGoldFaktor = 4
					# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PRINTING_PRESS")):
						# iGoldFaktor += 1
					# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MASS_MEDIA")):
						# iGoldFaktor += 1
					# iPopGoldTotal *= iGoldFaktor
					# iPopGoldTotal /= 4
						
					# #Fr 6.1 E - 50% mehr Gold
					# iPopGoldTotal *= 4
					# iPopGoldTotal /= 2
					
					# pPlayer.changeGold(iPopGoldTotal)
					# pCapital = pPlayer.getCapitalCity()
					# strMessage = CyTranslator().getText("TXT_KEY_TRAIT_POP_GET_GOLD_NATIONAL", (iPopGoldTotal, (iPopGoldTotal)))
					# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCapital.getX(), pCapital.getY(), True, True)
# Cybah: BASE fr 6.1 E TEST - Populist Trait: Nationaler Feiertag auch bei Wunderbau END -----------------------------------------------------------------------------------------------
		if isWorldWonderClass(gc.getBuildingInfo(iBuildingType).getBuildingClassType()):
# Creative Trait Start -----------------------------------------------------------------------------------------------
			if gc.getBuildingInfo(iBuildingType).getReligionType() == -1 and gc.getBuildingInfo(iBuildingType).getProductionCost() > 0:
				iTheSpeed = CyGame().getGameSpeedType()
				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
# ZE: Inka 6.3 B Start ----------------------------------------------------------------------------------------------
				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
					iTechZEINCA = gc.getInfoTypeForString("TECH_INCA")
					if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEINCA):
						# 1 Gold fr 5 Hmmer
						iWonderGoldInca = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 500)
						pPlayer.changeGold(iWonderGoldInca)
# ZE: Inka 6.3 B End ----------------------------------------------------------------------------------------------
				for iPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
					ppPlayer = gc.getPlayer(iPlayer)
					iTraitCre = gc.getInfoTypeForString("TRAIT_CREATIVE")
					# Cybah: BASE fr 6.1 E - Kein Gold mehr, wenn Wunder im eigenen Team erbaut (siehe letztes and)
					if ppPlayer.isAlive() and ppPlayer.hasTrait(iTraitCre) and ppPlayer.countNumBuildings(iBuildingType) < 1 and ppPlayer.getTeam() != pPlayer.getTeam():
						
						# 1 Gold fr 10 Hmmer
						iWonderGold = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 1000)
						
						iWonderDescription = gc.getBuildingInfo(iBuildingType).getDescription()
						ppcapital = ppPlayer.getCapitalCity()
						strMessage = CyTranslator().getText("TXT_KEY_TRAIT_CREATIVE_OTHER_WONDER", (iWonderGold, (iWonderDescription)))
						CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage, "", 0, gc.getBuildingInfo(iBuildingType).getButton(), ColorTypes(7), ppcapital.getX(), ppcapital.getY(), True, True)
						ppPlayer.changeGold(iWonderGold)
											
					# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion zum Bau von Weltwundern
						iThreshold = self.iHGA * (ppPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
						iCurrent = 0

						# 1 Bonusproduktion fr 10 Hmmer
						if not SDTK.sdObjectExists( "Kreativ", ppPlayer ):
							iCurrent = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 1000)
							SDTK.sdObjectInit('Kreativ', ppPlayer, {})
							SDTK.sdObjectSetVal( "Kreativ", ppPlayer, 'iCurrent', iCurrent)
						else:
							# BugUtil.warn("Kreativ Script existiert")
							if SDTK.sdObjectGetVal( "Kreativ", ppPlayer, 'iCurrent') == None or SDTK.sdObjectGetVal( "Kreativ", ppPlayer, 'iCurrent') < 0:
								# BugUtil.warn("Inhalt von Kreativ Script ist None")
								iCurrent = ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 1000)
							else:
								iCurrent = (SDTK.sdObjectGetVal( "Kreativ", ppPlayer, 'iCurrent') + ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 1000))
						
						# Maximal 500 (modifiziert vom Game Speed) im Speicher
						if iCurrent >= iThreshold: iCurrent = iThreshold
							
						SDTK.sdObjectSetVal( "Kreativ", ppPlayer, 'iCurrent', iCurrent)
						SDTK.sdObjectSetVal( "Kreativ", ppPlayer, 'iThreshold', iThreshold)
						
						# Test
						# CyInterface().addMessage(gc.getGame().getActivePlayer(),true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iCurrent,SDTK.sdObjectGetVal( "Kreativ", ppPlayer, 'iCurrent'),)),'',0,'',-1,-1,-1,false,false)

						# Alter Code
						# sScript = ppPlayer.getScriptData()
						# sHappy = sScript[:sScript.find("Split")]
						# if sHappy.find("HGA") == -1:
							# iCurrent = 0
							# iThreshold = self.iHGA * (ppPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
						# else:
							# iCurrent = int(sHappy[:sHappy.find("HGA")])
							# iThreshold = self.iHGA * (ppPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
							# # iThreshold = int(sHappy[sHappy.find("HGA") +3:])
							
						# # 1 Bonusproduktion fr 10 Hmmer
						# iCurrent += ((gc.getBuildingInfo(iBuildingType).getProductionCost() * TheSpeed.getConstructPercent()) / 1000)
						
						# # Maximal 500 (modifiziert vom Game Speed) im Speicher
						# if iCurrent >= iThreshold: iCurrent = iThreshold
							
						# sHappy = str(iCurrent) + "HGA" + str(iThreshold)
						# sScript = sHappy + "Split"
						# ppPlayer.setScriptData(sScript)	
						
					# # Cybah: BASE fr 6.1 E - Kreativ Groer Architekt-Punkte - DEAKTIVIERT - jetzt Bonusproduktion zum Bau von Weltwundern
						# # sScript = ppPlayer.getScriptData()
						# # sHappy = sScript[:sScript.find("Split")]
						# # if sHappy.find("HGA") == -1:
							# # iCurrent = 0
							# # iThreshold = 10
						# # else:
							# # iCurrent = int(sHappy[:sHappy.find("HGA")])
							# # iThreshold = int(sHappy[sHappy.find("HGA") +3:])
						# # iCurrent += 1 
						# # if iCurrent >= iThreshold:
							# # ppcapital.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_ARCHITECT' ), False, False)
							# # iCurrent = 0
						# # sHappy = str(iCurrent) + "HGA" + str(iThreshold)
						# # sScript = sHappy + "Split"
						# # ppPlayer.setScriptData(sScript)	
# Creative Trait End -----------------------------------------------------------------------------------------------
# Palastbau-Funktionen START -----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_PALACE"):
		# Mehr Palastkommerz START -----------------------------------------------------------------------------------------------
			iBonusPalaceCommerce = 0
			# 6.4 C - Kommerzbonus fr Rad
			if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
				iBonusPalaceCommerce += 2
				
			# ZE: Byzanz 1/4 Start ----------------------------------------------------------------------------------------------
			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
				iTechZEBY = gc.getInfoTypeForString("TECH_BYZANTIUM")
				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEBY):
				
					# Nichthauptstdte zhlen
					iNonCapCities= 0
					pNumCity, iter = pPlayer.firstCity(false)  
					while(pNumCity):	  
						if pNumCity.getOwner() == pPlayer.getID() and not pNumCity.isNone() and not pNumCity.isCapital():
							iNonCapCities += 1
							# Bonus temporr auf 0 setzen
							pNumCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, 0)
						pNumCity, iter = pPlayer.nextCity(iter, false)
				
					# Eigenschaft: +2 immer und +1 fr jede weitere Stadt
					iByzBonus = (2 + iNonCapCities)
					iBonusPalaceCommerce += iByzBonus
			# ZE: Byzanz 1/4 End ----------------------------------------------------------------------------------------------

			# Palastkommerzbonus in allen Stdten einstellen
			pCityPalaceCommerce, iter = pPlayer.firstCity(false)  
			while(pCityPalaceCommerce):	  
				if pCityPalaceCommerce.getOwner() == pPlayer.getID() and not pCityPalaceCommerce.isNone():
					pCityPalaceCommerce.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, iBonusPalaceCommerce)
				pCityPalaceCommerce, iter = pPlayer.nextCity(iter, false)
		# Mehr Palastkommerz END -----------------------------------------------------------------------------------------------
		# Cybah: BASE fr 6.1 F - ZE: Hethiter Start ----------------------------------------------------------------------------------------------
			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
				iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHET):
				
					# Wenn Sklavenzahl existiert (ab zweiter Stadt): Scriptdata fr Sklavenzahl anpassen
					if SDTK.sdObjectExists( "Hitti", pPlayer ):
					
						# Stdte zhlen
						iCities = 0
						pCityHet, iter = pPlayer.firstCity(false)
						while(pCityHet):
							if pCityHet.getOwner() == pPlayer.getID() and not pCityHet.isNone():
								iCities += 1
							pCityHet, iter = pPlayer.nextCity(iter, false)
					
						# Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
						iOldSlaves = max(0, (iCities - 1))
						SDTK.sdObjectSetVal("Hitti", pPlayer, 'Slaves', iOldSlaves)
					
						# Stdte durchgehen
						iCities = 0
						pCityHet, iter = pPlayer.firstCity(false)  
						while(pCityHet):
							if pCityHet.getOwner() == pPlayer.getID() and not pCityHet.isNone():
								iCities += 1
								# Stadt hat Sklaven -> entfernen um sie spter der Hauptstadt wieder hinzuzufgen
								if SDTK.sdObjectGetVal( "Hitti", pCityHet, 'iHasSlavesPlayer' ) == pPlayer.getID() and iOldSlaves > 0:
									# BugUtil.warn("Sklaven werden entfernt")
									pCityHet.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
									SDTK.sdObjectSetVal( "Hitti", pCityHet, 'iHasSlavesPlayer', -1)
								else: SDTK.sdObjectSetVal( "Hitti", pCityHet, 'iHasSlavesPlayer', -1)
							pCityHet, iter = pPlayer.nextCity(iter, false)
									
						# Neue Sklavenzahl festlegen
						iNewSlaves = max(0, (iCities - 1))
						SDTK.sdObjectSetVal( "Hitti", pPlayer, 'Slaves', iNewSlaves)
						
						# Hauptstadt bekommt neue Sklavenzahl (wurden zuvor entfernt im Stdtedurchgang)
						pCity.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), SDTK.sdObjectGetVal( "Hitti", pPlayer, 'Slaves' ))
						SDTK.sdObjectSetVal( "Hitti", pCity, 'iHasSlavesPlayer', pPlayer.getID())
		# Cybah: BASE fr 6.1 F - ZE: Hethiter End ----------------------------------------------------------------------------------------------
# Palastbau-Funktionen END -----------------------------------------------------------------------------------------------
# Dreischluchtenstaudamm Start ----------------------------------------------------------------------------------------------
		if iBuildingType == gc.getInfoTypeForString("BUILDING_GREAT_DAM"):
			pCityDSS, iter = pPlayer.firstCity(false)  
			while(pCityDSS):
				if pCityDSS.getOwner() == pPlayer.getID() and not pCityDSS.isNone():
					if pCity.area().getID() == pCityDSS.area().getID():
						pCityDSS.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_COAL_PLANT"),0)
						pCityDSS.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_NUCLEAR_PLANT"),0)
				pCityDSS, iter = pPlayer.nextCity(iter, false)
# Dreischluchtenstaudamm End ----------------------------------------------------------------------------------------------	

		CvAdvisorUtils.buildingBuiltFeats(pCity, iBuildingType)
		
		if iBuildingType == gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING"):
			pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY"), False)
		#elif iBuildingType == gc.getInfoTypeForString("BUILDING_DEFLECTOR_SHIELDING"):
			#pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING"), False)

		if (not self.__LOG_BUILDING):
			return
		CvUtil.pyPrint('%s was finished by Player %d Civilization %s' 
			%(PyInfo.BuildingInfo(iBuildingType).getDescription(), pCity.getOwner(), gc.getPlayer(pCity.getOwner()).getCivilizationDescription(0)))
	
	def onProjectBuilt(self, argsList):
		'Project Completed'
		pCity, iProjectType = argsList
		game = gc.getGame()
		if ((not gc.getGame().isNetworkMultiPlayer()) and (pCity.getOwner() == gc.getGame().getActivePlayer())):
	## Platy Builder ##
			if not CyGame().GetWorldBuilderMode():
	## Platy Builder ##
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
				popupInfo.setData1(iProjectType)
				popupInfo.setData2(pCity.getID())
				popupInfo.setData3(2)
				popupInfo.setText(u"showWonderMovie")
				popupInfo.addPopup(pCity.getOwner())

		iPlayer = pCity.getOwner()
		pPlayer = gc.getPlayer(iPlayer)
		iTeam = pPlayer.getTeam()
		iX = pCity.getX()
		iY = pCity.getY()

# Cybah: BASE fr 6.4 C - Beziehungsverschlechterung durch Weltraumrennen-Projekte START -----------------------------------------------------------------------------------------------
		if iProjectType == gc.getInfoTypeForString("PROJECT_APOLLO_PROGRAM") or iProjectType == gc.getInfoTypeForString("PROJECT_MISSION_TO_MARS") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_COCKPIT") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_LIFE_SUPPORT") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_STASIS_CHAMBER") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_DOCKING_BAY") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_ENGINE") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_CASING") or iProjectType == gc.getInfoTypeForString("PROJECT_SS_THRUSTERS"):
			for iPlayerLoop in xrange(gc.getMAX_CIV_PLAYERS()):
				ppPlayer = gc.getPlayer(iPlayerLoop)
				if ppPlayer.isAlive():
					if ppPlayer.getTeam() != pPlayer.getTeam():
						if not gc.getTeam(ppPlayer.getTeam()).isVassal(iTeam):
							ppPlayer.AI_changeAttitudeExtra(iPlayer, -2)
# Cybah: BASE fr 6.4 C - Beziehungsverschlechterung durch Weltraumrennen-Projekte END -----------------------------------------------------------------------------------------------
# Hacker Attack Start -----------------------------------------------------------------------------------------------

		if iProjectType == gc.getInfoTypeForString("PROJECT_HACKER_ATTACK"):
			for iPlayerLoop in xrange(gc.getMAX_CIV_PLAYERS()):
				ppPlayer = gc.getPlayer(iPlayerLoop)
				if ppPlayer.isAlive():
					if ppPlayer.getTeam() != pPlayer.getTeam():
						if not gc.getTeam(ppPlayer.getTeam()).isVassal(iTeam):
							iRivalGold = ppPlayer.getGold( )
							pPlayer.changeGold( iRivalGold )
							ppPlayer.changeGold( -iRivalGold )

# Hacker Attack End -----------------------------------------------------------------------------------------------
# World War Start -----------------------------------------------------------------------------------------------

		if iProjectType == gc.getInfoTypeForString("PROJECT_WORLD_WAR"):
			pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )   
			iMaxTeam = gc.getMAX_CIV_TEAMS() 
			for i in xrange(iMaxTeam): 
				for j in xrange(iMaxTeam): 
					if i!=j and i!=iTeam and j!=iTeam: 
						FirstTeam = gc.getTeam(i) 
						SecondTeam = gc.getTeam(j) 
						if FirstTeam.isAlive() and SecondTeam.isAlive() and not FirstTeam.isAVassal() and not SecondTeam.isAVassal() and not gc.getTeam(iTeam).isVassal(i) and not gc.getTeam(iTeam).isVassal(j) and not gc.getTeam(iTeam).isDefensivePact(i) and not gc.getTeam(iTeam).isDefensivePact(j):
							iRandom = self.getRandomNumber(2)
							if iRandom == 0:
								FirstTeam.declareWar(j,True,WarPlanTypes.NO_WARPLAN)
							else:
								SecondTeam.declareWar(i,True,WarPlanTypes.NO_WARPLAN)

# World War End -----------------------------------------------------------------------------------------------
# Geographike Hyphegesis Start -----------------------------------------------------------------------------------------------

		if iProjectType == gc.getInfoTypeForString("PROJECT_GEOGRAPHIKE_HYPHEGESIS"):
			iTechGeographike = gc.getInfoTypeForString("TECH_GEOGRAPHIKE_HYPHEGESIS")
			pTeam = gc.getTeam(pPlayer.getTeam())
			# Alt: Komplette Weltkarte
			# pTeam.setHasTech(iTechGeographike, true, iPlayer, false, false)
			
			# Neu in BASE 6.1 F: Weltkarten aller Nationen
			for i in xrange(gc.getMAX_CIV_TEAMS()):
				MapH = CyMap().getGridHeight()
				MapW = CyMap().getGridWidth()
				for j in xrange (MapW):
					for k in xrange (MapH):
						pPlot = CyMap().plot(j, k)
						if pPlot.isVisible(i, False): pPlot.setRevealed(pPlayer.getTeam(), True, False, i)

# Geographike Hyphegesis End -----------------------------------------------------------------------------------------------
# Manhattan Project Start -----------------------------------------------------------------------------------------------

		if iProjectType == gc.getInfoTypeForString("PROJECT_MANHATTAN_PROJECT"):
			for i in xrange(1):
				pNewMHUnit1 = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TACTICAL_NUKE' ), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
			for i in xrange(1):
				pNewMHUnit2 = pPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_ICBM' ), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )

# Manhattan Project End -----------------------------------------------------------------------------------------------
# Great Man-Made River Start -----------------------------------------------------------------------------------------------
		if iProjectType == gc.getInfoTypeForString("PROJECT_GMMR"):
			for iX in xrange(CyMap().getGridWidth()):
				for iY in xrange(CyMap().getGridHeight()):	
					pPlot = CyMap().plot(iX,iY)
					if pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_DESERT' ) and not pPlot.isImpassable() and not pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' ) and not pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_OASIS' ):
						if pPlot.getOwner() == iPlayer:
							CyGame().setPlotExtraYield(iX, iY, YieldTypes.YIELD_FOOD, 1)
# Great Man-Made River End -----------------------------------------------------------------------------------------------
				
	def onSelectionGroupPushMission(self, argsList):
		'selection group mission'
		eOwner = argsList[0]
		eMission = argsList[1]
		iNumUnits = argsList[2]
		listUnitIds = argsList[3]
		
		if (not self.__LOG_PUSH_MISSION):
			return
		if pHeadUnit:
			CvUtil.pyPrint("Selection Group pushed mission %d" %(eMission))
	
	def onUnitMove(self, argsList):
		'unit move'
		pPlot,pUnit,pOldPlot = argsList
		player = PyPlayer(pUnit.getOwner())
		unitInfo = PyInfo.UnitInfo(pUnit.getUnitType())		
		pPlayer = gc.getPlayer(pUnit.getOwner())				
				
# ZE: Russland 2/2 Start -----------------------------------------------------------------------------------------------
		# if pPlot.getOwner() != -1:
			# ppPlayer = gc.getPlayer(pPlot.getOwner())
			# if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
				# iTechZER = gc.getInfoTypeForString("TECH_RUSSIA")
				# if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZER) and gc.getTeam(ppPlayer.getTeam()).isAtWar(pPlayer.getTeam()) and pUnit.getDomainType() == DomainTypes.DOMAIN_LAND and pUnit.baseCombatStr() > 0 and pPlayer != ppPlayer:
					# # pUnit.setImmobileTimer(1)
					# if pUnit.getDamage() < 13:
						# pUnit.changeDamage(3, false)
					# elif pUnit.getDamage() < 14:
						# pUnit.changeDamage(2, false)
					# elif pUnit.getDamage() < 15:
						# pUnit.changeDamage(1, false)
# ZE: Russland 2/2 End -----------------------------------------------------------------------------------------------
# Aliens Always Raze Cities Start -----------------------------------------------------------------------------------------------
		if pPlayer.isBarbarian():
			if pPlot.isCity():
				pAlienCity = pPlot.getPlotCity()
				if pUnit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_ALIEN' ):
					# 6.4 D - Bevlkerung wird in Trooper umgewandelt
					bPlayer = gc.getPlayer(gc.getBARBARIAN_PLAYER())
					iTroopers = max(1, (pAlienCity.getPopulation() / 4))
					for i in xrange (iTroopers):
						pNewUnit = bPlayer.initUnit( gc.getInfoTypeForString( 'UNIT_TROOPER' ), pPlot.getX(), pPlot.getY(), UnitAITypes.UNITAI_PARADROP, DirectionTypes.NO_DIRECTION )
					szTitle = CyTranslator().getText("TXT_KEY_PROJECT_SETI_ALIEN_CITY_RAZE", (pAlienCity.getName(),))
					CyInterface().addImmediateMessage( szTitle , None)
					pAlienCity.kill()
# Aliens Always Raze Cities End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_MOVEMENT):
			return
		if player and unitInfo:
			CvUtil.pyPrint('Player %d Civilization %s unit %s is moving to %d, %d' 
				%(player.getID(), player.getCivilizationName(), unitInfo.getDescription(), 
				pUnit.getX(), pUnit.getY()))

	def onUnitSetXY(self, argsList):
		'units xy coords set manually'
		pPlot,pUnit = argsList
		player = PyPlayer(pUnit.getOwner())
		unitInfo = PyInfo.UnitInfo(pUnit.getUnitType())
		if (not self.__LOG_MOVEMENT):
			return
		
	def onUnitCreated(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Unit Completed'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		iPlayer = unit.getOwner()

		iUnitType = unit.getUnitType()
		pPlayer = gc.getPlayer(iPlayer)
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)

# Cybah: BASE fr 6.4 D - Schildgeneration START -----------------------------------------------------------------------------------------------
		if (pTeam.isHasTech(gc.getInfoTypeForString("TECH_SHIELDING")) and (unit.baseCombatStr() > 0) and (unit.getDomainType() == DomainTypes.DOMAIN_LAND or unit.getDomainType() == DomainTypes.DOMAIN_SEA)):
			unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_DEFLECTION"),True)
# Cybah: BASE fr 6.4 D - Schildgeneration END -----------------------------------------------------------------------------------------------
		
# Cybah: BASE fr 6.4 A - Aggressive Trait - Wehrhafte Siedler und Bautrupps START (siehe auch CvGameTextMgr.cpp) // Idee verworfen, zu schwach? Passt besser zu Stz? KI?
		# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_AGGRESSIVE")):	
			# # if iUnitType == gc.getInfoTypeForString("UNIT_SETTLER"):
				# # unit.setBaseCombatStr(2)
			# # if iUnitType == gc.getInfoTypeForString("UNIT_WORKER") or iUnitType == gc.getInfoTypeForString("UNIT_INDIAN_FAST_WORKER") or iUnitType == gc.getInfoTypeForString("UNIT_MALINESE_WORKER"):
				# # unit.setBaseCombatStr(2)
			# iUnitClassType = unit.getUnitClassType()
			# if iUnitClassType == gc.getInfoTypeForString("UNITCLASS_SETTLER"):
				# unit.setBaseCombatStr(3)
			# elif iUnitClassType == gc.getInfoTypeForString("UNITCLASS_WORKER"):
				# unit.setBaseCombatStr(3)
# Cybah: BASE fr 6.4 A - Aggressive Trait - Wehrhafte Siedler und Bautrupps END
		
# Cybah: BASE fr 6.1 E - Easter Eggs START
		# Cybah: BASE fr 6.3 C - Nur noch bei aktivierten Zufallsereignissen
		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_EVENTS):
			if unit.getNameKey() == "Cybah":
				unit.setBaseCombatStr(8)
				unit.setBaseMoves(2)
			if unit.getNameKey() == "Rucivfan":
				unit.setBaseCombatStr(10)
			if unit.getNameKey() == "BadMoose":
				unit.setBaseCombatStr(4)
			if unit.getNameKey() == "HeyI":
				unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_HEROIC_STRENGTH1"), true)
			# 6.4 A
			if unit.getNameKey() == "Vanguard":
				unit.setBaseCombatStr(6)
				unit.setBaseMoves(3)
			# 6.4 C (siehe auch CvUnit.cpp)
			if unit.getNameKey() == "Sauron":
				unit.setBaseCombatStr(4)
				unit.setBaseMoves(3)
				# Kann nicht angreifen
				unit.setMaxAttackCount(0)
# Cybah: BASE fr 6.1 E - Easter Eggs END

# Cybah: BASE fr 6.3 C - ZE: Rom START
		if unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_SIEGE' ) and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ROME")):
			unit.setBaseMoves((unit.baseMoves() + 1))
# Cybah: BASE fr 6.3 C - ZE: Rom End

# Cybah: BASE fr 6.1 F - Keltischer Stammesfrst START
		if iUnitType == gc.getInfoTypeForString("UNIT_CELTIC_FANATIC"):
			pPlot = gc.getMap().plot( unit.getX(), unit.getY() )
			if pPlot.isCity():
				pCity = pPlot.getPlotCity()
				if pCity.getOwner() == unit.getOwner() and pCity.hasBonus(gc.getInfoTypeForString("BONUS_IRON")):
					unit.setBaseCombatStr(unit.baseCombatStr() + 1)
# Cybah: BASE fr 6.1 F - Keltischer Stammesfrst END
# Cybah: BASE fr 6.3 C - Brasilianischer Bandeirante 1/2 START (nur Idee)
		# if iUnitType == gc.getInfoTypeForString("UNIT_BRAZIL_BANDEIRANTE"):
			# pPlot = gc.getMap().plot( unit.getX(), unit.getY() )
			# if pPlot.isCity():
				# pCity = pPlot.getPlotCity()
				# if pCity.getOwner() == unit.getOwner() and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MILITARY_TRADITION")):
					# unit.setBaseCombatStr(12)
# Cybah: BASE fr 6.3 C - Brasilianischer Bandeirante 1/2 END
		
		# test - funktioniert mit initUnit!
		# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(unit.getUnitType(),unit.getUnitType(),)),'',0,'',-1,-1,-1,false,false)

# Charismatisch Start (Rest vom Bewegungsbonus ist im SDK) -----------------------------------------------------------------------------------------------
#		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CHARISMATIC")) and unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_WORKER' ): 
#			unit.changeTempFlatMoves(1)
# Charismatisch End (Rest vom Bewegungsbonus ist im SDK) -----------------------------------------------------------------------------------------------
# Spieloption Keine Piraten START -----------------------------------------------------------------------------------------------
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_PIRATES) and pPlayer.isBarbarian() and unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE")):
			unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_PIRATE"),False)
# Spieloption Keine Piraten END	-----------------------------------------------------------------------------------------------
# ZE: England Start DEAKTIVIERT -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND") and pTeam.isHasTech(gc.getInfoTypeForString("TECH_ENGLAND")):
			# # (Rest vom Bewegungsbonus ist im SDK)
			# if unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_NAVAL' ):
				# unit.changeTempFlatMoves(2)
			# # Kommando fr groe Hndler
			# if iUnitType == gc.getInfoTypeForString("UNIT_MERCHANT"):
				# unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_COMMANDO"),True)
# ZE: England End  -----------------------------------------------------------------------------------------------
# Siedler Start -----------------------------------------------------------------------------------------------
		if iUnitType == gc.getInfoTypeForString("UNIT_SETTLER") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
			if gc.getGame().getGameTurnYear() != gc.getDefineINT("START_YEAR") or not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_STARTING_TECHS):
				unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MOBILITY"),True)
# Siedler End -----------------------------------------------------------------------------------------------
# ZE: Amerika Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA") and unit.getDomainType() == DomainTypes.DOMAIN_LAND: 
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_AMERICA")):
				unit.changeVisibilityRange(1)
# ZE: Amerika End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - Listig Trait START -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CUNNING")) and unit.getDomainType() == DomainTypes.DOMAIN_LAND:
			unit.changeVisibilityRange(1)
# Cybah: BASE fr 6.3 C - Listig Trait END -----------------------------------------------------------------------------------------------
# ZE: Portugal Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL") and unit.getDomainType() == DomainTypes.DOMAIN_SEA: 
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_PORTUGAL")):
				unit.changeVisibilityRange(2)
# ZE: Portugal End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 - ZE: Rom Start (IDEE verworfen) -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME") and (unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_MELEE' ) or unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_GUN' )): 
			# if pTeam.isHasTech(gc.getInfoTypeForString("TECH_ROME")) and not iUnitType == gc.getInfoTypeForString("UNIT_GLADIATOR"):
				# iChance = CyGame().getSorenRandNum(100, "Royal Guard Promotion Chance")
				# # 2% Chance (0 oder 1)
				# if iChance < 2:
					# unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_ROYAL_GUARD"),True)
# Cybah: BASE fr 6.3 - ZE: Rom End -----------------------------------------------------------------------------------------------
# ZE: Nordreich 1/2 Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"): 
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_VIKING")):
				if unit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_VIKING")) and not unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_VIKING")):
					unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_VIKING"),True)
				# if unit.getUnitCombatType() == gc.getInfoTypeForString( 'UNITCOMBAT_SIEGE' ) and unit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_AMPHIBIOUS")) and not unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_AMPHIBIOUS")):
					# unit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_AMPHIBIOUS"),True)
# ZE: Nordreich 1/2 End -----------------------------------------------------------------------------------------------
# KI: Groer Staatsmann Start -----------------------------------------------------------------------------------------------
		# rucivfan_ai_auto_play raap[
		#if not pPlayer.isHuman() and iUnitType == gc.getInfoTypeForString("UNIT_GREAT_STATESMAN"):
		if not pPlayer.isHumanActive() and iUnitType == gc.getInfoTypeForString("UNIT_GREAT_STATESMAN"):
		# ]rucivfan_ai_auto_play raap
			iOwner = unit.getOwner()
			iUnitID = unit.getID()
			pPlot = gc.getMap().plot( unit.getX(), unit.getY() )

			# Schalter
			bDone = False

			# Aktionen im Krieg haben Vorrang	
			if pTeam.getAtWarCount(true) > 0:

				l_Victims = []
				iOtherTeamPower = 0
				iOwnPower = pPlayer.getPower()
				iOwnTeamPower = iOwnPower
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					iTeamX = pPlayerX.getTeam()
					if pPlayerX.isAlive() and pTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID():
						l_Victims.append(pPlayerX)
						iOtherTeamPower += pPlayerX.getPower()

					elif pPlayerX.isAlive() and iTeamX == iTeam and pPlayerX.getID() != pPlayer.getID():
						iOwnTeamPower += pPlayerX.getPower()

				# Gibt es kriegerische Aktionen, die ausgefhrt werden knnen?
				if len(l_Victims) >= 1:

					# Deaktiviert
					# # Aufstndische untersttzen hat Vorrang
					# l_Victims2 = []
					# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
						# pPlayerX = gc.getPlayer(iPlayerX)
						# iTeamX = pPlayerX.getTeam()
						# if pPlayerX.isAlive() and pTeam.isAtWar(iTeamX) and pPlayerX.getID() != pPlayer.getID() and not gc.getGame().isPbem() and not gc.getGame().isNetworkMultiPlayer() and not gc.getGame().isGameMultiPlayer() and not gc.getGame().isPitboss():
							# iRebels = 0
							# pCity, iter = pPlayerX.firstCity(false)
							# while(pCity):
								# if not pCity.isNone() and pCity.getOwner() == pPlayerX.getID() and ((pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()) - pCity.happyLevel()) > 0:
									# iRebels += min((pCity.getPopulation() - 1), ((pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()) - pCity.happyLevel()))
								# pCity, iter = pPlayerX.nextCity(iter, false)

							# # Gbe es auch genug Rebellen?
							# if iRebels >= 4 and iRebels >= pPlayerX.getNumCities() and not pPlayerX in l_Victims2 and not pPlayerX.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_GREAT_WALL")) > 0:
								# l_Victims2.append(pPlayerX)

					# # Gibt es Opfer mit genug Rebellen und haben die Gegner zusammen mehr Power?
					# if bDone == False and len(l_Victims2) >= 1 and (10 * iOtherTeamPower / iOwnTeamPower) >= 11:
						# CyMessageControl().sendModNetMessage( 9000, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
						# bDone = True
						# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9000,iRebels,)),'',0,'',-1,-1,-1,false,false)

					# Hat die KI viel Gold und die Gegner sind NICHT extrem berlegen (dann ist Frieden sinnvoller)? -> Sldner anheuern
					if bDone == False and pPlayer.getCurrentEra() > 0 and pTeam.isHasTech(gc.getInfoTypeForString("TECH_CURRENCY")) and pPlayer.getGold() >= (pPlayer.getCurrentEra() * pPlayer.getCurrentEra() * 200) and not (10 * iOtherTeamPower / iOwnTeamPower) >= 15:

						pBestXPCity = pPlayer.getCapitalCity()
						iBestXP = 0
						pMaybeBestXPCity, iter = pPlayer.firstCity(false)
						while(pMaybeBestXPCity):
							iCityOwner = pMaybeBestXPCity.getOwner() 
							if not pMaybeBestXPCity.isNone() and iCityOwner == pPlayer.getID():
								iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
# ZE: Zulu 2/2 Start -----------------------------------------------------------------------------------------------
								# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pPlayer.getID() == pMaybeBestXPCity.getOriginalOwner():
									# iXP += 5
# ZE: Zulu 2/2 End -----------------------------------------------------------------------------------------------
								if iBestXP < iXP: 
									iBestXP = iXP
									pBestXPCity = pMaybeBestXPCity
							pMaybeBestXPCity, iter = pPlayer.nextCity(iter, false)

						if pBestXPCity != -1 and pPlayer.getNumCities() > 1:
							
							# rucivfan_conscript_extended rce[
							#iConscriptUnit = pBestXPCity.getConscriptUnit()
							iConscriptUnit = pBestXPCity.getConscriptUnit(true)	# true fr keine reinen Verteidigungseinheiten
							# ]rucivfan_conscript_extended rce
							
							iTheSpeed = CyGame().getGameSpeedType()
							TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
							iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)

							# - Spieloption erhhte Einheitenproduktionskosten -
							if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
								if gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()) > 0:
									iEra = gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()).getEra()
								else:	
									iEra = 0
								for k in xrange(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")):
									iPrereqX = gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)
									if iPrereqX >= 0:
										iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)).getEra())
								if iEra > 5:
									iEra = 5
								iConscriptUnitCost *= 100 + iEra * 10
								iConscriptUnitCost /= 100

							# "NEW_HURRY_MODIFIER"
							# iConscriptUnitCost *= 3
							# iConscriptUnitCost /= 2

							# Gold per Production
							iConscriptUnitCost *= 3

							# Gold fr XP - 2% pro 1 XP
							# iConscriptUnitCostTotal = (iConscriptUnitCost * (100 + (iBestXP * 2)))
							# iConscriptUnitCostTotal /= 100
							iConscriptUnitCostTotal = iConscriptUnitCost

							# Nachtrgliche BASE Modifikatoren
							# - Endmodifikator zum schnellen Anpassen: 33% billiger -
							# iConscriptUnitCostTotal *= 2
							# iConscriptUnitCostTotal /= 3

							# Gbe es mindestens 7 Sldner?
							# 6.3 B - auf 10 beschrnkt
							iMercs = min(10,(pPlayer.getGold() / iConscriptUnitCostTotal))
							if iMercs > 6:
								CyMessageControl().sendModNetMessage( 9005, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
								bDone = True
								CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9005,iMercs,)),'',0,'',-1,-1,-1,false,false)

					# Haben die Kriegsgegner zusammen mehr Power und KI ist kein Vasall? -> Frieden stiften
					# Alter Code
					# if bDone == False and (10 * iOtherTeamPower / iOwnTeamPower) >= 13 and (10 * iOtherTeamPower / iOwnTeamPower) <= 20 and not pTeam.isAVassal():
						# CyMessageControl().sendModNetMessage( 9002, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
						# bDone = True
						# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9002,unit.getUnitType(),)),'',0,'',-1,-1,-1,false,false)
					
					if bDone == False and not pTeam.isAVassal() and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ALWAYS_WAR) and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_REAL_ALWAYS_WAR):
						iPossiblePeaceTeams = 0
						iTotalEnemyPower = 0
						for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
							pTeamX = gc.getTeam(iTeamX)
							if pTeamX.isAlive() and pTeam.isAtWar(iTeamX):
								iTotalEnemyPower += pTeamX.getPower(True)
								if pTeamX.getPower(True) < (pTeam.getPower(True) * 2):
									iPossiblePeaceTeams += 1
								
						if iPossiblePeaceTeams > 0 and iTotalEnemyPower > pTeam.getPower(True):
							CyMessageControl().sendModNetMessage( 9002, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							bDone = True
							CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9002,unit.getUnitType(),)),'',0,'',-1,-1,-1,false,false)
					
					# MOBILISIEREN IST DEAKTIVIERT
					# # Ist die eigene Power unter Durchschnitt? -> Mobilisieren
					# if bDone == False and ((10 * iOtherTeamPower / len(l_Victims)) / iOwnPower) >= 11:
						# iCanDraftCities = 0
						# pCity, iter = pPlayer.firstCity(false)
						# while(pCity):
							# if not pCity.isNone() and pCity.getOwner() == pPlayer.getID():

								# # rucivfan_conscript_extended rce[
								# #if pCity.getPopulation() >= (pCity.getConscriptPopulation() + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) and pCity.calculateTeamCulturePercent(iTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():

								# # Hinweis: (pCity.getConscriptPopulation(iConscriptUnit, true) + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) ist gleich pCity.conscriptMinCityPopulation(iConscriptUnit, true)!
								# if pCity.getPopulation() >= pCity.conscriptMinCityPopulation(UnitTypes.NO_UNIT, true) and pCity.calculateTeamCulturePercent(iTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():
								# # ]rucivfan_conscript_extended rce
									# iCanDraftCities += 1
							# pCity, iter = pPlayer.nextCity(iter, false)

						# # Gbe es mindestens 4 Einheiten und kann mindestens die Hlfte der Stdte rekrutieren?
						# if iCanDraftCities >= max(4, (pPlayer.getNumCities() / 2)):
							# CyMessageControl().sendModNetMessage( 9003, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							# bDone = True
							# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9003,iCanDraftCities,)),'',0,'',-1,-1,-1,false,false)

					# Gibt es viele Verwundete oder viele Einheiten, denen 1 XP fehlt? -> Rede an die Nation
					if bDone == False:
						iTotalUnits = 0
						iHealUnits = 0
						iXPUnits = 0
						(loopUnit, iter) = pPlayer.firstUnit(False)
						while(loopUnit):
							if loopUnit.getUnitCombatType() > -1 and (loopUnit.airBaseCombatStr() > 0 or loopUnit.baseCombatStr() > 0):
								iTotalUnits += 1
								
								# Deaktiviert
								## Verwundete Zhlen
								# if not loopUnit.getDamage() == 0:
									# iHealUnits += 1
								# else:
								# Zum Aktivieren bei folgenden Zeilen ein Tab einfgen
								# Sonstige Einheiten mit nur 1 fehlender Erfahrung zhlen
								iXPNeeded = ((loopUnit.getLevel() * loopUnit.getLevel()) + 1)
								iModifier = gc.getPlayer(iOwner).getLevelExperienceModifier()
								if (0 != iModifier):
									iXPNeeded += (iXPNeeded * iModifier + 99) / 100   # ROUND UP
								iXPLeft = (iXPNeeded - loopUnit.getExperience())
								if iXPLeft == 1:
									iXPUnits += 1
							(loopUnit, iter) = pPlayer.nextUnit(iter, False)

						# Deaktiviert
						# # Sind mindestens 60 Militreinheiten vorhanden und mindestens 15% aller Militreinheiten verletzt?
						# if bDone == False and iTotalUnits >= 60 and (100 * iHealUnits / iTotalUnits) >= 15:
							# CyMessageControl().sendModNetMessage( 9004, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							# bDone = True
							# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9004,iHealUnits,)),'',0,'',-1,-1,-1,false,false)

						# Oder sind mindestens 40 Militreinheiten vorhanden und mindestens 25% aller Militreinheiten nur 1 XP von der nchsten Stufe entfernt?
						if bDone == False and iTotalUnits >= 40 and (100 * iXPUnits / iTotalUnits) >= 25:
							CyMessageControl().sendModNetMessage( 9004, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							bDone = True
							CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9004,iXPUnits,)),'',0,'',-1,-1,-1,false,false)

						# Deaktiviert
						# # Oder sind mindestens 50 Militreinheiten vorhanden und mindestens 20% aller Militreinheiten betroffen?
						# if bDone == False and iTotalUnits >= 50 and (100 * (iXPUnits + iHealUnits) / (iTotalUnits)) >= 20:
							# CyMessageControl().sendModNetMessage( 9004, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							# bDone = True
							# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9004,(iXPUnits + iHealUnits),)),'',0,'',-1,-1,-1,false,false)

			# Aktionen im Frieden und sonstiges
			if pTeam.getAtWarCount(true) < 1 or bDone == False:
				pUnitOwnerTeam = pTeam

				# Entwicklungshilfe hat Vorrang
				iAidTechResearch = 0
				l_AidTechs = []
				for iTechX in xrange(gc.getNumTechInfos()):
					bTechXKnownTeam = False
					iTechXCount = 0
					if pUnitOwnerTeam.isHasTech(iTechX) or not gc.getTechInfo(iTechX).isTrade(): continue
					for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
						pTeamX = gc.getTeam(iTeamX)
						if pTeamX.isAlive():
							if pTeamX.isHasTech(iTechX):
								iTechXCount += 1
								if pUnitOwnerTeam.isHasMet(iTeamX):
									bTechXKnownTeam = True
					# Hlfte aller Spieler muss die Tech haben
					if bTechXKnownTeam == True and iTechXCount >= ((gc.getGame().countCivTeamsAlive() + 1) / 2):
						# Tech zur Liste der mglichen Techs hinzufgen
						l_AidTechs.append(iTechX)

				if len(l_AidTechs) > 3:
					for iTech in xrange(len(l_AidTechs)):
						# 33% der verbleibenden Kolben
						iTechKolben = (pUnitOwnerTeam.getResearchLeft(l_AidTechs[iTech]) / 3)
						# Kolben fr Anzeige aufsummieren
						iAidTechResearch += iTechKolben		
								
				# Nutzen der Welthandelsmission prfen
				# 250 ab Klassik
				iBaseGold = 250
				# Mittelalter
				if pPlayer.getCurrentEra() > 1: iBaseGold += 250
				# Renaissance
				if pPlayer.getCurrentEra() > 2: iBaseGold += 500
				# Industriezeitalter
				if pPlayer.getCurrentEra() > 3: iBaseGold += 1000
				# Moderne
				if pPlayer.getCurrentEra() > 4: iBaseGold += 2000
				# Zukunft
				if pPlayer.getCurrentEra() > 5: iBaseGold += 4000
				estiEnd = CyGame().getEstimateEndTurn()
				if estiEnd >= 1000:
					iBaseGold *= 2
				elif estiEnd >= 700:
					iBaseGold *= 7
					iBaseGold /= 5
				elif estiEnd >= 500:
					iBaseGold *= 1
				elif estiEnd >= 300:
					iBaseGold *= 3
					iBaseGold /= 5

				# Entwicklungshilfe ausfhren
				if bDone == False and len(l_AidTechs) > 3 and ((iAidTechResearch * 2) > (iBaseGold * 3)):
					CyMessageControl().sendModNetMessage( 9001, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
					bDone = True
					CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9001,iAidTechResearch,)),'',0,'',-1,-1,-1,false,false)

				# Ist ein Krieg geplant -> Sldner anheuern
				if bDone == False and pTeam.getAnyWarPlanCount(True) > 0 and pTeam.isHasTech(gc.getInfoTypeForString("TECH_CURRENCY")):

					pBestXPCity = pPlayer.getCapitalCity()
					iBestXP = 0
					pMaybeBestXPCity, iter = pPlayer.firstCity(false)
					while(pMaybeBestXPCity):
						iCityOwner = pMaybeBestXPCity.getOwner() 
						if not pMaybeBestXPCity.isNone() and iCityOwner == pPlayer.getID():
							iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
# ZE: Zulu 2/2 Start -----------------------------------------------------------------------------------------------
							# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pPlayer.getID() == pMaybeBestXPCity.getOriginalOwner():
								# iXP += 5
# ZE: Zulu 2/2 End -----------------------------------------------------------------------------------------------
							if iBestXP < iXP: 
								iBestXP = iXP
								pBestXPCity = pMaybeBestXPCity
						pMaybeBestXPCity, iter = pPlayer.nextCity(iter, false)

					if pBestXPCity != -1 and pPlayer.getNumCities() > 1:

						# rucivfan_conscript_extended rce[
						#iConscriptUnit = pBestXPCity.getConscriptUnit()
						iConscriptUnit = pBestXPCity.getConscriptUnit(true)	# true fr keine reinen Verteidigungseinheiten
						# ]rucivfan_conscript_extended rce

						iTheSpeed = CyGame().getGameSpeedType()
						TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
						iConscriptUnitCost = ((gc.getUnitInfo(iConscriptUnit).getProductionCost() * TheSpeed.getTrainPercent()) / 100)

						# - Spieloption erhhte Einheitenproduktionskosten -
						if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_HIGHER_UNIT_PRODUCTION_COST):
							if gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()) > 0:
								iEra = gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTech()).getEra()
							else:	
								iEra = 0
							for k in xrange(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")):
								iPrereqX = gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)
								if iPrereqX >= 0:
									iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iConscriptUnit).getPrereqAndTechs(k)).getEra())
							if iEra > 5:
								iEra = 5
							iConscriptUnitCost *= 100 + iEra * 10
							iConscriptUnitCost /= 100

						# "NEW_HURRY_MODIFIER"
						# iConscriptUnitCost *= 3
						# iConscriptUnitCost /= 2

						# Gold per Production
						iConscriptUnitCost *= 3

						# Gold fr XP - 2% pro 1 XP
						# iConscriptUnitCostTotal = (iConscriptUnitCost * (100 + (iBestXP * 2)))
						# iConscriptUnitCostTotal /= 100
						iConscriptUnitCostTotal = iConscriptUnitCost
						
						# Nachtrgliche BASE Modifikatoren
						# - Im Frieden 25% Rabatt -
						if not pTeam.getAtWarCount(True) > 0:
							iConscriptUnitCostTotal *= 3
							iConscriptUnitCostTotal /= 4

						# - Endmodifikator zum schnellen Anpassen: 33% billiger -
						# iConscriptUnitCostTotal *= 2
						# iConscriptUnitCostTotal /= 3

						# Gbe es mindestens 9 Sldner?
						# 6.3 B - auf 10 beschrnkt
						iMercs = min(10,(pPlayer.getGold() / iConscriptUnitCostTotal))
						if iMercs > 8:
							CyMessageControl().sendModNetMessage( 9005, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
							bDone = True
							CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9005,iMercs,)),'',0,'',-1,-1,-1,false,false)

				# MOBILISIEREN IST DEAKTIVIERT
				# # Ist Krieg geplant und es gibt nicht gengend Sldner -> Mobilisieren
				# if bDone == False and pTeam.getAnyWarPlanCount(True) > 0:
					# iCanDraftCities = 0
					# pCity, iter = pPlayer.firstCity(false)
					# while(pCity):
						# if not pCity.isNone() and pCity.getOwner() == pPlayer.getID():
								
							# # rucivfan_conscript_extended rce[
							# #if pCity.getPopulation() >= (pCity.getConscriptPopulation() + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) and pCity.calculateTeamCulturePercent(iTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():

							# # Hinweis: (pCity.getConscriptPopulation(iConscriptUnit, true) + gc.getDefineINT("CONSCRIPT_MIN_CITY_POPULATION")) ist gleich pCity.conscriptMinCityPopulation(iConscriptUnit, true)!
							# if pCity.getPopulation() >= pCity.conscriptMinCityPopulation(UnitTypes.NO_UNIT, true) and pCity.calculateTeamCulturePercent(iTeam) >= gc.getDefineINT("CONSCRIPT_MIN_CULTURE_PERCENT") and not pCity.isDisorder() and not pCity.isDrafted():
							# # ]rucivfan_conscript_extended rce							
								# iCanDraftCities += 1
						# pCity, iter = pPlayer.nextCity(iter, false)

					# # Gbe es mindestens 4 Einheiten und kann mindestens die Hlfte der Stdte rekrutieren?
					# if iCanDraftCities >= max(4, (pPlayer.getNumCities() / 2)):
						# CyMessageControl().sendModNetMessage( 9003, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
						# bDone = True
						# CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9003,iCanDraftCities,)),'',0,'',-1,-1,-1,false,false)

				# Ist Krieg geplant und es gibt viele Einheiten, denen 1 XP fehlt? -> Rede an die Nation
				if bDone == False and pTeam.getAnyWarPlanCount(True) > 0:
					iTotalUnits = 0
					iHealUnits = 0
					iXPUnits = 0
					(loopUnit, iter) = pPlayer.firstUnit(False)
					while(loopUnit):
						if loopUnit.getUnitCombatType() > -1 and (loopUnit.airBaseCombatStr() > 0 or loopUnit.baseCombatStr() > 0):
							iTotalUnits += 1

							# # Verwundete Zhlen
							# if not loopUnit.getDamage() == 0:
								# iHealUnits += 1

							# Sonstige Einheiten mit nur 1 fehlender Erfahrung zhlen
							# else:
							iXPNeeded = ((loopUnit.getLevel() * loopUnit.getLevel()) + 1)
							iModifier = gc.getPlayer(iOwner).getLevelExperienceModifier()
							if (0 != iModifier):
								iXPNeeded += (iXPNeeded * iModifier + 99) / 100   # ROUND UP
							iXPLeft = (iXPNeeded - loopUnit.getExperience())
							if iXPLeft == 1:
								iXPUnits += 1

						(loopUnit, iter) = pPlayer.nextUnit(iter, False)

					# Sind mindestens 40 Militreinheiten vorhanden und mindestens 25% aller Militreinheiten nur 1 XP von der nchsten Stufe entfernt?
					if bDone == False and iTotalUnits >= 40 and (100 * iXPUnits / iTotalUnits) >= 25:
						CyMessageControl().sendModNetMessage( 9004, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
						bDone = True
						CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9004,iXPUnits,)),'',0,'',-1,-1,-1,false,false)

				# Ansonsten -> Welthandelsmission
				if bDone == False and gc.getGame().countCivPlayersAlive() > 1:
					CyMessageControl().sendModNetMessage( 9006, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
					bDone = True
		 			CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9006,unit.getUnitType(),)),'',0,'',-1,-1,-1,false,false)

				# Falls schon gewonnen und trotzdem weiter gespielt wird -> Rede an die Nation
				if bDone == False:
					CyMessageControl().sendModNetMessage( 9004, pPlot.getX(), pPlot.getY(), iOwner, iUnitID )
					bDone = True
					CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(9004,unit.getUnitType(),)),'',0,'',-1,-1,-1,false,false)

# KI: Groer Staatsmann End ----------------------------------------------------------------------------------------------

		if (not self.__LOG_UNITBUILD):
			return

	def onUnitBuilt(self, argsList):
		'Unit Completed'
		city = argsList[0]
		unit = argsList[1]
		player = PyPlayer(city.getOwner())

		pCity = argsList[0]
		pUnit = argsList[1]
		iPlayer = pUnit.getOwner()
		pPlayer = gc.getPlayer(pUnit.getOwner())
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		iUnitType = pUnit.getUnitType()
		
# Cybah: BASE fr 6.3 C - ZE: Mongolen START ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.4 A
# +4 Generalspunkte fr jeweils die erste ausgebildete offensive militrische Landeinheit jeden Typs
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MONGOL")):
				# # nur offensive Militreinheiten
				# if unit.baseCombatStr() > 0 and unit.getDomainType() == DomainTypes.DOMAIN_LAND and not unit.isOnlyDefensive():
					# if CyStatistics().getPlayerNumUnitsBuilt(iPlayer, iUnitType) == 0:
						# pPlayer.changeCombatExperience(4)
# Cybah: BASE fr 6.3 C - ZE: Mongolen END -----------------------------------------------------------------------------------------------
# ZE: Hethiter Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.1 F
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES") and (unit.airBaseCombatStr() > 0 or unit.baseCombatStr() > 0):
			# iTechZEHITTI = gc.getInfoTypeForString("TECH_HITTITES")
			# if pTeam.isHasTech(iTechZEHITTI):			
				# if unit.baseCombatStr() > 0: iCulture = int(unit.baseCombatStr() * 100)
				# elif unit.airBaseCombatStr() > 0: iCulture = int(unit.airBaseCombatStr() * 100)									
				# estiEnd = CyGame().getEstimateEndTurn()				
				# if estiEnd >= 1000:
					# iCulture *= 2
				# elif estiEnd >= 700:
					# iCulture *= 3
					# iCulture /= 2
				# elif estiEnd >= 400:
					# iCulture *= 1
				# elif estiEnd >= 300:
					# iCulture *= 67
					# iCulture /= 100
				# elif estiEnd < 300:
					# iCulture *= 67
					# iCulture /= 100
				# iCulture = max(100, iCulture)					
				# pCity.changeCultureTimes100(iPlayer, iCulture, true)
# ZE: Hethiter End -----------------------------------------------------------------------------------------------		
# ZE: Spanien Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN") and unit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"):
#			iTechZESPA1 = gc.getInfoTypeForString("TECH_SPAIN")
#			iTechZESPA2 = gc.getInfoTypeForString("TECH_ASTRONOMY")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESPA1) and gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESPA2):
#				iX = pUnit.getX()
#				iY = pUnit.getY()
#				pZEUnit = pPlayer.initUnit( iUnitType, iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
#				pCity.addProductionExperience(pZEUnit, false)
# ZE: Spanien End -----------------------------------------------------------------------------------------------
# rucivfan: siehe SDK fr XP ZE
# ZE: Niederlande Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS") and not unit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MISC"):
#			iTechZEN = gc.getInfoTypeForString("TECH_NETHERLANDS")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEN) and pPlayer.isGoldenAge():
#				if (unit.airBaseCombatStr() > 0 or unit.baseCombatStr() > 0):
#					unit.changeExperience(3,-1,False,False,False)
#				elif unit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SPY"):
#					unit.changeExperience(3,-1,False,False,False)
# ZE: Niederlande End -----------------------------------------------------------------------------------------------
# ZE: Zulu 1/2 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and (unit.airBaseCombatStr() > 0 or unit.baseCombatStr() > 0) and not unit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MISC"):
#			iTechZEZ = gc.getInfoTypeForString("TECH_ZULU")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEZ) and not pPlayer.getID() == pCity.getOriginalOwner():
#				unit.changeExperience(5,-1,False,False,False)
# ZE: Zulu 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Heilig-Rom Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN") and (unit.airBaseCombatStr() > 0 or unit.baseCombatStr() > 0) and not unit.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_MISC"):
#			iTechZEHRR = gc.getInfoTypeForString("TECH_HOLY_ROMAN")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHRR):
#				if pPlayer.getCivics(gc.getInfoTypeForString("CIVICOPTION_LEGAL")) == gc.getInfoTypeForString("CIVIC_VASSALAGE"):
#					unit.changeExperience(1,-1,False,False,False)
#				if pPlayer.getCivics(gc.getInfoTypeForString("CIVICOPTION_RELIGION")) == gc.getInfoTypeForString("CIVIC_THEOCRACY") and pPlayer.getStateReligion() != -1:
#					if pCity.isHasReligion(pPlayer.getStateReligion()):
#						unit.changeExperience(1,-1,False,False,False)
# ZE: Heilig-Rom End -----------------------------------------------------------------------------------------------
# Militant Trait Start -----------------------------------------------------------------------------------------------
#		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_MILITANT")):
#			if unit.getUnitCombatType() != -1:	
#				unitClass = unit.getUnitClassType()
#				SameClass = []
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isEverAlive():
#						civUnit = gc.getCivilizationInfo(pPlayerX.getCivilizationType()).getCivilizationUnits(unitClass)
#						if civUnit not in SameClass:
#							SameClass.append(civUnit)
#				DeadExp = 0
#				for i in xrange(len(SameClass)):
#					DeadExp += CyStatistics().getPlayerNumUnitsKilled(iPlayer, SameClass[i])
#				unit.changeExperience(DeadExp /10,-1,False,False,False)
# Militant Trait End -----------------------------------------------------------------------------------------------
# Spieloption: Im Team geteilte Spezialeinheiten START -----------------------------------------------------------------------------------------------
		bTeamUU = False
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_SHARED_SPECIAL_UNITS):
			
			# Zivilisationen des Teams in die Liste tun
			l_TeamCivs = []
			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				pPlayerX = gc.getPlayer(iPlayerX)
				iTeamX = pPlayerX.getTeam()
				if iTeam == iTeamX and not pPlayer.getCivilizationType() == pPlayerX.getCivilizationType():
					l_TeamCivs.append(pPlayerX.getCivilizationType())
			
			l_UniqueUnits = []
			for iCiv in xrange(gc.getNumCivilizationInfos()):
				if iCiv in l_TeamCivs:
					for iUnit in xrange(gc.getNumUnitClassInfos()):
						iUniqueUnit = gc.getCivilizationInfo(iCiv).getCivilizationUnits(iUnit);
						iDefaultUnit = gc.getUnitClassInfo(iUnit).getDefaultUnitIndex();
						if (iDefaultUnit > -1 and iUniqueUnit > -1 and iDefaultUnit != iUniqueUnit):
							if iUnitType == iDefaultUnit:
								l_UniqueUnits.append(iUniqueUnit)
			if len(l_UniqueUnits) >= 1:
				bTeamUU = True
				chance = CyGame().getSorenRandNum(len(l_UniqueUnits), "Random for UniqueUnits")
				iX = pUnit.getX()
				iY = pUnit.getY()
				pNewUnit = pPlayer.initUnit( l_UniqueUnits[chance], iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
				pNewUnit.convert(pUnit)
				
				if gc.getUnitInfo(pNewUnit.getUnitType()) == gc.getInfoTypeForString("UNIT_CELTIC_FANATIC") and pCity.hasBonus(gc.getInfoTypeForString("BONUS_IRON")):
					pNewUnit.setBaseCombatStr(pNewUnit.baseCombatStr() + 1)
							
				pRallyPlot = pCity.getRallyPlot()
				if pRallyPlot and not pRallyPlot.isNone():
					pGroup = pNewUnit.getGroup()
					pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
# Creative Trait Start -----------------------------------------------------------------------------------------------
		# Veralteter Transformatorcode
		# if not gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_TRANSFORMATION")) or pCity.getPopulation() < 2 or pCity.isDisorder():
		# Folgende Zeile ist Teil der Spieloption
		if bTeamUU == False:
# Spieloption: Im Team geteilte Spezialeinheiten END -----------------------------------------------------------------------------------------------
			if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CREATIVE")):
				l_UniqueUnits = []
				for iCiv in xrange(gc.getNumCivilizationInfos()):
					for iUnit in xrange(gc.getNumUnitClassInfos()):
						iUniqueUnit = gc.getCivilizationInfo(iCiv).getCivilizationUnits(iUnit);
						iDefaultUnit = gc.getUnitClassInfo(iUnit).getDefaultUnitIndex();
						if (iDefaultUnit > -1 and iUniqueUnit > -1 and iDefaultUnit != iUniqueUnit):
							if iUnitType == iDefaultUnit and not iUnitType == gc.getInfoTypeForString("UNIT_CARAVEL"):
							
# Cybah: BASE fr 6.2 D - Nur noch Einheiten, deren Tech- und Ressourcenbedingungen erfllt werden START -----------------------------------------------------------------------------------------------
								bCanTrain = True
								
								# Techs verfgbar?
								iPrereqTech = gc.getUnitInfo(iUniqueUnit).getPrereqAndTech()
								if iPrereqTech >= 0 and not pTeam.isHasTech(iPrereqTech): bCanTrain = False
								if (bCanTrain == True):
									for k in xrange(gc.getNUM_UNIT_AND_TECH_PREREQS()):
										iPrereqAndTech = gc.getUnitInfo(iUniqueUnit).getPrereqAndTechs(k)
										if iPrereqAndTech >= 0 and not pTeam.isHasTech(iPrereqAndTech): bCanTrain = False
										
								# Ressourcen verfgbar?
								if (bCanTrain == True):
									iPrereqAndBonus = gc.getUnitInfo(iUniqueUnit).getPrereqAndBonus()
									if iPrereqAndBonus >= 0 and not pCity.hasBonus(iPrereqAndBonus): bCanTrain = False									
								if (bCanTrain == True):
									iPrereqOrBonuses = 0
									iHasPrereqOrBonuses = 0
									for l in xrange(gc.getNUM_UNIT_PREREQ_OR_BONUSES()):
										iPrereqOrBonus = gc.getUnitInfo(iUniqueUnit).getPrereqOrBonuses(l)
										if iPrereqOrBonus >= 0:
											iPrereqOrBonuses += 1
											if pCity.hasBonus(iPrereqOrBonus):
												iHasPrereqOrBonuses += 1
									if iPrereqOrBonuses > 0 and iHasPrereqOrBonuses < 1: bCanTrain = False

								# l_UniqueUnits.append(iUniqueUnit)
								if (bCanTrain == True): l_UniqueUnits.append(iUniqueUnit)
# Cybah: BASE fr 6.2 D - Nur noch Einheiten, deren Tech- und Ressourcenbedingungen erfllt werden END -----------------------------------------------------------------------------------------------
								
				if len(l_UniqueUnits) >= 1:
					# 25% chance
					iForeignUUChance = self.getRandomNumber( 4 )

					# Zum Testen Raute entfernen
					# iForeignUUChance = 0

					if iForeignUUChance == 0:
						chance = CyGame().getSorenRandNum(len(l_UniqueUnits), "Random for UniqueUnits")
						iX = pUnit.getX()
						iY = pUnit.getY()
						pNewUnit = pPlayer.initUnit( l_UniqueUnits[chance], iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pNewUnit.convert(pUnit)
						
						if gc.getUnitInfo(pNewUnit.getUnitType()) == gc.getInfoTypeForString("UNIT_CELTIC_FANATIC") and pCity.hasBonus(gc.getInfoTypeForString("BONUS_IRON")):
							pNewUnit.setBaseCombatStr(pNewUnit.baseCombatStr() + 1)
						
						pRallyPlot = pCity.getRallyPlot()
						if pRallyPlot and not pRallyPlot.isNone():
							pGroup = pNewUnit.getGroup()
							pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
# Creative Trait End -----------------------------------------------------------------------------------------------
# # Transformation Start -----------------------------------------------------------------------------------------------
		# elif gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_TRANSFORMATION")) and pCity.getPopulation() > 2:
			# iTransformer = gc.getInfoTypeForString("BUILDING_TRANSFORMER")
			# iBonus1 = gc.getInfoTypeForString("BONUS_ALUMINUM")
			# iBonus2 = gc.getInfoTypeForString("BONUS_OIL")			
			# if pCity.getNumActiveBuilding(iTransformer) > 0 and pCity.getNumBonuses(iBonus1) > 0 and pCity.getNumBonuses(iBonus2) > 0:
				# iTransformerLab = gc.getInfoTypeForString("BUILDING_TRANSFORMER_LAB")
				# iTransformerCore = gc.getInfoTypeForString("BUILDING_TRANSFORMER_CORE")
				# iTransformation = self.getRandomNumber( 1000 )
# # Creative Trait Start -----------------------------------------------------------------------------------------------
				# if iTransformation < 250:
					# # 25% chance				
					# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CREATIVE")):
						# l_UniqueUnits = []
						# for iCiv in xrange(gc.getNumCivilizationInfos()):
							# for iUnit in xrange(gc.getNumUnitClassInfos()):
								# iUniqueUnit = gc.getCivilizationInfo(iCiv).getCivilizationUnits(iUnit);
								# iDefaultUnit = gc.getUnitClassInfo(iUnit).getDefaultUnitIndex();
								# if (iDefaultUnit > -1 and iUniqueUnit > -1 and iDefaultUnit != iUniqueUnit):
									# if iUnitType == iDefaultUnit:
										# l_UniqueUnits.append(iUniqueUnit)
						# if len(l_UniqueUnits) >= 1:
							# chance = CyGame().getSorenRandNum(len(l_UniqueUnits), "Random for UniqueUnits")
							# iX = pUnit.getX()
							# iY = pUnit.getY()
							# pNewUnit = pPlayer.initUnit( l_UniqueUnits[chance], iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
# # Creative Trait End -----------------------------------------------------------------------------------------------		
				# elif iTransformation < 450:
					# iX = pUnit.getX()
					# iY = pUnit.getY()
					# if gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_MAMMOTH_TANK"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_APU"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_APU"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SIEGE"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_DISRUPTER"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER"):
						# iTransformationUnit = self.getRandomNumber( 3 )
						# if iTransformationUnit == 0:
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAWK_THOPTER"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# elif iTransformationUnit == 1:
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_VULTURE"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# else:
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_ORCA"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
					# # elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANTIAIR"):
						# # pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HYDRA"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# # pNewUnit.convert(pUnit)
						# # pRallyPlot = pCity.getRallyPlot()
						# # if pRallyPlot and not pRallyPlot.isNone():
							# # pGroup = pNewUnit.getGroup()
							# # pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)						
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_AIR"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)					
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HEAVY_AIR"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)					
					# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_JETPLANE"):
						# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# pNewUnit.convert(pUnit)
						# pRallyPlot = pCity.getRallyPlot()
						# if pRallyPlot and not pRallyPlot.isNone():
							# pGroup = pNewUnit.getGroup()
							# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
				# elif iTransformation < 500:
					# if pCity.getNumActiveBuilding(iTransformerCore) > 0:
						# iX = pUnit.getX()
						# iY = pUnit.getY()
						# if gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_MAMMOTH_TANK"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_APU"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_APU"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SIEGE"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_DISRUPTER"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER"):
							# iTransformationUnit = self.getRandomNumber( 3 )
							# if iTransformationUnit == 0:
								# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAWK_THOPTER"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
								# pNewUnit.convert(pUnit)
								# pRallyPlot = pCity.getRallyPlot()
								# if pRallyPlot and not pRallyPlot.isNone():
									# pGroup = pNewUnit.getGroup()
									# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
							# elif iTransformationUnit == 1:
								# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_VULTURE"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
								# pNewUnit.convert(pUnit)
								# pRallyPlot = pCity.getRallyPlot()
								# if pRallyPlot and not pRallyPlot.isNone():
									# pGroup = pNewUnit.getGroup()
									# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
							# else:
								# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_ORCA"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
								# pNewUnit.convert(pUnit)
								# pRallyPlot = pCity.getRallyPlot()
								# if pRallyPlot and not pRallyPlot.isNone():
									# pGroup = pNewUnit.getGroup()
									# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)
						# # elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANTIAIR"):
							# # pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HYDRA"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# # pNewUnit.convert(pUnit)
							# # pRallyPlot = pCity.getRallyPlot()
							# # if pRallyPlot and not pRallyPlot.isNone():
								# # pGroup = pNewUnit.getGroup()
								# # pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)					
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_AIR"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)					
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HEAVY_AIR"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)					
						# elif gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_JETPLANE"):
							# pNewUnit = pPlayer.initUnit( gc.getInfoTypeForString("UNIT_HAMMERHEAD"), iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
							# pNewUnit.convert(pUnit)
							# pRallyPlot = pCity.getRallyPlot()
							# if pRallyPlot and not pRallyPlot.isNone():
								# pGroup = pNewUnit.getGroup()
								# pGroup.pushMission(MissionTypes.MISSION_MOVE_TO, pRallyPlot.getX(), pRallyPlot.getY(), 0, False, False, MissionAITypes.NO_MISSIONAI, pRallyPlot, pNewUnit)			
				# elif iTransformation < 525:
					# if gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SIEGE") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANTIAIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_AIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HEAVY_AIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_JETPLANE"):
						# pUnit.kill( 0, -1 )
						# pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRANSFORMER"),0)
						# pCity.changePopulation(-1)
						# pCity.changeExtraHappiness(-1)
						# pCity.changeExtraHealth(-1)
						# strMessage = CyTranslator().getText("TXT_KEY_TRANSFORMATION_FAILURE", (pCity.getName(), pPlayer.getName(), pPlayer.getName()))
						# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',ColorTypes(7),-1,-1, True, True)
				# elif iTransformation < 550:
					# if not pCity.getNumActiveBuilding(iTransformerLab) > 0:
						# if gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARMOR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRENCH") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_SIEGE") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HELICOPTER") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANTIAIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_AIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_HEAVY_AIR") or gc.getUnitInfo(pUnit.getUnitType()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_JETPLANE"):
							# pUnit.kill( 0, -1 )
							# pCity.setNumRealBuilding(gc.getInfoTypeForString("BUILDING_TRANSFORMER"),0)
							# pCity.changePopulation(-1)
							# pCity.changeExtraHappiness(-1)
							# pCity.changeExtraHealth(-1)
							# strMessage = CyTranslator().getText("TXT_KEY_TRANSFORMATION_FAILURE", (pCity.getName(), pPlayer.getName(), pPlayer.getName()))
							# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0,'',ColorTypes(7),-1,-1, True, True)
# # Transformation End -----------------------------------------------------------------------------------------------

		CvAdvisorUtils.unitBuiltFeats(city, unit)
		
		if (not self.__LOG_UNITBUILD):
			return
		CvUtil.pyPrint('%s was finished by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitKilled(self, argsList):
		'Unit Killed'
		unit, iAttacker = argsList
		player = PyPlayer(unit.getOwner())
		attacker = PyPlayer(iAttacker)

		iPlayer = unit.getOwner()
		pPlayer = gc.getPlayer(iPlayer)
		pPID = pPlayer.getID()
		ppPlayer = gc.getPlayer(iAttacker)
		iX = unit.getX()
		iY = unit.getY()
		pPlot = CyMap().plot(iX,iY)

# Terracotta Start -----------------------------------------------------------------------------------------------
		b_Terra = gc.getInfoTypeForString("BUILDING_TERRACOTTA_ARMY")
		obsoleteTech = gc.getBuildingInfo(b_Terra).getObsoleteTech()
		if obsoleteTech == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTech):
			if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_TERRACOTTA_ARMY")) > 0 and not ppPlayer.isBarbarian() and not pPlayer.isBarbarian():
				for iiX in xrange(iX-1, iX+2, 1):
					for iiY in xrange(iY-1, iY+2, 1):
						pPlot2 = CyMap().plot(iiX,iiY)
						if pPlot2.isCity():
							pCity = pPlot2.getPlotCity()
							pPID = pPlayer.getID()
							iExp = int(unit.getExperience())
							if iExp > 0: iCulture = iExp * 100
							else: iCulture = 100
							estiEnd = CyGame().getEstimateEndTurn()				
							if estiEnd >= 1000:
								iCulture *= 2
							elif estiEnd >= 700:
								iCulture *= 3
								iCulture /= 2
							elif estiEnd >= 400:
								iCulture *= 1
							elif estiEnd >= 300:
								iCulture *= 67
								iCulture /= 100
							elif estiEnd < 300:
								iCulture *= 67
								iCulture /= 100
							iCulture = max(100, iCulture)					
							pCity.changeCultureTimes100(pPID, iCulture, true)
# Terracotta End -----------------------------------------------------------------------------------------------
# ZE: Polynesien 1/2 Start -----------------------------------------------------------------------------------------------
		# if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"): 
			# iTechZEPOLY = gc.getInfoTypeForString("TECH_POLYNESIA")
			# if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEPOLY):

				# iUnitType = PyInfo.UnitInfo(unit.getUnitType())
				# if iUnitType.getDomainType() == DomainTypes.DOMAIN_LAND and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ANIMAL"):

					# if unit.baseCombatStr() > 1:
						# iPolyFood = (unit.baseCombatStr() /2)
						# for i in xrange(1):

							# # ---- Stadt mit der wenigsten Bevlkerung suchen und speichern ----
							# pPolyCity = ppPlayer.getCapitalCity()
							# iPopulation = pPolyCity.getPopulation()
							# ppCity, iter = ppPlayer.firstCity(false)
							# while(ppCity):  
								# ipCityOwner = ppCity.getOwner()  
								# if not ppCity.isNone() and ipCityOwner == ppPlayer.getID():
									# if iPopulation > ppCity.getPopulation():
										# iPopulation = ppCity.getPopulation()
										# pPolyCity = ppCity
								# ppCity, iter = ppPlayer.nextCity(iter, false)

							# pPolyCity.changeFood(iPolyFood)
# ZE: Polynesien 1/2 End -----------------------------------------------------------------------------------------------
# Populist Trait Start -----------------------------------------------------------------------------------------------

		iTraitPop = gc.getInfoTypeForString("TRAIT_POPULIST")
		if pPlayer.hasTrait(iTraitPop) and pPlayer.isAlive() and pPlayer.getNumCities() > 0 and not unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_IMMORTAL")):

			iUnitType = PyInfo.UnitInfo(unit.getUnitType())
			# if iUnitType.getDomainType() == DomainTypes.DOMAIN_LAND and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER") and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_TRANSFORMED") and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ALIEN"):
			if iUnitType.getDomainType() == DomainTypes.DOMAIN_LAND and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_WORKER") and not iUnitType.getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ALIEN"):

				# rucivfan_ai_auto_play raap[
				#if pPlayer.isHuman():
				if pPlayer.isHumanActive():
				# ]rucivfan_ai_auto_play raap				
					if unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")):
						for i in xrange(1):

							# ---- Stadt mit der hchsten Production Experience suchen und speichern ----
							pPopCity = pPlayer.getCapitalCity()
							iProductionExperience = pPopCity.getProductionExperience(unit.getUnitType())
							iNearestDistance = -1
							
							# Perfekte Spawn-Stadt suchen (erster Versuch)
							bCityFound = False

							# Cybah: BASE fr 6.2 D - folgende Zeilen sind obsolet
							# bSameArea = False
							# pNearestCity = gc.getMap().findCity(pPlot.getX(), pPlot.getY(), pPlayer.getID(), pPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
							# if pNearestCity and not pNearestCity.isNone():
								# pCityPlot = pNearestCity.plot()
								# if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pNearestCity.isOccupation():
									# iNearestDistance = plotDistance(iX, iY, pNearestCity.getX(), pNearestCity.getY())
									# pNearestPopCity = pNearestCity
									# bSameArea = True
									# bCityFound = True
									# # BugUtil.warn("Perfekte Stadt gefunden")
							
							if bCityFound == False:
								# BugUtil.warn("Stadtdurchlauf 1")
								pCity, iter = pPlayer.firstCity(false)
								while(pCity):  
									iCityOwner = pCity.getOwner()
									if not pCity.isNone() and iCityOwner == pPlayer.getID():
										# BugUtil.warn("Eine Stadt wird getestet")
										pCityPlot = pCity.plot()
										
										# Mit Kulturhoheit und ohne Revolte
										if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pCity.isOccupation():
										
											# Cybah: BASE fr 6.2 D - Neuer Code: 3-fach Malus fr anderen Kontinent
											iOtherAreaMod = 1
											if pCity.area().getID() != pPlot.area().getID(): iOtherAreaMod = 3 
											iPlotDistance = (plotDistance(iX, iY, pCity.getX(), pCity.getY()) * iOtherAreaMod)

											# Erfahrungsreichste Stadt speichern
											if iProductionExperience < pCity.getProductionExperience(unit.getUnitType()):
												iProductionExperience = pCity.getProductionExperience(unit.getUnitType())
												pPopCity = pCity
												# BugUtil.warn("XP Stadt gefunden")
											
											# Cybah: BASE fr 6.2 D - folgende Zeile ist obsolet, weil jetzt alle Kontinente durchgegangen und abgewogen werden
											#if pCity.area().getID() == pPlot.area().getID():
											
											if iNearestDistance == -1:
												# BugUtil.warn("Erste Stadt aus 1. Durchlauf")
												iNearestDistance = iPlotDistance
												pNearestPopCity = pCity
												# bSameArea = True
												bCityFound = True
											
											elif iNearestDistance > iPlotDistance:
												# BugUtil.warn("Neue Stadt aus 1. Durchlauf")
												iNearestDistance = iPlotDistance
												pNearestPopCity = pCity
												# bSameArea = True
												bCityFound = True
											
										# else: BugUtil.warn("Stadt hat nicht Kulturhoheit oder revoltiert")
									pCity, iter = pPlayer.nextCity(iter, false)
								
								# Cybah: BASE fr 6.2 D - folgender Code ist obsolet, weil obig jetzt alle Kontinente durchgegangen und abgewogen werden
								# # Auf anderem Kontinent suchen
								# if bSameArea == False:
									# # BugUtil.warn("auf anderem Kontinent suchen")

									# # Neuer Durchlauf	
									# pCity, iter = pPlayer.firstCity(false)
									# while(pCity):  
										# iCityOwner = pCity.getOwner()
										# if not pCity.isNone() and iCityOwner == pPlayer.getID():	
											# pCityPlot = pCity.plot()
											
											# # BugUtil.warn("Kultur berprfen der Nichtarea-Stdte")
											# # Mit Kulturhoheit und ohne Revolte
											# if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pCity.isOccupation():
												
												# if iNearestDistance == 99999999999999999:
													# # BugUtil.warn("Erste Stadt aus 2. Durchlauf")
													# iNearestDistance = plotDistance(iX, iY, pCity.getX(), pCity.getY())
													# pNearestPopCity = pCity
													# bCityFound = True
												
												# elif iNearestDistance > plotDistance(iX, iY, pCity.getX(), pCity.getY()):
													# # BugUtil.warn("Neue Stadt aus 2. Durchlauf")
													# iNearestDistance = plotDistance(iX, iY, pCity.getX(), pCity.getY())
													# pNearestPopCity = pCity
													# bCityFound = True
													
												# # else: BugUtil.warn("Stadt ist nher dran, Abbruch")
										# # else: BugUtil.warn("Stadtbesitzer ist ungleich Spieler ID")		
										# pCity, iter = pPlayer.nextCity(iter, false)
							
							# Fall: Keine Stadt (inklusive Hauptstadt) hat Kulturhoheit
							if bCityFound == False:
								pNearestPopCity = pPlayer.getCapitalCity()
								# BugUtil.warn("Keine Stadt gefunden also wirds die Hauptstadt")
							
							if pNearestPopCity:
								pNearestCity = pNearestPopCity
							
								# Einheit spawnen
								pPopUnit = pPlayer.initUnit(unit.getUnitType(), pNearestCity.getX(), pNearestCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
								
								# Fr eine Runde bewegungsunfhig
								pPopUnit.setImmobileTimer(1)
								
								# Nchste Stadt == Erfahrungsreichste Stadt
								if pPopCity == pNearestCity: pPopCity.addProductionExperience(pPopUnit, false)
								
								# Nchste Stadt != Erfahrungsreichste Stadt
								else:
									iProductionExperienceNearest = pNearestCity.getProductionExperience(unit.getUnitType())
									
									# Auswrfeln, aus welcher Stadt freie Befrderungen gewhlt werden
									iWelcheStadt = self.getRandomNumber( 2 )
									
									# Fall 1: Befrderungen aus erfahrungsreichster Stadt
							 		if iWelcheStadt == 0:
										pPopCity.addProductionExperience(pPopUnit, false)
										# XP aus anderer Stadt addieren, um spter die Hlfte wieder abzuziehen
										pPopUnit.changeExperience(iProductionExperienceNearest,-1,False,False,False)
									
									else:
										pNearestCity.addProductionExperience(pPopUnit, false)
										# XP aus anderer Stadt addieren, um spter die Hlfte wieder abzuziehen
										pPopUnit.changeExperience(iProductionExperience,-1,False,False,False)
										
									iXPTotal = (iProductionExperience + iProductionExperienceNearest)
									iXPAbzug = (iXPTotal / 2)
									pPopUnit.changeExperience(-iXPAbzug,-1,False,False,False)
									
									# Ungerade Zahl: -1 XP (abrunden)
									if iXPTotal %2 != 0: pPopUnit.changeExperience(-1,-1,False,False,False)
								
								# Textnachricht
								strMessage1 = CyTranslator().getText("TXT_KEY_TRAIT_POP_NEW_UNIT_PREPAID", (pPopUnit.getName(), pNearestCity.getName()))
								CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0, unit.getButton(), ColorTypes(8), pNearestCity.getX(), pNearestCity.getY(), True, True)

				# Cybah: BASE fr 6.2 C - KI bekommt jede Einheit nur noch 1x pro Runde ersetzt
				#else:
				elif unit.getImmobileTimer() < 1:
					if unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")) or unit.canAcquirePromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")):
						iTheSpeed = CyGame().getGameSpeedType()
						TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
						pHandicapInfo = gc.getHandicapInfo(gc.getGame().getHandicapType())
						iPopGold = pPlayer.getGold()
						
						# # iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * pHandicapInfo.getAIUnitCostPercent() / 100 / 100 / 2)
						# iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / 100 / 2)
						
						# Cybah: BASE fr 6.3 - jetzt 75% der Produktionskosten als Start -> 75, 80, 90, 105, 125
						iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 3 / 4 / 100)

						# berprfung der Spielerra
						if pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MEDIEVAL"):
							# Cybah: BASE fr 6.3 (siehe oben)
							iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 4 / 5 / 100)
							# iPopUnitCost *= 12
							# iPopUnitCost /= 10
						elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_RENAISSANCE"):
							# Cybah: BASE fr 6.3 (siehe oben)
							iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 9 / 10 / 100)
							# iPopUnitCost *= 16
							# iPopUnitCost /= 10
						elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_INDUSTRIAL"):
							# Cybah: BASE fr 6.3 (siehe oben)
							iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 21 / 20 / 100)
							# iPopUnitCost *= 22
							# iPopUnitCost /= 10
						elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MODERN"):
							# Cybah: BASE fr 6.3 (siehe oben)
							iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 5 / 4 / 100)
							# iPopUnitCost *= 3
						elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_FUTURE"):
							# Cybah: BASE fr 6.3 (siehe oben)
							iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() * 5 / 4 / 100)
							# iPopUnitCost *= 3
							
						# # Neue berprfung der Einheitenra	- zu ressourcenintensiv? (ersetzt durch Spielerra bei KI)
						# # if gc.getTechInfo(gc.getUnitInfo(iUnitType).getPrereqAndTech()) > 0:
							# # iEra = gc.getTechInfo(gc.getUnitInfo(iUnitType).getPrereqAndTech()).getEra()
						# # else:	
							# # iEra = 0
						# # for k in xrange(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")):
							# # iPrereqX = gc.getUnitInfo(iUnitType).getPrereqAndTechs(k)
							# # if iPrereqX >= 0:
								# # iEra = max(iEra, gc.getTechInfo(gc.getUnitInfo(iUnitType).getPrereqAndTechs(k)).getEra())
						# # if iEra > 5:
							# # iEra = 5

						if iPopGold >= (2 * iPopUnitCost):
							iPopUnitGold = (1 * iPopUnitCost)
							
							# 6.4 D - Gold nur noch abziehen wenn Einheit nicht schon vom Mensch befrdert gewesen
							# pPlayer.changeGold(-iPopUnitGold)
							if not unit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_POPULIST1")):
								pPlayer.changeGold(-iPopUnitGold)
							
							for i in xrange(1):

								# ---- Stadt mit der hchsten Production Experience suchen und speichern ----
								pPopCity = pPlayer.getCapitalCity()
								iProductionExperience = pPopCity.getProductionExperience(unit.getUnitType())
								iNearestDistance = -1
								
								# Perfekte Spawn-Stadt suchen (erster Versuch)
								bCityFound = False

								# Cybah: BASE fr 6.2 D - folgende Zeilen sind obsolet
								# bSameArea = False
								# pNearestCity = gc.getMap().findCity(pPlot.getX(), pPlot.getY(), pPlayer.getID(), pPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, CyCity())
								# if pNearestCity and not pNearestCity.isNone():
									# pCityPlot = pNearestCity.plot()
									# if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pNearestCity.isOccupation():
										# iNearestDistance = plotDistance(iX, iY, pNearestCity.getX(), pNearestCity.getY())
										# pNearestPopCity = pNearestCity
										# bSameArea = True
										# bCityFound = True
										# # BugUtil.warn("Perfekte Stadt gefunden")
								
								if bCityFound == False:
									# BugUtil.warn("Stadtdurchlauf 1")
									pCity, iter = pPlayer.firstCity(false)
									while(pCity):  
										iCityOwner = pCity.getOwner()
										if not pCity.isNone() and iCityOwner == pPlayer.getID():
											# BugUtil.warn("Eine Stadt wird getestet")
											pCityPlot = pCity.plot()
											
											# Mit Kulturhoheit und ohne Revolte
											if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pCity.isOccupation():
											
												# Cybah: BASE fr 6.2 D - Neuer Code: 3-fach Malus fr anderen Kontinent
												iOtherAreaMod = 1
												if pCity.area().getID() != pPlot.area().getID(): iOtherAreaMod = 3 
												iPlotDistance = (plotDistance(iX, iY, pCity.getX(), pCity.getY()) * iOtherAreaMod)

												# Erfahrungsreichste Stadt speichern
												if iProductionExperience < pCity.getProductionExperience(unit.getUnitType()):
													iProductionExperience = pCity.getProductionExperience(unit.getUnitType())
													pPopCity = pCity
													# BugUtil.warn("XP Stadt gefunden")
												
												# Cybah: BASE fr 6.2 D - folgende Zeile ist obsolet, weil jetzt alle Kontinente durchgegangen und abgewogen werden
												#if pCity.area().getID() == pPlot.area().getID():
												
												if iNearestDistance == -1:
													# BugUtil.warn("Erste Stadt aus 1. Durchlauf")
													iNearestDistance = iPlotDistance
													pNearestPopCity = pCity
													# bSameArea = True
													bCityFound = True
												
												elif iNearestDistance > iPlotDistance:
													# BugUtil.warn("Neue Stadt aus 1. Durchlauf")
													iNearestDistance = iPlotDistance
													pNearestPopCity = pCity
													# bSameArea = True
													bCityFound = True
												
											# else: BugUtil.warn("Stadt hat nicht Kulturhoheit oder revoltiert")
										pCity, iter = pPlayer.nextCity(iter, false)
									
									# Cybah: BASE fr 6.2 D - folgender Code ist obsolet, weil obig jetzt alle Kontinente durchgegangen und abgewogen werden
									# # Auf anderem Kontinent suchen
									# if bSameArea == False:
										# # BugUtil.warn("auf anderem Kontinent suchen")

										# # Neuer Durchlauf	
										# pCity, iter = pPlayer.firstCity(false)
										# while(pCity):  
											# iCityOwner = pCity.getOwner()
											# if not pCity.isNone() and iCityOwner == pPlayer.getID():	
												# pCityPlot = pCity.plot()
												
												# # BugUtil.warn("Kultur berprfen der Nichtarea-Stdte")
												# # Mit Kulturhoheit und ohne Revolte
												# if pCityPlot.findHighestCultureTeam() == pPlayer.getTeam() and not pCity.isOccupation():
													
													# if iNearestDistance == 99999999999999999:
														# # BugUtil.warn("Erste Stadt aus 2. Durchlauf")
														# iNearestDistance = plotDistance(iX, iY, pCity.getX(), pCity.getY())
														# pNearestPopCity = pCity
														# bCityFound = True
													
													# elif iNearestDistance > plotDistance(iX, iY, pCity.getX(), pCity.getY()):
														# # BugUtil.warn("Neue Stadt aus 2. Durchlauf")
														# iNearestDistance = plotDistance(iX, iY, pCity.getX(), pCity.getY())
														# pNearestPopCity = pCity
														# bCityFound = True
														
													# # else: BugUtil.warn("Stadt ist nher dran, Abbruch")
											# # else: BugUtil.warn("Stadtbesitzer ist ungleich Spieler ID")		
											# pCity, iter = pPlayer.nextCity(iter, false)
								
								# Fall: Keine Stadt (inklusive Hauptstadt) hat Kulturhoheit
								if bCityFound == False:
									pNearestPopCity = pPlayer.getCapitalCity()
									#BugUtil.warn("Keine Stadt gefunden also wirds die Hauptstadt")
								
								if pNearestPopCity:
									pNearestCity = pNearestPopCity
								
									# Einheit spawnen
									pPopUnit = pPlayer.initUnit(unit.getUnitType(), pNearestCity.getX(), pNearestCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
									
									# Fr eine Runde bewegungsunfhig
									pPopUnit.setImmobileTimer(1)
									
									# Nchste Stadt == Erfahrungsreichste Stadt
									if pPopCity == pNearestCity: pPopCity.addProductionExperience(pPopUnit, false)
									
									# Nchste Stadt != Erfahrungsreichste Stadt
									else:
										iProductionExperienceNearest = pNearestCity.getProductionExperience(unit.getUnitType())
										
										# Auswrfeln, aus welcher Stadt freie Befrderungen gewhlt werden
										iWelcheStadt = self.getRandomNumber( 2 )
										
										# Fall 1: Befrderungen aus erfahrungsreichster Stadt
										if iWelcheStadt == 0:
											pPopCity.addProductionExperience(pPopUnit, false)
											# XP aus anderer Stadt addieren, um spter die Hlfte wieder abzuziehen
											pPopUnit.changeExperience(iProductionExperienceNearest,-1,False,False,False)
										
										else:
											pNearestCity.addProductionExperience(pPopUnit, false)
											# XP aus anderer Stadt addieren, um spter die Hlfte wieder abzuziehen
											pPopUnit.changeExperience(iProductionExperience,-1,False,False,False)
											
										iXPTotal = (iProductionExperience + iProductionExperienceNearest)
										iXPAbzug = (iXPTotal / 2)
										pPopUnit.changeExperience(-iXPAbzug,-1,False,False,False)
										
										# Ungerade Zahl: -1 XP (abrunden)
										if iXPTotal %2 != 0: pPopUnit.changeExperience(-1,-1,False,False,False)
									
									# Textnachricht
									strMessage1 = CyTranslator().getText("TXT_KEY_TRAIT_POP_NEW_UNIT", (iPopUnitGold, pPopUnit.getName(), pNearestCity.getName()))
									CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage1, "", 0, unit.getButton(), ColorTypes(8), pNearestCity.getX(), pNearestCity.getY(), True, True)

# Populist Trait End -----------------------------------------------------------------------------------------------

	def onUnitLost(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Unit Lost'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		if (not self.__LOG_UNITLOST):
			return
		CvUtil.pyPrint('%s was lost by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitPromoted(self, argsList):
		'Unit Promoted'
		pUnit, iPromotion = argsList
		player = PyPlayer(pUnit.getOwner())

		pPlayer = gc.getPlayer(pUnit.getOwner())
		iUnitType = PyInfo.UnitInfo(pUnit.getUnitType())

# Cybah: BASE fr 6.4 A - ZE: Mongolei START -----------------------------------------------------------------------------------------------
		# Freie Befrderung Inspiration fr von einem Kriegsherren gefhrte Einheiten
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MONGOL")):
			if iPromotion == gc.getInfoTypeForString("PROMOTION_LEADER") and iUnitType.getDomainType() == DomainTypes.DOMAIN_LAND:
				pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_INSPIRATION'),True)
		
		# Idee: Chance auf Inspiration
			# if iPromotion != gc.getInfoTypeForString("PROMOTION_POPULIST1"):
				# iInspirationPromo = self.getRandomNumber( 100 )
				# if iInspirationPromo < 101 and pUnit.baseCombatStr() > 0 and iUnitType.getDomainType() == DomainTypes.DOMAIN_LAND:
					# pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_INSPIRATION'),True)
# Cybah: BASE fr 6.4 A - ZE: Mongolei END -----------------------------------------------------------------------------------------------
# berlufer Befrderung entfernen Start -----------------------------------------------------------------------------------------------
		if pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_DEFECTOR_LAND')) and iPromotion != gc.getInfoTypeForString("PROMOTION_POPULIST1"):
			pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_DEFECTOR_LAND'),False)
		if pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_DEFECTOR_SEA')) and iPromotion != gc.getInfoTypeForString("PROMOTION_POPULIST1"):
			pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_DEFECTOR_SEA'),False)
# berlufer Befrderung entfernen End -----------------------------------------------------------------------------------------------
# Populist Start -----------------------------------------------------------------------------------------------
#		if iPromotion == gc.getInfoTypeForString("PROMOTION_POPULIST1"):
#			if pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_ANCIENT"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / 200)
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_CLASSICAL"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / 200)
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MEDIEVAL"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / (200 * 10 / 12))
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_RENAISSANCE"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / (200 * 10 / 16))
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_INDUSTRIAL"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / (200 * 10 / 22))
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_MODERN"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / (200 / 3))
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			elif pPlayer.getCurrentEra() == gc.getInfoTypeForString("ERA_FUTURE"):
#				iTheSpeed = CyGame().getGameSpeedType()
#				TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
#				iPopUnitCost = (iUnitType.getProductionCost() * TheSpeed.getTrainPercent() / (200 / 3))
#				pPlayer.changeGold(-iPopUnitCost)
#				pUnit.changeLevel(-1)
#
#			pUnit.setPromotionReady(1)
# Populist End ----------------------------------------------------------------------------------------------- 
# ZE: Amerika 2/2 Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
			iTechZE = gc.getInfoTypeForString("TECH_AMERICA")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZE):
				pUnit.setDamage(0, False)
# ZE: Amerika 2/2 End -----------------------------------------------------------------------------------------------
# AI Promotion Tweaks Start -----------------------------------------------------------------------------------------------
		## rucivfan_ai_auto_play raap[
		## if not pPlayer.isHuman():
		# if not pPlayer.isHumanActive():
		## ]rucivfan_ai_auto_play raap
			# if iPromotion != gc.getInfoTypeForString('PROMOTION_MEDIC1') and iPromotion != gc.getInfoTypeForString('PROMOTION_MEDIC2') and iPromotion != gc.getInfoTypeForString('PROMOTION_MEDIC3'):			
				# if not pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC1')):
					# if pUnit.canAcquirePromotion(gc.getInfoTypeForString('PROMOTION_MEDIC1')):					
						# iX = pUnit.getX()
						# iY = pUnit.getY()
						# pPlot = CyMap().plot(iX, iY)
						# if(pPlot.getOwner() != -1 and gc.getPlayer(pPlot.getOwner()) == pPlayer):
						# # Im eigenen Land 1 von 60 Befrderungen
							# iPromotionForceMedic1 = self.getRandomNumber( 60 )							
							# if iPromotionForceMedic1 == 30:
								# pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC1'),True)
								# pUnit.setHasPromotion(iPromotion,False)
						# # Im Feindesland 1 von 30 Befrderungen
						# else:
							# iPromotionForceMedic1 = self.getRandomNumber( 30 )
							# if iPromotionForceMedic1 == 10:
								# pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC1'),True)
								# pUnit.setHasPromotion(iPromotion,False)
				# elif iPromotion != gc.getInfoTypeForString('PROMOTION_COMBAT1') and iPromotion != gc.getInfoTypeForString('PROMOTION_DRILL1') and pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC1')) and not pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC2')):
					# if pUnit.canAcquirePromotion(gc.getInfoTypeForString('PROMOTION_MEDIC2')):
						# # iPromotionForceMedic2 = self.getRandomNumber( 2 )
						# # if iPromotionForceMedic2 == 1:
						# pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC2'),True)
						# pUnit.setHasPromotion(iPromotion,False)
				# elif iPromotion != gc.getInfoTypeForString('PROMOTION_COMBAT2') and iPromotion != gc.getInfoTypeForString('PROMOTION_DRILL2') and pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC2')) and not pUnit.isHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC3')):
					# if pUnit.canAcquirePromotion(gc.getInfoTypeForString('PROMOTION_MEDIC3')):
						# # iPromotionForceMedic3 = self.getRandomNumber( 3 )
						# # if iPromotionForceMedic3 == 1:
						# pUnit.setHasPromotion(gc.getInfoTypeForString('PROMOTION_MEDIC3'),True)
						# pUnit.setHasPromotion(iPromotion,False)
# AI Promotion Tweaks End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_UNITPROMOTED):
			return
		CvUtil.pyPrint('Unit Promotion Event: %s - %s' %(player.getCivilizationName(), pUnit.getName(),))
	
	def onUnitSelected(self, argsList):
		'Unit Selected'
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		if (not self.__LOG_UNITSELECTED):
			return
		CvUtil.pyPrint('%s was selected by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
	
	def onUnitRename(self, argsList):
		'Unit is renamed'
		pUnit = argsList[0]
		if (pUnit.getOwner() == gc.getGame().getActivePlayer()):
			self.__eventEditUnitNameBegin(pUnit)
	
	def onUnitPillage(self, argsList):
		'Unit pillages a plot'
		pUnit, iImprovement, iRoute, iOwner = argsList
		iPlotX = pUnit.getX()
		iPlotY = pUnit.getY()
		pPlot = CyMap().plot(iPlotX, iPlotY)
		pPlayer = gc.getPlayer(pUnit.getOwner())

# Cunning Trait Start -----------------------------------------------------------------------------------------------
#		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CUNNING")):
#			iNotDestroyed = self.getRandomNumber( 4 )							
#			if iNotDestroyed < 3:
#				if iImprovement == gc.getInfoTypeForString("IMPROVEMENT_COTTAGE") or iImprovement == gc.getInfoTypeForString("IMPROVEMENT_HAMLET") or iImprovement == gc.getInfoTypeForString("IMPROVEMENT_VILLAGE") or iImprovement == gc.getInfoTypeForString("IMPROVEMENT_TOWN"):
#					pPlot.setImprovementType(iImprovement)
# Cunning Trait Start -----------------------------------------------------------------------------------------------
# Aggressive Trait Start -----------------------------------------------------------------------------------------------
		# if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SKIRMISHER")):
			# if not pUnit.canMove():
				# pUnit.setMoves(pUnit.maxMoves())
			
			# iMoveChange = 60
			# if(pUnit.getMoves() < iMoveChange):
				# pUnit.changeMoves(-pUnit.getMoves())
			# else:
				# pUnit.changeMoves(-iMoveChange)
				
		# rucivfan_movement_system_extended rmse[
		# iMoves entspricht dem alten iMovesLeft
		if pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_SKIRMISHER")):
			pUnit.changeTempFlatMoves(1)
		# ]rucivfan_movement_system_extended rmse
# Aggressive Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - ZE: Berber Start (DEAKTIVIERT -----------------------------------------------------------------------------------------------
		# elif pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"): 
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_BERBER")):
				# pUnit.changeTempFlatMoves(1)
# Cybah: BASE fr 6.3 C - ZE: Berber End -----------------------------------------------------------------------------------------------
# # ZE: Berber Start DEAKTIVIERT -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"): 
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_BERBER")):
				# # Goldzuwachs in GameUtils!
				# # pPlayer.changeGold(20)
				
				# if pUnit.isPromotionValid(gc.getInfoTypeForString("PROMOTION_BANDEIRA")) and not pUnit.isHasPromotion(gc.getInfoTypeForString("PROMOTION_BANDEIRA")):
					# pUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_BANDEIRA"),True)
# # ZE: Berber End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_UNITPILLAGE):
			return
		CvUtil.pyPrint("Player %d's %s pillaged improvement %d and route %d at plot at (%d, %d)" 
			%(iOwner, PyInfo.UnitInfo(pUnit.getUnitType()).getDescription(), iImprovement, iRoute, iPlotX, iPlotY))
	
	def onUnitSpreadReligionAttempt(self, argsList):
		'Unit tries to spread religion to a city'
		pUnit, iReligion, bSuccess = argsList		
		iX = pUnit.getX()
		iY = pUnit.getY()
		pPlot = CyMap().plot(iX, iY)
		pCity = pPlot.getPlotCity()
		pPlayer = gc.getPlayer(pUnit.getOwner())
		ppPlayer = gc.getPlayer(pCity.getOwner())

# ZE: Indonesien Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
			iTechZEINDO = gc.getInfoTypeForString("TECH_INDONESIA")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEINDO):
				# if not bSuccess:
					# capital= pPlayer.getCapitalCity()
					# pNewUnit = pPlayer.initUnit(pUnit.getUnitType(), capital.getX(),capital.getY(), UnitAITypes.UNITAI_MISSIONARY, DirectionTypes.NO_DIRECTION )
					# pNewUnit.finishMoves()
				if bSuccess:
					estiEnd = CyGame().getEstimateEndTurn()
					iPopulation = max(1, pCity.getPopulation())
					if estiEnd >= 1000:
						iGold = (iPopulation * 12)
					elif estiEnd >= 700:
						iGold = (iPopulation * 9)
					elif estiEnd >= 400:
						iGold = (iPopulation * 6)
					elif estiEnd >= 300:
						iGold = (iPopulation * 4)
					elif estiEnd < 300:
						iGold = (iPopulation * 4)
					# iGold *= (1 + pPlayer.getCurrentEra())
					
					# 6.3 C - gestrichen
					# Cybah: BASE fr 6.1 E - 50% Bonus falls Spieler nicht in Besitz der heiligen Stadt
					# if not pPlayer.hasHolyCity(iReligion):
						# iGold *= 3
						# iGold /= 2
					
					# # Malus fr vorhandene Religionen in der Stadt
					# iCityReligions = 0
					# for i in xrange(gc.getNumReligionInfos()):
						# if iReligion != i and pCity.isHasReligion(i):
							# iCityReligions += 1
					# if iCityReligions > 0:
						# iCityReligions = min(6, iCityReligions)
						# iGoldMalusPercent = (15 * iCityReligions)
						# iGold -= ((iGold * iGoldMalusPercent) / 100)
					
					# 6.3 C - gestrichen, warum war das berhaupt im Code? Speedmodifikatoren sind oben schon
					# iGold *= (gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getTrainPercent() / 100)
					
					if iGold > 0:
						pPlayer.changeGold(iGold)
						strMessage = CyTranslator().getText("TXT_KEY_TECH_INDONESIA_GOLD", (iGold, (pCity.getName())))
						CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
				
		# if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
			# iTechZEINDO = gc.getInfoTypeForString("TECH_INDONESIA")
			# if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEINDO):
				# if bSuccess:
					# estiEnd = CyGame().getEstimateEndTurn()
					# if estiEnd >= 1000:
						# iGold = (pCity.getPopulation() * 40)
					# elif estiEnd >= 700:
						# iGold = (pCity.getPopulation() * 30)
					# elif estiEnd >= 400:
						# iGold = (pCity.getPopulation() * 20)
					# elif estiEnd >= 300:
						# iGold = (pCity.getPopulation() * 13)
					# elif estiEnd < 300:
						# iGold = (pCity.getPopulation() * 13)
					# iCityReligions = 0
					# for i in xrange(gc.getNumReligionInfos()):
						# if iReligion != i and pCity.isHasReligion(i):
							# iCityReligions += 1
					# if iCityReligions > 0:
						# iCityReligions = min(6, iCityReligions)
						# iGoldMalusPercent = (15 * iCityReligions)
						# iGold -= ((iGold * iGoldMalusPercent) / 100)
					
					# ppPlayer.changeGold(iGold)				
					# strMessage = CyTranslator().getText("TXT_KEY_TECH_INDONESIA_GOLD", (iGold, (pCity.getName())))
					# CyInterface().addMessage(ppPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# ZE: Indonesien End -----------------------------------------------------------------------------------------------
	
	def onUnitGifted(self, argsList):
		'Unit is gifted from one player to another'
		pUnit, iGiftingPlayer, pPlotLocation = argsList
	
	def onUnitBuildImprovement(self, argsList):
		'Unit begins enacting a Build (building an Improvement or Route)'
		pUnit, iBuild, bFinished = argsList

	def onGoodyReceived(self, argsList):
		'Goody received'
		iPlayer, pPlot, pUnit, iGoodyType = argsList
		if (not self.__LOG_GOODYRECEIVED):
			return
		CvUtil.pyPrint('%s received a goody' %(gc.getPlayer(iPlayer).getCivilizationDescription(0)),)
	
	def onGreatPersonBorn(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Unit Promoted'
		pUnit, iPlayer, pCity = argsList
		player = PyPlayer(iPlayer)
		if pUnit.isNone() or pCity.isNone():
			return

		pPlayer = gc.getPlayer(pCity.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())

# Cybah: BASE fr 6.2 D - ZE: Osmanen START -----------------------------------------------------------------------------------------------
		if pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_GREAT_GENERAL") and pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_OTTOMAN")):
				# halbe Dauer
				iGALengthT = (pPlayer.getGoldenAgeLength() / 2)
				# if not pPlayer.isGoldenAge(): iGALengthT += 1
				pPlayer.changeGoldenAgeTurns(iGALengthT)
# Cybah: BASE fr 6.2 D - ZE: Osmanen END -----------------------------------------------------------------------------------------------
# Nobel Prize Awards Start -----------------------------------------------------------------------------------------------
#		if not pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_GREAT_SPY") and not pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_GREAT_GENERAL"):
#			if pTeam.getProjectCount(gc.getInfoTypeForString("PROJECT_NOBEL")) > 0:
#				iNobelHappyChance = self.getRandomNumber(gc.getGame().countCivPlayersAlive())
#				if iNobelHappyChance == 0:
#					iNobelHappy = self.getRandomNumber(gc.getGame().countCivPlayersAlive())
#					iNobelHappyTotal = max(1, iNobelHappy)
#					pCity.changeExtraHappiness(iNobelHappyTotal)
#					strMessage = CyTranslator().getText("TXT_KEY_PROJECT_NOBEL_HAPPY", (pCity.getName(), pUnit.getName(), iNobelHappyTotal))
#					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_NOBEL")).getButton(), ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# Nobel Prize Awards End -----------------------------------------------------------------------------------------------
# Nobel Prize Acceptance Start -----------------------------------------------------------------------------------------------
#			elif pTeam.getProjectCount(gc.getInfoTypeForString("PROJECT_NOBEL_ACCEPTANCE")) > 0:
#				iNobelHappyChance = self.getRandomNumber(gc.getGame().countCivPlayersAlive() * 2)
#				if iNobelHappyChance == 0:
#					iNobelHappy = self.getRandomNumber(gc.getGame().countCivPlayersAlive())
#					iNobelHappyTotal = max(1, iNobelHappy)
#					pCity.changeExtraHappiness(iNobelHappyTotal)
#					strMessage = CyTranslator().getText("TXT_KEY_PROJECT_NOBEL_HAPPY", (pCity.getName(), pUnit.getName(), iNobelHappyTotal))
#					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProjectInfo(gc.getInfoTypeForString("PROJECT_NOBEL")).getButton(), ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# Nobel Prize Acceptance End -----------------------------------------------------------------------------------------------
# ZE: Deutschland Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
#			iTechZEGER1 = gc.getInfoTypeForString("TECH_GERMANY")
#			iTechZEGER2 = gc.getInfoTypeForString("TECH_ASSEMBLY_LINE")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEGER1) and gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEGER2):
#				if pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_ENGINEER"):
#					pCity.createGreatPeople(gc.getInfoTypeForString( 'UNIT_ENGINEER' ), False, False)
# ZE: Deutschland End -----------------------------------------------------------------------------------------------
# Triumpfbogen Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT/GENDERT in 6.1 E
		# if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_ARC_DE_TRIOMPHE")) > 0:
			# b_Arc = gc.getInfoTypeForString("BUILDING_ARC_DE_TRIOMPHE")
			# obsoleteTechArc = gc.getBuildingInfo(b_Arc).getObsoleteTech()
			# if obsoleteTechArc == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTechArc):
				# if pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_GREAT_GENERAL"):
					# newGeneral = pPlayer.initUnit(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
# Triumpfbogen End ----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Populist Trait: Nationaler Feiertag auch bei Geburt Groer Persnlichkeiten START -----------------------------------------------------------------------------------------------
		# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_POPULIST")) and not pUnit.getUnitType() == gc.getInfoTypeForString("UNIT_GREAT_GENERAL"):
			# iPopGoldTotal = 0
			# pCityPop, iter = pPlayer.firstCity(false)
			# while(pCityPop):
				# if pCityPop.getOwner() == pPlayer.getID() and pCityPop.getPopulation() > 0 and not pCityPop.isNone() and not pCityPop.isWeLoveTheKingDay():
					# pCityPop.setWeLoveTheKingDay(true)
					# iPopGoldTotal += pCityPop.getPopulation()
					# # Cybah: BASE fr 6.1 D - Vier statt zwei einzelne Berechnungen fr weniger Random Spitzen
					# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					# iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
				# pCityPop, iter = pPlayer.nextCity(iter, false)
					
			# if iPopGoldTotal > 0:
				# iGoldFaktor = 4
				# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PRINTING_PRESS")):
					# iGoldFaktor += 1
				# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MASS_MEDIA")):
					# iGoldFaktor += 1
				# iPopGoldTotal *= iGoldFaktor
				# iPopGoldTotal /= 4
					
				# #Fr 6.1 E - 50% mehr Gold
				# iPopGoldTotal *= 4
				# iPopGoldTotal /= 2
				
				# pPlayer.changeGold(iPopGoldTotal)
				# pCapital = pPlayer.getCapitalCity()
				# strMessage = CyTranslator().getText("TXT_KEY_TRAIT_POP_GET_GOLD_NATIONAL", (iPopGoldTotal, (iPopGoldTotal)))
				# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCapital.getX(), pCapital.getY(), True, True)
# Cybah: BASE fr 6.1 E - Populist Trait: Nationaler Feiertag auch bei Geburt Groer Persnlichkeiten END -----------------------------------------------------------------------------------------------

		if (not self.__LOG_GREATPERSON):
			return
		CvUtil.pyPrint('A %s was born for %s in %s' %(pUnit.getName(), player.getCivilizationName(), pCity.getName()))
	
	def AI_chooseReligion(self, iPlayer):
		pPlayer = gc.getPlayer(iPlayer)
		eFavorite = gc.getLeaderHeadInfo(pPlayer.getLeaderType()).getFavoriteReligion()
		if eFavorite > -1 and not CyGame().isReligionFounded(eFavorite):
			return eFavorite

		aeReligions = list()
		for i in xrange(gc.getNumReligionInfos()):
			if not CyGame().isReligionFounded(i):
				aeReligions.append(i)

		if len(aeReligions) > 0:
			return aeReligions[CyGame().getSorenRandNum(len(aeReligions), "AI pick religion")]

		return -1

	def onTechAcquired(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Tech Acquired'
		iTechType, iTeam, iPlayer, bAnnounce = argsList
		# Note that iPlayer may be NULL (-1) and not a refer to a player object

# ZE: Variablen fr alle Spieler Start -----------------------------------------------------------------------------------------------
		if iPlayer > -1:
			pZEPlayer = gc.getPlayer(iPlayer)
			iZETeam = pZEPlayer.getTeam()
			pZETeam = gc.getTeam(iZETeam)
# ZE: Variablen fr alle Spieler End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Technologie Das Rad START -----------------------------------------------------------------------------------------------
			if iTechType == gc.getInfoTypeForString('TECH_THE_WHEEL'):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						(loopUnit, iter) = pPlayerX.firstUnit(False)
						while(loopUnit):
							if loopUnit.getUnitType() == gc.getInfoTypeForString('UNIT_SETTLER'):
								loopUnit.setHasPromotion(gc.getInfoTypeForString("PROMOTION_MOBILITY"),True)
							(loopUnit, iter) = pPlayerX.nextUnit(iter, False)
								
					# Mehr Palastkommerz START -----------------------------------------------------------------------------------------------
						iBonusPalaceCommerce = 2

						# ZE: Byzanz 2/4 Start ----------------------------------------------------------------------------------------------
						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
							iTechZEBY = gc.getInfoTypeForString("TECH_BYZANTIUM")
							if gc.getTeam(pPlayerX.getTeam()).isHasTech(iTechZEBY):
							
								# Nichthauptstdte zhlen
								iNonCapCities= 0
								pNumCity, iter = pPlayerX.firstCity(false)  
								while(pNumCity):	  
									if pNumCity.getOwner() == pPlayerX.getID() and not pNumCity.isNone() and not pNumCity.isCapital():
										iNonCapCities += 1
										# Bonus temporr auf 0 setzen
										pNumCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, 0)
									pNumCity, iter = pPlayerX.nextCity(iter, false)
							
								# Eigenschaft: +2 immer und +1 fr jede weitere Stadt
								iByzBonus = (2 + iNonCapCities)
								iBonusPalaceCommerce += iByzBonus
						# ZE: Byzanz 2/4 End ----------------------------------------------------------------------------------------------

						# Palastkommerzbonus in allen Stdten einstellen
						pCityPalaceCommerce, iter = pPlayerX.firstCity(false)  
						while(pCityPalaceCommerce):	  
							if pCityPalaceCommerce.getOwner() == pPlayerX.getID() and not pCityPalaceCommerce.isNone():
								pCityPalaceCommerce.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, iBonusPalaceCommerce)
							pCityPalaceCommerce, iter = pPlayerX.nextCity(iter, false)
					# Mehr Palastkommerz END -----------------------------------------------------------------------------------------------
			
# Cybah: BASE fr 6.1 E - Technologie Das Rad END -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - Brasilianischer Bandeirante 2/2 START (Idee) -----------------------------------------------------------------------------------------------
			# if iTechType == gc.getInfoTypeForString("TECH_MILITARY_TRADITION"):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# (loopUnit, iter) = pPlayerX.firstUnit(False)
						# while(loopUnit):
							# if loopUnit.getUnitType() == gc.getInfoTypeForString('UNIT_BRAZIL_BANDEIRANTE'):
								# loopUnit.setBaseCombatStr(loopUnit.baseCombatStr() + 2)
							# (loopUnit, iter) = pPlayerX.nextUnit(iter, False)
# Cybah: BASE fr 6.3 C - Brasilianischer Bandeirante 2/2 END -----------------------------------------------------------------------------------------------
# ZE: Amerika 2/2 Start - DEAKTIVIERT/ERSETZT MIT 6.3 C -----------------------------------------------------------------------------------------------
		# if iTechType == gc.getInfoTypeForString("TECH_INDUSTRIALISM"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_AMERICA")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_ALUMINUM"), 1)
# ZE: Amerika 2/2 End -----------------------------------------------------------------------------------------------
# ZE: China 2/3 Start -----------------------------------------------------------------------------------------------			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_CHINA")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
#							capitalZE = pPlayerX.getCapitalCity()
#							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_RARE_EARTH_ELEMENTS"), 1)
# ZE: China 2/3 End -----------------------------------------------------------------------------------------------
# ZE: China 3/3 Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_MONARCHY"):			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_CHINA")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
#							capitalZE = pPlayerX.getCapitalCity()
#							capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), False, False)
# ZE: China 3/3 End -----------------------------------------------------------------------------------------------
# ZE: Arabien 1/2 Start -----------------------------------------------------------------------------------------------
		# if iTechType == gc.getInfoTypeForString("TECH_COMBUSTION"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_ARABIA")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_OIL"), 1)
# ZE: Arabien 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Hethiter Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_IRON_WORKING"):			
			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_HITTITES")):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
							capitalZE = pPlayerX.getCapitalCity()
							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_IRON"), 1)
# ZE: Hethiter End -----------------------------------------------------------------------------------------------
# ZE: England Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_STEAM_POWER"):			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_ENGLAND")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
#							capitalZE = pPlayerX.getCapitalCity()
#							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_COAL"), 1)
# ZE: England End -----------------------------------------------------------------------------------------------
# ZE: Griechenland Start -----------------------------------------------------------------------------------------------
		# if iTechType == gc.getInfoTypeForString("TECH_MATHEMATICS"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_GREECE")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_SCIENTIST' ), False, False)
		# if iTechType == gc.getInfoTypeForString("TECH_DRAMA"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_GREECE")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_ARTIST' ), False, False)
# ZE: Griechenland End ----------------------------------------------------------------------------------------------- 
# ZE: Israel 1/2 Start (DEAKTIVIERT in 6.3 C) -----------------------------------------------------------------------------------------------
		# if iTechType == gc.getInfoTypeForString("TECH_MONOTHEISM"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_ISRAEL")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_PROPHET' ), False, False)
# ZE: Israel 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Korea 2/2 Start -----------------------------------------------------------------------------------------------
		# if iTechType == gc.getInfoTypeForString("TECH_GUNPOWDER"):			
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_KOREA")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA"):
							# capitalZE = pPlayerX.getCapitalCity()
							# capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_SALPETER"), 1)
# ZE: Korea 2/2 End -----------------------------------------------------------------------------------------------
# ZE: Portugal Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_CARTOGRAPHY"):			
			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_PORTUGAL")):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
							capitalZE = pPlayerX.getCapitalCity()
							capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_MERCHANT' ), False, False)
# ZE: Portugal End -----------------------------------------------------------------------------------------------
# ZE: Frankreich Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_DIVINE_RIGHT"):			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_FRANCE")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
#							if pPlayerX.isGoldenAge(): iGALengthF = pPlayerX.getGoldenAgeLength()
#							else: iGALengthF = (pPlayerX.getGoldenAgeLength() + 1)
#							pPlayerX.changeGoldenAgeTurns(iGALengthF)
# ZE: Frankreich End -----------------------------------------------------------------------------------------------
# ZE: England Start (deaktiviert mit 6.2 D) -----------------------------------------------------------------------------------------------
		# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_ENGLAND")):
			# iEnglandTechs = 0
			# for iTech in xrange(gc.getNumTechInfos()):
				# if not gc.getTechInfo(iTech).isTrade() or gc.getTechInfo(iTech).isRepeat(): continue
				# if gc.getTeam(iZETeam).isHasTech(iTech): iEnglandTechs += 1
			
			# # Cybah: BASE fr 6.2 D - Alle 12 Technologien
			# if iEnglandTechs % 12 == 0:
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# # halbe Dauer
							# iGALengthT = (pPlayerX.getGoldenAgeLength() / 2)
							# if not pPlayerX.isGoldenAge(): iGALengthT += 1
							# pPlayerX.changeGoldenAgeTurns(iGALengthT)
							
			# elif iEnglandTechs == 4 or iEnglandTechs == 16 or iEnglandTechs == 28 or iEnglandTechs == 40 or iEnglandTechs == 52 or iEnglandTechs == 64 or iEnglandTechs == 76 or iEnglandTechs == 88 or iEnglandTechs == 100 or iEnglandTechs == 112:
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# capitalZE = pPlayerX.getCapitalCity()
							# strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (8)))
							# CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
							
			# elif iEnglandTechs == 8 or iEnglandTechs == 20 or iEnglandTechs == 32 or iEnglandTechs == 44 or iEnglandTechs == 56 or iEnglandTechs == 68 or iEnglandTechs == 80 or iEnglandTechs == 92 or iEnglandTechs == 104 or iEnglandTechs == 116:
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# capitalZE = pPlayerX.getCapitalCity()
							# strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (4)))
							# CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
							
			# elif iEnglandTechs == 11 or iEnglandTechs == 23 or iEnglandTechs == 35 or iEnglandTechs == 47 or iEnglandTechs == 59 or iEnglandTechs == 71 or iEnglandTechs == 83 or iEnglandTechs == 95 or iEnglandTechs == 107 or iEnglandTechs == 119:
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# capitalZE = pPlayerX.getCapitalCity()
							# strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (1)))
							# CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
				
			# # Alle 15 Technologien
			# # if iEnglandTechs == 15 or iEnglandTechs == 30 or iEnglandTechs == 45 or iEnglandTechs == 60 or iEnglandTechs == 75 or iEnglandTechs == 90 or iEnglandTechs == 105:
				# # for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# # pPlayerX = gc.getPlayer(iPlayerX)
					# # if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# # if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# # # halbe Dauer
							# # iGALengthT = (pPlayerX.getGoldenAgeLength() / 2)
							# # if not pPlayerX.isGoldenAge(): iGALengthT += 1
							# # pPlayerX.changeGoldenAgeTurns(iGALengthT)
							
			# # elif iEnglandTechs == 5 or iEnglandTechs == 20 or iEnglandTechs == 35 or iEnglandTechs == 50 or iEnglandTechs == 65 or iEnglandTechs == 80 or iEnglandTechs == 95:
				# # for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# # pPlayerX = gc.getPlayer(iPlayerX)
					# # if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# # if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# # capitalZE = pPlayerX.getCapitalCity()
							# # strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (10)))
							# # CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
							
			# # elif iEnglandTechs == 10 or iEnglandTechs == 25 or iEnglandTechs == 40 or iEnglandTechs == 55 or iEnglandTechs == 70 or iEnglandTechs == 85 or iEnglandTechs == 100:
				# # for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# # pPlayerX = gc.getPlayer(iPlayerX)
					# # if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# # if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# # capitalZE = pPlayerX.getCapitalCity()
							# # strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (5)))
							# # CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
							
			# # elif iEnglandTechs == 14 or iEnglandTechs == 29 or iEnglandTechs == 44 or iEnglandTechs == 59 or iEnglandTechs == 74 or iEnglandTechs == 89 or iEnglandTechs == 104:
				# # for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# # pPlayerX = gc.getPlayer(iPlayerX)
					# # if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# # if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
							# # capitalZE = pPlayerX.getCapitalCity()
							# # strMessage = CyTranslator().getText("TXT_KEY_ENGLAND_TECHS_MISSING", (pPlayerX.getName(), (1)))
							# # CyInterface().addMessage(pPlayerX.getID(), True, 20, strMessage, "AS2D_POSITIVE_DINK", 0,'Art/Interface/Buttons/General/warning_popup.dds', ColorTypes(11), capitalZE.getX(), capitalZE.getY(), True, True)
		
			# # # -- Alter Effekt: Bei Erforschung der letzten potentiell nicht religiongrndenden Tech jeder ra --
			# # # iEra0 = 0; iEra1 = 0; iEra2 = 0; iEra3 = 0; iEra4 = 0; iEra5 = 0; iEra6 = 0
			# # # iHasEra0 = 0; iHasEra1 = 0; iHasEra2 = 0; iHasEra3 = 0; iHasEra4 = 0; iHasEra5 = 0; iHasEra6 = 0
			# # # for iTech in xrange(gc.getNumTechInfos()):
				# # # if not gc.getTechInfo(iTech).isTrade() or gc.getTechInfo(iTech).isRepeat(): continue
				# # # Era = gc.getTechInfo(iTech).getEra()
				# # # if Era == 0 and iTech != gc.getInfoTypeForString("TECH_MEDITATION") and iTech != gc.getInfoTypeForString("TECH_POLYTHEISM") and iTech != gc.getInfoTypeForString("TECH_MONOTHEISM"):
					# # # iEra0 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra0 += 1
				# # # elif Era == 1 and iTech != gc.getInfoTypeForString("TECH_CODE_OF_LAWS") and iTech != gc.getInfoTypeForString("TECH_THEOLOGY"):
					# # # iEra1 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra1 += 1
				# # # elif Era == 2 and iTech != gc.getInfoTypeForString("TECH_DIVINE_RIGHT") and iTech != gc.getInfoTypeForString("TECH_PHILOSOPHY"):
					# # # iEra2 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra2 += 1
				# # # elif Era == 3:
					# # # iEra3 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra3 += 1
				# # # elif Era == 4:
					# # # iEra4 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra4 += 1
				# # # elif Era == 5:
					# # # iEra5 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra5 += 1
				# # # elif Era == 6:
					# # # iEra6 += 1
					# # # if gc.getTeam(iZETeam).isHasTech(iTech):
						# # # iHasEra6 += 1
			
			# # # bGoldenAge = False
			
			# # # if gc.getTechInfo(iTechType).getEra() == 0 and iEra0 == iHasEra0: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 1 and iEra1 == iHasEra1: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 2 and iEra2 == iHasEra2: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 3 and iEra3 == iHasEra3: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 4 and iEra4 == iHasEra4: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 5 and iEra5 == iHasEra5: bGoldenAge = True
			# # # elif gc.getTechInfo(iTechType).getEra() == 6 and iEra6 == iHasEra6: bGoldenAge = True
				
			# # # for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				# # # pPlayerX = gc.getPlayer(iPlayerX)
				# # # if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
					# # # if bGoldenAge and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
					
						# # # # halbe Dauer
						# # # iGALengthT = (pPlayerX.getGoldenAgeLength() / 2)
						# # # if not pPlayerX.isGoldenAge(): iGALengthT += 1
						# # # pPlayerX.changeGoldenAgeTurns(iGALengthT)					
# ZE: England End -----------------------------------------------------------------------------------------------
# GA durch Tourismus Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_TOURISM"):
			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				pPlayerX = gc.getPlayer(iPlayerX)
				if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
				
# ZE: Persien Start (Rest vom Bewegungsbonus whrend GZ ist im SDK)  -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.2 D - ALLES IM SDK !!!!
					# if gc.getTeam(pPlayerX.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PERSIA")) and not pPlayerX.isGoldenAge():
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA"):
							# (loopUnit, iter) = pPlayerX.firstUnit(False)
							# while(loopUnit):				
								# if loopUnit.baseCombatStr() > 0 and loopUnit.getDomainType() == DomainTypes.DOMAIN_LAND:
									# loopUnit.changeTempFlatMoves(1)
								# (loopUnit, iter) = pPlayerX.nextUnit(iter, False)						
# ZE: Persien End (Rest vom Bewegungsbonus whrend GZ ist im SDK)  -----------------------------------------------------------------------------------------------
				
					iGALengthT = pPlayerX.getGoldenAgeLength()
					if not pPlayerX.isGoldenAge(): iGALengthT += 1
					pPlayerX.changeGoldenAgeTurns(iGALengthT)
# GA durch Tourismus End -----------------------------------------------------------------------------------------------
# ZE: Karibik 3/3 Start -----------------------------------------------------------------------------------------------			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_CARIBBEAN")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN"):
#							if pPlayerX.isGoldenAge(): iGALengthK = pPlayerX.getGoldenAgeLength()
#							else: iGALengthK = (pPlayerX.getGoldenAgeLength() + 1)
#							pZEPlayer.changeGoldenAgeTurns(iGALengthK)
# ZE: Karibik 3/3 End -----------------------------------------------------------------------------------------------
# ZE: Japan 1/3 Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_ASSEMBLY_LINE"):
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_JAPAN")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
#								pCity, iter = pZEPlayer.firstCity(false)  
#								while(pCity):  
#										iCityOwner = pCity.getOwner()  
#										if not pCity.isNone() and iCityOwner == pZEPlayer.getID():
#									iFabrikKlasse = gc.getInfoTypeForString("BUILDINGCLASS_FACTORY") 
#									pCity.changeNumCivilizationBuildingPossible(iFabrikKlasse, 1, False)
#								pCity, iter = pZEPlayer.nextCity(iter, false)
# ZE: Japan 1/3 End -----------------------------------------------------------------------------------------------
# ZE: Khmer 1/5 Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_CONSTITUTION"):
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_KHMER")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
#								pCity, iter = pZEPlayer.firstCity(false)  
#								while(pCity):  
#										iCityOwner = pCity.getOwner()  
#										if not pCity.isNone() and iCityOwner == pZEPlayer.getID():
#									iJailClass = gc.getInfoTypeForString("BUILDINGCLASS_JAIL") 
#									pCity.changeNumCivilizationBuildingPossible(iJailClass, 1, False)
#								pCity, iter = pZEPlayer.nextCity(iter, false)
# ZE: Khmer 1/5 End -----------------------------------------------------------------------------------------------
# ZE: sterreich 2/2 Start -----------------------------------------------------------------------------------------------
			# # if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_RIFLING")) and gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_AUSTRIA")):
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_AUSTRIA")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
								# pCity, iter = pZEPlayer.firstCity(false)  
								# while(pCity):  
										# iCityOwner = pCity.getOwner()  
										# if not pCity.isNone() and iCityOwner == pZEPlayer.getID():
									# iTheSpeed = CyGame().getGameSpeedType()
									# TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
									# iGreatWorkCulture = (10 * TheSpeed.getUnitGreatWorkPercent())
									# pCity.changeCulture(iPlayerX, iGreatWorkCulture, true)

									# # rucivfan_conscript_extended rce[
									# # #pHSUnitID = pCity.getConscriptUnit()
									# #pHSUnitID = pCity.getConscriptUnit(false) # true fr keine reinen Verteidigungseinheiten
									# # ]rucivfan_conscript_extended rce

									# #for i in xrange(1):
										# #pNewUnit = pZEPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
										# #pCity.addProductionExperience(pNewUnit, false)
								# pCity, iter = pZEPlayer.nextCity(iter, false)

		# if iTechType == gc.getInfoTypeForString("TECH_RIFLING"):
			# # if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_CONSTITUTION")) and gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_AUSTRIA")):
			# if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_AUSTRIA")):
				# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					# pPlayerX = gc.getPlayer(iPlayerX)
					# if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						# if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
								# pCity, iter = pZEPlayer.firstCity(false)  
								# while(pCity):  
										# iCityOwner = pCity.getOwner()  
										# if not pCity.isNone() and iCityOwner == pZEPlayer.getID():
									# #iTheSpeed = CyGame().getGameSpeedType()
									# #TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
									# #iGreatWorkCulture = (10 * TheSpeed.getUnitGreatWorkPercent())
									# #pCity.changeCulture(iPlayerX, iGreatWorkCulture, true)

									# # rucivfan_conscript_extended rce[
									# #pHSUnitID = pCity.getConscriptUnit()
									# pHSUnitID = pCity.getConscriptUnit(false) # true fr keine reinen Verteidigungseinheiten
									# # ]rucivfan_conscript_extended rce

									# for i in xrange(1):
										# pNewUnit = pZEPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
										# pCity.addProductionExperience(pNewUnit, false)
								# pCity, iter = pZEPlayer.nextCity(iter, false)
# ZE: sterreich 2/2 End -----------------------------------------------------------------------------------------------
# ZE: Mongolei 2/2 Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_HORSEBACK_RIDING"):
			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_MONGOL")):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
							capitalZE = pPlayerX.getCapitalCity()
							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_HORSE"), 1)
# ZE: Mongolei 2/2 End -----------------------------------------------------------------------------------------------
# ZE: Karthago 1/2 Start -----------------------------------------------------------------------------------------------			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_CARTHAGE")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
#							capitalZE = pPlayerX.getCapitalCity()
#							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_IVORY"), 1)
# ZE: Karthago 1/2 End -----------------------------------------------------------------------------------------------
# ZE: Russland 3/3 Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_FISSION"):			
#			if gc.getTeam(iZETeam).isHasTech(gc.getInfoTypeForString("TECH_RUSSIA")):
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.isAlive() and pPlayerX.getTeam() == iZETeam:
#						if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
#							capitalZE = pPlayerX.getCapitalCity()
#							capitalZE.changeFreeBonus(gc.getInfoTypeForString("BONUS_URANIUM"), 1)
# ZE: Russland 3/3 End -----------------------------------------------------------------------------------------------
# Terraforming Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_TERRAFORMING"):
			pPlayer = gc.getPlayer(iPlayer)
			for iPlayer2 in xrange(gc.getMAX_CIV_PLAYERS()):
				iPlayerT2 = gc.getPlayer(iPlayer2)
				if iPlayerT2.getTeam() == pPlayer.getTeam():
					for iX in xrange(CyMap().getGridWidth()):
						for iY in xrange(CyMap().getGridHeight()):	
							pPlot = CyMap().plot(iX,iY)
							if pPlot.getOwner() == iPlayer2:
								if pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_DESERT' ) and not pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_FLOOD_PLAINS' ) and not pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_OASIS' ):
									pPlot.setTerrainType(gc.getInfoTypeForString( 'TERRAIN_PLAINS' ), True, True)
								elif pPlot.getTerrainType() == gc.getInfoTypeForString( 'TERRAIN_SNOW' ):
									pPlot.setTerrainType(gc.getInfoTypeForString( 'TERRAIN_TUNDRA' ), True, True)
								# 6.4 C - Eis wird auch entfernt
								if pPlot.getFeatureType() == gc.getInfoTypeForString( 'FEATURE_ICE' ):
									pPlot.setFeatureType(-1, 0)
# Terraforming End -----------------------------------------------------------------------------------------------
		
		# Inquisition Mod
		rSlotAvailable = False
		iRCount = 0		
		# End Inquisition Mod
		
# Limited Religions Mod Start -----------------------------------------------------------------------------------------------
		CvPlayer = gc.getPlayer(iPlayer)
		
		# Is Tech a Religious Tech?
		if CvUtil.CvIsReligiousTech(iTechType):
			# If game option is Limited Religions
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_LIMITED_RELIGIONS):
				if not CvPlayer.isNone() and not CvPlayer.isBarbarian() and CvPlayer.isAlive():
					#if iPlayer > -1 and not CvPlayer.isNone() and not CvPlayer.isBarbarian() and CvPlayer.isAlive():
					#CvGameUtils.LR_iPlayer = iPlayer
					# Does the player have a Holy City?
					if not CvUtil.OwnsHolyCity(iPlayer):
						# Loop through Religions
						for iReligion in xrange(gc.getNumReligionInfos()):
							# If the religion has not been founded
							if not gc.getGame().isReligionFounded(iReligion):
								# If game option is not set to choose religions
								if not CyGame().isOption(GameOptionTypes.GAMEOPTION_PICK_RELIGION):
									if gc.getReligionInfo(iReligion).getTechPrereq() == iTechType:
										gc.getPlayer(iPlayer).foundReligion(iReligion,iReligion,True)
										#CyInterface().addMessage(CyGame().getActivePlayer(),True,25,'Message A','AS2D_DISCOVERBONUS',1,'Art/Interface/Buttons/TerrainFeatures/Forest.dds',ColorTypes(8),0,0,False,False)
										break
								# If game option is set to choose religions
								elif CyGame().isOption(GameOptionTypes.GAMEOPTION_PICK_RELIGION):
									rSlotAvailable = True
									break
																				
		#  There is one or more unfounded Religions
		if rSlotAvailable:
			TotalRelFounded = CvUtil.CvGetTotalReligionsFounded()
			# Evaluate whether or not a religion can be founded for the discovered tech 
			if CvUtil.canTechFoundReligion(iTechType, TotalRelFounded):
				# rucivfan_ai_auto_play raap[
				#if not CvPlayer.isNone() and not CvPlayer.isBarbarian() and not CvPlayer.isHuman() and CvPlayer.isAlive():
				if not CvPlayer.isNone() and not CvPlayer.isBarbarian() and not CvPlayer.isHumanActive() and CvPlayer.isAlive():
				# ]rucivfan_ai_auto_play raap				
					if not CvUtil.OwnsHolyCity(iPlayer):
						gc.getPlayer(iPlayer).foundReligion(iReligion,iReligion,True)
						#CyInterface().addMessage(CyGame().getActivePlayer(),True,25,'Message B','AS2D_DISCOVERBONUS',1,'Art/Interface/Buttons/TerrainFeatures/Forest.dds',ColorTypes(8),0,0,False,False)

				# rucivfan_ai_auto_play raap[
				#elif CvPlayer.isHuman() and CvPlayer.isAlive():
				elif CvPlayer.isHumanActive() and CvPlayer.isAlive():
				# ]rucivfan_ai_auto_play raap				
					# Create Religion Selection Popup
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
					popupInfo.setData1(iPlayer)
					popupInfo.setText(CyTranslator().getText(("TXT_KEY_FOUNDED_RELIGION"),()))
								
					# Find all unfounded religions
					for iNewReligion in xrange(gc.getNumReligionInfos()):
						if not gc.getGame().isReligionFounded(iNewReligion):
							popupInfo.addPythonButton(gc.getReligionInfo(iNewReligion).getDescription(), gc.getReligionInfo(iNewReligion).getButton())
							iRCount = iRCount + 1
							if iRCount == gc.getNumReligionInfos() - CvUtil.CvGetTotalReligionsFounded():
								# Display popup for human player to selected Religion
								popupInfo.addPopup(1)
								#CyInterface().addMessage(CyGame().getActivePlayer(),True,25,'Message C','AS2D_DISCOVERBONUS',1,'Art/Interface/Buttons/TerrainFeatures/Forest.dds',ColorTypes(8),0,0,False,False)
								break
								# End Inquisition Mod 
# Limited Religions Mod End -----------------------------------------------------------------------------------------------
# Gameoption AI and Barbarian Tech Support Start -----------------------------------------------------------------------------------------------

		if gc.getTechInfo(iTechType).isTrade() and (gc.getGame().isOption(GameOptionTypes.GAMEOPTION_AI_TECH_SUPPORT) or gc.getGame().isOption(GameOptionTypes.GAMEOPTION_BARBARIAN_TECH_SUPPORT)):
			iBarbTech1 = gc.getInfoTypeForString("TECH_MYSTICISM")
			iBarbTech2 = gc.getInfoTypeForString("TECH_MEDITATION")
			iBarbTech3 = gc.getInfoTypeForString("TECH_POLYTHEISM")
			iBarbTech4 = gc.getInfoTypeForString("TECH_MONOTHEISM")
			iBarbTech5 = gc.getInfoTypeForString("TECH_CODE_OF_LAWS")
			iBarbTech6 = gc.getInfoTypeForString("TECH_THEOLOGY")
			iBarbTech7 = gc.getInfoTypeForString("TECH_PHILOSOPHY")
			iBarbTech8 = gc.getInfoTypeForString("TECH_DIVINE_RIGHT")
			if ((iTechType != iBarbTech1) and (iTechType != iBarbTech2) and (iTechType != iBarbTech3) and (iTechType != iBarbTech4) and (iTechType != iBarbTech5) and (iTechType != iBarbTech6) and (iTechType != iBarbTech7) and (iTechType != iBarbTech8)):
				humantechcounter = 0
				AItechcounter = 0
				for i in xrange(gc.getMAX_PLAYERS()):
					TSTeam = gc.getTeam(gc.getPlayer(i).getTeam())
					if TSTeam.isHasTech(iTechType):
						if not gc.getPlayer(i).isBarbarian():
							# rucivfan_ai_auto_play raap[
							#if gc.getPlayer(i).isHuman():
							if gc.getPlayer(i).isHumanActive():
							# ]rucivfan_ai_auto_play raap							
								humantechcounter = humantechcounter+1
							else:
								AItechcounter = AItechcounter+1
							if (humantechcounter > 1) or (humantechcounter > 0 and AItechcounter > 0):
								if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_AI_TECH_SUPPORT):
									for j in xrange(gc.getMAX_PLAYERS ()):
										AITSTeam = gc.getTeam(gc.getPlayer(j).getTeam())
										if not gc.getPlayer(j).isBarbarian():
											# rucivfan_ai_auto_play raap[
											#if not AITSTeam.isHuman() and not gc.getPlayer(j).isHuman() and not gc.getPlayer(j).isBarbarian() and gc.getPlayer(j).isAlive():
											if not AITSTeam.isHumanActive() and not gc.getPlayer(j).isHumanActive() and not gc.getPlayer(j).isBarbarian() and gc.getPlayer(j).isAlive():
											# ]rucivfan_ai_auto_play raap											
												AITSTeam.changeResearchProgress(iTechType, AITSTeam.getResearchCost(iTechType) - AITSTeam.getResearchProgress(iTechType), j)
												# AITSTeam.setHasTech(iTechType,True,j,False,True)
								if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_BARBARIAN_TECH_SUPPORT) and not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_BARBARIANS) and not iTechType == gc.getInfoTypeForString("TECH_TOURISM"):
									gc.getTeam(gc.getPlayer(gc.getBARBARIAN_PLAYER()).getTeam()).setHasTech(iTechType,True,gc.getBARBARIAN_PLAYER(),False,True)

# Gameoption AI and Barbarian Tech Support End -----------------------------------------------------------------------------------------------
# ZE: Griechenland Start -----------------------------------------------------------------------------------------------

		TechInfo = gc.getTechInfo(iTechType)
		if TechInfo.getFirstFreeTechs() > 0 or TechInfo.getFirstFreeUnitClass() != -1:
			pPlayer = gc.getPlayer(iPlayer)
		
			if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_GREECE")):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.isAlive() and pPlayerX.getCapitalCity() != -1 and pPlayerX.getTeam() == pPlayer.getTeam() and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):

						for iTeamX in xrange(gc.getMAX_CIV_TEAMS()):
							if iTeamX != iTeam and gc.getTeam(iTeamX).isHasTech(iTechType):
								if TechInfo.getFirstFreeTechs() > 0:
									if pPlayerX.isHuman:
										pPlayerX.chooseTech(TechInfo.getFirstFreeTechs(),'',True)
									# rucivfan_ai_auto_play raap[
									#if not pPlayerX.isHuman():
									if not pPlayerX.isHumanActive():
									# ]rucivfan_ai_auto_play raap									
										pTeam = gc.getTeam(iTeam)
										for i in xrange(TechInfo.getFirstFreeTechs()):
											Researchable = []
											for iTech in xrange (gc.getNumTechInfos()):
												if pPlayerX.canResearch(iTech, true):
													Researchable.append(iTech)
											if len(Researchable) >= 1:
												FreeTech = CyGame().getSorenRandNum(len(Researchable), "which tech")
												pTeam.changeResearchProgress(Researchable[FreeTech], pTeam.getResearchCost(Researchable[FreeTech]) - pTeam.getResearchProgress(Researchable[FreeTech]), iPlayer)
								if TechInfo.getFirstFreeUnitClass() != -1:
									pCapitalX = pPlayerX.getCapitalCity()
									iFreeUnit = gc.getCivilizationInfo(pPlayerX.getCivilizationType()).getCivilizationUnits(TechInfo.getFirstFreeUnitClass())
									pCapitalX.createGreatPeople(iFreeUnit, false, false)
								break

# ZE: Griechenland End -----------------------------------------------------------------------------------------------
# Financial Trait Start -----------------------------------------------------------------------------------------------
		# pTeam = gc.getTeam(iTeam)
		# bNewEra = true
		# for iTech in xrange(gc.getNumTechInfos()):
			# if pTeam.isHasTech(iTech) and iTech != iTechType:
				# if gc.getTechInfo(iTech).getEra() >= gc.getTechInfo(iTechType).getEra():
					# bNewEra = false
					# break
		# if bNewEra:
			# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				# pPlayerX = gc.getPlayer(iPlayerX)
				# if pPlayerX.isAlive() and pPlayerX.getTeam() == iTeam:
					# if pPlayerX.hasTrait(gc.getInfoTypeForString("TRAIT_FINANCIAL")):
						# if gc.getTechInfo(iTechType).getEra() == gc.getInfoTypeForString("ERA_RENAISSANCE"):
							# for iX in xrange(CyMap().getGridWidth()):
								# for iY in xrange(CyMap().getGridHeight()):	
									# pPlot = CyMap().plot(iX,iY)
									# if pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_COTTAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_HAMLET"))
						# elif gc.getTechInfo(iTechType).getEra() == gc.getInfoTypeForString("ERA_INDUSTRIAL"):
							# for iX in xrange(CyMap().getGridWidth()):
								# for iY in xrange(CyMap().getGridHeight()):	
									# pPlot = CyMap().plot(iX,iY)
									# if pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_COTTAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_VILLAGE"))
									# elif pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_HAMLET") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_VILLAGE"))
						# elif gc.getTechInfo(iTechType).getEra() == gc.getInfoTypeForString("ERA_MODERN"):
							# for iX in xrange(CyMap().getGridWidth()):
								# for iY in xrange(CyMap().getGridHeight()):	
									# pPlot = CyMap().plot(iX,iY)
									# if pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_COTTAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
									# elif pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_HAMLET") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
									# elif pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_VILLAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
						# elif gc.getTechInfo(iTechType).getEra() == gc.getInfoTypeForString("ERA_FUTURE"):
							# for iX in xrange(CyMap().getGridWidth()):
								# for iY in xrange(CyMap().getGridHeight()):	
									# pPlot = CyMap().plot(iX,iY)
									# if pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_COTTAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
									# elif pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_HAMLET") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
									# elif pPlot.getImprovementType() == gc.getInfoTypeForString("IMPROVEMENT_VILLAGE") and pPlot.getOwner() == iPlayerX:
										# pPlot.setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_TOWN"))
# Financial Trait End -----------------------------------------------------------------------------------------------
# Diplomatic Trait End -----------------------------------------------------------------------------------------------
		pTeam = gc.getTeam(iTeam)
		bNewEra = true
		for iTech in xrange(gc.getNumTechInfos()):
			if pTeam.isHasTech(iTech) and iTech != iTechType:
				if gc.getTechInfo(iTech).getEra() >= gc.getTechInfo(iTechType).getEra():
					bNewEra = false
					break
		if bNewEra:
			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				pPlayerX = gc.getPlayer(iPlayerX)
				if pPlayerX.isAlive() and pPlayerX.getTeam() == iTeam:
					if pPlayerX.hasTrait(gc.getInfoTypeForString("TRAIT_DIPLOMATIC")):
						if pPlayerX.getNumCities() > 0:
							capital = pPlayerX.getCapitalCity()
							# pCapital.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_STATESMAN' ), False, False)
							
							# Nur einer zur Zeit - deaktiviert
							# if pPlayerX.getUnitClassCount(gc.getInfoTypeForString("UNITCLASS_GREAT_STATESMAN")) < 1:
							pNewUnit = pPlayerX.initUnit(gc.getInfoTypeForString("UNIT_GREAT_STATESMAN"), capital.getX(), capital.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
# Diplomatic Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion zum Bau von Weltwundern -----------------------------------------------------------------------------------------------
					# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion zum Bau von Weltwundern
					if pPlayerX.hasTrait(gc.getInfoTypeForString("TRAIT_CREATIVE")):
					
						iThreshold = self.iHGA * (pPlayerX.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
						iCurrent = 0

						if SDTK.sdObjectExists( "Kreativ", pPlayerX ): iCurrent = SDTK.sdObjectGetVal( "Kreativ", pPlayerX, 'iCurrent')
						else: SDTK.sdObjectInit('Kreativ', pPlayerX, {})
					
						SDTK.sdObjectSetVal( "Kreativ", pPlayerX, 'iCurrent', iCurrent)
						SDTK.sdObjectSetVal( "Kreativ", pPlayerX, 'iThreshold', iThreshold)
					
						# Alter Code
						# sScript = pPlayerX.getScriptData()
						# sHappy = sScript[:sScript.find("Split")]
						# if sHappy.find("HGA") == -1:
							# iCurrent = 0
							# iThreshold = self.iHGA * (pPlayerX.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
						# else:
							# iCurrent = int(sHappy[:sHappy.find("HGA")])
							# iThreshold = self.iHGA * (pPlayerX.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
							
						# sHappy = str(iCurrent) + "HGA" + str(iThreshold)
						# sScript = sHappy + "Split"
						# pPlayerX.setScriptData(sScript)	
# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion zum Bau von Weltwundern -----------------------------------------------------------------------------------------------	
# ZE: England START DEAKTIVIERT -----------------------------------------------------------------------------------------------
		# pTeam = gc.getTeam(iTeam)
		# bNewEra = true
		# for iTech in xrange(gc.getNumTechInfos()):
			# if pTeam.isHasTech(iTech) and iTech != iTechType:
				# if gc.getTechInfo(iTech).getEra() >= gc.getTechInfo(iTechType).getEra():
					# bNewEra = false
					# break
		# if bNewEra:
			# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				# pPlayerX = gc.getPlayer(iPlayerX)
				# if pPlayerX.isAlive() and pPlayerX.getTeam() == iTeam:					
					# if pPlayerX.getCurrentEra() == gc.getInfoTypeForString("ERA_RENAISSANCE") and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND") and pTeam.isHasTech(gc.getInfoTypeForString("TECH_ENGLAND")):
						# if pPlayerX.isGoldenAge(): iGALengthE = pPlayerX.getGoldenAgeLength()
						# else: iGALengthE = (pPlayerX.getGoldenAgeLength() + 1)
						# pPlayerX.changeGoldenAgeTurns(iGALengthE)
# ZE: England END -----------------------------------------------------------------------------------------------
# Kernspaltung Start -----------------------------------------------------------------------------------------------
#		if iTechType == gc.getInfoTypeForString("TECH_FISSION"):
#			pPlayer = gc.getPlayer(iPlayer)			
#			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#				pPlayerX = gc.getPlayer(iPlayerX)
#				if pPlayerX.isAlive() and pPlayerX.getTeam() == pPlayer.getTeam():
#					pPlayerX.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_COAL_PLANT"), -1)
# Kernspaltung End -----------------------------------------------------------------------------------------------
# Kaltfusion Start -----------------------------------------------------------------------------------------------
		if iTechType == gc.getInfoTypeForString("TECH_COLD_FUSION"):
			pPlayer = gc.getPlayer(iPlayer)
			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				pPlayerX = gc.getPlayer(iPlayerX)
				if pPlayerX.isAlive() and pPlayerX.getTeam() == pPlayer.getTeam():
					pPlayerX.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_COAL_PLANT"), -2)
					pPlayerX.changeExtraBuildingClassHappiness(gc.getInfoTypeForString("BUILDINGCLASS_NUCLEAR_PLANT"), -2)
# Kaltfusion End -----------------------------------------------------------------------------------------------

		# Show tech splash when applicable
		if (iPlayer > -1 and bAnnounce and not CyInterface().noTechSplash()):
			if (gc.getGame().isFinalInitialized() and not gc.getGame().GetWorldBuilderMode()):
				# if ((not gc.getGame().isNetworkMultiPlayer()) and (iPlayer == gc.getGame().getActivePlayer())):
				if (((not gc.getGame().isNetworkMultiPlayer()) or (gc.getActivePlayer() and gc.getActivePlayer().isOption(PlayerOptionTypes.PLAYEROPTION_MP_TECH_SOUNDS_AS_SP))) and (iPlayer == gc.getGame().getActivePlayer())):
					popupInfo = CyPopupInfo()
					popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
					popupInfo.setData1(iTechType)
					popupInfo.setText(u"showTechSplash")
					popupInfo.addPopup(iPlayer)

# Thomas SG - < M.A.D. Nukes Start >
		if (iPlayer > -1):
			if (gc.getTechInfo(iTechType).enablesMADStrategicCommand()):
				gc.getPlayer(iPlayer).setMADStrategicCommandEnabled(true)	
# Thomas SG - < M.A.D. Nukes End >
				
		if (not self.__LOG_TECH):
			return
		CvUtil.pyPrint('%s was finished by Team %d' 
			%(PyInfo.TechnologyInfo(iTechType).getDescription(), iTeam))
	
	def onTechSelected(self, argsList):
		'Tech Selected'
		iTechType, iPlayer = argsList
		if (not self.__LOG_TECH):
			return
		CvUtil.pyPrint('%s was selected by Player %d' %(PyInfo.TechnologyInfo(iTechType).getDescription(), iPlayer))
	
	def onReligionFounded(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Religion Founded'
		iReligion, iFounder = argsList
		player = PyPlayer(iFounder)
		pPlayer = gc.getPlayer(iFounder)
		
		iCityId = gc.getGame().getHolyCity(iReligion).getID()
		if (gc.getGame().isFinalInitialized() and not gc.getGame().GetWorldBuilderMode()):
			if ((not gc.getGame().isNetworkMultiPlayer()) and (iFounder == gc.getGame().getActivePlayer())):
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
				popupInfo.setData1(iReligion)
				popupInfo.setData2(iCityId)
				popupInfo.setData3(1)
				popupInfo.setText(u"showWonderMovie")
				popupInfo.addPopup(iFounder)

		iReligionSlotsTaken = 0
		if gc.getGame().isReligionSlotTaken(0): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(1): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(2): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(3): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(4): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(5): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(6): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(7): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(8): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(9): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(10): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(11): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(12): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(13): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(14): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(15): iReligionSlotsTaken += 1
		if gc.getGame().isReligionSlotTaken(16): iReligionSlotsTaken += 1
				
# Cybah: BASE fr 6.4 C - Autoverbreitung spterer gegrndeter Religionen START -----------------------------------------------------------------------------------------------
		bAutoSpread = False
		iAutoSpreadPercent = 0
		
		# 10% fr die dritte Religion (meistens per Monotheismus)
		if iReligionSlotsTaken == 3:
			bAutoSpread = True
			iAutoSpreadPercent = 10
		
		# 20% fr die vierte Religion (meistens per Gesetzgebung)
		elif iReligionSlotsTaken == 4:
			bAutoSpread = True
			iAutoSpreadPercent = 20
			
		# 30% fr die fnfte Religion (meistens per Philosophie)
		elif iReligionSlotsTaken == 5:
			bAutoSpread = True
			iAutoSpreadPercent = 30
		
		# 40% fr die sechste Religion (meistens per Theologie)
		elif iReligionSlotsTaken == 6:
			bAutoSpread = True
			iAutoSpreadPercent = 40
		
		# 50% fr die siebte Religion (meistens per Gttliches Recht)
		elif iReligionSlotsTaken == 7:
			bAutoSpread = True
			iAutoSpreadPercent = 50
		
		# Stdte zhlen
		if bAutoSpread and iAutoSpreadPercent > 0:
			AutoSpreadCities = []
			pCityAutoSpread, iter = pPlayer.firstCity(false)
			while(pCityAutoSpread):
				if not pCityAutoSpread.isNone() and pCityAutoSpread.getOwner() == iFounder:
					AutoSpreadCities.append(pCityAutoSpread)
				pCityAutoSpread, iter = pPlayer.nextCity(iter, false)
			
			# Zhlung aller fr die Autoverbreitung erlaubten Stdte
			iAutoSpreadCities = (len(AutoSpreadCities) * iAutoSpreadPercent / 100)
			
			# # Zufllige Auswahl von x = iAutoSpreadCities Stdten fr die Autoverbreitung // VERURSACHT OOS WOHL WEGEN DER RANDOM CHOICE FUNKTION
			# # if iAutoSpreadCities >= 1:
				# # for iAutoSpreadCity in xrange(iAutoSpreadCities):
					# # pCityChosen = random.choice(AutoSpreadCities)
					# # AutoSpreadCities.remove(pCityChosen)
					# # pCityChosen.setHasReligion(iReligion,True,True,True)

			# # - Alte Auswahlmethode (ging nach Grndungsreihenfolge, nicht zufllig) // FUNKTIONIERT, ABER NICHT OPTIMAL	
			# if iAutoSpreadCities >= 1:
				# iAutoToSpread = iAutoSpreadCities
				# pCityAutoSpread2, iter = pPlayer.firstCity(false)
				# while(pCityAutoSpread2):
					# # Wenn Stdte noch Autoverbreitung bekommen drfen
					# if not pCityAutoSpread2.isNone() and not pCityAutoSpread2.isHasReligion(iReligion) and pCityAutoSpread2.getOwner() == iFounder and iAutoToSpread >= 1:
						# pCityAutoSpread2.setHasReligion(iReligion,True,True,True)
						# iAutoToSpread -= 1
					# pCityAutoSpread2, iter = pPlayer.nextCity(iter, false)
					
			# - Neuer Versuch - Zufallsschleife
			if iAutoSpreadCities >= 1:
				iX = 0
				while(iX < iAutoSpreadCities):
					iX += 1
					iReliSpreadCity = CyGame().getSorenRandNum(len(AutoSpreadCities), "Stadtwahl")
					AutoSpreadCities[iReliSpreadCity].setHasReligion(iReligion,True,True,True)
					AutoSpreadCities.remove(AutoSpreadCities[iReliSpreadCity])
		
# Cybah: BASE fr 6.4 C - Autoverbreitung spterer gegrndeter Religionen END -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 B - ZE: Indonesien START -----------------------------------------------------------------------------------------------
		# Autoverbreitung der ersten gegrndeten Religion in der Hauptstadt anstelle Freimystik
		if not gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_CIV_TRAITS):
			if iReligionSlotsTaken == 1:
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
						pCapitalX = pPlayerX.getCapitalCity()
						if pCapitalX: pCapitalX.setHasReligion(iReligion,True,True,True)
# Cybah: BASE fr 6.3 B - ZE: Indonesien START -----------------------------------------------------------------------------------------------
		
		if (not self.__LOG_RELIGION):
			return
		CvUtil.pyPrint('Player %d Civilization %s has founded %s'
			%(iFounder, player.getCivilizationName(), gc.getReligionInfo(iReligion).getDescription()))

	def onReligionSpread(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Religion Has Spread to a City'
		iReligion, iOwner, pSpreadCity = argsList
		player = PyPlayer(iOwner)

# Cybah: BASE fr 6.1 E - ZE: Arabien Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.3 C (ersetzt durch anderen SDK Effekt)
		# pPlayer = gc.getPlayer(pSpreadCity.getOwner())
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ARABIA")):
			# if iReligion == pPlayer.getStateReligion():
			
				# if not SDTK.sdObjectExists( "Arab", pSpreadCity ):
					# SDTK.sdObjectInit('Arab', pSpreadCity, {})
					# #sVal = "ARABPLAYER" + pPlayer.getID()
					# #SDTK.sdObjectSetVal( "Arab", pSpreadCity, 'sHasRecruitedPlayer', sVal)

				# sScript = pSpreadCity.getScriptData()
				# sTest = str("ArabID") + str(pPlayer.getID())
				# if sScript.find(sTest) == -1:
				
					# sVal = str(SDTK.sdObjectGetVal( "Arab", pSpreadCity, 'sHasRecruitedPlayers' )) + str("ArabID") + str(pPlayer.getID())
					# SDTK.sdObjectSetVal( "Arab", pSpreadCity, 'sHasRecruitedPlayers', sVal)
					
					# pUnitID = pSpreadCity.getConscriptUnit(false)	# true fr keine reinen Verteidigungseinheiten
					# pNewUnit = pPlayer.initUnit( pUnitID, pSpreadCity.getX(), pSpreadCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
					# pSpreadCity.addProductionExperience(pNewUnit, false)
# Cybah: BASE fr 6.1 E - ZE: Arabien End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has spread to Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pSpreadCity.getName()))

	def onReligionRemove(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Religion Has been removed from a City'
		iReligion, iOwner, pRemoveCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has been removed from Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pRemoveCity.getName()))
				
	def onCorporationFounded(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Corporation Founded'
		iCorporation, iFounder = argsList
		player = PyPlayer(iFounder)
		
		if (not self.__LOG_RELIGION):
			return
		CvUtil.pyPrint('Player %d Civilization %s has founded %s'
			%(iFounder, player.getCivilizationName(), gc.getCorporationInfo(iCorporation).getDescription()))

	def onCorporationSpread(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Corporation Has Spread to a City'
		iCorporation, iOwner, pSpreadCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has spread to Player %d Civilization %s city of %s'
			%(gc.getCorporationInfo(iCorporation).getDescription(), iOwner, player.getCivilizationName(), pSpreadCity.getName()))

	def onCorporationRemove(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Corporation Has been removed from a City'
		iCorporation, iOwner, pRemoveCity = argsList
		player = PyPlayer(iOwner)
		if (not self.__LOG_RELIGIONSPREAD):
			return
		CvUtil.pyPrint('%s has been removed from Player %d Civilization %s city of %s'
			%(gc.getReligionInfo(iReligion).getDescription(), iOwner, player.getCivilizationName(), pRemoveCity.getName()))
				
	def onGoldenAge(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Golden Age'
		iPlayer = argsList[0]
		player = PyPlayer(iPlayer)
		pPlayer = gc.getPlayer(iPlayer)

# test - wurde vorher nur ausgefhrt, wenn man nicht bereits im GA ist - seit 6.0 gehts auch so
#		if pPlayer.isAlive() and pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CREATIVE")):
#		pCapital = pPlayer.getCapitalCity()
#		pCapital.createGreatPeople(gc.getInfoTypeForString( 'UNIT_ENGINEER' ), False, False)
# test
# Anthems Start -----------------------------------------------------------------------------------------------

		# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ANTHEMS):

		pActivePlayer = gc.getActivePlayer()
		if pActivePlayer:
			if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()) and pActivePlayer.isOption(PlayerOptionTypes.PLAYEROPTION_ANTHEMS):

				#CyInterface().addMessage(iNewOwner,false,15,CyTranslator().getText("TXT_KEY_ANTHEM_CITY_CONQUER",( pCity.getName(), PyHelpers.PyInfo.BuildingInfo(iUniqueBuilding).getDescription() , PyHelpers.PyInfo.BuildingInfo(iDefaultBuilding).getDescription() )),'',0,gc.getBuildingInfo(iUniqueBuilding).getButton(),ColorTypes(11),pCity.getX(),pCity.getY(),True,True)

				#strMessageAnthem = CyTranslator().getText("TXT_KEY_BUILDING_FORTKNOX_WINNER", (ppPlayer.getName(), (iConquestGold)))
				#CyInterface().addMessage(pPlayer.getID(), True, 20, strMessageAnthem, "AS2D_ANTHEM_AEGYPTEN", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), iX, iY, True, True)

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_AMERICA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ARABIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_AUSTRIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AZTEC"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_AZTEC")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_BABYLON")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_BERBER")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_BRAZIL")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_BYZANTIUM")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_CARIBBEAN")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_CARTHAGE")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_CELT")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_CHINA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_EGYPT")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ENGLAND")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ETHIOPIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_FRANCE")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_GERMANY")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_GREECE")
				
				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_HITTITE")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_HOLY_ROMAN")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_HUNGARY")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_INCA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_INDIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_INDONESIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ISRAEL")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_JAPAN")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_KHMER")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_KOREA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_MALI")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_MAYA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_MONGOL")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_NATIVE_AMERICA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_NETHERLANDS")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_OTTOMAN")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_PERSIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLAND"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_POLAND")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_POLYNESIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_PORTUGAL")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ROME")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_RUSSIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCOTLAND"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_SCOTLAND")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCYTHS"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_SCYTHS")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_SPAIN")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SUMERIA"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_SUMERIA")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_TIBET"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_TIBET")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_VIKING")

				if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU"):
					CyAudioGame().Play2DSound("AS2D_ANTHEM_ZULU")

# Anthems End -----------------------------------------------------------------------------------------------
# ZE: China 3/3 Start -----------------------------------------------------------------------------------------------
		if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_CHINA")):
			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
				capitalZE = pPlayer.getCapitalCity()
				capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), False, False)

# Falls GZ im Team geteilt werden (obige drei Zeilen mssen dann deaktiviert werden):						
#			for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#				pPlayerX = gc.getPlayer(iPlayerX)
#				if pPlayerX.isAlive() and pPlayerX.getTeam() == pPlayer.getTeam():
#					if pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
#						capitalZE = pPlayerX.getCapitalCity()
#						capitalZE.createGreatPeople(gc.getInfoTypeForString( 'UNIT_GREAT_GENERAL' ), False, False)
# ZE: China 3/3 End -----------------------------------------------------------------------------------------------
# Repressive Trait Start - BASE 6.1 ----------------------------------------------------------------------------------------------- DEAKTIVIERT MIT 6.1 F (jetzt franzsische Ziveigenschaft)
		# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_REPRESSIVE")):
# Cybah: BASE fr 6.1 F - ZE: Frankreich START -----------------------------------------------------------------------------------------------
		if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_FRANCE")):
			if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
				pPopTeam = gc.getTeam(pPlayer.getTeam())
				iGlobalWW = 0
				for iTeam in xrange(gc.getMAX_CIV_TEAMS()):
					iGlobalWW += pPopTeam.getWarWeariness(iTeam)
					iWarW = pPopTeam.getWarWeariness(iTeam)
					pPopTeam.setWarWeariness(iTeam, (iWarW /2))
				if iGlobalWW > 1:
					pCapital = pPlayer.getCapitalCity()
					strMessage = CyTranslator().getText("TXT_KEY_TRAIT_REPRESSIVE_WW_REDUCED", (iGlobalWW, (iGlobalWW)))
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, '', 0,'Art/Interface/Buttons/General/happy_person.dds', ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), pCapital.getX(), pCapital.getY(), True, True)
# Cybah: BASE fr 6.1 F - ZE: Frankreich END -----------------------------------------------------------------------------------------------
# Repressive Trait Start - BASE 6.1 -----------------------------------------------------------------------------------------------
# Populist Trait Start - BASE 6.0 c -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_POPULIST")):
			iPopGoldTotal = 0
			pCityPop, iter = pPlayer.firstCity(false)
			while(pCityPop):
				if pCityPop.getOwner() == pPlayer.getID() and pCityPop.getPopulation() > 0 and not pCityPop.isNone() and not pCityPop.isWeLoveTheKingDay():
					pCityPop.setWeLoveTheKingDay(true)
					iPopGoldTotal += pCityPop.getPopulation()
					# Cybah: BASE fr 6.1 D - Vier statt zwei einzelne Berechnungen fr weniger Random Spitzen
					iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
					iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCityPop.getPopulation())))
				pCityPop, iter = pPlayer.nextCity(iter, false)
					
			if iPopGoldTotal > 0:
				iGoldFaktor = 4
				if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PRINTING_PRESS")):
					iGoldFaktor += 1
				if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MASS_MEDIA")):
					iGoldFaktor += 1
				iPopGoldTotal *= iGoldFaktor
				iPopGoldTotal /= 4
					
				#Fr 6.1 E - 50% mehr Gold
				iPopGoldTotal *= 4
				iPopGoldTotal /= 2
				
				#Spielgeschwindigkeitsmodifikator
				iPopGoldTotal = (iPopGoldTotal * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getGreatPeoplePercent() / 100)
				
				pPlayer.changeGold(iPopGoldTotal)
				pCapital = pPlayer.getCapitalCity()
				strMessage = CyTranslator().getText("TXT_KEY_TRAIT_POP_GET_GOLD_NATIONAL", (iPopGoldTotal, (iPopGoldTotal)))
				CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCapital.getX(), pCapital.getY(), True, True)
# Populist Trait End - BASE 6.0 c -----------------------------------------------------------------------------------------------

		if (not self.__LOG_GOLDENAGE):
			return
		CvUtil.pyPrint('Player %d Civilization %s has begun a golden age'
			%(iPlayer, player.getCivilizationName()))

	def onEndGoldenAge(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'End Golden Age'
		iPlayer = argsList[0]
		player = PyPlayer(iPlayer)
		if (not self.__LOG_ENDGOLDENAGE):
			return
		CvUtil.pyPrint('Player %d Civilization %s golden age has ended'
			%(iPlayer, player.getCivilizationName()))

	def onChangeWar(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'War Status Changes'
		bIsWar = argsList[0]
		iTeam = argsList[1]
		iRivalTeam = argsList[2]

		if bIsWar:
			pTeam2 = gc.getTeam(iRivalTeam)
# ZE: Frankreich Start -----------------------------------------------------------------------------------------------
#			if pTeam2.isHasTech(gc.getInfoTypeForString("TECH_FRANCE")) and pTeam2.isHasTech(gc.getInfoTypeForString("TECH_NATIONALISM")):
#
#				estiEnd = CyGame().getEstimateEndTurn()
#				if estiEnd >= 1000:
#					iRoundsAndMalus = 16	
#				elif estiEnd >= 700:
#					iRoundsAndMalus = 10
#				elif estiEnd >= 500:
#					iRoundsAndMalus = 8
#				elif estiEnd >= 300:
#					iRoundsAndMalus = 6
#
#				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
#					pPlayerX = gc.getPlayer(iPlayerX)
#					if pPlayerX.getTeam() == iRivalTeam and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
#
#						for iPlayerY in xrange(gc.getMAX_CIV_PLAYERS()):
#							pPlayerY = gc.getPlayer(iPlayerY)
#							if pPlayerY.getTeam() == iTeam:
#								(loopCityY, iter) = pPlayerY.firstCity(false)
#								while(loopCityY):
#									if loopCityY.getEspionageHappinessCounter() < 1 or loopCityY.getEspionageHealthCounter() < 1:
#
#										if loopCityY.getEspionageHappinessCounter() < 1 and loopCityY.getEspionageHealthCounter() < 1:
#											loopCityY.changeEspionageHappinessCounter(iRoundsAndMalus)
#											loopCityY.changeEspionageHealthCounter(iRoundsAndMalus)
#
#										elif loopCityY.getEspionageHappinessCounter() < 1:
#											loopCityY.changeEspionageHappinessCounter(iRoundsAndMalus)
#
#										elif loopCityY.getEspionageHealthCounter() < 1:
#											loopCityY.changeEspionageHealthCounter(iRoundsAndMalus)
#
#									(loopCityY, iter) = pPlayerY.nextCity(iter, false)
# ZE: Frankreich End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - Tote Hand (vorher ZE: Israel) Start -----------------------------------------------------------------------------------------------
			if pTeam2.getProjectCount(gc.getInfoTypeForString("PROJECT_DEAD_HAND")) > 0 and not gc.getGame().isVotePassed(gc.getInfoTypeForString("VOTE_NO_NUKES")):
				for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
					pPlayerX = gc.getPlayer(iPlayerX)
					if pPlayerX.getTeam() == iRivalTeam:
						for iPlayerY in xrange(gc.getMAX_CIV_PLAYERS()):
							pPlayerY = gc.getPlayer(iPlayerY)
							if pPlayerY.getTeam() == iTeam:
								citychance = CyGame().getSorenRandNum(pPlayerY.getNumCities(), "which city")
								i = 0
								(loopCity, iter) = pPlayerY.firstCity(false)
								while(loopCity):
									if i == citychance:
										break
									i += 1
									(loopCity, iter) = pPlayerY.nextCity(iter, false)
								if loopCity:
									if pTeam2.isHasTech(gc.getInfoTypeForString("TECH_FUSION")):
										pXCity = pPlayerX.getCapitalCity()
										pNukeUnit = pPlayerX.initUnit( gc.getInfoTypeForString("UNIT_ICBFM"), pXCity.getX(), pXCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
										pPlot = loopCity.plot()
										CyEngine().triggerEffect(gc.getInfoTypeForString("EFFECT_ICBM_NUCLEAR_EXPLOSION"), pPlot.getPoint())
										pPlot.nukeExplosion(pNukeUnit.nukeRange(), pNukeUnit)
										pPlot.nukeExplosion(pNukeUnit.nukeRange(), pNukeUnit)
										pNukeUnit.kill(0, -1)
										pPlayerY.AI_changeMemoryCount(iPlayerX, MemoryTypes.MEMORY_NUKED_US, 1)
									else:
										pXCity = pPlayerX.getCapitalCity()
										pNukeUnit = pPlayerX.initUnit( gc.getInfoTypeForString("UNIT_ICBM"), pXCity.getX(), pXCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
										pPlot = loopCity.plot()
										CyEngine().triggerEffect(gc.getInfoTypeForString("EFFECT_ICBM_NUCLEAR_EXPLOSION"), pPlot.getPoint())
										pPlot.nukeExplosion(pNukeUnit.nukeRange(), pNukeUnit)
										pPlot.nukeExplosion(pNukeUnit.nukeRange(), pNukeUnit)
										pNukeUnit.kill(0, -1)
										pPlayerY.AI_changeMemoryCount(iPlayerX, MemoryTypes.MEMORY_NUKED_US, 1)
# Cybah: BASE fr 6.3 C - Tote Hand End -----------------------------------------------------------------------------------------------

		if (not self.__LOG_WARPEACE):
			return
		if (bIsWar):
			strStatus = "declared war"
		else:
			strStatus = "declared peace"
		CvUtil.pyPrint('Team %d has %s on Team %d'
			%(iTeam, strStatus, iRivalTeam))
	
	def onChat(self, argsList):
		'Chat Message Event'
		chatMessage = "%s" %(argsList[0],)
		
	def onSetPlayerAlive(self, argsList):
		'Set Player Alive Event'
		iPlayerID = argsList[0]
		bNewValue = argsList[1]
		CvUtil.pyPrint("Player %d's alive status set to: %d" %(iPlayerID, int(bNewValue)))
		
	def onPlayerChangeStateReligion(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'Player changes his state religion'
		iPlayer, iNewReligion, iOldReligion = argsList
		pPlayer = gc.getPlayer(iPlayer)
		
# Cybah: BASE fr 6.2 A - Spiritual Trait START ----------------------------------------------------------------------------------------------- DEAKTIVIERT (stattdessen in CvCity.cpp hhere Chance)
		# if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_SPIRITUAL")):
			# if iNewReligion != -1:
				# if pPlayer.getStateReligion() == iNewReligion:
				
					# pCity, iter = pPlayer.firstCity(false)  
					# while(pCity):	  
						# if pCity.getOwner() == pPlayer.getID() and not pCity.isNone():
							# iRelis = 0
							# for i in xrange(gc.getNumReligionInfos()):
								# if pCity.isHasReligion(i):
									# iRelis += 1
									# break
							# if iRelis < 1: pCity.setHasReligion(iNewReligion,True,True,True)
						# pCity, iter = pPlayer.nextCity(iter, false)
# Cybah: BASE fr 6.2 A - Spiritual Trait END -----------------------------------------------------------------------------------------------
		
	def onPlayerGoldTrade(self, argsList):
		'Player Trades gold to another player'
		iFromPlayer, iToPlayer, iGoldAmount = argsList

	def onCityBuilt(self, argsList):
		'City Built'
		city = argsList[0]
		player = PyPlayer(city.getOwner())
		pPlayer = gc.getPlayer(city.getOwner())
		iPlayer = pPlayer.getID()
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		iPalace = gc.getInfoTypeForString("BUILDING_PALACE")

# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung START
		if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_NO_STARTING_TECHS) and city.getNumActiveBuilding(iPalace):
			# rucivfan_ai_auto_play raap[
			#if pPlayer.isHuman():
			if pPlayer.isHumanActive():
			# ]rucivfan_ai_auto_play raap
				self.starttechpopup(iPlayer, iTeam)
				
			else:
				iXPlayerNum = 0
				for iXPlayer in xrange(gc.getMAX_CIV_PLAYERS()):
					pXPlayer = gc.getPlayer(iXPlayer)
					if pXPlayer.isAlive() and pXPlayer.getTeam() == pPlayer.getTeam():
						iXPlayerNum += 1
			
				pPlot = city.plot(); iFischen = 0; iLawi = 0; iJagd = 0; iBergbau = 0; iRad = 0; iWald = 0
				if pPlot.isRiver():
					iFischen += 1
					iLawi += 1
				iX = city.getX()
				iY = city.getY()
				
				for iXLoop in xrange(iX - 2, iX + 3, 1):
					for iYLoop in xrange(iY - 2, iY + 3, 1):
						pPlotX = CyMap().plot(iXLoop, iYLoop)
						if city.isCoastal(10) and (pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_CLAM') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_CRAB') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_FISH') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_SHRIMP') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_PEARLS')):
							iFischen += 1
						if pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_DEER') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_FUR') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_IVORY') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_RABBIT') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_SEALION'):
							iJagd += 1
						if pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_CORN') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_RICE') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_WHEAT'):
							iLawi += 1
						if pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_BISON') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_COW') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_HORSE') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_PIG') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_SHEEP'):
							iLawi += 1
							iJagd += 1
						if not pPlot.isRiver() or not pPlotX.isRiver():
							if pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_HORSE'):
								iRad += 1
							elif pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_STONE'):
								iRad += 1
						if pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_GEMS') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_GOLD') or pPlotX.getBonusType(pPlayer.getTeam()) == gc.getInfoTypeForString('BONUS_SILVER'):
							iBergbau += 1
						if pPlotX.getFeatureType() == gc.getInfoTypeForString('FEATURE_FOREST') or pPlotX.getFeatureType() == gc.getInfoTypeForString('FEATURE_SAVANNA'):
							iWald += 1
				iBergbau += (iWald / 4)
				if pTeam.isHasTech(gc.getInfoTypeForString('TECH_ARCHERY')):
					iJagd += 2
			
				# Auswertung
				iBest1 = iFischen
				iBest1Tech = gc.getInfoTypeForString('TECH_FISHING')
				if iBergbau > iBest1:
					iBest1 = iBergbau
					iBest1Tech = gc.getInfoTypeForString('TECH_MINING')
					iBest2 = iFischen
					iBest2Tech = gc.getInfoTypeForString('TECH_FISHING')
				else:
					iBest2 = iBergbau
					iBest2Tech = gc.getInfoTypeForString('TECH_MINING')
				if iLawi > iBest1:
					iBest1 = iLawi
					iBest1Tech = gc.getInfoTypeForString('TECH_AGRICULTURE')
				elif iLawi > iBest2:
					iBest2 = iLawi
					iBest2Tech = gc.getInfoTypeForString('TECH_AGRICULTURE')
				if iJagd > iBest1:
					iBest1 = iJagd
					iBest1Tech = gc.getInfoTypeForString('TECH_HUNTING')
				elif iJagd > iBest2:
					iBest2 = iJagd
					iBest2Tech = gc.getInfoTypeForString('TECH_HUNTING')
				if iRad > iBest1:
					iBest1 = iRad
					iBest1Tech = gc.getInfoTypeForString('TECH_THE_WHEEL')
				elif iRad > iBest2:
					iBest2 = iRad
					iBest2Tech = gc.getInfoTypeForString('TECH_THE_WHEEL')
				
				iTechsResearched = 0
				if iBest1Tech and not pTeam.isHasTech(iBest1Tech):
					iTechCost = pTeam.getResearchCost(iBest1Tech)
					iTechsResearched += 1
					pTeam.changeResearchProgress(iBest1Tech, (iTechCost / iXPlayerNum), iPlayer)
					if (pTeam.getResearchCost(iBest1Tech) - pTeam.getResearchProgress(iBest1Tech)) == 1: pTeam.changeResearchProgress(iBest1Tech, 1, iPlayer)
					
				if iBest2Tech and not pTeam.isHasTech(iBest2Tech):
					iTechCost2 = pTeam.getResearchCost(iBest2Tech)
					iTechsResearched += 1
					pTeam.changeResearchProgress(iBest2Tech, (iTechCost2 / iXPlayerNum), iPlayer)
					if (pTeam.getResearchCost(iBest2Tech) - pTeam.getResearchProgress(iBest2Tech)) == 1: pTeam.changeResearchProgress(iBest2Tech, 1, iPlayer)
				
				if iTechsResearched < 2:
					iTechsToResearch = (2 - iTechsResearched)
					if iTechsToResearch > 0:
						for k in xrange(iTechsToResearch):
						
							if not pTeam.isHasTech(gc.getInfoTypeForString('TECH_MINING')):
								iTechCost3 = pTeam.getResearchCost(gc.getInfoTypeForString('TECH_MINING'))
								pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_MINING'), (iTechCost3 / iXPlayerNum), iPlayer)
								if (pTeam.getResearchCost(gc.getInfoTypeForString('TECH_MINING')) - pTeam.getResearchProgress(gc.getInfoTypeForString('TECH_MINING'))) == 1: pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_MINING'), 1, iPlayer)
						
							elif not pTeam.isHasTech(gc.getInfoTypeForString('TECH_HUNTING')):
								iTechCost3 = pTeam.getResearchCost(gc.getInfoTypeForString('TECH_HUNTING'))
								pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_HUNTING'), (iTechCost3 / iXPlayerNum), iPlayer)
								if (pTeam.getResearchCost(gc.getInfoTypeForString('TECH_HUNTING')) - pTeam.getResearchProgress(gc.getInfoTypeForString('TECH_HUNTING'))) == 1: pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_HUNTING'), 1, iPlayer)
						
							elif not pTeam.isHasTech(gc.getInfoTypeForString('TECH_AGRICULTURE')):
								iTechCost3 = pTeam.getResearchCost(gc.getInfoTypeForString('TECH_AGRICULTURE'))
								pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_AGRICULTURE'), (iTechCost3 / iXPlayerNum), iPlayer)
								if (pTeam.getResearchCost(gc.getInfoTypeForString('TECH_AGRICULTURE')) - pTeam.getResearchProgress(gc.getInfoTypeForString('TECH_AGRICULTURE'))) == 1: pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_AGRICULTURE'), 1, iPlayer)
						
							elif not pTeam.isHasTech(gc.getInfoTypeForString('TECH_FISHING')):
								iTechCost3 = pTeam.getResearchCost(gc.getInfoTypeForString('TECH_FISHING'))
								pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_FISHING'), (iTechCost3 / iXPlayerNum), iPlayer)
								if (pTeam.getResearchCost(gc.getInfoTypeForString('TECH_FISHING')) - pTeam.getResearchProgress(gc.getInfoTypeForString('TECH_FISHING'))) == 1: pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_FISHING'), 1, iPlayer)
						
							elif not pTeam.isHasTech(gc.getInfoTypeForString('TECH_THE_WHEEL')):
								iTechCost3 = pTeam.getResearchCost(gc.getInfoTypeForString('TECH_THE_WHEEL'))
								pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_THE_WHEEL'), (iTechCost3 / iXPlayerNum), iPlayer)
								if (pTeam.getResearchCost(gc.getInfoTypeForString('TECH_THE_WHEEL')) - pTeam.getResearchProgress(gc.getInfoTypeForString('TECH_THE_WHEEL'))) == 1: pTeam.changeResearchProgress(gc.getInfoTypeForString('TECH_THE_WHEEL'), 1, iPlayer)
						
# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung END
# Palast TEST
		# if city.getNumActiveBuilding(iPalace): self.triggerPalace(iPlayer)
# Palast TEST		
# Expansive Trait Start -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_EXPANSIVE")):
		
			# Freie Karte
			pPlot = city.plot()
			pPlayer.receiveGoody(pPlot, gc.getInfoTypeForString("GOODY_MAP"), CyUnit())

			# if city.getNumActiveBuilding(iPalace):
			city.changePopulation(1)

#			iGoodyGet = self.getRandomNumber( 100 )
#			if iGoodyGet < 25:
#				Goody = []
#				pUnit = pPlayer.getUnit(gc.getInfoTypeForString("UNIT_SCOUT"))
#				pPlot = city.plot()
#				for iGoody in xrange(gc.getNumGoodyInfos()):
#					if pPlayer.canReceiveGoody(pPlot, iGoody, pUnit) and iGoody != gc.getInfoTypeForString("GOODY_SETTLER") and iGoody != gc.getInfoTypeForString("GOODY_WORKER") and iGoody != gc.getInfoTypeForString("GOODY_EXPERIENCE") and iGoody != gc.getInfoTypeForString("GOODY_HEALING") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_WEAK") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_ARCHER") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_SPEARMAN") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_AXEMAN"):
#						Goody.append(iGoody)
#				if len(Goody) > 0:
#					pPlayer.receiveGoody(pPlot, Goody[CyGame().getSorenRandNum(len(Goody), "Which Goody")], pUnit)
# Expansive Trait End -----------------------------------------------------------------------------------------------
# Industrious Trait Start -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")):
			city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FORGE"), YieldTypes.YIELD_PRODUCTION, 2)
			# city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_LEVEE"), YieldTypes.YIELD_PRODUCTION, 2)
			city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FACTORY"), YieldTypes.YIELD_PRODUCTION, 2)
			city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_INDUSTRIAL_PARK"), YieldTypes.YIELD_PRODUCTION, 2)
# Industrious Trait End -----------------------------------------------------------------------------------------------
# Financial Trait Start -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_FINANCIAL")):
			city.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_MARKET"), CommerceTypes.COMMERCE_GOLD, 1)
			city.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), CommerceTypes.COMMERCE_GOLD, 1)
			city.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_BANK"), CommerceTypes.COMMERCE_GOLD, 1)
# Financial Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.4 A - Militant Trait Start -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_MILITANT")):
			city.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_MILITARY_ACADEMY"), CommerceTypes.COMMERCE_RESEARCH, 2)
# Cybah: BASE fr 6.4 A - Militant Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - ZE: Griechenland Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
			iTechZEGREECE = gc.getInfoTypeForString("TECH_GREECE")
			if pTeam.isHasTech(iTechZEGREECE):
				city.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_ACADEMY"), CommerceTypes.COMMERCE_RESEARCH, 6)
# Cybah: BASE fr 6.1 E - ZE: Griechenland End -----------------------------------------------------------------------------------------------
# Niederlande Deich Start -----------------------------------------------------------------------------------------------
		if city.isCoastal(-1):
			pCityPlot = city.plot()
			if not pCityPlot.isRiver(): city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_LEVEE"), YieldTypes.YIELD_FOOD, -1)
# Niederlande Deich End -----------------------------------------------------------------------------------------------
# Artistic Trait Start ----------------------------------------------------------------------------------------------- 
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_ARTISTIC")):
			estiEnd = CyGame().getEstimateEndTurn()
			if estiEnd >= 1000:
				if city.getCulture(iPlayer) < 30:
					pCC2 = int(30 - city.getCulture(iPlayer))
					city.changeCulture(iPlayer, pCC2, true)
			elif estiEnd >= 700:
				if city.getCulture(iPlayer) < 15:
					pCC2 = int(15 - city.getCulture(iPlayer))
					city.changeCulture(iPlayer, pCC2, true)
			elif estiEnd >= 500:
				if city.getCulture(iPlayer) < 10:
					pCC2 = int(10 - city.getCulture(iPlayer))
					city.changeCulture(iPlayer, pCC2, true)
			elif estiEnd >= 300:
				if city.getCulture(iPlayer) < 5:
					pCC2 = int(5 - city.getCulture(iPlayer))
					city.changeCulture(iPlayer, pCC2, true)
			elif estiEnd < 300:
				if city.getCulture(iPlayer) < 5:
					pCC2 = int(5 - city.getCulture(iPlayer))
					city.changeCulture(iPlayer, pCC2, true)
# Artistic Trait End -----------------------------------------------------------------------------------------------
# ZE: Japan 2/3 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
#			iTechZEJA1 = gc.getInfoTypeForString("TECH_JAPAN")
#			if pTeam.isHasTech(iTechZEJA1):
#				iTechZEJA2 = gc.getInfoTypeForString("TECH_ASSEMBLY_LINE")
#				if pTeam.isHasTech(iTechZEJA2):
#					iFabrikKlasse = gc.getInfoTypeForString("BUILDINGCLASS_FACTORY") 
#					city.changeNumCivilizationBuildingPossible(iFabrikKlasse, 1, False)
# ZE: Japan 2/3 End -----------------------------------------------------------------------------------------------
# ZE: Khmer 2/5 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
#			iTechZEKHM1 = gc.getInfoTypeForString("TECH_KHMER")
#			if pTeam.isHasTech(iTechZEKHM1):
#				iTechZEKHM2 = gc.getInfoTypeForString("TECH_CONSTITUTION")
#				if pTeam.isHasTech(iTechZEKHM2):
#					iJailClass = gc.getInfoTypeForString("BUILDINGCLASS_JAIL") 
#					city.changeNumCivilizationBuildingPossible(iJailClass, 1, False)
# ZE: Khmer 2/5 End -----------------------------------------------------------------------------------------------
# ZE: Karthago Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
#			iTechZECA = gc.getInfoTypeForString("TECH_CARTHAGE")
#			if pTeam.isHasTech(iTechZECA):
#				if city.getNumActiveBuilding(iPalace): 
#					city.changeExtraTradeRoutes(1)
# ZE: Karthago End -----------------------------------------------------------------------------------------------
# ZE: Inka 3/3 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
#			iTechZEINCA = gc.getInfoTypeForString("TECH_INCA")
#			if pTeam.isHasTech(iTechZEINCA):
#				if city.getNumActiveBuilding(iPalace):
#					city.changeFreeBonus(gc.getInfoTypeForString("BONUS_GOLD"), 1)
# ZE: Inka 3/3 End -----------------------------------------------------------------------------------------------
# ZE: Khmer 3/5 End -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
			iTechZEKHMER = gc.getInfoTypeForString("TECH_KHMER")
			if pTeam.isHasTech(iTechZEKHMER):
			
				# 6.2 D - MONASTERY mit TEMPLE getauscht (hier wurde aus TEMPLE MONASTERY)
				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

# ------------------------------------

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if city.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					city.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Khmer 3/5 End -----------------------------------------------------------------------------------------------

# Mehr Palastkommerz START -----------------------------------------------------------------------------------------------
		iBonusPalaceCommerce = 0
		# 6.4 C - Kommerzbonus fr Rad
		if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
			iBonusPalaceCommerce += 2
			
		# ZE: Byzanz 3/4 Start ----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
			iTechZEBY = gc.getInfoTypeForString("TECH_BYZANTIUM")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEBY):
			
				# Nichthauptstdte zhlen
				iNonCapCities= 0
				pNumCity, iter = pPlayer.firstCity(false)  
				while(pNumCity):	  
					if pNumCity.getOwner() == pPlayer.getID() and not pNumCity.isNone() and not pNumCity.isCapital():
						iNonCapCities += 1
						# Bonus temporr auf 0 setzen
						pNumCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, 0)
					pNumCity, iter = pPlayer.nextCity(iter, false)
			
				# Eigenschaft: +2 immer und +1 fr jede weitere Stadt
				iByzBonus = (2 + iNonCapCities)
				iBonusPalaceCommerce += iByzBonus
		# ZE: Byzanz 3/4 End ----------------------------------------------------------------------------------------------

		# Palastkommerzbonus in allen Stdten einstellen
		pCityPalaceCommerce, iter = pPlayer.firstCity(false)  
		while(pCityPalaceCommerce):	  
			if pCityPalaceCommerce.getOwner() == pPlayer.getID() and not pCityPalaceCommerce.isNone():
				pCityPalaceCommerce.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, iBonusPalaceCommerce)
			pCityPalaceCommerce, iter = pPlayer.nextCity(iter, false)
# Mehr Palastkommerz END -----------------------------------------------------------------------------------------------

# Cybah: BASE fr 6.1 F - ZE: Hethiter Start ----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
			iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHET):

				if not SDTK.sdObjectExists("Hitti", pPlayer):
					SDTK.sdObjectInit('Hitti', pPlayer, {})
					SDTK.sdObjectSetVal("Hitti", pPlayer, 'Slaves', 0)
					
				if not SDTK.sdObjectExists("Hitti", city):
					SDTK.sdObjectInit('Hitti', city, {})
					if city.isCapital():
						SDTK.sdObjectSetVal("Hitti", city, 'iHasSlavesPlayer', pPlayer.getID())
					else:
						SDTK.sdObjectSetVal("Hitti", city, 'iHasSlavesPlayer', -1)
				
				pHetCapital = pPlayer.getCapitalCity()
				if not pHetCapital.isNone():
					SDTK.sdObjectSetVal("Hitti", pHetCapital, 'iHasSlavesPlayer', pPlayer.getID())
					
					# Stdte zhlen
					iCities = 0
					pCityHet, iter = pPlayer.firstCity(false)
					while(pCityHet):
						if pCityHet.getOwner() == pPlayer.getID() and not pCityHet.isNone():
							iCities += 1
							if not SDTK.sdObjectExists("Hitti", pCityHet):
								SDTK.sdObjectInit('Hitti', pCityHet, {})
								if not pCityHet.isCapital(): SDTK.sdObjectSetVal("Hitti", pCityHet, 'iHasSlavesPlayer', -1)
						pCityHet, iter = pPlayer.nextCity(iter, false)
				
					# Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
					iOldSlaves = max(0, (iCities - 2))
					SDTK.sdObjectSetVal("Hitti", pPlayer, 'Slaves', iOldSlaves)
			
					# # Stdte durchgehen und Sklaven entfernen
					# pCityHet, iter = pPlayer.firstCity(false)
					# while(pCityHet):
						# if pCityHet.getOwner() == pPlayer.getID() and not pCityHet.isNone():
							# if SDTK.sdObjectGetVal("Hitti", pCityHet, 'iHasSlavesPlayer') == pPlayer.getID():
								# BugUtil.warn("Sklavenstadt wurde gefunden")
								# pCityHet.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
								# SDTK.sdObjectSetVal("Hitti", pCityHet, 'iHasSlavesPlayer', -1)
						# pCityHet, iter = pPlayer.nextCity(iter, false)
								
					# Neue Sklavenzahl festlegen
					iNewSlaves = max(0, (iCities - 1))
					SDTK.sdObjectSetVal( "Hitti", pPlayer, 'Slaves', iNewSlaves)
					
					# Test
					#CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(-iOldSlaves,-iOldSlaves,)),'',0,'',-1,-1,-1,false,false)
					#CyInterface().addMessage(iPlayer,true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(+iNewSlaves,+iNewSlaves,)),'',0,'',-1,-1,-1,false,false)
					
					# Hauptstadt bekommt neue Sklavenzahl
					pHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
					pHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), +iNewSlaves)
					SDTK.sdObjectSetVal("Hitti", pHetCapital, 'iHasSlavesPlayer', pPlayer.getID())
# Cybah: BASE fr 6.1 F - ZE: Hethiter End ----------------------------------------------------------------------------------------------	
# ZE: Kelten 2/2 Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
			iTechZECELT = gc.getInfoTypeForString("TECH_CELT")
			if pTeam.isHasTech(iTechZECELT):
				pPlot = city.plot()
				pPlot.setPlotType(PlotTypes.PLOT_HILLS, True, True)
				pPlot.setTerrainType(gc.getInfoTypeForString( 'TERRAIN_PLAINS' ), True, True)
# ZE: Kelten 2/2 End -----------------------------------------------------------------------------------------------
# ZE: Arabien 2/2 Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"): 
			iTechZERAB = gc.getInfoTypeForString("TECH_ARABIA")
			if pTeam.isHasTech(iTechZERAB) and pTeam.isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
			
				# Strae zu allen Straen im Radius 6
				# pStartPlot = city.plot()
				# pCityAra, iter = pPlayer.firstCity(false)  
				# while(pCityAra):		
					# pDestinationPlot = pCityAra.plot()
					# iPlotDistance = plotDistance(pStartPlot.getX(), pStartPlot.getY(), pDestinationPlot.getX(), pDestinationPlot.getY())
					# if iPlotDistance <= 6:
						# iDestinationDistance = gc.getMap().calculatePathDistance(pStartPlot, pDestinationPlot)
						# if iDestinationDistance <= 6:
							# eRoute = gc.getInfoTypeForString("ROUTE_ROAD")
							# for iDistance in xrange(1,iDestinationDistance):
								# pPlot = gc.getMap().getPathDistanceNextPlot(iDistance)
								# if not pPlot or pPlot.isNone():
									# break;
								# if pPlot.getRouteType() == -1:
									# pPlot.setRouteType(eRoute)
						# gc.getMap().resetPathDistance()
					# pCityAra, iter = pPlayer.nextCity(iter, false)

				# Strae zur nchsten Stadt im Radius von 10
				pStartPlot = city.plot()
				pNearestCity = gc.getMap().findCity(pStartPlot.getX(), pStartPlot.getY(), pPlayer.getID(), pPlayer.getTeam(), True, False, TeamTypes.NO_TEAM, DirectionTypes.NO_DIRECTION, city)
				if pNearestCity and not pNearestCity.isNone():
					pDestinationPlot = pNearestCity.plot()
					iPlotDistance = plotDistance(pStartPlot.getX(), pStartPlot.getY(), pDestinationPlot.getX(), pDestinationPlot.getY())
					if iPlotDistance <= 10:
						iDestinationDistance = gc.getMap().calculatePathDistance(pStartPlot, pDestinationPlot)
						if iDestinationDistance <= 10:
							eRoute = gc.getInfoTypeForString("ROUTE_ROAD")
							for iDistance in xrange(1,iDestinationDistance):
								pPlot = gc.getMap().getPathDistanceNextPlot(iDistance)
								if not pPlot or pPlot.isNone(): break
								if pPlot.getRouteType() == -1: pPlot.setRouteType(eRoute)
						gc.getMap().resetPathDistance()
# ZE: Arabien 2/2 End -----------------------------------------------------------------------------------------------
# ZE: Polynesien 2/2 Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"): 
			iTechZEPOLY = gc.getInfoTypeForString("TECH_POLYNESIA")
			if pTeam.isHasTech(iTechZEPOLY):
				pTestCapital = pPlayer.getCapitalCity()
				
				# Andere Area deaktiviert
				# if pTestCapital != -1 and city.area().getID() != pTestCapital.area().getID():
				
				if pTestCapital != -1:
					for eBuilding in xrange ( gc.getNumBuildingInfos() ):
						if not isWorldWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()) and not isNationalWonderClass(gc.getBuildingInfo(eBuilding).getBuildingClassType()):
							if pTestCapital.getNumRealBuilding(eBuilding) and not city.getNumRealBuilding(eBuilding) and city.canConstruct(eBuilding, True, True, True):
								# city.setNumRealBuilding((eBuilding), True)
								
								# rucivfan: Debuggen wird ohne diese Abfrage erschwert.
								if gc.getBuildingInfo(eBuilding).getProductionCost() < 0:
									continue

								iTheSpeed = CyGame().getGameSpeedType()
								TheSpeed = gc.getGameSpeedInfo(iTheSpeed)
								pHandicapInfo = gc.getHandicapInfo(gc.getGame().getHandicapType())
								# rucivfan_ai_auto_play raap[
								#if pPlayer.isHuman(): iBuildingCost = ((gc.getBuildingInfo(eBuilding).getProductionCost() * TheSpeed.getConstructPercent()) / 100)
								if pPlayer.isHumanActive(): iBuildingCost = ((gc.getBuildingInfo(eBuilding).getProductionCost() * TheSpeed.getConstructPercent()) / 100)
								# ]rucivfan_ai_auto_play raap								
								else: iBuildingCost = ((gc.getBuildingInfo(eBuilding).getProductionCost() * TheSpeed.getConstructPercent() * pHandicapInfo.getAIConstructPercent()) / 100 / 100)				
								
								# 25%
								city.setBuildingProduction(eBuilding, (iBuildingCost / 4))
# ZE: Polynesien 2/2 End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 F - ZE: Spanien Start (VERSCHOBEN MIT 6.3 C - jetzt im SDK) -----------------------------------------------------------------------------------------------
		# if pPlayer.isBarbarian():
			# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				# pPlayerX = gc.getPlayer(iPlayerX)
				# if pPlayerX.isAlive() and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
					# iTechZESPAIN = gc.getInfoTypeForString("TECH_SPAIN")
					# pTeamX = gc.getTeam(pPlayerX.getTeam())
					# if pTeamX.isHasTech(iTechZESPAIN):
						# pPlot = city.plot()
						# pPlot.setRevealed(pPlayerX.getTeam(), 1,0,-1)
						# pPlot.changeVisibilityCount(pPlayerX.getTeam(), 99999, 0)
						# pPlot.updateVisibility()
# Cybah: BASE fr 6.1 F - ZE: Spanien End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.2 D - Organized Trait Start -----------------------------------------------------------------------------------------------
		if (pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_ORGANIZED")) and (pTeam.isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")) or pTeam.isHasTech(gc.getInfoTypeForString("TECH_RAILROAD")))):
			for i in xrange(gc.getNUM_CITY_PLOTS()):
				pPlotX = city.getCityIndexPlot(i)
				if pPlotX and not pPlotX.isNone():
					if pPlotX.getBonusType(pPlayer.getTeam()) != -1:
						if pPlotX.isOwned() and pPlotX.getOwner() == pPlayer.getID() and not pPlotX.isWater():
							# Ressource selbst verstraen
							if pPlotX.getRouteType() == -1:
								if pTeam.isHasTech(gc.getInfoTypeForString("TECH_RAILROAD")): pPlotX.setRouteType(gc.getInfoTypeForString("ROUTE_RAILROAD"))
								else: pPlotX.setRouteType(gc.getInfoTypeForString("ROUTE_ROAD"))
							# Weg zur Ressource mit einer Stadt verbinden
							pCityPlot = city.plot()
							iDestinationDistance = gc.getMap().calculatePathDistance(pPlotX, pCityPlot)
							if iDestinationDistance <= 2:
								for iDistance in xrange(1,iDestinationDistance):
									pPlotY = gc.getMap().getPathDistanceNextPlot(iDistance)
									if not pPlotY or pPlotY.isNone():
										break;	
									if pPlotY.getRouteType() == -1:
										if pTeam.isHasTech(gc.getInfoTypeForString("TECH_RAILROAD")): pPlotY.setRouteType(gc.getInfoTypeForString("ROUTE_RAILROAD"))
										else: pPlotY.setRouteType(gc.getInfoTypeForString("ROUTE_ROAD"))								
# Cybah: BASE fr 6.2 D - Organized Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.3 C - ZE: Ungarn Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_HUNGARY")):
				# if not city.getNumActiveBuilding(gc.getInfoTypeForString("BUILDING_PALACE")):
				estiEnd = CyGame().getEstimateEndTurn()
				if estiEnd >= 1000:
					iScythProd = (30 + (pPlayer.getCurrentEra() * 15))
				elif estiEnd >= 700:
					iScythProd = (18 + (pPlayer.getCurrentEra() * 9))
				elif estiEnd >= 500:
					iScythProd = (12 + (pPlayer.getCurrentEra() * 6))
				else:
					iScythProd = (8 + (pPlayer.getCurrentEra() * 4))
				city.changeFeatureProduction(iScythProd)
# Cybah: BASE fr 6.3 C - ZE: Ungarn End -----------------------------------------------------------------------------------------------
# Protective Trait Start -----------------------------------------------------------------------------------------------
#		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_PROTECTIVE")):
#			iTeam = pPlayer.getTeam()
#			for x in xrange (city.getX() - 4, city.getX() + 5):
#				for y in xrange (city.getY() - 4, city.getY() + 5):
#					pPlot = CyMap().plot(x,y)
#					pPlot.changeVisibilityCount(iTeam, 4, 0)
# Protective Trait End -----------------------------------------------------------------------------------------------

		if not (city.getOwner() == CyGame().getActivePlayer() and CyGame().getAIAutoPlay() == 0 ):
			try:
				CvUtil.pyPrint('City Built Event: %s' %(city.getName()))
			except:
				CvUtil.pyPrint('City Built Event: Error processing city name' )

		if (city.getOwner() == gc.getGame().getActivePlayer()):
## AI AutoPlay ##
			# rucivfan_ai_auto_play raap[
			#if CyGame().getAIAutoPlay() == 0 and not CyGame().GetWorldBuilderMode():
			if not CyGame().isPlayerAIAutoPlay(CyGame().getActivePlayer()) and not CyGame().GetWorldBuilderMode():
			# ]rucivfan_ai_auto_play raap
				self.__eventEditCityNameBegin(city, False)
## AI AutoPlay ##
		CvUtil.pyPrint('City Built Event: %s' %(city.getName()))
		
	def onCityRazed(self, argsList):
		'City Razed'
		city, iPlayer = argsList
		iOwner = city.findHighestCulture()

# messages - wonder destroyed start #
		pCity = city		
		NumWonders = pCity.getNumWorldWonders
		if NumWonders () > 0:
			Counter = 0
			for i in xrange(gc.getNumBuildingInfos ()):
				thisbuilding = gc.getBuildingInfo (i)
				if pCity.getNumBuilding(i)>0:
					iBuildingClass = thisbuilding.getBuildingClassType ()
					thisbuildingclass = gc.getBuildingClassInfo (iBuildingClass)
					if thisbuildingclass.getMaxGlobalInstances ()==1:
						ConquerPlayer = gc.getPlayer(city.getOwner())
						iConquerTeam = ConquerPlayer.getTeam()
						ConquerName = ConquerPlayer.getName ()
						WonderName = thisbuilding.getDescription ()
						iX = pCity.getX()
						iY = pCity.getY()
						for iAllPlayer in xrange (gc.getMAX_CIV_PLAYERS ()):
							ThisPlayer = gc.getPlayer(iAllPlayer)
							iThisTeam = ThisPlayer.getTeam()
							ThisTeam = gc.getTeam(iThisTeam)
							if ThisTeam.isHasMet(iConquerTeam):
								if iAllPlayer == city.getOwner():
									CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_YOU_DESTROYED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
								else:
									CyInterface().addMessage(iAllPlayer,False,15,CyTranslator().getText("TXT_KEY_DESTROYED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
# messages - wonder destroyed end #
		
		# Partisans!
		if city.getPopulation > 1 and iOwner != -1 and iPlayer != -1:
			owner = gc.getPlayer(iOwner)
			if not owner.isBarbarian() and owner.getNumCities() > 0:
				if gc.getTeam(owner.getTeam()).isAtWar(gc.getPlayer(iPlayer).getTeam()):
					if gc.getNumEventTriggerInfos() > 0: # prevents mods that don't have events from getting an error
						iEvent = CvUtil.findInfoTypeNum(gc.getEventTriggerInfo, gc.getNumEventTriggerInfos(),'EVENTTRIGGER_PARTISANS')
						if iEvent != -1 and gc.getGame().isEventActive(iEvent) and owner.getEventTriggerWeight(iEvent) < 0:
							triggerData = owner.initTriggeredData(iEvent, true, -1, city.getX(), city.getY(), iPlayer, city.getID(), -1, -1, -1, -1)
			
		#Raze the Arcology
		owner = PyPlayer(city.getOwner())
		razor = PyPlayer(iPlayer)
		
		self.iArcologyCityID = -1
		
		#if city.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY")) or city.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING")) or city.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_DEFLECTOR_SHIELDING")):
		if city.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY")) or city.getNumRealBuilding(gc.getInfoTypeForString("BUILDING_ARCOLOGY_SHIELDING")):
			self.iArcologyCityID = city.getID()
		
		CvUtil.pyPrint('Player %d Civilization %s City %s was razed by Player %d' 
			%(owner.getID(), owner.getCivilizationName(), city.getName(), razor.getID()))	
		CvUtil.pyPrint("City Razed Event: %s" %(city.getName(),))
	
	def onCityAcquired(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'City Acquired'
		iPreviousOwner, iNewOwner, pCity, bConquest, bTrade, bFirstOwned = argsList
		CvUtil.pyPrint('City Acquired Event: %s' %(pCity.getName()))

		pPlayer = gc.getPlayer(iNewOwner)
		pTeam = gc.getTeam(pPlayer.getTeam())
		ppPlayer = gc.getPlayer(iPreviousOwner)
		ppTeam = gc.getTeam(ppPlayer.getTeam())
		iX = pCity.getX()
		iY = pCity.getY()
		pPlot = CyMap().plot(iX +0, iY +0)
		capitalpp = ppPlayer.getCapitalCity()
		capitalp = pPlayer.getCapitalCity()

# Cybah: BASE fr 6.3 C - ZE: Spanien Start (funktioniert nicht, deshalb im SDK) -----------------------------------------------------------------------------------------------
		# if ppPlayer.isBarbarian() and ppPlayer.getID() == pCity.getOriginalOwner() and bFirstOwned:
			# for iPlayerX in xrange(gc.getMAX_CIV_PLAYERS()):
				# pPlayerX = gc.getPlayer(iPlayerX)
				# if pPlayerX.isAlive() and pPlayerX.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
					# iTechZESPAIN = gc.getInfoTypeForString("TECH_SPAIN")
					# pTeamX = gc.getTeam(pPlayerX.getTeam())
					# if pTeamX.isHasTech(iTechZESPAIN):
						# pPlot.changeVisibilityCount(pPlayerX.getTeam(), -99999, 0)
						# pPlot.updateVisibility()
# Cybah: BASE fr 6.3 C - ZE: Spanien End -----------------------------------------------------------------------------------------------
# Industrious Trait Start -----------------------------------------------------------------------------------------------
		if ppPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")):
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FORGE"), YieldTypes.YIELD_PRODUCTION, 0)
			# pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_LEVEE"), YieldTypes.YIELD_PRODUCTION, 0)
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FACTORY"), YieldTypes.YIELD_PRODUCTION, 0)
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_INDUSTRIAL_PARK"), YieldTypes.YIELD_PRODUCTION, 0)
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")):
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FORGE"), YieldTypes.YIELD_PRODUCTION, 2)
			# pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_LEVEE"), YieldTypes.YIELD_PRODUCTION, 2)
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FACTORY"), YieldTypes.YIELD_PRODUCTION, 2)
			pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_INDUSTRIAL_PARK"), YieldTypes.YIELD_PRODUCTION, 2)
# Industrious Trait End -----------------------------------------------------------------------------------------------
# Financial Trait Start -----------------------------------------------------------------------------------------------
		if ppPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_FINANCIAL")):
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_MARKET"), CommerceTypes.COMMERCE_GOLD, 0)
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), CommerceTypes.COMMERCE_GOLD, 0)
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_BANK"), CommerceTypes.COMMERCE_GOLD, 0)
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_FINANCIAL")):
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_MARKET"), CommerceTypes.COMMERCE_GOLD, 1)
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_GROCER"), CommerceTypes.COMMERCE_GOLD, 1)
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_BANK"), CommerceTypes.COMMERCE_GOLD, 1)
# Financial Trait End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - ZE: Griechenland Start -----------------------------------------------------------------------------------------------
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
			pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_ACADEMY"), CommerceTypes.COMMERCE_RESEARCH, 0)
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
			iTechZEGREECE = gc.getInfoTypeForString("TECH_GREECE")
			if pTeam.isHasTech(iTechZEGREECE):
				pCity.setBuildingCommerceChange(gc.getInfoTypeForString("BUILDINGCLASS_ACADEMY"), CommerceTypes.COMMERCE_RESEARCH, 4)
# Cybah: BASE fr 6.1 E - ZE: Griechenland End -----------------------------------------------------------------------------------------------
# ZE: Japan 3/3 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
#			iTechZEJA1 = gc.getInfoTypeForString("TECH_JAPAN")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEJA1):
#				iTechZEJA2 = gc.getInfoTypeForString("TECH_ASSEMBLY_LINE")
#				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEJA2):
#					iFabrikKlasse = gc.getInfoTypeForString("BUILDINGCLASS_FACTORY") 
#					pCity.changeNumCivilizationBuildingPossible(iFabrikKlasse, 1, False)
# ZE: Japan 3/3 End -----------------------------------------------------------------------------------------------
# ZE: Khmer 4/5 Start -----------------------------------------------------------------------------------------------
#		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
#			iTechZEKHM1 = gc.getInfoTypeForString("TECH_KHMER")
#			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEKHM1):
#				iTechZEKHM2 = gc.getInfoTypeForString("TECH_CONSTITUTION")
#				if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEKHM2):
#					iJailClass = gc.getInfoTypeForString("BUILDINGCLASS_JAIL") 
#					pCity.changeNumCivilizationBuildingPossible(iJailClass, 1, False)
# ZE: Khmer 4/5 End -----------------------------------------------------------------------------------------------
# ZE: Khmer 5/5 Start -----------------------------------------------------------------------------------------------
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
		
			# 6.2 D - MONASTERY mit MONASTERY getauscht (hier wurde aus TEMPLE MONASTERY)
			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 1:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 0)

# ------------------------------------

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

			if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 3:
				pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 2)

		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
			iTechZEKHMER = gc.getInfoTypeForString("TECH_KHMER")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEKHMER):
				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 2:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 3)

# ------------------------------------

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_JEWISH_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CHRISTIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ISLAMIC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_HINDU_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_BUDDHIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_CONFUCIAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TAOIST_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_OLYMP_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ASEN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_VOODOO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHINTO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_ZORO_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_RA_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_TOLTEC_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_SHAMAN_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_FREEM_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)

				if pCity.getBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION) == 0:
					pCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_DRUID_MONASTERY"), YieldTypes.YIELD_PRODUCTION, 1)
# ZE: Khmer 5/5 End -----------------------------------------------------------------------------------------------
# Mehr Palastkommerz START -----------------------------------------------------------------------------------------------
	
	# Stadtgewinner (pPlayer)
		
		iBonusPalaceCommerce = 0
		# 6.4 C - Kommerzbonus fr Rad
		if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
			iBonusPalaceCommerce += 2
			
		# ZE: Byzanz 4/4 Teil 1 Start ----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
			iTechZEBY = gc.getInfoTypeForString("TECH_BYZANTIUM")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEBY):
			
				# Nichthauptstdte zhlen
				iNonCapCities= 0
				pNumCity, iter = pPlayer.firstCity(false)  
				while(pNumCity):	  
					if pNumCity.getOwner() == pPlayer.getID() and not pNumCity.isNone() and not pNumCity.isCapital():
						iNonCapCities += 1
						# Bonus temporr auf 0 setzen
						pNumCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, 0)
					pNumCity, iter = pPlayer.nextCity(iter, false)
			
				# Eigenschaft: +2 immer und +1 fr jede weitere Stadt
				iByzBonus = (2 + iNonCapCities)
				iBonusPalaceCommerce += iByzBonus
		# ZE: Byzanz 4/4 Teil 1 End ----------------------------------------------------------------------------------------------

		# Palastkommerzbonus in allen Stdten einstellen
		pCityPalaceCommerce, iter = pPlayer.firstCity(false)
		while(pCityPalaceCommerce):	  
			if pCityPalaceCommerce.getOwner() == pPlayer.getID() and not pCityPalaceCommerce.isNone():
				pCityPalaceCommerce.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, iBonusPalaceCommerce)
			pCityPalaceCommerce, iter = pPlayer.nextCity(iter, false)
			
	# -----------------------------------------------------------------------------------------------			
	# Stadtverlierer (ppPlayer)	
			
		ippBonusPalaceCommerce = 0
		# 6.4 C - Kommerzbonus fr Rad
		if gc.getTeam(ppPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_THE_WHEEL")):
			ippBonusPalaceCommerce += 2
			
		# ZE: Byzanz 4/4 Teil 2 Start ----------------------------------------------------------------------------------------------
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
			iTechZEBY = gc.getInfoTypeForString("TECH_BYZANTIUM")
			if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEBY):
			
				# Nichthauptstdte zhlen
				ippNonCapCities= 0
				ppNumCity, iter = ppPlayer.firstCity(false)
				while(ppNumCity):	  
					if ppNumCity.getOwner() == ppPlayer.getID() and not ppNumCity.isNone() and not ppNumCity.isCapital():
						ippNonCapCities += 1
						# Bonus temporr auf 0 setzen
						ppNumCity.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, 0)
					ppNumCity, iter = ppPlayer.nextCity(iter, false)
			
				# Eigenschaft: +2 immer und +1 fr jede weitere Stadt
				iByzBonus = (2 + ippNonCapCities)
				ippBonusPalaceCommerce += iByzBonus
		# ZE: Byzanz 4/4 Teil 2 End ----------------------------------------------------------------------------------------------

		# Palastkommerzbonus in allen Stdten einstellen
		ppCityPalaceCommerce, iter = ppPlayer.firstCity(false)  
		while(ppCityPalaceCommerce):	  
			if ppCityPalaceCommerce.getOwner() == ppPlayer.getID() and not ppCityPalaceCommerce.isNone():
				ppCityPalaceCommerce.setBuildingYieldChange(gc.getInfoTypeForString("BUILDINGCLASS_PALACE"), YieldTypes.YIELD_COMMERCE, ippBonusPalaceCommerce)
			ppCityPalaceCommerce, iter = ppPlayer.nextCity(iter, false)
			
# Mehr Palastkommerz END -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 F - ZE: Hethiter Start ----------------------------------------------------------------------------------------------
		# Ist jetzt bei onCityLost
		# # Stadtverlierer ist Hethiter
		# if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):	
			# iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
			# if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEHET) and ppPlayer.isAlive():

				# # Scriptdata fr Sklavenzahl anpassen
				# if SDTK.sdObjectExists( "Hitti", ppPlayer ):
				
					# # Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
					# iOldSlaves = max(0, SDTK.sdObjectGetVal( "Hitti", ppPlayer, 'Slaves' ))
				
					# if SDTK.sdObjectGetVal( "Hitti", pCity, 'iHasSlavesPlayer' ) == ppPlayer.getID():
						# SDTK.sdObjectSetVal( "Hitti", pCity, 'iHasSlavesPlayer', -1)
						# pCity.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
			
					# # Stdte durchgehen
					# iCities = 0
					# ppCityHet, iter = ppPlayer.firstCity(false)  
					# while(ppCityHet):
						# if ppCityHet.getOwner() == ppPlayer.getID() and not ppCityHet.isNone():
							# iCities += 1
							# # Stadt hat Sklaven -> entfernen um sie spter der Hauptstadt wieder hinzuzufgen
							# if SDTK.sdObjectGetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer' ) == ppPlayer.getID() and iOldSlaves > 0:
								# ppCityHet.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
								# SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
							# else: SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
						# ppCityHet, iter = ppPlayer.nextCity(iter, false)
								
					# # Neue Sklavenzahl festlegen
					# iNewSlaves = max(0, (iCities - 1))
					# SDTK.sdObjectSetVal( "Hitti", ppPlayer, 'Slaves', iNewSlaves)
					
					# # Hauptstadt bekommt neue Sklavenzahl (wurden zuvor entfernt im Stdtedurchgang)
					# ppHetCapital = ppPlayer.getCapitalCity()
					# if not ppHetCapital.isNone():
						# ppHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), SDTK.sdObjectGetVal( "Hitti", ppPlayer, 'Slaves' ))
						# SDTK.sdObjectSetVal( "Hitti", ppHetCapital, 'iHasSlavesPlayer', ppPlayer.getID())
						
# Testfix START
# Cybah: BASE fr 6.1 F - ZE: Hethiter Start ----------------------------------------------------------------------------------------------
		# Stadtverlierer ist Hethiter //Teilcode wird von onBuildingBuild genommen (Fall: Hauptstadtverlust)
		if ppPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):	
			iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
			if gc.getTeam(ppPlayer.getTeam()).isHasTech(iTechZEHET):

				# Scriptdata fr Sklavenzahl anpassen
				if SDTK.sdObjectExists( "Hitti", ppPlayer ):
				
					# Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
					iOldSlaves = max(0, SDTK.sdObjectGetVal( "Hitti", ppPlayer, 'Slaves' ))
				
					if SDTK.sdObjectGetVal( "Hitti", pCity, 'iHasSlavesPlayer' ) == ppPlayer.getID():
						SDTK.sdObjectSetVal( "Hitti", pCity, 'iHasSlavesPlayer', -1)
						pCity.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
			
					# Stdte durchgehen
					iCities = 0
					ppCityHet, iter = ppPlayer.firstCity(false)  
					while(ppCityHet):
						if ppCityHet.getOwner() == ppPlayer.getID() and not ppCityHet.isNone():
							iCities += 1
							# Stadt hat Sklaven -> entfernen um sie spter der Hauptstadt wieder hinzuzufgen
							if SDTK.sdObjectGetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer' ) == ppPlayer.getID() and iOldSlaves > 0:
								ppCityHet.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
								SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
							else: SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
						ppCityHet, iter = ppPlayer.nextCity(iter, false)
								
					# Neue Sklavenzahl festlegen
					iNewSlaves = max(0, (iCities - 1))
					SDTK.sdObjectSetVal( "Hitti", ppPlayer, 'Slaves', iNewSlaves)
					
					# Neue Sklavenzahl
					# Hauptstadt bekommt neue Sklavenzahl (wurden zuvor entfernt im Stdtedurchgang)
					ppHetCapital = ppPlayer.getCapitalCity()
					if not ppHetCapital.isNone():
						ppHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), SDTK.sdObjectGetVal( "Hitti", ppPlayer, 'Slaves' ))
						SDTK.sdObjectSetVal( "Hitti", ppHetCapital, 'iHasSlavesPlayer', ppPlayer.getID())
# Cybah: BASE fr 6.1 F - ZE: Hethiter End ----------------------------------------------------------------------------------------------
# Testfix END
						
		# Stadtgewinner ist Hethiter
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
			iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHET):

				if not SDTK.sdObjectExists("Hitti", pPlayer):
					SDTK.sdObjectInit('Hitti', pPlayer, {})
					SDTK.sdObjectSetVal("Hitti", pPlayer, 'Slaves', 0)
					
				if not SDTK.sdObjectExists("Hitti", pCity):
					SDTK.sdObjectInit('Hitti', pCity, {})
					if pCity.isCapital():
						SDTK.sdObjectSetVal("Hitti", pCity, 'iHasSlavesPlayer', pPlayer.getID())
					else:
						SDTK.sdObjectSetVal("Hitti", pCity, 'iHasSlavesPlayer', -1)
						
				elif SDTK.sdObjectGetVal("Hitti", pCity, 'iHasSlavesPlayer') != -1:
					SDTK.sdObjectSetVal("Hitti", pCity, 'iHasSlavesPlayer', -1)
				
				pHetCapital = pPlayer.getCapitalCity()
				if not pHetCapital.isNone():
					SDTK.sdObjectSetVal("Hitti", pHetCapital, 'iHasSlavesPlayer', pPlayer.getID())
					
					#- Stdte zhlen
					iCities = 0
					pCityHet, iter = pPlayer.firstCity(false)
					while(pCityHet):
						if pCityHet.getOwner() == pPlayer.getID() and not pCityHet.isNone():
							iCities += 1
							if not SDTK.sdObjectExists("Hitti", pCityHet):
								SDTK.sdObjectInit('Hitti', pCityHet, {})
								if not pCityHet.isCapital(): SDTK.sdObjectSetVal("Hitti", pCityHet, 'iHasSlavesPlayer', -1)
						pCityHet, iter = pPlayer.nextCity(iter, false)
				
					#- Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
					iOldSlaves = max(0, (iCities - 2))
					SDTK.sdObjectSetVal("Hitti", pPlayer, 'Slaves', iOldSlaves)
								
					#- Neue Sklavenzahl festlegen
					iNewSlaves = max(0, (iCities - 1))
					SDTK.sdObjectSetVal( "Hitti", pPlayer, 'Slaves', iNewSlaves)
					
					#- Hauptstadt bekommt neue Sklavenzahl
					pHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
					pHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), +iNewSlaves)
					SDTK.sdObjectSetVal("Hitti", pHetCapital, 'iHasSlavesPlayer', pPlayer.getID())
# Cybah: BASE fr 6.1 F - ZE: Hethiter End ----------------------------------------------------------------------------------------------
# Great Bath Start -----------------------------------------------------------------------------------------------
#		b_bath = gc.getInfoTypeForString("BUILDING_GREAT_BATH")
#		if pCity.getNumActiveBuilding(b_bath):
#			pPlot.setFeatureType(gc.getInfoTypeForString( "FEATURE_RAINWATER_BASIN" ), 1)
# Great Bath End -----------------------------------------------------------------------------------------------
# Artistic Trait Start -----------------------------------------------------------------------------------------------
#
#		iTrait = gc.getInfoTypeForString("TRAIT_ARTISTIC")
#		if pPlayer.hasTrait(iTrait):
#
#			civ_type = gc.getPlayer(iPreviousOwner).getCivilizationType()
#			for iBuilding in xrange(gc.getNumBuildingClassInfos()):
#				iUniqueBuilding = gc.getCivilizationInfo(civ_type).getCivilizationBuildings(iBuilding);
#				iDefaultBuilding = gc.getBuildingClassInfo(iBuilding).getDefaultBuildingIndex();
#				if (iDefaultBuilding > -1 and iUniqueBuilding > -1 and iDefaultBuilding != iUniqueBuilding):
#
#					if pCity.getNumActiveBuilding(iDefaultBuilding):
#
#						pCity.setNumRealBuilding(iDefaultBuilding,0)
#						pCity.setNumRealBuilding(iUniqueBuilding,1)
#
#						CyInterface().addMessage(iNewOwner,false,15,CyTranslator().getText("TXT_KEY_BUILDING_FLAVIAN_GAMETXT",( pCity.getName(), PyHelpers.PyInfo.BuildingInfo(iUniqueBuilding).getDescription() , PyHelpers.PyInfo.BuildingInfo(iDefaultBuilding).getDescription() )),'',0,gc.getBuildingInfo(iUniqueBuilding).getButton(),ColorTypes(11),pCity.getX(),pCity.getY(),True,True)
#
# Artistic Trait End -----------------------------------------------------------------------------------------------

		if bConquest == True:

# Anthems Start -----------------------------------------------------------------------------------------------

			# if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_ANTHEMS):

			pActivePlayer = gc.getActivePlayer()
			if pActivePlayer:
				if gc.getTeam(pActivePlayer.getTeam()).isHasMet(pPlayer.getTeam()) and pActivePlayer.isOption(PlayerOptionTypes.PLAYEROPTION_ANTHEMS):

					#CyInterface().addMessage(iNewOwner,false,15,CyTranslator().getText("TXT_KEY_ANTHEM_CITY_CONQUER",( pCity.getName(), PyHelpers.PyInfo.BuildingInfo(iUniqueBuilding).getDescription() , PyHelpers.PyInfo.BuildingInfo(iDefaultBuilding).getDescription() )),'',0,gc.getBuildingInfo(iUniqueBuilding).getButton(),ColorTypes(11),pCity.getX(),pCity.getY(),True,True)

					#strMessageAnthem = CyTranslator().getText("TXT_KEY_BUILDING_FORTKNOX_WINNER", (ppPlayer.getName(), (iConquestGold)))
					#CyInterface().addMessage(pPlayer.getID(), True, 20, strMessageAnthem, "AS2D_ANTHEM_AEGYPTEN", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), iX, iY, True, True)

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AMERICA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AMERICA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ARABIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ARABIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AUSTRIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AUSTRIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AZTEC"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_AZTEC")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BABYLON"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BABYLON")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BERBER"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BERBER")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BRAZIL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BRAZIL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_BYZANTIUM"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_BYZANTIUM")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARIBBEAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CARIBBEAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CARTHAGE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CARTHAGE")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CELT"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CELT")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_CHINA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_CHINA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_EGYPT")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ENGLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ETHIOPIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_FRANCE")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GERMANY"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_GERMANY")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_GREECE"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_GREECE")
					
					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HITTITES")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HOLY_ROMAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HOLY_ROMAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HUNGARY"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_HUNGARY")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INCA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INCA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INDIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_INDONESIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_INDONESIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ISRAEL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ISRAEL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_JAPAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_JAPAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KHMER"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_KHMER")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_KOREA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_KOREA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MALI")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MAYA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MAYA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MONGOL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_MONGOL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NATIVE_AMERICA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_NATIVE_AMERICA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_NETHERLANDS"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_NETHERLANDS")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_OTTOMAN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_OTTOMAN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PERSIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_PERSIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_POLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_POLYNESIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_POLYNESIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_PORTUGAL"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_PORTUGAL")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ROME"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ROME")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_RUSSIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_RUSSIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCOTLAND"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SCOTLAND")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SCYTHS"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SCYTHS")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SPAIN")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SUMERIA"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_SUMERIA")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_TIBET"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_TIBET")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_VIKING"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_VIKING")

					if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU"):
						CyAudioGame().Play2DSound("AS2D_ANTHEM_ZULU")

# Anthems End -----------------------------------------------------------------------------------------------
# Samurai-Burg Himeji Start -----------------------------------------------------------------------------------------------
			# DEAKTIVIERT (6.3 B - jetzt reduzierter Einheitenunterhalt per Bauernhof [siehe SDK])
			# # Stadteroberer hat Samuraiburg, Stadteroberer hat die Stadt zum ersten Mal
			# if pPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_HIMEJI_CASTLE")) > 0 and bFirstOwned:
				# obsoleteTechSamu = gc.getBuildingInfo(gc.getInfoTypeForString("BUILDING_HIMEJI_CASTLE")).getObsoleteTech()
				# if obsoleteTechSamu == -1 or not gc.getTeam(pPlayer.getTeam()).isHasTech(obsoleteTechSamu):				
					# # Alle eigenen militrischen Landeinheiten: +Bewegung
					# # iPreviousPopulation = (pCity.getPopulation() + 1)
					# # iExtraMoves = (1 + (iPreviousPopulation / 10))
					# iExtraMoves = 1
					# (loopUnit, iter) = pPlayer.firstUnit(False)
					# while(loopUnit):
						# if loopUnit.getUnitCombatType() > -1 and loopUnit.baseCombatStr() > 0 and loopUnit.getDomainType() == DomainTypes.DOMAIN_LAND:
							# loopUnit.changeTempFlatMoves(iExtraMoves)
						# (loopUnit, iter) = pPlayer.nextUnit(iter, False)

			# DEAKTIVIERT (6.3 B - jetzt Erstangriffe fr Nahkampfeinheiten, Bogenschtzen und berittene Einheiten [siehe SDK])
			# Stadtverlierer hat Samuraiburg, Stadt wurde vom Stadtverlierer gegrndet, Stadteroberer hat die Stadt zum ersten Mal
			# if ppPlayer.getBuildingClassCount(gc.getInfoTypeForString("BUILDINGCLASS_HIMEJI_CASTLE")) > 0 and ppPlayer.getID() == pCity.getOriginalOwner() and bFirstOwned:
				# obsoleteTechSamu = gc.getBuildingInfo(gc.getInfoTypeForString("BUILDING_HIMEJI_CASTLE")).getObsoleteTech()
				# if obsoleteTechSamu == -1 or not gc.getTeam(ppPlayer.getTeam()).isHasTech(obsoleteTechSamu):
				
					# # Neuer Effekt (BASE 6.1 E): Stadt mit der meisten XP rekrutiert 1 + (1 fr je 4 Bevlkerung)
					# iPreviousPopulation = (pCity.getPopulation() + 1)
					# iExtraUnits = (1 + (iPreviousPopulation / 4))

					# # ---- Stadt mit der hchsten Production Experience suchen und speichern ----
					# pBestXPCity = ppPlayer.getCapitalCity()
					# iBestXP = 0
					# pMaybeBestXPCity, iter = ppPlayer.firstCity(False)
					# while(pMaybeBestXPCity):
						# iCityOwner = pMaybeBestXPCity.getOwner() 
						# if not pMaybeBestXPCity.isNone() and iCityOwner == ppPlayer.getID():
							# iXP = pMaybeBestXPCity.getProductionExperience(gc.getInfoTypeForString("UNIT_FANATIC"))
							# if iBestXP < iXP: 
								# iBestXP = iXP
								# pBestXPCity = pMaybeBestXPCity
						# pMaybeBestXPCity, iter = ppPlayer.nextCity(iter, False)

					# if pBestXPCity != -1 and ppPlayer.getNumCities() > 1:
						# for i in xrange(iExtraUnits):
							# iConscriptUnit = pBestXPCity.getConscriptUnit(False)	# true fr keine reinen Verteidigungseinheiten
							# pSamuUnit = ppPlayer.initUnit(iConscriptUnit, pBestXPCity.getX(), pBestXPCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
							# pBestXPCity.addProductionExperience(pSamuUnit, False)
	
# Samurai-Burg Himeji End -----------------------------------------------------------------------------------------------
# ZE: Mali Start -----------------------------------------------------------------------------------------------
			# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_MALI"): 
				# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MALI")) and not pPlayer.getID() == pCity.getOriginalOwner():
					# iConquestGold = max(20, ((pCity.getPopulation() +1) * 20))
					# pPlayer.changeGold(iConquestGold)
# ZE: Mali End -----------------------------------------------------------------------------------------------
# ZE: Spanien Start - DEAKTIVIERT MIT 6.3 C (ersetzt durch SDK Effekt) -----------------------------------------------------------------------------------------------
			# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN") and bFirstOwned:
				# iTechZESPAIN = gc.getInfoTypeForString("TECH_SPAIN")
				# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESPAIN):
				
					# # -- Tech bei Barbaren -- (NEU)
					# if ppPlayer.isBarbarian():
						# pPlot = pCity.plot()

						# # pTempUnit = pPlayer.initUnit(gc.getInfoTypeForString("UNIT_SCOUT"), pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
						# if pPlayer.canReceiveGoody(pPlot, gc.getInfoTypeForString("GOODY_TECH"), CyUnit()):
							# pPlayer.receiveGoody(pPlot, gc.getInfoTypeForString("GOODY_TECH"), CyUnit())
							# # pTempUnit.kill(0, -1)

						# else:
							# # pTempUnit.kill(0, -1)
							# # -- Gold bei Barbaren -- (ALT)
							# iGold = (5 * CyGame().getGameTurn() * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100)
							# pPlayer.changeGold(iGold)
							# strMessage = CyTranslator().getText("TXT_KEY_TECH_SPAIN_GOLD", (iGold, (pCity.getName())))
							# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
					
					# # -- Gold bei anderen Spielern --
					# else:
						# # +100 mal ra Gold
						# iConquestGold = ((pPlayer.getCurrentEra() + 1) * 100 * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100)
						# pPlayer.changeGold(iConquestGold)
						# strMessage = CyTranslator().getText("TXT_KEY_TECH_SPAIN_GOLD", (iConquestGold, (pCity.getName())))
						# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# ZE: Spanien End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 F - Spieloption Techeroberung START -----------------------------------------------------------------------------------------------
			if gc.getGame().isOption(GameOptionTypes.GAMEOPTION_TECH_CONQUEST) and bFirstOwned and not ppPlayer.isBarbarian():
			
				# Mindestens 25% Chance (5 von 20)
				iPreviousPopulation = max(5, (pCity.getPopulation() + 1))
				iTechGet = self.getRandomNumber( 20 )
				if iPreviousPopulation > iTechGet:
			
					iTech = -1
					iTechPointsLeft = 0
				
					PossibleTechs = []
					for iTechType in xrange(gc.getNumTechInfos()):                          
						if gc.getTechInfo(iTechType).isTrade() and ppTeam.isHasTech(iTechType) and not pTeam.isHasTech(iTechType) and pPlayer.canResearch(iTechType, false):
							PossibleTechs.append(iTechType)
					
					# Die billigste Tech
					if PossibleTechs:
						for i in xrange(len(PossibleTechs)):
							if pTeam.getResearchLeft(PossibleTechs[i]) > 0 and ((pTeam.getResearchLeft(PossibleTechs[i]) < iTechPointsLeft) or (iTech == -1)):
								iTechPointsLeft = pTeam.getResearchLeft(PossibleTechs[i])
								iTech = PossibleTechs[i]
								
					# Techvergabe
					if iTech and iTech != -1:
						pTeam.changeResearchProgress(iTech, pTeam.getResearchCost(iTech) - pTeam.getResearchProgress(iTech), iNewOwner)
						strMessage = CyTranslator().getText("TXT_KEY_TECH_CONQUERED_NEW", (pCity.getName(), (gc.getTechInfo(iTech).getDescription())))
						
					else:
						strMessage = CyTranslator().getText("TXT_KEY_NO_TECH_CONQUERED", (pCity.getName(), ()))
						
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getCivilizationInfo(ppPlayer.getCivilizationType()).getButton(), ColorTypes(0), pCity.getX(), pCity.getY(), True, True)			

# Cybah: BASE fr 6.1 F - Spieloption Techeroberung END -----------------------------------------------------------------------------------------------
# ZE: Zulu Start -----------------------------------------------------------------------------------------------
			# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ZULU") and pCity.getPopulation() > 2:
				# if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ZULU")) and not pPlayer.getID() == pCity.getOriginalOwner():				
					# iUnits = 2
					# for iUnit in xrange(iUnits):
						# pCity.changePopulation(-1)

						# # rucivfan_conscript_extended rce[
						# #pUnitIDO = capitalp.getConscriptUnit()
						# pUnitIDO = capitalp.getConscriptUnit(false)	# true fr keine reinen Verteidigungseinheiten
						# # ]rucivfan_conscript_extended rce
						
						# pNewUnit = pPlayer.initUnit( pUnitIDO, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						# capitalp.addProductionExperience(pNewUnit, false)
# ZE: Zulu End -----------------------------------------------------------------------------------------------
# Expansive Trait Start -----------------------------------------------------------------------------------------------
#			if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_EXPANSIVE")) and ppPlayer.getID() == pCity.getOriginalOwner():
#				Goody = []
#				pUnit = pPlayer.getUnit(gc.getInfoTypeForString("UNIT_SCOUT"))
#				pPlot = city.plot()
#				for iGoody in xrange(gc.getNumGoodyInfos()):
#					if pPlayer.canReceiveGoody(pPlot, iGoody, pUnit) and iGoody != gc.getInfoTypeForString("GOODY_MAP") and iGoody != gc.getInfoTypeForString("GOODY_SETTLER") and iGoody != gc.getInfoTypeForString("GOODY_WORKER") and iGoody != gc.getInfoTypeForString("GOODY_EXPERIENCE") and iGoody != gc.getInfoTypeForString("GOODY_HEALING") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_WEAK") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_ARCHER") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_SPEARMAN") and iGoody != gc.getInfoTypeForString("GOODY_BARBARIANS_STRONG_AXEMAN"):
#						Goody.append(iGoody)
#				if len(Goody) > 0:
#					pPlayer.receiveGoody(pPlot, Goody[CyGame().getSorenRandNum(len(Goody), "Which Goody")], pUnit)
# Expansive Trait End -----------------------------------------------------------------------------------------------
# Protective Trait Start -----------------------------------------------------------------------------------------------
#			if ppPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_PROTECTIVE")):
#				iTeam2 = ppPlayer.getTeam()
#				for x in xrange (pCity.getX() - 4, pCity.getX() + 5):
#					for y in xrange (pCity.getY() - 4, pCity.getY() + 5):
#						pPlot2 = CyMap().plot(x,y)
#						pPlot2.changeVisibilityCount(iTeam2, -4, 0)
#
#			if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_PROTECTIVE")):
#				iTeam = pPlayer.getTeam()
#				for x in xrange (pCity.getX() - 4, pCity.getX() + 5):
#					for y in xrange (pCity.getY() - 4, pCity.getY() + 5):
#						pPlot = CyMap().plot(x,y)
#						pPlot.changeVisibilityCount(iTeam, 4, 0)
# Protective Trait End -----------------------------------------------------------------------------------------------
	
	def onCityAcquiredAndKept(self, argsList):
		'City Acquired and Kept'
		iOwner,pCity = argsList
		CvUtil.pyPrint('City Acquired and Kept Event: %s' %(pCity.getName()))

		# iOwner funktioniert nicht und ist immer 0 !!! Deshalb muss es aus pCity geholt werden
   		iOwner = pCity.getOwner()
		pPlayer = gc.getPlayer(pCity.getOwner())

# messages - wonder captured start #		
		NumWonders = pCity.getNumWorldWonders
		if NumWonders ()>0:
			Counter = 0
			for i in xrange(gc.getNumBuildingInfos ()):
				thisbuilding = gc.getBuildingInfo (i)
				if pCity.getNumBuilding(i)>0:
					iBuildingClass = thisbuilding.getBuildingClassType ()
					thisbuildingclass = gc.getBuildingClassInfo (iBuildingClass)
					if thisbuildingclass.getMaxGlobalInstances ()==1:
						ConquerPlayer = gc.getPlayer(pCity.getOwner())
						iConquerTeam = ConquerPlayer.getTeam()
						ConquerName = ConquerPlayer.getName ()
						WonderName = thisbuilding.getDescription ()
						iX = pCity.getX()
						iY = pCity.getY()
						for iPlayer in xrange (gc.getMAX_CIV_PLAYERS ()):
							ThisPlayer = gc.getPlayer(iPlayer)
							iThisTeam = ThisPlayer.getTeam()
							ThisTeam = gc.getTeam(iThisTeam)
							if ThisTeam.isHasMet(iConquerTeam):
								if iPlayer == pCity.getOwner():
									CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_YOU_CAPTURED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/happy_person.dds',ColorTypes(gc.getInfoTypeForString("COLOR_GREEN")), iX, iY, True,True)
								else:
									CyInterface().addMessage(iPlayer,False,15,CyTranslator().getText("TXT_KEY_CAPTURED_WONDER",(ConquerName,WonderName)),'',0,'Art/Interface/Buttons/General/warning_popup.dds',ColorTypes(gc.getInfoTypeForString("COLOR_RED")), iX, iY, True,True)
# messages - wonder captured end #
	
	def onCityLost(self, argsList):
		'City Lost'
		city = argsList[0]
		player = PyPlayer(city.getOwner())
   		iOwner = city.getOwner()
		pPlayer = gc.getPlayer(city.getOwner())

		if city.getID() == self.iArcologyCityID:
			city.plot().setImprovementType(gc.getInfoTypeForString("IMPROVEMENT_CITY_RUINS_ARCOLOGY"))

# Great Bath Start -----------------------------------------------------------------------------------------------
		iX = city.getX()
		iY = city.getY()
		pPlot = CyMap().plot(iX +0, iY +0)

		if ( pPlot.getFeatureType()==gc.getInfoTypeForString( 'FEATURE_RAINWATER_BASIN' )):
			pPlot.setFeatureType(-1, 0)
# Great Bath End -----------------------------------------------------------------------------------------------

# Cybah: BASE fr 6.1 F - ZE: Hethiter Start ----------------------------------------------------------------------------------------------
		# Stadtverlierer ist Hethiter // Beobachten: Fall Hauptstadtverlust problematisch?
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_HITTITES"):	
			iTechZEHET = gc.getInfoTypeForString("TECH_HITTITES")
			if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEHET) and pPlayer.isAlive():

				# Scriptdata fr Sklavenzahl anpassen
				if SDTK.sdObjectExists( "Hitti", pPlayer ):
				
					# Alte Sklavenzahl zwischenspeichern fr temporre Entfernung
					iOldSlaves = max(0, SDTK.sdObjectGetVal( "Hitti", pPlayer, 'Slaves' ))
				
					if SDTK.sdObjectGetVal( "Hitti", city, 'iHasSlavesPlayer' ) == pPlayer.getID():
						SDTK.sdObjectSetVal( "Hitti", city, 'iHasSlavesPlayer', -1)
						city.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
			
					# Stdte durchgehen
					# -1 weil die verlorene Stadt mitzhlt
					iCities = -1
					ppCityHet, iter = pPlayer.firstCity(false)  
					while(ppCityHet):
						if ppCityHet.getOwner() == pPlayer.getID() and not ppCityHet.isNone():
							iCities += 1
							# Stadt hat Sklaven -> entfernen um sie spter der Hauptstadt wieder hinzuzufgen
							if SDTK.sdObjectGetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer' ) == pPlayer.getID() and iOldSlaves > 0:
								ppCityHet.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), -iOldSlaves)
								SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
							else: SDTK.sdObjectSetVal( "Hitti", ppCityHet, 'iHasSlavesPlayer', -1)
						ppCityHet, iter = pPlayer.nextCity(iter, false)
								
					# Neue Sklavenzahl festlegen
					iNewSlaves = max(0, (iCities - 1))
					SDTK.sdObjectSetVal( "Hitti", pPlayer, 'Slaves', iNewSlaves)
					
					# Hauptstadt bekommt neue Sklavenzahl (wurden zuvor entfernt im Stdtedurchgang)
					ppHetCapital = pPlayer.getCapitalCity()
					if not ppHetCapital.isNone():
						ppHetCapital.changeFreeSpecialistCount(gc.getInfoTypeForString("SPECIALIST_SLAVE"), SDTK.sdObjectGetVal( "Hitti", pPlayer, 'Slaves' ))
						SDTK.sdObjectSetVal( "Hitti", ppHetCapital, 'iHasSlavesPlayer', pPlayer.getID())
# Cybah: BASE fr 6.1 F - ZE: Hethiter End ----------------------------------------------------------------------------------------------

		if (not self.__LOG_CITYLOST):
			return
		CvUtil.pyPrint('City %s was lost by Player %d Civilization %s' 
			%(city.getName(), player.getID(), player.getCivilizationName()))
	
	def onCultureExpansion(self, argsList):
	## Platy Builder ##
		if CyGame().GetWorldBuilderMode() and not CvPlatyBuilderScreen.bPython: return
	## Platy Builder ##
		'City Culture Expansion'
		pCity = argsList[0]
		iPlayer = argsList[1]

		CvUtil.pyPrint("City %s's culture has expanded" %(pCity.getName(),))
	
	def onCityGrowth(self, argsList):
		'City Population Growth'
		pCity = argsList[0]
		iPlayer = argsList[1]
		pPlayer = gc.getPlayer(iPlayer)

# Cybah: BASE fr 6.1 F - ZE: thiopien Start ----------------------------------------------------------------------------------------------- DEAKTIVIERT (zu MM lastig, evtl. imba)
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ETHIOPIA") and gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_ETHIOPIA")): 
			# # Deaktiviert
			# # if not pPlayer.getCivics(gc.getInfoTypeForString("CIVICOPTION_LABOR")) == gc.getInfoTypeForString("CIVIC_SLAVERY"):
			# # Es wird die bereits erhhte Bevlkerung gezhlt
			# if pCity.getPopulation() > 4 and not pCity.getHurryAngerTimer() > 0 and not pCity.getConscriptAngerTimer() > 0:
				# iTempHappy = 0
				# if pCity.getHappinessTimer() > 0: iTempHappy = 1
				# iHappyExcess = ((pCity.happyLevel() - iTempHappy) - (pCity.unhappyLevel(0) - pCity.getEspionageHappinessCounter()))
				# if iHappyExcess > 0: pCity.changePopulation(1)
# Cybah: BASE fr 6.1 F - ZE: thiopien End -----------------------------------------------------------------------------------------------

		CvUtil.pyPrint("%s has grown" %(pCity.getName(),))
	
	def onCityDoTurn(self, argsList):
		'City Production'
		pCity = argsList[0]
		iPlayer = argsList[1]
		pPlayer = gc.getPlayer(iPlayer)
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		estiEnd = CyGame().getEstimateEndTurn()
		iGameTurn = CyGame().getGameTurn()

# Exploitation bzw Ausbeutung Start -----------------------------------------------------------------------------------------------
  
		if pCity.getProductionProcess() == gc.getInfoTypeForString("PROCESS_WEALTH0") and not pCity.isDisorder():
			if estiEnd >= 1000:
				iPopLose = self.getRandomNumber( 30 )
				iExploitGold = (pCity.getPopulation() * 4)
			elif estiEnd >= 700:
				iPopLose = self.getRandomNumber( 15 )
				iExploitGold = (pCity.getPopulation() * 3)
			elif estiEnd >= 500:
				iPopLose = self.getRandomNumber( 10 )
				iExploitGold = (pCity.getPopulation() * 2)
			elif estiEnd >= 300:
				iPopLose = self.getRandomNumber( 7 )
				iExploitGold = (pCity.getPopulation() * 1)
			if iPopLose == 0:
				if pCity.getPopulation() > 1:
					pPlayer.changeGold(iExploitGold)
					pCity.changePopulation(-1)	
					strMessage = CyTranslator().getText("TXT_KEY_EXPLOITATION_POPULATION_LOSE", (pCity.getName(), (iExploitGold)))  
					CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getProcessInfo(gc.getInfoTypeForString("PROCESS_WEALTH0")).getButton(), ColorTypes(7), pCity.getX(), pCity.getY(), True, True)																											  

# Exploitation bzw Ausbeutung End -----------------------------------------------------------------------------------------------
# ZE: Industrious Trait Start DEAKTIVIERT -----------------------------------------------------------------------------------------------
		# if pCity.isProductionBuilding() and not pCity.isDisorder():
			# pB = pCity.getProductionBuilding()
			# if pB > -1:
				# if not isWorldWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()) and not isNationalWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()):
					# iIndTrait = gc.getInfoTypeForString("TRAIT_INDUSTRIOUS")
					# iIndTech = gc.getInfoTypeForString("TECH_MASONRY")		
					# if pPlayer.hasTrait(iIndTrait) and gc.getTeam(pPlayer.getTeam()).isHasTech(iIndTech):
						# if estiEnd >= 1000:
							# iGetBPC = self.getRandomNumber( 300 )
						# elif estiEnd >= 700:
							# iGetBPC = self.getRandomNumber( 150 )
						# elif estiEnd >= 500:
							# iGetBPC = self.getRandomNumber( 100 )
						# elif estiEnd >= 300:
							# iGetBPC = self.getRandomNumber( 67 )
						# if iGetBPC == 0:
							# if pCity.productionLeft() > 1:
								# lBuildingStrs = gc.getBuildingInfo(pB).getDescription()
								# #pCity.setBuildingProduction(pB, pCity.productionLeft())
								# pCity.changeProduction(pCity.productionLeft())
								# strMessage = CyTranslator().getText("TXT_KEY_TRAIT_INDUSTRIOUS_BPC", (pCity.getName(), (lBuildingStrs)))
								# CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "", 0, gc.getBuildingInfo(pB).getButton(), ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# Industrious Trait End -----------------------------------------------------------------------------------------------
# Philosophical Trait Start -----------------------------------------------------------------------------------------------
#
#		iTraitPhi = gc.getInfoTypeForString("TRAIT_PHILOSOPHICAL")
#		if pPlayer.hasTrait(iTraitPhi):
#			pCity.changeGreatPeopleProgress(1)
#			
# Philosophical Trait End -----------------------------------------------------------------------------------------------
# Populist Trait Start -----------------------------------------------------------------------------------------------

		iTraitPop = gc.getInfoTypeForString("TRAIT_POPULIST")
		if pCity.getPopulation() > 0 and pCity.isWeLoveTheKingDay() and pPlayer.hasTrait(iTraitPop):
		
			# Cybah: BASE fr 6.1 E (in D vergessen) - Vier statt zwei einzelne Berechnungen fr weniger Random Spitzen
			iPopGoldTotal = pCity.getPopulation()
			iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCity.getPopulation())))
			iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCity.getPopulation())))
			iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCity.getPopulation())))
			iPopGoldTotal += (1 + self.getRandomNumber(max(8, pCity.getPopulation())))
			
			if iPopGoldTotal > 0:
				iGoldFaktor = 4
				if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_PRINTING_PRESS")):
					iGoldFaktor += 1
				if gc.getTeam(pPlayer.getTeam()).isHasTech(gc.getInfoTypeForString("TECH_MASS_MEDIA")):
					iGoldFaktor += 1
				iPopGoldTotal *= iGoldFaktor
				iPopGoldTotal /= 4
					
				#Fr 6.1 E - 100% mehr Gold
				iPopGoldTotal *= 4
				iPopGoldTotal /= 2
				
				pPlayer.changeGold(iPopGoldTotal)
				strMessage = CyTranslator().getText("TXT_KEY_TRAIT_POP_GET_GOLD", (pCity.getName(), (iPopGoldTotal)))
				CyInterface().addMessage(pPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)

# Populist Trait End -----------------------------------------------------------------------------------------------
# Homeland Security Start -----------------------------------------------------------------------------------------------
		b_HS = gc.getInfoTypeForString("BUILDING_HOMELAND_SECURITY")
		if pCity.getNumActiveBuilding(b_HS):

			# rucivfan_conscript_extended rce[
			#pHSUnitID = pCity.getConscriptUnit()
			pHSUnitID = pCity.getConscriptUnit(false) # true fr keine reinen Verteidigungseinheiten
			# ]rucivfan_conscript_extended rce
			
			if estiEnd >= 1000:
				if iGameTurn % 12 == 0:
					for i in xrange(2):
						pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pCity.addProductionExperience(pNewUnit, false)
			elif estiEnd >= 700:
				if iGameTurn % 9 == 0:
					for i in xrange(2):
						pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pCity.addProductionExperience(pNewUnit, false)
			elif estiEnd >= 500:
				if iGameTurn % 6 == 0:
					for i in xrange(2):
						pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pCity.addProductionExperience(pNewUnit, false)
			elif estiEnd >= 300:
				if iGameTurn % 4 == 0:
					for i in xrange(2):
						pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pCity.addProductionExperience(pNewUnit, false)
			elif estiEnd < 300:
				if iGameTurn % 4 == 0:
					for i in xrange(2):
						pNewUnit = pPlayer.initUnit( pHSUnitID, pCity.getX(), pCity.getY(), UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION )
						pCity.addProductionExperience(pNewUnit, false)
# Homeland Security End -----------------------------------------------------------------------------------------------
# ZE: gypten Start (VERLAGERT INS SDK MIT 6.3 C) -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_EGYPT") and not pCity.isDisorder():
			# iTechZEGY = gc.getInfoTypeForString("TECH_EGYPT")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZEGY):
				# # Nur in Stdten ohne Weltwunder
				# if pCity.getNumWorldWonders() < 1:
					# pB = pCity.getProductionBuilding()
					# if pB > -1:
						# if isWorldWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()):
							# # 50% Bonus, 25% wre 5 / 4
							# # alter Code
							# # iProduction = ((pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) * 3 / 2) - pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION))
							# # neuer Code (6.2 D)
							# iProduction = (pCity.getBaseYieldRate(YieldTypes.YIELD_PRODUCTION) * pCity.getBaseYieldRateModifier(YieldTypes.YIELD_PRODUCTION, pCity.getBuildingProductionModifier(pB)) / 100)
							# iProduction = ((iProduction * 3 / 2) - iProduction)
							# pCity.changeProduction(iProduction)
# ZE: gypten End -----------------------------------------------------------------------------------------------
# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion Creative Trait START -----------------------------------------------------------------------------------------------
		if pPlayer.hasTrait(gc.getInfoTypeForString("TRAIT_CREATIVE")) and not pCity.isDisorder():
			pB = pCity.getProductionBuilding()
			if pB > -1:
				if isWorldWonderClass(gc.getBuildingInfo(pB).getBuildingClassType()):

					iCurrent = 0
					iThreshold = self.iHGA * (pPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100

					if SDTK.sdObjectExists( "Kreativ", pPlayer ): iCurrent = SDTK.sdObjectGetVal( "Kreativ", pPlayer, 'iCurrent')
					else: SDTK.sdObjectInit('Kreativ', pPlayer, {})
					
					if iCurrent > 0 and pCity.productionLeft() > 1:
						# alter Code
						# iRate = min(pCity.productionLeft(), min(pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION), iCurrent))
						# neuer Code (6.2 D)
						iRate = min(pCity.productionLeft(), min((pCity.getBaseYieldRate(YieldTypes.YIELD_PRODUCTION) * pCity.getBaseYieldRateModifier(YieldTypes.YIELD_PRODUCTION, pCity.getBuildingProductionModifier(pB)) / 100), iCurrent))
						if iRate > 0:
							iCurrent -= iRate
							SDTK.sdObjectSetVal( "Kreativ", pPlayer, 'iCurrent', iCurrent)
							SDTK.sdObjectSetVal( "Kreativ", pPlayer, 'iThreshold', iThreshold)
							pCity.changeProduction(iRate)
				
					# Alter Code
					# sScript = pPlayer.getScriptData()
					# sHappy = sScript[:sScript.find("Split")]
					# if sHappy.find("HGA") == -1:
						# iCurrent = 0
						# iThreshold = self.iHGA * (pPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
					# else:
						# iCurrent = int(sHappy[:sHappy.find("HGA")])
						# iThreshold = self.iHGA * (pPlayer.getCurrentEra() + 1) * gc.getGameSpeedInfo(CyGame().getGameSpeedType()).getConstructPercent() / 100
						# # iThreshold = int(sHappy[sHappy.find("HGA") +3:])
					
					# # test
					# # CyInterface().addMessage(pPlayer.getID(),true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iCurrent,iCurrent,)),'',0,'',-1,-1,-1,false,false)
					# if iCurrent > 0 and pCity.productionLeft() > 1:
						# iRate = min(pCity.productionLeft(), min(pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION), iCurrent))
						# # test
						# # CyInterface().addMessage(pPlayer.getID(),true,ColorTypes(8),CyTranslator().getText("TXT_KEY_TEST",(iRate,iRate,)),'',0,'',-1,-1,-1,false,false)
						# if iRate > 0:
							# iCurrent -= iRate
							# pCity.changeProduction(iRate)
							# sHappy = str(iCurrent) + "HGA" + str(iThreshold)
							# sScript = sHappy + "Split"
							# pPlayer.setScriptData(sScript)
# Cybah: BASE fr 6.1 E - Kreativ Bonusproduktion END -----------------------------------------------------------------------------------------------
# ZE: Spanien Start -----------------------------------------------------------------------------------------------
		# if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_SPAIN"):
			# iTechZESPAIN = gc.getInfoTypeForString("TECH_SPAIN")
			# if gc.getTeam(pPlayer.getTeam()).isHasTech(iTechZESPAIN):
				# pU = pCity.getProductionUnit()
				# if pU > -1:
					# if gc.getUnitInfo(pU).isMilitaryProduction():
						# if gc.getUnitInfo(pU).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_NAVAL"):
							# iUnitProdBonus = ((pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION) * 150 / 100) - pCity.getYieldRate(YieldTypes.YIELD_PRODUCTION))
							# pCity.changeProduction(iUnitProdBonus)
# ZE: Spanien End -----------------------------------------------------------------------------------------------
# Portugiesische Feitoria Start -----------------------------------------------------------------------------------------------
		b_PF = gc.getInfoTypeForString("BUILDING_PORTUGAL_FEITORIA")
		if pCity.getNumActiveBuilding(b_PF):
			pCityPlot = CyMap().plot(pCity.getX(), pCity.getY())
			for iUnit in xrange(pCityPlot.getNumUnits()):
				pCityUnit = pCityPlot.getUnit(iUnit)
				if pCityUnit.getOwner() == pCity.getOwner() and pCityUnit.getDomainType() == DomainTypes.DOMAIN_SEA:
					pCityUnit.setDamage(0, False)
# Portugiesische Feitoria End -----------------------------------------------------------------------------------------------
# ZE: Frankreich Start -----------------------------------------------------------------------------------------------
		if pPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_FRANCE") and pPlayer.isGoldenAge() and not pCity.isDisorder():
			if pTeam.isHasTech(gc.getInfoTypeForString("TECH_FRANCE")):			
				iCulture = ((1 + pPlayer.getCurrentEra()) * 10) * 100
				# # Marathonmod -> warum nochmal ? (deaktiviert)				
				# estiEnd = CyGame().getEstimateEndTurn()	
				# if estiEnd >= 1000:
					# iCulture *= 300
					# iCulture /= 250
				iCulture = max(100, iCulture)					
				pCity.changeCultureTimes100(pPlayer.getID(), iCulture, True)				
# ZE: Frankreich End -----------------------------------------------------------------------------------------------
# Landwirtschaft Start -----------------------------------------------------------------------------------------------
#		if not pTeam.isHasTech(gc.getInfoTypeForString("TECH_AGRICULTURE")):
#			iFoodMalus = ((pCity.getYieldRate(0) - pCity.foodConsumption(false, 0)) / 4)
#			iFoodMalus = min(pCity.getFood()
#			pCity.changeFood(-iFoodProdValue)
# Landwirtschaft End -----------------------------------------------------------------------------------------------

		CvAdvisorUtils.cityAdvise(pCity, iPlayer)
	
	def onCityBuildingUnit(self, argsList):
		'City begins building a unit'
		pCity = argsList[0]
		iUnitType = argsList[1]
		if (not self.__LOG_CITYBUILDING):
			return
		CvUtil.pyPrint("%s has begun building a %s" %(pCity.getName(),gc.getUnitInfo(iUnitType).getDescription()))
	
	def onCityBuildingBuilding(self, argsList):
		'City begins building a Building'
		pCity = argsList[0]
		iBuildingType = argsList[1]
		if (not self.__LOG_CITYBUILDING):
			return
		CvUtil.pyPrint("%s has begun building a %s" %(pCity.getName(),gc.getBuildingInfo(iBuildingType).getDescription()))
	
	def onCityRename(self, argsList):
		'City is renamed'
		pCity = argsList[0]
		if (pCity.getOwner() == gc.getGame().getActivePlayer()):
			self.__eventEditCityNameBegin(pCity, True)	
	
	def onCityHurry(self, argsList):
		'City is renamed'
		pCity = argsList[0]
		iHurryType = argsList[1]

# ZE: ENGLAND KI TEST -----------------------------------------------------------------------------------------------		
#		if iHurryType == gc.getInfoTypeForString("HURRY_GOLD") and pCity.isProductionUnit():
#			if gc.getUnitInfo(pCity.getProductionUnit()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_ARCHER") or gc.getUnitInfo(pCity.getProductionUnit()).getUnitCombatType() == gc.getInfoTypeForString("UNITCOMBAT_GUN"):
#				pZEPlayer = gc.getPlayer(pCity.getOwner())
#				if pZEPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_ENGLAND"):
#					strMessage = CyTranslator().getText("TXT_KEY_TRAIT_POP_GET_GOLD", (pCity.getName(), (12345)))
#					CyInterface().addMessage(pZEPlayer.getID(), True, 20, strMessage, "AS2D_GOODY_GOLD", 0,',Art/Interface/Buttons/TechTree/Banking.dds,Art/Interface/Buttons/TechTree_Atlas.dds,8,1', ColorTypes(8), pCity.getX(), pCity.getY(), True, True)
# ZE: ENGLAND KI TEST -----------------------------------------------------------------------------------------------		
# ZE: Azteken Start -----------------------------------------------------------------------------------------------		
		if iHurryType == gc.getInfoTypeForString("HURRY_POPULATION"):
			pZEPlayer = gc.getPlayer(pCity.getOwner())
			if pZEPlayer.getCivilizationType() == gc.getInfoTypeForString("CIVILIZATION_AZTEC"):
				iTechZE1 = gc.getInfoTypeForString("TECH_AZTEC")
				if gc.getTeam(pZEPlayer.getTeam()).isHasTech(iTechZE1):
					pZEID = pZEPlayer.getID()					
					estiEnd = CyGame().getEstimateEndTurn()
					if ( estiEnd >= 1000 ): iValue = 36
					elif ( estiEnd >= 700 ): iValue = 18
					elif ( estiEnd >= 500 ): iValue = 12
					elif ( estiEnd >= 300 ): iValue = 8
					elif ( estiEnd < 300 ): iValue = 8
					
					pZEPlayer.changeGold(iValue)
					
					# 6.3 C - Nur die Hlfte Kultur
					iValueHalf = (iValue / 2)
					
					pCity.changeCulture(pZEID, iValueHalf, true)
					
					# Sofort fertigstellen: Gebude, Nationalwunder, Einheiten
					if pCity.isProductionBuilding() or pCity.isProductionUnit():
						if pCity.isProductionBuilding():
							pBuilding = pCity.getProductionBuilding()
							# Wegen PB84 ab 6.3 C nicht mehr fr Weltwunder
							if not isWorldWonderClass(gc.getBuildingInfo(pBuilding).getBuildingClassType()):
								pCity.popOrder(0, true, false)
						else:
							pCity.popOrder(0, true, false)
# ZE: Azteken End -----------------------------------------------------------------------------------------------

	def onVictory(self, argsList):
		'Victory'
		iTeam, iVictory = argsList
		if (iVictory >= 0 and iVictory < gc.getNumVictoryInfos()):
			victoryInfo = gc.getVictoryInfo(int(iVictory))
			CvUtil.pyPrint("Victory!  Team %d achieves a %s victory"
				%(iTeam, victoryInfo.getDescription()))
	
	# rucivfan_diplomacy_extended rde[
	# def onVassalState(self, argsList):
		# 'Vassal State'
		# iMaster, iVassal, bVassal = argsList
		
		# if (bVassal):
			# CvUtil.pyPrint("Team %d becomes a Vassal State of Team %d"
				# %(iVassal, iMaster))
		# else:
			# CvUtil.pyPrint("Team %d revolts and is no longer a Vassal State of Team %d"
				# %(iVassal, iMaster))

	def onVassalState(self, argsList):
		'Vassal State'
		iMaster, iVassal, iOldMaster = argsList
		
		if(iOldMaster != TeamTypes.NO_TEAM):
			CvUtil.pyPrint("Team %d revolts and is no longer a Vassal State of Team %d"
				%(iVassal, iOldMaster))
		if(iMaster != TeamTypes.NO_TEAM):
			CvUtil.pyPrint("Team %d becomes a Vassal State of Team %d"
				%(iVassal, iMaster))					
	# ]rucivfan_diplomacy_extended rde	
	
	def onGameUpdate(self, argsList):
		'sample generic event, called on each game turn slice'
		genericArgs = argsList[0][0]	# tuple of tuple of my args
		turnSlice = genericArgs[0]

		#OOS logging.
		OOSLogger.doGameUpdate()
		#OOS logging.
	
	def onMouseEvent(self, argsList):
		'mouse handler - returns 1 if the event was consumed'
		eventType,mx,my,px,py,interfaceConsumed,screens = argsList
		if ( px!=-1 and py!=-1 ):
			if ( eventType == self.EventLButtonDown ):
				if (self.bAllowCheats and self.bCtrl and self.bAlt and CyMap().plot(px,py).isCity() and not interfaceConsumed):
					# Launch Edit City Event
					self.beginEvent( CvUtil.EventEditCity, (px,py) )
					return 1
				
				elif (self.bAllowCheats and self.bCtrl and self.bShift and not interfaceConsumed):
					# Launch Place Object Event
					self.beginEvent( CvUtil.EventPlaceObject, (px, py) )
					return 1
			
		if ( eventType == self.EventBack ):
			return CvScreensInterface.handleBack(screens)
		elif ( eventType == self.EventForward ):
			return CvScreensInterface.handleForward(screens)
		
		return 0
		

#################### TRIGGERED EVENTS ##################

	def __eventPlaceObjectBegin(self, argsList):
		'Place Object Event'
		CvDebugTools.CvDebugTools().initUnitPicker(argsList)
	
	def __eventPlaceObjectApply(self, playerID, userData, popupReturn):
		'Place Object Event Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyUnitPicker( (popupReturn, userData) )

	def __eventAwardTechsAndGoldBegin(self, argsList):
		'Award Techs & Gold Event'
		CvDebugTools.CvDebugTools().cheatTechs()
	
	def __eventAwardTechsAndGoldApply(self, playerID, netUserData, popupReturn):
		'Award Techs & Gold Event Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyTechCheat( (popupReturn) )
	
	def __eventShowWonderBegin(self, argsList):
		'Show Wonder Event'
		CvDebugTools.CvDebugTools().wonderMovie()
	
	def __eventShowWonderApply(self, playerID, netUserData, popupReturn):
		'Wonder Movie Apply'
		if (getChtLvl() > 0):
			CvDebugTools.CvDebugTools().applyWonderMovie( (popupReturn) )

## Platy Builder ##
	
	def __eventEditUnitNameBegin(self, argsList):
		pUnit = argsList
		popup = PyPopup.PyPopup(CvUtil.EventEditUnitName, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setUserData((pUnit.getID(), CyGame().getActivePlayer()))
		popup.setBodyString(CyTranslator().getText("TXT_KEY_RENAME_UNIT", ()))
		popup.createEditBox(pUnit.getNameNoDesc())
		popup.setEditBoxMaxCharCount(25)
		popup.launch()

	def __eventEditUnitNameApply(self, playerID, userData, popupReturn):
		'Edit Unit Name Event'
		iUnitID = userData[0]
		unit = gc.getPlayer(playerID).getUnit(iUnitID)
		newName = popupReturn.getEditBoxString(0)
		if (len(newName) > 25):
			newName = newName[:25]			
		unit.setName(newName)

## Platy Builder ##
		if CyGame().GetWorldBuilderMode():
			WBUnitScreen.WBUnitScreen(CvPlatyBuilderScreen.CvWorldBuilderScreen()).placeStats()
			WBUnitScreen.WBUnitScreen(CvPlatyBuilderScreen.CvWorldBuilderScreen()).placeCurrentUnit()	
				
	def __eventEditCityNameBegin(self, city, bRename):
		popup = PyPopup.PyPopup(CvUtil.EventEditCityName, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setUserData((city.getID(), bRename, CyGame().getActivePlayer()))
		popup.setHeaderString(CyTranslator().getText("TXT_KEY_NAME_CITY", ()))
		popup.setBodyString(CyTranslator().getText("TXT_KEY_SETTLE_NEW_CITY_NAME", ()))
		popup.createEditBox(city.getName())
		popup.setEditBoxMaxCharCount(15)
		popup.launch()
	
	def __eventEditCityNameApply(self, playerID, userData, popupReturn):
		city = gc.getPlayer(userData[2]).getCity(userData[0])
		cityName = popupReturn.getEditBoxString(0)
		city.setName(cityName, not userData[1])
		if CyGame().GetWorldBuilderMode() and not CyGame().isInAdvancedStart():
			WBCityEditScreen.WBCityEditScreen().placeStats()

	def __eventWBPlayerScriptPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		gc.getPlayer(userData[0]).setScriptData(CvUtil.convertToStr(sScript))
		WBPlayerScreen.WBPlayerScreen().placeScript()
		return

	def __eventWBCityScriptPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		pCity = gc.getPlayer(userData[0]).getCity(userData[1])
		pCity.setScriptData(CvUtil.convertToStr(sScript))
		WBCityEditScreen.WBCityEditScreen().placeScript()
		return

	def __eventWBUnitScriptPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		pUnit = gc.getPlayer(userData[0]).getUnit(userData[1])
		pUnit.setScriptData(CvUtil.convertToStr(sScript))
		WBUnitScreen.WBUnitScreen(CvPlatyBuilderScreen.CvWorldBuilderScreen()).placeScript()
		return

	def __eventWBScriptPopupBegin(self):
		return

	def __eventWBGameScriptPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		CyGame().setScriptData(CvUtil.convertToStr(sScript))
		WBGameDataScreen.WBGameDataScreen(CvPlatyBuilderScreen.CvWorldBuilderScreen()).placeScript()
		return

	def __eventWBPlotScriptPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		pPlot = CyMap().plot(userData[0], userData[1])
		pPlot.setScriptData(CvUtil.convertToStr(sScript))
		WBPlotScreen.WBPlotScreen().placeScript()
		return

	def __eventWBLandmarkPopupApply(self, playerID, userData, popupReturn):
		sScript = popupReturn.getEditBoxString(0)
		pPlot = CyMap().plot(userData[0], userData[1])
		iPlayer = userData[2]
		if userData[3] > -1:
			pSign = CyEngine().getSignByIndex(userData[3])
			iPlayer = pSign.getPlayerType()
			CyEngine().removeSign(pPlot, iPlayer)
		if len(sScript):
			if iPlayer == gc.getBARBARIAN_PLAYER():
				CyEngine().addLandmark(pPlot, CvUtil.convertToStr(sScript))
			else:
				CyEngine().addSign(pPlot, iPlayer, CvUtil.convertToStr(sScript))
		WBPlotScreen.iCounter = 10
		return
## Platy Builder ##

# The School of Confucius Start -----------------------------------------------------------------------------------------------
	def getRandomNumber(self, int):
		return CyGame().getSorenRandNum(int, "Gods")

	def findClearPlot(self, pUnit):
		BestPlot = -1
		iBestPlot = 0
		pOldPlot = pUnit.plot()
		iX = pOldPlot.getX()
		iY = pOldPlot.getY()
		for iiX in xrange(iX-1, iX+2, 1):
			for iiY in xrange(iY-1, iY+2, 1):
				iCurrentPlot = 0
				pPlot = CyMap().plot(iiX,iiY)
				if pPlot.getNumUnits() == 0:
					iCurrentPlot = iCurrentPlot + 5
				if iCurrentPlot >= 1:
					iCurrentPlot = iCurrentPlot + CyGame().getSorenRandNum(5, "findClearPlot")
					if iCurrentPlot >= iBestPlot:
						BestPlot = pPlot
						iBestPlot = iCurrentPlot
		return BestPlot
# The School of Confucius End -----------------------------------------------------------------------------------------------

# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung START ----------------------------------------------------------------------------------------------------------------------------
	def starttechpopup(self, iPlayer, iTeam):
		popupInfo = CyPopupInfo()
		popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
		popupInfo.setText(CyTranslator().getText("TXT_KEY_SELECT_TECH",()))
		popupInfo.setData1(iPlayer)
		popupInfo.setData2(iTeam)
		popupInfo.setOnClickedPythonCallback("selectTech")
		szText = CyTranslator().getText("TXT_KEY_TECH_MINING", ())
		pTeam = gc.getTeam(iTeam)
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_MINING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_FISHING", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_FISHING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_HUNTING", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_HUNTING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_AGRICULTURE", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_AGRICULTURE')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_THE_WHEEL", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_THE_WHEEL')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		popupInfo.addPopup(iPlayer)
		
	def starttechpopup2(self, iPlayer, iTeam):
		popupInfo = CyPopupInfo()
		popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON)
		popupInfo.setText(CyTranslator().getText("TXT_KEY_SELECT_TECH",()))
		popupInfo.setData1(iPlayer)
		popupInfo.setData2(iTeam)
		popupInfo.setOnClickedPythonCallback("selectTech2")
		szText = CyTranslator().getText("TXT_KEY_TECH_MINING", ())
		pTeam = gc.getTeam(iTeam)
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_MINING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_FISHING", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_FISHING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_HUNTING", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_HUNTING')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_AGRICULTURE", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_AGRICULTURE')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		szText = CyTranslator().getText("TXT_KEY_TECH_THE_WHEEL", ())
		if pTeam.isHasTech(gc.getInfoTypeForString('TECH_THE_WHEEL')):
			szText = szText + CyTranslator().getText("TXT_KEY_TECH_ALREADY_KNOWN", ())
		popupInfo.addPythonButton(szText, "")
		popupInfo.addPopup(iPlayer)
# Cybah: BASE fr 6.1 E -  Spieloption: Keine Starttechnologien nderung END ----------------------------------------------------------------------------------------------------------------------------

## Palace Upgrades ##
	def triggerPalace(self, iPlayer):
		pPlayer = gc.getPlayer(iPlayer)
		pCapital = pPlayer.getCapitalCity()
		if CyGame().getActivePlayer() == iPlayer:
			CyInterface().lookAtCityBuilding(pCapital.getID(), -1)
		triggerData = pPlayer.initTriggeredData(gc.getInfoTypeForString("EVENTTRIGGER_PALACE_UPGRADE"), True, -1, -1, -1, -1, -1, -1, -1, -1, -1)