#
#       FILE:    Fractal_Arboria.py
#       AUTHOR:  Arboria by Bob Thomas (Sirian) - Modified by Junuxx
#       PURPOSE: Combine Fractal landmasses with lush Arboria terrain
#-----------------------------------------------------------------------------

from CvPythonExtensions import *
import CvUtil
import random
import CvMapGeneratorUtil
import sys
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator

def getDescription():
        return "Combines the lush land of Arboria with the land shapes of Fractal"

def isAdvancedMap():
        "This map should  show up in simple mode"
        return 0
        
def isClimateMap():
        return 0

def getTopLatitude():
        return 50
        
def getBottomLatitude():
        return -50

def minStartingDistanceModifier():
        return -10

# removed square map size  - Junuxx

def beforeGeneration():
        gc = CyGlobalContext()
        map = CyMap()
        dice = gc.getGame().getMapRand()
        iW = map.getGridWidth()
        iH = map.getGridHeight()
        global food
        food = CyFractal()
        food.fracInit(iW, iH, 7, dice, 0, -1, -1)

# using continents instead of all land Arboria - Junuxx         
def generatePlotTypes():        
        NiTextOut("Setting Plot Types (Python Continents) ...")
        fractal_world = FractalWorld()
        fractal_world.initFractal(rift_grain = -1, has_center_rift = False, polar = True)
        return fractal_world.generatePlotTypes(water_percent=75)

# subclass TerrainGenerator to create a lush grassland utopia.
class ArboriaTerrainGenerator(CvMapGeneratorUtil.TerrainGenerator):
        def __init__(self, fracXExp=-1, fracYExp=-1, grain_amount=5):
                self.gc = CyGlobalContext()
                self.map = CyMap()

                self.grain_amount = grain_amount + self.gc.getWorldInfo(self.map.getWorldSize()).getTerrainGrainChange()

                self.iWidth = self.map.getGridWidth()
                self.iHeight = self.map.getGridHeight()

                self.mapRand = self.gc.getGame().getMapRand()

                self.iFlags = 0  # Disallow FRAC_POLAR flag, to prevent "zero row" problems.

                self.terrain=CyFractal()

                self.fracXExp = fracXExp
                self.fracYExp = fracYExp

                self.initFractals()
                
        def initFractals(self):
                self.terrain.fracInit(self.iWidth, self.iHeight, self.grain_amount, self.mapRand, self.iFlags, self.fracXExp, self.fracYExp)
                self.iGrassBottom = self.terrain.getHeightFromPercent(12)

                self.terrainPlains = self.gc.getInfoTypeForString("TERRAIN_PLAINS")
                self.terrainGrass = self.gc.getInfoTypeForString("TERRAIN_GRASS")
                self.terrainDesert = self.gc.getInfoTypeForString("TERRAIN_DESERT") # added desert - Junuxx

        def getLatitudeAtPlot(self, iX, iY):
                return None

        def generateTerrain(self):              
                terrainData = [0]*(self.iWidth*self.iHeight)
                for x in range(self.iWidth):
                        for y in range(self.iHeight):
                                iI = y*self.iWidth + x
                                terrain = self.generateTerrainAtPlot(x, y)
                                terrainData[iI] = terrain
                return terrainData

        def generateTerrainAtPlot(self,iX,iY):
                lat = self.getLatitudeAtPlot(iX,iY)

                if (self.map.plot(iX, iY).isWater()):
                        return self.map.plot(iX, iY).getTerrainType()

                val = self.terrain.getHeight(iX, iY)
                if val >= self.iGrassBottom:
                        terrainVal = self.terrainGrass
        #       elif val < 0.25 * self.iGrassBottom:
        #               terrainVal = self.terrainDesert
                else:
                        terrainVal = self.terrainPlains

                if (terrainVal == TerrainTypes.NO_TERRAIN):
                        return self.map.plot(iX, iY).getTerrainType()

                return terrainVal

def generateTerrainTypes():
        NiTextOut("Generating Terrain (Python Arboria) ...")
        terraingen = ArboriaTerrainGenerator()
        terrainTypes = terraingen.generateTerrain()
        return terrainTypes

class ArboriaFeatureGenerator(CvMapGeneratorUtil.FeatureGenerator):
        def __init__(self, forest_grain=6, fracXExp=-1, fracYExp=-1):
                self.gc = CyGlobalContext()
                self.map = CyMap()
                self.mapRand = self.gc.getGame().getMapRand()
                self.forests = CyFractal()
                
                self.iFlags = 0  # Disallow FRAC_POLAR flag, to prevent "zero row" problems.

                self.iGridW = self.map.getGridWidth()
                self.iGridH = self.map.getGridHeight()
                
                self.forest_grain = forest_grain + self.gc.getWorldInfo(self.map.getWorldSize()).getFeatureGrainChange()

                self.fracXExp = fracXExp
                self.fracYExp = fracYExp

                self.__initFractals()
                self.__initFeatureTypes()
        
        def __initFractals(self):
                self.forests.fracInit(self.iGridW, self.iGridH, self.forest_grain, self.mapRand, self.iFlags, self.fracXExp, self.fracYExp)
                
                self.iJungleStart = self.forests.getHeightFromPercent(65)
                self.iJungleStop = self.forests.getHeightFromPercent(69)
                self.iForestStart = self.forests.getHeightFromPercent(29)
                
        def __initFeatureTypes(self):
                self.featureJungle = self.gc.getInfoTypeForString("FEATURE_JUNGLE")
                self.featureForest = self.gc.getInfoTypeForString("FEATURE_FOREST")
        
        def getLatitudeAtPlot(self, iX, iY):
                return 50

        def addFeaturesAtPlot(self, iX, iY):
                "adds any appropriate features at the plot (iX, iY) where (0,0) is in the SW"
                long = iX/float(self.iGridW)
                lat = iY/float(self.iGridH)
                pPlot = self.map.sPlot(iX, iY)

                if (pPlot.getFeatureType() == FeatureTypes.NO_FEATURE):
                        self.addJunglesAtPlot(pPlot, iX, iY, lat)
                        
                if (pPlot.getFeatureType() == FeatureTypes.NO_FEATURE):
                        self.addForestsAtPlot(pPlot, iX, iY, lat, long)
                
        def addIceAtPlot(self, pPlot, iX, iY, lat):
                # We don' need no steeking ice. M'kay? Alrighty then.
                ice = 0
        
        def addJunglesAtPlot(self, pPlot, iX, iY, lat):
                # Warning: this version of JunglesAtPlot is using the forest fractal!
                if pPlot.canHaveFeature(self.featureJungle):
                        if (self.forests.getHeight(iX, iY) >= self.iJungleStart) and (self.forests.getHeight(iX, iY) <= self.iJungleStop):
                                pPlot.setFeatureType(self.featureJungle, -1)

        def addForestsAtPlot(self, pPlot, iX, iY, lat, long):
                # Deciduous trees everywhere.
                if pPlot.canHaveFeature(self.featureForest):
                        if self.forests.getHeight(iX, iY) >= self.iForestStart:
                                pPlot.setFeatureType(self.featureForest, 0)

def addFeatures():
        global featuregen
        NiTextOut("Adding Features (Python Arboria) ...")
        featuregen = ArboriaFeatureGenerator()
        featuregen.addFeatures()
        NiTextOut("Simulate Forest Paradise (Forests - Python Arboria) ...")
        return 0

def normalizeRemovePeaks():
        return None

def normalizeRemoveBadFeatures():
        return None

def normalizeRemoveBadTerrain():
        return None

def normalizeAddGoodTerrain():
        return None

def normalizeAddExtras():
        return None

# Sirian's "Sahara Regional Bonus Placement" system.

# Init all bonuses. This is your master key.
# added aluminum, seafood and incense tweaks - Junuxx
forest = ('BONUS_SILVER', 'BONUS_DEER', 'BONUS_INCENSE', 'BONUS_ALUMINUM', 'BONUS_FISH')
silver = ('BONUS_SILVER')
rare = ('BONUS_ALUMINUM', 'BONUS_INCENSE')
fish = ('BONUS_FISH')
deer = ('BONUS_DEER')

def addBonusType(argsList):
        print('*******')
        [iBonusType] = argsList
        gc = CyGlobalContext()
        map = CyMap()
        dice = gc.getGame().getMapRand()
        type_string = gc.getBonusInfo(iBonusType).getType()

        if not (type_string in forest):
                print('Default', type_string, 'Default')
                CyPythonMgr().allowDefaultImpl() # Let C handle this bonus in the default way.
        else: # Current bonus type is custom-handled. Assignments to follow.
                iW = map.getGridWidth()
                iH = map.getGridHeight()

                # slightly less deer
                # Generate resources
                if (True):       
                        print('---', type_string, '---')
                        global food
                        NiTextOut("Placing forest resources (Python Arboria) ...")
                        iSilverBottom = food.getHeightFromPercent(10)
                        iSilverTop = food.getHeightFromPercent(14)
                        iDeerBottom1 = food.getHeightFromPercent(24)
                        iDeerTop1 = food.getHeightFromPercent(26)
                        iDeerBottom2 = food.getHeightFromPercent(49)
                        iDeerTop2 = food.getHeightFromPercent(51)
                        iDeerBottom3 = food.getHeightFromPercent(73)
                        iDeerTop3 = food.getHeightFromPercent(75)
                        iRareBottom = food.getHeightFromPercent(60)
                        iRareTop = food.getHeightFromPercent(63)
                        fishChance = 0.15
                        rareChance = 0.25
                        
                        for y in range(iH):
                                for x in range(iW):
                                        # Fractalized placement
                                        pPlot = map.plot(x,y)
                                        if (pPlot.isWater()) and (pPlot.getBonusType(-1) == -1):
                                                if (type_string in fish):
                                                        if pPlot.getTerrainType() == gc.getInfoTypeForString("TERRAIN_COAST"):
                                                                if (random.random() < fishChance): 
                                                                        map.plot(x,y).setBonusType(iBonusType)
                                                continue
                                        if pPlot.isPeak():
                                                continue
                                        if pPlot.getBonusType(-1) == -1:
                                                foodVal = food.getHeight(x,y)
                                                if (type_string in deer):
                                                        if pPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_FOREST") and pPlot.isFlatlands():
                                                                if (foodVal >= iDeerBottom1 and foodVal <= iDeerTop1) or (foodVal >= iDeerBottom2 and foodVal <= iDeerTop2) or (foodVal >= iDeerBottom3 and foodVal <= iDeerTop3):
                                                                        map.plot(x,y).setBonusType(iBonusType)
                                                if (type_string in silver):
                                                        if (pPlot.isHills()) or (pPlot.getFeatureType() == gc.getInfoTypeForString("FEATURE_FOREST")):  
                                                                if (foodVal >= iSilverBottom) and (foodVal <= iSilverTop):
                                                                        map.plot(x,y).setBonusType(iBonusType)
                                                if (type_string in rare):
                                                        if (foodVal >= iRareBottom) and (foodVal <= iRareTop):
                                                                r = random.random()
                                                                if iBonusType == 0: # easy on the aluminum
                                                                        r = r*2;
                                                                if (r < rareChance):
                                                                        map.plot(x,y).setBonusType(iBonusType)

                return None
