# -*- coding: iso-8859-1 -*-
#
#       ORIGINAL MAP FILES:  Archipelago.py, Continents.py, Custom_Continents.py, Fractal.py, Hub.py, Inland_Sea.py, Islands.py, Lakes.py,
#                            Maze.py, Pangaea.py, Ring.py, Shuffle.py, Terra.py, Wheel.py, Big_and_Small.py, Hemispheres.py, Medium_and_Small.py,
#                            Tectonics (AUTHOR : Laurent Di Cesare (LDiCesare))
#	AUTHORS:  Bob Thomas (Sirian), Soren Johnson, Andy Szybalski, Ben Sarsgard
#
#-----------------------------------------------------------------------------
#	Copyright (c) 2004, 2005, 2007, 2008 Firaxis Games, Inc. All rights reserved.
#-----------------------------------------------------------------------------
#
#       PERSONAL MAP FILE :   chess
#       Customized by : Sto , EMAIL : <<<stoofisme<delete_me>@hotmail.com>>>
#                           , Forum : http://forums.civfanatics.com/showthread.php?t=151629
#
# Contributions and Thanks :
#
#		To AlanH :
#		Modified version for Mac OS X by AlanH : <<alanh<delete_me>@civfanatics.net>>
#		Mac OS X changes: _winreg calls replaced by Mac OS path definitions.
#		Mac OS X changes: Mac OS path uncompress definitions.
#		Mac OS X changes: python 2.4 sort calls replaced by Mac OS python 2.3 definitions.
#
#               To Bringa :
#               Many advise for FFH2 customization and feed backs
#
#               To FastWorker :
#               Many help for warlord compatibility ,tests and feed backs
#
#               To Balerion :
#               tests and feed backs
#
#               And also to all other peoples from civfanatics that helps me or give me some feed backs
#

def getVersion():
        return "3.03"

from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import MultilayeredFractal
from CvMapGeneratorUtil import HintedWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import os
import sys
import string
import cPickle as pickle
try :
        import CvEventInterface
except :
        pass
import CvScreensInterface
import CvOptionsScreen
import CvOptionsScreenCallbackInterface
import types
from math import sqrt
import Popup as PyPopup
import traceback
import copy
import webbrowser
import urllib

if (sys.platform == 'darwin'):
        import sets
        def set(arg):
                return sets.Set(arg)
else:
        import _winreg
        import operator

selection = {}
launchScreenNumOptions = False
firstInitDebugFiles = True
XMLEntriesList = {}
XMLDescriptions = {}
bInitDescription = True
bGeneratingMap = False
hinted_world = None

##!_!## map generation
def beforeInit():
        global selGen
        global idMap
        global bScreen
        global bCanWriteLog
        global bGeneratingMap
        global originalUniqueFeatureChance
        bGeneratingMap = True
        bScreen = True
        bCanWriteLog = bool(not CyGame().isPbem())

        initVersions()
        createStoDir()
        initStoFolder()
        initGenerationDebug()

        writeLog(" = beforeInit = ", False, [""])
        
        initGenerationGlobals()

        if is_BtS_FFH2 :
                iOriginalMSOGDH = gc.getDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE")
                originalUniqueFeatureChance = gc.getDefineINT("IMPROVEMENT_UNIQUE_CHANCE")

                try :
                        gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", 1)
                        gc.setDefineINT("IMPROVEMENT_UNIQUE_CHANCE", -800)
                        gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", iOriginalMSOGDH)
                except :
                        writeLog("", False, [" FfH : error changing the unique feature chance", ""])

        if isNetMP :
                selTemp = loadSelection("_Multiplayer_Config.cfg", False)
                if selTemp == -1 :
                        selGen = copy.deepcopy(defSel)
                        writeLog("", False, [" selGen : net MP can't read the config", ""])
                else :
                        selGen = dict(selTemp)
                        writeLog("", False, [" selGen : net MP config read (hope this is the good one)", ""])
        elif selection == {} :
                selTemp = loadSelection("_LastConfig.cfg", False)
                if selTemp == -1 :
                        selGen = copy.deepcopy(defSel)
                        writeLog("", False, [" selGen : selection reseted , can't read the config", ""])
                else :
                        selGen = dict(selTemp)
                        writeLog("", False, [" selGen : selection reseted , reading the last config saved", ""])
        else :
                selGen = checkSettings(copy.deepcopy(selection))
                writeLog("", False, [" selGen : use last defined selection", ""])

        bScreen = False
        logList = ["selGen :", ""]
        for sKey1 in sortKeys(selGen) :
                logList += ["%s :" %sKey1, ""]
                for sKey2 in sortKeys(selGen, sKey1) :
                        logList.append("%s :" %sKey2)
                        for sKey3 in sortKeys(selGen, sKey1 , sKey2) :
                                logList.append(" %s : %r" %(sKey3, selGen[sKey1][sKey2][sKey3]))
                        logList.append("")
                logList.append("")
        writeLog("", False, logList)

        logList = ["Game options :"]
        for iGameOption in range(gc.getNumGameOptionInfos()) :
                logList.append("%s : %r" %(gc.getGameOptionInfo(iGameOption).getType(), game.isOption(iGameOption)))
        logList.append("")
        writeLog("", False, logList)

        listMaps = [sKey for sKey in selGen["maps"].keys() if selGen["maps"][sKey]["selected"]]
        if listMaps == [] :
                writeLog("", False, [" no map selected ... choose at random"])
                listMaps = [sKey for sKey in selGen["maps"].keys()]

        writeLog("", False, [" list of maps : %r" %listMaps, ""])

        idMap = str(getRandSel(listMaps))
        writeLog("", True, [" map chosen : %s" %idMap, ""])

        initCustomMapOption()
        initWrap()

def getGridSize(argsList):
	if (argsList[0] == -1): # (-1,) is passed to function on loads
		return []

	listSize = [(6,4), (8,5), (10,6), (13,8), (16,10), (21,13), (26,16), (32,20), (38,24)]
	if idMap == "chess" : listSize = [(6,6), (9,6), (15,9), (21,12), (24,15), (27,18), (30,18), (33,21), (36,21), (39,24), (42,24), (45,27), (48,30)]
	elif idMap == "maze" : listSize = [(6,4), (9,4), (10,6), (14,8), (18,10), (24,14)]

	[eWorldSize] = argsList
	iWorldSize = int(eWorldSize)
	if not iWorldSize in range(6) :
                xSize = gc.getWorldInfo(iWorldSize).getGridWidth()
                ySize = gc.getWorldInfo(iWorldSize).getGridHeight()
                if idMap == "chess" :
                        diffAreas = [abs(xSize*ySize - item[0]*item[1]) for item in listSize]
                        tWorldSize = listSize[diffAreas.index(min(diffAreas))]
                else :
                        tWorldSize = (xSize, ySize)
        else :
                # chess, maze have a custom list . inlandsea, lakes are the smallest maps
                if idMap in ["hub", "pangaea", "ring", "wheel"] : iWorldSize += 1
                elif idMap in ["archipelago", "continents", "customcontinents", "fractals", "islands", "shuffle", "bigandsmall", "hemispheres", "mediumandsmall", "tectonics"] : iWorldSize += 2
                elif idMap in ["terra"] : iWorldSize += 3

                tWorldSize = listSize[iWorldSize]

        writeLog("getGridSize", True, [" world entry : %r , world int : %d , grid size : %r" %(eWorldSize, iWorldSize, tWorldSize)])

	return tWorldSize

def getWrapX():
        return wrapX
	
def getWrapY():
        return wrapY

def getTopLatitude():
        if bGeneratingMap :
                if idMap == "inlandsea" : return 60
                elif idMap == "tectonics" :
                        if cmo[0] == 5 : return 65
        return 90

def getBottomLatitude():
        if bGeneratingMap :
                if idMap == "inlandsea" : return -60
                elif idMap == "tectonics" :
                        if cmo[0] == 5 : return 25
        return -90

def isBonusIgnoreLatitude(): # warning called by StoAddBonuses
        if bGeneratingMap :
                if idMap in ["hub", "ring", "wheel"] : return True
                else : return not selGen["resources"]["resourcesgen"]["resspreadclimate"]
        return False

def beforeGeneration():
        initBeforeGenerationGlobals()

        global iNumConts
        global cont_data
        global xShiftRoll
        global yShiftRoll
        global bSuccessFlag
        global region_data
        global buffer_data
        global center_data
        global hub_data
        global templates
        global shuffledPlayers
        global iTemplateRoll
        global iNumRegions
        global iExtras
        global regions_in_use
        global remaining_regions
        global region_coords
        global isTeamGame
        global wheel_data
        global ySplitRoll
        global yPortionRoll
        global yShiftRoll1
        global yShiftRoll2

        #i prefer keep all different generations in one function ... Alleluia Alt-c
        #all comments are removed from the original scripts and can be read in the default map .
        if idMap == "customcontinents" :
                iPlayers = game.countCivPlayersEverAlive()
                iTeams = game.countCivTeamsEverAlive()
                bThisMapBalanced = False
                xShiftRoll = getRandNum(2, "FoR : Region Shift, Horizontal - Custom Continents PYTHON")
                yShiftRoll = getRandNum(2, "FoR : Region Shift, Vertical - Custom Continents PYTHON")
                userInputContinents = cmo[0]
                if userInputContinents > 1:
                        iNumConts = userInputContinents
                elif userInputContinents == 1:
                        bThisMapBalanced = True
                        if iTeams > 1 and iTeams < 7:
                                iNumConts = iTeams
                        elif iTeams < 2:
                                iNumConts = 2
                        elif iTeams <= 12:
                                iNumConts = int(iTeams / 2)
                        elif iTeams <= 18:
                                iNumConts = int(iTeams / 3)
                        else:
                                iNumConts = 6
                else:
                        numContsRoll = getRandNum(100, "FoR : Number of Continents - Custom Continents PYTHON")
                        byPlayerIndex = {2: [60, 90, 100, 111],
                                         3: [55, 85, 96, 100],
                                         4: [50, 80, 94, 99],
                                         5: [48, 78, 92, 98],
                                         6: [45, 75, 90, 96],
                                         7: [40, 70, 85, 95],
                                         8: [38, 68, 83, 94],
                                         9: [35, 65, 80, 92],
                                         10: [33, 60, 75, 90],
                                         11: [30, 55, 70, 88],
                                         12: [28, 53, 68, 86],
                                         13: [25, 50, 65, 85],
                                         14: [25, 45, 63, 85],
                                         15: [20, 40, 60, 80],
                                         16: [17, 35, 55, 75],
                                         17: [13, 30, 50, 70],
                                         18: [10, 25, 45, 65]
                        }
                        if numContsRoll < byPlayerIndex[iPlayers][0]:
                                iNumConts = 2
                        elif numContsRoll < byPlayerIndex[iPlayers][1]:
                                iNumConts = 3
                        elif numContsRoll < byPlayerIndex[iPlayers][2]:
                                iNumConts = 4
                        elif numContsRoll < byPlayerIndex[iPlayers][3]:
                                iNumConts = 5
                        else:
                                iNumConts = 6
                configs = [0, 0, 10, 9, 7, 6, 6]
                if bThisMapBalanced:
                        templateID = 0
                else:
                        templateID = getRandNum(configs[iNumConts], "FoR : Template - Custom Continents PYTHON")
                templates = {(2,0): {0: [2,
                                         [0.03, 0.47, 0.05, 0.65, 0, 0.3, False, True, 55, 23, 3, -1, -1, 11],
                                         [0.14, 0.36, 0.2, 0.5, 0, 0.3, False, True, 60, 1, 1, -1, -1, 7]],
                                     1: [2,
                                         [0.53, 0.97, 0.05, 0.65, 0, 0.3, False, True, 55, 23, 3, -1, -1, 11],
                                         [0.64, 0.86, 0.2, 0.5, 0, 0.3, False, True, 60, 1, 1, -1, -1, 7]]},
                             (2,1): {0: [7,
                                         [0.04, 0.6, 0.74, 0.9, 0.36, -0.64, False, False, 55, 2, 2, -1, -1, 7],
                                         [0.23, 0.41, 0.78, 0.86, 0.36, -0.64, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.1, 0.3, 0.5, 0.9, 0.6, -0.4, False, False, 55, 1, 2, 6, 7, 7],
                                         [0.05, 0.35, 0.45, 0.95, 0.6, -0.4, False, False, 70, 3, 3, 6, 7, 7],
                                         [0.15, 0.5, 0.4, 0.6, 0.35, 0, False, False, 55, 1, 1, -1, -1, 7],
                                         [0.35, 0.5, 0.2, 0.55, 0.15, 0.25, False, False, 60, 2, 3, 6, 6, 5],
                                         [0.2, 0.4, 0.25, 0.4, 0.4, 0.35, False, False, 80, 4, 3, 6, 6, 5]],
                                     1: [5,
                                         [0.6, 0.9, 0.35, 0.45, -0.5, 0.2, False, False, 60, 1, 1, -1, -1, 7],
                                         [0.55, 0.95, 0.3, 0.5, -0.5, 0.2, False, False, 65, 3, 1, -1, -1, 7],
                                         [0.72, 0.85, 0.25, 0.85, -0.57, -0.1, False, False, 50, 1, 2, 6, 7, 7],
                                         [0.7, 0.9, 0.65, 0.85, -0.6, -0.5, False, False, 70, 3, 3, 6, 6, 7],
                                         [0.7, 0.95, 0.1, 0.3, -0.65, 0.6, False, False, 80, 4, 3, 6, 5, 5]]},
                             (2,2): {0: [7,
                                         [0.1, 0.9, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.1, 0.9, 0.1, 0.4, 0, 0.5, False, False, 60, 2, 1, -1, -1, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.15, 0.5, 0.05, 0.2, 0.35, 0.75, True, False, 75, 3, 1, 6, 5, 3]],
                                     1: [4,
                                         [0.1, 0.9, 0.65, 0.95, 0, -0.6, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.15, 0.85, 0.75, 0.85, 0, -0.6, False, False, 55, 1, 1, -1, -1, 3],
                                         [0.4, 0.6, 0.45, 0.85, 0, -0.3, False, False, 55, 2, 2, 6, 6, 5],
                                         [0.4, 0.6, 0.45, 0.95, 0, -0.4, False, False, 70, 4, 3, 6, 6, 5]]},
                             (2,3): {0: [3,
                                         [0.03, 0.57, 0.05, 0.75, 0.4, 0.2, False, True, 65, 2, 2, -1, -1, 11],
                                         [0.13, 0.47, 0.2, 0.7, 0.4, 0.1, False, True, 75, 4, 3, -1, -1, 7],
                                         [0.22, 0.38, 0.2, 0.6, 0.4, 0.2, False, True, 60, 1, 1, -1, -1, 7]],
                                     1: [3,
                                         [0.63, 0.97, 0.05, 0.75, -0.6, 0.2, False, True, 60, 2, 2, -1, -1, 9],
                                         [0.68, 0.92, 0.15, 0.65, -0.6, 0.2, False, True, 70, 4, 3, -1, -1, 7],
                                         [0.74, 0.86, 0.2, 0.6, -0.6, 0.2, False, True, 55, 1, 1, -1, -1, 5]]},
                             (2,4): {0: [7,
                                         [0.03, 0.47, 0.6, 0.95, 0.5, -0.55, False, False, 60, 2, 1, -1, -1, 9],
                                         [0.03, 0.37, 0.5, 0.95, 0.6, -0.45, False, False, 60, 2, 1, -1, -1, 7],
                                         [0.03, 0.27, 0.4, 0.85, 0.7, -0.25, False, False, 60, 2, 2, -1, -1, 7],
                                         [0.03, 0.17, 0.3, 0.75, 0.8, -0.05, False, False, 60, 2, 3, -1, -1, 5],
                                         [0.13, 0.57, 0.7, 0.95, 0.5, -0.65, False, False, 60, 1, 1, -1, -1, 7],
                                         [0.23, 0.67, 0.8, 0.95, 0.5, -0.75, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.4, 0.6, 0.5, 0.65, 0, -0.15, False, False, 82, 4, 1, 6, 5, 5]],
                                     1: [8,
                                         [0.53, 0.97, 0.2, 0.55, -0.5, 0.25, False, False, 55, 2, 1, -1, -1, 9],
                                         [0.63, 0.97, 0.3, 0.65, -0.6, 0.05, False, False, 55, 2, 1, -1, -1, 7],
                                         [0.73, 0.97, 0.4, 0.75, -0.7, -0.15, False, False, 55, 2, 1, -1, -1, 7],
                                         [0.83, 0.97, 0.5, 0.85, -0.8, -0.35, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.43, 0.87, 0.1, 0.45, -0.3, 0.45, False, False, 60, 2, 1, -1, -1, 7],
                                         [0.33, 0.77, 0.05, 0.35, -0.1, 0.6, False, False, 60, 2, 1, -1, -1, 7],
                                         [0.23, 0.67, 0.05, 0.25, 0.1, 0.7, False, False, 60, 2, 1, -1, -1, 5],
                                         [0.13, 0.57, 0.05, 0.15, 0.3, 0.8, False, False, 60, 1, 1, -1, -1, 3]]},
                             (2,5): {0: [4,
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 70, 2, 1, -1, -1, 9],
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 65, 2, 2, -1, -1, 9],
                                         [0.4, 0.9, 0.05, 0.45, -0.3, 0.5, False, False, 70, 3, 1, -1, -1, 7],
                                         [0.45, 0.85, 0.15, 0.35, -0.3, 0.5, False, False, 50, 1, 1, -1, -1, 3]],
                                     1: [5,
                                         [0.1, 0.5, 0.5, 0.9, 0.4, -0.4, False, False, 60, 3, 1, -1, -1, 9],
                                         [0.15, 0.45, 0.55, 0.85, 0.4, -0.4, False, False, 65, 1, 1, -1, -1, 7],
                                         [0.3, 0.8, 0.75, 0.95, -0.1, -0.7, False, False, 55, 1, 1, -1, -1, 3],
                                         [0.15, 0.25, 0.2, 0.7, 0.6, 0.1, False, False, 45, 1, 2, 6, 7, 3],
                                         [0.05, 0.35, 0.25, 0.65, 0.6, 0.1, False, False, 75, 4, 3, 6, 6, 5]]},
                             (2,6): {0: [3,
                                         [0.03, 0.77, 0.05, 0.45, 0.2, 0, True, False, 55, 2, 2, -1, -1, 7],
                                         [0.21, 0.59, 0.15, 0.35, 0.2, 0, True, False, 60, 1, 1, -1, -1, 5],
                                         [0.33, 0.47, 0.28, 0.52, 0, 0.2, False, False, 70, 3, 3, 6, 6, 3]],
                                     1: [3,
                                         [0.03, 0.77, 0.55, 0.95, 0.2, 0, True, False, 55, 2, 2, -1, -1, 7],
                                         [0.21, 0.59, 0.65, 0.85, 0.2, 0, True, False, 60, 1, 1, -1, -1, 5],
                                         [0.53, 0.67, 0.48, 0.72, 0, -0.2, False, False, 70, 3, 3, 6, 6, 3]]},
                             (2,7): {0: [8,
                                         [0.3, 0.4, 0.1, 0.9, 0.3, 0, False, True, 40, 1, 2, 6, 7, 5],
                                         [0.15, 0.45, 0.1, 0.3, 0.4, 0.6, False, True, 70, 3, 1, 6, 5, 3],
                                         [0.05, 0.4, 0.15, 0.3, 0.55, 0.2, False, True, 60, 1, 1, 6, 5, 3],
                                         [0.3, 0.65, 0.15, 0.3, 0.05, 0.2, False, True, 60, 1, 1, 6, 5, 3],
                                         [0.05, 0.4, 0.5, 0.65, 0.55, 0.2, False, True, 60, 1, 1, 6, 5, 3],
                                         [0.1, 0.25, 0.18, 0.42, 0.65, 0, False, True, 70, 14, 2, 5, 5, 3],
                                         [0.3, 0.65, 0.5, 0.65, 0.05, 0.2, False, True, 60, 1, 1, 6, 5, 3],
                                         [0.35, 0.6, 0.05, 0.35, 0.05, 0.6, False, True, 80, 34, 0, 6, 6, 5]],
                                     1: [3,
                                         [0.7, 0.95, 0.1, 0.7, -0.6, 0.2, False, True, 60, 24, 2, 6, 6, 5],
                                         [0.75, 0.9, 0.2, 0.6, -0.6, 0.2, False, True, 60, 1, 3, 6, 7, 5],
                                         [0.7, 0.95, 0.1, 0.4, -0.6, 0.5, False, True, 80, 34, 2, 6, 6, 3]]},
                             (2,8): {0: [5,
                                         [0.05, 0.6, 0.1, 0.25, 0.35, 0, False, False, 50, 1, 1, -1, -1, 3],
                                         [0.05, 0.6, 0.4, 0.6, 0.35, 0, False, False, 50, 1, 1, -1, -1, 3],
                                         [0.05, 0.6, 0.75, 0.9, 0.35, 0, False, False, 50, 1, 1, -1, -1, 3],
                                         [0.1, 0.25, 0.45, 0.9, 0.65, -0.35, False, False, 45, 1, 2, 5, 6, 3],
                                         [0.4, 0.55, 0.1, 0.55, 0.05, 0.35, False, False, 45, 1, 2, 5, 6, 3]],
                                     1: [4,
                                         [0.7, 0.95, 0.15, 0.45, -0.65, 0, False, False, 65, 24, 3, 6, 6, 3],
                                         [0.67, 0.98, 0.4, 0.6, -0.65, 0, False, False, 50, 1, 1, -1, -1, 3],
                                         [0.67, 0.8, 0.45, 0.9, -0.47, -0.35, False, False, 45, 1, 2, 5, 6, 3],
                                         [0.85, 0.98, 0.1, 0.55, -0.83, 0.35, False, False, 45, 1, 2, 5, 6, 3]]},
                             (2,9): {0: [3,
                                         [0.03, 0.77, 0.05, 0.7, 0.2, 0.25, True, False, 65, 3, 1, -1, -1, 11],
                                         [0.23, 0.57, 0.2, 0.55, 0.2, 0.25, True, False, 55, 12, 1, -1, -1, 7],
                                         [0.13, 0.67, 0.1, 0.65, 0.2, 0.25, True, False, 80, 34, 1, -1, -1, 9]],
                                     1: [3,
                                         [0.05, 0.65, 0.75, 0.95, 0.3, -0.7, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.15, 0.55, 0.8, 0.9, 0.3, -0.7, True, False, 55, 12, 1, -1, -1, 3],
                                         [0.55, 0.85, 0.75, 0.95, -0.3, -0.7, False, False, 75, 34, 1, 6, 5, 3]]},
                             (3,0): {0: [2,
                                         [0.03, 0.48, 0.05, 0.56, 0, 0.39, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.14, 0.36, 0.18, 0.43, 0, 0.39, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.52, 0.97, 0.05, 0.56, 0, 0.39, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.64, 0.86, 0.18, 0.43, 0, 0.39, False, False, 60, 1, 1, -1, -1, 5]],
                                     2: [2,
                                         [0.03, 0.83, 0.64, 0.93, 0.14, -0.57, True, False, 55, 23, 1, -1, -1, 9],
                                         [0.23, 0.63, 0.71, 0.86, 0.14, -0.57, True, False, 60, 1, 1, -1, -1, 5]]},
                             (3,1): {0: [2,
                                         [0.03, 0.57, 0.05, 0.46, 0.4, 0, False, False, 55, 13, 3, -1, -1, 9],
                                         [0.21, 0.39, 0.15, 0.36, 0.4, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.03, 0.57, 0.54, 0.95, 0.4, 0, False, False, 55, 13, 3, -1, -1, 9],
                                         [0.21, 0.39, 0.15, 0.36, 0.4, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     2: [3,
                                         [0.63, 0.97, 0.05, 0.7, -0.6, 0.25, False, False, 55, 13, 3, 6, 6, 9],
                                         [0.72, 0.88, 0.21, 0.54, -0.6, 0.25, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.65, 0.95, 0.75, 0.9, -0.6, -0.65, False, False, 60, 34, 1, 5, 5, 3]]},
                             (3,2): {0: [3,
                                         [0.03, 0.57, 0.05, 0.75, 0.4, 0.2, False, True, 65, 2, 2, -1, -1, 11],
                                         [0.13, 0.47, 0.2, 0.7, 0.4, 0.1, False, True, 75, 4, 3, -1, -1, 7],
                                         [0.22, 0.38, 0.2, 0.6, 0.4, 0.2, False, True, 60, 1, 1, -1, -1, 7]],
                                     1: [3,
                                         [0.63, 0.97, 0.05, 0.5, -0.6, 0.45, False, False, 60, 2, 2, -1, -1, 5],
                                         [0.68, 0.92, 0.15, 0.4, -0.6, 0.45, False, False, 70, 4, 3, -1, -1, 5],
                                         [0.74, 0.86, 0.2, 0.35, -0.6, 0.45, False, False, 55, 1, 1, 6, 5, 3]],
                                     2: [2,
                                         [0.63, 0.97, 0.55, 0.9, -0.6, -0.45, False, False, 60, 23, 3, -1, -1, 5],
                                         [0.74, 0.86, 0.66, 0.88, -0.6, -0.45, False, False, 55, 1, 1, 6, 5, 3]]},
                             (3,3): {0: [5,
                                         [0.05, 0.45, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.05, 0.45, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.05, 0.25, 0.05, 0.2, 0.2, 0.75, True, False, 75, 3, 1, 6, 5, 3]],
                                     1: [5,
                                         [0.55, 0.95, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.55, 0.95, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.55, 0.75, 0.05, 0.2, 0.2, 0.75, True, False, 75, 3, 1, 6, 5, 3]],
                                     2: [4,
                                         [0.1, 0.9, 0.65, 0.95, 0, -0.6, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.15, 0.85, 0.75, 0.85, 0, -0.6, False, False, 55, 1, 1, -1, -1, 3],
                                         [0.4, 0.6, 0.45, 0.85, 0, -0.3, False, False, 55, 2, 2, 6, 6, 5],
                                         [0.4, 0.6, 0.45, 0.95, 0, -0.4, False, False, 70, 4, 3, 6, 6, 5]]},
                             (3,4): {0: [7,
                                         [0.03, 0.47, 0.6, 0.95, 0.5, -0.55, False, False, 60, 2, 1, -1, -1, 9],
                                         [0.03, 0.37, 0.5, 0.95, 0.6, -0.45, False, False, 60, 2, 1, -1, -1, 7],
                                         [0.03, 0.27, 0.4, 0.85, 0.7, -0.25, False, False, 60, 2, 2, -1, -1, 7],
                                         [0.03, 0.17, 0.3, 0.75, 0.8, -0.05, False, False, 60, 2, 3, -1, -1, 5],
                                         [0.13, 0.57, 0.7, 0.95, 0.3, -0.65, False, False, 60, 1, 1, -1, -1, 7],
                                         [0.23, 0.67, 0.8, 0.95, 0.1, -0.75, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.4, 0.6, 0.5, 0.65, 0, -0.15, False, False, 82, 4, 1, 6, 5, 5]],
                                     1: [5,
                                         [0.53, 0.97, 0.45, 0.55, -0.5, 0, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.63, 0.97, 0.35, 0.65, -0.6, 0, False, False, 55, 23, 3, -1, -1, 5],
                                         [0.73, 0.97, 0.25, 0.75, -0.7, 0, False, False, 55, 2, 3, -1, -1, 7],
                                         [0.83, 0.97, 0.15, 0.85, -0.8, 0, False, False, 55, 2, 3, -1, -1, 5],
                                         [0.9, 0.97, 0.05, 0.95, -0.87, 0, False, False, 50, 1, 2, 5, 6, 3]],
                                     2: [5,
                                         [0.43, 0.47, 0.05, 0.5, 0.1, 0.45, False, False, 45, 1, 2, 5, 6, 1],
                                         [0.33, 0.57, 0.05, 0.4, 0.1, 0.55, False, False, 55, 2, 1, -1, -1, 3],
                                         [0.23, 0.67, 0.05, 0.3, 0.1, 0.65, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.13, 0.77, 0.05, 0.2, 0.1, 0.75, False, False, 55, 2, 1, -1, -1, 3],
                                         [0.03, 0.87, 0.05, 0.1, 0.1, 0.85, False, False, 50, 1, 1, 7, 6, 1]]},
                             (3,5): {0: [4,
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 70, 2, 1, -1, -1, 9],
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 65, 23, 3, -1, -1, 9],
                                         [0.4, 0.9, 0.05, 0.45, -0.3, 0.5, False, False, 70, 3, 1, -1, -1, 7],
                                         [0.45, 0.85, 0.15, 0.35, -0.3, 0.5, False, False, 50, 1, 1, -1, -1, 3]],
                                     1: [2,
                                         [0.55, 0.95, 0.7, 0.9, -0.5, -0.6, False, False, 65, 34, 1, -1, -1, 3],
                                         [0.3, 0.9, 0.75, 0.95, -0.2, -0.7, False, False, 50, 1, 1, -1, -1, 3]],
                                     2: [4,
                                         [0.05, 0.25, 0.4, 0.9, 0.7, -0.3, False, False, 60, 13, 3, -1, -1, 5],
                                         [0.15, 0.45, 0.5, 0.65, 0.4, -0.15, False, False, 65, 1, 1, -1, -1, 3],
                                         [0.15, 0.25, 0.2, 0.6, 0.6, 0.2, False, False, 45, 1, 2, 5, 6, 3],
                                         [0.05, 0.35, 0.25, 0.65, 0.6, 0.1, False, False, 75, 4, 3, 6, 6, 5]]},
                             (3,6): {0: [6,
                                         [0.1, 0.2, 0.1, 0.9, 0, 0, False, False, 40, 1, 2, 5, 6, 3],
                                         [0.05, 0.47, 0.05, 0.35, 0, 0, False, False, 65, 23, 1, -1, -1, 5],
                                         [0.05, 0.47, 0.1, 0.25, 0, 0, False, False, 60, 1, 1, -1, -1, 3],
                                         [0.05, 0.47, 0.65, 0.95, 0, 0, False, False, 65, 23, 1, -1, -1, 5],
                                         [0.05, 0.47, 0.7, 0.95, 0, 0, False, False, 60, 1, 1, -1, -1, 3],
                                         [0.05, 0.25, 0.15, 0.85, 0, 0, False, False, 70, 4, 3, 5, 6, 3]],
                                     1: [2,
                                         [0.3, 0.7, 0.4, 0.6, 0, 0, False, False, 55, 14, 3, -1, -1, 5],
                                         [0.35, 0.65, 0.45, 0.55, 0, 0, False, False, 45, 1, 1, -1, -1, 3]],
                                     2: [6,
                                         [0.8, 0.9, 0.1, 0.9, 0, 0, False, False, 40, 1, 2, 5, 6, 3],
                                         [0.53, 0.95, 0.05, 0.35, 0, 0, False, False, 65, 23, 1, -1, -1, 5],
                                         [0.53, 0.95, 0.1, 0.25, 0, 0, False, False, 60, 1, 1, -1, -1, 3],
                                         [0.53, 0.95, 0.65, 0.95, 0, 0, False, False, 65, 23, 1, -1, -1, 5],
                                         [0.53, 0.95, 0.7, 0.95, 0, 0, False, False, 60, 1, 1, -1, -1, 3],
                                         [0.75, 0.95, 0.15, 0.85, 0, 0, False, False, 70, 4, 3, 5, 6, 3]]},
                             (3,7): {0: [3,
                                         [0.03, 0.77, 0.05, 0.7, 0.2, 0.25, True, False, 65, 3, 1, -1, -1, 11],
                                         [0.23, 0.57, 0.2, 0.55, 0.2, 0.25, True, False, 55, 12, 1, -1, -1, 7],
                                         [0.13, 0.67, 0.1, 0.65, 0.2, 0.25, True, False, 80, 34, 1, -1, -1, 9]],
                                     1: [3,
                                         [0.03, 0.47, 0.75, 0.95, 0, -0.7, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.1, 0.4, 0.8, 0.9, 0, -0.7, False, False, 55, 12, 1, -1, -1, 3],
                                         [0.15, 0.35, 0.75, 0.95, 0, -0.7, False, False, 75, 34, 1, 6, 5, 3]],
                                     2: [3,
                                         [0.53, 0.97, 0.75, 0.95, 0, -0.7, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.6, 0.9, 0.8, 0.9, 0, -0.7, False, False, 55, 12, 1, -1, -1, 3],
                                         [0.65, 0.85, 0.75, 0.95, 0, -0.7, False, False, 75, 34, 1, 6, 5, 3]]},
                             (3,8): {0: [6,
                                         [0.03, 0.57, 0.7, 0.95, 0, -0.65, False, False, 55, 23, 1, -1, -1, 3],
                                         [0.15, 0.55, 0.8, 0.85, 0, -0.65, False, False, 35, 1, 1, -1, -1, 2],
                                         [0.43, 0.97, 0.05, 0.3, 0, 0.65, False, False, 55, 23, 1, -1, -1, 3],
                                         [0.45, 0.85, 0.15, 0.2, 0, 0.65, False, False, 35, 1, 1, -1, -1, 2],
                                         [0.43, 0.57, 0.05, 0.95, 0, 0, False, False, 50, 24, 2, 6, 6, 3],
                                         [0.47, 0.53, 0.1, 0.9, 0, 0, False, False, 20, 1, 2, 5, 6, 1]],
                                     1: [4,
                                         [0.03, 0.37, 0.2, 0.6, 0, 0.3, False, False, 70, 34, 1, -1, -1, 5],
                                         [0.03, 0.17, 0.15, 0.55, 0.2, 0.3, True, False, 45, 12, 2, 5, 6, 3],
                                         [0.03, 0.37, 0.05, 0.2, 0, 0.75, False, False, 55, 1, 1, 6, 5, 3],
                                         [0.03, 0.37, 0.5, 0.65, 0, -0.15, False, False, 55, 1, 1, 6, 5, 3]],
                                         2: [4,
                                         [0.63, 0.97, 0.4, 0.8, 0, -0.3, False, False, 70, 34, 1, -1, -1, 5],
                                         [0.63, 0.77, 0.45, 0.85, 0.2, -0.3, True, False, 45, 12, 2, 5, 6, 3],
                                         [0.63, 0.97, 0.8, 0.95, 0, -0.75, False, False, 55, 1, 1, 6, 5, 3],
                                         [0.63, 0.97, 0.35, 0.5, 0, 0.15, False, False, 55, 1, 1, 6, 5, 3]]},
                             (4,0): {0: [2,
                                         [0.03, 0.47, 0.05, 0.45, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.14, 0.36, 0.15, 0.35, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.53, 0.97, 0.05, 0.45, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.64, 0.86, 0.15, 0.35, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     2: [2,
                                         [0.03, 0.47, 0.55, 0.95, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.14, 0.36, 0.65, 0.85, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     3: [2,
                                         [0.53, 0.97, 0.55, 0.95, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.64, 0.86, 0.65, 0.85, 0, 0, False, False, 60, 1, 1, -1, -1, 5]]},
                             (4,1): {0: [3,
                                         [0.03, 0.47, 0.05, 0.65, 0, 0.3, False, False, 70, 34, 3, -1, -1, 9],
                                         [0.07, 0.43, 0.15, 0.55, 0, 0.3, False, False, 65, 23, 3, -1, -1, 7],
                                         [0.14, 0.36, 0.2, 0.5, 0, 0.3, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.53, 0.97, 0.05, 0.3, 0, 0.65, False, False, 55, 24, 3, -1, -1, 5],
                                         [0.64, 0.86, 0.1, 0.25, 0, 0.65, False, False, 60, 1, 1, -1, -1, 3]],
                                     2: [2,
                                         [0.03, 0.47, 0.70, 0.95, 0, -0.65, False, False, 55, 24, 3, -1, -1, 5],
                                         [0.14, 0.36, 0.75, 0.9, 0, -0.65, False, False, 60, 1, 1, -1, -1, 3]],
                                     3: [3,
                                         [0.53, 0.97, 0.35, 0.95, 0, -0.3, False, False, 70, 34, 3, -1, -1, 9],
                                         [0.57, 0.93, 0.45, 0.85, 0, -0.3, False, False, 65, 23, 3, -1, -1, 7],
                                         [0.64, 0.86, 0.5, 0.8, 0, -0.3, False, False, 60, 1, 1, -1, -1, 5]]},
                             (4,2): {0: [4,
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 70, 2, 1, -1, -1, 9],
                                         [0.6, 0.95, 0.2, 0.65, -0.55, 0.15, False, False, 65, 23, 3, -1, -1, 9],
                                         [0.4, 0.9, 0.05, 0.45, -0.3, 0.5, False, False, 70, 3, 1, -1, -1, 7],
                                         [0.45, 0.85, 0.15, 0.35, -0.3, 0.5, False, False, 50, 1, 1, -1, -1, 3]],
                                     1: [2,
                                         [0.6, 0.95, 0.75, 0.9, -0.55, -0.65, False, False, 55, 1, 1, -1, -1, 3],
                                         [0.6, 0.95, 0.7, 0.95, -0.55, -0.65, False, False, 50, 23, 3, -1, -1, 3]],
                                     2: [2,
                                         [0.1, 0.55, 0.5, 0.9, 0.35, -0.4, False, False, 60, 14, 3, -1, -1, 7],
                                         [0.2, 0.45, 0.6, 0.8, 0.35, -0.4, False, False, 55, 1, 1, -1, -1, 3]],
                                     3: [3,
                                         [0.05, 0.35, 0.1, 0.4, 0.6, 0.5, False, False, 60, 13, 3, 6, 6, 5],
                                         [0.11, 0.28, 0.15, 0.35, 0.61, 0.5, False, False, 50, 1, 3, 6, 6, 3],
                                         [0.03, 0.36, 0.05, 0.45, 0.61, 0.5, False, False, 75, 35, 3, 6, 6, 5]]},
                             (4,3): {0: [5,
                                         [0.05, 0.45, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.05, 0.45, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.05, 0.3, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.15, 0.35, 0.05, 0.2, 0, 0.75, False, False, 75, 3, 1, 6, 5, 3]],
                                     1: [5,
                                         [0.55, 0.95, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.55, 0.95, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.7, 0.95, 0.15, 0.6, 0, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.65, 0.85, 0.05, 0.2, 0, 0.75, False, False, 75, 3, 1, 6, 5, 3]],
                                     2: [3,
                                         [0.55, 0.95, 0.8, 0.95, -0.5, -0.75, False, False, 45, 34, 1, -1, -1, 3],
                                         [0.7, 0.95, 0.65, 0.9, -0.65, -0.55, False, False, 55, 2, 3, -1, -1, 3],
                                         [0.75, 0.9, 0.75, 0.85, -0.65, -0.6, False, False, 60, 1, 1, -1, -1, 3]],
                                     3: [5,
                                         [0.05, 0.45, 0.65, 0.95, 0.5, -0.6, False, False, 55, 3, 1, -1, -1, 5],
                                         [0.15, 0.5, 0.7, 0.9, 0.35, -0.6, False, False, 55, 2, 1, -1, -1, 3],
                                         [0.35, 0.5, 0.68, 0.75, 0.15, -0.43, False, False, 35, 1, 1, -1, -1, 3],
                                         [0.4, 0.6, 0.45, 0.75, 0, -0.2, False, False, 55, 2, 3, 6, 6, 5],
                                         [0.35, 0.65, 0.45, 0.75, 0, -0.2, False, False, 70, 4, 3, 6, 6, 5]]},
                             (4,4): {0: [4,
                                         [0.33, 0.47, 0.55, 0.95, 0.2, -0.5, False, False, 50, 23, 1, -1, -1, 3],
                                         [0.23, 0.57, 0.65, 0.95, 0.2, -0.6, False, False, 55, 12, 1, -1, -1, 5],
                                         [0.13, 0.67, 0.75, 0.95, 0.2, -0.7, False, False, 55, 23, 1, -1, -1, 3],
                                         [0.03, 0.77, 0.85, 0.95, 0.2, -0.8, False, False, 50, 1, 1, -1, -1, 3]],
                                     1: [4,
                                         [0.03, 0.37, 0.45, 0.5, 0.6, 0.05, False, False, 40, 1, 1, 6, 5, 1],
                                         [0.03, 0.27, 0.35, 0.6, 0.7, 0.05, False, False, 45, 13, 3, 6, 6, 3],
                                         [0.03, 0.17, 0.25, 0.7, 0.8, 0.05, False, False, 45, 13, 3, 6, 6, 3],
                                         [0.03, 0.12, 0.2, 0.75, 0.85, 0.05, False, False, 40, 1, 2, 5, 6, 1]],
                                     2: [5,
                                         [0.53, 0.97, 0.45, 0.55, -0.5, 0, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.63, 0.97, 0.35, 0.65, -0.6, 0, False, False, 55, 23, 3, -1, -1, 5],
                                         [0.73, 0.97, 0.25, 0.75, -0.7, 0, False, False, 55, 2, 3, -1, -1, 7],
                                         [0.83, 0.97, 0.15, 0.85, -0.8, 0, False, False, 55, 2, 3, -1, -1, 5],
                                         [0.9, 0.97, 0.1, 0.9, -0.87, 0, False, False, 50, 1, 2, 5, 6, 3]],
                                     3: [5,
                                         [0.38, 0.52, 0.05, 0.45, 0.1, 0.5, False, False, 45, 1, 2, 5, 6, 1],
                                         [0.33, 0.57, 0.05, 0.4, 0.1, 0.55, False, False, 55, 2, 1, -1, -1, 3],
                                         [0.23, 0.67, 0.05, 0.3, 0.1, 0.65, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.13, 0.77, 0.05, 0.2, 0.1, 0.75, False, False, 55, 2, 1, -1, -1, 3],
                                         [0.03, 0.87, 0.05, 0.1, 0.1, 0.85, False, False, 50, 1, 1, 7, 6, 1]]},
                             (4,5): {0: [3,
                                         [0.03, 0.77, 0.05, 0.7, 0.2, 0.25, False, False, 65, 3, 1, -1, -1, 11],
                                         [0.23, 0.57, 0.2, 0.55, 0.2, 0.25, False, False, 55, 12, 1, -1, -1, 7],
                                         [0.13, 0.67, 0.1, 0.65, 0.2, 0.25, False, False, 80, 34, 1, -1, -1, 9]],
                                     1: [3,
                                         [0.83, 0.97, 0.1, 0.7, -0.8, 0.2, False, False, 70, 34, 2, 6, 6, 3],
                                         [0.83, 0.97, 0.1, 0.7, -0.8, 0.2, False, False, 55, 23, 3, 6, 6, 3],
                                         [0.88, 0.93, 0.2, 0.6, -0.8, 0.2, False, False, 45, 1, 2, 5, 6, 1]],
                                     2: [3,
                                         [0.03, 0.47, 0.75, 0.95, 0, -0.7, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.1, 0.4, 0.8, 0.9, 0, -0.7, False, False, 55, 12, 1, -1, -1, 3],
                                         [0.15, 0.35, 0.75, 0.95, 0, -0.7, False, False, 75, 34, 1, 6, 5, 3]],
                                     3: [3,
                                         [0.53, 0.97, 0.75, 0.95, 0, -0.7, False, False, 55, 2, 1, -1, -1, 5],
                                         [0.6, 0.9, 0.8, 0.9, 0, -0.7, False, False, 55, 12, 1, -1, -1, 3],
                                         [0.65, 0.85, 0.75, 0.95, 0, -0.7, False, False, 75, 34, 1, 6, 5, 3]]},
                             (4,6): {0: [2,
                                         [0.03, 0.37, 0.05, 0.55, 0.6, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.12, 0.28, 0.15, 0.45, 0.6, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.03, 0.37, 0.6, 0.95, 0.6, 0, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.12, 0.28, 0.7, 0.85, 0.6, 0, False, False, 50, 1, 1, -1, -1, 3]],
                                     2: [4,
                                         [0.43, 0.67, 0.25, 0.65, -0.1, 0.1, False, False, 70, 24, 3, -1, -1, 5],
                                         [0.45, 0.65, 0.2, 0.6, -0.1, 0.2, False, False, 55, 2, 3, -1, -1, 5],
                                         [0.43, 0.97, 0.05, 0.35, -0.4, 0.6, False, False, 55, 23, 3, -1, -1, 5],
                                         [0.55, 0.85, 0.1, 0.3, -0.4, 0.6, False, False, 60, 1, 1, -1, -1, 3]],
                                     3: [4,
                                         [0.73, 0.97, 0.35, 0.75, -0.7, -0.1, False, False, 70, 24, 3, -1, -1, 5],
                                         [0.73, 0.97, 0.4, 0.8, -0.7, -0.2, False, False, 55, 2, 3, -1, -1, 5],
                                         [0.43, 0.97, 0.65, 0.95, -0.4, -0.6, False, False, 55, 23, 3, -1, -1, 5],
                                         [0.55, 0.85, 0.7, 0.9, -0.4, -0.6, False, False, 60, 1, 1, -1, -1, 3]]},
                             (5,0): {0: [2,
                                         [0.02, 0.32, 0.05, 0.55, 0, 0.4, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.09, 0.25, 0.18, 0.43, 0, 0.4, False, False, 60, 1, 1, -1, -1, 3]],
                                     1: [2,
                                         [0.35, 0.65, 0.05, 0.55, 0, 0.4, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.42, 0.58, 0.18, 0.43, 0, 0.4, False, False, 60, 1, 1, -1, -1, 3]],
                                     2: [2,
                                         [0.68, 0.98, 0.05, 0.55, 0, 0.4, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.75, 0.86, 0.18, 0.43, 0, 0.4, False, False, 60, 1, 1, -1, -1, 3]],
                                     3: [2,
                                         [0.02, 0.48, 0.62, 0.95, 0, -0.57, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.13, 0.37, 0.7, 0.87, 0, -0.57, False, False, 60, 1, 1, -1, -1, 3]],
                                     4: [2,
                                         [0.52, 0.98, 0.62, 0.95, 0, -0.57, False, False, 55, 23, 3, -1, -1, 7],
                                         [0.63, 0.87, 0.7, 0.87, 0, -0.57, False, False, 60, 1, 1, -1, -1, 3]]},
                             (5,1): {0: [2,
                                         [0.03, 0.47, 0.05, 0.4, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.14, 0.36, 0.15, 0.3, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     1: [2,
                                         [0.53, 0.97, 0.05, 0.4, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.64, 0.86, 0.15, 0.3, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     2: [2,
                                         [0.03, 0.47, 0.6, 0.95, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.14, 0.36, 0.7, 0.85, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     3: [2,
                                         [0.53, 0.97, 0.6, 0.95, 0, 0, False, False, 55, 23, 3, -1, -1, 9],
                                         [0.64, 0.86, 0.7, 0.85, 0, 0, False, False, 60, 1, 1, -1, -1, 5]],
                                     4: [3,
                                         [0.05, 0.95, 0.45, 0.55, 0, 0, False, False, 70, 24, 1, -1, -1, 3],
                                         [0.1, 0.9, 0.45, 0.55, 0, 0, False, False, 70, 3, 1, -1, -1, 3],
                                         [0.15, 0.85, 0.48, 0.52, 0, 0, False, False, 0, 1, 1, 5, 5, 1]]},
                             (5,2): {0: [2,
                                         [0.03, 0.57, 0.7, 0.95, 0, -0.65, False, False, 55, 23, 1, -1, -1, 3],
                                         [0.15, 0.55, 0.8, 0.85, 0, -0.65, False, False, 35, 1, 1, -1, -1, 2]],
                                     1: [2,
                                         [0.43, 0.97, 0.05, 0.3, 0, 0.65, False, False, 55, 23, 1, -1, -1, 3],
                                         [0.45, 0.85, 0.15, 0.2, 0, 0.65, False, False, 35, 1, 1, -1, -1, 2]],
                                     2: [2,
                                         [0.43, 0.57, 0.35, 0.65, 0, 0, False, False, 50, 24, 2, 6, 6, 3],
                                         [0.47, 0.53, 0.35, 0.65, 0, 0, False, False, 20, 1, 2, 5, 6, 1]],
                                     3: [4,
                                         [0.03, 0.37, 0.2, 0.6, 0, 0.3, False, False, 70, 34, 1, -1, -1, 5],
                                         [0.03, 0.17, 0.15, 0.55, 0.2, 0.3, True, False, 45, 12, 2, 5, 6, 3],
                                         [0.03, 0.37, 0.05, 0.2, 0, 0.75, False, False, 55, 1, 1, 6, 5, 3],
                                         [0.03, 0.37, 0.5, 0.65, 0, -0.15, False, False, 55, 1, 1, 6, 5, 3]],
                                         4: [4,
                                         [0.63, 0.97, 0.4, 0.8, 0, -0.3, False, False, 70, 34, 1, -1, -1, 5],
                                         [0.63, 0.77, 0.45, 0.85, 0.2, -0.3, True, False, 45, 12, 2, 5, 6, 3],
                                         [0.63, 0.97, 0.8, 0.95, 0, -0.75, False, False, 55, 1, 1, 6, 5, 3],
                                         [0.63, 0.97, 0.35, 0.5, 0, 0.15, False, False, 55, 1, 1, 6, 5, 3]]},
                             (5,3): {0: [5,
                                         [0.03, 0.47, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.03, 0.47, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.03, 0.32, 0.15, 0.6, 0.65, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.03, 0.32, 0.15, 0.6, 0.65, 0.25, False, False, 60, 4, 3, 6, 5, 5],
                                         [0.13, 0.37, 0.05, 0.2, 0, 0.75, False, False, 75, 3, 1, 6, 5, 3]],
                                     1: [5,
                                         [0.53, 0.97, 0.2, 0.3, 0, 0.5, False, False, 45, 1, 1, -1, -1, 3],
                                         [0.53, 0.97, 0.1, 0.4, 0, 0.5, False, False, 60, 23, 1, -1, -1, 5],
                                         [0.53, 0.82, 0.15, 0.6, -0.35, 0.25, False, False, 70, 2, 3, 6, 6, 5],
                                         [0.53, 0.82, 0.15, 0.6, -0.35, 0.25, False, False, 60, 3, 3, 6, 5, 5],
                                         [0.63, 0.85, 0.05, 0.2, 0, 0.75, False, False, 75, 3, 1, 6, 5, 3]],
                                     2: [5,
                                         [0.38, 0.47, 0.45, 0.75, 0.15, -0.2, False, False, 50, 2, 3, 6, 5, 3],
                                         [0.4, 0.45, 0.5, 0.75, 0.15, -0.25, False, False, 50, 1, 2, 5, 6, 1],
                                         [0.03, 0.32, 0.65, 0.95, 0.65, -0.6, False, False, 60, 24, 3, 6, 5, 3],
                                         [0.08, 0.27, 0.7, 0.9, 0.65, -0.6, False, False, 50, 2, 3, 6, 5, 1],
                                         [0.03, 0.47, 0.65, 0.75, 0.5, -0.4, False, False, 50, 1, 1, 6, 5, 2]],
                                     3: [4,
                                         [0.53, 0.82, 0.65, 0.95, -0.35, -0.6, False, False, 60, 24, 3, 6, 5, 3],
                                         [0.53, 0.82, 0.7, 0.9, -0.35, -0.6, False, False, 50, 2, 3, 6, 5, 1],
                                         [0.37, 0.82, 0.8, 0.95, -0.19, -0.75, False, False, 55, 24, 3, -1, -1, 3],
                                         [0.42, 0.77, 0.85, 0.9, -0.19, -0.75, False, False, 40, 1, 1, -1, -1, 1]],
                                     4: [2,
                                         [0.87, 0.98, 0.45, 0.95, -0.85, -0.4, False, False, 55, 23, 3, -1, -1, 3],
                                         [0.87, 0.98, 0.5, 0.9, -0.85, -0.4, False, False, 60, 1, 1, -1, -1, 3]]},
                             (5,4): {0: [4,
                                         [0.03, 0.37, 0.05, 0.25, 0, 0, False, False, 55, 23, 1, 6, 5, 3],
                                         [0.1, 0.3, 0.1, 0.2, 0, 0, False, False, 50, 1, 1, 6, 5, 2],
                                         [0.03, 0.17, 0.1, 0.47, 0, 0, False, False, 60, 24, 1, 5, 5, 3],
                                         [0.05, 0.15, 0.05, 0.45, 0, 0, False, False, 50, 2, 1, 5, 5, 3]],
                                     1: [4,
                                         [0.03, 0.37, 0.75, 0.95, 0, 0, False, False, 55, 23, 1, 6, 5, 3],
                                         [0.1, 0.3, 0.8, 0.9, 0, 0, False, False, 50, 1, 1, 6, 5, 2],
                                         [0.03, 0.17, 0.53, 0.9, 0, 0, False, False, 60, 24, 1, 5, 5, 3],
                                         [0.05, 0.15, 0.55, 0.95, 0, 0, False, False, 50, 2, 1, 5, 5, 3]],
                                     2: [4,
                                         [0.63, 0.97, 0.05, 0.25, 0, 0, False, False, 55, 23, 1, 6, 5, 3],
                                         [0.7, 0.9, 0.1, 0.2, 0, 0, False, False, 50, 1, 1, 6, 5, 2],
                                         [0.83, 0.97, 0.1, 0.47, 0, 0, False, False, 60, 24, 1, 5, 5, 3],
                                         [0.85, 0.95, 0.05, 0.45, 0, 0, False, False, 50, 2, 1, 5, 5, 3]],
                                     3: [4,
                                         [0.63, 0.97, 0.75, 0.95, 0, 0, False, False, 55, 23, 1, 6, 5, 3],
                                         [0.7, 0.9, 0.8, 0.9, 0, 0, False, False, 50, 1, 1, 6, 5, 2],
                                         [0.83, 0.97, 0.53, 0.9, 0, 0, False, False, 60, 24, 1, 5, 5, 3],
                                         [0.85, 0.95, 0.55, 0.95, 0, 0, False, False, 50, 2, 1, 5, 5, 3]],
                                     4: [7,
                                         [0.43, 0.57, 0.1, 0.4, 0, 0, False, False, 70, 34, 1, 6, 5, 3],
                                         [0.43, 0.57, 0.6, 0.85, 0, 0, False, False, 70, 34, 1, 6, 5, 3],
                                         [0.43, 0.57, 0.1, 0.4, 0, 0, False, False, 55, 2, 3, 6, 5, 3],
                                         [0.43, 0.57, 0.6, 0.85, 0, 0, False, False, 55, 2, 3, 6, 5, 3],
                                         [0.23, 0.77, 0.3, 0.7, 0, 0, False, False, 60, 3, 3, -1, -1, 7],
                                         [0.33, 0.67, 0.4, 0.6, 0, 0, False, False, 50, 5, 3, 6, 5, 5],
                                         [0.28, 0.72, 0.35, 0.65, 0, 0, False, False, 50, 2, 1, -1, -1, 5]]},
                             (5,5): {0: [3,
                                         [0.43, 0.97, 0.05, 0.45, -0.4, 0.5, False, False, 55, 2, 2, -1, -1, 7],
                                         [0.55, 0.85, 0.15, 0.35, -0.4, 0.5, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.5, 0.9, 0.1, 0.4, -0.4, 0.5, False, False, 70, 3, 3, 6, 6, 5]],
                                     1: [3,
                                         [0.23, 0.77, 0.55, 0.95, 0, -0.5, False, False, 55, 2, 2, -1, -1, 7],
                                         [0.35, 0.65, 0.65, 0.85, 0, -0.5, False, False, 60, 1, 1, -1, -1, 5],
                                         [0.3, 0.7, 0.6, 0.9, 0, -0.5, False, False, 70, 3, 3, 6, 6, 5]],
                                     2: [2,
                                         [0.03, 0.37, 0.05, 0.45, 0.6, 0.5, False, False, 55, 23, 3, 6, 5, 5],
                                         [0.1, 0.3, 0.15, 0.35, 0.6, 0.5, False, False, 50, 1, 1, 6, 5, 3]],
                                     3: [2,
                                         [0.03, 0.17, 0.5, 0.95, 0, -0.45, False, False, 55, 23, 3, 6, 5, 5],
                                         [0.05, 0.15, 0.55, 0.9, 0, -0.45, False, False, 50, 1, 3, 6, 5, 3]],
                                     4: [2,
                                         [0.83, 0.97, 0.5, 0.95, 0, -0.45, False, False, 55, 23, 3, 6, 5, 5],
                                         [0.85, 0.95, 0.55, 0.9, 0, -0.45, False, False, 50, 1, 3, 6, 5, 3]]},
                             (6,0): {0: [2,
                                         [0.02, 0.32, 0.05, 0.47, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.09, 0.25, 0.15, 0.35, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.36, 0.64, 0.05, 0.47, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.42, 0.58, 0.15, 0.35, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [2,
                                         [0.68, 0.98, 0.05, 0.47, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.75, 0.91, 0.15, 0.35, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [2,
                                         [0.02, 0.32, 0.53, 0.95, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.09, 0.25, 0.65, 0.85, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.36, 0.64, 0.53, 0.95, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.42, 0.58, 0.65, 0.85, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.68, 0.98, 0.53, 0.95, 0, 0, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.75, 0.91, 0.65, 0.85, 0, 0, False, False, 60, 1, 1, 5, 5, 3]]},
                             (6,1): {0: [2,
                                         [0.02, 0.32, 0.05, 0.37, 0, 0.58, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.09, 0.25, 0.15, 0.25, 0, 0.58, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.36, 0.64, 0.05, 0.57, 0, 0.38, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.42, 0.58, 0.15, 0.45, 0, 0.38, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [2,
                                         [0.68, 0.98, 0.05, 0.37, 0, 0.58, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.75, 0.91, 0.15, 0.25, 0, 0.58, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [2,
                                         [0.02, 0.32, 0.43, 0.95, 0, -0.38, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.09, 0.25, 0.55, 0.85, 0, -0.38, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.36, 0.64, 0.63, 0.95, 0, -0.58, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.42, 0.58, 0.75, 0.85, 0, -0.58, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.68, 0.98, 0.43, 0.95, 0, -0.38, False, False, 55, 23, 3, 6, 6, 7],
                                         [0.75, 0.91, 0.55, 0.85, 0, -0.38, False, False, 60, 1, 1, 5, 5, 3]]},
                             (6,2): {0: [2,
                                         [0.03, 0.47, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.4, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.53, 0.72, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.57, 0.67, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [2,
                                         [0.77, 0.97, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.82, 0.92, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [2,
                                         [0.02, 0.32, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.25, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.35, 0.65, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.42, 0.58, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.68, 0.98, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.75, 0.9, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]]},
                             (6,3): {0: [2,
                                         [0.02, 0.35, 0.06, 0.62, 0.63, 0.32, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.27, 0.2, 0.5, 0.63, 0.32, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.02, 0.35, 0.66, 0.94, 0.63, -0.6, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.27, 0.73, 0.87, 0.63, -0.6, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [2,
                                         [0.39, 0.61, 0.05, 0.48, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.45, 0.55, 0.16, 0.37, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [2,
                                         [0.39, 0.61, 0.52, 0.95, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.45, 0.55, 0.63, 0.84, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.65, 0.98, 0.06, 0.62, -0.63, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.73, 0.9, 0.2, 0.5, 0, -0.63, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.65, 0.98, 0.66, 0.94, -0.63, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.73, 0.9, 0.73, 0.87, -0.63, 0, False, False, 60, 1, 1, 5, 5, 3]]},
                             (6,4): {0: [2,
                                         [0.03, 0.27, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.08, 0.22, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.33, 0.67, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.4, 0.6, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [2,
                                         [0.73, 0.97, 0.05, 0.53, 0, 0.42, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.78, 0.92, 0.17, 0.41, 0, 0.42, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [2,
                                         [0.02, 0.32, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.25, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.35, 0.65, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.42, 0.58, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.68, 0.98, 0.58, 0.95, 0, -0.53, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.75, 0.9, 0.67, 0.84, 0, -0.53, False, False, 60, 1, 1, 5, 5, 3]]},
                             (6,5): {0: [2,
                                         [0.02, 0.6, 0.06, 0.34, 0.38, 0.6, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.53, 0.13, 0.27, 0.38, 0.6, False, False, 60, 1, 1, 5, 5, 3]],
                                     1: [2,
                                         [0.02, 0.35, 0.38, 0.62, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.27, 0.44, 0.56, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     2: [4,
                                         [0.02, 0.35, 0.66, 0.94, 0.62, -0.6, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.1, 0.27, 0.73, 0.87, 0.62, -0.6, False, False, 60, 1, 1, 5, 5, 3],
                                         [0.39, 0.61, 0.05, 0.48, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.45, 0.55, 0.16, 0.37, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     3: [4,
                                         [0.39, 0.61, 0.52, 0.95, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.45, 0.55, 0.63, 0.84, 0, 0, False, False, 60, 1, 1, 5, 5, 3],
                                         [0.4, 0.98, 0.06, 0.34, -0.38, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.47, 0.9, 0.13, 0.27, -0.38, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     4: [2,
                                         [0.65, 0.98, 0.38, 0.62, 0, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.73, 0.9, 0.44, 0.56, 0, 0, False, False, 60, 1, 1, 5, 5, 3]],
                                     5: [2,
                                         [0.65, 0.98, 0.66, 0.94, -0.62, 0, False, False, 55, 23, 3, 6, 6, 5],
                                         [0.73, 0.9, 0.73, 0.87, -0.62, 0, False, False, 60, 1, 1, 5, 5, 3]]}
                }
                cont_data = templates[(iNumConts, templateID)]
        elif idMap == "hub" :
                iPlayers = game.countCivPlayersEverAlive()
                if iPlayers < 2 or iPlayers > 18:
                        bSuccessFlag = False
                        return 0
                else:
                        bSuccessFlag = True
                userInputLandmass = cmo[0]
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.8, 1.0, 0.333, 1.0],
                                         2: [0.2, 0.6, 0.0, 0.333]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.167, 0.4, 0.8],
                                         1: [0.333, 0.667, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.583, 0.917, 0.0, 0.2],
                                         4: [0.083, 0.417, 0.0, 0.2]},
                                     6: {0: [0.0, 0.333, 0.8, 1.0],
                                         1: [0.5, 0.833, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.667, 1.0, 0.0, 0.2],
                                         4: [0.167, 0.5, 0.0, 0.2],
                                         5: [0.0, 0.167, 0.2, 0.6]},
                                     7: {0: [0.0, 0.2, 0.75, 1.0],
                                         1: [0.4, 0.6, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.75, 1.0],
                                         3: [0.8, 1.0, 0.25, 0.5],
                                         4: [0.6, 0.8, 0.0, 0.25],
                                         5: [0.2, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.5]},
                                     8: {0: [0.0, 0.2, 0.6, 0.8],
                                         1: [0.2, 0.4, 0.8, 1.0],
                                         2: [0.6, 0.8, 0.8, 1.0],
                                         3: [0.8, 1.0, 0.6, 0.8],
                                         4: [0.8, 1.0, 0.2, 0.4],
                                         5: [0.6, 0.8, 0.0, 0.2],
                                         6: [0.2, 0.4, 0.0, 0.2],
                                         7: [0.0, 0.2, 0.2, 0.4]},
                                     9: {0: [0.0, 0.167, 0.6, 0.8],
                                         1: [0.167, 0.333, 0.8, 1.0],
                                         2: [0.5, 0.677, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.8, 1.0],
                                         4: [0.833, 1.0, 0.4, 0.6],
                                         5: [0.833, 1.0, 0.0, 0.2],
                                         6: [0.5, 0.667, 0.0, 0.2],
                                         7: [0.167, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.4]},
                                     10: {0: [0.0, 0.167, 0.667, 0.833],
                                          1: [0.167, 0.333, 0.833, 1.0],
                                          2: [0.5, 0.667, 0.833, 1.0],
                                          3: [0.833, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.667],
                                          5: [0.833, 1.0, 0.167, 0.333],
                                          6: [0.667, 0.833, 0.0, 0.167],
                                          7: [0.333, 0.5, 0.0, 0.167],
                                          8: [0.0, 0.167, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.333, 0.5]}
                        }
                        buffers = {2: {0: [0.4, 0.6, 0.1, 0.3],
                                       1: [0.4, 0.6, 0.7, 0.9]},
                                   3: {0: [0.4, 0.8, 0.667, 1.0],
                                       1: [0.6, 1.0, 0.0, 0.333],
                                       2: [0.0, 0.2, 0.0, 0.667]},
                                   4: {0: [0.0, 0.333, 0.667, 1.0],
                                       1: [0.667, 1.0, 0.667, 1.0],
                                       2: [0.667, 1.0, 0.0, 0.333],
                                       3: [0.0, 0.333, 0.0, 0.333]},
                                   5: {0: [0.0, 0.167, 0.2, 0.4],
                                       1: [0.167, 0.333, 0.8, 1.0],
                                       2: [0.667, 0.833, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.417, 0.583, 0.0, 0.2]},
                                   6: {0: [0.0, 0.167, 0.6, 0.8],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.833, 1.0, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.5, 0.667, 0.0, 0.2],
                                       5: [0.0, 0.167, 0.0, 0.2]},
                                   7: {0: [0.2, 0.4, 0.77, 1.0],
                                       1: [0.6, 0.8, 0.77, 1.0],
                                       2: [0.82, 1.0, 0.5, 0.7],
                                       3: [0.8, 1.0, 0.0, 0.25],
                                       4: [0.4, 0.6, 0.0, 0.25],
                                       5: [0.0, 0.2, 0.0, 0.25],
                                       6: [0.0, 0.18, 0.5, 0.7]},
                                   8: {0: [0.0, 0.2, 0.8, 1.0],
                                       1: [0.4, 0.6, 0.8, 1.0],
                                       2: [0.8, 1.0, 0.8, 1.0],
                                       3: [0.8, 1.0, 0.4, 0.6],
                                       4: [0.8, 1.0, 0.0, 0.2],
                                       5: [0.4, 0.6, 0.0, 0.2],
                                       6: [0.0, 0.2, 0.0, 0.2],
                                       7: [0.0, 0.2, 0.4, 0.6]},
                                   9: {0: [0.0, 0.167, 0.8, 1.0],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.667, 0.81, 0.82, 1.0],
                                       3: [0.85, 1.0, 0.6, 0.77],
                                       4: [0.85, 1.0, 0.22, 0.4],
                                       5: [0.667, 0.81, 0.0, 0.18],
                                       6: [0.333, 0.5, 0.0, 0.2],
                                       7: [0.0, 0.167, 0.0, 0.2],
                                       8: [0.0, 0.167, 0.4, 0.6]},
                                   10: {0: [0.0, 0.15, 0.5, 0.65],
                                        1: [0.0, 0.167, 0.833, 1.0],
                                        2: [0.333, 0.5, 0.833, 1.0],
                                        3: [0.667, 0.81, 0.85, 1.0],
                                        4: [0.85, 1.0, 0.667, 0.81],
                                        5: [0.833, 1.0, 0.333, 0.5],
                                        6: [0.833, 1.0, 0.0, 0.167],
                                        7: [0.5, 0.667, 0.0, 0.167],
                                        8: [0.18, 0.333, 0.0, 0.15],
                                        9: [0.0, 0.15, 0.18, 0.333]}
                        }
                        center_isle = {2: [0.35, 0.65, 0.4, 0.6],
                                       3: [0.28, 0.72, 0.4, 0.6],
                                       4: [0.38, 0.62, 0.38, 0.62],
                                       5: [0.27, 0.73, 0.3, 0.7],
                                       6: [0.25, 0.75, 0.3, 0.7],
                                       7: [0.3, 0.7, 0.35, 0.65],
                                       8: [0.32, 0.68, 0.32, 0.68],
                                       9: [0.25, 0.75, 0.3, 0.7],
                                       10: [0.25, 0.75, 0.25, 0.75]
                        }
                        the_spokes = {2: [[0.167, 0.2, 0.167, 0.8], [0.833, 0.2, 0.833, 0.8], 
                                          [0.167, 0.5, 0.833, 0.5], [0.5, 0.2, 0.5, 0.8]],
                                      3: [[0.2, 0.833, 0.5, 0.5], [0.9, 0.667, 0.5, 0.5], [0.4, 0.167, 0.5, 0.5]],
                                      4: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167]],
                                      5: [[0.083, 0.6, 0.5, 0.5], [0.5, 0.917, 0.5, 0.5], [0.917, 0.6, 0.5, 0.5],
                                          [0.25, 0.083, 0.5, 0.5], [0.75, 0.083, 0.5, 0.5]],
                                      6: [[0.083, 0.4, 0.917, 0.6], [0.167, 0.9, 0.833, 0.1], [0.667, 0.9, 0.333, 0.1]],
                                      7: [[0.1, 0.875, 0.4, 0.5], [0.3, 0.125, 0.5, 0.5], [0.1, 0.4, 0.4, 0.5],
                                          [0.7, 0.125, 0.5, 0.5], [0.5, 0.875, 0.5, 0.5], [0.9, 0.875, 0.6, 0.5],
                                          [0.9, 0.375, 0.6, 0.5], [0.4, 0.5, 0.6, 0.5]],
                                      8: [[0.1, 0.7, 0.9, 0.3], [0.3, 0.9, 0.7, 0.1], 
                                          [0.1, 0.3, 0.9, 0.7], [0.7, 0.9, 0.3, 0.1]],
                                      9: [[0.083, 0.7, 0.333, 0.5], [0.083, 0.3, 0.333, 0.5], [0.25, 0.1, 0.417, 0.5], 
                                          [0.25, 0.9, 0.417, 0.5], [0.583, 0.9, 0.583, 0.1], [0.333, 0.5, 0.917, 0.5],
                                          [0.917, 0.9, 0.667, 0.5], [0.917, 0.1, 0.667, 0.5]],
                                      10: [[0.25, 0.917, 0.75, 0.083], [0.417, 0.083, 0.583, 0.917], [0.083, 0.083, 0.917, 0.917], 
                                           [0.083, 0.417, 0.917, 0.583], [0.083, 0.75, 0.917, 0.25]]
                        }
                else:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.25, 0.25, 0.75],
                                         1: [0.5, 1.0, 0.75, 1.0],
                                         2: [0.5, 1.0, 0.0, 0.25]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.25, 0.333, 1.0],
                                         1: [0.25, 0.75, 0.667, 1.0],
                                         2: [0.75, 1.0, 0.333, 1.0],
                                         3: [0.5, 1.0, 0.0, 0.333],
                                         4: [0.0, 0.5, 0.0, 0.333]},
                                     6: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.4, 0.8, 0.667, 1.0],
                                         2: [0.8, 1.0, 0.333, 1.0],
                                         3: [0.6, 1.0, 0.0, 0.333],
                                         4: [0.2, 0.6, 0.0, 0.333],
                                         5: [0.0, 0.2, 0.0, 0.667]},
                                     7: {0: [0.0, 0.4, 0.75, 1.0],
                                         1: [0.4, 0.8, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.5, 1.0],
                                         3: [0.8, 1.0, 0.0, 0.5],
                                         4: [0.4, 0.8, 0.0, 0.25],
                                         5: [0.0, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.75]},
                                     8: {0: [0.0, 0.3, 0.35, 0.65],
                                         1: [0.0, 0.3, 0.7, 1.0],
                                         2: [0.35, 0.65, 0.7, 1.0],
                                         3: [0.7, 1.0, 0.7, 1.0],
                                         4: [0.7, 1.0, 0.35, 0.65],
                                         5: [0.7, 1.0, 0.0, 0.3],
                                         6: [0.35, 0.65, 0.0, 0.3],
                                         7: [0.0, 0.3, 0.0, 0.3]},
                                     9: {0: [0.0, 0.167, 0.6, 1.0],
                                         1: [0.167, 0.5, 0.8, 1.0],
                                         2: [0.5, 0.833, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.6, 1.0],
                                         4: [0.833, 1.0, 0.2, 0.6],
                                         5: [0.667, 1.0, 0.0, 0.2],
                                         6: [0.333, 0.667, 0.0, 0.2],
                                         7: [0.0, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.6]},
                                     10: {0: [0.0, 0.167, 0.5, 0.833],
                                          1: [0.0, 0.333, 0.833, 1.0],
                                          2: [0.333, 0.667, 0.833, 1.0],
                                          3: [0.667, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.833],
                                          5: [0.833, 1.0, 0.167, 0.5],
                                          6: [0.667, 1.0, 0.0, 0.167],
                                          7: [0.333, 0.667, 0.0, 0.167],
                                          8: [0.0, 0.333, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.167, 0.5]},
                                     11: {0: [0.0, 0.2, 0.167, 0.5],
                                          1: [0.0, 0.2, 0.5, 0.833],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333]},
                                     12: {0: [0.0, 0.2, 0.333, 0.667],
                                          1: [0.0, 0.2, 0.667, 1.0],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333],
                                          11: [0.0, 0.2, 0.0, 0.333]},
                                     13: {0: [0.0, 0.2, 0.375, 0.625],
                                          1: [0.0, 0.2, 0.7, 0.95],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.05, 0.3]},
                                     14: {0: [0.0, 0.2, 0.5, 0.75],
                                          1: [0.0, 0.2, 0.75, 1.0],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.0, 0.25],
                                          13: [0.0, 0.2, 0.25, 0.5]},
                                     15: {0: [0.0, 0.167, 0.375, 0.625],
                                          1: [0.0, 0.167, 0.7, 0.95],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.05, 0.3]},
                                     16: {0: [0.0, 0.167, 0.5, 0.75],
                                          1: [0.0, 0.167, 0.75, 1.0],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.25, 0.5],
                                          15: [0.0, 0.167, 0.0, 0.25]},
                                     17: {0: [0.0, 0.167, 0.5, 0.7],
                                          1: [0.0, 0.167, 0.7, 0.9],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.1, 0.3],
                                          16: [0.0, 0.167, 0.3, 0.5]},
                                     18: {0: [0.0, 0.167, 0.6, 0.8],
                                          1: [0.0, 0.167, 0.8, 1.0],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.0, 0.2],
                                          16: [0.0, 0.167, 0.2, 0.4],
                                          17: [0.0, 0.167, 0.4, 0.6]}
                        }
                        center_isle = {2: [0.35, 0.65, 0.4, 0.6],
                                       3: [0.38, 0.7, 0.35, 0.65],
                                       4: [0.37, 0.63, 0.37, 0.63],
                                       5: [0.32, 0.68, 0.38, 0.62],
                                       6: [0.28, 0.72, 0.38, 0.62],
                                       7: [0.28, 0.72, 0.35, 0.65],
                                       8: [0.37, 0.63, 0.37, 0.63],
                                       9: [0.3, 0.7, 0.35, 0.65],
                                       10: [0.3, 0.7, 0.3, 0.7],
                                       11: [0.28, 0.72, 0.38, 0.62],
                                       12: [0.28, 0.72, 0.38, 0.62],
                                       13: [0.3, 0.7, 0.35, 0.65],
                                       14: [0.3, 0.7, 0.35, 0.65],
                                       15: [0.25, 0.75, 0.35, 0.65],
                                       16: [0.25, 0.75, 0.35, 0.65],
                                       17: [0.25, 0.75, 0.3, 0.7],
                                       18: [0.25, 0.75, 0.3, 0.7]
                        }
                        the_spokes = {2: [[0.167, 0.2, 0.167, 0.8], [0.833, 0.2, 0.833, 0.8], [0.167, 0.5, 0.833, 0.5]],
                                      3: [[0.125, 0.5, 0.5, 0.5], [0.75, 0.125, 0.5, 0.5], [0.75, 0.875, 0.5, 0.5]],
                                      4: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167]],
                                      5: [[0.125, 0.667, 0.375, 0.5], [0.25, 0.167, 0.375, 0.5], [0.375, 0.5, 0.625, 0.5],
                                          [0.5, 0.5, 0.5, 0.833], [0.625, 0.5, 0.75, 0.167], [0.625, 0.5, 0.875, 0.667]],
                                      6: [[0.1, 0.333, 0.3, 0.5], [0.7, 0.5, 0.8, 0.167], [0.7, 0.5, 0.9, 0.667], 
                                          [0.4, 0.167, 0.6, 0.833], [0.2, 0.833, 0.3, 0.5], [0.3, 0.5, 0.7, 0.5]],
                                      7: [[0.2, 0.875, 0.3, 0.5], [0.2, 0.125, 0.3, 0.5], [0.1, 0.5, 0.7, 0.5],
                                          [0.6, 0.125, 0.5, 0.5], [0.6, 0.875, 0.5, 0.5], [0.9, 0.75, 0.7, 0.5],
                                          [0.9, 0.25, 0.7, 0.5]],
                                      8: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167], 
                                          [0.167, 0.167, 0.833, 0.833], [0.167, 0.833, 0.833, 0.167]],
                                      9: [[0.083, 0.8, 0.375, 0.5], [0.083, 0.4, 0.375, 0.5], [0.167, 0.1, 0.375, 0.5], 
                                          [0.333, 0.9, 0.5, 0.5], [0.667, 0.9, 0.5, 0.5], [0.5, 0.1, 0.5, 0.5],
                                          [0.917, 0.8, 0.625, 0.5], [0.917, 0.4, 0.625, 0.5], [0.833, 0.1, 0.625, 0.5], 
                                          [0.375, 0.5, 0.625, 0.5]],
                                      10: [[0.167, 0.917, 0.833, 0.083], [0.5, 0.083, 0.5, 0.917], [0.167, 0.083, 0.833, 0.917], 
                                           [0.083, 0.333, 0.917, 0.667], [0.083, 0.667, 0.917, 0.333]],
                                      11: [[0.7, 0.5, 0.9, 0.5], [0.7, 0.5, 0.9, 0.167], [0.7, 0.5, 0.9, 0.833], 
                                           [0.6, 0.5, 0.7, 0.833], [0.6, 0.5, 0.7, 0.167], [0.5, 0.5, 0.5, 0.833],
                                           [0.5, 0.5, 0.5, 0.167], [0.4, 0.5, 0.3, 0.167], [0.4, 0.5, 0.3, 0.833], 
                                           [0.3, 0.5, 0.1, 0.667], [0.3, 0.5, 0.1, 0.333], [0.3, 0.5, 0.7, 0.5]],
                                      12: [[0.7, 0.5, 0.9, 0.5], [0.7, 0.5, 0.9, 0.167], [0.7, 0.5, 0.9, 0.833], 
                                           [0.6, 0.5, 0.7, 0.833], [0.6, 0.5, 0.7, 0.167], [0.5, 0.5, 0.5, 0.833],
                                           [0.5, 0.5, 0.5, 0.167], [0.4, 0.5, 0.3, 0.167], [0.4, 0.5, 0.3, 0.833], 
                                           [0.3, 0.5, 0.1, 0.167], [0.3, 0.5, 0.1, 0.833], [0.3, 0.5, 0.1, 0.5], 
                                           [0.3, 0.5, 0.7, 0.5]],
                                      13: [[0.3, 0.875, 0.5, 0.125], [0.3, 0.5, 0.6, 0.5], [0.5, 0.875, 0.3, 0.125], 
                                           [0.7, 0.125, 0.9, 0.375], [0.7, 0.875, 0.9, 0.625], [0.9, 0.125, 0.6, 0.5],
                                           [0.9, 0.875, 0.6, 0.5], [0.1, 0.175, 0.3, 0.5], [0.1, 0.5, 0.3, 0.5], 
                                           [0.1, 0.825, 0.3, 0.5]],
                                      14: [[0.3, 0.875, 0.1, 0.625], [0.4, 0.5, 0.6, 0.5], [0.1, 0.375, 0.3, 0.125], 
                                           [0.7, 0.125, 0.9, 0.375], [0.7, 0.875, 0.9, 0.625], [0.9, 0.125, 0.6, 0.5],
                                           [0.9, 0.875, 0.6, 0.5], [0.1, 0.125, 0.4, 0.5], [0.1, 0.875, 0.4, 0.5], 
                                           [0.5, 0.125, 0.5, 0.875]],
                                      15: [[0.583, 0.125, 0.25, 0.875], [0.25, 0.5, 0.667, 0.5], [0.583, 0.875, 0.25, 0.125], 
                                           [0.75, 0.125, 0.917, 0.375], [0.75, 0.875, 0.917, 0.625], [0.917, 0.125, 0.667, 0.5],
                                           [0.917, 0.875, 0.667, 0.5], [0.083, 0.175, 0.25, 0.5], [0.083, 0.5, 0.25, 0.5], 
                                           [0.083, 0.825, 0.25, 0.5], [0.417, 0.125, 0.417, 0.875]],
                                      16: [[0.083, 0.875, 0.417, 0.125], [0.25, 0.5, 0.75, 0.5], [0.417, 0.875, 0.083, 0.125], 
                                           [0.75, 0.125, 0.75, 0.875], [0.25, 0.125, 0.25, 0.875], [0.917, 0.125, 0.583, 0.875],
                                           [0.917, 0.875, 0.583, 0.125], [0.083, 0.625, 0.25, 0.5], [0.083, 0.375, 0.25, 0.5], 
                                           [0.917, 0.375, 0.75, 0.5], [0.917, 0.625, 0.75, 0.5]],
                                      17: [[0.25, 0.5, 0.917, 0.5], [0.083, 0.6, 0.25, 0.5], [0.083, 0.4, 0.25, 0.5], 
                                           [0.083, 0.8, 0.333, 0.7], [0.25, 0.9, 0.417, 0.5], [0.417, 0.9, 0.333, 0.7], 
                                           [0.583, 0.9, 0.75, 0.7], [0.75, 0.9, 0.75, 0.7], [0.917, 0.9, 0.583, 0.5], 
                                           [0.917, 0.7, 0.75, 0.5], [0.917, 0.3, 0.75, 0.5], [0.917, 0.1, 0.583, 0.5],
                                           [0.75, 0.1, 0.75, 0.3], [0.583, 0.1, 0.75, 0.3], [0.417, 0.1, 0.333, 0.3], 
                                           [0.25, 0.1, 0.417, 0.5], [0.083, 0.2, 0.333, 0.3]],
                                      18: [[0.083, 0.5, 0.917, 0.5], [0.083, 0.7, 0.25, 0.5], [0.083, 0.3, 0.25, 0.5], 
                                           [0.083, 0.9, 0.417, 0.5], [0.25, 0.9, 0.25, 0.7], [0.417, 0.9, 0.25, 0.7], 
                                           [0.583, 0.9, 0.75, 0.7], [0.75, 0.9, 0.75, 0.7], [0.917, 0.9, 0.583, 0.5], 
                                           [0.917, 0.7, 0.75, 0.5], [0.917, 0.3, 0.75, 0.5], [0.917, 0.1, 0.583, 0.5],
                                           [0.75, 0.1, 0.75, 0.3], [0.583, 0.1, 0.75, 0.3], [0.417, 0.1, 0.25, 0.3], 
                                           [0.25, 0.1, 0.25, 0.3], [0.083, 0.1, 0.417, 0.5]]
                        }
                region_data = []
                for regionLoop in range(iPlayers):
                        [fWestLon, fEastLon, fSouthLat, fNorthLat] = templates[iPlayers][regionLoop]
                        iWestX = int((iW - 1) * fWestLon)
                        iEastX = int((iW - 1) * fEastLon) - 1
                        iSouthY = int((iH - 1) * fSouthLat)
                        iNorthY = int((iH - 1) * fNorthLat) -1
                        region_data.append([iWestX, iEastX, iSouthY, iNorthY])
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        buffer_data = []
                        for bufferLoop in range(iPlayers):
                                [fWestLon, fEastLon, fSouthLat, fNorthLat] = buffers[iPlayers][bufferLoop]
                                iWestX = int((iW - 1) * fWestLon)
                                iEastX = int((iW - 1) * fEastLon) - 1
                                iSouthY = int((iH - 1) * fSouthLat)
                                iNorthY = int((iH - 1) * fNorthLat) -1
                                buffer_data.append([iWestX, iEastX, iSouthY, iNorthY])
                else: pass
                [fWestLon, fEastLon, fSouthLat, fNorthLat] = center_isle[iPlayers]
                iWestX = int((iW - 1) * fWestLon)
                iEastX = int((iW - 1) * fEastLon) - 1
                iSouthY = int((iH - 1) * fSouthLat)
                iNorthY = int((iH - 1) * fNorthLat) -1
                center_data = [iWestX, iEastX, iSouthY, iNorthY]
                hub_data = []
                for [fStartLon, fStartLat, fEndLon, fEndLat] in the_spokes[iPlayers]:
                        iStartX = int((iW - 1) * fStartLon)
                        iStartY = int((iH - 1) * fStartLat)
                        iEndX = int((iW - 1) * fEndLon)
                        iEndY = int((iH - 1) * fEndLat)
                        hub_data.append([iStartX, iStartY, iEndX, iEndY])
        elif idMap == "inlandsea" :
                configs = [0, 1, 6, 4, 3, 2, 2, 2, 4, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1]
                iPlayers = game.countCivPlayersEverAlive()
                iNumTemplates = configs[iPlayers]
                iTemplateRoll = getRandNum(iNumTemplates, "FoR : Template Selection - Inland Sea PYTHON")
                map_size = map.getWorldSize()
                sizevalues = {
                        WorldSizeTypes.WORLDSIZE_DUEL:		(2, 3),
                        WorldSizeTypes.WORLDSIZE_TINY:		(2, 3),
                        WorldSizeTypes.WORLDSIZE_SMALL:		(3, 4),
                        WorldSizeTypes.WORLDSIZE_STANDARD:	(4, 7),
                        WorldSizeTypes.WORLDSIZE_LARGE:		(5, 10),
                        WorldSizeTypes.WORLDSIZE_HUGE:		(6, 15)
                        }
                if int(map_size) in sizevalues.keys() :
                        (threeVar, twoVar) = sizevalues[map_size]
                elif int(map_size) == int(WorldSizeTypes.WORLDSIZE_HUGE) + 1 :
                        (threeVar, twoVar) = (7, 22)
                else :
                        (threeVar, twoVar) = (8, 30)
                if iPlayers <= threeVar:
                        fVar = 3
                elif iPlayers <= twoVar:
                        fVar = 2
                else:
                        fVar = 1
                templates = {(1,0): {0: [0.5, 0.5, int(0.5 * iW), int(0.5 * iH)]},
                             (2,0): {0: [0.1, 0.5, fVar, int(0.5 * iH)],
                                     1: [0.9, 0.5, fVar, int(0.5 * iH)]},
                             (2,1): {0: [0.5, 0.167, int(0.3 * iW), fVar],
                                     1: [0.5, 0.833, int(0.3 * iW), fVar]},
                             (2,2): {0: [0.3, 0.167, int(0.3 * iW), fVar],
                                     1: [0.7, 0.833, int(0.3 * iW), fVar]},
                             (2,3): {0: [0.7, 0.167, int(0.3 * iW), fVar],
                                     1: [0.3, 0.833, int(0.3 * iW), fVar]},
                             (2,4): {0: [0.2, 0.333, int(0.2 * iW), int(0.333 * iH)],
                                     1: [0.8, 0.667, int(0.2 * iW), int(0.333 * iH)]},
                             (2,5): {0: [0.8, 0.333, int(0.2 * iW), int(0.333 * iH)],
                                     1: [0.2, 0.677, int(0.2 * iW), int(0.333 * iH)]},
                             (3,0): {0: [0.1, 0.5, fVar, fVar],
                                     1: [0.7, 0.167, fVar, fVar],
                                     2: [0.7, 0.833, fVar, fVar]},
                             (3,1): {0: [0.9, 0.5, fVar, fVar],
                                     1: [0.3, 0.167, fVar, fVar],
                                     2: [0.3, 0.833, fVar, fVar]},
                             (3,2): {0: [0.5, 0.167, fVar, fVar],
                                     1: [0.1, 0.833, fVar, fVar],
                                     2: [0.9, 0.833, fVar, fVar]},
                             (3,3): {0: [0.5, 0.833, fVar, fVar],
                                     1: [0.1, 0.167, fVar, fVar],
                                     2: [0.9, 0.167, fVar, fVar]},
                             (4,0): {0: [0.1, 0.5, fVar, fVar],
                                     1: [0.5, 0.167, fVar, fVar],
                                     2: [0.9, 0.5, fVar, fVar],
                                     3: [0.5, 0.833, fVar, fVar]},
                             (4,1): {0: [0.1, 0.167, fVar, fVar],
                                     1: [0.7, 0.167, fVar, fVar],
                                     2: [0.9, 0.833, fVar, fVar],
                                     3: [0.3, 0.833, fVar, fVar]},
                             (4,2): {0: [0.1, 0.833, fVar, fVar],
                                     1: [0.7, 0.833, fVar, fVar],
                                     2: [0.9, 0.167, fVar, fVar],
                                     3: [0.3, 0.167, fVar, fVar]},
                             (5,0): {0: [0.5, 0.167, fVar, fVar],
                                     1: [0.125, 0.333, fVar, fVar],
                                     2: [0.25, 0.833, fVar, fVar],
                                     3: [0.75, 0.833, fVar, fVar],
                                     4: [0.875, 0.333, fVar, fVar]},
                             (5,1): {0: [0.5, 0.833, fVar, fVar],
                                     1: [0.125, 0.667, fVar, fVar],
                                     2: [0.25, 0.167, fVar, fVar],
                                     3: [0.75, 0.167, fVar, fVar],
                                     4: [0.875, 0.667, fVar, fVar]},
                             (6,0): {0: [0.1, 0.5, fVar, fVar],
                                     1: [0.3, 0.167, fVar, fVar],
                                     2: [0.7, 0.167, fVar, fVar],
                                     3: [0.9, 0.5, fVar, fVar],
                                     4: [0.7, 0.833, fVar, fVar],
                                     5: [0.3, 0.833, fVar, fVar]},
                             (6,1): {0: [0.1, 0.167, fVar, fVar],
                                     1: [0.5, 0.167, fVar, fVar],
                                     2: [0.9, 0.167, fVar, fVar],
                                     3: [0.9, 0.833, fVar, fVar],
                                     4: [0.5, 0.833, fVar, fVar],
                                     5: [0.1, 0.833, fVar, fVar]},
                             (7,0): {0: [0.1, 0.5, fVar, fVar],
                                     1: [0.2, 0.125, fVar, fVar],
                                     2: [0.6, 0.125, fVar, fVar],
                                     3: [0.9, 0.25, fVar, fVar],
                                     4: [0.9, 0.75, fVar, fVar],
                                     5: [0.6, 0.875, fVar, fVar],
                                     6: [0.2, 0.875, fVar, fVar]},
                             (7,1): {0: [0.9, 0.5, fVar, fVar],
                                     1: [0.8, 0.125, fVar, fVar],
                                     2: [0.4, 0.125, fVar, fVar],
                                     3: [0.1, 0.25, fVar, fVar],
                                     4: [0.1, 0.75, fVar, fVar],
                                     5: [0.4, 0.875, fVar, fVar],
                                     6: [0.8, 0.875, fVar, fVar]},
                             (8,0): {0: [0.583, 0.125, fVar, fVar],
                                     1: [0.25, 0.125, fVar, fVar],
                                     2: [0.083, 0.375, fVar, fVar],
                                     3: [0.083, 0.875, fVar, fVar],
                                     4: [0.417, 0.875, fVar, fVar],
                                     5: [0.75, 0.875, fVar, fVar],
                                     6: [0.917, 0.625, fVar, fVar],
                                     7: [0.917, 0.125, fVar, fVar]},
                             (8,1): {0: [0.417, 0.125, fVar, fVar],
                                     1: [0.083, 0.125, fVar, fVar],
                                     2: [0.083, 0.625, fVar, fVar],
                                     3: [0.25, 0.875, fVar, fVar],
                                     4: [0.583, 0.875, fVar, fVar],
                                     5: [0.917, 0.875, fVar, fVar],
                                     6: [0.917, 0.375, fVar, fVar],
                                     7: [0.75, 0.125, fVar, fVar]},
                             (8,2): {0: [0.1, 0.5, fVar, fVar],
                                     1: [0.2, 0.125, fVar, fVar],
                                     2: [0.5, 0.125, fVar, fVar],
                                     3: [0.8, 0.125, fVar, fVar],
                                     4: [0.9, 0.5, fVar, fVar],
                                     5: [0.8, 0.875, fVar, fVar],
                                     6: [0.5, 0.875, fVar, fVar],
                                     7: [0.2, 0.875, fVar, fVar]},
                             (8,3): {0: [0.1, 0.75, fVar, fVar],
                                     1: [0.1, 0.25, fVar, fVar],
                                     2: [0.333, 0.125, fVar, fVar],
                                     3: [0.667, 0.125, fVar, fVar],
                                     4: [0.9, 0.25, fVar, fVar],
                                     5: [0.9, 0.75, fVar, fVar],
                                     6: [0.667, 0.875, fVar, fVar],
                                     7: [0.333, 0.875, fVar, fVar]},
                             (9,0): {0: [0.833, 0.15, fVar, fVar],
                                     1: [0.5, 0.15, fVar, fVar],
                                     2: [0.167, 0.15, fVar, fVar],
                                     3: [0.08, 0.412, fVar, fVar],
                                     4: [0.08, 0.775, fVar, fVar],
                                     5: [0.35, 0.85, fVar, fVar],
                                     6: [0.65, 0.85, fVar, fVar],
                                     7: [0.92, 0.775, fVar, fVar],
                                     8: [0.92, 0.412, fVar, fVar]},
                             (9,1): {0: [0.833, 0.85, fVar, fVar],
                                     1: [0.5, 0.85, fVar, fVar],
                                     2: [0.167, 0.85, fVar, fVar],
                                     3: [0.08, 0.588, fVar, fVar],
                                     4: [0.08, 0.225, fVar, fVar],
                                     5: [0.35, 0.15, fVar, fVar],
                                     6: [0.65, 0.15, fVar, fVar],
                                     7: [0.92, 0.225, fVar, fVar],
                                     8: [0.92, 0.588, fVar, fVar]},
                             (10,0): {0: [0.875, 0.15, fVar, fVar],
                                      1: [0.625, 0.15, fVar, fVar],
                                      2: [0.375, 0.15, fVar, fVar],
                                      3: [0.125, 0.15, fVar, fVar],
                                      4: [0.08, 0.5, fVar, fVar],
                                      5: [0.125, 0.85, fVar, fVar],
                                      6: [0.375, 0.85, fVar, fVar],
                                      7: [0.625, 0.85, fVar, fVar],
                                      8: [0.875, 0.85, fVar, fVar],
                                      9: [0.92, 0.5, fVar, fVar]},
                             (10,1): {0: [0.75, 0.15, fVar, fVar],
                                      1: [0.5, 0.15, fVar, fVar],
                                      2: [0.25, 0.15, fVar, fVar],
                                      3: [0.08, 0.33, fVar, fVar],
                                      4: [0.08, 0.67, fVar, fVar],
                                      5: [0.25, 0.85, fVar, fVar],
                                      6: [0.5, 0.85, fVar, fVar],
                                      7: [0.75, 0.85, fVar, fVar],
                                      8: [0.92, 0.67, fVar, fVar],
                                      9: [0.92, 0.33, fVar, fVar]},
                             (11,0): {0: [0.875, 0.15, fVar, fVar],
                                      1: [0.625, 0.15, fVar, fVar],
                                      2: [0.375, 0.15, fVar, fVar],
                                      3: [0.125, 0.15, fVar, fVar],
                                      4: [0.08, 0.45, fVar, fVar],
                                      5: [0.08, 0.75, fVar, fVar],
                                      6: [0.28, 0.85, fVar, fVar],
                                      7: [0.5, 0.85, fVar, fVar],
                                      8: [0.72, 0.85, fVar, fVar],
                                      9: [0.92, 0.75, fVar, fVar],
                                      10: [0.92, 0.45, fVar, fVar]},
                             (11,1): {0: [0.875, 0.85, fVar, fVar],
                                      1: [0.625, 0.85, fVar, fVar],
                                      2: [0.375, 0.85, fVar, fVar],
                                      3: [0.125, 0.85, fVar, fVar],
                                      4: [0.08, 0.55, fVar, fVar],
                                      5: [0.08, 0.25, fVar, fVar],
                                      6: [0.28, 0.15, fVar, fVar],
                                      7: [0.5, 0.15, fVar, fVar],
                                      8: [0.72, 0.15, fVar, fVar],
                                      9: [0.92, 0.25, fVar, fVar],
                                      10: [0.92, 0.55, fVar, fVar]},
                             (12,0): {0: [0.7, 0.15, fVar, fVar],
                                      1: [0.5, 0.15, fVar, fVar],
                                      2: [0.3, 0.15, fVar, fVar],
                                      3: [0.1, 0.15, fVar, fVar],
                                      4: [0.08, 0.5, fVar, fVar],
                                      5: [0.1, 0.85, fVar, fVar],
                                      6: [0.3, 0.85, fVar, fVar],
                                      7: [0.5, 0.85, fVar, fVar],
                                      8: [0.7, 0.85, fVar, fVar],
                                      9: [0.9, 0.85, fVar, fVar],
                                      10: [0.92, 0.5, fVar, fVar],
                                      11: [0.9, 0.15, fVar, fVar]},
                             (13,0): {0: [0.7, 0.125, fVar, fVar],
                                      1: [0.5, 0.125, fVar, fVar],
                                      2: [0.3, 0.125, fVar, fVar],
                                      3: [0.1, 0.125, fVar, fVar],
                                      4: [0.08, 0.425, fVar, fVar],
                                      5: [0.08, 0.725, fVar, fVar],
                                      6: [0.2, 0.875, fVar, fVar],
                                      7: [0.4, 0.875, fVar, fVar],
                                      8: [0.6, 0.875, fVar, fVar],
                                      9: [0.8, 0.875, fVar, fVar],
                                      10: [0.92, 0.725, fVar, fVar],
                                      11: [0.92, 0.425, fVar, fVar],
                                      12: [0.9, 0.125, fVar, fVar]},
                             (13,1): {0: [0.7, 0.875, fVar, fVar],
                                      1: [0.5, 0.875, fVar, fVar],
                                      2: [0.3, 0.875, fVar, fVar],
                                      3: [0.1, 0.875, fVar, fVar],
                                      4: [0.08, 0.575, fVar, fVar],
                                      5: [0.08, 0.275, fVar, fVar],
                                      6: [0.2, 0.125, fVar, fVar],
                                      7: [0.4, 0.125, fVar, fVar],
                                      8: [0.6, 0.125, fVar, fVar],
                                      9: [0.8, 0.125, fVar, fVar],
                                      10: [0.92, 0.275, fVar, fVar],
                                      11: [0.92, 0.575, fVar, fVar],
                                      12: [0.9, 0.875, fVar, fVar]},
                             (14,0): {0: [0.7, 0.125, fVar, fVar],
                                      1: [0.5, 0.125, fVar, fVar],
                                      2: [0.3, 0.125, fVar, fVar],
                                      3: [0.1, 0.125, fVar, fVar],
                                      4: [0.08, 0.375, fVar, fVar],
                                      5: [0.08, 0.625, fVar, fVar],
                                      6: [0.1, 0.875, fVar, fVar],
                                      7: [0.3, 0.875, fVar, fVar],
                                      8: [0.5, 0.875, fVar, fVar],
                                      9: [0.7, 0.875, fVar, fVar],
                                      10: [0.9, 0.875, fVar, fVar],
                                      11: [0.92, 0.625, fVar, fVar],
                                      12: [0.92, 0.375, fVar, fVar],
                                      13: [0.9, 0.125, fVar, fVar]},
                             (15,0): {0: [0.583, 0.125, fVar, fVar],
                                      1: [0.417, 0.125, fVar, fVar],
                                      2: [0.25, 0.125, fVar, fVar],
                                      3: [0.083, 0.125, fVar, fVar],
                                      4: [0.083, 0.4, fVar, fVar],
                                      5: [0.083, 0.65, fVar, fVar],
                                      6: [0.1, 0.9, fVar, fVar],
                                      7: [0.3, 0.875, fVar, fVar],
                                      8: [0.5, 0.875, fVar, fVar],
                                      9: [0.7, 0.875, fVar, fVar],
                                      10: [0.9, 0.9, fVar, fVar],
                                      11: [0.917, 0.65, fVar, fVar],
                                      12: [0.917, 0.4, fVar, fVar],
                                      13: [0.917, 0.125, fVar, fVar],
                                      14: [0.75, 0.125, fVar, fVar]},
                             (15,1): {0: [0.583, 0.875, fVar, fVar],
                                      1: [0.417, 0.875, fVar, fVar],
                                      2: [0.25, 0.875, fVar, fVar],
                                      3: [0.083, 0.875, fVar, fVar],
                                      4: [0.083, 0.6, fVar, fVar],
                                      5: [0.083, 0.35, fVar, fVar],
                                      6: [0.1, 0.1, fVar, fVar],
                                      7: [0.3, 0.125, fVar, fVar],
                                      8: [0.5, 0.125, fVar, fVar],
                                      9: [0.7, 0.125, fVar, fVar],
                                      10: [0.9, 0.1, fVar, fVar],
                                      11: [0.917, 0.35, fVar, fVar],
                                      12: [0.917, 0.6, fVar, fVar],
                                      13: [0.917, 0.875, fVar, fVar],
                                      14: [0.75, 0.875, fVar, fVar]},
                             (16,0): {0: [0.583, 0.125, fVar, fVar],
                                      1: [0.417, 0.125, fVar, fVar],
                                      2: [0.25, 0.125, fVar, fVar],
                                      3: [0.083, 0.125, fVar, fVar],
                                      4: [0.083, 0.375, fVar, fVar],
                                      5: [0.083, 0.625, fVar, fVar],
                                      6: [0.083, 0.875, fVar, fVar],
                                      7: [0.25, 0.875, fVar, fVar],
                                      8: [0.417, 0.875, fVar, fVar],
                                      9: [0.583, 0.875, fVar, fVar],
                                      10: [0.75, 0.875, fVar, fVar],
                                      11: [0.917, 0.875, fVar, fVar],
                                      12: [0.917, 0.625, fVar, fVar],
                                      13: [0.917, 0.375, fVar, fVar],
                                      14: [0.917, 0.125, fVar, fVar],
                                      15: [0.75, 0.125, fVar, fVar]},
                             (17,0): {0: [0.5, 0.125, fVar, fVar],
                                      1: [0.35, 0.125, fVar, fVar],
                                      2: [0.2, 0.125, fVar, fVar],
                                      3: [0.05, 0.175, fVar, fVar],
                                      4: [0.083, 0.45, fVar, fVar],
                                      5: [0.083, 0.7, fVar, fVar],
                                      6: [0.083, 0.95, fVar, fVar],
                                      7: [0.25, 0.875, fVar, fVar],
                                      8: [0.417, 0.875, fVar, fVar],
                                      9: [0.583, 0.875, fVar, fVar],
                                      10: [0.75, 0.875, fVar, fVar],
                                      11: [0.917, 0.95, fVar, fVar],
                                      12: [0.917, 0.7, fVar, fVar],
                                      13: [0.917, 0.45, fVar, fVar],
                                      14: [0.95, 0.175, fVar, fVar],
                                      15: [0.8, 0.125, fVar, fVar],
                                      16: [0.65, 0.125, fVar, fVar]},
                             (17,1): {0: [0.5, 0.875, fVar, fVar],
                                      1: [0.35, 0.875, fVar, fVar],
                                      2: [0.2, 0.875, fVar, fVar],
                                      3: [0.05, 0.825, fVar, fVar],
                                      4: [0.083, 0.65, fVar, fVar],
                                      5: [0.083, 0.3, fVar, fVar],
                                      6: [0.083, 0.05, fVar, fVar],
                                      7: [0.25, 0.125, fVar, fVar],
                                      8: [0.417, 0.125, fVar, fVar],
                                      9: [0.583, 0.125, fVar, fVar],
                                      10: [0.75, 0.125, fVar, fVar],
                                      11: [0.917, 0.05, fVar, fVar],
                                      12: [0.917, 0.3, fVar, fVar],
                                      13: [0.917, 0.65, fVar, fVar],
                                      14: [0.95, 0.825, fVar, fVar],
                                      15: [0.8, 0.875, fVar, fVar],
                                      16: [0.65, 0.875, fVar, fVar]},
                             (18,0): {0: [0.5, 0.125, fVar, fVar],
                                      1: [0.35, 0.125, fVar, fVar],
                                      2: [0.2, 0.125, fVar, fVar],
                                      3: [0.05, 0.125, fVar, fVar],
                                      4: [0.075, 0.375, fVar, fVar],
                                      5: [0.075, 0.625, fVar, fVar],
                                      6: [0.05, 0.875, fVar, fVar],
                                      7: [0.2, 0.875, fVar, fVar],
                                      8: [0.35, 0.875, fVar, fVar],
                                      9: [0.5, 0.875, fVar, fVar],
                                      10: [0.65, 0.875, fVar, fVar],
                                      11: [0.8, 0.875, fVar, fVar],
                                      12: [0.95, 0.875, fVar, fVar],
                                      13: [0.925, 0.625, fVar, fVar],
                                      14: [0.925, 0.375, fVar, fVar],
                                      15: [0.95, 0.125, fVar, fVar],
                                      16: [0.8, 0.125, fVar, fVar],
                                      17: [0.65, 0.125, fVar, fVar]}
                }
                player_list = []
                for playerLoop in range(game.countCivPlayersEverAlive()):
                        player_list.append(playerLoop)
                shuffledPlayers = []
                for playerLoopTwo in range(game.countCivPlayersEverAlive()):
                        iChoosePlayer = getRandNum(len(player_list), "FoR : Shuffling Template IDs - Inland Sea PYTHON")
                        shuffledPlayers.append(player_list[iChoosePlayer])
                        del player_list[iChoosePlayer]
        elif idMap == "islands" :
                userInputLargeIslands = cmo[0]
                iPlayers = game.countCivPlayersEverAlive()
                if iPlayers < 1 or iPlayers > 18:
                        return None
                if userInputLargeIslands == 0:
                        configs = [0, 4, 4, 4, 6, 8, 8, 12, 12, 12, 15, 15, 15, 15, 20, 20, 20, 24, 24]
                        iExtras = 0
                elif userInputLargeIslands == 2:
                        configs = [0, 4, 4, 6, 8, 8, 12, 12, 12, 15, 15, 15, 20, 20, 20, 24, 24, 24, 24]
                        extras_min_list = [0, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 3, 4, 4, 4, 4]
                        extras_max_list = [0, 3, 2, 3, 3, 3, 5, 5, 4, 6, 5, 4, 7, 7, 6, 8, 8, 7, 6]
                        extras_min = extras_min_list[iPlayers]
                        extras_max = extras_max_list[iPlayers]
                        if extras_min == extras_max:
                                iExtras = extras_min
                        else:
                                extras_range = getRandNum((extras_max - extras_min + 1), "FoR : Extra Islands - Islands PYTHON")
                                iExtras = extras_min + extras_range
                else:
                        configs = [0, 4, 4, 6, 6, 8, 8, 12, 12, 12, 15, 15, 15, 15, 20, 20, 20, 24, 24]
                        extras_min_list = [0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 2, 2]
                        extras_max_list = [0, 2, 1, 2, 2, 2, 2, 3, 3, 2, 3, 3, 3, 2, 3, 4, 4, 4, 4]
                        extras_min = extras_min_list[iPlayers]
                        extras_max = extras_max_list[iPlayers]
                        if extras_min == extras_max:
                                iExtras = extras_min
                        else:
                                extras_range = getRandNum((extras_max - extras_min + 1), "FoR : Extra Islands - Islands PYTHON")
                                iExtras = extras_min + extras_range
                iNumRegions = configs[iPlayers]
                regions_in_use = []
                remaining_regions = []
                for loopy in range(iNumRegions):
                        remaining_regions.append(loopy)
                templates = {4: {0: [0.0, 0.5, 0.1, 0.45],
                                 1: [0.5, 1.0, 0.1, 0.45],
                                 2: [0.0, 0.5, 0.55, 0.9],
                                 3: [0.5, 1.0, 0.55, 0.9]},
                             6: {0: [0.0, 0.333, 0.1, 0.45],
                                 1: [0.333, 0.667, 0.1, 0.45],
                                 2: [0.667, 1.0, 0.1, 0.45],
                                 3: [0.0, 0.333, 0.55, 0.9],
                                 4: [0.333, 0.667, 0.55, 0.9],
                                 5: [0.667, 1.0, 0.55, 0.9]},
                             8: {0: [0.0, 0.25, 0.1, 0.45],
                                 1: [0.25, 0.5, 0.1, 0.45],
                                 2: [0.5, 0.75, 0.1, 0.45],
                                 3: [0.75, 1.0, 0.1, 0.45],
                                 4: [0.0, 0.25, 0.55, 0.9],
                                 5: [0.25, 0.5, 0.55, 0.9],
                                 6: [0.5, 0.75, 0.55, 0.9],
                                 7: [0.75, 1.0, 0.55, 0.9]},
                             12: {0: [0.0, 0.25, 0.1, 0.35],
                                  1: [0.25, 0.5, 0.1, 0.35],
                                  2: [0.5, 0.75, 0.1, 0.35],
                                  3: [0.75, 1.0, 0.1, 0.35],
                                  4: [0.0, 0.25, 0.4, 0.6],
                                  5: [0.25, 0.5, 0.4, 0.6],
                                  6: [0.5, 0.75, 0.4, 0.6],
                                  7: [0.75, 1.0, 0.4, 0.6],
                                  8: [0.0, 0.25, 0.65, 0.9],
                                  9: [0.25, 0.5, 0.65, 0.9],
                                  10: [0.5, 0.75, 0.65, 0.9],
                                  11: [0.75, 1.0, 0.65, 0.9]},
                             15: {0: [0.0, 0.2, 0.1, 0.35],
                                  1: [0.2, 0.4, 0.1, 0.35],
                                  2: [0.4, 0.6, 0.1, 0.35],
                                  3: [0.6, 0.8, 0.1, 0.35],
                                  4: [0.8, 1.0, 0.1, 0.35],
                                  5: [0.0, 0.2, 0.4, 0.6],
                                  6: [0.2, 0.4, 0.4, 0.6],
                                  7: [0.4, 0.6, 0.4, 0.6],
                                  8: [0.6, 0.8, 0.4, 0.6],
                                  9: [0.8, 1.0, 0.4, 0.6],
                                  10: [0.0, 0.2, 0.65, 0.9],
                                  11: [0.2, 0.4, 0.65, 0.9],
                                  12: [0.4, 0.6, 0.65, 0.9],
                                  13: [0.6, 0.8, 0.65, 0.9],
                                  14: [0.8, 1.0, 0.65, 0.9]},
                             20: {0: [0.0, 0.2, 0.1, 0.29],
                                  1: [0.2, 0.4, 0.1, 0.29],
                                  2: [0.4, 0.6, 0.1, 0.29],
                                  3: [0.6, 0.8, 0.1, 0.29],
                                  4: [0.8, 1.0, 0.1, 0.29],
                                  5: [0.0, 0.2, 0.33, 0.48],
                                  6: [0.2, 0.4, 0.33, 0.48],
                                  7: [0.4, 0.6, 0.33, 0.48],
                                  8: [0.6, 0.8, 0.33, 0.48],
                                  9: [0.8, 1.0, 0.33, 0.48],
                                  10: [0.0, 0.2, 0.52, 0.67],
                                  11: [0.2, 0.4, 0.52, 0.67],
                                  12: [0.4, 0.6, 0.52, 0.67],
                                  13: [0.6, 0.8, 0.52, 0.67],
                                  14: [0.8, 1.0, 0.52, 0.67],
                                  15: [0.0, 0.2, 0.71, 0.9],
                                  16: [0.2, 0.4, 0.71, 0.9],
                                  17: [0.4, 0.6, 0.71, 0.9],
                                  18: [0.6, 0.8, 0.71, 0.9],
                                  19: [0.8, 1.0, 0.71, 0.9]},
                             24: {0: [0.0, 0.167, 0.1, 0.29],
                                  1: [0.167, 0.333, 0.1, 0.29],
                                  2: [0.333, 0.5, 0.1, 0.29],
                                  3: [0.5, 0.667, 0.1, 0.29],
                                  4: [0.667, 0.833, 0.1, 0.29],
                                  5: [0.833, 1.0, 0.1, 0.29],
                                  6: [0.0, 0.167, 0.33, 0.48],
                                  7: [0.167, 0.333, 0.33, 0.48],
                                  8: [0.333, 0.5, 0.33, 0.48],
                                  9: [0.5, 0.667, 0.33, 0.48],
                                  10: [0.667, 0.833, 0.33, 0.48],
                                  11: [0.833, 1.0, 0.33, 0.48],
                                  12: [0.0, 0.167, 0.52, 0.67],
                                  13: [0.167, 0.333, 0.52, 0.67],
                                  14: [0.333, 0.5, 0.52, 0.67],
                                  15: [0.5, 0.667, 0.52, 0.67],
                                  16: [0.667, 0.833, 0.52, 0.67],
                                  17: [0.833, 1.0, 0.52, 0.67],
                                  18: [0.0, 0.167, 0.71, 0.9],
                                  19: [0.167, 0.333, 0.71, 0.9],
                                  20: [0.333, 0.5, 0.71, 0.9],
                                  21: [0.5, 0.667, 0.71, 0.9],
                                  22: [0.667, 0.833, 0.71, 0.9],
                                  23: [0.833, 1.0, 0.71, 0.9]}
                }
                region_coords = templates[iNumRegions]
        elif idMap == "pangaea" :
                iPlayers = game.countCivPlayersEverAlive()
                iTeams = game.countCivTeamsEverAlive()
                if iPlayers >= iTeams * 2 or iPlayers == 2:
                        isTeamGame = True
                else:
                        isTeamGame = False
        elif idMap == "ring" :
                iPlayers = game.countCivPlayersEverAlive()
                if iPlayers < 2 or iPlayers > 18:
                        bSuccessFlag = False
                        return 0
                else:
                        bSuccessFlag = True
                userInputLandmass = cmo[0]
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.8, 1.0, 0.333, 1.0],
                                         2: [0.2, 0.6, 0.0, 0.333]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.167, 0.4, 0.8],
                                         1: [0.333, 0.667, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.583, 0.917, 0.0, 0.2],
                                         4: [0.083, 0.417, 0.0, 0.2]},
                                     6: {0: [0.0, 0.333, 0.8, 1.0],
                                         1: [0.5, 0.833, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.667, 1.0, 0.0, 0.2],
                                         4: [0.167, 0.5, 0.0, 0.2],
                                         5: [0.0, 0.167, 0.2, 0.6]},
                                     7: {0: [0.0, 0.2, 0.75, 1.0],
                                         1: [0.4, 0.6, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.75, 1.0],
                                         3: [0.8, 1.0, 0.25, 0.5],
                                         4: [0.6, 0.8, 0.0, 0.25],
                                         5: [0.2, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.5]},
                                     8: {0: [0.0, 0.2, 0.6, 0.8],
                                         1: [0.2, 0.4, 0.8, 1.0],
                                         2: [0.6, 0.8, 0.8, 1.0],
                                         3: [0.8, 1.0, 0.6, 0.8],
                                         4: [0.8, 1.0, 0.2, 0.4],
                                         5: [0.6, 0.8, 0.0, 0.2],
                                         6: [0.2, 0.4, 0.0, 0.2],
                                         7: [0.0, 0.2, 0.2, 0.4]},
                                     9: {0: [0.0, 0.167, 0.6, 0.8],
                                         1: [0.167, 0.333, 0.8, 1.0],
                                         2: [0.5, 0.677, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.8, 1.0],
                                         4: [0.833, 1.0, 0.4, 0.6],
                                         5: [0.833, 1.0, 0.0, 0.2],
                                         6: [0.5, 0.667, 0.0, 0.2],
                                         7: [0.167, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.4]},
                                     10: {0: [0.0, 0.167, 0.667, 0.833],
                                          1: [0.167, 0.333, 0.833, 1.0],
                                          2: [0.5, 0.667, 0.833, 1.0],
                                          3: [0.833, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.667],
                                          5: [0.833, 1.0, 0.167, 0.333],
                                          6: [0.667, 0.833, 0.0, 0.167],
                                          7: [0.333, 0.5, 0.0, 0.167],
                                          8: [0.0, 0.167, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.333, 0.5]}
                        }
                        buffers = {2: {0: [0.4, 0.6, 0.1, 0.3],
                                       1: [0.4, 0.6, 0.7, 0.9]},
                                   3: {0: [0.4, 0.8, 0.667, 1.0],
                                       1: [0.6, 1.0, 0.0, 0.333],
                                       2: [0.0, 0.2, 0.0, 0.667]},
                                   4: {0: [0.0, 0.333, 0.667, 1.0],
                                       1: [0.667, 1.0, 0.667, 1.0],
                                       2: [0.667, 1.0, 0.0, 0.333],
                                       3: [0.0, 0.333, 0.0, 0.333]},
                                   5: {0: [0.0, 0.167, 0.2, 0.4],
                                       1: [0.167, 0.333, 0.8, 1.0],
                                       2: [0.667, 0.833, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.417, 0.583, 0.0, 0.2]},
                                   6: {0: [0.0, 0.167, 0.6, 0.8],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.833, 1.0, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.5, 0.667, 0.0, 0.2],
                                       5: [0.0, 0.167, 0.0, 0.2]},
                                   7: {0: [0.2, 0.4, 0.75, 1.0],
                                       1: [0.6, 0.8, 0.75, 1.0],
                                       2: [0.8, 1.0, 0.5, 0.75],
                                       3: [0.8, 1.0, 0.0, 0.25],
                                       4: [0.4, 0.6, 0.0, 0.25],
                                       5: [0.0, 0.2, 0.0, 0.25],
                                       6: [0.0, 0.2, 0.5, 0.75]},
                                   8: {0: [0.0, 0.2, 0.8, 1.0],
                                       1: [0.4, 0.6, 0.8, 1.0],
                                       2: [0.8, 1.0, 0.8, 1.0],
                                       3: [0.8, 1.0, 0.4, 0.6],
                                       4: [0.8, 1.0, 0.0, 0.2],
                                       5: [0.4, 0.6, 0.0, 0.2],
                                       6: [0.0, 0.2, 0.0, 0.2],
                                       7: [0.0, 0.2, 0.4, 0.6]},
                                   9: {0: [0.0, 0.167, 0.8, 1.0],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.667, 0.833, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.6, 0.8],
                                       4: [0.833, 1.0, 0.2, 0.4],
                                       5: [0.667, 0.833, 0.0, 0.2],
                                       6: [0.333, 0.5, 0.0, 0.2],
                                       7: [0.0, 0.167, 0.0, 0.2],
                                       8: [0.0, 0.167, 0.4, 0.6]},
                                   10: {0: [0.0, 0.167, 0.5, 0.667],
                                        1: [0.0, 0.167, 0.833, 1.0],
                                        2: [0.333, 0.5, 0.833, 1.0],
                                        3: [0.667, 0.833, 0.833, 1.0],
                                        4: [0.833, 1.0, 0.667, 0.833],
                                        5: [0.833, 1.0, 0.333, 0.5],
                                        6: [0.833, 1.0, 0.0, 0.167],
                                        7: [0.5, 0.667, 0.0, 0.167],
                                        8: [0.167, 0.333, 0.0, 0.167],
                                        9: [0.0, 0.167, 0.167, 0.333]}
                        }
                        center_isle = {2: [0.4, 0.6, 0.4, 0.6],
                                       3: [0.28, 0.72, 0.4, 0.6],
                                       4: [0.4, 0.6, 0.4, 0.6],
                                       5: [0.27, 0.73, 0.3, 0.7],
                                       6: [0.25, 0.75, 0.3, 0.7],
                                       7: [0.3, 0.7, 0.35, 0.65],
                                       8: [0.32, 0.68, 0.32, 0.68],
                                       9: [0.25, 0.75, 0.3, 0.7],
                                       10: [0.25, 0.75, 0.25, 0.75]
                        }
                        the_wheel = {2: [[0.167, 0.2], [0.167, 0.8], [0.833, 0.8], [0.833, 0.2]],
                                     3: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     4: [[0.167, 0.167], [0.167, 0.833], [0.833, 0.833], [0.833, 0.167]],
                                     5: [[0.083, 0.7], [0.25, 0.9], [0.75, 0.9], [0.917, 0.7], [0.917, 0.3], [0.833, 0.1], [0.167, 0.1], [0.083, 0.3]],
                                     6: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     7: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     8: [[0.1, 0.1], [0.1, 0.9], [0.9, 0.9], [0.9, 0.1]],
                                     9: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     10: [[0.083, 0.083], [0.083, 0.917], [0.917, 0.917], [0.917, 0.083]]
                        }

                else:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.25, 0.25, 0.75],
                                         1: [0.5, 1.0, 0.75, 1.0],
                                         2: [0.5, 1.0, 0.0, 0.25]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.25, 0.333, 1.0],
                                         1: [0.25, 0.75, 0.667, 1.0],
                                         2: [0.75, 1.0, 0.333, 1.0],
                                         3: [0.5, 1.0, 0.0, 0.333],
                                         4: [0.0, 0.5, 0.0, 0.333]},
                                     6: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.4, 0.8, 0.667, 1.0],
                                         2: [0.8, 1.0, 0.333, 1.0],
                                         3: [0.6, 1.0, 0.0, 0.333],
                                         4: [0.2, 0.6, 0.0, 0.333],
                                         5: [0.0, 0.2, 0.0, 0.667]},
                                     7: {0: [0.0, 0.4, 0.75, 1.0],
                                         1: [0.4, 0.8, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.5, 1.0],
                                         3: [0.8, 1.0, 0.0, 0.5],
                                         4: [0.4, 0.8, 0.0, 0.25],
                                         5: [0.0, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.75]},
                                     8: {0: [0.0, 0.3, 0.35, 0.65],
                                         1: [0.0, 0.3, 0.7, 1.0],
                                         2: [0.35, 0.65, 0.7, 1.0],
                                         3: [0.7, 1.0, 0.7, 1.0],
                                         4: [0.7, 1.0, 0.35, 0.65],
                                         5: [0.7, 1.0, 0.0, 0.3],
                                         6: [0.35, 0.65, 0.0, 0.3],
                                         7: [0.0, 0.3, 0.0, 0.3]},
                                     9: {0: [0.0, 0.167, 0.6, 1.0],
                                         1: [0.167, 0.5, 0.8, 1.0],
                                         2: [0.5, 0.833, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.6, 1.0],
                                         4: [0.833, 1.0, 0.2, 0.6],
                                         5: [0.667, 1.0, 0.0, 0.2],
                                         6: [0.333, 0.667, 0.0, 0.2],
                                         7: [0.0, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.6]},
                                     10: {0: [0.0, 0.167, 0.5, 0.833],
                                          1: [0.0, 0.333, 0.833, 1.0],
                                          2: [0.333, 0.667, 0.833, 1.0],
                                          3: [0.667, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.833],
                                          5: [0.833, 1.0, 0.167, 0.5],
                                          6: [0.667, 1.0, 0.0, 0.167],
                                          7: [0.333, 0.667, 0.0, 0.167],
                                          8: [0.0, 0.333, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.167, 0.5]},
                                     11: {0: [0.0, 0.2, 0.167, 0.5],
                                          1: [0.0, 0.2, 0.5, 0.833],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333]},
                                     12: {0: [0.0, 0.2, 0.333, 0.667],
                                          1: [0.0, 0.2, 0.667, 1.0],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333],
                                          11: [0.0, 0.2, 0.0, 0.333]},
                                     13: {0: [0.0, 0.2, 0.375, 0.625],
                                          1: [0.0, 0.2, 0.7, 0.95],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.05, 0.3]},
                                     14: {0: [0.0, 0.2, 0.5, 0.75],
                                          1: [0.0, 0.2, 0.75, 1.0],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.0, 0.25],
                                          13: [0.0, 0.2, 0.25, 0.5]},
                                     15: {0: [0.0, 0.167, 0.375, 0.625],
                                          1: [0.0, 0.167, 0.7, 0.95],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.05, 0.3]},
                                     16: {0: [0.0, 0.167, 0.5, 0.75],
                                          1: [0.0, 0.167, 0.75, 1.0],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.25, 0.5],
                                          15: [0.0, 0.167, 0.0, 0.25]},
                                     17: {0: [0.0, 0.167, 0.5, 0.7],
                                          1: [0.0, 0.167, 0.7, 0.9],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.1, 0.3],
                                          16: [0.0, 0.167, 0.3, 0.5]},
                                     18: {0: [0.0, 0.167, 0.6, 0.8],
                                          1: [0.0, 0.167, 0.8, 1.0],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.0, 0.2],
                                          16: [0.0, 0.167, 0.2, 0.4],
                                          17: [0.0, 0.167, 0.4, 0.6]}
                        }
                        center_isle = {2: [0.4, 0.6, 0.4, 0.6],
                                       3: [0.4, 0.7, 0.35, 0.65],
                                       4: [0.4, 0.6, 0.4, 0.6],
                                       5: [0.32, 0.68, 0.4, 0.6],
                                       6: [0.28, 0.72, 0.4, 0.6],
                                       7: [0.28, 0.72, 0.35, 0.65],
                                       8: [0.4, 0.6, 0.4, 0.6],
                                       9: [0.3, 0.7, 0.35, 0.65],
                                       10: [0.3, 0.7, 0.3, 0.7],
                                       11: [0.28, 0.72, 0.4, 0.6],
                                       12: [0.28, 0.72, 0.4, 0.6],
                                       13: [0.3, 0.7, 0.35, 0.65],
                                       14: [0.3, 0.7, 0.35, 0.65],
                                       15: [0.25, 0.75, 0.35, 0.65],
                                       16: [0.25, 0.75, 0.35, 0.65],
                                       17: [0.25, 0.75, 0.3, 0.7],
                                       18: [0.25, 0.75, 0.3, 0.7]
                        }
                        the_wheel = {2: [[0.167, 0.3], [0.167, 0.7], [0.833, 0.7], [0.833, 0.3]],
                                     3: [[0.125, 0.375], [0.125, 0.625], [0.625, 0.875], [0.875, 0.875], [0.875, 0.125], [0.625, 0.125]],
                                     4: [[0.167, 0.5], [0.5, 0.833], [0.833, 0.5], [0.5, 0.167]],
                                     5: [[0.125, 0.167], [0.125, 0.833], [0.875, 0.833], [0.875, 0.167]],
                                     6: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     7: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     8: [[0.167, 0.167], [0.167, 0.833], [0.833, 0.833], [0.833, 0.167]],
                                     9: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     10: [[0.083, 0.083], [0.083, 0.917], [0.917, 0.917], [0.917, 0.083]],
                                     11: [[0.1, 0.333], [0.1, 0.667], [0.3, 0.833], [0.9, 0.833], [0.9, 0.167], [0.3, 0.167]],
                                     12: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     13: [[0.1, 0.175], [0.1, 0.825], [0.3, 0.875], [0.9, 0.875], [0.9, 0.125], [0.3, 0.125]],
                                     14: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     15: [[0.083, 0.175], [0.083, 0.825], [0.25, 0.875], [0.917, 0.875], [0.917, 0.125], [0.25, 0.125]],
                                     16: [[0.083, 0.125], [0.083, 0.875], [0.917, 0.875], [0.917, 0.125]],
                                     17: [[0.083, 0.2], [0.083, 0.8], [0.25, 0.9], [0.917, 0.9], [0.917, 0.1], [0.25, 0.1]],
                                     18: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]]
                        }
                region_data = []
                for regionLoop in range(iPlayers):
                        [fWestLon, fEastLon, fSouthLat, fNorthLat] = templates[iPlayers][regionLoop]
                        iWestX = int((iW - 1) * fWestLon)
                        iEastX = int((iW - 1) * fEastLon) - 1
                        iSouthY = int((iH - 1) * fSouthLat)
                        iNorthY = int((iH - 1) * fNorthLat) -1
                        region_data.append([iWestX, iEastX, iSouthY, iNorthY])
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        buffer_data = []
                        for bufferLoop in range(iPlayers):
                                [fWestLon, fEastLon, fSouthLat, fNorthLat] = buffers[iPlayers][bufferLoop]
                                iWestX = int((iW - 1) * fWestLon)
                                iEastX = int((iW - 1) * fEastLon) - 1
                                iSouthY = int((iH - 1) * fSouthLat)
                                iNorthY = int((iH - 1) * fNorthLat) -1
                                buffer_data.append([iWestX, iEastX, iSouthY, iNorthY])
                else: pass
                [fWestLon, fEastLon, fSouthLat, fNorthLat] = center_isle[iPlayers]
                iWestX = int((iW - 1) * fWestLon)
                iEastX = int((iW - 1) * fEastLon) - 1
                iSouthY = int((iH - 1) * fSouthLat)
                iNorthY = int((iH - 1) * fNorthLat) -1
                center_data = [iWestX, iEastX, iSouthY, iNorthY]
                wheel_data = []
                for [fLon, fLat] in the_wheel[iPlayers]:
                        iX = int((iW - 1) * fLon)
                        iY = int((iH - 1) * fLat)
                        wheel_data.append([iX, iY])
                [fLon, fLat] = the_wheel[iPlayers][0]
                iX = int((iW - 1) * fLon)
                iY = int((iH - 1) * fLat)
                wheel_data.append([iX, iY])
        elif idMap == "wheel" :
                iPlayers = game.countCivPlayersEverAlive()
                if iPlayers < 2 or iPlayers > 18:
                        bSuccessFlag = False
                        return 0
                else:
                        bSuccessFlag = True
                userInputLandmass = cmo[0]
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.8, 1.0, 0.333, 1.0],
                                         2: [0.2, 0.6, 0.0, 0.333]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.167, 0.4, 0.8],
                                         1: [0.333, 0.667, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.583, 0.917, 0.0, 0.2],
                                         4: [0.083, 0.417, 0.0, 0.2]},
                                     6: {0: [0.0, 0.333, 0.8, 1.0],
                                         1: [0.5, 0.833, 0.8, 1.0],
                                         2: [0.833, 1.0, 0.4, 0.8],
                                         3: [0.667, 1.0, 0.0, 0.2],
                                         4: [0.167, 0.5, 0.0, 0.2],
                                         5: [0.0, 0.167, 0.2, 0.6]},
                                     7: {0: [0.0, 0.2, 0.75, 1.0],
                                         1: [0.4, 0.6, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.75, 1.0],
                                         3: [0.8, 1.0, 0.25, 0.5],
                                         4: [0.6, 0.8, 0.0, 0.25],
                                         5: [0.2, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.5]},
                                     8: {0: [0.0, 0.2, 0.6, 0.8],
                                         1: [0.2, 0.4, 0.8, 1.0],
                                         2: [0.6, 0.8, 0.8, 1.0],
                                         3: [0.8, 1.0, 0.6, 0.8],
                                         4: [0.8, 1.0, 0.2, 0.4],
                                         5: [0.6, 0.8, 0.0, 0.2],
                                         6: [0.2, 0.4, 0.0, 0.2],
                                         7: [0.0, 0.2, 0.2, 0.4]},
                                     9: {0: [0.0, 0.167, 0.6, 0.8],
                                         1: [0.167, 0.333, 0.8, 1.0],
                                         2: [0.5, 0.677, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.8, 1.0],
                                         4: [0.833, 1.0, 0.4, 0.6],
                                         5: [0.833, 1.0, 0.0, 0.2],
                                         6: [0.5, 0.667, 0.0, 0.2],
                                         7: [0.167, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.4]},
                                     10: {0: [0.0, 0.167, 0.667, 0.833],
                                          1: [0.167, 0.333, 0.833, 1.0],
                                          2: [0.5, 0.667, 0.833, 1.0],
                                          3: [0.833, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.667],
                                          5: [0.833, 1.0, 0.167, 0.333],
                                          6: [0.667, 0.833, 0.0, 0.167],
                                          7: [0.333, 0.5, 0.0, 0.167],
                                          8: [0.0, 0.167, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.333, 0.5]}
                        }
                        buffers = {2: {0: [0.4, 0.6, 0.1, 0.3],
                                       1: [0.4, 0.6, 0.7, 0.9]},
                                   3: {0: [0.4, 0.8, 0.667, 1.0],
                                       1: [0.6, 1.0, 0.0, 0.333],
                                       2: [0.0, 0.2, 0.0, 0.667]},
                                   4: {0: [0.0, 0.333, 0.667, 1.0],
                                       1: [0.667, 1.0, 0.667, 1.0],
                                       2: [0.667, 1.0, 0.0, 0.333],
                                       3: [0.0, 0.333, 0.0, 0.333]},
                                   5: {0: [0.0, 0.167, 0.2, 0.4],
                                       1: [0.167, 0.333, 0.8, 1.0],
                                       2: [0.667, 0.833, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.417, 0.583, 0.0, 0.2]},
                                   6: {0: [0.0, 0.167, 0.6, 0.8],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.833, 1.0, 0.8, 1.0],
                                       3: [0.833, 1.0, 0.2, 0.4],
                                       4: [0.5, 0.667, 0.0, 0.2],
                                       5: [0.0, 0.167, 0.0, 0.2]},
                                   7: {0: [0.2, 0.4, 0.77, 1.0],
                                       1: [0.6, 0.8, 0.77, 1.0],
                                       2: [0.82, 1.0, 0.5, 0.7],
                                       3: [0.8, 1.0, 0.0, 0.25],
                                       4: [0.4, 0.6, 0.0, 0.25],
                                       5: [0.0, 0.2, 0.0, 0.25],
                                       6: [0.0, 0.18, 0.5, 0.7]},
                                   8: {0: [0.0, 0.2, 0.8, 1.0],
                                       1: [0.4, 0.6, 0.8, 1.0],
                                       2: [0.8, 1.0, 0.8, 1.0],
                                       3: [0.8, 1.0, 0.4, 0.6],
                                       4: [0.8, 1.0, 0.0, 0.2],
                                       5: [0.4, 0.6, 0.0, 0.2],
                                       6: [0.0, 0.2, 0.0, 0.2],
                                       7: [0.0, 0.2, 0.4, 0.6]},
                                   9: {0: [0.0, 0.167, 0.8, 1.0],
                                       1: [0.333, 0.5, 0.8, 1.0],
                                       2: [0.667, 0.81, 0.82, 1.0],
                                       3: [0.85, 1.0, 0.6, 0.77],
                                       4: [0.85, 1.0, 0.22, 0.4],
                                       5: [0.667, 0.81, 0.0, 0.18],
                                       6: [0.333, 0.5, 0.0, 0.2],
                                       7: [0.0, 0.167, 0.0, 0.2],
                                       8: [0.0, 0.167, 0.4, 0.6]},
                                   10: {0: [0.0, 0.15, 0.5, 0.65],
                                        1: [0.0, 0.167, 0.833, 1.0],
                                        2: [0.333, 0.5, 0.833, 1.0],
                                        3: [0.667, 0.81, 0.85, 1.0],
                                        4: [0.85, 1.0, 0.667, 0.81],
                                        5: [0.833, 1.0, 0.333, 0.5],
                                        6: [0.833, 1.0, 0.0, 0.167],
                                        7: [0.5, 0.667, 0.0, 0.167],
                                        8: [0.18, 0.333, 0.0, 0.15],
                                        9: [0.0, 0.15, 0.18, 0.333]}
                        }
                        center_isle = {2: [0.35, 0.65, 0.4, 0.6],
                                       3: [0.28, 0.72, 0.4, 0.6],
                                       4: [0.38, 0.62, 0.38, 0.62],
                                       5: [0.27, 0.73, 0.3, 0.7],
                                       6: [0.25, 0.75, 0.3, 0.7],
                                       7: [0.3, 0.7, 0.35, 0.65],
                                       8: [0.32, 0.68, 0.32, 0.68],
                                       9: [0.25, 0.75, 0.3, 0.7],
                                       10: [0.25, 0.75, 0.25, 0.75]
                        }
                        the_wheel = {2: [[0.167, 0.2], [0.167, 0.8], [0.833, 0.8], [0.833, 0.2]],
                                     3: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     4: [[0.167, 0.167], [0.167, 0.833], [0.833, 0.833], [0.833, 0.167]],
                                     5: [[0.083, 0.7], [0.25, 0.9], [0.75, 0.9], [0.917, 0.7], [0.917, 0.3], [0.833, 0.1], [0.167, 0.1], [0.083, 0.3]],
                                     6: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     7: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     8: [[0.1, 0.1], [0.1, 0.9], [0.9, 0.9], [0.9, 0.1]],
                                     9: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     10: [[0.083, 0.083], [0.083, 0.917], [0.917, 0.917], [0.917, 0.083]]
                        }
                        the_spokes = {2: [[0.167, 0.2, 0.167, 0.8], [0.833, 0.2, 0.833, 0.8], 
                                          [0.167, 0.5, 0.833, 0.5], [0.5, 0.2, 0.5, 0.8]],
                                      3: [[0.2, 0.833, 0.5, 0.5], [0.9, 0.667, 0.5, 0.5], [0.4, 0.167, 0.5, 0.5]],
                                      4: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167]],
                                      5: [[0.083, 0.6, 0.5, 0.5], [0.5, 0.917, 0.5, 0.5], [0.917, 0.6, 0.5, 0.5],
                                          [0.25, 0.083, 0.5, 0.5], [0.75, 0.083, 0.5, 0.5]],
                                      6: [[0.083, 0.4, 0.917, 0.6], [0.167, 0.9, 0.833, 0.1], [0.667, 0.9, 0.333, 0.1]],
                                      7: [[0.1, 0.875, 0.4, 0.5], [0.3, 0.125, 0.5, 0.5], [0.1, 0.4, 0.4, 0.5],
                                          [0.7, 0.125, 0.5, 0.5], [0.5, 0.875, 0.5, 0.5], [0.9, 0.875, 0.6, 0.5],
                                          [0.9, 0.375, 0.6, 0.5], [0.4, 0.5, 0.6, 0.5]],
                                      8: [[0.1, 0.7, 0.9, 0.3], [0.3, 0.9, 0.7, 0.1], 
                                          [0.1, 0.3, 0.9, 0.7], [0.7, 0.9, 0.3, 0.1]],
                                      9: [[0.083, 0.7, 0.333, 0.5], [0.083, 0.3, 0.333, 0.5], [0.25, 0.1, 0.417, 0.5], 
                                          [0.25, 0.9, 0.417, 0.5], [0.583, 0.9, 0.583, 0.1], [0.333, 0.5, 0.917, 0.5],
                                          [0.917, 0.9, 0.667, 0.5], [0.917, 0.1, 0.667, 0.5]],
                                      10: [[0.25, 0.917, 0.75, 0.083], [0.417, 0.083, 0.583, 0.917], [0.083, 0.083, 0.917, 0.917], 
                                           [0.083, 0.417, 0.917, 0.583], [0.083, 0.75, 0.917, 0.25]]
                        }

                else:
                        templates = {2: {0: [0.0, 0.333, 0.0, 1.0],
                                         1: [0.667, 1.0, 0.0, 1.0]},
                                     3: {0: [0.0, 0.25, 0.25, 0.75],
                                         1: [0.5, 1.0, 0.75, 1.0],
                                         2: [0.5, 1.0, 0.0, 0.25]},
                                     4: {0: [0.0, 0.333, 0.333, 0.667],
                                         1: [0.333, 0.667, 0.667, 1.0],
                                         2: [0.667, 1.0, 0.333, 0.667],
                                         3: [0.333, 0.667, 0.0, 0.333]},
                                     5: {0: [0.0, 0.25, 0.333, 1.0],
                                         1: [0.25, 0.75, 0.667, 1.0],
                                         2: [0.75, 1.0, 0.333, 1.0],
                                         3: [0.5, 1.0, 0.0, 0.333],
                                         4: [0.0, 0.5, 0.0, 0.333]},
                                     6: {0: [0.0, 0.4, 0.667, 1.0],
                                         1: [0.4, 0.8, 0.667, 1.0],
                                         2: [0.8, 1.0, 0.333, 1.0],
                                         3: [0.6, 1.0, 0.0, 0.333],
                                         4: [0.2, 0.6, 0.0, 0.333],
                                         5: [0.0, 0.2, 0.0, 0.667]},
                                     7: {0: [0.0, 0.4, 0.75, 1.0],
                                         1: [0.4, 0.8, 0.75, 1.0],
                                         2: [0.8, 1.0, 0.5, 1.0],
                                         3: [0.8, 1.0, 0.0, 0.5],
                                         4: [0.4, 0.8, 0.0, 0.25],
                                         5: [0.0, 0.4, 0.0, 0.25],
                                         6: [0.0, 0.2, 0.25, 0.75]},
                                     8: {0: [0.0, 0.3, 0.35, 0.65],
                                         1: [0.0, 0.3, 0.7, 1.0],
                                         2: [0.35, 0.65, 0.7, 1.0],
                                         3: [0.7, 1.0, 0.7, 1.0],
                                         4: [0.7, 1.0, 0.35, 0.65],
                                         5: [0.7, 1.0, 0.0, 0.3],
                                         6: [0.35, 0.65, 0.0, 0.3],
                                         7: [0.0, 0.3, 0.0, 0.3]},
                                     9: {0: [0.0, 0.167, 0.6, 1.0],
                                         1: [0.167, 0.5, 0.8, 1.0],
                                         2: [0.5, 0.833, 0.8, 1.0],
                                         3: [0.833, 1.0, 0.6, 1.0],
                                         4: [0.833, 1.0, 0.2, 0.6],
                                         5: [0.667, 1.0, 0.0, 0.2],
                                         6: [0.333, 0.667, 0.0, 0.2],
                                         7: [0.0, 0.333, 0.0, 0.2],
                                         8: [0.0, 0.167, 0.2, 0.6]},
                                     10: {0: [0.0, 0.167, 0.5, 0.833],
                                          1: [0.0, 0.333, 0.833, 1.0],
                                          2: [0.333, 0.667, 0.833, 1.0],
                                          3: [0.667, 1.0, 0.833, 1.0],
                                          4: [0.833, 1.0, 0.5, 0.833],
                                          5: [0.833, 1.0, 0.167, 0.5],
                                          6: [0.667, 1.0, 0.0, 0.167],
                                          7: [0.333, 0.667, 0.0, 0.167],
                                          8: [0.0, 0.333, 0.0, 0.167],
                                          9: [0.0, 0.167, 0.167, 0.5]},
                                     11: {0: [0.0, 0.2, 0.167, 0.5],
                                          1: [0.0, 0.2, 0.5, 0.833],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333]},
                                     12: {0: [0.0, 0.2, 0.333, 0.667],
                                          1: [0.0, 0.2, 0.667, 1.0],
                                          2: [0.2, 0.4, 0.667, 1.0],
                                          3: [0.4, 0.6, 0.667, 1.0],
                                          4: [0.6, 0.8, 0.667, 1.0],
                                          5: [0.8, 1.0, 0.667, 1.0],
                                          6: [0.8, 1.0, 0.333, 0.667],
                                          7: [0.8, 1.0, 0.0, 0.333],
                                          8: [0.6, 0.8, 0.0, 0.333],
                                          9: [0.4, 0.6, 0.0, 0.333],
                                          10: [0.2, 0.4, 0.0, 0.333],
                                          11: [0.0, 0.2, 0.0, 0.333]},
                                     13: {0: [0.0, 0.2, 0.375, 0.625],
                                          1: [0.0, 0.2, 0.7, 0.95],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.05, 0.3]},
                                     14: {0: [0.0, 0.2, 0.5, 0.75],
                                          1: [0.0, 0.2, 0.75, 1.0],
                                          2: [0.2, 0.4, 0.75, 1.0],
                                          3: [0.4, 0.6, 0.75, 1.0],
                                          4: [0.6, 0.8, 0.75, 1.0],
                                          5: [0.8, 1.0, 0.75, 1.0],
                                          6: [0.8, 1.0, 0.5, 0.75],
                                          7: [0.8, 1.0, 0.25, 0.5],
                                          8: [0.8, 1.0, 0.0, 0.25],
                                          9: [0.6, 0.8, 0.0, 0.25],
                                          10: [0.4, 0.6, 0.0, 0.25],
                                          11: [0.2, 0.4, 0.0, 0.25],
                                          12: [0.0, 0.2, 0.0, 0.25],
                                          13: [0.0, 0.2, 0.25, 0.5]},
                                     15: {0: [0.0, 0.167, 0.375, 0.625],
                                          1: [0.0, 0.167, 0.7, 0.95],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.05, 0.3]},
                                     16: {0: [0.0, 0.167, 0.5, 0.75],
                                          1: [0.0, 0.167, 0.75, 1.0],
                                          2: [0.167, 0.333, 0.75, 1.0],
                                          3: [0.333, 0.5, 0.75, 1.0],
                                          4: [0.5, 0.667, 0.75, 1.0],
                                          5: [0.667, 0.833, 0.75, 1.0],
                                          6: [0.833, 1.0, 0.75, 1.0],
                                          7: [0.833, 1.0, 0.5, 0.75],
                                          8: [0.833, 1.0, 0.25, 0.5],
                                          9: [0.833, 1.0, 0.0, 0.25],
                                          10: [0.667, 0.833, 0.0, 0.25],
                                          11: [0.5, 0.667, 0.0, 0.25],
                                          12: [0.333, 0.5, 0.0, 0.25],
                                          13: [0.167, 0.333, 0.0, 0.25],
                                          14: [0.0, 0.167, 0.25, 0.5],
                                          15: [0.0, 0.167, 0.0, 0.25]},
                                     17: {0: [0.0, 0.167, 0.5, 0.7],
                                          1: [0.0, 0.167, 0.7, 0.9],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.1, 0.3],
                                          16: [0.0, 0.167, 0.3, 0.5]},
                                     18: {0: [0.0, 0.167, 0.6, 0.8],
                                          1: [0.0, 0.167, 0.8, 1.0],
                                          2: [0.167, 0.333, 0.8, 1.0],
                                          3: [0.333, 0.5, 0.8, 1.0],
                                          4: [0.5, 0.667, 0.8, 1.0],
                                          5: [0.667, 0.833, 0.8, 1.0],
                                          6: [0.833, 1.0, 0.8, 1.0],
                                          7: [0.833, 1.0, 0.6, 0.8],
                                          8: [0.833, 1.0, 0.4, 0.6],
                                          9: [0.833, 1.0, 0.2, 0.4],
                                          10: [0.833, 1.0, 0.0, 0.2],
                                          11: [0.667, 0.833, 0.0, 0.2],
                                          12: [0.5, 0.667, 0.0, 0.2],
                                          13: [0.333, 0.5, 0.0, 0.2],
                                          14: [0.167, 0.333, 0.0, 0.2],
                                          15: [0.0, 0.167, 0.0, 0.2],
                                          16: [0.0, 0.167, 0.2, 0.4],
                                          17: [0.0, 0.167, 0.4, 0.6]}
                        }
                        center_isle = {2: [0.35, 0.65, 0.4, 0.6],
                                       3: [0.38, 0.7, 0.35, 0.65],
                                       4: [0.37, 0.63, 0.37, 0.63],
                                       5: [0.32, 0.68, 0.38, 0.62],
                                       6: [0.28, 0.72, 0.38, 0.62],
                                       7: [0.28, 0.72, 0.35, 0.65],
                                       8: [0.37, 0.63, 0.37, 0.63],
                                       9: [0.3, 0.7, 0.35, 0.65],
                                       10: [0.3, 0.7, 0.3, 0.7],
                                       11: [0.28, 0.72, 0.38, 0.62],
                                       12: [0.28, 0.72, 0.38, 0.62],
                                       13: [0.3, 0.7, 0.35, 0.65],
                                       14: [0.3, 0.7, 0.35, 0.65],
                                       15: [0.25, 0.75, 0.35, 0.65],
                                       16: [0.25, 0.75, 0.35, 0.65],
                                       17: [0.25, 0.75, 0.3, 0.7],
                                       18: [0.25, 0.75, 0.3, 0.7]
                        }
                        the_wheel = {2: [[0.167, 0.3], [0.167, 0.7], [0.833, 0.7], [0.833, 0.3]],
                                     3: [[0.125, 0.375], [0.125, 0.625], [0.625, 0.875], [0.875, 0.875], [0.875, 0.125], [0.625, 0.125]],
                                     4: [[0.167, 0.5], [0.5, 0.833], [0.833, 0.5], [0.5, 0.167]],
                                     5: [[0.125, 0.167], [0.125, 0.833], [0.875, 0.833], [0.875, 0.167]],
                                     6: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     7: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     8: [[0.167, 0.167], [0.167, 0.833], [0.833, 0.833], [0.833, 0.167]],
                                     9: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]],
                                     10: [[0.083, 0.083], [0.083, 0.917], [0.917, 0.917], [0.917, 0.083]],
                                     11: [[0.1, 0.333], [0.1, 0.667], [0.3, 0.833], [0.9, 0.833], [0.9, 0.167], [0.3, 0.167]],
                                     12: [[0.1, 0.167], [0.1, 0.833], [0.9, 0.833], [0.9, 0.167]],
                                     13: [[0.1, 0.175], [0.1, 0.825], [0.3, 0.875], [0.9, 0.875], [0.9, 0.125], [0.3, 0.125]],
                                     14: [[0.1, 0.125], [0.1, 0.875], [0.9, 0.875], [0.9, 0.125]],
                                     15: [[0.083, 0.175], [0.083, 0.825], [0.25, 0.875], [0.917, 0.875], [0.917, 0.125], [0.25, 0.125]],
                                     16: [[0.083, 0.125], [0.083, 0.875], [0.917, 0.875], [0.917, 0.125]],
                                     17: [[0.083, 0.2], [0.083, 0.8], [0.25, 0.9], [0.917, 0.9], [0.917, 0.1], [0.25, 0.1]],
                                     18: [[0.083, 0.1], [0.083, 0.9], [0.917, 0.9], [0.917, 0.1]]
                        }
                        the_spokes = {2: [[0.167, 0.2, 0.167, 0.8], [0.833, 0.2, 0.833, 0.8], [0.167, 0.5, 0.833, 0.5]],
                                      3: [[0.125, 0.5, 0.5, 0.5], [0.75, 0.125, 0.5, 0.5], [0.75, 0.875, 0.5, 0.5]],
                                      4: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167]],
                                      5: [[0.125, 0.667, 0.375, 0.5], [0.25, 0.167, 0.375, 0.5], [0.375, 0.5, 0.625, 0.5],
                                          [0.5, 0.5, 0.5, 0.833], [0.625, 0.5, 0.75, 0.167], [0.625, 0.5, 0.875, 0.667]],
                                      6: [[0.1, 0.333, 0.3, 0.5], [0.7, 0.5, 0.8, 0.167], [0.7, 0.5, 0.9, 0.667], 
                                          [0.4, 0.167, 0.6, 0.833], [0.2, 0.833, 0.3, 0.5], [0.3, 0.5, 0.7, 0.5]],
                                      7: [[0.2, 0.875, 0.3, 0.5], [0.2, 0.125, 0.3, 0.5], [0.1, 0.5, 0.7, 0.5],
                                          [0.6, 0.125, 0.5, 0.5], [0.6, 0.875, 0.5, 0.5], [0.9, 0.75, 0.7, 0.5],
                                          [0.9, 0.25, 0.7, 0.5]],
                                      8: [[0.167, 0.5, 0.833, 0.5], [0.5, 0.833, 0.5, 0.167], 
                                          [0.167, 0.167, 0.833, 0.833], [0.167, 0.833, 0.833, 0.167]],
                                      9: [[0.083, 0.8, 0.375, 0.5], [0.083, 0.4, 0.375, 0.5], [0.167, 0.1, 0.375, 0.5], 
                                          [0.333, 0.9, 0.5, 0.5], [0.667, 0.9, 0.5, 0.5], [0.5, 0.1, 0.5, 0.5],
                                          [0.917, 0.8, 0.625, 0.5], [0.917, 0.4, 0.625, 0.5], [0.833, 0.1, 0.625, 0.5], 
                                          [0.375, 0.5, 0.625, 0.5]],
                                      10: [[0.167, 0.917, 0.833, 0.083], [0.5, 0.083, 0.5, 0.917], [0.167, 0.083, 0.833, 0.917], 
                                           [0.083, 0.333, 0.917, 0.667], [0.083, 0.667, 0.917, 0.333]],
                                      11: [[0.7, 0.5, 0.9, 0.5], [0.7, 0.5, 0.9, 0.167], [0.7, 0.5, 0.9, 0.833], 
                                           [0.6, 0.5, 0.7, 0.833], [0.6, 0.5, 0.7, 0.167], [0.5, 0.5, 0.5, 0.833],
                                           [0.5, 0.5, 0.5, 0.167], [0.4, 0.5, 0.3, 0.167], [0.4, 0.5, 0.3, 0.833], 
                                           [0.3, 0.5, 0.1, 0.667], [0.3, 0.5, 0.1, 0.333], [0.3, 0.5, 0.7, 0.5]],
                                      12: [[0.7, 0.5, 0.9, 0.5], [0.7, 0.5, 0.9, 0.167], [0.7, 0.5, 0.9, 0.833], 
                                           [0.6, 0.5, 0.7, 0.833], [0.6, 0.5, 0.7, 0.167], [0.5, 0.5, 0.5, 0.833],
                                           [0.5, 0.5, 0.5, 0.167], [0.4, 0.5, 0.3, 0.167], [0.4, 0.5, 0.3, 0.833], 
                                           [0.3, 0.5, 0.1, 0.167], [0.3, 0.5, 0.1, 0.833], [0.3, 0.5, 0.1, 0.5], 
                                           [0.3, 0.5, 0.7, 0.5]],
                                      13: [[0.3, 0.875, 0.5, 0.125], [0.3, 0.5, 0.6, 0.5], [0.5, 0.875, 0.3, 0.125], 
                                           [0.7, 0.125, 0.9, 0.375], [0.7, 0.875, 0.9, 0.625], [0.9, 0.125, 0.6, 0.5],
                                           [0.9, 0.875, 0.6, 0.5], [0.1, 0.175, 0.3, 0.5], [0.1, 0.5, 0.3, 0.5], 
                                           [0.1, 0.825, 0.3, 0.5]],
                                      14: [[0.3, 0.875, 0.1, 0.625], [0.4, 0.5, 0.6, 0.5], [0.1, 0.375, 0.3, 0.125], 
                                           [0.7, 0.125, 0.9, 0.375], [0.7, 0.875, 0.9, 0.625], [0.9, 0.125, 0.6, 0.5],
                                           [0.9, 0.875, 0.6, 0.5], [0.1, 0.125, 0.4, 0.5], [0.1, 0.875, 0.4, 0.5], 
                                           [0.5, 0.125, 0.5, 0.875]],
                                      15: [[0.583, 0.125, 0.25, 0.875], [0.25, 0.5, 0.667, 0.5], [0.583, 0.875, 0.25, 0.125], 
                                           [0.75, 0.125, 0.917, 0.375], [0.75, 0.875, 0.917, 0.625], [0.917, 0.125, 0.667, 0.5],
                                           [0.917, 0.875, 0.667, 0.5], [0.083, 0.175, 0.25, 0.5], [0.083, 0.5, 0.25, 0.5], 
                                           [0.083, 0.825, 0.25, 0.5], [0.417, 0.125, 0.417, 0.875]],
                                      16: [[0.083, 0.875, 0.417, 0.125], [0.25, 0.5, 0.75, 0.5], [0.417, 0.875, 0.083, 0.125], 
                                           [0.75, 0.125, 0.75, 0.875], [0.25, 0.125, 0.25, 0.875], [0.917, 0.125, 0.583, 0.875],
                                           [0.917, 0.875, 0.583, 0.125], [0.083, 0.625, 0.25, 0.5], [0.083, 0.375, 0.25, 0.5], 
                                           [0.917, 0.375, 0.75, 0.5], [0.917, 0.625, 0.75, 0.5]],
                                      17: [[0.25, 0.5, 0.917, 0.5], [0.083, 0.6, 0.25, 0.5], [0.083, 0.4, 0.25, 0.5], 
                                           [0.083, 0.8, 0.333, 0.7], [0.25, 0.9, 0.417, 0.5], [0.417, 0.9, 0.333, 0.7], 
                                           [0.583, 0.9, 0.75, 0.7], [0.75, 0.9, 0.75, 0.7], [0.917, 0.9, 0.583, 0.5], 
                                           [0.917, 0.7, 0.75, 0.5], [0.917, 0.3, 0.75, 0.5], [0.917, 0.1, 0.583, 0.5],
                                           [0.75, 0.1, 0.75, 0.3], [0.583, 0.1, 0.75, 0.3], [0.417, 0.1, 0.333, 0.3], 
                                           [0.25, 0.1, 0.417, 0.5], [0.083, 0.2, 0.333, 0.3]],
                                      18: [[0.083, 0.5, 0.917, 0.5], [0.083, 0.7, 0.25, 0.5], [0.083, 0.3, 0.25, 0.5], 
                                           [0.083, 0.9, 0.417, 0.5], [0.25, 0.9, 0.25, 0.7], [0.417, 0.9, 0.25, 0.7], 
                                           [0.583, 0.9, 0.75, 0.7], [0.75, 0.9, 0.75, 0.7], [0.917, 0.9, 0.583, 0.5], 
                                           [0.917, 0.7, 0.75, 0.5], [0.917, 0.3, 0.75, 0.5], [0.917, 0.1, 0.583, 0.5],
                                           [0.75, 0.1, 0.75, 0.3], [0.583, 0.1, 0.75, 0.3], [0.417, 0.1, 0.25, 0.3], 
                                           [0.25, 0.1, 0.25, 0.3], [0.083, 0.1, 0.417, 0.5]]
                        }
                region_data = []
                for regionLoop in range(iPlayers):
                        [fWestLon, fEastLon, fSouthLat, fNorthLat] = templates[iPlayers][regionLoop]
                        iWestX = int((iW - 1) * fWestLon)
                        iEastX = int((iW - 1) * fEastLon) - 1
                        iSouthY = int((iH - 1) * fSouthLat)
                        iNorthY = int((iH - 1) * fNorthLat) -1
                        region_data.append([iWestX, iEastX, iSouthY, iNorthY])
                if userInputLandmass == 1 and iPlayers >= 2 and iPlayers <= 10:
                        buffer_data = []
                        for bufferLoop in range(iPlayers):
                                [fWestLon, fEastLon, fSouthLat, fNorthLat] = buffers[iPlayers][bufferLoop]
                                iWestX = int((iW - 1) * fWestLon)
                                iEastX = int((iW - 1) * fEastLon) - 1
                                iSouthY = int((iH - 1) * fSouthLat)
                                iNorthY = int((iH - 1) * fNorthLat) -1
                                buffer_data.append([iWestX, iEastX, iSouthY, iNorthY])
                else: pass
                [fWestLon, fEastLon, fSouthLat, fNorthLat] = center_isle[iPlayers]
                iWestX = int((iW - 1) * fWestLon)
                iEastX = int((iW - 1) * fEastLon) - 1
                iSouthY = int((iH - 1) * fSouthLat)
                iNorthY = int((iH - 1) * fNorthLat) -1
                center_data = [iWestX, iEastX, iSouthY, iNorthY]
                wheel_data = []
                for [fLon, fLat] in the_wheel[iPlayers]:
                        iX = int((iW - 1) * fLon)
                        iY = int((iH - 1) * fLat)
                        wheel_data.append([iX, iY])
                [fLon, fLat] = the_wheel[iPlayers][0]
                iX = int((iW - 1) * fLon)
                iY = int((iH - 1) * fLat)
                wheel_data.append([iX, iY])
                hub_data = []
                for [fStartLon, fStartLat, fEndLon, fEndLat] in the_spokes[iPlayers]:
                        iStartX = int((iW - 1) * fStartLon)
                        iStartY = int((iH - 1) * fStartLat)
                        iEndX = int((iW - 1) * fEndLon)
                        iEndY = int((iH - 1) * fEndLat)
                        hub_data.append([iStartX, iStartY, iEndX, iEndY])
        elif idMap == "bigandsmall" :
                xShiftRoll = getRandNum(2, "FoR : Region Shift, Horizontal - Big and Small PYTHON")
        elif idMap == "hemispheres" :
                xShiftRoll = getRandNum(2, "FoR : Region Shift, Horizontal - Left and Right PYTHON")
                yShiftRoll = getRandNum(2, "FoR : Region Shift, Vertical - Left and Right PYTHON")
                ySplitRoll = getRandNum(2, "FoR : Region Split, Vertical - Left and Right PYTHON")
                yPortionRoll = getRandNum(2, "FoR : Region Portioning, Vertical - Left and Right PYTHON")
        elif idMap == "mediumandsmall" :
                yShiftRoll1 = getRandNum(2, "FoR : West Region Shift, Vertical - Medium and Small PYTHON")
                yShiftRoll2 = getRandNum(2, "FoR : East Region Shift, Vertical - Medium and Small PYTHON")

def generatePlotTypes():
        try :
                writeLog(" = generatePlotTypes = ", False, [""])
                NiTextOut("Setting Plot Types (Full of resources) ...")
                global bSuccessFlag
                if idMap == "archipelago" :
                        waterPer = getRandSel(selGen["maps"]["archipelago"]["waterper"], False)
                        fractal_world = ArchipelagoFractalWorld()
                        userInputLandmass = cmo[0]
                        if userInputLandmass == 2:
                                fractal_world.initFractal(continent_grain = 5, rift_grain = -1, has_center_rift = False, polar = True)
                                plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer, grain_amount = 4)
                        elif userInputLandmass == 0:
                                fractal_world.initFractal(continent_grain = 3, rift_grain = -1, has_center_rift = False, polar = True)
                                plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer, grain_amount = 4)
                        else:
                                fractal_world.initFractal(continent_grain = 4, rift_grain = -1, has_center_rift = False, polar = True)
                                plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer, grain_amount = 4)
                elif idMap == "continents" :
                        waterPer = getRandSel(selGen["maps"]["continents"]["waterper"], False)
                        fractal_world = FractalWorld()
                        fractal_world.initFractal(polar = True)
                        plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer)
                elif idMap == "customcontinents" :
                        fractal_world = CCMultilayeredFractal()
                        plotTypes = fractal_world.generatePlotsByRegion()
                elif idMap == "fractals" :
                        waterPer = getRandSel(selGen["maps"]["fractals"]["waterper"], False)
                        fractal_world = FractalWorld()
                        fractal_world.initFractal(rift_grain = -1, has_center_rift = False, polar = True)
                        plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer)
                elif idMap == "hub" :
                        if not bSuccessFlag:
                                fractal_world = FractalWorld()
                                fractal_world.initFractal(polar = True)
                                plotTypes = fractal_world.generatePlotTypes()
                        else:
                                fractal_world = HubMultilayeredFractal()
                                userInputLandmass = cmo[0]
                                if userInputLandmass == 1:
                                        hub_type = 1
                                else:
                                        hub_type = 0
                                plotTypes = fractal_world.generatePlotsByRegion(hub_type)
                elif idMap == "inlandsea" :
                        global hinted_world
                        hinted_world = ISHintedWorld(4,2)
                        for y in range(hinted_world.h):
                                for x in range(hinted_world.w):
                                        if x in (0, hinted_world.w-1) or y in (0, hinted_world.h-1):
                                                hinted_world.setValue(x, y, 200 + getRandNum(55, "FoR : Plot Types - Inland Sea PYTHON"))
                                        else:
                                                hinted_world.setValue(x, y, 0)

                        hinted_world.buildAllContinents()
                        plotTypes = hinted_world.generatePlotTypes()
                elif idMap == "islands" :
                        iPlayers = game.countCivPlayersEverAlive()
                        if iPlayers > 0 and iPlayers < 19:
                                fractal_world = IslandsMultilayeredFractal()
                                plotTypes = fractal_world.generatePlotsByRegion()
                        else:
                                fractal_world = FractalWorld()
                                fractal_world.initFractal(polar = True)
                                plotTypes = fractal_world.generatePlotTypes()
                elif idMap == "lakes" :
                        waterPer = getRandSel(selGen["maps"]["lakes"]["waterper"], False)
                        userInputLakesSize = getRandSel(selGen["maps"]["lakes"]["lakesize"])
                        grainCont = 3
                        grainCont += userInputLakesSize
                        grainCont += int(waterPer/35)

                        fractal_world = LakesFractalWorld()
                        fractal_world.initFractal(continent_grain = grainCont, rift_grain = -1, has_center_rift = False, invert_heights = True)
                        plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer)
                elif idMap == "maze" :
                        plotTypes = generateMazePlotTypes()
                elif idMap == "pangaea" :
                        plotTypes = generatePangaeaPlotTypes()
                elif idMap == "ring" :
                        if bSuccessFlag:
                                fractal_world = RingMultilayeredFractal()
                                userInputLandmass = cmo[0]
                                if userInputLandmass == 1:
                                        ring_type = 1
                                else:
                                        ring_type = 0
                                plotTypes = fractal_world.generatePlotsByRegion(ring_type)
                        else:
                                fractal_world = FractalWorld()
                                fractal_world.initFractal(polar = True)
                                plotTypes = fractal_world.generatePlotTypes()
                elif idMap == "shuffle" :
                        waterPer = getRandSel(selGen["maps"]["shuffle"]["waterper"], False)
                        fractal_world = FractalWorld()
                        grainRoll = 1 + getRandNum(8, "FoR : Fractal Grain - Shuffle PYTHON")
                        if grainRoll > 5:
                                grainRoll -= 5
                        if grainRoll == 2:
                                fractal_world.initFractal(polar = True)
                                plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer)
                        else:
                                if grainRoll == 5: grainRoll -= 3
                                fractal_world.initFractal(continent_grain = grainRoll, rift_grain = -1, has_center_rift = False, polar = True)
                                plotTypes = fractal_world.generatePlotTypes(water_percent = waterPer)
                elif idMap == "terra" :
                        plotgen = TerraMultilayeredFractal()
                        plotTypes = plotgen.generatePlotsByRegion()
                elif idMap == "wheel" :
                        if bSuccessFlag:
                                fractal_world = WheelMultilayeredFractal()
                                userInputLandmass = cmo[0]
                                if userInputLandmass == 1:
                                        wheel_type = 1
                                else:
                                        wheel_type = 0
                                plotTypes = fractal_world.generatePlotsByRegion(wheel_type)
                        else:
                                fractal_world = FractalWorld()
                                fractal_world.initFractal(polar = True)
                                plotTypes = fractal_world.generatePlotTypes()
                elif idMap == "chess" :
                        bSuccessFlag, plotTypes = generateChessPlotTypes()
                elif idMap == "bigandsmall" :
                        fractal_world = BnSMultilayeredFractal()
                        plotTypes = fractal_world.generatePlotsByRegion()
                elif idMap == "hemispheres" :
                        fractal_world = BnSHemMultilayeredFractal()
                        plotTypes = fractal_world.generatePlotsByRegion()
                elif idMap == "mediumandsmall" :
                        fractal_world = MnSMultilayeredFractal()
                        plotTypes = fractal_world.generatePlotsByRegion()

                if idMap == "chess" :
                        if bSuccessFlag :
                                writeLog("", True, [" Chess generation finished ..."])
                                return plotTypes
                elif idMap == "tectonics" :
                        userInputLandmass = cmo[0]
                        numPlayers = game.countCivPlayersEverAlive()
                        surface = iH * iW
                        numPlayers = (numPlayers + surface / 400) / 2
                        numContinents = 1
                        numSeaPlates = 1
                        hotspotsFrequency = 900
                        bGenerated = False
                        if (userInputLandmass == 0):       #                 "Earthlike (70% water)"
                                numContinents = 1 + numPlayers
                                numSeaPlates = numPlayers*3
                        elif (userInputLandmass == 1):       #               "Earthlike (60% water)"
                                numContinents = 1 + numPlayers*2
                                numSeaPlates = numPlayers*3 - 1
                        elif (userInputLandmass == 2):     #                 "Pangaea"
                                generator = voronoiPangaeaMap(numPlayers)
                                plotTypes = generator.generate()
                                bGenerated = True
                        elif (userInputLandmass == 3):     #                 "Lakes (30% water")
                                numContinents = 1 + numPlayers*3
                                numSeaPlates = numPlayers - 1
                                hotspotsFrequency = 1600
                        elif (userInputLandmass == 4):     #                 "Islands"
                                numContinents = numPlayers
                                numSeaPlates = numPlayers*6 - 1
                                hotspotsFrequency = 300
                        elif (userInputLandmass == 5):     #                 "Mediterranean"
                                generator = voronoiMediterraneanMap(numPlayers)
                                plotTypes = generator.generate()
                                bGenerated = True
                        elif (userInputLandmass == 6 or userInputLandmass == 7): # "Terra"
                                generator = voronoiTerraMap()
                                plotTypes = generator.generate()
                                bGenerated = True

                        if not bGenerated :
                                #width = gc.getMap().getGridWidth() ??
                                generator = voronoiMap(numContinents, numSeaPlates, hotspotsFrequency)
                                plotTypes = generator.generate()

                ## apply options chosen
                try :
                        remPeak = bool((selGen["terrain"]["peak"]["peakcoast"]) or (idMap in ["archipelago", "maze"]))
                        minIslandTiles = getRandSel(selGen["terrain"]["island"]["nbtilesminisland"], False)
                        if selGen["terrain"]["peak"]["peakpercent"] == "standard" : peakPer = "standard"
                        else : peakPer = getRandSel(selGen["terrain"]["peak"]["peakpercent"], False, "float") / 100.0
                        if selGen["terrain"]["hill"]["hillpercent"] == "standard" : hillPer = "standard"
                        else : hillPer = getRandSel(selGen["terrain"]["hill"]["hillpercent"], False) / 100.0
                        if idMap == "chess" :
                                minIslandTiles = max(minIslandTiles, 2)

                        # debug
                        logList = []
                        logList.append(" reamove peak : %r" %remPeak)
                        logList.append(" minIslandTiles : %r" %minIslandTiles)
                        logList.append(" peak percent : %r" %peakPer)
                        logList.append(" hill percent : %r" %hillPer)
                        logList.append("")
                        writeLog("", False, logList)

                        pWater = PlotTypes.PLOT_OCEAN
                        pLand = PlotTypes.PLOT_LAND
                        pHill = PlotTypes.PLOT_HILLS
                        pPeak = PlotTypes.PLOT_PEAK
                        rings = generateRings(1)
                        ring1 = rings[1]

                        # store plot types in a grid size
                        tPlots = [[ plotTypes[map.plotNum(iX, iY)] for iY in range(iH)] for iX in range(iW) ]

                        # be sure with some maps that there is no land at the poles (to prevent that ships can't do go everywhere in the map , if ice is removed along the coast)
                        if idMap in ["archipelago", "continents", "customcontinents", "fractals", "islands", "pangaea", "shuffle", "terra", "bigandsmall", "hemispheres", "mediumandsmall"] :
                                for iY in [0, iH-1] :
                                        for iX in range(iW) :
                                                tPlots[iX][iY] = pWater

                        # prevent a long line of plot just near the border of the map for hub, wheel, ring
                        if idMap in ["hub", "wheel", "ring"] :
                                while True :
                                        bChange = False
                                        for iY in [1, iH-2] :
                                                if bChange : break
                                                lXPlots = []
                                                for iX in range(iW) :
                                                        if tPlots[iX][iY] != pWater :
                                                                lXPlots.append(iX)
                                                                continue
                                                        if len(lXPlots) >= 4 :
                                                                iChoice = getRandNum(len(lXPlots) - 2, " FoR : hub , side plot")
                                                                tPlots[lXPlots[iChoice+1]][iY] = pWater
                                                                bChange = True
                                                                break
                                                        else :
                                                                lXPlots = []
                                        if not bChange : break

                                while True :
                                        bChange = False
                                        for iX in [1, iW-2] :
                                                if bChange : break
                                                lYPlots = []
                                                for iY in range(iH) :
                                                        if tPlots[iX][iY] != pWater :
                                                                lYPlots.append(iY)
                                                                continue
                                                        if len(lYPlots) >= 4 :
                                                                iChoice = getRandNum(len(lYPlots) - 2, " FoR : hub , side plot")
                                                                tPlots[iX][lYPlots[iChoice+1]] = pWater
                                                                bChange = True
                                                                break
                                                        else :
                                                                lYPlots = []
                                        if not bChange : break

                        # remove small islands
                        def getAreaTiles((x, y), lPlots):
                                if not (x, y) in lPlots : lPlots.append((x, y))
                                if len(lPlots) <= minIslandTiles + 2 : # prevent an exceed of number of reccursion 
                                        for dx, dy in ring1 :
                                                wTP = toWrap(x + dx, y +dy)
                                                if wTP != -1 :
                                                        if tPlots[wTP[0]][wTP[1]] != pWater :
                                                                if not wTP in lPlots :
                                                                        lPlots = getAreaTiles(wTP, lPlots)
                                return lPlots
                            
                        testedPlots = []
                        plotsToRemove = []
                        for iX in range(iW) :
                                for iY in range(iH) :
                                        if tPlots[iX][iY] == pWater : continue
                                        if (iX, iY) in testedPlots : continue
                                        areaPlots = getAreaTiles((iX, iY), [])
                                        testedPlots += areaPlots
                                        if len(areaPlots) < minIslandTiles : plotsToRemove += areaPlots

                        for x, y in plotsToRemove : tPlots[x][y] = pWater

                        def isCoast(x, y) :
                                for dx, dy in ring1 :
                                        wTP = toWrap(x + dx, y +dy)
                                        if wTP != -1 :
                                                if tPlots[wTP[0]][wTP[1]] == pWater : return True
                                return False

                        # debug
                        nbPeak = 0
                        nbHill = 0
                        nbTile = 0
                        nbUnwantedPeak = 0
                        nbCoastalTiles = 0
                        for iX in range(iW) :
                                for iY in range(iH) :
                                        plotType = tPlots[iX][iY]
                                        if plotType == pWater : continue
                                        if isCoast(iX, iY) :
                                                nbCoastalTiles += 1
                                                if remPeak :
                                                        if plotType == pPeak : nbUnwantedPeak += 1
                                        nbTile += 1
                                        if plotType == pHill : nbHill += 1
                                        elif plotType == pPeak : nbPeak += 1
                        logList = []
                        logList.append(" start peak number : %r" %nbPeak)
                        logList.append(" start peak percent : %r" %(float(nbPeak)/nbTile*100.0, ))
                        if remPeak :
                                if (nbTile - nbCoastalTiles) > 0 :
                                        logList.append(" start peak percent (without coastal tiles) : %r" %(float(nbPeak - nbUnwantedPeak)/(nbTile - nbCoastalTiles)*100.0, ))
                        logList.append(" start hill percent : %r" %(float(nbHill)/nbTile*100.0, ))
                        logList.append(" nb Tiles : %r" %nbTile)
                        logList.append(" nb Coastal Tiles : %r" %nbCoastalTiles)
                        logList.append(" nb unwanted peaks : %r" %nbUnwantedPeak)
                        logList.append("")
                        writeLog("", False, logList)

                        # remove peak along the coast
                        if remPeak :
                                for iX in range(iW) :
                                        for iY in range(iH) :
                                                if tPlots[iX][iY] != pPeak : continue
                                                if isCoast(iX, iY) :
                                                        tPlots[iX][iY] = pHill

                        # adjust peak percent
                        landPlots = []
                        hillPlots = []
                        peakPlots = []
                        waterPlots = []
                        coastalPlots = []
                        for iX in range(iW) :
                                for iY in range(iH) :
                                        plotType = tPlots[iX][iY]
                                        if plotType == pWater :
                                                waterPlots.append((iX, iY))
                                                continue
                                        if isCoast(iX, iY) : coastalPlots.append((iX, iY))
                                        if plotType == pLand : landPlots.append((iX, iY))
                                        elif plotType == pHill : hillPlots.append((iX, iY))
                                        elif plotType == pPeak : peakPlots.append((iX, iY))

                        # check if a path is doable between each land plots around the center plot if i place a peak at the center
                        def canHavePeak(x, y) :
                                lPlots = []
                                allPlots = []
                                nbPeakAround = 0
                                for dx, dy in ring1 :
                                        wTP = toWrap(x + dx, y +dy)
                                        if wTP != -1 :
                                                allPlots.append(wTP)
                                                plotType = tPlots[wTP[0]][wTP[1]]
                                                if plotType in [pLand, pHill] : lPlots.append(wTP)
                                                if plotType == pPeak : nbPeakAround += 1
                                if nbPeakAround > 2 : return False
                                if len(lPlots) <= 1 : return False #prevent the systematic appearance on small islands
                                sPlot = tuple(lPlots[0])
                                foundPlots = [sPlot]
                                testedPlots = []
                                while True :
                                        if len(foundPlots) == len(testedPlots) : break
                                        plotToCheck = [item for item in foundPlots if not item in testedPlots][0]
                                        testedPlots.append(plotToCheck)
                                        for dx, dy in ring1 :
                                                wTP = toWrap(plotToCheck[0] + dx, plotToCheck[1] +dy)
                                                if wTP != -1 :
                                                        if not wTP in allPlots : continue
                                                        if not wTP in lPlots : continue
                                                        if not wTP in foundPlots : foundPlots.append(wTP)
                                if len(lPlots) == len(foundPlots) : return True #all passable plots communicate
                                return False

                        nbTiles = len(peakPlots) + len(hillPlots) + len(landPlots)
                        if remPeak : nbTiles -= len(coastalPlots)

                        if nbTiles > 0 : #all plots are coastal !?
                                effPeakPer = len(peakPlots) / (nbTiles + 0.001)
                                if peakPer != "standard" :
                                        if effPeakPer > peakPer : # remove some peak
                                                while True :
                                                        if (len(peakPlots) / (nbTiles + 0.001)) < peakPer : break
                                                        if len(peakPlots) == 0 : break
                                                        iChoice = getRandNum(len(peakPlots), "FoR : peak remove")
                                                        cPlot = peakPlots[iChoice]
                                                        tPlots[cPlot[0]][cPlot[1]] = pHill
                                                        hillPlots.append(cPlot)
                                                        del peakPlots[iChoice]
                                        else :
                                                if remPeak :
                                                        ncLandPlots = [item for item in landPlots if not item in coastalPlots]
                                                        ncHillPlots = [item for item in hillPlots if not item in coastalPlots]
                                                else :
                                                        ncLandPlots = copy.copy(landPlots)
                                                        ncHillPlots = copy.copy(hillPlots)
                                                while True :
                                                        if (len(peakPlots) / (nbTiles + 0.001)) >= peakPer : break
                                                        if (len(ncLandPlots) == 0) and (len(ncHillPlots) == 0) : break
                                                        listPlots = copy.copy(ncLandPlots) + copy.copy(ncHillPlots)
                                                        iChoice = getRandNum(len(listPlots), "FoR : peak add")
                                                        cPlot = listPlots[iChoice]
                                                        if canHavePeak(cPlot[0], cPlot[1]) :
                                                                tPlots[cPlot[0]][cPlot[1]] = pPeak
                                                                peakPlots.append(cPlot)
                                                                if cPlot in hillPlots : hillPlots.remove(cPlot)
                                                                elif cPlot in landPlots : landPlots.remove(cPlot)
                                                        if cPlot in ncHillPlots : ncHillPlots.remove(cPlot)
                                                        elif cPlot in ncLandPlots : ncLandPlots.remove(cPlot)

                        # adjust hill percent
                        nbTiles = len(peakPlots) + len(hillPlots) + len(landPlots)

                        effHillPer = len(hillPlots) / (nbTiles + 0.001)
                        if hillPer != "standard" :
                                if effHillPer > hillPer :
                                        while True :
                                                if (len(hillPlots) / (nbTiles + 0.001)) < hillPer : break
                                                if len(hillPlots) == 0 : break
                                                iChoice = getRandNum(len(hillPlots), "FoR : hill remove")
                                                cPlot = hillPlots[iChoice]
                                                tPlots[cPlot[0]][cPlot[1]] = pLand
                                                landPlots.append(cPlot)
                                                del hillPlots[iChoice]
                                else :
                                        while True :
                                                if (len(hillPlots) / (nbTiles + 0.001)) >= hillPer : break
                                                if len(landPlots) == 0 : break
                                                iChoice = getRandNum(len(landPlots), "FoR : hill add")
                                                cPlot = landPlots[iChoice]
                                                tPlots[cPlot[0]][cPlot[1]] = pHill
                                                hillPlots.append(cPlot)
                                                del landPlots[iChoice]

                        # debug
                        nbPeak = 0
                        nbHill = 0
                        nbTile = 0
                        nbUnwantedPeak = 0
                        nbCoastalTiles = 0
                        for iX in range(iW) :
                                for iY in range(iH) :
                                        plotType = tPlots[iX][iY]
                                        if plotType == pWater : continue
                                        if isCoast(iX, iY) :
                                                nbCoastalTiles += 1
                                                if remPeak :
                                                        if plotType == pPeak : nbUnwantedPeak += 1
                                        nbTile += 1
                                        if plotType == pHill : nbHill += 1
                                        elif plotType == pPeak : nbPeak += 1
                        logList = []
                        logList.append(" final peak number : %r" %nbPeak)
                        logList.append(" final peak percent : %r" %(float(nbPeak)/nbTile*100.0, ))
                        if remPeak :
                                if (nbTile - nbCoastalTiles) > 0 :
                                        logList.append(" final peak percent (without coastal tiles) : %r" %(float(nbPeak - nbUnwantedPeak)/(nbTile - nbCoastalTiles)*100.0, ))
                        logList.append(" final hill percent : %r" %(float(nbHill)/nbTile*100.0, ))
                        logList.append(" final nb Tiles : %r" %nbTile)
                        logList.append(" final nb Coastal Tiles : %r" %nbCoastalTiles)
                        logList.append(" final nb unwanted peaks : %r" %nbUnwantedPeak)
                        logList.append("")
                        writeLog("", True, logList)

                        # save changes
                        for iX in range(iW) :
                                for iY in range(iH) :
                                        plotTypes[map.plotNum(iX, iY)] = tPlots[iX][iY]
                except :
                        writeLog("", True, ["", " An error occured during option application ..."])
                        writeError()

                return plotTypes
        except :
                writeLog("", True, ["", " An error occured during plot generation ... generate a fractal map"])
                writeError()
                fractal_world = FractalWorld()
                fractal_world.initFractal(polar = True)
                plotTypes = fractal_world.generatePlotTypes()
                return plotTypes

class voronoiMap:
	def __init__(self,landPlates,seaPlates,hotspotsF):
		self.dice = gc.getGame().getMapRand()
		self.mapWidth = map.getGridWidth()
		self.mapHeight = map.getGridHeight()
		self.plotTypes = [PlotTypes.PLOT_OCEAN] * (self.mapWidth*self.mapHeight)
		self.heightMap = [0] * (self.mapWidth*self.mapHeight)
		self.plateMap = [0] * (self.mapWidth*self.mapHeight)
		self.numContinents = landPlates
		self.hotSpotFrequency = hotspotsF
		self.numSeaPlates = seaPlates + 1 # plate 0 is for initialisation
		self.plate = [0] * (self.numContinents + self.numSeaPlates)
		# plateSize is a random number which gives the probability of growing a plate
		self.plateSize = [0] * (self.numContinents + self.numSeaPlates)
		self.altitudeVariation = 2
		self.peakAltitude = 12
		self.hillAltitude = 9
		self.landAltitude = 6
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				i = y*self.mapWidth + x
				self.plotTypes[i] = PlotTypes.PLOT_OCEAN

	def generate(self):
		self.sowSeeds()
		self.fillPlates()
		self.movePlates(true)
		self.erode()
		self.movePlates(false)
		self.blur()
		self.addFaults()
		self.hotspots()
		self.createMap()
		self.finalizeMap()
		return self.plotTypes

	def sowSeeds(self):
		self.mostLands = self.dice.get(2,"mostland hemisphere")
		for i in range(self.numSeaPlates):
			self.plate[i] = self.dice.get(3,"Sea altitude")
		for i in range(self.numContinents):
			self.plate[self.numSeaPlates + i] = self.landAltitude + self.dice.get(3,"Land altitude")
		for i in range(self.numContinents + self.numSeaPlates):
			x, y = self.getCoord(i)
			while self.plateMap[y*self.mapWidth + x] != 0:
				x, y = self.getCoord(i)
			self.plateMap[y*self.mapWidth + x] = i
			self.plateSize[i] = 2 + self.dice.get(6,"Some randomness in plate sizes")

	def getCoord(self,i):
		x = self.dice.get(self.mapWidth,"x seed for plate")
		if (i >= self.numSeaPlates + (self.numContinents/3)):
			y = 2 + self.dice.get(2*self.mapHeight/3,"y seed for plate")
			if (i >= self.numSeaPlates + 1 + (self.numContinents/3)):
				if (self.mostLands == 0):
					y = self.mapHeight - y - 1
			elif (self.mostLands == 1):
				y = self.mapHeight - y - 1
		else:
			y = self.dice.get(self.mapHeight,"y seed for plate")
		return x, y

	def fillPlates(self):
		filled = False
		bufferPlateMap = [0] * (self.mapWidth*self.mapHeight)
		while filled == False:
			filled = True
			for x in range(self.mapWidth):
				for y in range(self.mapHeight):
					i = y*self.mapWidth + x
					bufferPlateMap[i] = self.plateMap[i]
					if (self.plateMap[i] == 0):
						bufferPlateMap[i] = self.neighbour(x,y)
			for x in range(self.mapWidth):
				for y in range(self.mapHeight):
					i = y*self.mapWidth + x
					self.plateMap[i] = bufferPlateMap[i]
					if self.plateMap[i] == 0:
						filled = False
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				i = y*self.mapWidth + x
				self.heightMap[i] = self.plate[self.plateMap[i]] + self.dice.get(self.altitudeVariation,"Random variation of altitude")

	def movePlates(self,dontMoveSeaPlates):
		plates = self.numContinents + self.numSeaPlates
		xMoves = [0] * plates
		yMoves = [0] * plates
		subduction = [0] * plates
		min = 0
		if dontMoveSeaPlates:
			min = self.numSeaPlates
		for i in range(min,plates):
			xMoves[i] = self.dice.get(3,"moves") - 2
			yMoves[i] = self.dice.get(3,"moves") - 2
			subduction[i] = self.dice.get(10,"subduction")
		self.doMovePlates(xMoves,yMoves,subduction)

	def doMovePlates(self,xMoves,yMoves,subduction):
		mapSize = self.mapWidth*self.mapHeight
		#FIXME There must be a clone method somewhere?
		oldHeightMap = [0] * mapSize
		for i in range(mapSize):
			oldHeightMap[i] = self.heightMap[i]
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				currentCoord = y*self.mapWidth + x
				currentPlate = self.plateMap[currentCoord]
				if (xMoves[currentPlate] != 0 or yMoves[currentPlate] != 0):
					movedX = x + xMoves[currentPlate]
					movedY = y + yMoves[currentPlate]
					if (movedX >= 0 and movedX < self.mapWidth):
						if (movedY >= 0 and movedY < self.mapHeight):
							movedCoord = movedY*self.mapWidth + movedX
							targetPlate = self.plateMap[movedCoord]
							if (targetPlate != currentPlate):
								if (subduction[currentPlate] >= 6):
									sum = oldHeightMap[movedCoord] + oldHeightMap[currentCoord] + 2
									if (self.heightMap[movedCoord] < sum ):
										self.heightMap[movedCoord] = sum 
									self.heightMap[currentCoord] = self.heightMap[currentCoord] -1
								else:
									sum = oldHeightMap[movedCoord] + oldHeightMap[currentCoord] -2
									if (self.heightMap[movedCoord] < sum and self.heightMap[movedCoord] >= self.landAltitude):
										self.heightMap[movedCoord] = sum
									if (self.heightMap[currentCoord] < sum and self.heightMap[currentCoord] >= self.landAltitude):
										self.heightMap[currentCoord] = sum

	def addFaults(self):
		"Adds faultlines to break up big flat land masses. Think Rift Valley."
		plates = self.numContinents + self.numSeaPlates
		width = [0] * plates
		height = [0] * plates
		sum = [0] * plates
		lastPlate = 0
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				currentCoord = y*self.mapWidth + x
				lastPlate = self.checkFault(currentCoord,sum,height,lastPlate)
		for y in range(self.mapHeight):
			for x in range(self.mapWidth):
				currentCoord = y*self.mapWidth + x
				lastPlate = self.checkFault(currentCoord,sum,width,lastPlate)
		for i in range(plates):
			if (width[i] != 0): self.verticalFault(i,width[i])
			elif (height[i] != 0): self.horizontalFault(i,height[i])

	def checkFault(self,currentCoord,sum,table,lastPlate):
		plates = self.numContinents + self.numSeaPlates
		faultLimit = 7
		if (self.heightMap[currentCoord] <= self.landAltitude):
			return 0
		if (self.heightMap[currentCoord] > self.hillAltitude):
			return 0
		currentPlate = self.plateMap[currentCoord]
		if (lastPlate != currentPlate):
			if (sum[lastPlate] >= 0):
				sum[lastPlate] = 0
			lastPlate = currentPlate
		elif (sum[lastPlate] >= 0):
			sum[lastPlate] = 1 + sum[lastPlate]
		if (sum[lastPlate] > faultLimit):
			table[lastPlate] = currentCoord
			sum[lastPlate] = -1
		return lastPlate

	def verticalFault(self,plateNumber,coord):
		nextCoord = coord - 3 + self.dice.get(6,"Fault position")
		mapSize = self.mapWidth*self.mapHeight
		while (nextCoord >= 0 and nextCoord < mapSize):
			if (self.plateMap[nextCoord] != plateNumber):
				break
			self.fault(nextCoord)
			nextCoord = nextCoord + self.mapWidth + self.dice.get(3,"Fault tilt") - 1

	def horizontalFault(self,plateNumber,coord):
		nextCoord = coord + (self.dice.get(6,"Fault position") - 3) * self.mapWidth 
		mapSize = self.mapWidth*self.mapHeight
		max = coord + self.mapWidth
		if (max > mapSize):
			max = mapSize
		while (nextCoord >= 0 and nextCoord < max):
			if (self.plateMap[nextCoord] != plateNumber):
				break
			self.fault(nextCoord)
			nextCoord = nextCoord + 1 + (self.dice.get(3,"Fault tilt") - 1)*self.mapWidth

	def fault(self,coord):
		dieRoll = self.dice.get(20,"Fault line effect")
		if (dieRoll > 11):
			self.heightMap[coord] = self.hillAltitude + 1
		elif (dieRoll > 9):
			self.heightMap[coord] = 0

	def erode(self):
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				i = y*self.mapWidth + x
				if self.heightMap[i] > self.peakAltitude:
					self.heightMap[i] -= 2
				if self.heightMap[i] > self.hillAltitude:
					self.heightMap[i] -= 1
				hasSeaNeighbour = False
				hasHillNeighbour = False
				leftX = x-1
				if (leftX < 0):
					leftX = self.mapWidth - 1
				left = self.heightMap[leftX + y*self.mapWidth] 
				if (left < self.landAltitude):
					hasSeaNeighbour = True
				elif (left > self.hillAltitude):
					hasHillNeighbour = True
				rightX = x+1
				if (rightX >= self.mapWidth):
					rightX = 0
				right = self.heightMap[rightX + y*self.mapWidth] 
				if (right < self.landAltitude):
					hasSeaNeighbour = True
				elif (right > self.hillAltitude):
					hasHillNeighbour = True
				if (y>0):
					top = self.heightMap[x + (y-1)*self.mapWidth] 
					if (top < self.landAltitude):
						hasSeaNeighbour = True
					elif (top > self.hillAltitude):
						hasHillNeighbour = True
				if (y<self.mapHeight - 2):
					bottom = self.heightMap[x + (y+1)*self.mapWidth] 
					if (bottom < self.landAltitude):
						hasSeaNeighbour = True
					elif (bottom > self.hillAltitude):
						hasHillNeighbour = True
				if (hasSeaNeighbour):
					self.heightMap[i] = self.heightMap[i] - 1
				if (hasHillNeighbour):
					self.heightMap[i] = self.heightMap[i] - 1


	def min( height, left, right, top, bottom ):
		minHeight = height
		if ( minHeight > left ):
			minHeight = left
		if ( minHeight > right ):
			minHeight = right
		if ( minHeight > top ):
			minHeight = top
		if ( minHeight > bottom ):
			minHeight = bottom
		return minHeight

	def blur(self):
		#FIXME There must be a clone method somewhere?
		mapSize = self.mapWidth*self.mapHeight
		oldHeightMap = [0] * (mapSize)
		for i in range(mapSize):
			oldHeightMap[i] = self.heightMap[i]
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				i = y*self.mapWidth + x
				height = self.heightMap[i]
				leftX = x-1
				if (leftX < 0):
					leftX = self.mapWidth - 1
				left = oldHeightMap[leftX + y*self.mapWidth]
				rightX = x+1
				if (rightX >= self.mapWidth):
					rightX = 0
				right = oldHeightMap[rightX + y*self.mapWidth]
				top = height
				if (y>0):
					top = oldHeightMap[x + (y-1)*self.mapWidth]
				bottom = height
				if (y<self.mapHeight - 2):
					bottom = oldHeightMap[x + (y+1)*self.mapWidth]
				self.heightMap[i] = (height * 4 + left + right + top + bottom) / 8
				minHeight = min(height,left,right,top,bottom)
				if (minHeight >= self.peakAltitude):
					oldHeightMap[leftX + y*self.mapWidth] = self.hillAltitude + 1 
					self.heightMap[leftX + y*self.mapWidth] = self.hillAltitude  + 1
					oldHeightMap[rightX + y*self.mapWidth] = self.hillAltitude  + 1
					self.heightMap[rightX + y*self.mapWidth] = self.hillAltitude  + 1
					if (y>0):
						oldHeightMap[x + (y-1)*self.mapWidth] = self.hillAltitude  + 1
						self.heightMap[x + (y-1)*self.mapWidth] = self.hillAltitude  + 1
					if (y<self.mapHeight - 2):
						oldHeightMap[x + (y+1)*self.mapWidth] = self.hillAltitude + 1
						self.heightMap[x + (y+1)*self.mapWidth] = self.hillAltitude + 1

	def hotspots(self):
		mapSize = self.mapWidth * self.mapHeight
		hotSpotsNumber = mapSize/self.hotSpotFrequency
		for hotspot in range(hotSpotsNumber):
			i = self.dice.get(mapSize,"Hotspot location")
			self.heightMap[i] = self.heightMap[i] + self.dice.get(self.peakAltitude,"Hotspot altitude")

	def createMap(self):
		for y in range(self.mapHeight):
			for x in range(self.mapWidth):
				i = y*self.mapWidth + x
				height = self.heightMap[i]
				if (height > self.peakAltitude):
					if (self.dice.get(7,"Random pass") == 6):
						self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_PEAK
				elif (height > self.hillAltitude):
					if (self.dice.get(20,"Random peak") == 19):
						self.plotTypes[i] = PlotTypes.PLOT_PEAK
					else:
						self.plotTypes[i] = PlotTypes.PLOT_HILLS
				elif (height > self.landAltitude):
					self.plotTypes[i] = PlotTypes.PLOT_LAND
				else:
					self.plotTypes[i] = PlotTypes.PLOT_OCEAN

	def finalizeMap(self):
		return

	def neighbour(self,x,y):
		roll = self.dice.get(10,"Some randomness in plate shapes")
		leftX = x-1
		if (leftX < 0):
			leftX = self.mapWidth - 1
		left = self.plateMap[leftX + y*self.mapWidth]
		if (left != 0):
			if (roll <= self.plateSize[left]):
				return left
		rightX = x+1
		if (rightX >= self.mapWidth):
			rightX = 0
		right = self.plateMap[rightX + y*self.mapWidth]
		if (right != 0):
			if (roll <= self.plateSize[right]):
				return right
		if (y>0):
			top = self.plateMap[x + (y-1)*self.mapWidth]
			if (top != 0):
				if (roll <= self.plateSize[top]):
					return top
		if (y<self.mapHeight - 2):
			bottom = self.plateMap[x + (y+1)*self.mapWidth]
			if (bottom != 0):
				if (roll <= self.plateSize[bottom]):
					return bottom
		return 0

class voronoiMediterraneanMap(voronoiMap):
	def __init__(self,numPlayers):
		voronoiMap.__init__(self,numPlayers*5/2, numPlayers,150)
		self.peakAltitude = 13

	def movePlates(self,dontMoveSeaPlates):
		if dontMoveSeaPlates:
			return
		voronoiMap.movePlates(self,true)

	def getCoord(self,i):
		mapWidthFraction = self.mapWidth/self.numSeaPlates
			# Sea plates
		if (i < self.numSeaPlates): 
			x = mapWidthFraction*i + self.dice.get(mapWidthFraction,"x seed for sea plate")
			y = self.mapHeight/3 + self.dice.get(self.mapHeight/3,"y seed for plate")
		else:
			# One land plate to the east to link north and south
			if (i == self.numSeaPlates + self.numContinents - 1):
				x = self.dice.get(self.mapWidth - 2,"x seed for link land plate")
				y = self.mapHeight/3 + self.dice.get(self.mapHeight/3,"y seed for land plate")
			# Other land plates half north half south
			elif (i < self.numSeaPlates * 2):
				x = mapWidthFraction * (i - self.numSeaPlates) + self.dice.get(mapWidthFraction,"x seed for land plate")
				y = self.getLandY(0)
			elif (i >= self.numSeaPlates * 3):
				x = mapWidthFraction * (i - 2*self.numSeaPlates) + self.dice.get(mapWidthFraction,"x seed for land plate")
				y = self.getLandY(1)
			else:
				x = self.dice.get(self.mapWidth,"x seed for land plate")
				y = self.getLandY(i)
		return x, y

	def getLandY(self,i):
		y = 1 + self.dice.get(self.mapHeight/4,"y seed for land plate")
		if (i == 2*(i/2)):
			y = y + self.mapHeight*3/4 -1
		return y

	def hotspots(self):
		mapSize = self.mapWidth * self.mapHeight
		hotSpotsNumber = mapSize/self.hotSpotFrequency
		minX = 2
		maxX = self.mapWidth*9/10
		minY = self.mapHeight/10
		yRange = self.mapHeight*8/10
		for hotspot in range(hotSpotsNumber):
			x = minX + self.dice.get(maxX,"Hotspot X")
			y = minY + self.dice.get(yRange,"Hotspot Y")
			i = y*self.mapWidth + x
			while (self.plotTypes[i] != PlotTypes.PLOT_OCEAN):
				x = minX + self.dice.get(maxX,"Hotspot X")
				y = minY + self.dice.get(yRange,"Hotspot Y")
				i = y*self.mapWidth + x
			self.heightMap[i] = self.heightMap[i] + self.dice.get(self.peakAltitude,"Hotspot altitude")
			self.spreadHotSpot(i)

	def spreadHotSpot(self,i):
		self.spreadIsland(i+1)
		self.spreadIsland(i-1)
		self.spreadIsland(i+self.mapWidth)
		self.spreadIsland(i-self.mapWidth)

	def spreadIsland(self,i):
		self.heightMap[i] = self.heightMap[i] + self.dice.get(self.peakAltitude,"Hotspot altitude")
		if (self.heightMap[i] > self.landAltitude):
			self.spreadBigIsland(i+1)
			self.spreadBigIsland(i-1)
			self.spreadBigIsland(i+self.mapWidth)
			self.spreadBigIsland(i-self.mapWidth)

	def spreadBigIsland(self,i):
		if (self.heightMap[i] <= self.landAltitude):
			self.heightMap[i] = self.dice.get(self.peakAltitude,"Island altitude")

	def finalizeMap(self):
		# Make sure that the north and south borders are made of land.
		for y in range(self.mapHeight):
			for x in range(self.mapWidth):
				if self.checkY(y):
					i = y*self.mapWidth + x
					if (self.plotTypes[i] == PlotTypes.PLOT_OCEAN):
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		# Make sure that there's a way north/south by foot or galley
		minEastWidth = self.mapWidth * 9 /10
		margin = self.mapWidth/10
		for y in range(self.mapHeight-1):
			for x in range(minEastWidth,self.mapWidth):
				if (x + 3 + self.dice.get(margin,"Border")) > self.mapWidth:
					i = y*self.mapWidth + x
					if (self.plotTypes[i] == PlotTypes.PLOT_OCEAN):
						self.plotTypes[i] = PlotTypes.PLOT_LAND

	def checkY(self,y):
		if (y > 9*self.mapHeight/10):
			y = self.mapHeight - y
		if (y < self.mapHeight/10):
			if (2 + self.dice.get(self.mapHeight/10,"Border")) > y:
				return True
		return False

class voronoiTerraMap(voronoiMap):
	def __init__(self):
		voronoiMap.__init__(self,12,8,800)
		self.altitudeVariation = 3

	def sowSeeds(self):
		for i in range(0,8):
			self.plate[i] = 2
		for i in range(8,20):
			self.plate[i] = self.landAltitude + 3
		#Pacific Ocean
		for i in range(self.mapHeight):
			self.plateMap[i*self.mapWidth] = 1
		for i in range(self.mapWidth/10):
			self.plateMap[self.mapHeight*self.mapWidth/2 -self.mapWidth/20 + i] = 1
		x = self.mapWidth/10
		y = self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 1
		self.plateSize[1] = 7
		#North Atlantic
		x = self.mapWidth/3
		ymin = 2*self.mapHeight/3
		ymax = 7*self.mapHeight/8
		for y in range(ymin,ymax):
			self.plateMap[x + y*self.mapWidth] = 2
		x = 3*self.mapWidth/10
		y = 3*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 2
		self.plateSize[2] = 7
		#South Atlantic
		x = self.mapWidth/3
		yMin = self.mapHeight/5
		yMax = self.mapHeight/3
		for y in range(yMin,yMax):
			self.plateMap[x + y*self.mapWidth] = 3
		for x in range(self.mapWidth/4,self.mapWidth/2):
			self.plateMap[self.mapWidth/3 + self.mapHeight/5*self.mapWidth] = 3
		x = self.mapWidth/3
		y= 5*self.mapHeight/12
		self.plateMap[x + y*self.mapWidth] = 3
		x = self.mapWidth/4 +1
		y = self.mapHeight/4
		self.plateMap[x + y*self.mapWidth] = 3
		self.plateSize[3] = 7
		#Arctic Ocean
		for i in range(self.mapWidth):
			self.plateMap[self.mapWidth*(self.mapHeight-2) + i] = 4
		self.plateSize[4] = 3
		#Mediterranean
		x = 4*self.mapWidth/9
		y = 3*self.mapHeight/4
		self.plateMap[x + y*self.mapWidth] = 5
		self.plateSize[5] = 4
		#Indian Ocean
		x = 3*self.mapWidth/4
		y = self.mapHeight/3
		self.plateMap[x + y*self.mapWidth] = 6
		x = 3*self.mapWidth/5
		y = self.mapHeight/3
		self.plateMap[x + y*self.mapWidth] = 6
		x = 2*self.mapWidth/3
		y = 9*self.mapHeight/20
		self.plateMap[x + y*self.mapWidth] = 6
		self.plateSize[6] = 7
		#Antarctic Ocean
		y = self.mapHeight/8
		for i in range(self.mapWidth):
			self.plateMap[i+y*self.mapWidth] = 7
		self.plateSize[7] = 4
		#North America
		x = self.mapWidth/5
		yMin = 4*self.mapHeight/5
		yMax = 6*self.mapHeight/7
		for y in range(yMin,yMax):
			self.plateMap[x + y*self.mapWidth] = 8
		self.plateMap[self.mapWidth/20 + yMax*self.mapWidth] = 8
		self.plateSize[8] = 8
		#South America
		x = self.mapWidth/5
		y = self.mapHeight/4
		self.plateMap[x + y*self.mapWidth] = 9
		y = self.mapHeight/3
		self.plateMap[x + y*self.mapWidth] = 9
		x = self.mapWidth/4 +1
		y = 2*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 9
		self.plateSize[9] = 5
		#Europe
		x = self.mapWidth/2
		y = 6*self.mapHeight/7
		self.plateMap[x + y*self.mapWidth] = 10
		x = 3*self.mapWidth/7
		y = 4*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 10
		self.plateSize[10] = 6
		#Asia
		x = 3*self.mapWidth/4
		y = 7*self.mapHeight/10
		self.plateMap[x + y*self.mapWidth] = 11
		x = 4*self.mapWidth/5
		y = 4*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 11
		x = 2*self.mapWidth/3
		y = 4*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 11
		self.plateSize[11] = 9
		#Africa
		x = 7*self.mapWidth/20
		y = 2*self.mapHeight/3 -1
		for i in range(self.mapWidth/12):
			self.plateMap[x  + i + y*self.mapWidth] = 12
		x = self.mapWidth/2
		y = 2*self.mapHeight/5
		self.plateMap[x + y*self.mapWidth] = 12
		self.plateSize[12] = 6
		#India
		x = 3*self.mapWidth/4
		y = 5*self.mapHeight/9
		self.plateMap[x + y*self.mapWidth] = 13
		self.plateSize[13] = 3
		#Oceania
		x = 4*self.mapWidth/5
		y = self.mapHeight/4 +1
		self.plateMap[x + y*self.mapWidth] = 14
		self.plateSize[14] = 4
		#Middle East
		x = 3*self.mapWidth/5
		y = 4*self.mapHeight/7
		self.plateMap[x + y*self.mapWidth] = 15
		self.plateSize[15] = 2
		self.plate[15] = self.landAltitude -1
		#South East Asia
		x = 17*self.mapWidth/20
		y = 4*self.mapHeight/7
		self.plateMap[x + y*self.mapWidth] = 16
		self.plateSize[16] = 3
		self.plate[16] = self.landAltitude
		#Greenland
		x = 3*self.mapWidth/10
		y = 7*self.mapHeight/8
		self.plateMap[x + y*self.mapWidth] = 17
		self.plateSize[17] = 4
		#Scandinavia
		x = 3*self.mapWidth/7 -1
		y = 7*self.mapHeight/8
		self.plateMap[x + y*self.mapWidth] = 18
		self.plateSize[18] = 3
		self.plate[18] = self.landAltitude
		#Bering
		x = 9*self.mapWidth/10
		y = 5*self.mapHeight/6
		self.plateMap[x + y*self.mapWidth] = 19
		self.plateSize[19] = 5

	def finalizeMap(self):
		#Force Gibraltar straits
		x = 4*self.mapWidth/9
		y = 3*self.mapHeight/4
		for i in range(self.mapWidth/5):
			self.plotTypes[x + y*self.mapWidth - i] = PlotTypes.PLOT_OCEAN
		#Force cut between India and Oceania
		x = 7*self.mapWidth/10
		y = 4*self.mapHeight/9 -1
		for i in range(self.mapWidth/5):
			self.plotTypes[x + y*self.mapWidth + i] = PlotTypes.PLOT_OCEAN
		#Force Greenland to be an island
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				if (self.plateMap[x + y*self.mapWidth] == 17):
					if (self.plateMap[x-1 + y*self.mapWidth] != 17):
						self.plotTypes[x + y*self.mapWidth] = PlotTypes.PLOT_OCEAN
						self.plotTypes[x + (y-1)*self.mapWidth] = PlotTypes.PLOT_OCEAN
		#Force Central America
		baseX = self.mapWidth/6
		x = baseX
		width = 2
		if (width < 4 and self.dice.get(10,"Width variation") > 8):
			width += 1
		if (width > 1 and self.dice.get(10,"Width variation") > 8):
			width -= 1
		for y in range(self.mapHeight/5,self.mapHeight*3/4):
			x = x + self.dice.get(3,"Not too straight") - 1
			if ( x - baseX > 4):
				x = baseX + 4
			if ( x - baseX < -4):
				x = baseX - 4
			if (self.plotTypes[x + y*self.mapWidth ] == PlotTypes.PLOT_OCEAN):
				for plot in range( width ):
					self.plotTypes[x + y*self.mapWidth + plot ] = PlotTypes.PLOT_LAND
					if (self.dice.get(10,"Some hills") > 5):
						self.plotTypes[x + y*self.mapWidth + plot ] = PlotTypes.PLOT_HILLS

	def movePlates(self,dontMoveSeaPlates):
		plates = self.numContinents + self.numSeaPlates
		if dontMoveSeaPlates:
			xMoves =     [0, 1, 0, 0, 0, 0, 0, 0,  -1,-1, 0,-1, 0, 0,-1, 0,-1, 1, 1, 0, 0]
			yMoves =     [0, 0, 0, 0,-1, 1, 1, 0,   0, 1,-1,-1, 0, 1, 0, 0, 0, 1, 0, 0, 0]
			subduction = [0, 9, 9, 0, 9, 0, 0, 0,   9, 9, 9, 0, 0, 9, 9, 9, 0, 9, 9, 0, 0]
		else:
			xMoves =     [0, 1, 0, 0, 0, 1,-1, 0,  -1,-1, 0, 1, 1,-1, 1, 0, 0,-1,-1, 1,-1]
			yMoves =     [0, 0, 0, 0, 1,-1, 0, 0,  -1, 1,-1,-1, 1,-1,-1,-1,-1,-1, 0, 1, 1]
			subduction = [0, 9, 9, 0, 9, 9, 9, 0,   9, 9, 9, 9, 0, 9, 9, 9, 0, 0, 9, 0, 0]
		self.doMovePlates(xMoves,yMoves,subduction)

class voronoiPangaeaMap(voronoiMap):
	def __init__(self,numPlayers):
		voronoiMap.__init__(self,numPlayers,1,1600)
		self.peakAltitude = 11
		self.hillAltitude = 7
		self.landAltitude = 3
		self.altitudeVariation = 3

	def sowSeeds(self):
		self.yTilt = self.dice.get(4,"YTilt")
		self.plate[0] = 0
		self.plate[1] = 0
		for x in range(self.mapWidth):
			self.plateMap[x] = 1
			self.plateMap[self.mapWidth + x] = 1
			self.plateMap[(self.mapHeight - 2)*self.mapWidth + x] = 1
			self.plateMap[(self.mapHeight - 1)*self.mapWidth + x] = 1
		for y in range(self.mapHeight):
			self.plateMap[y*self.mapWidth] = 1
			self.plateMap[y*self.mapWidth + 1] = 1
			self.plateMap[y*self.mapWidth + self.mapWidth - 2] = 1
			self.plateMap[y*self.mapWidth + self.mapWidth - 1] = 1
		for i in range(self.numContinents):
			self.plate[i + self.numSeaPlates] = 4 + self.dice.get(3,"Land altitude")
			x, y = self.getCoord(i)
			while self.plateMap[y*self.mapWidth + x] != 0:
				x, y = self.getCoord(i)
			self.plateMap[y*self.mapWidth + x] = i + 2

	def getCoord(self,i):
		step = self.mapWidth/(2*self.numContinents)
		x = self.mapWidth/4 + i*step + self.dice.get(step,"x seed for plate")
		quarterHeight = self.mapHeight/4 
		eigthHeight = self.mapHeight/8 
		y = quarterHeight + self.dice.get(self.mapHeight/2,"y seed for plate")
		if (self.yTilt == 0):
			y += i*(self.mapHeight/(self.numContinents*4)) - eigthHeight
		elif (self.yTilt == 1):
			y += eigthHeight - i*quarterHeight/self.numContinents
		elif (self.yTilt == 2):
			if (i%2 == 0):
				y += eigthHeight
			else:
				y -= eigthHeight
		# else: Let it be the way it was generated
		return x, y

class MnSMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self):
		global yShiftRoll1
		global yShiftRoll2
		if cmo[0] != 4:
			iContinentsGrainWest = 1 + cmo[0]
			iContinentsGrainEast = 1 + cmo[0]
		else:
			iContinentsGrainWest = 1 + getRandNum(4, "FoR : West Continent Grain - Medium and Small PYTHON")
			iContinentsGrainEast = 1 + getRandNum(4, "FoR : East Continent Grain - Medium and Small PYTHON")
		iIslandsGrain = 4 + cmo[1]
		userInputOverlap = cmo[2]
		numTinies = 1 + getRandNum(4, "FoR : Tiny Islands - Medium and Small PYTHON")
		if numTinies:
			for tiny_loop in range(numTinies):
				tinyWestLon = 0.01 * getRandNum(85, "FoR : Tiny Longitude - Medium and Small PYTHON")
				tinyWestX = int(self.iW * tinyWestLon)
				tinySouthLat = 0.01 * getRandNum(85, "FoR : Tiny Latitude - Medium and Small PYTHON")
				tinySouthY = int(self.iH * tinyWestLon)
				tinyWidth = int(self.iW * 0.15)
				tinyHeight = int(self.iH * 0.15)

				self.generatePlotsInRegion(80,
				                           tinyWidth, tinyHeight,
				                           tinyWestX, tinySouthY,
				                           4, 3,
				                           0, self.iTerrainFlags,
				                           6, 5,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		iWestX = int(self.iW / 20)
		iEastX = int(self.iW * 0.45) - 1
		iWidth = iEastX - iWestX + 1
		if userInputOverlap:
			yExp = 5
			iWater = 80
		else:
			iWater = 74
			yExp = 6
			if yShiftRoll1:
				southShift = int(0.4 * self.iH)
				northShift = 0
			else:
				southShift = 0
				northShift = int(0.4 * self.iH)

			iSouthY += southShift
			iNorthY -= northShift
			iHeight = iNorthY - iSouthY + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iContinentsGrainWest, 4,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, yExp,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		iWestX = int(self.iW * 0.12)
		iEastX = int(self.iW * 0.38) - 1
		iWidth = iEastX - iWestX + 1
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		if userInputOverlap:
			yExp = 5
			iWater = 80
		else:
			iWater = 74
			yExp = 6
			if yShiftRoll1:
				southShift = 0
				northShift = int(0.4 * self.iH)
			else:
				southShift = int(0.4 * self.iH)
				northShift = 0

			iSouthY += southShift
			iNorthY -= northShift
			iHeight = iNorthY - iSouthY + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iIslandsGrain, 5,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, yExp,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		iWestX = int(self.iW * 0.55)
		iEastX = int(self.iW * 0.95) - 1
		iWidth = iEastX - iWestX + 1
		if userInputOverlap:
			yExp = 5
			iWater = 80
		else:
			iWater = 74
			yExp = 6
			if yShiftRoll2:
				southShift = int(0.4 * self.iH)
				northShift = 0
			else:
				southShift = 0
				northShift = int(0.4 * self.iH)
			iSouthY += southShift
			iNorthY -= northShift
			iHeight = iNorthY - iSouthY + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iContinentsGrainWest, 4,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, yExp,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		iWestX = int(self.iW * 0.62)
		iEastX = int(self.iW * 0.88) - 1
		iWidth = iEastX - iWestX + 1
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		if userInputOverlap:
			yExp = 5
			iWater = 80
		else:
			iWater = 74
			yExp = 6
			if yShiftRoll2:
				southShift = 0
				northShift = int(0.4 * self.iH)
			else:
				southShift = int(0.4 * self.iH)
				northShift = 0
			iSouthY += southShift
			iNorthY -= northShift
			iHeight = iNorthY - iSouthY + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iIslandsGrain, 5,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, yExp,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		return self.wholeworldPlotTypes

class BnSHemMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generateIslandRegion(self, minTinies, extraTinies, iWestX, iSouthY, iWidth, iHeight, iGrain):
		numTinies = minTinies + getRandNum(extraTinies, "FoR : Tiny Islands - Custom Continents PYTHON")
		if numTinies:
			for tiny_loop in range(numTinies):
				tinyWidth = int(self.iW * 0.15)
				tinyHeight = int(self.iH * 0.15)
				tinyWestX = iWestX + getRandNum(iWidth - tinyWidth, "FoR : Tiny Longitude - Custom Continents PYTHON")
				tinySouthY = iSouthY + getRandNum(iHeight - tinyHeight, "FoR : Tiny Latitude - Custom Continents PYTHON")
				self.generatePlotsInRegion(80,
										   tinyWidth, tinyHeight,
										   tinyWestX, tinySouthY,
										   iGrain, 3,
										   0, self.iTerrainFlags,
										   6, 5,
										   True, 3,
										   -1, False,
										   False
										   )
		return 0

	def generateContinentRegion(self, iWater, iWidth, iHeight, iWestX, iSouthY, iGrain, xExp):
		self.generatePlotsInRegion(iWater,
								   iWidth, iHeight,
								   iWestX, iSouthY,
								   iGrain, 4,
								   self.iRoundFlags, self.iTerrainFlags,
								   xExp, 6,
								   True, 15,
								   -1, False,
								   False
								   )
		return 0

	def generatePlotsByRegion(self):
		global xShiftRoll
		global yShiftRoll
		global ySplitRoll
		global yPortionRoll
		if (cmo[0] == 3):
			iContinentsGrain = 1
			iSecondaryContinentsGrain = 3
			iTertiaryContinentsGrain = 2
			iPrimaryWater = 74
			iSecondaryWater = 79
			iTertiaryWater = 76
		else:
			iContinentsGrain = 1 + cmo[0]
			iSecondaryContinentsGrain = 1 + cmo[0]
			iTertiaryContinentsGrain = 1 + cmo[0]
			iPrimaryWater = 74
			iSecondaryWater = 74
			iTertiaryWater = 74
		iPrimaryWater += self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		iSecondaryWater += self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		iTertiaryWater += self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		splitYBigger = 0.5
		splitYSmaller = 0.5
		splitYBuffer = 0.1
		iIslandsGrain = 3 + cmo[1]
		tinyIslandOverlap = 0
		regions = 2 + cmo[2]
		if (regions == 2):
			vSplitPrimary = 0
			vSplitSecondary = 0
			vSplitTertiary = 0
			tripleSplit = 0
		elif (regions == 3):
			vSplitPrimary = 0
			vSplitSecondary = 0
			vSplitTertiary = 0
			tripleSplit = 1
		elif (regions == 4):
			vSplitPrimary = 1
			vSplitSecondary = 1
			vSplitTertiary = 0
			tripleSplit = 0
		elif (regions == 5):
			vSplitPrimary = 0
			vSplitSecondary = 1
			vSplitTertiary = 1
			tripleSplit = 1
		elif (regions == 6):
			vSplitPrimary = 1
			vSplitSecondary = 1
			vSplitTertiary = 1
			tripleSplit = 1
		else:
			vSplitPrimary = 0
			vSplitSecondary = 0
			vSplitTertiary = 0
			tripleSplit = 0
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		iWestX = 0
		iEastX = self.iW - 1
		iWidth = iEastX - iWestX + 1
		if tinyIslandOverlap:
			self.generateIslandRegion(4, 6, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		xExp = 6
		if tripleSplit:
			if xShiftRoll:
				westShift = int(0.33 * self.iW)
				eastShift = int(0.33 * self.iW)
			else:
				westShift = 0
				eastShift = int(0.66 * self.iW)
		else:
			if xShiftRoll:
				westShift = int(0.5 * self.iW)
				eastShift = 0
			else:
				westShift = 0
				eastShift = int(0.5 * self.iW)
		iWestX = westShift
		iEastX = self.iW - eastShift
		iWidth = iEastX - iWestX
		if vSplitPrimary:
			if yPortionRoll:
				if yShiftRoll:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYBigger * self.iH)
				else:
					northShift = int(splitYSmaller * self.iH)
					southShift = int(splitYBuffer * self.iH)
			else:
				if yShiftRoll:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYSmaller * self.iH)
				else:
					northShift = int(splitYBigger * self.iH)
					southShift = int(splitYBuffer * self.iH)
			iSouthY = southShift
			iNorthY = self.iH - northShift
			iHeight = iNorthY - iSouthY
			self.generateContinentRegion(iPrimaryWater, iWidth, iHeight, iWestX, iSouthY, iContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(1, 2, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
			if yPortionRoll:
				if yShiftRoll:
					northShift = int(splitYSmaller * self.iH)
					southShift = int(splitYBuffer * self.iH)
				else:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYBigger * self.iH)
			else:
				if yShiftRoll:
					northShift = int(splitYBigger * self.iH)
					southShift = int(splitYBuffer * self.iH)
				else:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYSmaller * self.iH)
			iSouthY = southShift
			iNorthY = self.iH - northShift
			iHeight = iNorthY - iSouthY
			self.generateContinentRegion(iPrimaryWater, iWidth, iHeight, iWestX, iSouthY, iContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(1, 2, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		else:
			iSouthY = 0
			iNorthY = self.iH - 1
			iHeight = iNorthY - iSouthY + 1
			self.generateContinentRegion(iPrimaryWater, iWidth, iHeight, iWestX, iSouthY, iContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(2, 3, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		xExp = 6
		if tripleSplit:
			if xShiftRoll:
				westShift = 0
				eastShift = int(0.66 * self.iW)
			else:
				westShift = int(0.33 * self.iW)
				eastShift = int(0.33 * self.iW)
		else:
			if xShiftRoll:
				westShift = 0
				eastShift = int(0.5 * self.iW)
			else:
				westShift = int(0.5 * self.iW)
				eastShift = 0
		iWestX = westShift
		iEastX = self.iW - eastShift
		iWidth = iEastX - iWestX
		if vSplitSecondary:
			if yPortionRoll:
				if yShiftRoll:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYBigger * self.iH)
				else:
					northShift = int(splitYSmaller * self.iH)
					southShift = int(splitYBuffer * self.iH)
			else:
				if yShiftRoll:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYSmaller * self.iH)
				else:
					northShift = int(splitYBigger * self.iH)
					southShift = int(splitYBuffer * self.iH)
			iSouthY = southShift
			iNorthY = self.iH - northShift
			iHeight = iNorthY - iSouthY
			self.generateContinentRegion(iSecondaryWater, iWidth, iHeight, iWestX, iSouthY, iSecondaryContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(2, 3, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
			if yPortionRoll:
				if yShiftRoll:
					northShift = int(splitYSmaller * self.iH)
					southShift = int(splitYBuffer * self.iH)
				else:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYBigger * self.iH)
			else:
				if yShiftRoll:
					northShift = int(splitYBigger * self.iH)
					southShift = int(splitYBuffer * self.iH)
				else:
					northShift = int(splitYBuffer * self.iH)
					southShift = int(splitYSmaller * self.iH)
			iSouthY = southShift
			iNorthY = self.iH - northShift
			iHeight = iNorthY - iSouthY
			self.generateContinentRegion(iSecondaryWater, iWidth, iHeight, iWestX, iSouthY, iSecondaryContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(2, 3, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		else:
			iSouthY = 0
			iNorthY = self.iH - 1
			iHeight = iNorthY - iSouthY + 1
			self.generateContinentRegion(iSecondaryWater, iWidth, iHeight, iWestX, iSouthY, iSecondaryContinentsGrain, xExp)
			if (tinyIslandOverlap == 0):
				self.generateIslandRegion(3, 4, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		if tripleSplit:
			xExp = 6
			westShift = int(0.66 * self.iW)
			eastShift = 0
			iWestX = westShift
			iEastX = self.iW - eastShift
			iWidth = iEastX - iWestX
			if vSplitTertiary:
				if yPortionRoll:
					if yShiftRoll:
						northShift = int(splitYBuffer * self.iH)
						southShift = int(splitYBigger * self.iH)
					else:
						northShift = int(splitYSmaller * self.iH)
						southShift = int(splitYBuffer * self.iH)
				else:
					if yShiftRoll:
						northShift = int(splitYBuffer * self.iH)
						southShift = int(splitYSmaller * self.iH)
					else:
						northShift = int(splitYBigger * self.iH)
						southShift = int(splitYBuffer * self.iH)
				iSouthY = southShift
				iNorthY = self.iH - northShift
				iHeight = iNorthY - iSouthY
				self.generateContinentRegion(iTertiaryWater, iWidth, iHeight, iWestX, iSouthY, iTertiaryContinentsGrain, xExp)
				if (tinyIslandOverlap == 0):
					self.generateIslandRegion(2, 3, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
				if yPortionRoll:
					if yShiftRoll:
						northShift = int(splitYSmaller * self.iH)
						southShift = int(splitYBuffer * self.iH)
					else:
						northShift = int(splitYBuffer * self.iH)
						southShift = int(splitYBigger * self.iH)
				else:
					if yShiftRoll:
						northShift = int(splitYBigger * self.iH)
						southShift = int(splitYBuffer * self.iH)
					else:
						northShift = int(splitYBuffer * self.iH)
						southShift = int(splitYSmaller * self.iH)
				iSouthY = southShift
				iNorthY = self.iH - northShift
				iHeight = iNorthY - iSouthY
				self.generateContinentRegion(iTertiaryWater, iWidth, iHeight, iWestX, iSouthY, iTertiaryContinentsGrain, xExp)
				if (tinyIslandOverlap == 0):
					self.generateIslandRegion(2, 3, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
			else:
				iSouthY = 0
				iNorthY = self.iH - 1
				iHeight = iNorthY - iSouthY + 1
				self.generateContinentRegion(iTertiaryWater, iWidth, iHeight, iWestX, iSouthY, iTertiaryContinentsGrain, xExp)
				if (tinyIslandOverlap == 0):
					self.generateIslandRegion(3, 4, iWestX, iSouthY, iWidth, iHeight, iIslandsGrain)
		return self.wholeworldPlotTypes

class BnSMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self):
		global xShiftRoll
		iContinentsGrain = 1 + cmo[0]
		iIslandsGrain = 4 + cmo[1]
		userInputOverlap = cmo[2]
		iWater = 74
		numTinies = 1 + getRandNum(4, "FoR : Tiny Islands - Custom Continents PYTHON")
		if numTinies:
			for tiny_loop in range(numTinies):
				tinyWestLon = 0.01 * getRandNum(85, "FoR : Tiny Longitude - Custom Continents PYTHON")
				tinyWestX = int(self.iW * tinyWestLon)
				tinySouthLat = 0.01 * getRandNum(85, "FoR : Tiny Latitude - Custom Continents PYTHON")
				tinySouthY = int(self.iH * tinyWestLon)
				tinyWidth = int(self.iW * 0.15)
				tinyHeight = int(self.iH * 0.15)
				self.generatePlotsInRegion(80,
				                           tinyWidth, tinyHeight,
				                           tinyWestX, tinySouthY,
				                           4, 3,
				                           0, self.iTerrainFlags,
				                           6, 5,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		iSouthY = 0
		iNorthY = self.iH - 1
		iHeight = iNorthY - iSouthY + 1
		iWestX = 0
		iEastX = self.iW - 1
		iWidth = iEastX - iWestX + 1
		if userInputOverlap:
			xExp = 7
			iWater = 82
		else:
			xExp = 6
			if xShiftRoll:
				westShift = int(0.4 * self.iW)
				eastShift = 0
			else:
				westShift = 0
				eastShift = int(0.4 * self.iW)
			iWestX += westShift
			iEastX -= eastShift
			iWidth = iEastX - iWestX + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iContinentsGrain, 4,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           xExp, 6,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		iWestX = 0
		iEastX = self.iW - 1
		iWidth = iEastX - iWestX + 1
		if userInputOverlap:
			xExp = 7
			iWater = 82
		else:
			xExp = 6
			if xShiftRoll:
				westShift = 0
				eastShift = int(0.4 * self.iW)
			else:
				westShift = int(0.4 * self.iW)
				eastShift = 0
			iWestX += westShift
			iEastX -= eastShift
			iWidth = iEastX - iWestX + 1
		self.generatePlotsInRegion(iWater,
		                           iWidth, iHeight,
		                           iWestX, iSouthY,
		                           iIslandsGrain, 5,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           xExp, 6,
		                           True, 15,
		                           -1, False,
		                           False
		                           )
		return self.wholeworldPlotTypes

def generateChessPlotTypes():
	global chessLakes
	global userInputBorder
	try :
                userInputBorder = getRandSel(selGen["maps"]["chess"]["border"])
                if selGen["terrain"]["hill"]["hillpercent"] == "standard" : hillPer = 0.17
                else : hillPer = getRandSel(selGen["terrain"]["hill"]["hillpercent"], False) / 100.0
                waterPer = getRandSel(selGen["maps"]["chess"]["waterper"], False)
                plotTypes = [PlotTypes.PLOT_LAND] * (iW*iH)
                terrainFrac = CyFractal()
                hills = 60
                grain = 7
                area = iW*iH/16
                if area > 500 :
                        area=iW*iH/16
                        if area<750:
                                grain+=1
                        elif area<1050:
                                grain+=2
                        else :
                                grain+=3
                terrainFrac.fracInit(iW, iH, grain, dice, 0, -1, -1)
                iHillsThreshold = terrainFrac.getHeightFromPercent(hills)
                borderPlots = []
                borderSidePlots = []
                for dx in range(iW/6) :
                        for dy in range(iH/6) :
                                for dyy in range(5) : 
                                        borderPlots.append(map.plotNum(dx*6, dy*6+dyy))
                                        cTP = toWrap(dx*6+1, dy*6+dyy)
                                        if (dyy in range(1,4)) and (cTP != -1) :
                                                x, y = cTP
                                                borderSidePlots.append(map.plotNum(x, y))
                                        cTP = toWrap(dx*6-1, dy*6+dyy)
                                        if (dyy in range(1,4)) and (cTP != -1) :
                                                x, y = cTP
                                                borderSidePlots.append(map.plotNum(x, y))
                                for dxx in range(5):
                                        borderPlots.append(map.plotNum(dx*6+dxx+1, dy*6+5))
                                        cTP = toWrap(dx*6+dxx+1, dy*6+4)
                                        if (dxx in range(1,4)) and (cTP != -1) :
                                                x, y = cTP
                                                borderSidePlots.append(map.plotNum(x, y))
                                        cTP = toWrap(dx*6+dxx+1, dy*6+6)
                                        if (dxx in range(1,4)) and (cTP != -1) :
                                                x, y = cTP
                                                borderSidePlots.append(map.plotNum(x, y))

                for iX in range(iW) :
                        for iY in range(iH) :
                                iIndex = map.plotNum(iX, iY)
                                val = terrainFrac.getHeight(iX, iY)
                                if iIndex in borderSidePlots : val *= 1.6
                                if (val >= iHillsThreshold*1.3) and (not iIndex in borderPlots) : plotTypes[iIndex] = PlotTypes.PLOT_HILLS

                plotTP = PlotTypes.PLOT_PEAK
                if userInputBorder == 1 : plotTP = PlotTypes.PLOT_HILLS
                elif userInputBorder == 2 : plotTP = PlotTypes.PLOT_LAND
                elif userInputBorder == 3 : plotTP = PlotTypes.PLOT_OCEAN

                if not wrapY :
                        for dx in range(iW/6) :
                                i = map.plotNum(dx*6, iH-1)
                                plotTypes[i] = plotTP
                if not wrapX :
                        for dy in range(iH/6) :
                                i = map.plotNum(0, dy*6+5)
                                plotTypes[i] = plotTP
                for i in borderPlots : plotTypes[i] = plotTP

                lar = iW/6
                hau = iH/6
                chessLakes = [[0 for i in range(2*hau)] for j in range(lar)]
                waterFrac = CyFractal()
                waterFrac.fracInit(lar, 2*hau, grain-3, dice, 0, -1, -1)
                iWaterThreshold = waterFrac.getHeightFromPercent(int(waterPer))
                for dy in range(2*hau) :
                        for dx in range(lar) :
                                if waterFrac.getHeight(dx,dy) >=  iWaterThreshold : continue
                                for (dxx,dyy) in ((1,0),(2,0),(3,0),(4,0),(5,0),(2,1),(3,1),(4,1),(2,-1),(3,-1),(4,-1),(3,2),(3,-2)) :
                                        i = map.plotNum((dx*6+(dy%2)*3+dxx)%iW, (dy*3+dyy-1)%iH)
                                        plotTypes[i] = PlotTypes.PLOT_OCEAN
                                chessLakes[dx][dy] = 1

                for iX in range(iW) :
                        for iY in range(iH) :
                                iIndex = map.plotNum(iX, iY)
                                if plotTypes[iIndex] != PlotTypes.PLOT_OCEAN :
                                        oceanPlots = 0
                                        for (i,j) in ((-1,-1),(-1,0),(-1,1),(0,-1),(0,1),(1,-1),(1,0),(1,1)) :
                                                k = map.plotNum((iX+i)%iW, (iY+j)%iH)
                                                if plotTypes[k] == PlotTypes.PLOT_OCEAN : oceanPlots += 1
                                        if oceanPlots > 5 : plotTypes[iIndex] = PlotTypes.PLOT_OCEAN

                plotLand = []
                plotHill = []
                for i in range(len(plotTypes)) :
                        if i in borderPlots : continue
                        if plotTypes[i] == PlotTypes.PLOT_HILLS : plotHill.append(i)
                        elif plotTypes[i] == PlotTypes.PLOT_LAND : plotLand.append(i)
                hillPerPlaced = float(len(plotHill))/(len(plotHill)+len(plotLand))

                nbPlaced = 0
                if hillPerPlaced < hillPer :
                        plotToPlace = PlotTypes.PLOT_HILLS
                        refList = plotLand
                        nbToPlace = (hillPer-hillPerPlaced)*(len(plotHill)+len(plotLand))
                else:
                        plotToPlace = PlotTypes.PLOT_LAND
                        refList = plotHill
                        nbToPlace = (hillPerPlaced-hillPer)*(len(plotHill)+len(plotLand))

                while True :
                        if nbPlaced >= nbToPlace : break
                        if len(refList) == 0 : break
                        iChoice = getRandNum(len(refList), 'FoR : chess hill dice')
                        plotTypes[refList[iChoice]] = plotToPlace
                        del refList[iChoice]
                        nbPlaced += 1

                return (True, plotTypes)
        except :
                writeLog("", False, ["", " An error occured during Chess plot generation ... generate a fractal map"])
                writeError()
                fractal_world = FractalWorld()
                fractal_world.initFractal(polar = True)
                plotTypes = fractal_world.generatePlotTypes()
                return (False, plotTypes)

class WheelMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsInRegion(self, iWaterPercent, 
	                          iRegionWidth, iRegionHeight, 
	                          iRegionWestX, iRegionSouthY, 
	                          iRegionGrain, iRegionHillsGrain, 
	                          iRegionPlotFlags, iRegionTerrainFlags, 
	                          iRegionFracXExp = -1, iRegionFracYExp = -1, 
	                          bShift = True, iStrip = 15, 
	                          rift_grain = -1, has_center_rift = False, 
	                          invert_heights = False):
		water = iWaterPercent
		iWestX = iRegionWestX
		iSouthY = iRegionSouthY
		self.plotTypes = []
		self.plotTypes = [PlotTypes.PLOT_OCEAN] * (iRegionWidth*iRegionHeight)
		regionContinentsFrac = CyFractal()
		regionHillsFrac = CyFractal()
		regionPeaksFrac = CyFractal()
		regionContinentsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionGrain, self.dice, iRegionPlotFlags, iRegionFracXExp, iRegionFracYExp)
		regionHillsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		regionPeaksFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain+1, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		iWaterThreshold = regionContinentsFrac.getHeightFromPercent(water)
		iHillsBottom1 = regionHillsFrac.getHeightFromPercent(max((23 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop1 = regionHillsFrac.getHeightFromPercent(min((30 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iHillsBottom2 = regionHillsFrac.getHeightFromPercent(max((70 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop2 = regionHillsFrac.getHeightFromPercent(min((77 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iPeakThreshold = regionPeaksFrac.getHeightFromPercent(self.gc.getClimateInfo(self.map.getClimate()).getPeakPercent())
		for x in range(iRegionWidth):
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				val = regionContinentsFrac.getHeight(x,y)
				if val <= iWaterThreshold: pass
				else:
					hillVal = regionHillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						peakVal = regionPeaksFrac.getHeight(x,y)
						if (peakVal <= iPeakThreshold):
							self.plotTypes[i] = PlotTypes.PLOT_PEAK
						else:
							self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		if bShift:
			self.shiftRegionPlots(iRegionWidth, iRegionHeight, iStrip)
		for x in range(iRegionWidth):
			wholeworldX = x + iWestX
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				if self.plotTypes[i] == PlotTypes.PLOT_OCEAN: continue
				wholeworldY = y + iSouthY
				iWorld = wholeworldY*self.iW + wholeworldX
				self.wholeworldPlotTypes[iWorld] = self.plotTypes[i]
		return

	def generateCenter(self, iWaterPercent, 
	                   iRegionWidth, iRegionHeight, 
	                   iRegionWestX, iRegionSouthY, 
	                   iRegionGrain, iRegionHillsGrain, 
	                   iRegionPlotFlags, iRegionTerrainFlags, 
	                   iRegionFracXExp = -1, iRegionFracYExp = -1, 
	                   bShift = True, iStrip = 15, 
	                   rift_grain = -1, has_center_rift = False, 
	                   invert_heights = False):
		water = iWaterPercent
		iWestX = iRegionWestX
		iSouthY = iRegionSouthY
		self.plotTypes = []
		self.plotTypes = [PlotTypes.PLOT_OCEAN] * (iRegionWidth*iRegionHeight)
		regionContinentsFrac = CyFractal()
		regionHillsFrac = CyFractal()
		regionContinentsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionGrain, self.dice, iRegionPlotFlags, iRegionFracXExp, iRegionFracYExp)
		regionHillsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		iWaterThreshold = regionContinentsFrac.getHeightFromPercent(water)
		iHillsBottom1 = regionHillsFrac.getHeightFromPercent(max((20 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop1 = regionHillsFrac.getHeightFromPercent(min((30 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iHillsBottom2 = regionHillsFrac.getHeightFromPercent(max((70 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop2 = regionHillsFrac.getHeightFromPercent(min((80 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		for x in range(iRegionWidth):
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				val = regionContinentsFrac.getHeight(x,y)
				if val <= iWaterThreshold: pass
				else:
					hillVal = regionHillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND

		if bShift:
			self.shiftRegionPlots(iRegionWidth, iRegionHeight, iStrip)
		for x in range(iRegionWidth):
			wholeworldX = x + iWestX
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				if self.plotTypes[i] == PlotTypes.PLOT_OCEAN: continue
				wholeworldY = y + iSouthY
				iWorld = wholeworldY*self.iW + wholeworldX
				self.wholeworldPlotTypes[iWorld] = self.plotTypes[i]
		return

	def generatePlotsByRegion(self, wheel_type):
		iPlayers = self.gc.getGame().countCivPlayersEverAlive()
		userInputAreaType = cmo[1]
		area_grain = 3 - userInputAreaType
		buffer_one = [0, 58, 64, 70]
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		if wheel_type == 1 and iPlayers < 11 and iPlayers > 1:
			global buffer_data
			for buffer_loop in range(iPlayers):
				[bufWestX, bufEastX, bufSouthY, bufNorthY] = buffer_data[buffer_loop]
				thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Wheel PYTHON")
				bufWater = sea + buffer_one[thisBuffer]
				bufGrain = thisBuffer + 1
				bufWidth = bufEastX - bufWestX + 1
				bufHeight = bufNorthY - bufSouthY + 1
				self.generatePlotsInRegion(bufWater,
				                           bufWidth, bufHeight,
				                           bufWestX, bufSouthY,
				                           bufGrain, 3,
				                           self.iRoundFlags, self.iTerrainFlags,
				                           6, 6,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		else: pass
		global region_data
		for region_loop in range(iPlayers):
			[regWestX, regEastX, regSouthY, regNorthY] = region_data[region_loop]
			regWidth = regEastX - regWestX + 1
			regHeight = regNorthY - regSouthY + 1
			self.generatePlotsInRegion(55 + sea,
			                           regWidth, regHeight,
			                           regWestX, regSouthY,
			                           area_grain, 4,
			                           self.iRoundFlags, self.iTerrainFlags,
			                           6, 6,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
			coreWestX = regWestX + int(regWidth * 0.25)
			coreEastX = regEastX - int(regWidth * 0.25)
			coreSouthY = regSouthY + int(regHeight * 0.25)
			coreNorthY = regNorthY - int(regHeight * 0.25)
			coreWidth = coreEastX - coreWestX + 1
			coreHeight = coreNorthY - coreSouthY + 1
			self.generatePlotsInRegion(65,
			                           coreWidth, coreHeight,
			                           coreWestX, coreSouthY,
			                           1, 3,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           5, 5,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
		global wheel_data
		linewidth = 1 + cmo[2]
		iWH = self.iW * self.iH
		offsetstart = 0 - int(linewidth/2)
		offsetrange = range(offsetstart, offsetstart + linewidth)
		for wheel_loop in range(len(wheel_data) - 1):
			[startx, starty] = wheel_data[wheel_loop]
			[endx, endy] = wheel_data[wheel_loop + 1]
			if abs(endy-starty) < abs(endx-startx):
				if startx > endx:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx = endx-startx
				dy = endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dy)/float(dx)
				y = starty
				for x in range(startx, endx+1):
					for offset in offsetrange:
						if map.isPlot(x, int(round(y+offset))):
							i = map.plotNum(x, int(round(y+offset)))
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					y += slope
			else:
				if starty > endy:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx, dy = endx-startx, endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dx)/float(dy)
				x = startx
				for y in range(starty, endy+1):
					for offset in offsetrange:
						if map.isPlot(int(round(x+offset)), y):
							i = map.plotNum(int(round(x+offset)), y)
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					x += slope
		global hub_data
		linewidth = 1 + cmo[3]
		iWH = self.iW * self.iH
		offsetstart = 0 - int(linewidth/2)
		offsetrange = range(offsetstart, offsetstart + linewidth)
		for hub_loop in range(len(hub_data)):
			[startx, starty, endx, endy] = hub_data[hub_loop]
			if abs(endy-starty) < abs(endx-startx):
				if startx > endx:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx = endx-startx
				dy = endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dy)/float(dx)
				y = starty
				for x in range(startx, endx+1):
					for offset in offsetrange:
						if map.isPlot(x, int(round(y+offset))):
							i = map.plotNum(x, int(round(y+offset)))
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					y += slope
			else:
				if starty > endy:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx, dy = endx-startx, endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dx)/float(dy)
				x = startx
				for y in range(starty, endy+1):
					for offset in offsetrange:
						if map.isPlot(int(round(x+offset)), y):
							i = map.plotNum(int(round(x+offset)), y)
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					x += slope
		global center_data
		[cenWestX, cenEastX, cenSouthY, cenNorthY] = center_data
		cenWidth = cenEastX - cenWestX + 1
		cenHeight = cenNorthY - cenSouthY + 1
		thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Wheel PYTHON")
		bufWater = sea + buffer_one[thisBuffer]
		bufGrain = thisBuffer + 1
		self.generateCenter(bufWater,
		                    cenWidth, cenHeight,
		                    cenWestX, cenSouthY,
		                    bufGrain, 4,
		                    self.iRoundFlags, self.iTerrainFlags,
		                    -1, -1,
		                    True, 5,
		                    -1, False,
		                    False
		                    )
		return self.wholeworldPlotTypes

class TerraMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self):
		sizekey = self.map.getWorldSize()
		sizevalues = {
			WorldSizeTypes.WORLDSIZE_DUEL:      (3,2,1,2),
			WorldSizeTypes.WORLDSIZE_TINY:      (3,2,1,2),
			WorldSizeTypes.WORLDSIZE_SMALL:     (4,2,1,2),
			WorldSizeTypes.WORLDSIZE_STANDARD:  (4,2,1,2),
			WorldSizeTypes.WORLDSIZE_LARGE:     (4,2,1,2),
			WorldSizeTypes.WORLDSIZE_HUGE:      (5,2,1,2)
			}
		if int(sizekey) in sizevalues.keys() :
                        (archGrain, contGrain, gaeaGrain, eurasiaGrain) = sizevalues[sizekey]
                else :
                        (archGrain, contGrain, gaeaGrain, eurasiaGrain) = (7,4,3,4)
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		newworldWestLon = 0.05
		newworldEastLon = 0.35
		eurasiaWestLon = 0.45
		eurasiaEastLon = 0.95
		eurasiaNorthLat = 0.95
		eurasiaSouthLat = 0.45
		thirdworldDimension = 0.125
		thirdworldNorthLat = 0.35
		thirdworldSouthLat = 0.05
		subcontinentLargeHorz = 0.2
		subcontinentLargeVert = 0.32
		subcontinentLargeNorthLat = 0.6
		subcontinentLargeSouthLat = 0.28
		subcontinentSmallDimension = 0.125
		subcontinentSmallNorthLat = 0.525
		subcontinentSmallSouthLat = 0.4
		roll1 = getRandNum(2, "FoR : Eurasian Hemisphere N/S - Terra PYTHON")
		if roll1 == 1:
			eurasiaNorthLat -= 0.4; eurasiaSouthLat -= 0.4
			thirdworldNorthLat += 0.6; thirdworldSouthLat += 0.6
			subcontinentLargeNorthLat += 0.12; subcontinentLargeSouthLat += 0.12
			subcontinentSmallNorthLat += 0.075; subcontinentSmallSouthLat += 0.075
		roll2 = getRandNum(2, "FoR : Eurasian Hemisphere E/W - Terra PYTHON")
		if roll2 == 1:
			newworldWestLon += 0.6; newworldEastLon += 0.6
			eurasiaWestLon -= 0.4; eurasiaEastLon -= 0.4
		eurasiaWestX = int(self.iW * eurasiaWestLon)
		eurasiaEastX = int(self.iW * eurasiaEastLon)
		eurasiaNorthY = int(self.iH * eurasiaNorthLat)
		eurasiaSouthY = int(self.iH * eurasiaSouthLat)
		eurasiaWidth = eurasiaEastX - eurasiaWestX + 1
		eurasiaHeight = eurasiaNorthY - eurasiaSouthY + 1
		eurasiaWater = 55+sea
		self.generatePlotsInRegion(eurasiaWater,
		                           eurasiaWidth, eurasiaHeight,
		                           eurasiaWestX, eurasiaSouthY,
		                           eurasiaGrain, archGrain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           -1, -1,
		                           True, 11,
		                           2, False,
		                           False
		                           )
		twHeight = eurasiaHeight/2
		twWestX = eurasiaWestX + eurasiaWidth/10
		twEastX = eurasiaEastX - eurasiaWidth/10
		twWidth = twEastX - twWestX + 1
		twNorthY = eurasiaNorthY - eurasiaHeight/4
		twSouthY = eurasiaSouthY + eurasiaHeight/4
		twWater = 60+sea; twGrain = 1; twRift = 2
		self.generatePlotsInRegion(twWater,
		                           twWidth, twHeight,
		                           twWestX, twSouthY,
		                           twGrain, archGrain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           -1, -1,
		                           True, 11,
		                           twRift, False,
		                           False
		                           )
		NiTextOut("Generating the New World (Python Terra) ...")
		nwWestX = int(self.iW * newworldWestLon)
		nwEastX = int(self.iW * newworldEastLon)
		nwNorthY = int(self.iH * 0.85)
		nwSouthY = int(self.iH * 0.52)
		nwWidth = nwEastX - nwWestX + 1
		nwHeight = nwNorthY - nwSouthY + 1
		nwWater = 61+sea; nwGrain = 1; nwRift = -1
		self.generatePlotsInRegion(nwWater,
		                           nwWidth, nwHeight,
		                           nwWestX, nwSouthY,
		                           nwGrain, archGrain,
		                           self.iVertFlags, self.iTerrainFlags,
		                           6, 6,
		                           True, 7,
		                           nwRift, False,
		                           False
		                           )
		nwsRoll = getRandNum(2, "FoR : New World South E/W - Terra PYTHON")
		nwsVar = 0.0
		if nwsRoll == 1: nwsVar = 0.05
		nwsWestX = nwWestX + int(self.iW * (0.08 - nwsVar))
		nwsEastX = nwEastX - int(self.iW * (0.03 + nwsVar))
		nwsNorthY = int(self.iH * 0.47)
		nwsSouthY = int(self.iH * 0.25)
		nwsWidth = nwsEastX - nwsWestX + 1
		nwsHeight = nwsNorthY - nwsSouthY + 1
		nwsWater = 55+sea; nwsGrain = 1; nwsRift = -1
		self.generatePlotsInRegion(nwsWater,
		                           nwsWidth, nwsHeight,
		                           nwsWestX, nwsSouthY,
		                           nwsGrain, archGrain,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, 6,
		                           True, 5,
		                           nwsRift, False,
		                           False
		                           )
		nwpWestX = nwWestX + int(self.iW * (0.1 - nwsVar))
		nwpEastX = nwEastX - int(self.iW * (0.07 + nwsVar))
		nwpNorthY = int(self.iH * 0.3)
		nwpSouthY = int(self.iH * 0.18)
		nwpWidth = nwpEastX - nwpWestX + 1
		nwpHeight = nwpNorthY - nwpSouthY + 1
		nwpWater = 67+sea; nwpGrain = 1; nwpRift = -1
		self.generatePlotsInRegion(nwpWater,
		                           nwpWidth, nwpHeight,
		                           nwpWestX, nwpSouthY,
		                           nwpGrain, archGrain,
		                           self.iVertFlags, self.iTerrainFlags,
		                           6, 5,
		                           True, 3,
		                           nwpRift, False,
		                           False
		                           )
		twWidth = int(self.iW * 0.15)
		twWestX = nwWestX
		boreal = getRandNum(2, "FoR : New World North E/W - Terra PYTHON")
		if boreal == 1: twWestX += int(self.iW * 0.15)
		twEastX = twWestX + twWidth
		twNorthY = int(self.iH * 0.93)
		twSouthY = int(self.iH * 0.75)
		twHeight = twNorthY - twSouthY + 1
		twWater = 68+sea; twGrain = 2; twRift = -1
		self.generatePlotsInRegion(twWater,
		                           twWidth, twHeight,
		                           twWestX, twSouthY,
		                           twGrain, archGrain,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, 5,
		                           True, 5,
		                           twRift, False,
		                           False
		                           )
		twWidth = int(thirdworldDimension * self.iW)
		twHeight = int(thirdworldDimension * self.iH)
		if boreal == 0: 
			twEastX = nwEastX
			twWestX = twEastX - twWidth
		else:
			twWestX = nwWestX
			twEastX = twWestX + twWidth
		twNorthY = int(self.iH * 0.975)
		twSouthY = int(self.iH * 0.85)
		twWater = 76+sea; twGrain = archGrain; twRift = -1
		self.generatePlotsInRegion(twWater,
		                           twWidth, twHeight,
		                           twWestX, twSouthY,
		                           twGrain, archGrain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           6, 5,
		                           True, 5,
		                           twRift, False,
		                           False
		                           )
 		nwcVar = 0.0
		if nwsRoll == 1: nwcVar = 0.04
		nwcWidth = int(self.iW * 0.06)
		nwcRoll = getRandNum(2, "FoR : Central America and Carribean Placement - Terra PYTHON")
		nwcWestX = nwWestX + int(self.iW * (0.1 + nwcVar))
		nwcEastX = nwcWestX + nwcWidth
		nwcNorthY = int(self.iH * 0.6)
		nwcSouthY = int(self.iH * 0.42)
		nwcHeight = nwcNorthY - nwcSouthY + 1
		nwcWater = 60+sea; nwcGrain = 1; nwcRift = -1
		self.generatePlotsInRegion(nwcWater,
		                           nwcWidth, nwcHeight,
		                           nwcWestX, nwcSouthY,
		                           nwcGrain, archGrain,
		                           self.iVertFlags, self.iTerrainFlags,
		                           6, 5,
		                           True, 5,
		                           nwcRift, False,
		                           False
		                           )
 		carVar = 0.0
		if nwsRoll == 1: carVar = 0.15
		twWidth = int(0.15 * self.iW)
		twEastX = nwEastX - int(carVar * self.iW)
		twWestX = twEastX - twWidth
		twNorthY = int(self.iH * 0.55)
		twSouthY = int(self.iH * 0.47)
		twHeight = twNorthY - twSouthY + 1
		twWater = 75+sea; twGrain = archGrain + 1; twRift = -1
		self.generatePlotsInRegion(twWater,
		                           twWidth, twHeight,
		                           twWestX, twSouthY,
		                           twGrain, archGrain,
		                           0, self.iTerrainFlags,
		                           6, 5,
		                           True, 3,
		                           twRift, False,
		                           False
		                           )
		scLargeWidth = int(subcontinentLargeHorz * self.iW)
		scLargeHeight = int(subcontinentLargeVert * self.iH)
		scRoll = getRandNum((eurasiaWidth - scLargeWidth), "FoR : Large Subcontinent Placement - Terra PYTHON")
		scWestX = eurasiaWestX + scRoll
		scEastX = scWestX + scLargeWidth
		scNorthY = int(self.iH * subcontinentLargeNorthLat)
		scSouthY = int(self.iH * subcontinentLargeSouthLat)
		scShape = getRandNum(4, "FoR : Large Subcontinent Shape - Terra PYTHON")
		if scShape > 1:
			scWater = 55+sea; scGrain = 1; scRift = 2
		elif scShape == 1:
			scWater = 66+sea; scGrain = 2; scRift = 2
		else:
			scWater = 77+sea; scGrain = archGrain; scRift = -1
		self.generatePlotsInRegion(scWater,
		                           scLargeWidth, scLargeHeight,
		                           scWestX, scSouthY,
		                           scGrain, archGrain,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           6, 6,
		                           True, 7,
		                           scRift, False,
		                           False
		                           )
		scSmallWidth = int(subcontinentSmallDimension * self.iW)
		scSmallHeight = int(subcontinentSmallDimension * self.iH)
		endless = 1
		while endless == 1:
			scsRoll = getRandNum((eurasiaWidth - scSmallWidth), "FoR : Small Subcontinent Placement - Terra PYTHON")
			scsWestX = eurasiaWestX + scsRoll
			if abs((scsWestX + self.iW/12) - scWestX) > self.iW/8: break
		scsEastX = scsWestX + scSmallWidth
		scsNorthY = int(self.iH * subcontinentSmallNorthLat)
		scsSouthY = int(self.iH * subcontinentSmallSouthLat)
		scsShape = getRandNum(4, "FoR : Small Subcontinent Shape - Terra PYTHON")
		if scsShape == 2:
			scsWater = 55+sea; scsGrain = 1; scsRift = 2
		elif scsShape == 1:
			scsWater = 66+sea; scsGrain = 2; scsRift = 2
		else:
			scsWater = 77+sea; scsGrain = archGrain; scsRift = -1
		self.generatePlotsInRegion(scsWater,
		                           scSmallWidth, scSmallHeight,
		                           scsWestX, scsSouthY,
		                           scsGrain, archGrain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           6, 5,
		                           True, 5,
		                           scsRift, False,
		                           False
		                           )
		extras = 2 + getRandNum(3, "FoR : Number of Minor Regions - Terra PYTHON")
		for loop in range(extras):
			twWidth = int(thirdworldDimension * self.iW)
			twHeight = int(thirdworldDimension * self.iH)
			twVertRange = int(0.3 * self.iH) - twHeight
			twRoll = getRandNum((eurasiaWidth - twWidth), "FoR : Minor Region Placement - Terra PYTHON")
			twWestX = eurasiaWestX + twRoll
			twEastX = scWestX + scLargeWidth
			twVertRoll = getRandNum(twVertRange, "FoR : Minor Region Placement - Terra PYTHON")
			twNorthY = int(self.iH * thirdworldNorthLat) + twVertRoll
			twSouthY = int(self.iH * thirdworldSouthLat) + twVertRoll
			twShape = getRandNum(3, "FoR : Minor Region Shape - Terra PYTHON")
			if twShape == 2:
				twWater = 60+sea; twGrain = 1; twRift = 2
			elif twShape == 1:
				twWater = 65+sea; twGrain = 2; twRift = 2
			else:
				twWater = 70+sea; twGrain = archGrain; twRift = -1
			self.generatePlotsInRegion(twWater,
			                           twWidth, twHeight,
			                           twWestX, twSouthY,
			                           twGrain, archGrain,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           6, 5,
			                           True, 5,
			                           twRift, False,
			                           False
			                           )
		return self.wholeworldPlotTypes

class RingMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsInRegion(self, iWaterPercent, 
	                          iRegionWidth, iRegionHeight, 
	                          iRegionWestX, iRegionSouthY, 
	                          iRegionGrain, iRegionHillsGrain, 
	                          iRegionPlotFlags, iRegionTerrainFlags, 
	                          iRegionFracXExp = -1, iRegionFracYExp = -1, 
	                          bShift = True, iStrip = 15, 
	                          rift_grain = -1, has_center_rift = False, 
	                          invert_heights = False):
		water = iWaterPercent
		iWestX = iRegionWestX
		iSouthY = iRegionSouthY
		self.plotTypes = []
		self.plotTypes = [PlotTypes.PLOT_OCEAN] * (iRegionWidth*iRegionHeight)
		regionContinentsFrac = CyFractal()
		regionHillsFrac = CyFractal()
		regionPeaksFrac = CyFractal()
		regionContinentsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionGrain, self.dice, iRegionPlotFlags, iRegionFracXExp, iRegionFracYExp)
		regionHillsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		regionPeaksFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain+1, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		iWaterThreshold = regionContinentsFrac.getHeightFromPercent(water)
		iHillsBottom1 = regionHillsFrac.getHeightFromPercent(max((23 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop1 = regionHillsFrac.getHeightFromPercent(min((30 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iHillsBottom2 = regionHillsFrac.getHeightFromPercent(max((70 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop2 = regionHillsFrac.getHeightFromPercent(min((77 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iPeakThreshold = regionPeaksFrac.getHeightFromPercent(self.gc.getClimateInfo(self.map.getClimate()).getPeakPercent())
		for x in range(iRegionWidth):
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				val = regionContinentsFrac.getHeight(x,y)
				if val <= iWaterThreshold: pass
				else:
					hillVal = regionHillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						peakVal = regionPeaksFrac.getHeight(x,y)
						if (peakVal <= iPeakThreshold):
							self.plotTypes[i] = PlotTypes.PLOT_PEAK
						else:
							self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		if bShift:
			self.shiftRegionPlots(iRegionWidth, iRegionHeight, iStrip)
		for x in range(iRegionWidth):
			wholeworldX = x + iWestX
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				if self.plotTypes[i] == PlotTypes.PLOT_OCEAN: continue
				wholeworldY = y + iSouthY
				iWorld = wholeworldY*self.iW + wholeworldX
				self.wholeworldPlotTypes[iWorld] = self.plotTypes[i]
		return

	def generatePlotsByRegion(self, ring_type):
		iPlayers = self.gc.getGame().countCivPlayersEverAlive()
		userInputAreaType = cmo[1]
		area_grain = 3 - userInputAreaType
		userInputBufferType = cmo[2]
		buffer_one = [0, 58, 64, 70]
		bufWater = buffer_one[userInputBufferType]
		grainType = userInputBufferType
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		bufWater += sea
		if ring_type == 1 and iPlayers < 11 and iPlayers > 1:
			global buffer_data
			for buffer_loop in range(iPlayers):
				[bufWestX, bufEastX, bufSouthY, bufNorthY] = buffer_data[buffer_loop]
				if grainType == 0:
					thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Ring PYTHON")
					bufWater = sea + buffer_one[thisBuffer]
					bufGrain = thisBuffer + 1
				else:
					bufGrain = grainType + 1
				bufWidth = bufEastX - bufWestX + 1
				bufHeight = bufNorthY - bufSouthY + 1
				self.generatePlotsInRegion(bufWater,
				                           bufWidth, bufHeight,
				                           bufWestX, bufSouthY,
				                           bufGrain, 3,
				                           self.iRoundFlags, self.iTerrainFlags,
				                           6, 6,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		else: pass
		global region_data
		for region_loop in range(iPlayers):
			[regWestX, regEastX, regSouthY, regNorthY] = region_data[region_loop]
			regWidth = regEastX - regWestX + 1
			regHeight = regNorthY - regSouthY + 1
			self.generatePlotsInRegion(55 + sea,
			                           regWidth, regHeight,
			                           regWestX, regSouthY,
			                           area_grain, 4,
			                           self.iRoundFlags, self.iTerrainFlags,
			                           6, 6,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
			coreWestX = regWestX + int(regWidth * 0.25)
			coreEastX = regEastX - int(regWidth * 0.25)
			coreSouthY = regSouthY + int(regHeight * 0.25)
			coreNorthY = regNorthY - int(regHeight * 0.25)
			coreWidth = coreEastX - coreWestX + 1
			coreHeight = coreNorthY - coreSouthY + 1
			self.generatePlotsInRegion(65,
			                           coreWidth, coreHeight,
			                           coreWestX, coreSouthY,
			                           1, 3,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           5, 5,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
		global center_data
		[cenWestX, cenEastX, cenSouthY, cenNorthY] = center_data
		cenWidth = cenEastX - cenWestX + 1
		cenHeight = cenNorthY - cenSouthY + 1
		if grainType == 0:
			thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Ring PYTHON")
			bufWater = sea + buffer_one[thisBuffer]
			bufGrain = thisBuffer + 1
		else:
			bufGrain = grainType + 1
		self.generatePlotsInRegion(bufWater,
		                           cenWidth, cenHeight,
		                           cenWestX, cenSouthY,
		                           bufGrain, 4,
		                           self.iRoundFlags, self.iTerrainFlags,
		                           -1, -1,
		                           True, 5,
		                           -1, False,
		                           False
		                           )
		global wheel_data
		linewidth = 1 + cmo[3]
		iWH = self.iW * self.iH
		offsetstart = 0 - int(linewidth/2)
		offsetrange = range(offsetstart, offsetstart + linewidth)
		for wheel_loop in range(len(wheel_data) - 1):
			[startx, starty] = wheel_data[wheel_loop]
			[endx, endy] = wheel_data[wheel_loop + 1]
			if abs(endy-starty) < abs(endx-startx):
				if startx > endx:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx = endx-startx
				dy = endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dy)/float(dx)
				y = starty
				for x in range(startx, endx+1):
					for offset in offsetrange:
						if map.isPlot(x, int(round(y+offset))):
							i = map.plotNum(x, int(round(y+offset)))
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					y += slope
			else:
				if starty > endy:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx, dy = endx-startx, endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dx)/float(dy)
				x = startx
				for y in range(starty, endy+1):
					for offset in offsetrange:
						if map.isPlot(int(round(x+offset)), y):
							i = map.plotNum(int(round(x+offset)), y)
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					x += slope
		return self.wholeworldPlotTypes

def generatePangaeaPlotTypes():
	global pangaea_type
	mapgen = CyMapGenerator()
	hinted_world = PangaeaHintedWorld()
	fractal_world = PangaeaMultilayeredFractal()
	userInputLandmass = cmo[0]
	if userInputLandmass == 3:
		typeRoll = getRandNum(3, "FoR : PlotGen Chooser - Pangaea PYTHON")
		cohesive = False
		while not cohesive:
			plotTypes = []
			if typeRoll == 2:
				plotTypes = hinted_world.generateAndysHintedPangaea()
			else:
				plotTypes = hinted_world.generateSorensHintedPangaea()
			mapgen.setPlotTypes(plotTypes)
			biggest_area = map.findBiggestArea(false)
			iTotalLandPlots = map.getLandPlots()
			iBiggestAreaPlots = biggest_area.getNumTiles()
			if iBiggestAreaPlots >= 0.9 * iTotalLandPlots:
				cohesive = True
		return plotTypes
	elif userInputLandmass == 2:
		typeRoll = getRandNum(3, "FoR : PlotGen Chooser - Pangaea PYTHON")
		if typeRoll == 1:
			pangaea_type = 1
		else:
			pangaea_type = 2
		return fractal_world.generatePlotsByRegion(pangaea_type)
	elif userInputLandmass == 1:
		pangaea_type = 0
		return fractal_world.generatePlotsByRegion(pangaea_type)
	else:
		global terrainRoll
		terrainRoll = getRandNum(10, "FoR : PlotGen Chooser - Pangaea PYTHON")
		if terrainRoll > 6:
			cohesive = False
			while not cohesive:
				plotTypes = []
				if terrainRoll == 9:
					plotTypes = hinted_world.generateAndysHintedPangaea()
				else:
					plotTypes = hinted_world.generateSorensHintedPangaea()
				mapgen.setPlotTypes(plotTypes)
				biggest_area = map.findBiggestArea(false)
				iTotalLandPlots = map.getLandPlots()
				iBiggestAreaPlots = biggest_area.getNumTiles()
				if iBiggestAreaPlots >= 0.9 * iTotalLandPlots:
					cohesive = True
			return plotTypes
		elif terrainRoll == 5 or terrainRoll == 6:
			pangaea_type = 2
			return fractal_world.generatePlotsByRegion(pangaea_type)
		elif terrainRoll == 4:
			pangaea_type = 1
			return fractal_world.generatePlotsByRegion(pangaea_type)
		else:
			pangaea_type = 0
			return fractal_world.generatePlotsByRegion(pangaea_type)

class PangaeaHintedWorld:
	def generateSorensHintedPangaea(self):
		global hinted_world
		hinted_world = HintedWorld(8,4)
		for y in range(hinted_world.h):
			for x in range(hinted_world.w):
				if x in (0, hinted_world.w-1) or y in (0, hinted_world.h-1):
					hinted_world.setValue(x,y,0)
				else:
					hinted_world.setValue(x,y,200 + getRandNum(55, "FoR : Plot Types - Pangaea PYTHON"))
		hinted_world.setValue(1, 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		hinted_world.setValue(2 + getRandNum(2, "FoR : Plot Types - Pangaea PYTHON"), 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		hinted_world.setValue(4 + getRandNum(2, "FoR : Plot Types - Pangaea PYTHON"), 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		hinted_world.setValue(6, 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		if (getRandNum(2, "FoR : Plot Types - Pangaea PYTHON") == 0):
			hinted_world.setValue(2, 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		else:
			hinted_world.setValue(5, 1 + getRandNum(3, "FoR : Plot Types - Pangaea PYTHON"), getRandNum(64, "FoR : Plot Types - Pangaea PYTHON"))
		hinted_world.buildAllContinents()
		return hinted_world.generatePlotTypes(shift_plot_types=True)
	
	def generateAndysHintedPangaea(self):
		global hinted_world
		hinted_world = HintedWorld(16,8)
		numBlocks = hinted_world.w * hinted_world.h
		numBlocksLand = int(numBlocks*0.33)
		cont = hinted_world.addContinent(numBlocksLand,getRandNum(5, "FoR : Generate Plot Types PYTHON")+4,getRandNum(3, "FoR : Generate Plot Types PYTHON")+2)
		if not cont:
			return self.generateSorensHintedPangaea()
		else:		
			for x in range(hinted_world.w):
				for y in (0, hinted_world.h - 1):
					hinted_world.setValue(x,y, 1)
			hinted_world.buildAllContinents()
			return hinted_world.generatePlotTypes(shift_plot_types=True)

class PangaeaMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self, pangaea_type):
		sizekey = self.map.getWorldSize()
		sizevalues = {
			WorldSizeTypes.WORLDSIZE_DUEL:      3,
			WorldSizeTypes.WORLDSIZE_TINY:      3,
			WorldSizeTypes.WORLDSIZE_SMALL:     4,
			WorldSizeTypes.WORLDSIZE_STANDARD:  4,
			WorldSizeTypes.WORLDSIZE_LARGE:     4,
			WorldSizeTypes.WORLDSIZE_HUGE:      5
			}
		if int(sizekey) in sizevalues.keys() :
                        grain = sizevalues[sizekey]
                else :
                        grain = 7
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		mainWestLon = 0.2
		mainEastLon = 0.8
		mainSouthLat = 0.2
		mainNorthLat = 0.8
		subcontinentDimension = 0.4
		bSouthwardShift = False
		if pangaea_type == 2:
			numSubcontinents = 3
			global polarShiftRoll
			polarShiftRoll = getRandNum(2, "FoR : Shift - Pangaea PYTHON")
			if polarShiftRoll == 1:
				mainNorthLat += 0.175
				mainSouthLat += 0.175
				scValues = [[0.05, 0.375, 0.2, 0.0, 0],
				            [0.55, 0.375, 0.2, 0.0, 0],
				            [0.1, 0.225, 0.0, 0.15, 0],
				            [0.3, 0.225, 0.0, 0.15, 0]
				            ]
			else:
				mainNorthLat -= 0.175
				mainSouthLat -= 0.175
				scValues = [[0.05, 0.025, 0.2, 0.0, 0],
				            [0.55, 0.025, 0.2, 0.0, 0],
				            [0.1, 0.375, 0.0, 0.15, 0],
				            [0.3, 0.375, 0.0, 0.15, 0]
				            ]
		elif pangaea_type == 1:
			equRoll = getRandNum(4, "FoR : Subcontinents - Pangaea PYTHON")
			if equRoll == 3: equRoll = 1
			numSubcontinents = 2 + equRoll
			scValues = [[0.05, 0.2, 0.2, 0.0, 0.0],
			            [0.55, 0.2, 0.2, 0.0, 0.0],
			            [0.2, 0.05, 0.0, 0.2, 0.0],
			            [0.2, 0.55, 0.0, 0.2, 0.0]
			            ]
		else:
			subcontinentDimension = 0.3
			global shiftRoll
			shiftRoll = getRandNum(2, "FoR : Shift - Pangaea PYTHON")
			if shiftRoll == 1:
				mainNorthLat += 0.075
				mainSouthLat += 0.075
			else:
				mainNorthLat -= 0.075
				mainSouthLat -= 0.075
				bSouthwardShift = True
			numSubcontinents = 4 + getRandNum(3, "FoR : Subcontinents - Pangaea PYTHON")
			scValues = [[0.05, 0.575, 0.0, 0.0, 0.15],
			            [0.05, 0.275, 0.0, 0.0, 0.15],
			            [0.2, 0.175, 0.0, 0.0, 0.15],
			            [0.5, 0.175, 0.0, 0.0, 0.15],
			            [0.65, 0.575, 0.0, 0.0, 0.15],
			            [0.65, 0.275, 0.0, 0.0, 0.15],
			            [0.2, 0.675, 0.0, 0.0, 0.15],
			            [0.5, 0.675, 0.0, 0.0, 0.15]
			            ]
		mainWestX = int(self.iW * mainWestLon)
		mainEastX = int(self.iW * mainEastLon)
		mainNorthY = int(self.iH * mainNorthLat)
		mainSouthY = int(self.iH * mainSouthLat)
		mainWidth = mainEastX - mainWestX + 1
		mainHeight = mainNorthY - mainSouthY + 1
		mainWater = 55+sea
		self.generatePlotsInRegion(mainWater,
		                           mainWidth, mainHeight,
		                           mainWestX, mainSouthY,
		                           2, grain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           -1, -1,
		                           True, 15,
		                           2, False,
		                           False
		                           )
		second_layerHeight = mainHeight/2
		second_layerWestX = mainWestX + mainWidth/10
		second_layerEastX = mainEastX - mainWidth/10
		second_layerWidth = second_layerEastX - second_layerWestX + 1
		second_layerNorthY = mainNorthY - mainHeight/4
		second_layerSouthY = mainSouthY + mainHeight/4
		second_layerWater = 60+sea
		self.generatePlotsInRegion(second_layerWater,
		                           second_layerWidth, second_layerHeight,
		                           second_layerWestX, second_layerSouthY,
		                           1, grain,
		                           self.iHorzFlags, self.iTerrainFlags,
		                           -1, -1,
		                           True, 15,
		                           2, False,
		                           False
		                           )
		while numSubcontinents > 0:
			if len(scValues) > 1:
				scIndex = getRandNum(len(scValues), "FoR : Subcontinent Placement - Pangaea PYTHON")
			else:
				scIndex = 0
			[scWestLon, scSouthLat, scVertRange, scHorzRange, scSouthShift] = scValues[scIndex]
			scWidth = int(subcontinentDimension * self.iW)
			scHeight = int(subcontinentDimension * self.iH)
			scHorzShift = 0; scVertShift = 0
			if scHorzRange > 0.0:
				scHorzShift = getRandNum(int(self.iW * scHorzRange), "FoR : Subcontinent Variance - Terra PYTHON")
			if scVertRange > 0.0:
				scVertShift = getRandNum(int(self.iW * scVertRange), "FoR : Subcontinent Variance - Terra PYTHON")
			scWestX = int(self.iW * scWestLon) + scHorzShift
			scEastX = scWestX + scWidth
			if scEastX >= self.iW:
				while scEastX >= self.iW:
					scWidth -= 1
					scEastX = scWestX + scWidth
			scSouthY = int(self.iH * scSouthLat) + scVertShift
			if bSouthwardShift:
				scSouthY -= int(self.iH * scSouthShift)
			scNorthY = scSouthY + scHeight
			if scNorthY >= self.iH:
				while scNorthY >= self.iH:
					scHeight -= 1
					scNorthY = scSouthY + scHeight
			scShape = getRandNum(5, "FoR : Subcontinent Shape - Terra PYTHON")
			if scShape > 1:
				scWater = 55+sea; scGrain = 1; scRift = -1
			elif scShape == 1:
				scWater = 66+sea; scGrain = 2; scRift = 2
			else:
				scWater = 77+sea; scGrain = grain; scRift = -1
			self.generatePlotsInRegion(scWater,
			                           scWidth, scHeight,
			                           scWestX, scSouthY,
			                           scGrain, grain,
			                           self.iRoundFlags, self.iTerrainFlags,
			                           6, 6,
			                           True, 7,
			                           scRift, False,
			                           False
			                           )
			del scValues[scIndex]
			numSubcontinents -= 1
		return self.wholeworldPlotTypes

def generateMazePlotTypes():
	userInputMazeWidth = cmo[0]
	multiplier = 1 + userInputMazeWidth
	if userInputMazeWidth > 1:
		extraPeaks = 5 - userInputMazeWidth
	else:
		extraPeaks = 0 
	sizekey = map.getWorldSize()
	grainvalues = {
		WorldSizeTypes.WORLDSIZE_DUEL:		3,
		WorldSizeTypes.WORLDSIZE_TINY:		3,
		WorldSizeTypes.WORLDSIZE_SMALL:		4,
		WorldSizeTypes.WORLDSIZE_STANDARD:	4,
		WorldSizeTypes.WORLDSIZE_LARGE:		5,
		WorldSizeTypes.WORLDSIZE_HUGE:		6
		}
	if int(sizekey) in grainvalues.keys() :
                grain_amount = grainvalues[sizekey]
        else :
                grain_amount = 8
	hillsFrac = CyFractal()
	peaksFrac = CyFractal()
	hillsFrac.fracInit(iW, iH, grain_amount, dice, 0, -1, -1)
	peaksFrac.fracInit(iW, iH, grain_amount + 1, dice, 0, -1, -1)
	iHillsBottom1 = hillsFrac.getHeightFromPercent(max((25 - gc.getClimateInfo(map.getClimate()).getHillRange()), 0))
	iHillsTop1 = hillsFrac.getHeightFromPercent(min((25 + gc.getClimateInfo(map.getClimate()).getHillRange()), 100))
	iHillsBottom2 = hillsFrac.getHeightFromPercent(max((75 - gc.getClimateInfo(map.getClimate()).getHillRange()), 0))
	iHillsTop2 = hillsFrac.getHeightFromPercent(min((75 + gc.getClimateInfo(map.getClimate()).getHillRange()), 100))
	iPeakThreshold = peaksFrac.getHeightFromPercent((10 * extraPeaks) + gc.getClimateInfo(map.getClimate()).getPeakPercent())
	mazeW = iW/(2 * multiplier)
	mazeH = iH/(2 * multiplier)
	plotTypes = [PlotTypes.PLOT_OCEAN] * (iW*iH)
	matrix = [False] * (mazeW*mazeH)
	path = []
	remainingSegments = mazeW*mazeH - 1
	iX = getRandNum(mazeW, "FoR : Starting X - Maze PYTHON")
	iY = getRandNum(mazeH, "FoR : Starting Y - Maze PYTHON")
	directions = 4
	if iX == 0 or iX == mazeW - 1:
		directions -= 1
	if iY == 0 or iY == mazeH - 1:
		directions -= 1
	x = iX * 2 * multiplier
	y = iY * 2 * multiplier
	i = y*iW + x
	hillVal = hillsFrac.getHeight(x,y)
	if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
		plotTypes[i] = PlotTypes.PLOT_HILLS
	else:
		plotTypes[i] = PlotTypes.PLOT_LAND
	if multiplier == 1: pass
	else:
		for mazeX in range(x, x+multiplier):
			for mazeY in range(y, y+multiplier):
				i = mazeY*iW + mazeX
				hillVal = hillsFrac.getHeight(mazeX,mazeY)
				if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
					peakVal = peaksFrac.getHeight(mazeX,mazeY)
					if (peakVal <= iPeakThreshold):
						plotTypes[i] = PlotTypes.PLOT_PEAK
					else:
						plotTypes[i] = PlotTypes.PLOT_HILLS
				else:
					plotTypes[i] = PlotTypes.PLOT_LAND
	while remainingSegments:
		remainingSegments -= 1
		matrixIndex = mazeW*iY + iX
		matrix[matrixIndex] = True
		if iY == mazeH - 1:
			north = 0
		elif matrix[matrixIndex + mazeW] == True:
			north = 0
		else:
			north = 1
		if iY == 0:
			south = 0
		elif matrix[matrixIndex - mazeW] == True:
			south = 0
		else:
			south = 1
		if iX == mazeW - 1:
			east = 0
		elif matrix[matrixIndex + 1] == True:
			east = 0
		else:
			east = 1
		if iX == 0:
			west = 0
		elif matrix[matrixIndex - 1] == True:
			west = 0
		else:
			west = 1
		directions = north + south + east + west
		if directions > 1:
			path.append([iX, iY])
		while directions < 1:
			vertexRoll = getRandNum(len(path), "FoR : Pathfinding - Maze PYTHON")
			[iX, iY] = path[vertexRoll]
			matrixIndex = mazeW*iY + iX
			if iY == mazeH - 1:
				north = 0
			elif matrix[matrixIndex + mazeW] == True:
				north = 0
			else:
				north = 1
			if iY == 0:
				south = 0
			elif matrix[matrixIndex - mazeW] == True:
				south = 0
			else:
				south = 1
			if iX == mazeW - 1:
				east = 0
			elif matrix[matrixIndex + 1] == True:
				east = 0
			else:
				east = 1
			if iX == 0:
				west = 0
			elif matrix[matrixIndex - 1] == True:
				west = 0
			else:
				west = 1
			directions = north + south + east + west
			if directions < 2:
				del path[vertexRoll]
		choose = []
		if north: choose.append([0, 1])
		if south: choose.append([0, -1])
		if east: choose.append([1, 0])
		if west: choose.append([-1, 0])
		dir = getRandNum(len(choose), "FoR : Segment Direction - Maze PYTHON")
		[xPlus, yPlus] = choose[dir]
		for loop in range(1, 3):
			x = (iX * 2 * multiplier) + (multiplier * xPlus * loop)
			y = (iY * 2 * multiplier) + (multiplier * yPlus * loop)
			i = y*iW + x
			hillVal = hillsFrac.getHeight(x,y)
			if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
				plotTypes[i] = PlotTypes.PLOT_HILLS
			else:
				plotTypes[i] = PlotTypes.PLOT_LAND
			if multiplier == 1: pass
			else:
				for mazeX in range(x, x+multiplier):
					for mazeY in range(y, y+multiplier):
						i = mazeY*iW + mazeX
						hillVal = hillsFrac.getHeight(mazeX,mazeY)
						if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
							peakVal = peaksFrac.getHeight(mazeX,mazeY)
							if (peakVal <= iPeakThreshold):
								plotTypes[i] = PlotTypes.PLOT_PEAK
							else:
								plotTypes[i] = PlotTypes.PLOT_HILLS
						else:
							plotTypes[i] = PlotTypes.PLOT_LAND
		iX += xPlus
		iY += yPlus
	return plotTypes

class LakesFractalWorld(CvMapGeneratorUtil.FractalWorld):
	def generatePlotTypes(self, water_percent=9, shift_plot_types=True, 
	                      grain_amount=3):
		self.checkForOverrideDefaultUserInputVariances()
		self.hillsFrac.fracInit(self.iNumPlotsX, self.iNumPlotsY, grain_amount, self.mapRand, 0, self.fracXExp, self.fracYExp)
		self.peaksFrac.fracInit(self.iNumPlotsX, self.iNumPlotsY, grain_amount+1, self.mapRand, 0, self.fracXExp, self.fracYExp)
		if water_percent == 9 :
                        water_percent += self.seaLevelChange
                        water_percent = min(water_percent, 14)
                        water_percent = max(water_percent, 7)
		iWaterThreshold = self.continentsFrac.getHeightFromPercent(water_percent)
		iHillsBottom1 = self.hillsFrac.getHeightFromPercent(max((self.hillGroupOneBase - self.hillGroupOneRange), 0))
		iHillsTop1 = self.hillsFrac.getHeightFromPercent(min((self.hillGroupOneBase + self.hillGroupOneRange), 100))
		iHillsBottom2 = self.hillsFrac.getHeightFromPercent(max((self.hillGroupTwoBase - self.hillGroupTwoRange), 0))
		iHillsTop2 = self.hillsFrac.getHeightFromPercent(min((self.hillGroupTwoBase + self.hillGroupTwoRange), 100))
		iPeakThreshold = self.peaksFrac.getHeightFromPercent(self.peakPercent)
		for x in range(self.iNumPlotsX):
			for y in range(self.iNumPlotsY):
				i = y*self.iNumPlotsX + x
				if y == 0 or y == self.iNumPlotsY - 1:
					self.plotTypes[i] = PlotTypes.PLOT_OCEAN
					continue
				val = self.continentsFrac.getHeight(x,y)
				if val <= iWaterThreshold:
					self.plotTypes[i] = PlotTypes.PLOT_OCEAN
				else:
					hillVal = self.hillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						peakVal = self.peaksFrac.getHeight(x,y)
						if (peakVal <= iPeakThreshold):
							self.plotTypes[i] = PlotTypes.PLOT_PEAK
						else:
							self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		if shift_plot_types:
			self.shiftPlotTypes()
		return self.plotTypes

class IslandsMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self):
		iPlayers = self.gc.getGame().countCivPlayersEverAlive()
		userInputTinyIslands = cmo[1]
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		if userInputTinyIslands == 0: pass
		else:
			tiny_one = [[-1, -1], [92, 6], [91, 5], [85, 5]]
			[tinyWater, tinyGrain] = tiny_one[userInputTinyIslands]
			self.generatePlotsInRegion(tinyWater,
			                           self.iW, self.iH,
			                           0, 0,
			                           tinyGrain, 4,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           7, 6,
			                           True, 15,
			                           -1, False,
			                           False
			                           )
		global iExtras
		global region_coords
		global regions_in_use
		global remaining_regions
		for region_loop in range(iPlayers + iExtras):
			region_roll = getRandNum(len(remaining_regions), "FoR : Extra Islands - Islands PYTHON")
			thisRegion = remaining_regions[region_roll]
			regions_in_use.append(thisRegion)
			del remaining_regions[region_roll]
			[fWestLon, fEastLon, fSouthLat, fNorthLat] = region_coords[thisRegion]
			iWestX = int(self.iW * fWestLon)
			iEastX = int(self.iW * fEastLon) - 1
			iSouthY = int(self.iH * fSouthLat)
			iNorthY = int(self.iH * fNorthLat) -1
			iWidth = iEastX - iWestX + 1
			iHeight = iNorthY - iSouthY + 1
			thisIslandPattern = getRandNum(4, "FoR : Island Pattern - Islands PYTHON")
			if thisIslandPattern == 1:
				iOffSetX = getRandNum(int(iWidth * 0.2) + 1, "FoR : Island Offset - Islands PYTHON")
				iOffSetY = getRandNum(int(iHeight * 0.2) + 1, "FoR : Island Offset - Islands PYTHON")
				regWestX = iWestX + iOffSetX
				regSouthY = iSouthY + iOffSetY
				regWidth = int(iWidth * 0.8)
				regHeight = int(iHeight * 0.8)
			elif thisIslandPattern == 2:
				iOffSetX = getRandNum(int(iWidth * 0.37) + 1, "FoR : Island Offset - Islands PYTHON")
				iOffSetY = 0
				regWestX = iWestX + iOffSetX
				regSouthY = iSouthY + iOffSetY
				regWidth = int(iWidth * 0.63)
				regHeight = iHeight
			elif thisIslandPattern == 3:
				iOffSetX = 0
				iOffSetY = getRandNum(int(iHeight * 0.37) + 1, "FoR : Island Offset - Islands PYTHON")
				regWestX = iWestX + iOffSetX
				regSouthY = iSouthY + iOffSetY
				regWidth = iWidth
				regHeight = int(iHeight * 0.63)
			else:
				iOffSetX = int(iWidth * 0.1)
				iOffSetY = int(iHeight * 0.1)
				regWestX = iWestX + iOffSetX
				regSouthY = iSouthY + iOffSetY
				regWidth = int(iWidth * 0.8)
				regHeight = int(iHeight * 0.8)
			shore_grain = 1 + getRandNum(3, "FoR : Random Shoreline Type - Islands PYTHON")
			self.generatePlotsInRegion(55 + sea,
			                           regWidth, regHeight,
			                           regWestX, regSouthY,
			                           shore_grain, 4,
			                           self.iRoundFlags, self.iTerrainFlags,
			                           6, 6,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
			coreWestX = regWestX + int(regWidth * 0.25)
			coreEastX = coreWestX + int(regWidth * 0.5)
			coreSouthY = regSouthY + int(regHeight * 0.25)
			coreNorthY = coreSouthY + int(regHeight * 0.5)
			coreWidth = coreEastX - coreWestX + 1
			coreHeight = coreNorthY - coreSouthY + 1
			self.generatePlotsInRegion(65,
			                           coreWidth, coreHeight,
			                           coreWestX, coreSouthY,
			                           1, 3,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           5, 5,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
		return self.wholeworldPlotTypes

class ISFractalWorld(CvMapGeneratorUtil.FractalWorld):
	def generatePlotTypes(self, water_percent=78, shift_plot_types=True, 
	                      grain_amount=3):
		self.checkForOverrideDefaultUserInputVariances()
		self.hillsFrac.fracInit(self.iNumPlotsX, self.iNumPlotsY, grain_amount, self.mapRand, 0, self.fracXExp, self.fracYExp)
		self.peaksFrac.fracInit(self.iNumPlotsX, self.iNumPlotsY, grain_amount+1, self.mapRand, 0, self.fracXExp, self.fracYExp)
		water_percent += self.seaLevelChange
		water_percent = min(water_percent, self.seaLevelMax)
		water_percent = max(water_percent, self.seaLevelMin)
		iWaterThreshold = self.continentsFrac.getHeightFromPercent(water_percent)
		iHillsBottom1 = self.hillsFrac.getHeightFromPercent(max((self.hillGroupOneBase - self.hillGroupOneRange), 0))
		iHillsTop1 = self.hillsFrac.getHeightFromPercent(min((self.hillGroupOneBase + self.hillGroupOneRange), 100))
		iHillsBottom2 = self.hillsFrac.getHeightFromPercent(max((self.hillGroupTwoBase - self.hillGroupTwoRange), 0))
		iHillsTop2 = self.hillsFrac.getHeightFromPercent(min((self.hillGroupTwoBase + self.hillGroupTwoRange), 100))
		iPeakThreshold = self.peaksFrac.getHeightFromPercent(self.peakPercent)
		for x in range(self.iNumPlotsX):
			for y in range(self.iNumPlotsY):
				i = y*self.iNumPlotsX + x
				val = self.continentsFrac.getHeight(x,y)
				if val <= iWaterThreshold:
					self.plotTypes[i] = PlotTypes.PLOT_OCEAN
				else:
					hillVal = self.hillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						peakVal = self.peaksFrac.getHeight(x,y)
						if (peakVal <= iPeakThreshold):
							self.plotTypes[i] = PlotTypes.PLOT_PEAK
						else:
							self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		if shift_plot_types:
			self.shiftPlotTypes()
		return self.plotTypes

class ISHintedWorld(CvMapGeneratorUtil.HintedWorld, ISFractalWorld):
	def __doInitFractal(self):
		self.shiftHintsToMap()
		size = len(self.data)
		minExp = min(self.fracXExp, self.fracYExp)
		iGrain = None
		for i in range(minExp):
			width = (1 << (self.fracXExp - minExp + i))
			height = (1 << (self.fracYExp - minExp + i))
			if not self.iFlags & CyFractal.FracVals.FRAC_WRAP_X:
				width += 1
			if not self.iFlags & CyFractal.FracVals.FRAC_WRAP_Y:
				height += 1
			if size == width*height:
				iGrain = i
		assert(iGrain != None)
		iFlags = self.map.getMapFractalFlags()
		self.continentsFrac.fracInitHints(self.iNumPlotsX, self.iNumPlotsY, iGrain, self.mapRand, iFlags, self.data, self.fracXExp, self.fracYExp)

	def generatePlotTypes(self, water_percent=-1, shift_plot_types=False):
		for i in range(len(self.data)):
			if self.data[i] == None:
				self.data[i] = getRandNum(48, "FoR : Generate Plot Types PYTHON")
		self.__doInitFractal()
		if (water_percent == -1):
			numPlots = len(self.data)
			numWaterPlots = 0
			for val in self.data:
				if val < 192:
					numWaterPlots += 1
			water_percent = int(100*numWaterPlots/numPlots)
		return ISFractalWorld.generatePlotTypes(self, water_percent, shift_plot_types)

class HubMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generateCenter(self, iWaterPercent, 
	                   iRegionWidth, iRegionHeight, 
	                   iRegionWestX, iRegionSouthY, 
	                   iRegionGrain, iRegionHillsGrain, 
	                   iRegionPlotFlags, iRegionTerrainFlags, 
	                   iRegionFracXExp = -1, iRegionFracYExp = -1, 
	                   bShift = True, iStrip = 15, 
	                   rift_grain = -1, has_center_rift = False, 
	                   invert_heights = False):
		water = iWaterPercent
		iWestX = iRegionWestX
		iSouthY = iRegionSouthY
		self.plotTypes = []
		self.plotTypes = [PlotTypes.PLOT_OCEAN] * (iRegionWidth*iRegionHeight)
		regionContinentsFrac = CyFractal()
		regionHillsFrac = CyFractal()
		regionContinentsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionGrain, self.dice, iRegionPlotFlags, iRegionFracXExp, iRegionFracYExp)
		regionHillsFrac.fracInit(iRegionWidth, iRegionHeight, iRegionHillsGrain, self.dice, iRegionTerrainFlags, iRegionFracXExp, iRegionFracYExp)
		iWaterThreshold = regionContinentsFrac.getHeightFromPercent(water)
		iHillsBottom1 = regionHillsFrac.getHeightFromPercent(max((20 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop1 = regionHillsFrac.getHeightFromPercent(min((30 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		iHillsBottom2 = regionHillsFrac.getHeightFromPercent(max((70 - self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 0))
		iHillsTop2 = regionHillsFrac.getHeightFromPercent(min((80 + self.gc.getClimateInfo(self.map.getClimate()).getHillRange()), 100))
		for x in range(iRegionWidth):
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				val = regionContinentsFrac.getHeight(x,y)
				if val <= iWaterThreshold: pass
				else:
					hillVal = regionHillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						self.plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						self.plotTypes[i] = PlotTypes.PLOT_LAND
		if bShift:
			self.shiftRegionPlots(iRegionWidth, iRegionHeight, iStrip)
		for x in range(iRegionWidth):
			wholeworldX = x + iWestX
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				if self.plotTypes[i] == PlotTypes.PLOT_OCEAN: continue
				wholeworldY = y + iSouthY
				iWorld = wholeworldY*self.iW + wholeworldX
				self.wholeworldPlotTypes[iWorld] = self.plotTypes[i]
		return

	def generatePlotsByRegion(self, hub_type):
		iPlayers = self.gc.getGame().countCivPlayersEverAlive()
		userInputAreaType = cmo[1]
		area_grain = 3 - userInputAreaType
		userInputBufferType = cmo[2]
		buffer_one = [0, 58, 64, 70]
		bufWater = buffer_one[userInputBufferType]
		grainType = userInputBufferType
		sea = self.gc.getSeaLevelInfo(self.map.getSeaLevel()).getSeaLevelChange()
		sea = min(sea, 5)
		sea = max(sea, -5)
		bufWater += sea
		if hub_type == 1 and iPlayers < 11 and iPlayers > 1:
			global buffer_data
			for buffer_loop in range(iPlayers):
				[bufWestX, bufEastX, bufSouthY, bufNorthY] = buffer_data[buffer_loop]
				if grainType == 0:
					thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Hub PYTHON")
					bufWater = sea + buffer_one[thisBuffer]
					bufGrain = thisBuffer + 1
				else:
					bufGrain = grainType + 1
				bufWidth = bufEastX - bufWestX + 1
				bufHeight = bufNorthY - bufSouthY + 1
				self.generatePlotsInRegion(bufWater,
				                           bufWidth, bufHeight,
				                           bufWestX, bufSouthY,
				                           bufGrain, 3,
				                           self.iRoundFlags, self.iTerrainFlags,
				                           6, 6,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		else: pass
		global region_data
		for region_loop in range(iPlayers):
			[regWestX, regEastX, regSouthY, regNorthY] = region_data[region_loop]
			regWidth = regEastX - regWestX + 1
			regHeight = regNorthY - regSouthY + 1
			self.generatePlotsInRegion(55 + sea,
			                           regWidth, regHeight,
			                           regWestX, regSouthY,
			                           area_grain, 4,
			                           self.iRoundFlags, self.iTerrainFlags,
			                           6, 6,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
			coreWestX = regWestX + int(regWidth * 0.25)
			coreEastX = regEastX - int(regWidth * 0.25)
			coreSouthY = regSouthY + int(regHeight * 0.25)
			coreNorthY = regNorthY - int(regHeight * 0.25)
			coreWidth = coreEastX - coreWestX + 1
			coreHeight = coreNorthY - coreSouthY + 1
			self.generatePlotsInRegion(65,
			                           coreWidth, coreHeight,
			                           coreWestX, coreSouthY,
			                           1, 3,
			                           self.iHorzFlags, self.iTerrainFlags,
			                           5, 5,
			                           True, 3,
			                           -1, False,
			                           False
			                           )
		global hub_data
		linewidth = 1 + cmo[3]
		iWH = self.iW * self.iH
		offsetstart = 0 - int(linewidth/2)
		offsetrange = range(offsetstart, offsetstart + linewidth)
		for hub_loop in range(len(hub_data)):
			[startx, starty, endx, endy] = hub_data[hub_loop]
			if abs(endy-starty) < abs(endx-startx):
				if startx > endx:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx = endx-startx
				dy = endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dy)/float(dx)
				y = starty
				for x in range(startx, endx+1):
					for offset in offsetrange:
						if map.isPlot(x, int(round(y+offset))):
							i = map.plotNum(x, int(round(y+offset)))
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					y += slope
			else:
				if starty > endy:
					startx, starty, endx, endy = endx, endy, startx, starty
				dx, dy = endx-startx, endy-starty
				if dx == 0 or dy == 0:
					slope = 0
				else:
					slope = float(dx)/float(dy)
				x = startx
				for y in range(starty, endy+1):
					for offset in offsetrange:
						if map.isPlot(int(round(x+offset)), y):
							i = map.plotNum(int(round(x+offset)), y)
							self.wholeworldPlotTypes[i] = PlotTypes.PLOT_LAND
					x += slope
		global center_data
		[cenWestX, cenEastX, cenSouthY, cenNorthY] = center_data
		cenWidth = cenEastX - cenWestX + 1
		cenHeight = cenNorthY - cenSouthY + 1
		if grainType == 0:
			thisBuffer = 1 + getRandNum(3, "FoR : Random Buffer Type - Hub PYTHON")
			bufWater = sea + buffer_one[thisBuffer]
			bufGrain = thisBuffer + 1
		else:
			bufGrain = grainType + 1
		self.generateCenter(bufWater,
		                    cenWidth, cenHeight,
		                    cenWestX, cenSouthY,
		                    bufGrain, 4,
		                    self.iRoundFlags, self.iTerrainFlags,
		                    -1, -1,
		                    True, 5,
		                    -1, False,
		                    False
		                    )
		return self.wholeworldPlotTypes

class ArchipelagoFractalWorld(CvMapGeneratorUtil.FractalWorld):
	def checkForOverrideDefaultUserInputVariances(self):
		extraPeaks = 1 + cmo[0]
		self.peakPercent = min(100, self.peakPercent + (15 * extraPeaks))
		self.peakPercent = max(0, self.peakPercent)
		return

class CCMultilayeredFractal(CvMapGeneratorUtil.MultilayeredFractal):
	def generatePlotsByRegion(self):
		global xShiftRoll, yShiftRoll
		userInputContinents = cmo[0]
		defaultWater = [55, 60, 65, 70, 75, 80, 85]
		numTinies = 1 + getRandNum(4, "FoR : Tiny Islands - Custom Continents PYTHON")
		if numTinies:
			for tiny_loop in range(numTinies):
				tinyWestLon = 0.01 * getRandNum(85, "FoR : Tiny Longitude - Custom Continents PYTHON")
				tinyWestX = int(self.iW * tinyWestLon)
				tinySouthLat = 0.01 * getRandNum(85, "FoR : Tiny Latitude - Custom Continents PYTHON")
				tinySouthY = int(self.iH * tinyWestLon)
				tinyWidth = int(self.iW * 0.15)
				tinyHeight = int(self.iH * 0.15)
				self.generatePlotsInRegion(80,
				                           tinyWidth, tinyHeight,
				                           tinyWestX, tinySouthY,
				                           4, 3,
				                           0, self.iTerrainFlags,
				                           6, 5,
				                           True, 3,
				                           -1, False,
				                           False
				                           )
		global iNumConts
		global cont_data
		for continent_loop in range(iNumConts):
			iNumLayers = cont_data[continent_loop][0]
			for region_loop in range(1, (iNumLayers + 1)):
				[fWestLon, fEastLon, fSouthLat, fNorthLat, horzVar, vertVar, bFlagX, bFlagY, iWater, iGrain, flagID, xExp, yExp, iShift] = cont_data[continent_loop][region_loop]
				iWestX = int(self.iW * fWestLon)
				iEastX = int(self.iW * fEastLon) - 1
				iSouthY = int(self.iH * fSouthLat)
				iNorthY = int(self.iH * fNorthLat) -1
				iWidth = iEastX - iWestX + 1
				iHeight = iNorthY - iSouthY + 1
				if horzVar != 0:
					xVar = int(self.iW * horzVar)
					if bFlagX:
						xShift = getRandNum(xVar, "FoR : Region Shift, Horizontal - Custom Continents PYTHON")
					else:
						if xShiftRoll:
							xShift = xVar
						else:
							xShift = 0
					iWestX += xShift
				if vertVar != 0:
					yVar = int(self.iH * vertVar)
					if bFlagY:
						yShift = getRandNum(yVar, "FoR : Region Shift, Vertical - Custom Continents PYTHON")
					else:
						if yShiftRoll:
							yShift = yVar
						else:
							yShift = 0
					iSouthY += yShift
				if iGrain > 0 and iGrain < 7: pass
				elif iGrain == 12:
					grainRoll = getRandNum(2, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 1
				elif iGrain == 13:
					grainRoll = getRandNum(3, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 1
				elif iGrain == 14:
					grainRoll = getRandNum(4, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 1
				elif iGrain == 23:
					grainRoll = getRandNum(2, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 2
				elif iGrain == 24:
					grainRoll = getRandNum(3, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 2
				elif iGrain == 34:
					grainRoll = getRandNum(2, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 3
				elif iGrain == 35:
					grainRoll = getRandNum(3, "FoR : Random Grain - Custom Continents PYTHON")
					iGrain = grainRoll + 3
				else:
					iGrain = 2
				if iWater == -1:
					iWater = defaultWater[iGrain]
				if flagID == 0:
					iFlags = 0
				elif flagID == 1:
					iFlags = self.iHorzFlags
				elif flagID == 2:
					iFlags = self.iVertFlags
				elif flagID == 3:
					iFlags = self.iRoundFlags
				else:
					iFlags = 0

				self.generatePlotsInRegion(iWater,
				                           iWidth, iHeight,
				                           iWestX, iSouthY,
				                           iGrain, 4,
				                           iFlags, self.iTerrainFlags,
				                           xExp, yExp,
				                           True, iShift,
				                           -1, False,
				                           False
				                           )
		return self.wholeworldPlotTypes

def generateTerrainTypes():
        # don't do any river in the first pass
        global canAddRivers
        canAddRivers = False
        
	NiTextOut("Generating Terrain (Full of resources) ...")
        try :
                writeLog(" = generateTerrainTypes = ", False, [""])

                # pangaea final plot generation
                if idMap == "pangaea" :
                        generatePangaeaTerrainTypes()

                # terrrain generation
                terrainDesert = gc.getInfoTypeForString('TERRAIN_DESERT')
                terrainPlains = gc.getInfoTypeForString('TERRAIN_PLAINS')
                terrainSnow = gc.getInfoTypeForString('TERRAIN_SNOW')
                terrainTundra = gc.getInfoTypeForString('TERRAIN_TUNDRA')
                terrainGrass = gc.getInfoTypeForString('TERRAIN_GRASS')
                userInputGrass = getRandSel(selGen["terrain"]["terrains"]["grass"])
                userInputPlain = getRandSel(selGen["terrain"]["terrains"]["plains"])
                userInputDesert = getRandSel(selGen["terrain"]["terrains"]["desert"])
                userInputTundra = getRandSel(selGen["terrain"]["terrains"]["tundra"])
                userInputSnow = getRandSel(selGen["terrain"]["terrains"]["snow"])

                #debug
                logList = []
                logList.append(" userInputGrass : %r" %userInputGrass)
                logList.append(" userInputPlain : %r" %userInputPlain)
                logList.append(" userInputDesert : %r" %userInputDesert)
                logList.append(" userInputTundra : %r" %userInputTundra)
                logList.append(" userInputSnow : %r" %userInputSnow)
                logList.append("")
                writeLog("", False, logList)

                if idMap in ["archipelago", "continents", "customcontinents", "fractals", "islands", "lakes", "maze", "pangaea", "shuffle", "terra", "chess", "bigandsmall", "hemispheres", "mediumandsmall"] :
                        snowLatitude = min(1.0, 0.9 - userInputSnow*0.093 + 0.016*(userInputDesert + userInputGrass + userInputPlain) )
                        tundraLatitude = max(0.5, min(snowLatitude - 0.1, snowLatitude - userInputTundra*0.05 + 0.01*(userInputDesert + userInputGrass + userInputPlain)))
                        grassLatitude = min(0.25, 0.1 + userInputGrass*0.6 - userInputDesert*0.2)
                        amp = (tundraLatitude - grassLatitude)
                        botDesertLatitude = grassLatitude + min(amp/2, amp*0.13*(4 - userInputDesert))
                        topDesertLatitude = tundraLatitude - min(amp/2,amp*0.13*(4 - userInputDesert))
                        desertPer = max(0, min(60, int(userInputDesert*12.5 - (userInputPlain + userInputGrass)*1.25)))
                        plainsPer = 8 + userInputPlain*12
                        grain = 4

                        #debug
                        logList = []
                        logList.append(" snowLatitude : %r" %snowLatitude)
                        logList.append(" tundraLatitude : %r" %tundraLatitude)
                        logList.append(" grassLatitude : %r" %grassLatitude)
                        logList.append(" botDesertLatitude : %r" %botDesertLatitude)
                        logList.append(" topDesertLatitude : %r" %topDesertLatitude)
                        logList.append(" desertPer : %r" %desertPer)
                        logList.append(" plainsPer : %r" %plainsPer)
                        logList.append(" grain : %r" %grain)
                        logList.append("")
                        writeLog("", False, logList)

                        terraingen = TerrainGenerator(desertPer, plainsPer, snowLatitude, tundraLatitude, grassLatitude, botDesertLatitude, topDesertLatitude, -1, -1, grain)
                elif idMap == "inlandsea" : #the same as normal gen , should change with tests ...
                        snowLatitude = min(1.0, 0.9 - userInputSnow*0.093 + 0.016*(userInputDesert + userInputGrass + userInputPlain) )
                        tundraLatitude = max(0.5, min(snowLatitude - 0.1, snowLatitude - userInputTundra*0.05 + 0.01*(userInputDesert + userInputGrass + userInputPlain)))
                        grassLatitude = min(0.25, 0.1 + userInputGrass*0.6 - userInputDesert*0.2)
                        amp = (tundraLatitude - grassLatitude)
                        botDesertLatitude = grassLatitude + min(amp/2, amp*0.13*(4 - userInputDesert))
                        topDesertLatitude = tundraLatitude - min(amp/2,amp*0.13*(4 - userInputDesert))
                        desertPer = max(0, min(60, int(userInputDesert*12.5 - (userInputPlain + userInputGrass)*1.25)))
                        plainsPer = 8 + userInputPlain*12
                        grain = 4

                        #debug
                        logList = []
                        logList.append(" snowLatitude : %r" %snowLatitude)
                        logList.append(" tundraLatitude : %r" %tundraLatitude)
                        logList.append(" grassLatitude : %r" %grassLatitude)
                        logList.append(" botDesertLatitude : %r" %botDesertLatitude)
                        logList.append(" topDesertLatitude : %r" %topDesertLatitude)
                        logList.append(" desertPer : %r" %desertPer)
                        logList.append(" plainsPer : %r" %plainsPer)
                        logList.append(" grain : %r" %grain)
                        logList.append("")
                        writeLog("", False, logList)

                        terraingen = ISTerrainGenerator(desertPer, plainsPer, snowLatitude, tundraLatitude, grassLatitude, botDesertLatitude, topDesertLatitude, -1, -1, grain)
                elif idMap in ["hub", "ring", "wheel"] :
                        desertPer = 7*userInputDesert + 3 - (userInputGrass*4)
                        plainsPer = 10*userInputPlain + 18 - (userInputGrass*3)
                        icePer = 8 + 14*userInputSnow
                        tundraPer = 2 + 11*userInputTundra
                        grain = 5

                        #debug
                        logList = []
                        logList.append(" desertPer : %r" %desertPer)
                        logList.append(" plainsPer : %r" %plainsPer)
                        logList.append(" icePer : %r" %icePer)
                        logList.append(" tundraPer : %r" %tundraPer)
                        logList.append(" grain : %r" %grain)
                        logList.append("")
                        writeLog("", False, logList)

                        terraingen = HubTerrainGenerator(desertPer, plainsPer, icePer, tundraPer, -1, -1, grain)
                elif idMap == "tectonics" :
                        terraingen = ClimateGenerator()

                terrainTypes = terraingen.generateTerrain()

                # terrain replacement if none of the designed terrain should appear
                terrainRepSnow = terrainSnow
                terrainRepTundra = terrainTundra
                terrainRepDesert = terrainDesert
                if userInputDesert == 0 :
                        terrainRepDesert = terrainPlains
                if userInputSnow == 0 :
                        if userInputTundra == 0 :
                                terrainRepSnow = terrainPlains
                                terrainRepTundra = terrainGrass
                        else :
                                terrainRepSnow = terrainTundra
                elif userInputTundra == 0 :
                        terrainRepTundra = terrainPlains

                if (userInputSnow == 0) or (userInputTundra == 0) or (userInputDesert == 0) :
                        for iIndex in range(iW*iH) :
                                if terrainTypes[iIndex] == terrainSnow :
                                        terrainTypes[iIndex] = terrainRepSnow
                                elif terrainTypes[iIndex] == terrainTundra :
                                        terrainTypes[iIndex] = terrainRepTundra
                                elif terrainTypes[iIndex] == terrainDesert :
                                        terrainTypes[iIndex] = terrainRepDesert

                writeLog("", True, ["", " terrain generation completed ..."])

                return terrainTypes
        except :
                writeLog("", True, ["", " An error occured during terrain generation ... default generation"])
                writeError()
                terraingen = TerrainGenerator()
                terrainTypes = terraingen.generateTerrain()
                return terrainTypes

class ClimateGenerator:
	def __init__(self):
		self.climate = cmo[1]
		self.map = gc.getMap()
		self.mapWidth = self.map.getGridWidth()
		if (self.climate == 0):                          # Arid
			self.maxWindForce = self.mapWidth / 12
		elif (self.climate == 1):                        # Normal
			self.maxWindForce = self.mapWidth / 8
		elif (self.climate == 2):                        # Wet
			self.maxWindForce = self.mapWidth / 6
		elif (self.climate == 3):                        # No ice
			self.maxWindForce = self.mapWidth / 8
		self.mapHeight = self.map.getGridHeight()
		self.terrainDesert = gc.getInfoTypeForString("TERRAIN_DESERT")
		self.terrainPlains = gc.getInfoTypeForString("TERRAIN_PLAINS")
		self.terrainIce = gc.getInfoTypeForString("TERRAIN_SNOW")
		self.terrainTundra = gc.getInfoTypeForString("TERRAIN_TUNDRA")
		self.terrainGrass = gc.getInfoTypeForString("TERRAIN_GRASS")
		if (self.climate == 3):                        # No ice
			self.terrainIce = gc.getInfoTypeForString("TERRAIN_TUNDRA")
			self.terrainTundra = gc.getInfoTypeForString("TERRAIN_GRASS")
		self.terrain = [0] * (self.mapWidth*self.mapHeight)
		self.moisture = [0] * (self.mapWidth*self.mapHeight)
		self.dice = gc.getGame().getMapRand()

	def getLatitudeAtPlot(self, iX, iY):
		"returns a value in the range of 0-90 degrees"
		if (cmo[0] == 5):         #  "Mediterranean"
			return 65 - (40 * (self.mapHeight - iY) / self.mapHeight)
		return self.map.plot(iX,iY).getLatitude()

	def generateTerrain(self):
		self.blowWinds()
		self.blur()
		self.computeTerrain()
		return self.terrain

	def computeTerrain(self):
		terrain = [0] * (self.mapWidth*self.mapHeight)
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				if (self.map.plot(x,y).isWater()):
					self.terrain[y*self.mapWidth+x] = self.map.plot(x,y).getTerrainType()
				else:
					terrain[y*self.mapWidth+x] = self.getTerrain(self.getLatitudeAtPlot(x,y),self.moisture[y*self.mapWidth + x])
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				if (not self.map.plot(x,y).isWater()):
					i = y*self.mapWidth+x
					self.terrain[i] = terrain[i]
					bias = self.dice.get(3,"Random terrain")
					if bias == 0 and y > 1:
						self.terrain[i] = terrain[i-self.mapWidth]
					if bias == 2 and y < self.mapHeight - 1:
						self.terrain[i] = terrain[i+self.mapWidth]
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				if (not self.map.plot(x,y).isWater()):
					i = y*self.mapWidth+x
					if self.terrain[i] == self.terrainDesert:
						if y > 1 and y < self.mapHeight - 1:
							if self.terrain[i-self.mapWidth] == self.terrainGrass:
								self.terrain[i-self.mapWidth] = self.terrainPlains
							if self.terrain[i+self.mapWidth] == self.terrainGrass:
								self.terrain[i+self.mapWidth] = self.terrainPlains
							if self.terrain[i-1] == self.terrainGrass:
								self.terrain[i-1] = self.terrainPlains
							if self.terrain[i+1] == self.terrainGrass:
								self.terrain[i+1] = self.terrainPlains
					
	def getArcticTerrain(self, climate, latitude, moisture):
		polar = 0
		if (latitude > 70):
			polar = latitude - 70
			climate.ice += polar * polar * 3
			climate.tundra += polar * (2 + moisture)

	def getColdTerrain(self, climate, latitude, moisture):
		if (latitude > 60):
			polar = latitude - 60
			climate.tundra += polar * (5 + moisture) + self.dice.get(polar*3,"more tundra")
			if (moisture > 10):
				climate.plains += polar * (moisture - 10)

	def getTemperateTerrain(self, climate, latitude, moisture):
		temperate = 45 - abs(45 - latitude)
		climate.plains += temperate * (3 + moisture/2)
		climate.grass += temperate * (1 + moisture) + self.dice.get(temperate,"more grass")

	def getTropicalTerrain(self, climate, latitude, moisture):
		tropical = 0
		if (latitude < 40):
			tropical = 20 - abs(20 - latitude)
		climate.plains += tropical * (12 - self.climate + moisture/2) + self.dice.get(tropical,"more plains")
		climate.grass += tropical * (moisture + self.climate)
		climate.desert += tropical * (4 - self.climate) * 6

	def getEquatorialTerrain(self, climate, latitude, moisture):
		equator = 0
		if (latitude < 25):
			equator = 25 - latitude
		climate.plains += equator * 7
		climate.grass += equator * (3 + moisture) + self.dice.get(equator,"more grass")

	#I compute latitude as in the maputil but wtf is there a plot.latitude then?
	def getTerrain(self, latitude, moisture):
		class climates:
			def __init__(self):
				self.ice = 0
				self.tundra = 0
				self.plains = 0
				self.grass = 0
				self.desert = 0

		climate = climates()
		self.getArcticTerrain(climate, latitude, moisture)
		self.getColdTerrain(climate, latitude, moisture)
		self.getTemperateTerrain(climate, latitude, moisture)
		self.getTropicalTerrain(climate, latitude, moisture)
		self.getEquatorialTerrain(climate, latitude, moisture)

		if (climate.ice >= climate.tundra) and (climate.ice >= climate.plains) and (climate.ice >= climate.grass) and (climate.ice >= climate.desert):
			return self.terrainIce
		if (climate.tundra >= climate.plains) and (climate.tundra >= climate.grass) and (climate.tundra >= climate.desert):
			return self.terrainTundra
		if (climate.plains >= climate.grass) and (climate.plains >= climate.desert):
			return self.terrainPlains
		if (climate.grass >= climate.desert):
			return self.terrainGrass
		return self.terrainDesert

	def blowWinds(self):
	#Must find where the wind blows from and add moisture from there.
	#If there is a mountain in between, then terrain must become more arid:
	# Tundra -> ice (mmmh?), and grass -> plain -> desert.
		for x in range(self.mapWidth):
			for y in range(self.mapHeight):
				if (self.map.plot(x,y).isWater()):
					self.windBlowsFrom(x,y)

	def windBlowsFrom(self,x,y):
		latitude = self.getLatitudeAtPlot(x,y)
		horizontal = 0
		if (latitude > 80):
			horizontal = 1
		elif (latitude > 45):
			horizontal = -1
		elif (latitude > 30):
			horizontal = 1
		elif (latitude > 10):
			horizontal = -1
		else:
			horizontal = 1
		vertical = self.getVerticalWind(latitude,y)
		windForce = 1 + self.dice.get(self.maxWindForce,"Wind force")
		localMoisture = 5 + self.maxWindForce
		self.blow(localMoisture,windForce,horizontal,vertical,x,y)

	def getVerticalWind(self,latitude,y):
		if (latitude>70):
			vertical = -1
		elif (latitude>30):
			vertical = 1
		else:
			vertical = -1
		if (2*y < self.mapHeight):
			vertical *= -1
		return vertical

	def blow(self,localMoisture,maxHorizontal,horizontal,vertical,x,y):
		plotType = self.map.plot(x,y).getPlotType()
		if (y+vertical > 0 and y+vertical < self.mapHeight):
			if (plotType != PlotTypes.PLOT_PEAK):
				if (plotType == PlotTypes.PLOT_HILLS):
					self.blow(localMoisture - 7,maxHorizontal-2,horizontal,vertical,x,y+vertical)
				else:
					self.blow(localMoisture - 1,maxHorizontal-2,horizontal,vertical,x,y+vertical)
		for i in range(-1,maxHorizontal):
			adjustedX = x + i*horizontal
			if (adjustedX < 0):
				adjustedX += self.mapWidth
			elif (adjustedX >= self.mapWidth):
				adjustedX -= self.mapWidth
			self.moisture[y*self.mapWidth + adjustedX] = self.moisture[y*self.mapWidth + adjustedX] + localMoisture
			plotType = self.map.plot(adjustedX,y).getPlotType()
			if (plotType == PlotTypes.PLOT_PEAK):
				return
			elif (plotType == PlotTypes.PLOT_HILLS):
				localMoisture -= 7
			else:
				localMoisture -= 1
			if (localMoisture <= 0):
				return

	def blur(self):
		max = 1
		for y in range(self.mapHeight):
			for x in range(self.mapWidth):
				i = y*self.mapWidth + x
				if (max < self.moisture[i]):
					max = self.moisture[i]
		for y in range(1,self.mapHeight-2):
			for x in range(self.mapWidth):
				i = y*self.mapWidth + x
				self.moisture[i] = self.moisture[i]*100/max

class ISTerrainGenerator(CvMapGeneratorUtil.TerrainGenerator):
	def getLatitudeAtPlot(self, iX, iY):
		lat = CvMapGeneratorUtil.TerrainGenerator.getLatitudeAtPlot(self, iX, iY)
		lat = 0.07 + 0.56*lat
		return lat

class HubTerrainGenerator(CvMapGeneratorUtil.TerrainGenerator):
	def __init__(self, iDesertPercent=20, iPlainsPercent=25,
	             iIcePercent=50, iTundraPercent=35,
	             fracXExp=-1, fracYExp=-1, grain_amount=5):
		self.gc = CyGlobalContext()
		self.map = CyMap()
		global center_data
		[self.cenWestX, self.cenEastX, self.cenSouthY, self.cenNorthY] = center_data
		grain_amount += self.gc.getWorldInfo(self.map.getWorldSize()).getTerrainGrainChange()
		self.grain_amount = grain_amount
		self.iWidth = self.map.getGridWidth()
		self.iHeight = self.map.getGridHeight()
		self.mapRand = self.gc.getGame().getMapRand()
		self.iFlags = 0
		if self.map.isWrapX(): self.iFlags += CyFractal.FracVals.FRAC_WRAP_X
		if self.map.isWrapY(): self.iFlags += CyFractal.FracVals.FRAC_WRAP_Y
		self.main=CyFractal()
		self.center=CyFractal()
		iDesertPercent += self.gc.getClimateInfo(self.map.getClimate()).getDesertPercentChange()
		if self.gc.getClimateInfo(self.map.getClimate()).getRandIceLatitude() > 0.25:
			iIcePercent += 10
			iTundraPercent += 5
			iPlainsPercent += 25
		if self.gc.getClimateInfo(self.map.getClimate()).getJungleLatitude() < 5:
			iIcePercent = 15
			iTundraPercent = 20
		self.iDesertBottomPercent = 100 - iDesertPercent
		self.iPlainsBottomPercent = self.iDesertBottomPercent - iPlainsPercent
		self.iIceBottomPercent = 100 - iIcePercent
		self.iTundraBottomPercent = self.iIceBottomPercent - iTundraPercent
		self.fracXExp = fracXExp
		self.fracYExp = fracYExp
		self.initFractals()
		
	def initFractals(self):
		self.main.fracInit(self.iWidth, self.iHeight, self.grain_amount, self.mapRand, self.iFlags, self.fracXExp, self.fracYExp)
		self.iDesertBottom = self.main.getHeightFromPercent(self.iDesertBottomPercent)
		self.iPlainsBottom = self.main.getHeightFromPercent(self.iPlainsBottomPercent)
		self.center.fracInit(self.iWidth, self.iHeight, self.grain_amount, self.mapRand, self.iFlags, self.fracXExp, self.fracYExp)
		self.iIceBottom = self.center.getHeightFromPercent(self.iIceBottomPercent)
		self.iTundraBottom = self.center.getHeightFromPercent(self.iTundraBottomPercent)
		self.terrainDesert = self.gc.getInfoTypeForString("TERRAIN_DESERT")
		self.terrainPlains = self.gc.getInfoTypeForString("TERRAIN_PLAINS")
		self.terrainIce = self.gc.getInfoTypeForString("TERRAIN_SNOW")
		self.terrainTundra = self.gc.getInfoTypeForString("TERRAIN_TUNDRA")
		self.terrainGrass = self.gc.getInfoTypeForString("TERRAIN_GRASS")

	def generateTerrainAtPlot(self,iX,iY):
		if (self.map.plot(iX, iY).isWater()):
			return self.map.plot(iX, iY).getTerrainType()
		if ((iX >= self.cenWestX and iX <= self.cenEastX) and (iY >= self.cenSouthY and iY <= self.cenNorthY)):
			val = self.center.getHeight(iX, iY)
			if val >= self.iIceBottom:
				terrainVal = self.terrainIce
			elif val >= self.iTundraBottom:
				terrainVal = self.terrainTundra
			else:
				terrainVal = self.terrainPlains
		else:
			val = self.main.getHeight(iX, iY)
			if val >= self.iDesertBottom:
				terrainVal = self.terrainDesert
			elif val >= self.iPlainsBottom:
				terrainVal = self.terrainPlains
			else:
				terrainVal = self.terrainGrass
		if (terrainVal == TerrainTypes.NO_TERRAIN):
			return self.map.plot(iX, iY).getTerrainType()
		return terrainVal

def generatePangaeaTerrainTypes():
	iHorzFlags = CyFractal.FracVals.FRAC_WRAP_X + CyFractal.FracVals.FRAC_POLAR
	biggest_area = map.findBiggestArea(false)
	global terrainRoll
	userInputShoreline = cmo[0]
	iTotalLandPlots = map.getLandPlots()
	iBiggestAreaPlots = biggest_area.getNumTiles()
	if (userInputShoreline == 1 or userInputShoreline == 2 or (userInputShoreline == 0 and terrainRoll < 7)) and iBiggestAreaPlots < 0.8 * iTotalLandPlots:
		global pangaea_type
		iWestX = int(0.3 * iW)
		eastX = int(0.7 * iW)
		southLat = 0.4
		northLat = 0.6
		if pangaea_type == 0:
			global shiftRoll
			if shiftRoll == 1:
				southLat += 0.075
				northLat += 0.075
			else:
				southLat -= 0.075
				northLat -= 0.075
		elif pangaea_type == 2:
			global polarShiftRoll
			if polarShiftRoll == 1:
				southLat += 0.175
				northLat += 0.175
			else:
				southLat -= 0.175
				northLat -= 0.175
		else:
			pass
		iSouthY = int(southLat * iH)
		northY = int(northLat * iH)
		iRegionWidth = eastX - iWestX + 1
		iRegionHeight = northY - iSouthY + 1
		plotTypes = []
		plotTypes = [PlotTypes.PLOT_OCEAN] * (iRegionWidth*iRegionHeight)
		regionContinentsFrac = CyFractal()
		regionHillsFrac = CyFractal()
		regionPeaksFrac = CyFractal()
		regionContinentsFrac.fracInit(iRegionWidth, iRegionHeight, 1, dice, iHorzFlags, 7, 5)
		regionHillsFrac.fracInit(iRegionWidth, iRegionHeight, 3, dice, iHorzFlags, 7, 5)
		regionPeaksFrac.fracInit(iRegionWidth, iRegionHeight, 4, dice, iHorzFlags, 7, 5)
		iWaterThreshold = regionContinentsFrac.getHeightFromPercent(40)
		iHillsBottom1 = regionHillsFrac.getHeightFromPercent(20)
		iHillsTop1 = regionHillsFrac.getHeightFromPercent(30)
		iHillsBottom2 = regionHillsFrac.getHeightFromPercent(70)
		iHillsTop2 = regionHillsFrac.getHeightFromPercent(80)
		iPeakThreshold = regionPeaksFrac.getHeightFromPercent(25)
		for x in range(iRegionWidth):
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				val = regionContinentsFrac.getHeight(x,y)
				if val <= iWaterThreshold: pass
				else:
					hillVal = regionHillsFrac.getHeight(x,y)
					if ((hillVal >= iHillsBottom1 and hillVal <= iHillsTop1) or (hillVal >= iHillsBottom2 and hillVal <= iHillsTop2)):
						peakVal = regionPeaksFrac.getHeight(x,y)
						if (peakVal <= iPeakThreshold):
							plotTypes[i] = PlotTypes.PLOT_PEAK
						else:
							plotTypes[i] = PlotTypes.PLOT_HILLS
					else:
						plotTypes[i] = PlotTypes.PLOT_LAND
		for x in range(iRegionWidth):
			wholeworldX = x + iWestX
			for y in range(iRegionHeight):
				i = y*iRegionWidth + x
				if plotTypes[i] == PlotTypes.PLOT_OCEAN: continue
				wholeworldY = y + iSouthY
				iWorld = wholeworldY*iW + wholeworldX
				pPlot = map.plotByIndex(iWorld)
				if pPlot.isWater():
					pPlot.setPlotType(plotTypes[i], True, True)

                # remove peak along the coast for pangaea
                if (selGen["terrain"]["peak"]["peakcoast"]) :
                        for plotIndex in range(iW * iH):
                                pPlot = map.plotByIndex(plotIndex)
                                if pPlot.isPeak() :
                                        if pPlot.isCoastalLand() :
                                                pPlot.setPlotType(PlotTypes.PLOT_HILLS, True, True)

		map.recalculateAreas()

def getRiverStartCardinalDirection(argsList):
	if idMap != "inlandsea" :
                CyPythonMgr().allowDefaultImpl()
                return
	pPlot = argsList[0]
	if (pPlot.getY() > ((iH * 2) / 3)):
		return CardinalDirectionTypes.CARDINALDIRECTION_SOUTH

	if (pPlot.getY() < (iH / 3)):
		return CardinalDirectionTypes.CARDINALDIRECTION_NORTH

	if (pPlot.getX() > (iW / 2)):
		return CardinalDirectionTypes.CARDINALDIRECTION_WEST

	return CardinalDirectionTypes.CARDINALDIRECTION_EAST

def getRiverAltitude(argsList):
	if idMap != "inlandsea" :
                CyPythonMgr().allowDefaultImpl()
                return
	pPlot = argsList[0]
	CyPythonMgr().allowDefaultImpl()
	return ((abs(pPlot.getX() - (iW / 2)) + abs(pPlot.getY() - (iH / 2))) * 20)

def addRivers():
	if idMap != "chess" :
                if canAddRivers :
                        CyPythonMgr().allowDefaultImpl()
                        return
                else :
                        return None

        if not bSuccessFlag :
                if canAddRivers :
                        CyPythonMgr().allowDefaultImpl()
                        return
                else :
                        return None

        addChessRivers()
        return None

def addChessRivers():
        try :
                lar=iW/6
                hau=iH/6
                C_EAST = CardinalDirectionTypes.CARDINALDIRECTION_EAST
                C_SOUTH = CardinalDirectionTypes.CARDINALDIRECTION_SOUTH
                C_NORTH = CardinalDirectionTypes.CARDINALDIRECTION_NORTH
                C_WEST = CardinalDirectionTypes.CARDINALDIRECTION_WEST
                if userInputBorder == 3 :
                        C_EAST = CardinalDirectionTypes.CARDINALDIRECTION_WEST
                        C_SOUTH = CardinalDirectionTypes.CARDINALDIRECTION_NORTH
                        C_NORTH = CardinalDirectionTypes.CARDINALDIRECTION_SOUTH
                        C_WEST = CardinalDirectionTypes.CARDINALDIRECTION_EAST

                def setRiver(loc, x, y, card, rid) :
                        pPlot = map.plot(iX*6+x, iY*6+y)
                        if loc == "N" : pPlot.setNOfRiver(True, card)
                        elif loc == "W" : pPlot.setWOfRiver(True, card)
                        pPlot.setRiverID(rid)

                def setRID(x, y, rid) :
                        pPlot = map.plot(iX*6+x, iY*6+y)
                        pPlot.setRiverID(rid)

                for iX in range(lar) :
                        for iY in range(hau) :
                                idRiver = map.getNextRiverID()
                                map.incrementNextRiverID()
                                if (chessLakes[(iX-1)%lar][2*iY+1] == 0) and (chessLakes[iX][(2*iY+2)%(2*hau)] == 0) :
                                        lPlot = [("N", 2, 4, C_EAST), ("W", 1, 4, C_SOUTH), ("W", 2, 3, C_SOUTH), ("W", 2, 2, C_SOUTH)]
                                        for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                if (chessLakes[(iX-1)%lar][2*iY+1] == 0) and (chessLakes[iX][2*iY] == 0) :
                                        lPlot = [("N", 1, 1, C_EAST), ("N", 2, 2, C_EAST), ("N", 3, 2, C_EAST), ("W", 1, 1, C_NORTH)]
                                        for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                        setRID(2, 1, idRiver)
                                if (chessLakes[iX][2*iY] == 0) and (chessLakes[iX][2*iY+1] == 0) :
                                        lPlot = [("N", 4, 1, C_WEST), ("W", 4, 0, C_NORTH), ("W", 3, 1, C_NORTH), ("W", 3, 2, C_NORTH)]
                                        for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                if (chessLakes[iX][2*iY+1] == 0) and (chessLakes[iX][(2*iY+2)%(2*hau)] == 0) :
                                        lPlot = [("N", 5, 4, C_WEST), ("N", 4, 3, C_WEST), ("N", 3, 3, C_WEST), ("W", 4, 3, C_SOUTH)]
                                        for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                        setRID(5, 3, idRiver)
                                if userInputBorder != 3 :
                                        if (chessLakes[iX][(2*iY+2)%(2*hau)] == 0) and (chessLakes[(iX-1)%lar][2*iY+1] == 1) :
                                                lPlot = [("W", 2, 4, C_SOUTH), ("N", 3, 4, C_EAST), ("W", 3, 3, C_SOUTH)]
                                                for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                        if (chessLakes[(iX-1)%lar][2*iY+1] == 0) and (chessLakes[iX][2*iY] == 1) :
                                                lPlot = [("N", 1, 2, C_EAST), ("W", 1, 2, C_NORTH), ("N", 2, 3, C_EAST)]
                                                for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                                setRID(2, 2, idRiver)
                                        if (chessLakes[iX][2*iY] == 0) and (chessLakes[iX][2*iY+1] == 1) :
                                                lPlot = [("W", 3, 0, C_NORTH), ("N", 3, 1, C_WEST), ("W", 2, 1, C_NORTH)]
                                                for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                        if (chessLakes[iX][2*iY+1] == 0) and (chessLakes[iX][(2*iY+2)%(2*hau)] == 1) :
                                                lPlot = [("N", 5, 3, C_WEST), ("W", 4, 2, C_SOUTH), ("N", 4, 2, C_WEST)]
                                                for sLoc, dX, dY, iCard in lPlot : setRiver(sLoc, dX, dY, iCard, idRiver)
                                                setRID(5, 2, idRiver)
        except :
                writeLog("", False, ["", " An error occured during chess river generation ..."])
                writeError()

class riversFromSea:
	def __init__(self):
		self.gc = CyGlobalContext()
		self.dice = self.gc.getGame().getMapRand()
		self.map = CyMap()
		self.width = self.map.getGridWidth()
		self.height = self.map.getGridHeight()
		self.straightThreshold = 3
		if (self.width * self.height > 400):
			self.straightThreshold = 2

	def seedRivers(self):
		climate = cmo[1]
		if (climate == 0):                 # Arid
			divider = 6
		elif (climate == 1):               # Normal
			divider = 3
		elif (climate == 2):               # Wet
			divider = 2
		elif (climate == 3):               # No ice
			divider = 3
		maxNumber = (self.width + self.height) / divider
		userInputLandmass = cmo[0]
		riversNumber = 1 + maxNumber
		if (userInputLandmass == 1):       # Pangaea
			riversNumber = maxNumber/2
		self.coasts = self.collateCoasts()
		coastsNumber = len(self.coasts)
		if (coastsNumber == 0):
			return
		coastShare = coastsNumber/riversNumber
		for i in range(riversNumber):
			(x,y,flow) = self.generateRiver(i,coastShare)
			if (flow != CardinalDirectionTypes.NO_CARDINALDIRECTION):
				riverID = self.gc.getMap().getNextRiverID()
				self.addRiverFrom(x,y,flow,riverID)

	def collateCoasts(self):
		result = []
		for x in range(self.width):
			for y in range(self.height):
				plot = self.map.plot(x,y)
				if (plot.isCoastalLand()):
					result.append(plot)
		return result

	def generateRiver(self,i,coastShare):
		choiceCoast = coastShare * i + self.dice.get(coastShare,"Pick a coast for the river")
		plot = self.coasts[choiceCoast]
		FlowDirection = CardinalDirectionTypes.NO_CARDINALDIRECTION
		x = plot.getX()
		y = plot.getY()
		if ((y < 1 or y >= self.height - 1) or plot.isNOfRiver() or plot.isWOfRiver()):
			return (x,y,FlowDirection)
		eastX = self.eastX(x)
		westX = self.westX(x)
		otherPlot = True
		eastPlot = self.map.plot(eastX,y)
		if (eastPlot.isCoastalLand()):
			seaPlot = self.map.plot(x,y+1)
			if ((self.map.plot(x,y+1).isWater()) or (self.map.plot(eastX,y+1).isWater())):
				landPlot1 = self.map.plot(x,y-1)
				landPlot2 = self.map.plot(eastX,y-1)
				if (landPlot1.isWater() or landPlot2.isWater()):
					otherPlot = True
				else:
					FlowDirection = CardinalDirectionTypes.CARDINALDIRECTION_NORTH
					otherPlot = False
			if (otherPlot == True):
				if ((self.map.plot(x,y-1).isWater()) or (self.map.plot(eastX,y-1).isWater())):
					landPlot1 = self.map.plot(x,y+1)
					landPlot2 = self.map.plot(eastX,y+1)
					if (landPlot1.isWater() or landPlot2.isWater()):
						otherPlot = True
					else:
						FlowDirection = CardinalDirectionTypes.CARDINALDIRECTION_SOUTH
						otherPlot = False
		if (otherPlot == True):
			southPlot = self.map.plot(x,y-1)
			if (southPlot.isCoastalLand()):
				if ((self.map.plot(eastX,y).isWater()) or (self.map.plot(eastX,y-1).isWater())):
					landPlot1 = self.map.plot(westX,y)
					landPlot2 = self.map.plot(westX,y-1)
					if (landPlot1.isWater() or landPlot2.isWater()):
						otherPlot = True
					else:
						FlowDirection = CardinalDirectionTypes.CARDINALDIRECTION_EAST
						otherPlot = False
				if (otherPlot == True):
					if ((self.map.plot(westX,y).isWater()) or (self.map.plot(westX,y-1).isWater())):
						landPlot1 = self.map.plot(eastX,y)
						landPlot2 = self.map.plot(eastX,y-1)
						if (landPlot1.isWater() or landPlot2.isWater()):
							otherPlot = True
						else:
							FlowDirection = CardinalDirectionTypes.CARDINALDIRECTION_WEST
		return (x,y,FlowDirection)

	# prevent rivers from crossing each other
	def preventRiversFromCrossing(self,x,y,flow,riverID):
		plot = self.map.plot(x,y)
		eastX = self.eastX(x)
		westX = self.westX(x)
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
			if (plot.isNOfRiver()):
				return true
			if (self.map.plot(eastX,y).isNOfRiver()):
				return true
			southPlot = self.map.plot(x,y-1)
			if (southPlot.isWOfRiver() and southPlot.getRiverNSDirection() == CardinalDirectionTypes.CARDINALDIRECTION_SOUTH):
				return true
			if (plot.isWOfRiver() and plot.getRiverNSDirection() == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
				return true
			if (self.map.plot(eastX,y).isWater()):
				return true
			if (self.map.plot(x,y-1).isWater()):
				return true
			if (self.map.plot(eastX,y-1).isWater()):
				return true
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_EAST):
			if (plot.isNOfRiver()):
				return true
			if (self.map.plot(westX,y).isNOfRiver()):
				return true
			southPlot = self.map.plot(westX,y-1)
			if (southPlot.isWOfRiver() and southPlot.getRiverNSDirection() == CardinalDirectionTypes.CARDINALDIRECTION_SOUTH):
				return true
			westPlot = self.map.plot(westX,y)
			if (westPlot.isWOfRiver() and westPlot.getRiverNSDirection() == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
				return true
			if (self.map.plot(westX,y).isWater()):
				return true
			if (self.map.plot(x,y-1).isWater()):
				return true
			if (self.map.plot(westX,y-1).isWater()):
				return true
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
			if (plot.isWOfRiver()):
				return true
			eastPlot = self.map.plot(eastX,y)
			if (eastPlot.isNOfRiver() and eastPlot.getRiverWEDirection() == CardinalDirectionTypes.CARDINALDIRECTION_EAST):
				return true
			if (plot.isNOfRiver() and plot.getRiverWEDirection() == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
				return true
			if (self.map.plot(x,y-1).isWOfRiver()):
				return true
			if (self.map.plot(x,y-1).isWater()):
				return true
			if (self.map.plot(x+1,y).isWater()):
				return true
			if (self.map.plot(x+1,y-1).isWater()):
				return true
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_SOUTH):
			if (plot.isWOfRiver()):
				return true
			eastPlot = self.map.plot(eastX,y+1)
			if (eastPlot.isNOfRiver() and eastPlot.getRiverWEDirection() == CardinalDirectionTypes.CARDINALDIRECTION_EAST):
				return true
			northPlot = self.map.plot(x,y+1)
			if (northPlot.isNOfRiver() and northPlot.getRiverWEDirection() == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
				return true
			if (self.map.plot(x,y+1).isWOfRiver()):
				return true
			if (self.map.plot(x,y+1).isWater()):
				return true
			if (self.map.plot(x+1,y).isWater()):
				return true
			if (self.map.plot(x+1,y+1).isWater()):
				return true
		return false


	def addRiverFrom(self,x,y,flow,riverID):
		plot = self.map.plot(x,y)
		if (plot.isWater()):
			return
		eastX = self.eastX(x)
		westX = self.westX(x)
		if (self.preventRiversFromCrossing(x,y,flow,riverID)):
			return
		plot.setRiverID(riverID)
		if ((flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST) or (flow == CardinalDirectionTypes.CARDINALDIRECTION_EAST)):
			plot.setNOfRiver(True,flow)
		else:
			plot.setWOfRiver(True,flow)
		xShift = 0
		yShift = 0
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
			xShift = 1
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_EAST):
			xShift = -1
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
			yShift = -1
		if (flow == CardinalDirectionTypes.CARDINALDIRECTION_SOUTH):
			yShift = 1
		nextX = x + xShift
		nextY = y + yShift
		if (nextX >= self.width):
			nextX = 0
		if (nextY >= self.height):
			return
		nextI = nextY*self.width + nextX
		if (self.canFlowFrom(plot,self.map.plot(nextX,nextY)) == False):
			return
		if (plot.getTerrainType() == CyGlobalContext().getInfoTypeForString("TERRAIN_SNOW") and self.dice.get(10,"Stop on ice") > 3):
			return
		flatDesert = (plot.getPlotType() == PlotTypes.PLOT_LAND) and (plot.getTerrainType() == CyGlobalContext().getInfoTypeForString("TERRAIN_DESERT"))
		#Prevent Uturns in rivers
		turnThreshold = 16
		if flatDesert:
			turnThreshold = 18
		turned = False
		northY = y + 1
		southY = y - 1
		if ((flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST) or (flow == CardinalDirectionTypes.CARDINALDIRECTION_EAST)):
			if ((northY < self.height) and (self.dice.get(20,"branch from north") > turnThreshold)):
				nextI = northY*self.width + x
				if (self.canFlowFrom(plot,self.map.plot(x,northY)) and self.canFlowFrom(self.map.plot(self.eastX(x),y),self.map.plot(self.eastX(x),northY))):
					turned = True
					if (flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
						self.addRiverFrom(x,y,CardinalDirectionTypes.CARDINALDIRECTION_SOUTH,riverID)
					else:
						westPlot = self.map.plot(westX,y)
						westPlot.setRiverID(riverID)
						self.addRiverFrom(westX,y,CardinalDirectionTypes.CARDINALDIRECTION_SOUTH,riverID)
			if ((not turned) and (southY >= 0) and (self.dice.get(20,"branch from south") > turnThreshold)):
				nextI = southY*self.width + x
				if (self.canFlowFrom(plot,self.map.plot(x,southY)) and self.canFlowFrom(self.map.plot(self.eastX(x),y),self.map.plot(self.eastX(x),southY))):
					turned = True
					if (flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST):
						southPlot = self.map.plot(x,y-1)
						southPlot.setRiverID(riverID)
						self.addRiverFrom(x,southY,CardinalDirectionTypes.CARDINALDIRECTION_NORTH,riverID)
					else:
						westPlot = self.map.plot(westX,southY)
						westPlot.setRiverID(riverID)
						self.addRiverFrom(westX,southY,CardinalDirectionTypes.CARDINALDIRECTION_NORTH,riverID)
		else:
			nextI = y*self.width + eastX
			if (self.canFlowFrom(plot,self.map.plot(eastX,y)) and self.canFlowFrom(self.map.plot(x,southY),self.map.plot(eastX,y)) and (self.dice.get(20,"branch from east") > turnThreshold)):
				turned = True
				if (flow == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
					eastPlot = self.map.plot(eastX,y)
					eastPlot.setRiverID(riverID)
					self.addRiverFrom(eastX,y,CardinalDirectionTypes.CARDINALDIRECTION_WEST,riverID)
				else:
					northEastPlot = self.map.plot(eastX,y+1)
					northEastPlot.setRiverID(riverID)
					self.addRiverFrom(eastX,y+1,CardinalDirectionTypes.CARDINALDIRECTION_WEST,riverID)
			nextI = y*self.width + westX
			if ((not turned) and self.canFlowFrom(plot,self.map.plot(westX,y)) and self.canFlowFrom(self.map.plot(x,southY),self.map.plot(westX,southY)) and (self.dice.get(20,"branch from west") > turnThreshold)):
				turned = True
				if (flow == CardinalDirectionTypes.CARDINALDIRECTION_NORTH):
					self.addRiverFrom(x,y,CardinalDirectionTypes.CARDINALDIRECTION_EAST,riverID)
				else:
					northPlot = self.map.plot(x,y+1)
					northPlot.setRiverID(riverID)
					self.addRiverFrom(x,y+1,CardinalDirectionTypes.CARDINALDIRECTION_EAST,riverID)
		spawnInDesert = (not turned) and flatDesert
		if ((self.dice.get(10,"straight river") > self.straightThreshold) or spawnInDesert):
			self.addRiverFrom(nextX,nextY,flow,riverID)
		else:
			if (not turned):
				plot = self.map.plot(nextX,nextY)
				if ((plot.getPlotType() == PlotTypes.PLOT_LAND) and (self.dice.get(10,"Rivers start in hills") > 3)):
					plot.setPlotType(PlotTypes.PLOT_HILLS,true,true)
					if ((flow == CardinalDirectionTypes.CARDINALDIRECTION_WEST) or (flow == CardinalDirectionTypes.CARDINALDIRECTION_EAST)):
						if southY > 0:
							self.map.plot(nextX,southY).setPlotType(PlotTypes.PLOT_HILLS,true,true)
					else:
						self.map.plot(eastX,nextY).setPlotType(PlotTypes.PLOT_HILLS,true,true)

	def canFlowFrom(self,plot,upperPlot):
		if (plot.isWater()):
			return False
		if (plot.getPlotType() == PlotTypes.PLOT_PEAK):
			return False
		if (plot.getPlotType() == PlotTypes.PLOT_HILLS):
			if ((upperPlot.getPlotType() == PlotTypes.PLOT_HILLS) or (upperPlot.getPlotType() == PlotTypes.PLOT_PEAK)):
				return True
			else:
				return False
		if (plot.getPlotType() == PlotTypes.PLOT_LAND):
			if (upperPlot.isWater()):
				return False
		return True
	
	def westX(self,x):
		westX = x - 1
		if (westX < 0):
			westX = self.width
		return westX

	def eastX(self,x):
		eastX = x + 1
		if (eastX >= self.width):
			eastX = 0
		return eastX

def addLakes():
        try :
                if idMap == "chess" :
                        if bSuccessFlag :
                                writeLog(" = addLakes : adding rivers = ", True, [" chess rivers already done . No lakes"])
                                return None

                global canAddRivers
                canAddRivers = True

                writeLog(" = addLakes : adding rivers = ", False, [""])

                if idMap == "tectonics" :
                        riverGenerator = riversFromSea()
                        riverGenerator.seedRivers()

                # adding river . play with (fresh)water source range to make the longest rivers possible
                userInputPlotEdge = getRandSel(selGen["terrain"]["river"]["riveredge"], False)
                iOriginalMSOGDH = gc.getDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE")
                iOriginalMinRiverRange = gc.getDefineINT("RIVER_SOURCE_MIN_RIVER_RANGE") #4 in default civ (/2 for the 2 last pass over 4 pass)
                iOriginalMinSeaWaterRange = gc.getDefineINT("RIVER_SOURCE_MIN_SEAWATER_RANGE") #2 in default civ (/2 for the 2 last pass over 4 pass)
                iOriginalPlotPerRiverEdge = gc.getDefineINT("PLOTS_PER_RIVER_EDGE")
                
                #debug
                logList = []
                logList.append(" userInputPlotEdge : %r" %userInputPlotEdge)
                logList.append(" iOriginalMSOGDH : %r" %iOriginalMSOGDH)
                logList.append(" iOriginalMinRiverRange : %r" %iOriginalMinRiverRange)
                logList.append(" iOriginalMinSeaWaterRange : %r" %iOriginalMinSeaWaterRange)
                logList.append(" iOriginalPlotPerRiverEdge : %r" %iOriginalPlotPerRiverEdge)
                logList.append("")
                writeLog("", False, logList)

                # don't seem to have a use . keep it just in case
                gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", 1)
                gc.setDefineINT("PLOTS_PER_RIVER_EDGE", userInputPlotEdge)

                iMRRange = iOriginalMinRiverRange + 15
                iMSRange = iOriginalMinSeaWaterRange + 15
                iLimitMinRiverRange = iOriginalMinRiverRange
                # in case the player want lots of rivers :
                if userInputPlotEdge <= 6 :
                        iLimitMinRiverRange = min(2, iOriginalMinRiverRange)
                
                idRiverStart = map.getNextRiverID() # should be 0

                bBreak = False
                while True :

                        if (idMap == "tectonics") and (userInputPlotEdge == 1) :
                                writeLog("", False, [" tectonics without anymore rivers : break ",""])
                                break

                        idRiver = map.getNextRiverID()
                        if idRiver > 960 :
                                writeLog("", False, [" number of rivers exceed 960 : break ",""]) # think i remember that with XXXXl map ,1000 was the limit number of rivers
                                break

                        gc.setDefineINT("RIVER_SOURCE_MIN_RIVER_RANGE", iMRRange)
                        gc.setDefineINT("RIVER_SOURCE_MIN_SEAWATER_RANGE", iMSRange)

                        CyMapGenerator().addRivers()

                        if map.getNextRiverID() > idRiver :
                                continue
                        elif bBreak :
                                break

                        iMRRange -= 1
                        iMSRange -= 1
                        iMSRange = max(2, iMSRange)

                        if iMRRange == iLimitMinRiverRange : bBreak = True

                idRiverFinal = map.getNextRiverID()
                nbRivers = idRiverFinal - idRiverStart

                gc.setDefineINT("RIVER_SOURCE_MIN_RIVER_RANGE", iOriginalMinRiverRange)
                gc.setDefineINT("RIVER_SOURCE_MIN_SEAWATER_RANGE", iOriginalMinSeaWaterRange)
                gc.setDefineINT("PLOTS_PER_RIVER_EDGE", iOriginalPlotPerRiverEdge)
                gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", iOriginalMSOGDH)

                logList = []
                logList.append(" idRiverStart : %r" %idRiverStart)
                logList.append(" idRiverFinal : %r" %idRiverFinal)
                logList.append(" nbRivers : %r" %nbRivers)
                logList.append("")
                writeLog("", True, logList)
        except :
                writeLog("", True, ["", " An error occured during river generation ..."])
                writeError()

        # adding lakes
	CyPythonMgr().allowDefaultImpl()
	
def addFeatures():
        try :
                NiTextOut("Adding Features (Full of resources) ...")
                writeLog(" = addFeatures = ", False, [""])

                featureFlood = gc.getInfoTypeForString('FEATURE_FLOOD_PLAINS')
                terrainDesert = gc.getInfoTypeForString('TERRAIN_DESERT')
                featureIce = gc.getInfoTypeForString('FEATURE_ICE')
                featureOasis = gc.getInfoTypeForString('FEATURE_OASIS')
                featureNone = FeatureTypes.NO_FEATURE

                bIce = bool(featureIce != -1)
                bOasis = bool(featureOasis != -1)

                if bIce : userInputIced = copy.copy(selGen["terrain"]["ice"]["iceremove"])
                if bOasis : oasisPer = getRandSel(selGen["terrain"]["oasis"]["oasispercent"], False)

                forestPer = getRandSel(selGen["terrain"]["forest"]["forestpercent"], False)
                junglePer = getRandSel(selGen["terrain"]["jungle"]["junglepercent"], False)

                #debug
                logList = []
                if bIce : logList.append(" userInputIced : %r" %userInputIced)
                if bOasis : logList.append(" oasisPer : %r" %oasisPer)
                logList.append(" forestPer : %r" %forestPer)
                logList.append(" junglePer : %r" %junglePer)
                logList.append("")
                writeLog("", False, logList)

                fGrain=6
                jGrain=5

                if idMap in ["archipelago", "continents", "customcontinents", "fractals", "islands", "lakes", "maze", "pangaea", "shuffle", "terra", "chess", "bigandsmall", "hemispheres", "mediumandsmall"] :
                        featuregen = FeatureGenerator(junglePer, 100 - forestPer, jGrain, fGrain)
                elif idMap == "inlandsea" :
                        featuregen = ISFeatureGenerator(junglePer, 100 - forestPer, jGrain, fGrain)
                elif idMap in ["hub", "ring", "wheel"] :
                        forestPer = int(7.0 / 12 * (100 - forestPer) + 16) + 1
                        junglePer = int(5.0 / 16 * junglePer)
                        featuregen = HubFeatureGenerator(junglePer, 100 - forestPer, fGrain)
                elif idMap == "tectonics" :
                        if cmo[0] == 5 :         #  "Mediterranean"
                                userInputIced = 2
                                featuregen = MediterraneanFeatureGenerator(junglePer, 100 - forestPer, jGrain, fGrain)
                        else:
                                featuregen = FeatureGenerator(junglePer, 100 - forestPer, jGrain, fGrain)

                featuregen.addFeatures()

                oasisPlots = []
                for iX in range(iW) :
                        for iY in range(iH) :
                                pPlot = map.plot(iX, iY)
                                iFeature = pPlot.getFeatureType()
                                if iFeature != -1 :
                                        if bOasis :
                                                if iFeature == featureOasis :
                                                        pPlot.setFeatureType(featureNone, -1)
                                        if bIce :
                                                if iFeature == featureIce :
                                                        if userInputIced == 2 :
                                                                pPlot.setFeatureType(featureNone, -1)
                                                        elif userInputIced == 1 :
                                                                for dX, dY in [(-1, 0), (1, 0), (0, -1), (0, 1)] :
                                                                        pLoopPlot = map.plot(iX + dX, iY + dY)
                                                                        if pLoopPlot.isNone() : continue
                                                                        if not pLoopPlot.isWater() :
                                                                                pPlot.setFeatureType(featureNone, -1)
                                                                                break
                                                        continue

                                if bOasis :
                                        if pPlot.canHaveFeature(featureOasis) :
                                                oasisPlots.append((iX, iY))

                # place Oasis
                if bOasis :
                        rings = generateRings(3)
                        nbOasisPlaced = 0
                        nbOasisTiles = len(oasisPlots)
                        oasisPer /= 100.0
                        plotValue = [[0 for iY in range(iH)] for iX in range(iW)]
                        while True :
                                if (nbOasisPlaced / (nbOasisTiles + 0.001)) >= oasisPer : break
                                if len(oasisPlots) == 0 : break
                                bestValue = min([plotValue[iX][iY] for iX, iY in oasisPlots])
                                lPlots = [(iX, iY) for iX, iY in oasisPlots if plotValue[iX][iY] == bestValue]
                                iChoice = getRandNum(len(lPlots), "FoR : hill add")
                                iX, iY = lPlots[iChoice]
                                for iRing in range(1, 4) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        if wTP in oasisPlots :
                                                                plotValue[wTP[0]][wTP[1]] += (4 - iRing)
                                map.plot(iX, iY).setFeatureType(featureOasis, -1)
                                nbOasisPlaced += 1
                                oasisPlots.remove((iX, iY))

                        #debug
                        logList = []
                        logList.append(" nbOasisPlaced : %r" %nbOasisPlaced)
                        logList.append(" nbOasisTiles : %r" %nbOasisTiles)
                        if nbOasisTiles > 0 : logList.append(" eff oasis percent : %r" %(float(nbOasisPlaced)/nbOasisTiles*100, ))
                        logList.append("")
                        writeLog("", False, logList)

                writeLog("", True, [])
        except :
                writeLog("", True, ["", " An error occured during feature generation ..."])
                writeError()

	return 0

class MediterraneanFeatureGenerator(CvMapGeneratorUtil.FeatureGenerator):
	def getLatitudeAtPlot(self, iX, iY):
		"returns 0.0 for tropical, up to 1.0 for polar"
		# 25/90 to 65/90:
		lat = 5/float(18) + 4*(self.iGridH - iY)/float(9*self.iGridH)
		return lat
	
class ISFeatureGenerator(CvMapGeneratorUtil.FeatureGenerator):
	def getLatitudeAtPlot(self, iX, iY):
		lat = CvMapGeneratorUtil.FeatureGenerator.getLatitudeAtPlot(self, iX, iY)
		lat = 0.07 + 0.56*lat
		return lat

class HubFeatureGenerator(CvMapGeneratorUtil.FeatureGenerator):
	def __init__(self, iJunglePercent=25, iForestPercent=40,
	             forest_grain=6, fracXExp=-1, fracYExp=-1):
		self.gc = CyGlobalContext()
		self.map = CyMap()
		self.mapRand = self.gc.getGame().getMapRand()
		self.forests = CyFractal()
		global center_data
		[self.cenWestX, self.cenEastX, self.cenSouthY, self.cenNorthY] = center_data
		self.iFlags = 0
		if self.map.isWrapX(): self.iFlags += CyFractal.FracVals.FRAC_WRAP_X
		if self.map.isWrapY(): self.iFlags += CyFractal.FracVals.FRAC_WRAP_Y
		self.iGridW = self.map.getGridWidth()
		self.iGridH = self.map.getGridHeight()
		self.pineWestX = int(self.cenWestX * 0.7)
		self.pineEastX = self.iGridW - int((self.cenEastX + self.iGridW - 1) * 0.35) - 1
		self.pineSouthY = int(self.cenSouthY * 0.7)
		self.pineNorthY = self.iGridH - int((self.cenNorthY + self.iGridH - 1) * 0.35) - 1
		self.iJunglePercent = iJunglePercent
		self.iForestPercent = iForestPercent
		self.iIceChance = 15
		if self.gc.getClimateInfo(self.map.getClimate()).getJungleLatitude() < 5:
			self.iJunglePercent += 25
			self.iForestPercent -= 10
			self.iIceChance = 30
		if self.gc.getClimateInfo(self.map.getClimate()).getRandIceLatitude() > 0.25:
			self.iIceChance = 6
			self.iJunglePercent -= 10
			self.iForestPercent += 20
		if self.gc.getClimateInfo(self.map.getClimate()).getDesertPercentChange() >= 10:
			self.iJunglePercent = 15
			self.iForestPercent = 20
		forest_grain += self.gc.getWorldInfo(self.map.getWorldSize()).getFeatureGrainChange()
		self.forest_grain = forest_grain
		self.fracXExp = fracXExp
		self.fracYExp = fracYExp
		self.__initFractals()
		self.__initFeatureTypes()
	
	def __initFractals(self):
		self.forests.fracInit(self.iGridW, self.iGridH, self.forest_grain, self.mapRand, self.iFlags, self.fracXExp, self.fracYExp)
		self.iJungleBottom = self.forests.getHeightFromPercent(100 - self.iJunglePercent)
		self.iForestLevel = self.forests.getHeightFromPercent(self.iForestPercent)

	def __initFeatureTypes(self):
		self.featureIce = self.gc.getInfoTypeForString("FEATURE_ICE")
		self.featureJungle = self.gc.getInfoTypeForString("FEATURE_JUNGLE")
		self.featureForest = self.gc.getInfoTypeForString("FEATURE_FOREST")
		self.featureOasis = self.gc.getInfoTypeForString("FEATURE_OASIS")
	
	def addFeaturesAtPlot(self, iX, iY):
		pPlot = self.map.sPlot(iX, iY)
		for iI in range(self.gc.getNumFeatureInfos()):
			if pPlot.canHaveFeature(iI):
				if getRandNum(10000, "FoR : Add Feature PYTHON") < self.gc.getFeatureInfo(iI).getAppearanceProbability():
					pPlot.setFeatureType(iI, -1)
		if (pPlot.getFeatureType() == FeatureTypes.NO_FEATURE):
			self.addIceAtPlot(pPlot, iX, iY)
		if (pPlot.getFeatureType() == FeatureTypes.NO_FEATURE):
			self.addJunglesAtPlot(pPlot, iX, iY)
		if (pPlot.getFeatureType() == FeatureTypes.NO_FEATURE):
			self.addForestsAtPlot(pPlot, iX, iY)
		
	def addIceAtPlot(self, pPlot, iX, iY):
		if pPlot.isWater() and ((iX >= self.cenWestX and iX <= self.cenEastX) and (iY >= self.cenSouthY and iY <= self.cenNorthY)):
			rand = getRandNum(self.iIceChance, "FoR : Add Ice PYTHON")
			if rand == 4:
				pPlot.setFeatureType(self.featureIce, -1)
	
	def addJunglesAtPlot(self, pPlot, iX, iY):
		if pPlot.canHaveFeature(self.featureJungle) and not ((iX >= self.cenWestX and iX <= self.cenEastX) and (iY >= self.cenSouthY and iY <= self.cenNorthY)):
			iJungleHeight = self.forests.getHeight(iX, iY)
			if iJungleHeight >= self.iJungleBottom:
				pPlot.setFeatureType(self.featureJungle, -1)
	
	def addForestsAtPlot(self, pPlot, iX, iY):
		if pPlot.canHaveFeature(self.featureForest):
			if self.forests.getHeight(iX, iY) <= self.iForestLevel:
				if ((iX >= self.cenWestX and iX <= self.cenEastX) and (iY >= self.cenSouthY and iY <= self.cenNorthY)):
					forestVar = 2
				elif (iX <= self.pineWestX or iX >= self.pineEastX or iY <= self.pineSouthY or iY >= self.pineNorthY):
					forestVar = 0
				else:
					forestVar = 1
				pPlot.setFeatureType(self.featureForest, forestVar)

def afterGeneration():
        # remove the extra cities and improvement FFH2 adds to place them with the script options after the player assignments and normalizations
        if is_BtS_FFH2 :
                try :
                        removeFfH2Additions()
                except :
                        writeLog("", False, ["", " An error occured during removeFfH2Additions ..."])
                        writeError()

        #default bonus generation done , now add extra bonuses
        try :
                StoAddBonuses()
        except :
                writeLog("", True, ["", " An error occured during resources generation ..."])
                writeError()

def removeFfH2Additions():
        # restore unique feature chance after preventing the apparition
        iOriginalMSOGDH = gc.getDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE")
        try :
                gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", 1)
                gc.setDefineINT("IMPROVEMENT_UNIQUE_CHANCE", originalUniqueFeatureChance)
                gc.setDefineINT("MODS_SHOULD_OVERRIDE_GLOBAL_DEFINES_HERE", iOriginalMSOGDH)
        except :
                writeLog("", False, ["", " FfH : error restoring the unique feature chance"])
                writeError()

        BarbWorld = gc.getInfoTypeForString("GAMEOPTION_BARBARIAN_WORLD")
        if BarbWorld != -1 :
                if game.isOption(BarbWorld) :
                        try :
                                removeBarbCities()
                        except :
                                writeLog("", False, ["", " An error occured during removeBarbCities ..."])
                                writeError()

        NoLairs = gc.getInfoTypeForString("GAMEOPTION_NO_LAIRS")
        #NoUniqueImprovements = gc.getInfoTypeForString("GAMEOPTION_NO_UNIQUE_IMPROVEMENTS")

        bRemoveImprs = True
        if (NoLairs != -1) : # and (NoUniqueImprovements != -1) :
                if (game.isOption(NoLairs)) : # and (game.isOption(NoUniqueImprovements)) :
                        bRemoveImprs = False

        if bRemoveImprs :
                try :
                        removeImprovements()
                except :
                        writeLog("", False, ["", " An error occured during removeImprovements ..."])
                        writeError()

def removeImprovements() :
        lImprIDs = [ gc.getInfoTypeForString(item) for item in XMLEntriesList["lairs"] ]
        #lImprIDs += [ gc.getInfoTypeForString(item) for item in XMLEntriesList["uniqueimprovements"] ]

        lImprIDs = [ item for item in lImprIDs if item != -1 ] # should have no use , just in case

        if len(lImprIDs) == 0 :
                writeLog("", False, ["", " removeImprovements : no improvements type found to remove"])
                return

        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)
                        if pPlot.getImprovementType() in lImprIDs :

                                # debug
                                #CyEngine().addSign(pPlot, 0, gc.getImprovementInfo(pPlot.getImprovementType()).getType()[12:])

                                pPlot.setImprovementType(-1)
                                pPlot.setBonusType(-1)

def removeBarbCities() :
        barbPlayerID = gc.getBARBARIAN_PLAYER()
        pBarbPlayer = gc.getPlayer(barbPlayerID)

        lCities = []                                
        (loopCity, iter) = pBarbPlayer.firstCity(False)
        while (loopCity):
                cityOwner = loopCity.getOwner()
                if (not loopCity.isNone()) and (loopCity.getOwner() == barbPlayerID):
                        lCities.append(loopCity)
                (loopCity, iter) = pBarbPlayer.nextCity(iter, False)

        if len(lCities) == 0 :
                writeLog("", False, ["", " No Barb Cities to remove !? ..."])
                return

        listFeatures = []
        for iFeature in range(gc.getNumFeatureInfos()):
                featureXML = gc.getFeatureInfo(iFeature)
                if featureXML.getAppearanceProbability() < 10000 : continue
                listFeatures.append(iFeature)

        lUniqueImprovementsUnits = []
        for sImprovementType in XMLEntriesList["uniqueimprovements"] :
                if parsedXMLValuesEntries[sImprovementType]["SpawnUnitType"] != "" :
                        lUniqueImprovementsUnits.append(gc.getInfoTypeForString(parsedXMLValuesEntries[sImprovementType]["SpawnUnitType"]))

        lUnit = []
        (loopUnit, iter) = pBarbPlayer.firstUnit(False)
        while (loopUnit):
                if (not loopUnit.isDead()):
                        lUnit.append(loopUnit)
                (loopUnit, iter) = pBarbPlayer.nextUnit(iter, False)

        for pUnit in lUnit :
                if not pUnit.getUnitType() in lUniqueImprovementsUnits :
                        pUnit.kill(False, PlayerTypes.NO_PLAYER)
                else :
                        writeLog("", False, ["", " removeBarbCities : an unit (%s) not delete because in the list of unique feature units" %(gc.getUnitInfo(pUnit.getUnitType()).getType(), )])

        for pCity in lCities :
                iX = pCity.getX()
                iY = pCity.getY()
                pPlot = map.plot(iX, iY)

                pCity.kill()

                pPlot.setImprovementType(-1)
                pPlot.setRouteType(-1)
                for iFeature in listFeatures :
                        if pPlot.canHaveFeature(iFeature):
                                pPlot.setFeatureType(iFeature, -1)
                                break

                for i in range(2) :
                        for dX in range(-1,2) :
                                for dY in range(-1,2) :
                                        pLoopPlot = map.plot(iX + dX, iY + dY)
                                        if pLoopPlot.isNone() : continue
                                        pLoopPlot.setCulture(barbPlayerID, 0, True)

                # debug
                #CyEngine().addSign(pPlot, 0, "Barb City")

def StoAddBonuses():
        global lBonusExtend
        writeLog(" = StoAddBonuses = ", False, [""])

        # initialization

        # remove all goodies , store plots with other improvements .
        # let default goody generation in case some other improvements or goodies are added by the mod .
        iGoody = gc.getInfoTypeForString("IMPROVEMENT_GOODY_HUT")
        bGoody = bool(iGoody != -1)
        lImprovementPlots = []
        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)
                        iImprovement = pPlot.getImprovementType()
                        if iImprovement == -1 : continue
                        if bGoody :
                                if iImprovement == iGoody :
                                        pPlot.setImprovementType(-1)
                                        continue
                        lImprovementPlots.append((iX, iY))

        # entries
        natRes = genNatureRes()
        nbRes = gc.getNumBonusInfos()
        nbTerrain = gc.getNumTerrainInfos()
        nbFeature = gc.getNumFeatureInfos()

        noTeam = TeamTypes.NO_TEAM

        lResPro = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["strategic"]) and (natRes[iBonus][0] == 0))]
        lResFoo = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["health"]) and (natRes[iBonus][0] == 1))]
        lResLux = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["happiness"]) and (natRes[iBonus][0] == 2))]
        lRes = copy.copy(lResPro) + copy.copy(lResFoo) + copy.copy(lResLux)
        lResLand = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["land"]) and (natRes[iBonus][1]))]
        lResWater = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["water"]) and (natRes[iBonus][2]))]
        
	lResNatLoc = [[[iBonus for iBonus in lResPro if iBonus in lResLand], [iBonus for iBonus in lResPro if iBonus in lResWater]],
                      [[iBonus for iBonus in lResFoo if iBonus in lResLand], [iBonus for iBonus in lResFoo if iBonus in lResWater]],
                      [[iBonus for iBonus in lResLux if iBonus in lResLand], [iBonus for iBonus in lResLux if iBonus in lResWater]]]

	bEraseAll = copy.copy(selGen["resources"]["resourcesgen"]["erasedefres"])
        lStandardRes = []

        landPer = copy.copy(selGen["resources"]["resourcesgen"]["landpercent"])
        if landPer == "standard" :
                lStandardRes += copy.copy(lResLand)
                landPer = 0
        else :
                landPer = getRandSel(selGen["resources"]["resourcesgen"]["landpercent"], False)

        waterPer = copy.copy(selGen["resources"]["resourcesgen"]["waterpercent"])
        if waterPer == "standard" :
                lStandardRes += copy.copy(lResWater)
                waterPer = 0
        else :
                waterPer = getRandSel(selGen["resources"]["resourcesgen"]["waterpercent"], False)

        lStandardResSel = [gc.getInfoTypeForString(sType) for sType in selGen["resources"]["resourcesgen"]["standardgen"]]

        lStandardRes = list(set(lStandardResSel + lStandardRes))

        if bEraseAll : lStandardRes = []
        
        lGenRes = [iBonus for iBonus in lRes if not iBonus in lStandardRes]

        lGroupRes = [gc.getInfoTypeForString(sType) for sType in selGen["resources"]["resourcesgen"]["groupres"]]

        landProps = copy.copy(selGen["resources"]["resourcesgen"]["landprop"])
        waterProps = copy.copy(selGen["resources"]["resourcesgen"]["waterprop"])

        bLakes = copy.copy(selGen["resources"]["resourcesgen"]["resspreadlake"])
        bClimate = not isBonusIgnoreLatitude()

        lResMultiply = []
        for sKey in selGen["resources"]["resourcesgen"].keys() :
                if not "resmultiply-" in sKey : continue
                eBonuses = selGen["resources"]["resourcesgen"][sKey][0]
                rFactor = copy.copy(selGen["resources"]["resourcesgen"][sKey][1])
                if eBonuses == [] :
                        continue
                elif eBonuses == "allstrat" :
                        if rFactor > 1.001 :
                                for iBonus in lResPro : lResMultiply.append([iBonus, rFactor])
                elif eBonuses == "allhealth" :
                        if rFactor > 1.001 :
                                for iBonus in lResFoo : lResMultiply.append([iBonus, rFactor])
                elif eBonuses == "allhapp" :
                        if rFactor > 1.001 :
                                for iBonus in lResLux : lResMultiply.append([iBonus, rFactor])
                else :
                        if rFactor > 1.001 :
                                iBonus = gc.getInfoTypeForString(eBonuses[0])
                                if iBonus == -1 :
                                        writeLog("", False, ["ERROR , res multiply type : %r , %r" %(eBonuses, rFactor)])
                                        continue
                                lResMultiply.append([iBonus, rFactor])

        # debug                
        logList = [" resources generation entries :"]
        logList.append("")
        logList.append(" lResPro : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lResPro], ))
        logList.append(" lResFoo : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lResFoo], ))
        logList.append(" lResLux : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lResLux], ))
        logList.append("")
        logList.append(" bEraseAll    : %r" %bEraseAll)
        logList.append(" reslist      : %r" %XMLEntriesList["reslist"])
        logList.append(" lRes         : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lRes], ))
        logList.append(" lGenRes      : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lGenRes], ))
        logList.append(" lStandardRes : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lStandardRes], ))
        logList.append("")
        logList.append(" landlist : %r" %XMLEntriesList["land"])
        logList.append(" lResLand : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lResLand], ))
        logList.append("")
        logList.append(" waterlist : %r" %XMLEntriesList["water"])
        logList.append(" lResWater : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lResWater], ))
        logList.append("")
        lTag = ["pro", "foo", "lux"]
        for i in range(3) :
                logList.append(" lResNatLoc, %s, land  : %r" %(lTag[i], [gc.getBonusInfo(iBonus).getType() for iBonus in lResNatLoc[i][0]]))
                logList.append(" lResNatLoc, %s, water : %r" %(lTag[i], [gc.getBonusInfo(iBonus).getType() for iBonus in lResNatLoc[i][1]]))
        logList.append("")
        logList.append(" landPer  : %r" %landPer)
        logList.append(" waterPer : %r" %waterPer)
        logList.append("")
        logList.append(" lGroupRes : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in lGroupRes], ))
        logList.append("")
        logList.append(" landProps : %r" %landProps)
        logList.append(" waterProps : %r" %waterProps)
        logList.append(" bLakes : %r" %bLakes)
        logList.append(" bClimate : %r" %bClimate)
        logList.append("")
        logList.append(" res multiply :")
        for item in lResMultiply :
                logList.append(" res : %r , factor : %r" %(gc.getBonusInfo(item[0]).getType(), item[1]))
        logList.append("")
        writeLog("", False, logList)

        landTerrain = []
        waterTerrain = []
        for iTerrain in range(nbTerrain) :
                terrainXML = gc.getTerrainInfo(iTerrain)
                if terrainXML.isGraphicalOnly() : continue
                for iBonus in lRes :
                        bonusXML = gc.getBonusInfo(iBonus)
                        if bonusXML.isTerrain(iTerrain) or bonusXML.isFeatureTerrain(iTerrain) :
                                if terrainXML.isWater() : waterTerrain.append(iTerrain)
                                else : landTerrain.append(iTerrain)
                                break

        listTerrain = landTerrain + waterTerrain

        terrainWeak = []
        terrainGood = []
        yieldTerrain = {}
        for iTerrain in landTerrain :
                yieldTerrain[iTerrain] = [gc.getTerrainInfo(iTerrain).getYield(iYield) for iYield in (YieldTypes.YIELD_FOOD, YieldTypes.YIELD_PRODUCTION)]
                if sum(yieldTerrain[iTerrain]) < 2 : terrainWeak.append(iTerrain)
                else : terrainGood.append(iTerrain)

        listFeature = []
        for iFeature in range(nbFeature) :
                for iBonus in lRes :
                        if gc.getBonusInfo(iBonus).isFeature(iFeature) :
                                listFeature.append(iFeature)
                                break

        bonusTerrainWeak = []
        bonusTerrainGood = []
        for iBonus in lResLand :
                bonusXML = gc.getBonusInfo(iBonus)
                for iTerrain in terrainWeak :
                        if bonusXML.isTerrain(iTerrain) or bonusXML.isFeatureTerrain(iTerrain) :
                                bonusTerrainWeak.append(iBonus)
                                break
                for iTerrain in terrainGood :
                        if bonusXML.isTerrain(iTerrain) or bonusXML.isFeatureTerrain(iTerrain) :
                                bonusTerrainGood.append(iBonus)
                                break
                                
        logList = [" terrains , features sort :"]
        logList.append("")
        logList.append(" landTerrain : %r" %([gc.getTerrainInfo(iTerrain).getType() for iTerrain in landTerrain], ))
        logList.append(" waterTerrain : %r" %([gc.getTerrainInfo(iTerrain).getType() for iTerrain in waterTerrain], ))
        logList.append(" terrainWeak : %r" %([gc.getTerrainInfo(iTerrain).getType() for iTerrain in terrainWeak], ))
        logList.append(" terrainGood : %r" %([gc.getTerrainInfo(iTerrain).getType() for iTerrain in terrainGood], ))
        for iTerrain in landTerrain :
                logList.append(" yieldTerrain , %r : %r" %(gc.getTerrainInfo(iTerrain).getType(), yieldTerrain[iTerrain]))
        logList.append("")
        logList.append(" Feature bonus : %r" %([gc.getFeatureInfo(iFeature).getType() for iFeature in listFeature], ))
        logList.append("")
        logList.append(" bonusTerrainWeak : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in bonusTerrainWeak], ))
        logList.append(" bonusTerrainGood : %r" %([gc.getBonusInfo(iBonus).getType() for iBonus in bonusTerrainGood], ))
        logList.append("")
        writeLog("", False, logList)

        rings = generateRings(7)
        cityRings = rings[1] + rings[2]
        dictPlotsPerArea = getAreaPlots()

        # sort list of available land , water plots , placements
        buffTempPlacements = []
        mapSort = [[[[] for iHill in range(2)] for iFeature in range(nbFeature + 1)] for iTerrain in range(nbTerrain)]
        mapBonus = [[-1 for iY in range(iH)] for iX in range(iW)]
        listPlotBonus = [[] for iBonus in range(nbRes)]
        lPlotCanHaveBonus = [[[] for bWater in range(2)] for iBonus in range(nbRes)]
        nbPlaced = [[0 for bWater in range(2)] for iBonus in range(nbRes)]
        lBonusExtend = [[] for iBonus in range(nbRes)]
        landPlots = []
        landPlotsExtra = []
        waterPlots = []
        waterPlotsExtra = []
        lHillPlots = []

        logList = [" Bonus placement extention :"]
        for iX in range(iW):
                for iY in range(iH):
                        pPlot = map.plot(iX, iY)
                        if pPlot.isPeak() :
                                landPlotsExtra.append((iX, iY))
                                continue
                        terrainPlot = pPlot.getTerrainType()
                        featurePlot = pPlot.getFeatureType()
                        bonusPlot = pPlot.getBonusType(-1)

                        if bEraseAll :
                                if not (iX, iY) in lImprovementPlots :
                                        bonusPlot = -1
                                        pPlot.setBonusType(-1)

                        mapBonus[iX][iY] = int(bonusPlot)

                        iWater = 0
                        if pPlot.isWater() : iWater = 1

                        if bonusPlot != -1 :
                                listPlotBonus[bonusPlot].append((iX, iY))
                                pPlot.setBonusType(-1)

                        for iBonus in lGenRes :
                                if pPlot.canHaveBonus(iBonus, not bClimate) : lPlotCanHaveBonus[iBonus][iWater].append((iX, iY))

                        if bonusPlot != -1 : pPlot.setBonusType(bonusPlot)

                        idHill = 0
                        if pPlot.isHills() :
                                idHill = 1
                                lHillPlots.append((iX, iY))

                        if iWater == 1 :
                                if bonusPlot != -1 :
                                        nbPlaced[bonusPlot][1] += 1
                                        waterPlotsExtra.append((iX, iY))
                                elif (iX, iY) in lImprovementPlots :
                                        waterPlotsExtra.append((iX, iY))
                                        continue
                                elif pPlot.isLake() and (not bLakes) :
                                        continue
                                elif len(getListPlotsPerArea((iX, iY), dictPlotsPerArea)) == 1 :
                                        waterPlotsExtra.append((iX, iY))
                                        continue
                                else :
                                        bFound = False
                                        for dX, dY in cityRings :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        if not map.plot(wTP[0], wTP[1]).isWater():
                                                                bFound = True
                                                                break
                                        if bFound :
                                                if (terrainPlot in listTerrain) and ((featurePlot in listFeature) or (featurePlot == -1)) :
                                                        waterPlots.append((iX,iY))
                                                        mapSort[terrainPlot][featurePlot + 1][idHill].append((iX, iY))
                                                else :
                                                        waterPlotsExtra.append((iX, iY))
                                                        continue
                                        else :
                                                continue
                        else :
                                if bonusPlot != -1 :
                                        nbPlaced[bonusPlot][0] += 1
                                        landPlotsExtra.append((iX, iY))
                                        continue
                                elif (iX, iY) in lImprovementPlots :
                                        landPlotsExtra.append((iX, iY))
                                        continue
                                elif len(getListPlotsPerArea((iX, iY), dictPlotsPerArea)) == 1 :
                                        landPlotsExtra.append((iX, iY))
                                        continue
                                elif (terrainPlot in listTerrain) and ((featurePlot in listFeature) or (featurePlot == -1)) :
                                        landPlots.append((iX,iY))
                                        mapSort[terrainPlot][featurePlot + 1][idHill].append((iX, iY))
                                else :
                                        landPlotsExtra.append((iX, iY))
                                        continue

                        placement = (terrainPlot, featurePlot + 1, idHill)
                        if placement in buffTempPlacements : continue
                        buffTempPlacements.append(placement)

                        yieldPlot = [pPlot.calculateBestNatureYield(iYield, noTeam) for iYield in (YieldTypes.YIELD_FOOD, YieldTypes.YIELD_PRODUCTION, YieldTypes.YIELD_COMMERCE)]

                        if featurePlot == -1 : logList.append(" %r , No Feature , hill : %r" %(gc.getTerrainInfo(terrainPlot).getType(), bool(idHill)))
                        else : logList.append(" %r , %r , hill : %r" %(gc.getTerrainInfo(terrainPlot).getType(), gc.getFeatureInfo(featurePlot).getType(), bool(idHill)))

                        for iBonus in lRes :
                                bonusXML = gc.getBonusInfo(iBonus)
                                for iImprovement in range(gc.getNumImprovementInfos()) :
                                        improvementXML = gc.getImprovementInfo(iImprovement)

                                        if not improvementXML.isImprovementBonusMakesValid(iBonus) : continue

                                        if terrainPlot in terrainWeak :
                                                if not (bonusXML.isTerrain(terrainPlot) or bonusXML.isFeatureTerrain(terrainPlot)) :
                                                        continue

                                        if improvementXML.isWater():
                                                if terrainPlot in landTerrain : continue
                                        elif terrainPlot in waterTerrain : continue

                                        if improvementXML.isRequiresFeature() :
                                                if featurePlot == -1 : continue
                                                if not improvementXML.getFeatureMakesValid(featurePlot) : continue

                                        if improvementXML.isRequiresFlatlands() and idHill == 1 : continue

                                        bContinue = False
                                        for iYield in range(3) :
                                                if improvementXML.getPrereqNatureYield(iYield) > yieldPlot[iYield] : bContinue = True
                                        if bContinue : continue

                                        if not placement in lBonusExtend[iBonus] : lBonusExtend[iBonus].append(placement)
                                        logList.append(" %r , %r" %(bonusXML.getType(), improvementXML.getType()))
                        logList.append("")
        writeLog("", False, logList)

        # calculate nb Bonus to place .
        logList = [" bonus to place impl :"]

        nbLandPlots = len(landPlots) + len(landPlotsExtra)
        if nbLandPlots > 0 :
                effLandBonusPer = sum([nbPlaced[iBonus][0] for iBonus in range(nbRes)])*100.0/nbLandPlots
        else :
                effLandBonusPer = 110

        nbWaterPlots = len(waterPlots) + len(waterPlotsExtra)
        if nbWaterPlots > 0 :
                effWaterBonusPer = sum([nbPlaced[iBonus][1] for iBonus in range(nbRes)])*100.0/nbWaterPlots
        else :
                effWaterBonusPer = 110

        nbTotLandBonusToPlace = 0
        if effLandBonusPer < landPer :
                nbTotLandBonusToPlace = int(landPer / 100.0 * nbLandPlots) + 1

        nbTotWaterBonusToPlace = 0
        if effWaterBonusPer < waterPer :
                nbTotWaterBonusToPlace = int(waterPer / 100.0 * nbWaterPlots) + 1

        nbBonusToPlaceNatLoc = [[0 for bWater in range(2)] for iNat in range(3)]

        lResNatLocGen = [[[iBonus for iBonus in lResNatLoc[iNat][bWater] if (not iBonus in lStandardRes) and ( (len(lPlotCanHaveBonus[iBonus][0]) +len(lPlotCanHaveBonus[iBonus][1])) != 0 )] for bWater in range(2) ] for iNat in range(3)]
        nbPlacedNatLoc = [[sum([nbPlaced[iBonus][bWater] for iBonus in lResNatLoc[iNat][bWater]]) for bWater in range(2) ] for iNat in range(3)]
        bCanPlaceNatLoc = [[bool(len(lResNatLocGen[iNat][bWater]) != 0) for bWater in range(2) ] for iNat in range(3)]

        logList.append(" effLandBonusPer : %r" %effLandBonusPer)
        logList.append(" nbTotLandBonusToPlace : %r" %nbTotLandBonusToPlace)
        logList.append(" nbLandBonusPlaced : %r" %(sum([nbPlacedNatLoc[iNat][0] for iNat in range(3)]), ))
        logList.append("")
        logList.append(" effWaterBonusPer : %r" %effWaterBonusPer)
        logList.append(" nbTotWaterBonusToPlace : %r" %nbTotWaterBonusToPlace)
        logList.append(" nbWaterBonusPlaced : %r" %(sum([nbPlacedNatLoc[iNat][1] for iNat in range(3)]), ))
        logList.append("")

        for i in range(3) :
                logList.append(" lResNatLocGen, %s, land  : %r" %(lTag[i], [gc.getBonusInfo(iBonus).getType() for iBonus in lResNatLocGen[i][0]]))
                logList.append(" nbPlacedNatLoc, %s, land  : %r" %(lTag[i], nbPlacedNatLoc[i][0]))
                logList.append(" bCanPlaceNatLoc, %s, land  : %r" %(lTag[i], bCanPlaceNatLoc[i][0]))
                logList.append(" lResNatLocGen, %s, water : %r" %(lTag[i], [gc.getBonusInfo(iBonus).getType() for iBonus in lResNatLocGen[i][1]]))
                logList.append(" nbPlacedNatLoc, %s, water  : %r" %(lTag[i], nbPlacedNatLoc[i][1]))
                logList.append(" bCanPlaceNatLoc, %s, water  : %r" %(lTag[i], bCanPlaceNatLoc[i][1]))
        logList.append("")

        props = [landProps, waterProps]
        nbTotBonusToPlace = [nbTotLandBonusToPlace, nbTotWaterBonusToPlace]

        lSumProp = [sum([props[bWater][iNat] for iNat in range(3) if bCanPlaceNatLoc[iNat][bWater]]) for bWater in range(2)]
        for bWater in range(2) :
                if nbTotBonusToPlace[bWater] == 0 : continue
                if lSumProp[bWater] == 0 : continue

                nbAlreadyPlaced = sum([nbPlacedNatLoc[iNat][bWater] for iNat in range(3)])
                if  nbAlreadyPlaced >= nbTotBonusToPlace[bWater] : continue
                
                for iPass in range(nbTotBonusToPlace[bWater] - nbAlreadyPlaced) :
                        iNatPlace = -1
                        bestValue = -100000
                        for iNat in range(3) :
                                if props[bWater][iNat] == 0 : continue
                                if not bCanPlaceNatLoc[iNat][bWater] : continue
                                valueTemp = (props[bWater][iNat] / float(lSumProp[bWater])) * nbTotBonusToPlace[bWater] - nbPlacedNatLoc[iNat][bWater] - nbBonusToPlaceNatLoc[iNat][bWater]
                                if valueTemp > bestValue :
                                        bestValue = valueTemp
                                        iNatPlace = iNat
                        if iNatPlace == -1 :
                                break
                        else :
                                nbBonusToPlaceNatLoc[iNatPlace][bWater] += 1

        for bWater in range(2) :
                for iNat in range(3) :
                        logList.append(" nbBonusToPlaceNatLoc %r , %r : %r" %(iNat, bWater, nbBonusToPlaceNatLoc[iNat][bWater]))
        logList.append("")

        nbCountRes = [0  for iBonus in range(nbRes)]
        for iBonus in lGenRes :
                bonusXML = gc.getBonusInfo(iBonus)

                iBaseCount = bonusXML.getConstAppearance()
                iBaseCount += bonusXML.getRandAppearance1()
                iBaseCount += bonusXML.getRandAppearance2()
                iBaseCount += bonusXML.getRandAppearance3()
                iBaseCount += bonusXML.getRandAppearance4()

                iTiles = 0
                if bonusXML.getTilesPer() > 0 :
                        iTiles += float(len(lPlotCanHaveBonus[iBonus][0]) + len(lPlotCanHaveBonus[iBonus][1])) / bonusXML.getTilesPer()

                nPlay = (len(playerList) * bonusXML.getPercentPerPlayer()) / 100.0
                iBonusCount = (iBaseCount * (iTiles + nPlay)) / 100.0

                nbCountRes[iBonus] = max(1, iBonusCount)
                logList.append(" %r : %r" %(bonusXML.getType(), nbCountRes[iBonus]))

        logList.append("")

        nbBonusToPlace = [[ 0  for bWater in range(2) ] for iBonus in range(nbRes)]
        nbPlacedNatLocGen = [[sum([nbPlaced[iBonus][bWater] for iBonus in lResNatLocGen[iNat][bWater]]) for bWater in range(2) ] for iNat in range(3)]
        for bWater in range(2) :
                for iNat in range(3) :
                        if nbBonusToPlaceNatLoc[iNat][bWater] == 0 : continue

                        countTp = [0  for iBonus in range(nbRes)]
                        for iBonus in lResNatLocGen[iNatPlace][bWater] : countTp[iBonus] = nbCountRes[iBonus]*(float(len(lPlotCanHaveBonus[iBonus][bWater]))/(len(lPlotCanHaveBonus[iBonus][0]) + len(lPlotCanHaveBonus[iBonus][1])))
                        propMax = max([countTp[iBonus] for iBonus in lResNatLocGen[iNatPlace][bWater]])

                        sumProp = 0.0
                        for iBonus in lResNatLocGen[iNat][bWater] :
                                countTp[iBonus] = max(0.33*propMax, countTp[iBonus])
                                sumProp += countTp[iBonus]

                        nbTotTp = nbPlacedNatLocGen[iNat][bWater] + nbBonusToPlaceNatLoc[iNat][bWater]

                        for iPass in range(nbBonusToPlaceNatLoc[iNat][bWater]) :
                                if sumProp == 0 : break
                                iBonusPlace = -1
                                bestValue = -100000
                                for iBonus in lResNatLocGen[iNat][bWater] :
                                        if countTp[iBonus] == 0 : continue
                                        valueTemp = (countTp[iBonus] / sumProp) * nbTotTp - nbPlaced[iBonus][bWater] - nbBonusToPlace[iBonus][bWater]
                                        if (nbPlaced[iBonus][bWater] == 0) and (nbBonusToPlace[iBonus][bWater] == 0) :
                                                valueTemp += 10000
                                        if valueTemp > bestValue :
                                                bestValue = valueTemp
                                                iBonusPlace = iBonus
                                if iBonusPlace == -1 :
                                        break
                                else :
                                        nbBonusToPlace[iBonusPlace][bWater] += 1

                        if (bEraseAll) and (iNat == 0) :
                                for iBonus in lResNatLocGen[iNat][bWater] :
                                        nbBonusToPlace[iBonus][bWater] = max(1, nbBonusToPlace[iBonus][bWater])

        logList.append(" nb bonus to place before multiply :")
        for iBonus in range(nbRes) : logList.append(" %r : %r" %(gc.getBonusInfo(iBonus).getType(), nbBonusToPlace[iBonus]))
        logList.append("")

        for item in lResMultiply :
                iBonus = item[0]
                rFactor = item[1]

                if iBonus in lResWater :
                        nbAllPlace = nbPlaced[iBonus][1] + nbBonusToPlace[iBonus][1]
                        nbAllPlace = max(1, nbAllPlace)
                        nbBonusToPlace[iBonus][1] = max(1, int(nbAllPlace * rFactor) - nbPlaced[iBonus][1])

                if iBonus in lResLand :
                        nbAllPlace = nbPlaced[iBonus][0] + nbBonusToPlace[iBonus][0]
                        nbAllPlace = max(1, nbAllPlace)
                        nbBonusToPlace[iBonus][0] = max(1, int(nbAllPlace * rFactor) - nbPlaced[iBonus][0])

        logList.append(" nb bonus to place after multiply :")
        for iBonus in range(nbRes) : logList.append(" %r : %r" %(gc.getBonusInfo(iBonus).getType(), nbBonusToPlace[iBonus]))
        logList.append("")

        writeLog("", False, logList)

        lBonusWP = [iBonus for iBonus in range(nbRes) if ((nbBonusToPlace[iBonus][0] > 0) or (nbBonusToPlace[iBonus][1] > 0))]

        if lBonusWP == [] :
                writeLog("", True, [" No Bonus to Place ... continue"])
                return

        # map of bonus percentage per plot :
        bonusPercentPlot = {}
        bonusPlots = [landPlots, waterPlots]
        bonusPlotsExtra = [landPlotsExtra, waterPlotsExtra]

        for bWater in range(2) :
                for coord in bonusPlots[bWater] :
                        iX, iY = coord
                        bonusPercentPlot[coord] = [0, 0, 0, 0, 0, 0, 0, 0, 0] #nbTiles, nb bonuses, nbPro, nbFoo, nbLux, per, pro per, foo per, lux per
                        for iRing in range(4) :
                                for dX, dY in rings[iRing] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP != -1 :
                                                if (wTP in bonusPlots[bWater]) or (wTP in bonusPlotsExtra[bWater]) :
                                                        boPlTP = mapBonus[wTP[0]][wTP[1]]
                                                        if boPlTP != -1 :
                                                                bonusPercentPlot[coord][1] += 1
                                                                if boPlTP in lResPro : bonusPercentPlot[coord][2] += 1
                                                                elif boPlTP in lResFoo : bonusPercentPlot[coord][3] += 1
                                                                elif boPlTP in lResLux : bonusPercentPlot[coord][4] += 1
                                                        bonusPercentPlot[coord][0] += 1

        def updatePercents(iBD, x, y, bW) :
                if iBD in lResPro : iIN = 2
                elif iBD in lResFoo : iIN = 3
                else : iIN = 4
                for iRing in range(1, 4) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(x + dX, y + dY)
                                if wTP != -1 :
                                        if wTP in bonusPlots[bW] :
                                                bonusPercentPlot[wTP][1] += 1
                                                bonusPercentPlot[wTP][5] = int(bonusPercentPlot[wTP][1]/float(bonusPercentPlot[wTP][0])*100)
                                                bonusPercentPlot[wTP][iIN] += 1
                                                bonusPercentPlot[wTP][4 + iIN] = int(bonusPercentPlot[wTP][iIN]/float(bonusPercentPlot[wTP][0])*100)

        # map of distance between bonuses and between bonus class :
        bonusDist = [[[ 8 for iY in range(iH) ] for iX in range(iW) ] for iBonus in range(nbRes) ]
        bonusClass = [ gc.getBonusInfo(iBonus).getBonusClassType() for iBonus in range(nbRes) ]
        nbClass = max(bonusClass) + 1
        bonusClassDist = [[[ 8 for iY in range(iH) ] for iX in range(iW) ] for iClass in range(nbClass) ]
        for i in range(4) :
                for coord in bonusPercentPlot.keys() :
                        bonusPercentPlot[coord][i + 5] = int(bonusPercentPlot[coord][i + 1]/float(bonusPercentPlot[coord][0])*100)

        def updateDistance(iBD, x, y) :
                iBCD = bonusClass[iBD]
                for iRing in range(8) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(x + dX, y + dY)
                                if wTP != -1 :
                                        nX, nY = wTP
                                        bonusDist[iBD][nX][nY] = min(iRing, bonusDist[iBD][nX][nY])
                                        bonusClassDist[iBCD][nX][nY] = min(iRing, bonusClassDist[iBCD][nX][nY])

        for iX in range(iW) :
                for iY in range(iH) :
                        boPlTP = mapBonus[iX][iY]
                        if boPlTP == -1 : continue
                        updateDistance(boPlTP, iX, iY)

        # prevent group of bonus on bad terrain by scale :
        # if a bonus can only be place on snow for example ,and because there is not a lot of bonus for snow . Make it placed 1/2 only on good terrain
        bOnlyGood = [True for i in range(nbRes)]
        logList = [" Start Bonus Placement :"]
        originalNB = copy.deepcopy(nbPlaced)
        originalBTP = copy.deepcopy(nbBonusToPlace)
        lHillPlots = [coord for coord in lHillPlots if coord in bonusPlots[0]]
        for bWater in range(2) :
                for iBonus in range(nbRes) :
                        lPlotCanHaveBonus[iBonus][bWater] = [ coord for coord in lPlotCanHaveBonus[iBonus][bWater] if coord in bonusPlots[bWater] ]

        if bClimate :
                lLatPlot = [ [map.plot(iX, iY).getLatitude() for iY in range(iH) ] for iX in range(iW) ]

        def placeBonusAndUpdate(iBU, co, bWU) :
                pTempPlot = map.plot(co[0], co[1])
                terrainPlot = pTempPlot.getTerrainType()
                featurePlot = pTempPlot.getFeatureType()
                idHill = 0
                if pTempPlot.isHills() : idHill = 1
                if idHill == 1 : lHillPlots.remove(co)
                pTempPlot.setBonusType(iBU)
                bonusPlots[bWU].remove(co)
                del bonusPercentPlot[co]
                mapSort[terrainPlot][featurePlot + 1][idHill].remove(co)
                nbPlaced[iBU][bWU] += 1
                nbBonusToPlace[iBU][bWU] -= 1
                updatePercents(iBU, co[0], co[1], bWU)
                updateDistance(iBU, co[0], co[1])
                for iBI in lBonusWP :
                        if co in lPlotCanHaveBonus[iBI][bWU] :
                                lPlotCanHaveBonus[iBI][bWU].remove(co)

        def addBonusAway(iB, bWat) :
                if not bWat : bOnlyGood[iB] = not bOnlyGood[iB]
                iBC = bonusClass[iB]
                if iB in lResPro : iN = 2
                elif iB in lResFoo : iN = 3
                else : iN = 4

                lNaturalPlots = lPlotCanHaveBonus[iB][bWat]

                lOtherPlots = []
                if bWat :
                        for pl in lBonusExtend[iB] :
                                if pl[0] in waterTerrain :
                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])

                if not bWat :
                        bOnlyWeak = (iB in bonusTerrainWeak) and (not iB in bonusTerrainGood)
                        for pl in lBonusExtend[iB] :
                                if pl[0] in landTerrain :
                                        if (bOnlyWeak) and (bOnlyGood[iB]) :
                                                if pl[0] in terrainWeak : continue
                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])

                        if (lOtherPlots == []) and (bOnlyWeak) and (bOnlyGood[iB]) :
                                for pl in lBonusExtend[iB] :
                                        if pl[0] in landTerrain :
                                                if pl[0] in terrainWeak :
                                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])
                lOtherPlots = [coord for coord in lOtherPlots if not coord in lNaturalPlots]

                if bClimate :
                        minLat = gc.getBonusInfo(iB).getMinLatitude()
                        maxLat = gc.getBonusInfo(iB).getMaxLatitude()
                        lOtherPlots = [ coord for coord in lOtherPlots if (lLatPlot[coord[0]][coord[1]] <= maxLat) and (lLatPlot[coord[0]][coord[1]] >= minLat) ]
                        
                allPlots = copy.copy(lNaturalPlots) + copy.copy(lOtherPlots)

                if allPlots == [] :
                        logList.append(" ... No more place for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #Choose plots at max distance from same bonus , class (let range 1 for quality placement)
                maxDistClass = max([bonusClassDist[iBC][nX][nY] for nX, nY in allPlots])
                maxDistClass -= 1
                allPlots = [ coord for coord in allPlots if bonusClassDist[iBC][coord[0]][coord[1]] >= maxDistClass ]
                
                maxDistSBonus = max([bonusDist[iB][nX][nY] for nX, nY in allPlots])
                maxDistSBonus -= 1
                allPlots = [ coord for coord in allPlots if bonusDist[iB][coord[0]][coord[1]] >= maxDistSBonus ]

                if allPlots == [] :
                        logList.append(" ... allPlots == [] after bonus(class) sort (Strange) for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #Choose plots with less percentage of bonus (& nat bonus) around
                lPlotBonPer = [bonusPercentPlot[coord][5] for coord in allPlots]
                minPer = min(lPlotBonPer)
                maxPer = max(lPlotBonPer)
                if maxPer > minPer :
                        minPer += int((maxPer-minPer)/3.0)
                minPer += 1
                allPlots = [ coord for coord in allPlots if bonusPercentPlot[coord][5] <= minPer ]

                iNPer = iN + 4        
                lPlotNatPer = [bonusPercentPlot[coord][iNPer] for coord in allPlots]
                minPer = min(lPlotNatPer)
                maxPer = max(lPlotNatPer)
                if maxPer > minPer :
                        minPer += int((maxPer-minPer)/3.0)
                minPer += 1
                allPlots = [ coord for coord in allPlots if bonusPercentPlot[coord][iNPer] <= minPer ]

                if allPlots == [] :
                        logList.append(" ... allPlots == [] percentage of bonus (& nat bonus) around (Strange) for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #Try to choose the better matching tiles for bonuses , features non taken in count .
                lTemp = []
                if not bWat :
                        bOHill = gc.getBonusInfo(iB).isHills()
                        bOFlat = gc.getBonusInfo(iB).isFlatlands()

                        if (bOHill) and (not bOFlat) :
                                lTemp = [ coord for coord in allPlots if coord in lHillPlots ]

                        elif (not bOHill) and (bOFlat) :
                                lTemp = [ coord for coord in allPlots if not coord in lHillPlots ]

                if lTemp != [] : allPlots = copy.copy(lTemp)

                lTemp = [ coord for coord in allPlots if coord in lNaturalPlots ]

                if lTemp != [] : allPlots = copy.copy(lTemp)

                if allPlots == [] :
                        logList.append(" ... allPlots == [] (Strange) for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #choose tile
                choice = getRandNum(len(allPlots), " FoR : addBonusAway plot rand")
                placeBonusAndUpdate(iB, allPlots[choice], bWat)

        #count the number of resources groups for resources that should be added close .
        nbGroup = [0 for i in range(nbRes)]
        for iBonus in lGroupRes :
                tpList = []
                for coord in listPlotBonus[iBonus] :
                        if coord in tpList : continue
                        tpList.append(coord)
                        nbGroup[iBonus] += 1
                        lPlotToTest = [coord]
                        while True :
                                if len(lPlotToTest) == 0 : break
                                iX, iY = lPlotToTest[0]
                                lPlotToTest.remove((iX, iY))
                                for iRing in range(1, 4) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        if wTP in listPlotBonus[iBonus] :
                                                                if not wTP in tpList :
                                                                        tpList.append(wTP)
                                                                        lPlotToTest.append(wTP)
                
        def addBonusClose(iB, bWat) :
                if nbGroup[iB] < max(0, int(map.getWorldSize()) -1) + 1 :
                        nbGroup[iB] += 1
                        addBonusAway(iB, bWat)
                        return

                if not bWat : bOnlyGood[iB] = not bOnlyGood[iB]
                iBC = bonusClass[iB]
                if iB in lResPro : iN = 2
                elif iB in lResFoo : iN = 3
                else : iN = 4

                lNaturalPlots = lPlotCanHaveBonus[iB][bWat]

                lOtherPlots = []
                if bWat :
                        for pl in lBonusExtend[iB] :
                                if pl[0] in waterTerrain :
                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])

                if not bWat :
                        bOnlyWeak = (iB in bonusTerrainWeak) and (not iB in bonusTerrainGood)
                        for pl in lBonusExtend[iB] :
                                if pl[0] in landTerrain :
                                        if (bOnlyWeak) and (bOnlyGood[iB]) :
                                                if pl[0] in terrainWeak : continue
                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])

                        if (lOtherPlots == []) and (bOnlyWeak) and (bOnlyGood[iB]) :
                                for pl in lBonusExtend[iB] :
                                        if pl[0] in landTerrain :
                                                if pl[0] in terrainWeak :
                                                        lOtherPlots += copy.copy(mapSort[pl[0]][pl[1]][pl[2]])
                lOtherPlots = [coord for coord in lOtherPlots if not coord in lNaturalPlots]

                if bClimate :
                        minLat = gc.getBonusInfo(iB).getMinLatitude()
                        maxLat = gc.getBonusInfo(iB).getMaxLatitude()
                        lOtherPlots = [ coord for coord in lOtherPlots if (lLatPlot[coord[0]][coord[1]] <= maxLat) and (lLatPlot[coord[0]][coord[1]] >= minLat) ]
                        
                allPlots = copy.copy(lNaturalPlots) + copy.copy(lOtherPlots)

                if allPlots == [] :
                        logList.append(" ... No more place for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #Choose plots at max distance 3
                allPlots = [ coord for coord in allPlots if bonusDist[iB][coord[0]][coord[1]] <= 3]

                if allPlots == [] :
                        logList.append(" ... allPlots == [] after bonus dist for bonus %r (bWater %r) ... will try bonus away" %(gc.getBonusInfo(iB).getType(), bWat))
                        addBonusAway(iB, bWat)
                        return

                #Choose plots with less percentage of bonus (& nat bonus) around
                lPlotBonPer = [bonusPercentPlot[coord][5] for coord in allPlots]
                minPer = min(lPlotBonPer)
                maxPer = max(lPlotBonPer)
                if maxPer > minPer :
                        minPer += int((maxPer-minPer)/3.0)
                minPer += 1
                allPlots = [ coord for coord in allPlots if bonusPercentPlot[coord][5] <= minPer ]

                iNPer = iN + 4        
                lPlotNatPer = [bonusPercentPlot[coord][iNPer] for coord in allPlots]
                minPer = min(lPlotNatPer)
                maxPer = max(lPlotNatPer)
                if maxPer > minPer :
                        minPer += int((maxPer-minPer)/3.0)
                minPer += 1
                allPlots = [ coord for coord in allPlots if bonusPercentPlot[coord][iNPer] <= minPer ]

                if allPlots == [] :
                        logList.append(" bonus close ... allPlots == [] percentage of bonus (& nat bonus) around (Strange) for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #Try to choose the better matching tiles for bonuses , features non taken in count .
                lTemp = []
                if not bWat :
                        bOHill = gc.getBonusInfo(iB).isHills()
                        bOFlat = gc.getBonusInfo(iB).isFlatlands()

                        if (bOHill) and (not bOFlat) :
                                lTemp = [ coord for coord in allPlots if coord in lHillPlots ]

                        elif (not bOHill) and (bOFlat) :
                                lTemp = [ coord for coord in allPlots if not coord in lHillPlots ]

                if lTemp != [] : allPlots = copy.copy(lTemp)

                lTemp = [ coord for coord in allPlots if coord in lNaturalPlots ]

                if lTemp != [] : allPlots = copy.copy(lTemp)

                if allPlots == [] :
                        logList.append(" bonus close ... allPlots == [] (Strange) for bonus %r (bWater %r)" %(gc.getBonusInfo(iB).getType(), bWat))
                        nbBonusToPlace[iB][bWat] = 0
                        return

                #choose tile
                choice = getRandNum(len(allPlots), " FoR : addBonusClose plot rand")
                placeBonusAndUpdate(iB, allPlots[choice], bWat)

        #arg ... place bonus now :)
        while True :
                bPlaceOne = False
                for bWater in range(2) :
                        for iBonus in range(nbRes) :
                                if nbBonusToPlace[iBonus][bWater] > 0 :
                                        bPlaceOne = True 
                                        if iBonus in lGroupRes :
                                                addBonusClose(iBonus, bWater)
                                        else :
                                                addBonusAway(iBonus, bWater)
                if not bPlaceOne : break

        for iBonus in range(nbRes):
                logList.append("%s :: Land : nbOri %d , nbToPlace %d , nbPlacedAfter %d ... diff %d" %(gc.getBonusInfo(iBonus).getType(), originalNB[iBonus][0], originalBTP[iBonus][0], nbPlaced[iBonus][0], nbPlaced[iBonus][0]-originalNB[iBonus][0]-originalBTP[iBonus][0]))
        logList.append("")

        for iBonus in range(nbRes):
                logList.append("%s :: Water : nbOri %d , nbToPlace %d , nbPlacedAfter %d ... diff %d" %(gc.getBonusInfo(iBonus).getType(), originalNB[iBonus][1], originalBTP[iBonus][1], nbPlaced[iBonus][1], nbPlaced[iBonus][1]-originalNB[iBonus][1]-originalBTP[iBonus][1]))
        logList.append("")

        writeLog("", True, logList)

def minStartingDistanceModifier():
        # keep original values in case default generation must be run
        if bGeneratingMap :
                if idMap in ["customcontinents", "bigandsmall", "hemispheres"] :
                        return -12
                elif idMap in ["hub", "ring", "wheel"] :
                        global bSuccessFlag
                        if bSuccessFlag == True:
                                return -95
                        else:
                                return -50
                elif idMap == "inlandsea" :
                        numPlrs = game.countCivPlayersEverAlive()
                        if numPlrs  <= 18:
                                return -95
                        else:
                                return -50
                elif idMap == "lakes" :
                        return -15
                elif idMap == "terra" :
                        return -20
	return 0

def assignStartingPlots() :
        global bStandardAssignment
        global oldWorldStart
        global playerShuffledAssignment
        bStandardAssignment = False
        oldWorldStart = False
        playerShuffledAssignment = shuffleList(copy.copy(playerList))

        if "startterra" in selGen["maps"][idMap].keys() :
                if 2 in selGen["maps"][idMap]["startterra"] : oldWorldStart = True
        if idMap == "tectonics" :
                if cmo[0] == 7 : oldWorldStart = True
        if idMap in ["lakes", "pangaea"] :
                oldWorldStart = True

        try :
                if StoAssignStartingPlots() :
                        return None
        except :
                writeLog("", True, ["", " An error occured during assign starting plots ... launch default impl"])
                writeError()
        writeLog("", False, [" assignStartingPlots : running default impl ....", ""])
        bStandardAssignment = True

        CyPythonMgr().allowDefaultImpl()

def findStartingPlot(argsList):
	[playerID] = argsList
        if idMap in ["hub", "ring", "wheel"] :
                if bSuccessFlag :
                        pPlayer = gc.getPlayer(playerID)
                        pPlayer.AI_updateFoundValues(True)
                        
                        iRegionIndex = playerShuffledAssignment.index(playerID)

                        [regWestX, regEastX, regSouthY, regNorthY] = region_data[iRegionIndex]
                        regWidth = regEastX - regWestX + 1
                        regHeight = regNorthY - regSouthY + 1
                        iStartX = regWestX + int(regWidth / 2)
                        iStartY = regSouthY + int(regHeight / 2)

                        map_size = map.getWorldSize()
                        sizevalues = {
                                WorldSizeTypes.WORLDSIZE_DUEL:		(2, 3),
                                WorldSizeTypes.WORLDSIZE_TINY:		(2, 4),
                                WorldSizeTypes.WORLDSIZE_SMALL:		(3, 6),
                                WorldSizeTypes.WORLDSIZE_STANDARD:	(4, 10),
                                WorldSizeTypes.WORLDSIZE_LARGE:		(6, 12),
                                WorldSizeTypes.WORLDSIZE_HUGE:		(6, 18)
                                }
                        iPlotShift = 3
                        if map_size in sizevalues.keys() :
                                (threeVar, twoVar) = sizevalues[map_size]
                                if len(playerList) <= threeVar :
                                        iPlotShift = 3
                                elif len(playerList) <= twoVar :
                                        iPlotShift = 2
                                else:
                                        iPlotShift = 1

                        westX = max(2, iStartX - iPlotShift)
                        eastX = min(iW - 3, iStartX + iPlotShift)
                        southY = max(2, iStartY - iPlotShift)
                        northY = min(iH - 3, iStartY + iPlotShift)

                        iBestAreaID = map.findBiggestArea(False).getID()

                        while True :
                                if iPlotShift > 4 : break
                                
                                pBestPlot = None
                                iBestValue = 0
                                for iPass in range(2) :
                                        for dX in range(-1 - iPlotShift, iPlotShift +1) :
                                                for dY in range(-1 - iPlotShift, iPlotShift +1) :
                                                        iX = iStartX + dX
                                                        iY = iStartY + dY

                                                        if iX < 2 : continue
                                                        if iX > iW - 3 : continue
                                                        if iY < 2 : continue
                                                        if iY > iH - 3 : continue

                                                        pLoopPlot = map.plot(iX, iY)
                                                        if (iPass == 0) and (pLoopPlot.getArea() != iBestAreaID) : continue

                                                        val = pLoopPlot.getFoundValue(playerID)

                                                        if val > iBestValue :
                                                                val = iBestValue
                                                                pBestPlot = pLoopPlot

                                        if pBestPlot != None : return map.plotNum(pBestPlot.getX(), pBestPlot.getY())

                                iPlotShift += 1

        CyPythonMgr().allowDefaultImpl()
        
def findStartingArea(argsList):
	[playerID] = argsList
	if oldWorldStart : return map.findBiggestArea(False).getID()
        CyPythonMgr().allowDefaultImpl()

def StoAssignStartingPlots():
        writeLog(" = StoAssignStartingPlots = ", False, [""])

        bCoast = False
        bInland = False
        bSameArea = False

        if "start" in selGen["maps"][idMap].keys() :
                if 0 in selGen["maps"][idMap]["start"] : bCoast = True
                if 1 in selGen["maps"][idMap]["start"] : bInland = True
        elif "startterra" in selGen["maps"][idMap].keys() :
                if 0 in selGen["maps"][idMap]["startterra"] : bCoast = True
                if 1 in selGen["maps"][idMap]["startterra"] : bInland = True
                if 2 in selGen["maps"][idMap]["startterra"] : bSameArea = True
        if idMap == "tectonics" :
                if cmo[0] == 7 : bSameArea = True
        if (not bCoast) and (not bInland) or (idMap == "lakes") :
                bCoast = True
                bInland = True

        logList = []
        logList.append(" bCoast : %r" %(bCoast, ))
        logList.append(" bInland : %r" %(bInland, ))
        logList.append(" bSameArea : %r" %(bSameArea, ))

	iRangeStart = max(12, int(sqrt((iH*iW)/nbPlayer)))
        logList.append(" iRangeStart : %r" %(iRangeStart, ))
        rings = generateRings(iRangeStart)
        dictPlotsPerArea = getAreaPlots()
        lPlayers = shuffleList(copy.copy(playerList))

        lakeSize = gc.getDefineINT("LAKE_MAX_AREA_SIZE")
        oceanSize = getOceanMinSize()

        logList.append(" lakeSize : %r" %(lakeSize, ))
        logList.append(" oceanSize : %r" %(oceanSize, ))

        # keep these values for later improvements
        bRemovePeaks = bool(getNormalizeRemovePeaks())
        bRemoveBadFeatures = bool(getNormalizeRemoveBadFeatures())
        bRemoveBadTerrains = bool(getNormalizeRemoveBadTerrain())
        bEraseBonus = copy.copy(selGen["resources"]["resourcesstart"]["removestartres"])
        # will guess that the player equalize bonuses if at least one additionnal bonus is added near starting location
        # (normalizations will do the rest, if not)
        if not bEraseBonus :
                for sOptionTag in selGen["resources"]["resourcesstart"].keys() :
                        if "startresselect-" in sOptionTag :
                                locTag = "startreslocation-" + str(splitTag(sOptionTag)[1])
                                if selGen["resources"]["resourcesstart"][locTag] == 0 :
                                        bEraseBonus = True
                                        break

        logList.append(" bRemovePeaks : %r" %(bRemovePeaks, ))
        logList.append(" bRemoveBadFeatures : %r" %(bRemoveBadFeatures, ))
        logList.append(" bRemoveBadTerrains : %r" %(bRemoveBadTerrains, ))
        logList.append(" bEraseBonus : %r" %(bEraseBonus, ))
        logList.append("")
        writeLog("", False, logList)

        nbRes = gc.getNumBonusInfos()
        nbTerrain = gc.getNumTerrainInfos()
        nbFeature = gc.getNumFeatureInfos()

        landTerrain = []
        waterTerrain = []
        for iTerrain in range(nbTerrain) :
                terrainXML = gc.getTerrainInfo(iTerrain)
                if terrainXML.isGraphicalOnly() : continue
                if terrainXML.isWater() : waterTerrain.append(iTerrain)
                else : landTerrain.append(iTerrain)

        terrainWeak = []
        terrainGood = []
        yieldTerrain = {}
        for iTerrain in landTerrain :
                yieldTerrain[iTerrain] = [gc.getTerrainInfo(iTerrain).getYield(iYield) for iYield in (YieldTypes.YIELD_FOOD, YieldTypes.YIELD_PRODUCTION)]
                if sum(yieldTerrain[iTerrain]) < 2 : terrainWeak.append(iTerrain)
                else : terrainGood.append(iTerrain)

        listFeature = []
        featureWeak = []
        featureGood = [-1]
        yieldFeature = {}
        yieldFeature[-1] = 0
        for iFeature in range(nbFeature) :
                featureXML = gc.getFeatureInfo(iFeature)
                yieldFeature[iFeature] = sum([featureXML.getYieldChange(iYield) for iYield in (YieldTypes.YIELD_FOOD, YieldTypes.YIELD_PRODUCTION)])
                if (yieldFeature[iFeature] < 0) or (featureXML.isImpassable()) : featureWeak.append(iFeature)
                else : featureGood.append(iFeature)

        lNoStartTerrain = [gc.getInfoTypeForString('TERRAIN_SNOW'), gc.getInfoTypeForString('TERRAIN_TUNDRA')]

        areaList = []
        for listPlots in dictPlotsPerArea["land"] :
                areaValue = 0
                for iX, iY in listPlots :
                        pPlot = map.plot(iX, iY)
                        if (pPlot.isPeak()) or (pPlot.isImpassable()) :
                                continue
                        if pPlot.getTerrainType() in terrainGood :
                                areaValue += 2
                        elif pPlot.calculateTotalBestNatureYield(TeamTypes.NO_TEAM) > 2 :
                                areaValue += 2
                        else :
                                areaValue += 1
                areaList.append([areaValue, listPlots])

        areaList.sort()
        areaList.reverse()

        def makeMask(co, ir) :
                lL = []
                iX, iY = co
                for iR in range(ir + 1) :
                        for dX, dY in rings[iR] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        lL.append(wTP)
                return lL

        logList = []
        # area assignment
        bOtherAssignment = False
        if (idMap == "customcontinents") and (len(teamList)<7) :
                if cmo[0] == 1 :
                        shuffleT = shuffleList(copy.copy(teamList))
                        lPTeams = [ [iPlayer for iPlayer in playerList if gc.getPlayer(iPlayer).getTeam() == iTeam] for iTeam in shuffleT ]
                        lLenTeams = [len(item) for item in lPTeams]
                        lLenTeams = list(set(lLenTeams))
                        lLenTeams.sort()
                        lLenTeams.reverse()
                        lPlayersPerTeam = []
                        for i in range(len(lLenTeams)) :
                                lPlayersPerTeam += [ item for item in lPTeams if len(item) == lLenTeams[i] ]

                        if len(lPlayersPerTeam) <= len(areaList) :
                                bOtherAssignment = True
                                areaPlayer = [ [lPlayersPerTeam[i], areaList[i][1]] for i in range(len(lPlayersPerTeam)) ]

        if idMap in ["hub", "ring", "wheel"] :
                if bSuccessFlag :
                        shuffleP = shuffleList(copy.copy(playerList))
                        sPlotPerPlayer = []
                        for region_loop in range(len(shuffleP)):
                                [regWestX, regEastX, regSouthY, regNorthY] = region_data[region_loop]
                                regWidth = regEastX - regWestX + 1
                                regHeight = regNorthY - regSouthY + 1
                                iStartX = regWestX + int(regWidth / 2)
                                iStartY = regSouthY + int(regHeight / 2)
                                sPlotPerPlayer.append((iStartX, iStartY))

                        minAirDist = 100000
                        for iPlayer1 in range(len(shuffleP)) :
                                for iPlayer2 in range(iPlayer1 + 1, len(shuffleP)) :
                                        distP = calculateAirDistance(sPlotPerPlayer[iPlayer1], sPlotPerPlayer[iPlayer2])
                                        if distP < minAirDist : minAirDist = distP

                        iShiftRange = max(min(int(minAirDist/3.5), 12), 3)

                        BAllGoods = True
                        areaPlayer = []
                        for region_loop in range(len(shuffleP)):
                                [regWestX, regEastX, regSouthY, regNorthY] = region_data[region_loop]
                                centerPlot = sPlotPerPlayer[region_loop]
                                maskAPlots = makeMask(centerPlot, iShiftRange)

                                lPlayerAroundPlots = []
                                if idMap == "hub" :
                                        # be sure a player is in his own region (got 2 players in the same region once)
                                        clearPlot = -1
                                        iX, iY = centerPlot
                                        for iRing in range(5) :
                                                if clearPlot != -1 : break
                                                for dX, dY in rings[iRing] :
                                                        wTP = toWrap(iX + dX, iY + dY)
                                                        if wTP != -1 :
                                                                pLoopPlot = map.plot(wTP[0], wTP[1])
                                                                if pLoopPlot.isWater() : continue
                                                                if pLoopPlot.isPeak() : continue
                                                                if pLoopPlot.isImpassable() : continue
                                                                clearPlot = wTP
                                                                break

                                        if clearPlot != -1 :
                                                iX, iY = clearPlot
                                                pCenterPlot = map.plot(iX, iY)
                                                for areaValue, lRegionPlots in areaList :
                                                        for coord in maskAPlots :
                                                                dX, dY = coord
                                                                if not coord in lRegionPlots : continue
                                                                if regWestX >= dX : continue
                                                                if regEastX <= dX : continue
                                                                if regSouthY >= dY : continue
                                                                if regNorthY <= dY : continue
                                                                pRegionPlot = map.plot(dX, dY)
                                                                if pRegionPlot.isWater() : continue
                                                                if pRegionPlot.isPeak() : continue
                                                                if pRegionPlot.isImpassable() : continue
                                                                pathDist = map.calculatePathDistance(pCenterPlot, pRegionPlot)
                                                                map.resetPathDistance()
                                                                if pathDist == -1 : continue
                                                                if pathDist > 2 * max(abs(iX - dX), abs(iY - dY)) : continue
                                                                lPlayerAroundPlots.append(coord)
                                                        if lPlayerAroundPlots != [] : break
                                else :
                                        # loop over best list of plots (even if the regions should all be connected, got two separate hub one time ... the default impl should have WOC in this case)
                                        for areaValue, lRegionPlots in areaList :
                                                lPlayerAroundPlots = [ coord for coord in maskAPlots if (coord in lRegionPlots) and (regWestX<coord[0]<regEastX) and (regSouthY<coord[1]<regNorthY)]
                                                if lPlayerAroundPlots != [] : break

                                if lPlayerAroundPlots == [] :
                                        BAllGoods = False
                                        logList.append(" can't define a player zone for hub, ring or wheel ...")
                                        break

                                areaPlayer.append([[shuffleP[region_loop]], lPlayerAroundPlots])

                        if BAllGoods :
                                bOtherAssignment = True

        if not bOtherAssignment :
                if bSameArea :
                        areaPlayer = [ [lPlayers, areaList[0][1]] ]
                else :
                        areaPlayer = [ [[], areaList[i][1]] for i in range(len(areaList)) ]
                        for iPlayer in lPlayers :
                                bestArea = -1
                                bestIndex = -1
                                for i in range(len(areaPlayer)) :
                                        nArea = len(areaPlayer[i][1]) / (len(areaPlayer[i][0]) + 1)
                                        if nArea > bestArea :
                                                bestArea = nArea
                                                bestIndex = i
                                areaPlayer[bestIndex][0].append(iPlayer)
        logList.append(" areaList : %r" %([ [item[0], len(item[1])] for item in areaPlayer if item[0] != [] ], ))

        # coastal value change
        coastalValue = {}
        lCountPlots = []
        for lPl, lPlo in areaPlayer :
                if len(lPl) > 0 :
                        for coord in lPlo : coastalValue[coord] = [4, 0, 0] #dist ocean, coastal ocean value, nb lakes tiles

        lCountPlots = coastalValue.keys()

        for lWPlots in dictPlotsPerArea["water"] :
                bOcean = True
                if len(lWPlots) < oceanSize : bOcean = False
                for coord in lWPlots :
                        iX, iY = coord
                        if bOcean :
                                val = 2
                                if map.plot(iX, iY).isAdjacentToLand() : val = 1
                        for iRing in range(1, 4) :
                                for dX, dY in rings[iRing] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP != -1 :
                                                if wTP in lCountPlots :
                                                        if bOcean :
                                                                coastalValue[wTP][0] = min(iRing, coastalValue[wTP][0])
                                                                coastalValue[wTP][1] += val
                                                        elif iRing < 3 :
                                                                coastalValue[wTP][2] += 1

        # found values (based on original found values , no poles start , found value decrease if lots of water)
        #!! make my own plot value with normalizations defined and bonuses
        for iPlayer in playerList :
                gc.getPlayer(iPlayer).AI_updateFoundValues(True)

        lC = [[] for i in range(4)]
        foundValues = {}
        for coord in lCountPlots :
                coastDist = coastalValue[coord][0]
                coastVal = coastalValue[coord][1]
                lakeVal = coastalValue[coord][2]
                lC[coastDist - 1].append(coord)
                foundValues[coord] = {}
                valuePer = 1
                pPlot = map.plot(coord[0], coord[1])

                if pPlot.getTerrainType() in lNoStartTerrain :
                        valuePer = 0
                elif coastVal > 0 : # default found values already take in count water tiles as bad tiles , increase this effect
                        if coastDist == 1 :
                                if coastVal > 4 :
                                        valuePer = 0.85
                                elif coastVal > 7 :
                                        valuePer = 0.77
                                elif coastVal > 10 :
                                        valuePer = 0.69
                                elif coastVal > 13 :
                                        valuePer = 0.61
##                        elif coastDist == 2 :
##                                valuePer -= coastVal*0.05
                if coastDist == 3 : # Inland start better at at lest 3 tiles from the ocean
                        valuePer -= 0.1
                valuePer = max(0, valuePer - lakeVal*0.02)

                for iPlayer in playerList :
                        foundValues[coord][iPlayer] = int(pPlot.getFoundValue(iPlayer)* valuePer)

        #!! make values in function of size and nb players
        nbAttempts = 8
        minDist = 7
        maxDist = 10
        perValue = 0.84
        bAssign = True

        def initG() :
                global maskMinDistPlots
                global maskMaxDistPlots
                global plotsAssigned

                maskMinDistPlots = []
                maskMaxDistPlots = []
                plotsAssigned = {}

        initG()

        def placePlayersInArea(lP, lPlots, iRange) :
                lResult = [ [-1, []] for i in range(nbAttempts) ]

                for iAttempt in range(nbAttempts) :
                        minVal = -1
                        maxVal = 0
                        listPl = copy.deepcopy(lPlots)

                        for iPlayer in lP :
                                lValuePlots = [ (foundValues[coord][iPlayer], coord) for coord in listPl ]
                                limValMin = int(maxVal*(perValue - iAttempt * 0.02))
                                lValuePlots = [ item for item in lValuePlots if item[0] > limValMin ]

                                if lValuePlots == [] : break

                                lValuePlots.sort()
                                lValuePlots.reverse()

                                nbR = min(3, len(lValuePlots))

                                iChoice = getRandNum(nbR, "FoR : Start Plot choice")

                                val, pCoord = lValuePlots[iChoice]

                                if val > maxVal : maxVal = val
                                if (val < minVal) or (minVal == -1) : minVal = val

                                lResult[iAttempt][0] = minVal
                                lResult[iAttempt][1].append([iPlayer, pCoord])

                                tpMask = makeMask(pCoord, iRange)
                                listPl = [coord for coord in listPl if not coord in tpMask]

                bestVal = -1
                bestList = []
                for iAttempt in range(nbAttempts) :
                        val, lPPList = lResult[iAttempt]

                        if len(lPPList) > len(bestList) :
                                bestVal = val
                                bestList = lPPList
                        elif (val > bestVal) and (len(lPPList) == len(bestList)) :
                                bestVal = val
                                bestList = lPPList

                return bestList

        def placePlayersOneArea(lPl, lBPlots):
                global maskMinDistPlots
                global maskMaxDistPlots
                global plotsAssigned

                logList.append(" place player (%r) for one area : %r" %(lPl, len(lBPlots)))

                lValidPlots = []
                if bCoast :
                        lValidPlots += [coord for coord in lBPlots if coord in lC[0]]
                if (lValidPlots == []) or (bInland) :
                        lValidPlots += [coord for coord in lBPlots if coord in lC[2]]
                        lValidPlots += [coord for coord in lBPlots if coord in lC[3]]
                        if (not bCoast) and (lValidPlots == []) : #island inland start !?
                                lValidPlots += [coord for coord in lBPlots if coord in lC[0]]

                if lValidPlots == [] :  return False

                lVPlots = [coord for coord in lValidPlots if not coord in maskMaxDistPlots]

                iRS = copy.copy(iRangeStart)
                bReduceMinimalDist = False

                while True :
                        if iRS < 7 : break
                        if (iRS < 10) and (not bReduceMinimalDist) :
                                bReduceMinimalDist = True
                                lVPlots = [coord for coord in lValidPlots if not coord in maskMinDistPlots]

                        if lVPlots == [] :
                                iRS -= 1
                                continue

                        lResAss = placePlayersInArea(lPl, lVPlots, iRS)

                        diffPlacements = len(lPl) - len(lResAss)
                        
                        logList.append(" nb player placed for range %r : %r" %(iRS, len(lResAss)))

                        if diffPlacements == 0 :
                                for iPlayer, coord in lResAss :
                                        plotsAssigned[iPlayer] = coord
                                        maskMinDistPlots += makeMask(coord, minDist)
                                        maskMaxDistPlots += makeMask(coord, maxDist)
                                logList.append(" all players placed in this area -> continue")
                                logList.append("")
                                return True

                        if iRS > 18 :
                                iRS -= min(3, diffPlacements)
                        elif iRS > 14 :
                                iRS -= min(2, diffPlacements)
                        else :
                                iRS -= 1

                logList.append("")
                return False
                        

        for lPlay, lPlo in areaPlayer :
                if lPlay == [] : continue
                if idMap == "chess" :
                        lPlo = [plotCoords for plotCoords in lPlo if (plotCoords[0]%6 == 3) and (plotCoords[1]%6 == 2)]
                                
                if not placePlayersOneArea(lPlay, lPlo) :
                        bAssign = False
                        logList.append(" can't place all players in one area ...")
                        logList.append("")
                        break

        if not bAssign :
                if (bCoast) and (not bInland) :
                        bInland = True
                        logList.append(" coast start failed : add inland plots")
                        initG()
                        for lPlay, lPlo in areaPlayer :
                                if lPlay == [] : continue
                                if idMap == "chess" :
                                        lPlo = [plotCoords for plotCoords in lPlo if (plotCoords[0]%6 == 3) and (plotCoords[1]%6 == 2)]

                                if not placePlayersOneArea(lPlay, lPlo) :
                                        logList.append(" coast start : can't place all players in one area after adding inland plots")
                                        writeLog("", True, logList)
                                        return False

                elif (not bCoast) and (bInland) :
                        bCoast = True
                        logList.append(" inland start failed : add coastal plots")
                        initG()
                        for lPlay, lPlo in areaPlayer :
                                if lPlay == [] : continue
                                if idMap == "chess" :
                                        lPlo = [plotCoords for plotCoords in lPlo if (plotCoords[0]%6 == 3) and (plotCoords[1]%6 == 2)]

                                if not placePlayersOneArea(lPlay, lPlo) :
                                        logList.append(" inland start : can't place all players in one area after adding coastal plots")
                                        writeLog("", True, logList)
                                        return False

                else :
                        writeLog("", True, logList)
                        return False

        for iPlayer in plotsAssigned.keys() : 
                startPlot = map.plot(plotsAssigned[iPlayer][0], plotsAssigned[iPlayer][1])
                startPlot.setStartingPlot(True)
                gc.getPlayer(iPlayer).setStartingPlot(startPlot, True)

        writeLog("", True, logList)
        return True

def normalizeStartingPlotLocations():
        initPlayerList(True) # store starting locations

        #For MP games , humans are as far away as possible between them
        if isGameMP and selGen["startlocs"]["relocate"]["swaphuman"] :
                try :
                        if swapHumanPlayers() :
                                return None
                except :
                        writeLog("", False, ["", " An error occured during sawp humans ..."])
                        writeError()

        #if the player like to be isolated
        if selGen["startlocs"]["relocate"]["isolatehuman"] :
                try :
                        if isolateHumanPlayers() :
                                return None
                except :
                        writeLog("", False, ["", " An error occured during isolate humans ..."])
                        writeError()

        iNorm = selGen["startlocs"]["normalize"]["startplot"]
        if iNorm == 2 :
                return None
        elif iNorm == 1 :
                pass
        elif idMap == "customcontinents" :
                if cmo[0] != 1 or game.countCivTeamsAlive() > 6:
                        pass
                else :
                        return None
        CyPythonMgr().allowDefaultImpl()

def isolateHumanPlayers():
        nbAIPlayer = len(playerAIList)
        nbHUPlayer = len(playerHUList)
        writeLog("", False, ["", " isolateHumanPlayers : Impl begin"])

        if nbAIPlayer == 0 :
                writeLog("", False, ["", " isolateHumanPlayers : no AI players , don't launch the function ..."])
                return False

        if nbHUPlayer > nbAIPlayer :
                writeLog("", False, ["", " isolateHumanPlayers : more humans than AI , don't launch the function ..."])
                return False

        #use path distances, in case one continent is separated in parts by impassable plots.
        distances = {}
        playerGroups = []
        playerTested = []
        for iPlayer in playerList :
                for iPlayer2 in playerList :
                        if iPlayer2 == iPlayer : continue
                        distL = map.calculatePathDistance( map.plot(startX[iPlayer], startY[iPlayer]), map.plot(startX[iPlayer2], startY[iPlayer2]))
                        distances[(iPlayer, iPlayer2)] = distL
                        map.resetPathDistance()

        for iPlayer in playerList :
                if iPlayer in playerTested : continue
                playerTested.append(iPlayer)
                tpGroup = [iPlayer]
                for iPlayer2 in playerList :
                        if iPlayer2 in playerTested : continue
                        dist = distances[(iPlayer, iPlayer2)]
                        if dist <= 0 : continue
                        playerTested.append(iPlayer2)
                        tpGroup.append(iPlayer2)
                playerGroups.append(tpGroup)

        if len(playerGroups) == nbAIPlayer + nbHUPlayer :
                writeLog("", False, ["", " isolateHumanPlayers : all players are isolated , don't launch the function ..."])
                return False

        if len(playerGroups) == 1 :
                writeLog("", False, ["", " isolateHumanPlayers : all players are on the same continent , don't launch the function ..."])
                return False

        assignGroup = [[] for i in range(len(playerGroups))]

        newPlace = {}
        assignedPlace = []
        for iHumanPlayer in shuffleList(copy.copy(playerHUList)) :
                availableGroups = [playerGroups[i] for i in range(len(playerGroups)) if len(assignGroup[i]) < len(playerGroups[i])]

                if len(availableGroups) == 0 : #how can that be possible ?
                        writeLog("", False, ["", " isolateHumanPlayers : unexpected error 1"])
                        return False

                minVal = min([ len(group) + len(assignGroup[playerGroups.index(group)]) for group in availableGroups])
                lMinGroups = [ group for group in availableGroups if (len(group) + len(assignGroup[playerGroups.index(group)])) == minVal ]
                
                minVal = min([ len(assignGroup[playerGroups.index(group)]) for group in lMinGroups])
                lPotGroups = [ group for group in lMinGroups if len(assignGroup[playerGroups.index(group)]) == minVal ]

                iIndex = playerGroups.index(lPotGroups[getRandNum(len(lPotGroups), " FoR : assgin player to group (isolate)")])
                assignGroup[iIndex].append(iHumanPlayer)

                lPlayerPlaces = [iPlayer for iPlayer in playerGroups[iIndex] if not iPlayer in assignedPlace]
                iPlayerChoice = lPlayerPlaces[getRandNum(len(lPlayerPlaces), " FoR : choose player place in group (isolate)")]

                newPlace[iHumanPlayer] = iPlayerChoice
                assignedPlace.append(iPlayerChoice)

        availablePlace = [ iPlayer for iPlayer in playerList if not iPlayer in assignedPlace ]

        for iPlayer in playerList :
                if iPlayer in playerHUList :
                        stPlot = map.plot(startX[newPlace[iPlayer]], startY[newPlace[iPlayer]])
                        gc.getPlayer(iPlayer).setStartingPlot(stPlot, False)
                else :
                        iChoice = getRandNum(len(availablePlace), " FoR : AI swap place")
                        iPlayerPlaced = availablePlace[iChoice]
                        del availablePlace[iChoice]
                        stPlot = map.plot(startX[iPlayerPlaced], startY[iPlayerPlaced])
                        gc.getPlayer(iPlayer).setStartingPlot(stPlot, True)

        writeLog("", False, [""])
        return True

def swapHumanPlayers():
        nbAIPlayer = len(playerAIList)
        nbHUPlayer = len(playerHUList)

        if nbAIPlayer == 0 :
                writeLog("", False, ["", " swapHumanPlayers : no AI players , don't launch the function ..."])
                return False

        bAreaAssignment = True
        if nbHUPlayer > nbAIPlayer :
                writeLog("", False, ["", " swapHumanPlayers : more human than AI , use air placement only"])
                bAreaAssignment = False

        nbAIperHUmin = nbAIPlayer / nbHUPlayer
        if ((float(nbAIPlayer) / nbHUPlayer) - nbAIperHUmin) > 0.6 : nbAIperHUmin += 1

        logList = [""]
        logList.append(" swapHumanPlayers, nbAIPlayer : %r" %nbAIPlayer)
        logList.append(" swapHumanPlayers, nbHUPlayer : %r" %nbHUPlayer)
        logList.append(" swapHumanPlayers, nbAIperHUmin : %r" %nbAIperHUmin)
        writeLog("", False, logList)

        playerGroups = []
        playerTested = []

        distances = {}
        for iPlayer in playerList :
                for iPlayer2 in playerList :
                        if iPlayer2 == iPlayer : continue
                        distL = map.calculatePathDistance( map.plot(startX[iPlayer], startY[iPlayer]), map.plot(startX[iPlayer2], startY[iPlayer2]))
                        distA = calculateAirDistance(startPlots[iPlayer], startPlots[iPlayer2])
                        distances[(iPlayer, iPlayer2)] = [distL, distA]
                        map.resetPathDistance() # AAAAAAARRRGGGG !!! never forget this ... 1 day of tests and bug searching because of that ^^

        for iPlayer in playerList :
                if iPlayer in playerTested : continue
                playerTested.append(iPlayer)
                tpGroup = [iPlayer]
                for iPlayer2 in playerList :
                        if iPlayer2 in playerTested : continue
                        dist = distances[(iPlayer, iPlayer2)][0]
                        if dist <= 0 : continue
                        playerTested.append(iPlayer2)
                        tpGroup.append(iPlayer2)
                playerGroups.append(tpGroup)

        assignGroup = [[] for i in range(len(playerGroups))]
        nbPlayersPerGroup = [len(group) for group in playerGroups]

        # all players in one area : force path placement
        if len(playerGroups) == 1 :
                nbAIperHUmin = -1
                bAreaAssignment = True
                writeLog("", False, ["", " swapHumanPlayers : all players in one area , force path placement"])

        for iHumanPlayer in shuffleList(copy.copy(playerHUList)) :
                if not bAreaAssignment : break
                values = [ nbPlayersPerGroup[i] - len(assignGroup[i])*nbAIperHUmin -1 for i in range(len(playerGroups))]
                maxVal = max(values)
                if maxVal <= 0 : break
                lIndexGroups = [ i for i in range(len(playerGroups)) if values[i] == maxVal ]
                iIndex = lIndexGroups[getRandNum(len(lIndexGroups), " FoR : assgin player to group")]
                assignGroup[iIndex].append(iHumanPlayer)

        newPlace = {}
        for iHumanPlayer in playerHUList : newPlace[iHumanPlayer] = -1
        assignedPlace = []

        # First place each player in the groups with at least two human players
        for iGroup in range(len(playerGroups)) :
                lHumanGroup = assignGroup[iGroup]
                lPlayerGroup = playerGroups[iGroup]
                nbHU = len(lHumanGroup)
                if nbHU < 2 : continue

                bestList = -1
                bestCombi = -1
                for combi in Cnp(len(lPlayerGroup), nbHU) :
                        lPlayers = [lPlayerGroup[iIndex] for iIndex in combi]
                        listDist = [distances[(lPlayers[i], lPlayers[j])][0] for i, j in Cnp(nbHU, 2)]
                        listDist.sort()
                        if bestCombi == -1 :
                                bestList = copy.copy(listDist)
                                bestCombi = copy.copy(lPlayers)
                        elif listDist > bestList :
                                bestList = copy.copy(listDist)
                                bestCombi = copy.copy(lPlayers)

                assignedPlace += copy.copy(bestCombi)

                for i in range(len(lHumanGroup)) :
                        newPlace[lHumanGroup[i]] = bestCombi[i]

        writeLog("", False, ["", " swapHumanPlayers : assigned Players after groups (more than 2 HU) : %r" %newPlace])

        # Then place humans on one human group :
        lOneHumanGroup = [iGroup for iGroup in range(len(playerGroups)) if len(assignGroup[iGroup]) == 1]
        if lOneHumanGroup != [] :
                if (len(lOneHumanGroup) == 1) and (assignedPlace == []) :
                        iGroup = lOneHumanGroup[0]
                        iHumanPlayer = assignGroup[iGroup][0]
                        lPlayerGroup = playerGroups[iGroup]
                        iChoice = getRandNum(len(lPlayerGroup), " FoR : one area human placement choice")
                        iPlayer = lPlayerGroup[iChoice]
                        assignedPlace.append(iPlayer)
                        newPlace[iHumanPlayer] = iPlayer

                        writeLog("", False, ["", " swapHumanPlayers : assigned Players after only one human group , no assignment done already : %r" %newPlace])

                else : #place players with max dist by air
                        listPlayers = [[]]
                        for iIndex in range(len(lOneHumanGroup)) :
                                tpList = []
                                for lList in listPlayers :
                                        for iPlayer in playerGroups[lOneHumanGroup[iIndex]] :
                                                nList = lList + [iPlayer]
                                                tpList.append(nList)
                                listPlayers = tpList
                        listPlayers = [item + assignedPlace for item in listPlayers]

                        bestList = -1
                        listDist = []
                        for lList in listPlayers :
                                listDistTp = [distances[(lList[i], lList[j])][1] for i, j in Cnp(len(lList), 2)]
                                listDistTp.sort()

                                if bestList == -1 :
                                        bestList = copy.copy(lList)
                                        listDist = copy.copy(listDistTp)
                                elif listDistTp > listDist :
                                        bestList = copy.copy(lList)
                                        listDist = copy.copy(listDistTp)
                        
                        assignedPlace += bestList[0:len(lOneHumanGroup)]

                        for i in range(len(lOneHumanGroup)) :
                                iGroup = lOneHumanGroup[i]
                                iHumanPlayer = assignGroup[iGroup][0]
                                newPlace[iHumanPlayer] = bestList[i]

                        writeLog("", False, ["", " swapHumanPlayers : assigned Players after one human groups : %r" %newPlace])

        # place the rest of players by air :
        if len(assignedPlace) != nbHUPlayer :
                playersToPlace = shuffleList([iPlayer for iPlayer in playerHUList if newPlace[iPlayer] == -1])
                availablePlace = [iPlayer for iPlayer in playerList if not iPlayer in assignedPlace]

                listPlayers = [ [availablePlace[i] for i in lCombi] + assignedPlace for lCombi in Cnp(len(availablePlace), len(playersToPlace)) ]

                bestList = -1
                listDist = []
                for lList in listPlayers :
                        listDistTp = [distances[(lList[i], lList[j])][1] for i, j in Cnp(len(lList), 2)]
                        listDistTp.sort()

                        if bestList == -1 :
                                bestList = copy.copy(lList)
                                listDist = copy.copy(listDistTp)
                        elif listDistTp > listDist :
                                bestList = copy.copy(lList)
                                listDist = copy.copy(listDistTp)
                
                assignedPlace += bestList[0:len(playersToPlace)]

                for i in range(len(playersToPlace)) :
                        iHumanPlayer = playersToPlace[i]
                        newPlace[iHumanPlayer] = bestList[i]

                writeLog("", False, ["", " swapHumanPlayers : assigned Players rest of available players : %r" %newPlace])

        # swap player places
        availablePlace = [ iPlayer for iPlayer in playerList if not iPlayer in assignedPlace ]

        for iPlayer in playerList :
                if iPlayer in playerHUList :
                        stPlot = map.plot(startX[newPlace[iPlayer]], startY[newPlace[iPlayer]])
                        gc.getPlayer(iPlayer).setStartingPlot(stPlot, False)
                else :
                        iChoice = getRandNum(len(availablePlace), " FoR : AI swap place")
                        iPlayerPlaced = availablePlace[iChoice]
                        del availablePlace[iChoice]
                        stPlot = map.plot(startX[iPlayerPlaced], startY[iPlayerPlaced])
                        gc.getPlayer(iPlayer).setStartingPlot(stPlot, True)

        writeLog("", False, [""])
        return True

def normalizeAddRiver():
        initPlayerList(True) # reinit starting locations , in case of a change in normalizeStartingPlotLocations (team or cultural locations)

        iNorm = selGen["startlocs"]["normalize"]["addriver"]
        if (iNorm == 2) or (idMap == "chess") :
                return None
        elif iNorm == 1 :
                pass
	CyPythonMgr().allowDefaultImpl()

def normalizeRemovePeaks():
        #sometimes when creating a river , you can have some desert tiles without floodplains for an example .
        listRiverFeatures = []
        for iFeature in range(gc.getNumFeatureInfos()):
                featureXML = gc.getFeatureInfo(iFeature)
                if featureXML.getAppearanceProbability() < 10000 : continue
                if featureXML.isRequiresRiver() : listRiverFeatures.append(iFeature)
        writeLog("", False, ["", " normalizeRemovePeaks , list of feature to check after normalizeAddRiver : %r" %[gc.getFeatureInfo(i).getType() for i in listRiverFeatures], ""])
        for plotIndex in range(iW * iH):
                pPlot = map.plotByIndex(plotIndex)
                if pPlot.isNone() :
                        writeLog("", False, [" normalizeRemovePeaks , a plot is none ... need to be checked , index : %d" %plotIndex, ""])
                        continue
                if pPlot.isWater() : continue
                if not pPlot.isRiver() : continue
                if pPlot.getFeatureType() != -1 : continue
                if pPlot.getBonusType(-1) != -1 : continue
                for iFeature in listRiverFeatures :
                        if pPlot.canHaveFeature(iFeature):
                                pPlot.setFeatureType(iFeature, -1)
                                break

        if not getNormalizeRemovePeaks() : return None
	CyPythonMgr().allowDefaultImpl()

def getNormalizeRemovePeaks():
        iNorm = selGen["startlocs"]["normalize"]["removepeak"]
        if (iNorm == 2) or (idMap == "chess") :
                return False
        elif iNorm == 1 :
                return True
        elif idMap in ["archipelago", "hub", "islands", "maze", "ring", "wheel"] :
                return False
        return True

def normalizeAddLakes():
        iNorm = selGen["startlocs"]["normalize"]["addlake"]
        if (iNorm == 2)  or (idMap == "chess"):
                return None
        elif iNorm == 1 :
                pass
	CyPythonMgr().allowDefaultImpl()

def normalizeRemoveBadFeatures():
        if not getNormalizeRemoveBadFeatures() : return None
	CyPythonMgr().allowDefaultImpl()

def getNormalizeRemoveBadFeatures():
        iNorm = selGen["startlocs"]["normalize"]["removebadfeature"]
        if iNorm == 2 :
                return False
        elif iNorm == 1 :
                return True
	return True

def normalizeRemoveBadTerrain():
        if not getNormalizeRemoveBadTerrain() : return None
	CyPythonMgr().allowDefaultImpl()

def getNormalizeRemoveBadTerrain():
        iNorm = selGen["startlocs"]["normalize"]["removebadterrain"]
        if iNorm == 2 :
                return False
        elif iNorm == 1 :
                return True
        elif idMap in ["hub", "ring", "wheel"] :
                return False
	return True

def normalizeAddFoodBonuses():
        iNorm = selGen["startlocs"]["normalize"]["addfoodbonus"]
        if iNorm == 2 :
                return None
        elif iNorm == 1 :
                pass
	CyPythonMgr().allowDefaultImpl()

def normalizeAddGoodTerrain():
        iNorm = selGen["startlocs"]["normalize"]["addgoodterrain"]
        if iNorm == 2 :
                return None
        elif iNorm == 1 :
                pass
        elif idMap in ["hub", "ring", "wheel"] :
                return None
	CyPythonMgr().allowDefaultImpl()

def normalizeAddExtras():
        global bGeneratingMap
        global bApplyExtraImpl
        bGeneratingMap = False
        bApplyExtraImpl = True

        if canUseGameOptions :
                initStoAddEvent()
                CyMessageControl().sendApplyEvent(getattr(CvUtil, "Sto_FullOfResources_AddGameElements_EventID"), EventContextTypes.EVENTCONTEXT_SELF, (game.getActivePlayer(),))

        # replace FFH2 units to prevent an unit to appear on this tile, before the replacement
        # remembered the setDefineInt (tired today :) ), let the function in case needed later
##        if is_BtS_FFH2 :
##                try :
##                        placeUnitsAway()
##                except :
##                        writeLog("", False, ["", " An error occured during placeUnitsAway ..."])
##                        writeError()

        iNorm = selGen["startlocs"]["normalize"]["addextra"]
        if iNorm == 2 :
                return None
        elif iNorm == 1 :
                pass
	CyPythonMgr().allowDefaultImpl()

##def placeUnitsAway() :
##        lUniqueImprovementsUnits = []
##        for sImprovementType in XMLEntriesList["uniqueimprovements"] :
##                if parsedXMLValuesEntries[sImprovementType]["SpawnUnitType"] != "" :
##                        lUniqueImprovementsUnits.append(gc.getInfoTypeForString(parsedXMLValuesEntries[sImprovementType]["SpawnUnitType"]))
##
##        lUnit = []
##        (loopUnit, iter) = pBarbPlayer.firstUnit(False)
##        while (loopUnit):
##                if (not loopUnit.isDead()):
##                        lUnit.append(loopUnit)
##                (loopUnit, iter) = pBarbPlayer.nextUnit(iter, False)
##
##        lUnitsToReplace = []
##        for pUnit in lUnit :
##                if not pUnit.getUnitType() in lUniqueImprovementsUnits :
##                        writeLog("", False, ["", " placeUnitsAway : an unexpected unit %s" %(gc.getUnitInfo(pUnit.getUnitType()).getType(), )])
##                        continue
##                lUnitsToReplace.append(pUnit)
##
##        if len(lUnitsToReplace) == 0 :
##                writeLog("", False, ["", " placeUnitsAway : no plot available ..."])
##                return
##
##        # search a plot to place these units to prevent a bug with others impls, initial unit placed.
##        lStartPlots = [startPlots[iPlayer] for iPlayer in playerList]
##        rings = generateRings(3)
##        lNoPlots = []
##        for iX, iY in lStartPlots :
##                for iRing in range(4) :
##                        for dX, dY in rings[iRing] :
##                                wTP = toWrap(iX + dX, iY + dY)
##                                if wTP == -1 : continue
##                                lNoPlots.append(wTP)
##
##        iOcean = gc.getInfoTypeForString("TERRAIN_OCEAN")
##
##        bFoundOcean = False
##        bFoundWater = False
##        bestCoord = -1
##        for iX in range(iW) :
##                if bFoundOcean : break
##                for iY in range(iH) :
##                        if (iX, iY) in lNoPlots : continue
##                        pLoopPlot = map.plot(iX, iY)
##                        if pLoopPlot.isImpassable() : continue #seen some bugs with units replacement on impassable features, plots so skip them.
##                        if pLoopPlot.isWater() :
##                                if pLoopPlot.getTerrainType() == iOcean :
##                                        bFoundOcean = True
##                                        bestCoord = (iX, iY)
##                                        break
##                                else :
##                                        bFoundWater = True
##                                        bestCoord = (iX, iY)
##                        elif not bFoundWater :
##                                bestCoord = (iX, iY)
##
##        if bestCoord == -1 :
##                writeLog("", False, ["", " placeUnitsAway : no plot available ..."])
##                return
##
##        for pUnit in lUnitsToReplace :
##                if BtS :
##                        pUnit.setXY(bestCoord[0], bestCoord[1], False, False, False)
##                else : #don't remember if warlords have extra arguments !?
##                        try :
##                                pUnit.setXY(bestCoord[0], bestCoord[1])
##                        except :
##                                pass
##                        try :
##                                pUnit.setXY(bestCoord[0], bestCoord[1], False, False, False)
##                        except :
##                                pass

def startHumansOnSameTile():
        global bApplyExtraImpl
        if bApplyExtraImpl :
                bApplyExtraImpl = False

                #add extra starting bonuses
                try :
                        StoAddStartBonuses()
                except :
                        writeLog("", True, ["", " An error occured during start bonus implementation ..."])
                        writeError()

                # for FFH2 place unique improvements and lairs
                if is_BtS_FFH2 :
                        try :
                                StoAddFFH2UniqueIprovements()
                        except :
                                writeLog("", True, ["", " An error occured during StoAddFFH2UniqueIprovements implementation ..."])
                                writeError()

                        try :
                                StoAddFFH2Lairs()
                        except :
                                writeLog("", True, ["", " An error occured during StoAddFFH2Lairs implementation ..."])
                                writeError()

                #Done at the very end in case of lots of goodies, to prevent a good start location skipped and other effects
                try :
                        StoAddGoodies()
                except :
                        writeLog("", True, ["", " An error occured during goody generation ..."])
                        writeError()

        iNorm = selGen["startlocs"]["normalize"]["startsametile"]
        if iNorm == 2 :
                return True
        elif iNorm == 1 :
                pass
        elif idMap == "maze" :
                return True
        return False

def StoAddFFH2Lairs() :
        writeLog(" = StoAddFFH2Lairs = ", False, [""])

        if len(XMLEntriesList["lairs"]) == 0 :
                writeLog("", True, [" No lairs entries"])
                return

        NoLairs = gc.getInfoTypeForString("GAMEOPTION_NO_LAIRS")
        if NoLairs != -1 :
                if game.isOption(NoLairs) :
                        writeLog("", True, [" No Lairs option selected, continue"])
                        return

        logList = []
        minStartDist = getRandSel(selGen["ffh2"]["lairs"]["mindistlairstart"], False)
        logList.append("minStartDist : %d" %minStartDist)
        lOptions = selGen["ffh2"]["lairs"].keys()
        logList.append("lOptions : %r" %lOptions)
        lLairPercents = []
        for sType in XMLEntriesList["lairs"] :
                sOptionType = getTypeForm(sType)
                fPercent = parsedXMLValuesEntries[sType]["iAppearanceProbability"] / 10000.0
                if selGen["ffh2"]["lairs"][sOptionType] != "standard" : fPercent = getRandSel(selGen["ffh2"]["lairs"][sOptionType], False, "float") / 100.0

                if fPercent > 0.0001 : lLairPercents.append((sType, fPercent))
                logList.append("lair %s : %r" %(sType, fPercent))

        logList.append("")
        writeLog("", False, logList)
                
        if len(lLairPercents) == 0 :
                writeLog("", True, [" No Lair improvements to place ... continue"])
                return

        dictPlotsPerArea = getAreaPlots()
        rings = generateRings(6)

        valPlotPenality = [[ 0 for iY in range(iH) ] for iX in range(iW)] # penality for small islands for lair placements
        for lList in dictPlotsPerArea["land"] :
                nbTiles = len(lList)
                if nbTiles < 3 : #no lair on small islands
                        for iX, iY in lList :
                                valPlotPenality[iX][iY] = 6
                elif nbTiles < 11 : #placement penality for medium islands
                        val = (11 - nbTiles) / 2 + 1
                        for iX, iY in lList :
                                valPlotPenality[iX][iY] = val

        lImpChokePlots = []
        for lList in dictPlotsPerArea["water"] : lImpChokePlots += lList

        listStartPlots = []
        for iPlayer in startPlots.keys() :
                listStartPlots.append(startPlots[iPlayer])

        lNoImprCoords = []
        for coord in listStartPlots :
                iX, iY = coord
                for iRing in range(minStartDist + 1) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP == -1 : continue
                                lNoImprCoords.append(wTP)

        lImprovementType = [ gc.getInfoTypeForString(item[0]) for item in lLairPercents ]
        lImprTypePlots = {}
        for iImpr in lImprovementType : lImprTypePlots[iImpr] = []
        lHillPlots = []
        lLandPlots = []

        for iX in range(iW) :
                for iY in range(iH) :
                        coord = (iX, iY)
                        pPlot = map.plot(iX, iY)

                        if pPlot.isImpassable() :
                                if not pPlot.isWater() : lImpChokePlots.append(coord)
                                continue

                        if not pPlot.isWater() : lLandPlots.append(coord)

                        if coord in lNoImprCoords : continue

                        if pPlot.getBonusType(-1) != -1 : continue
                        if pPlot.getImprovementType() != -1 : continue

                        if pPlot.isHills() : lHillPlots.append(coord)

                        for iImpr in lImprovementType :
                                if pPlot.canHaveImprovement(iImpr, -1, True) :
                                        lImprTypePlots[iImpr].append(coord)

        nbLairToPlace = {}
        for sType, fPercent in lLairPercents :
                iImpr = gc.getInfoTypeForString(sType)
                nbLairToPlace[iImpr] = int(len(lImprTypePlots[iImpr]) * fPercent) + 1

        bTower = False
        if "IMPROVEMENT_TOWER" in XMLEntriesList["lairs"] :
                if gc.getInfoTypeForString("IMPROVEMENT_TOWER") in nbLairToPlace.keys() :
                        bTower = True

        lImpr = lImprTypePlots.keys()

        if bTower :
                iImpr = gc.getInfoTypeForString("IMPROVEMENT_TOWER")
                writeLog("", False, ["", " Place tower %d" %(nbLairToPlace[iImpr], )])

                lTowerPlots = [ [] for i in range(4) ]

                # determine choke points. very simple implementation since a few map scripts got some True choke points
                for coord in lImprTypePlots[iImpr] :
                        iX, iY = coord

                        # check if the plot is a choke point :
                        bChokePoint = True
                        for dX, dY in [(-1, 0), (1, 0)] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP == -1 :
                                        bChokePoint = False
                                        break
                                else :
                                        if not wTP in lImpChokePlots :
                                                bChokePoint = False
                                                break

                        if bChokePoint :
                                bFoundLand = False
                                for dX, dY in [(-1, 2), (0, 2), (1, 2)] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP == -1 :
                                                bChokePoint = False
                                                break
                                        else :
                                                if wTP in lLandPlots :
                                                        bFoundLand = True

                                if not bFoundLand :
                                        bChokePoint = False

                                if bChokePoint :
                                        bFoundLand = False
                                        for dX, dY in [(-1, -2), (0, -2), (1, -2)] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP == -1 :
                                                        bChokePoint = False
                                                        break
                                                else :
                                                        if wTP in lLandPlots :
                                                                bFoundLand = True

                                        if not bFoundLand :
                                                bChokePoint = False

                        if not bChokePoint :
                                bChokePoint = True
                                for dX, dY in [(0, -1), (0, 1)] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP == -1 :
                                                bChokePoint = False
                                                break
                                        else :
                                                if not wTP in lImpChokePlots :
                                                        bChokePoint = False
                                                        break

                                if bChokePoint :
                                        bFoundLand = False
                                        for dX, dY in [(-2, -1), (-2, 0), (-2, 1)] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP == -1 :
                                                        bChokePoint = False
                                                        break
                                                else :
                                                        if wTP in lLandPlots :
                                                                bFoundLand = True

                                        if not bFoundLand :
                                                bChokePoint = False

                                        if bChokePoint :
                                                bFoundLand = False
                                                for dX, dY in [(2, -1), (2, 0), (2, 1)] :
                                                        wTP = toWrap(iX + dX, iY + dY)
                                                        if wTP == -1 :
                                                                bChokePoint = False
                                                                break
                                                        else :
                                                                if wTP in lLandPlots :
                                                                        bFoundLand = True

                                                if not bFoundLand :
                                                        bChokePoint = False

                        if bChokePoint :
                                lTowerPlots[0].append(coord)
                                continue

                        if coord in lHillPlots :
                                bTopHill = True
                                for dX, dY in rings[1] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP == -1 :
                                                bTopHill = False
                                                break

                                        pPlot = map.plot(wTP[0], wTP[1])

                                        if pPlot.isWater() or pPlot.isFlatlands() : continue
                                        bTopHill = False
                                        break

                                if bTopHill :
                                        lTowerPlots[1].append(coord)
                                else :
                                        lTowerPlots[2].append(coord)
                                continue
                        lTowerPlots[3].append(coord)

                # place towers :
                plotValues = [[ 6 - valPlotPenality[iX][iY] for iY in range(iH) ] for iX in range(iW)] # penality for small islands for lair placements
                                        
                nbTowerPlaced = 0
                while True :
                        if nbTowerPlaced >= nbLairToPlace[iImpr] : break
                        if len(lImprTypePlots[iImpr]) == 0 : break

                        maxVal = max([plotValues[iX][iY] for iX, iY in lImprTypePlots[iImpr]])
                        tpList = [(iX, iY) for iX, iY in lImprTypePlots[iImpr] if plotValues[iX][iY] == maxVal]

                        for i in range(4) :
                                tpList2 = [coord for coord in tpList if coord in lTowerPlots[i]]
                                if len(tpList2) > 0 : break

                        iChoice = getRandNum(len(tpList2), " FoR : tower plot rand")
                        coord = tpList2[iChoice]
                        iX, iY = coord
                        for iRing in range(1, 7) :
                                for dX, dY in rings[iRing] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP == -1 : continue
                                        plotValues[wTP[0]][wTP[1]] = min(iRing, plotValues[wTP[0]][wTP[1]])

                        map.plot(iX, iY).setImprovementType(iImpr)
                        nbTowerPlaced += 1

                        # debug
                        #CyEngine().addSign(map.plot(iX, iY), 0, "TOWER")

                        for i in lImpr :
                                if coord in lImprTypePlots[i] : lImprTypePlots[i].remove(coord)

                lImpr.remove(iImpr)
                writeLog("", False, [" nb tower placed : %d" %nbTowerPlaced])

        # place lair without unit spawn
        lImprNoUnit = [iI for iI in lImpr if parsedXMLValuesEntries[gc.getImprovementInfo(iI).getType()]["SpawnUnitType"] == ""]

        if len(lImprNoUnit) == 0:
                writeLog("", False, ["", " No Lair without spawn unit to place ..."])
        else :
                for iImpr in lImprNoUnit :
                        sType = gc.getImprovementInfo(iImpr).getType()
                        writeLog("", False, ["", " Place %s : %d" %(sType, nbLairToPlace[iImpr])])

                        plotValues = [[ 6 - valPlotPenality[iX][iY] for iY in range(iH) ] for iX in range(iW)] # penality for small islands for lair placements
                                                
                        nbImprPlaced = 0
                        while True :
                                if nbImprPlaced >= nbLairToPlace[iImpr] : break
                                if len(lImprTypePlots[iImpr]) == 0 : break

                                maxVal = max([plotValues[iX][iY] for iX, iY in lImprTypePlots[iImpr]])
                                tpList = [(iX, iY) for iX, iY in lImprTypePlots[iImpr] if plotValues[iX][iY] == maxVal]

                                iChoice = getRandNum(len(tpList), " FoR : no unit plot rand")
                                coord = tpList[iChoice]
                                iX, iY = coord
                                for iRing in range(1, 7) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP == -1 : continue
                                                plotValues[wTP[0]][wTP[1]] = min(iRing, plotValues[wTP[0]][wTP[1]])

                                map.plot(iX, iY).setImprovementType(iImpr)
                                nbImprPlaced += 1

                                # debug
                                #CyEngine().addSign(map.plot(iX, iY), 0, sType[12:])

                                for i in lImpr :
                                        if coord in lImprTypePlots[i] : lImprTypePlots[i].remove(coord)

                        lImpr.remove(iImpr)
                        writeLog("", False, [" nb %s placed : %d" %(sType, nbImprPlaced)])

        # place lair with unit spawn, like if all are the same type to prevent a package of different lair type
        if len(lImpr) == 0:
                writeLog("", True, ["", " No Lair with spawn unit to place ..."])
                return

        writeLog("", False, [""])
        lTypes = []
        for iImpr in lImpr :
                sType = gc.getImprovementInfo(iImpr).getType()
                lTypes.append(sType)
                writeLog("", False, [" Place %s ( %s ) : %d" %(sType, parsedXMLValuesEntries[sType]["SpawnUnitType"], nbLairToPlace[iImpr])])

        plotValues = [[ 6 - valPlotPenality[iX][iY] for iY in range(iH) ] for iX in range(iW)] # penality for small islands for lair placements
                                
        writeLog("", False, [""])

        nbImprPlaced = [0 for i in range(len(lImpr))]
        iCount = 0
        while True :
                if len(lImpr) == 0 : break

                iIndex = iCount % len(lImpr)
                iImpr = lImpr[iIndex]

                if (nbImprPlaced[iIndex] >= nbLairToPlace[iImpr]) or (len(lImprTypePlots[iImpr]) == 0) :
                        writeLog("", False, [" nb placed %s : %d" %(lTypes[iIndex], nbImprPlaced[iIndex])])
                        del lImpr[iIndex]
                        del lTypes[iIndex]
                        del nbImprPlaced[iIndex]
                        continue

                maxVal = max([plotValues[iX][iY] for iX, iY in lImprTypePlots[iImpr]])
                tpList = [(iX, iY) for iX, iY in lImprTypePlots[iImpr] if plotValues[iX][iY] == maxVal]

                iChoice = getRandNum(len(tpList), " FoR : unit lair plot rand")
                coord = tpList[iChoice]
                iX, iY = coord
                for iRing in range(1, 7) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP == -1 : continue
                                plotValues[wTP[0]][wTP[1]] = min(iRing, plotValues[wTP[0]][wTP[1]])

                map.plot(iX, iY).setImprovementType(iImpr)
                nbImprPlaced[iIndex] += 1

                # debug
                #CyEngine().addSign(map.plot(iX, iY), 0, lTypes[iIndex][12:])

                for i in lImpr :
                        if coord in lImprTypePlots[i] : lImprTypePlots[i].remove(coord)

                iCount += 1

        writeLog("", True, [""])

def StoAddFFH2UniqueIprovements():
        global unitsToPlaceOnImprovements
        unitsToPlaceOnImprovements = []

        writeLog(" = StoAddFFH2UniqueIprovements = ", False, [""])

        if len(XMLEntriesList["uniqueimprovements"]) == 0 :
                writeLog("", True, [" No unique improvements entries"])
                return

        NoUniqueImprovements = gc.getInfoTypeForString("GAMEOPTION_NO_UNIQUE_IMPROVEMENTS")
        if NoUniqueImprovements != -1 :
                if game.isOption(NoUniqueImprovements) :
                        writeLog("", True, [" No unique improvements option selected, continue"])
                        return

        logList = []
        minStartDist = getRandSel(selGen["ffh2"]["uniqueimprovements"]["mindistuniquestart"], False)

        baseChance = gc.getDefineINT("IMPROVEMENT_UNIQUE_CHANCE")
        baseChance += parsedXMLValuesEntries[gc.getWorldInfo(int(map.getWorldSize())).getType()]["iUniqueFeatureChance"]

        lOptions = selGen["ffh2"]["uniqueimprovements"].keys()

        logList.append("minStartDist : %d" %minStartDist)
        logList.append("baseChance : %d" %baseChance)
        logList.append("listOptions : %r" %lOptions)

        pl = {
            0 : "Anywhere" ,
            1 : "Far" ,
            2 : "deserted Island only"
            }

        lImprs = []
        for sType in XMLEntriesList["uniqueimprovements"] :
                iChance = copy.copy(baseChance)
                sOptionType = getTypeForm(sType)
                if selGen["ffh2"]["uniqueimprovements"][sOptionType] != "standard" : iChance = getRandSel(selGen["ffh2"]["uniqueimprovements"][sOptionType], False)

                if getRandNum(100, " FoR : FFH2 unique improvement") >= iChance : continue

                iPlacement = 0
                if getTypeForm(sType) + "placement" in lOptions : iPlacement = copy.copy(selGen["ffh2"]["uniqueimprovements"][getTypeForm(sType) + "placement"])

                lImprs.append([sType, iPlacement])
                logList.append(" %s will be placed %s" %(sType, pl[iPlacement]))

        logList.append("")
        writeLog("", False, logList)

        if len(lImprs) == 0 :
                writeLog("", True, [" No unique improvements to place ... continue"])
                return

        buffValueStartDist = [[ 31 for iY in range(iH) ] for iX in range(iW)]
        buffValueImprDist = [[ 6 for iY in range(iH) ] for iX in range(iW)] # garanty a minimum distance between unique improvement

        dictPlotsPerArea = getAreaPlots()
        rings = generateRings(30)
        minOceanSize = getOceanMinSize()

        listStartPlots = []
        for iPlayer in startPlots.keys() :
                listStartPlots.append(startPlots[iPlayer])

        dictLandAreas = {}
        iAreaLand = 0
        for lPlots in dictPlotsPerArea["land"] :
                if len(lPlots) < 3 : continue
                dictLandAreas[iAreaLand] = {}
                dictLandAreas[iAreaLand]["plots"] = copy.copy(lPlots)
                bIsolated = True
                for coord in listStartPlots :
                        if coord in lPlots :
                                bIsolated = False
                                break

                dictLandAreas[iAreaLand]["isolated"] = bIsolated
                dictLandAreas[iAreaLand]["nbFeatures"] = 0

                iAreaLand += 1

        dictWaterAreas = {}
        iAreaWater = 0
        for lPlots in dictPlotsPerArea["water"] :
                dictWaterAreas[iAreaWater] = {}
                dictWaterAreas[iAreaWater]["plots"] = copy.copy(lPlots)
                bOcean = True
                if len(lPlots) < minOceanSize : bOcean = False
                dictWaterAreas[iAreaWater]["bocean"] = bOcean
                dictWaterAreas[iAreaWater]["nbFeatures"] = 0

                iAreaWater += 1

        lNoImprCoords = []
        for coord in listStartPlots :
                iX, iY = coord
                for iRing in range(31) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP == -1 : continue

                                if iRing <= minStartDist : lNoImprCoords.append(wTP)
                                iXX, iYY = wTP
                                buffValueStartDist[iXX][iYY] = min(buffValueStartDist[iXX][iYY], iRing)

        lImprovementType = [ gc.getInfoTypeForString(item[0]) for item in lImprs ]
        lImprTypePlots = {}
        for iImpr in lImprovementType : lImprTypePlots[iImpr] = []

        for iX in range(iW) :
                for iY in range(iH) :
                        coord = (iX, iY)
                        if coord in lNoImprCoords : continue

                        pPlot = map.plot(iX, iY)
                        if pPlot.getBonusType(-1) != -1 : continue
                        if pPlot.getImprovementType() != -1 : continue

                        if idMap == "chess" :
                                if (iX%6 == 3) and (iY%6 == 2) and (not pPlot.isWater()) : continue

                        for iImpr in lImprovementType :
                                if pPlot.canHaveImprovement(iImpr, -1, True) :
                                        lImprTypePlots[iImpr].append(coord)

        for iPass in range(3) :
                for sType, iPlacement in lImprs :
                        if iPlacement != iPass : continue

                        writeLog("", False, ["", " attempt to place %s, %s :" %(sType, pl[iPlacement])])

                        iImpr = gc.getInfoTypeForString(sType)

                        lAPlots = []
                        if gc.getImprovementInfo(iImpr).isWater() :
                                if sType == "IMPROVEMENT_MAELSTROM" :
                                        lID = [ (len(dictWaterAreas[iWat]["plots"]), iWat) for iWat in range(iAreaWater) if (dictWaterAreas[iWat]["bocean"])]

                                        if len(lID) > 1 :
                                                lID.sort()
                                                bigID = copy.copy(lID[-1][1])
                                                lID = lID[0 : -1]
                                                lID = [item[1] for item in lID]
                                                while True :
                                                        if len(lID) == 0 : break
                                                        cID = lID[0]
                                                        lTPPlots = [coord for coord in dictWaterAreas[cID]["plots"] if coord in lImprTypePlots[iImpr]]

                                                        if len(lTPPlots) > 0 :
                                                                lAPlots = copy.copy(lTPPlots)
                                                                break

                                                        del lID[0]

                                                if len(lAPlots) == 0 :
                                                        lTPPlots = [coord for coord in dictWaterAreas[bigID]["plots"] if coord in lImprTypePlots[iImpr]]

                                                        if len(lTPPlots) > 0 :
                                                                lAPlots = copy.copy(lTPPlots)

                                        elif len(lID) == 1 :
                                                lTPPlots = [coord for coord in dictWaterAreas[lID[0][1]]["plots"] if coord in lImprTypePlots[iImpr]]

                                                if len(lTPPlots) > 0 :
                                                        lAPlots = copy.copy(lTPPlots)

                                        if len(lAPlots) == 0 :
                                                lAPlots = copy.copy(lImprTypePlots[iImpr])

                                else :
                                        lID = [ (len(dictWaterAreas[iWat]["plots"])/(dictWaterAreas[iWat]["nbFeatures"] + 1), iWat) for iWat in range(iAreaWater)]

                                        if len(lID) > 0 :
                                                lID.sort()
                                                lID.reverse()
                                                lID = [item[1] for item in lID]
                                                while True :
                                                        if len(lID) == 0 : break
                                                        cID = lID[0]
                                                        lTPPlots = [coord for coord in dictWaterAreas[cID]["plots"] if coord in lImprTypePlots[iImpr]]

                                                        if len(lTPPlots) > 0 :
                                                                lAPlots = copy.copy(lTPPlots)
                                                                break

                                                        del lID[0]
                                
                        else :
                                lID = [ (len(dictLandAreas[iLand]["plots"])/(dictLandAreas[iLand]["nbFeatures"] + 1), iLand) for iLand in range(iAreaLand)]
                                if len(lID) > 0 :
                                        lID.sort()
                                        lID.reverse()
                                        lID = [item[1] for item in lID]
                                if iPlacement == 2 :
                                        lID = [item for item in lID if dictLandAreas[item]["isolated"]]
                                
                                while True :
                                        if len(lID) == 0 : break
                                        cID = lID[0]
                                        lTPPlots = [coord for coord in dictLandAreas[cID]["plots"] if coord in lImprTypePlots[iImpr]]

                                        if len(lTPPlots) > 0 :
                                                lAPlots = copy.copy(lTPPlots)
                                                break

                                        del lID[0]

                        if len(lAPlots) == 0 :
                                writeLog("", False, [" no available place ... continue to next improvement"])
                                continue

                        if iPlacement == 1 :
                                maxDist = max([buffValueStartDist[iX][iY] for iX, iY in lAPlots])
                                maxDist -= 2
                                lAPlots = [ coord for coord in lAPlots if buffValueStartDist[coord[0]][coord[1]] > maxDist ]

                        maxDist = max([buffValueImprDist[iX][iY] for iX, iY in lAPlots])
                        lAPlots = [ coord for coord in lAPlots if buffValueImprDist[coord[0]][coord[1]] == maxDist ]

                        imprCoord = lAPlots[getRandNum(len(lAPlots), " FoR : FFH2 unique improvement placement")]
                        iX, iY = imprCoord

                        map.plot(iX, iY).setImprovementType(iImpr)
                        writeLog("", False, [" improvement placed : %d, %d" %(iX, iY)])
                        if parsedXMLValuesEntries[sType]["SpawnUnitType"] != "" : unitsToPlaceOnImprovements.append((gc.getInfoTypeForString(parsedXMLValuesEntries[sType]["SpawnUnitType"]), iX, iY))
        
                        # debug
                        #CyEngine().addSign(map.plot(iX, iY), 0, sType[12:])

                        for iImpr2 in lImprovementType :
                                if imprCoord in lImprTypePlots[iImpr2] : lImprTypePlots[iImpr2].remove(imprCoord)
                                
                        for iRing in range(6) :
                                for dX, dY in rings[iRing] :
                                        wTP = toWrap(iX + dX, iY + dY)
                                        if wTP == -1 : continue

                                        iXX, iYY = wTP
                                        buffValueImprDist[iXX][iYY] = min(buffValueImprDist[iXX][iYY], iRing)

                        if gc.getImprovementInfo(iImpr).isWater() :
                                for iWat in range(iAreaWater) :
                                        if imprCoord in dictWaterAreas[iWat]["plots"] :
                                                dictWaterAreas[iWat]["nbFeatures"] += 1
                                                break
                        else :
                                for iLand in range(iAreaLand) :
                                        if imprCoord in dictLandAreas[iLand]["plots"] :
                                                dictLandAreas[iLand]["nbFeatures"] += 1
                                                break

        writeLog("", True, [""])

def StoAddGoodies():
        writeLog(" = StoAddGoodies = ", False, [""])

        iGoody = gc.getInfoTypeForString("IMPROVEMENT_GOODY_HUT")
        if iGoody == -1 :
                writeLog("", True, [" There is no goody hut with this mod ..."])
                return
                
        goodyPer = getRandSel(selGen["terrain"]["goodyhut"]["goodypercent"], False, "float")
        iOptionGoody = gc.getInfoTypeForString("GAMEOPTION_NO_GOODY_HUTS")
        if iOptionGoody != -1 :
                if game.isOption(iOptionGoody) :
                        writeLog("", True, [" the option no goody is selected ..."])
                        return

        writeLog("", False, [" goody percent : %r" %goodyPer, ""])
        if goodyPer < 0.01 :
                writeLog("", True, ["", " goody percent < 0.01 don't launch the function ..."])
                return

        # store starting locations :
        listStartPlots = []
        for iPlayer in startPlots.keys() :
                listStartPlots.append(startPlots[iPlayer])

        # store all plots that can have a goody or would have a goody
        lGoodyPlots = []
        lNGPlots = []
        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)

                        iImprovement = pPlot.getImprovementType()

                        bCanHaveGoody = bool(pPlot.canHaveImprovement(iGoody, -1, True))

                        if (iImprovement != -1) or ((iX, iY) in listStartPlots) or (pPlot.isUnit()) or (pPlot.isOwned()) :
                                if bCanHaveGoody : lNGPlots.append((iX, iY))
                                continue
                        
                        if bCanHaveGoody : lGoodyPlots.append((iX, iY))

        nbGoodyToAdd = int((len(lGoodyPlots) + len(lNGPlots))*goodyPer/100.0) + 1

        #debug
        logList = []
        logList.append(" nb tiles that can receive a goody : %r" %(len(lGoodyPlots), ))
        logList.append(" nb tiles that would receive a goody : %r" %(len(lNGPlots), ))
        logList.append(" nb Goody To Add : %r" %nbGoodyToAdd)
        logList.append("")
        writeLog("", False, logList)

        # assign a value to prevent small islands to ever have a goody
        dictPlotsPerArea = getAreaPlots()
        plotValues = [[7 for iY in range(iH)] for iX in range(iW)]
        for lList in dictPlotsPerArea["land"] :
                nbGP = 0
                lTPPlots = []
                for iX, iY in lList :
                        if (iX, iY) in lNGPlots :
                                nbGP += 1
                        elif (iX, iY) in lGoodyPlots :
                                nbGP += 1
                                lTPPlots.append((iX, iY))
                if nbGP < 3 : #no goody on small islands
                        for cPlot in lTPPlots :
                                lGoodyPlots.remove(cPlot)
                elif nbGP < 11 : #placement penality for medium islands
                        for iX, iY in lTPPlots :
                                val = (11 - nbGP) / 2
                                plotValues[iX][iY] = 7 - val

        rings = generateRings(7)
        nbGoodyPlaced = 0
        while True :
                if nbGoodyPlaced >= nbGoodyToAdd : break
                if len(lGoodyPlots) == 0 : break
                val = max([plotValues[iX][iY] for iX, iY in lGoodyPlots])
                tpList = [(iX, iY) for iX, iY in lGoodyPlots if plotValues[iX][iY] == val]
                iChoice = getRandNum(len(tpList), " FoR : goody plot rand")
                iX, iY = tpList[iChoice]
                areaPlotList = getListPlotsPerArea((iX, iY), dictPlotsPerArea)
                for iRing in range(1, 8) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        if wTP in areaPlotList :
                                                plotValues[wTP[0]][wTP[1]] = min(iRing, plotValues[wTP[0]][wTP[1]])
                map.plot(iX, iY).setImprovementType(iGoody)
                lGoodyPlots.remove((iX, iY))
                nbGoodyPlaced += 1

        writeLog("", True, [" nb goody placed : %r" %nbGoodyPlaced])

def StoAddStartBonuses():
        global lBonusExtend
        writeLog(" = StoAddBonuses = ", False, [""])

        #CyMapGenerator().eraseBonuses()

        natRes = genNatureRes()
        nbRes = gc.getNumBonusInfos()
        nbTerrain = gc.getNumTerrainInfos()
        nbFeature = gc.getNumFeatureInfos()

        lResPro = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["strategic"]) and (natRes[iBonus][0] == 0))]
        lResFoo = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["health"]) and (natRes[iBonus][0] == 1))]
        lResLux = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["happiness"]) and (natRes[iBonus][0] == 2))]
        lRes = copy.copy(lResPro) + copy.copy(lResFoo) + copy.copy(lResLux)
        lResLand = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["land"]) and (natRes[iBonus][1]))]
        lResWater = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in XMLEntriesList["water"]) and (natRes[iBonus][2]))]

	bEraseAll = copy.copy(selGen["resources"]["resourcesstart"]["removestartres"])
        lResProNoRand = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in selGen["resources"]["resourcesstart"]["strategicnorandom"]) and (natRes[iBonus][0] == 0))]
        lResFooNoRand = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in selGen["resources"]["resourcesstart"]["healthnorandom"]) and (natRes[iBonus][0] == 1))]
        lResLuxNoRand = [iBonus for iBonus in range(nbRes) if ((gc.getBonusInfo(iBonus).getType() in selGen["resources"]["resourcesstart"]["happinessnorandom"]) and (natRes[iBonus][0] == 2))]

        lStartRes = []
        for sOption2 in selGen["resources"]["resourcesstart"].keys() :
                if sOption2[0:15] == "startresselect-" :
                        if selGen["resources"]["resourcesstart"][sOption2] == [] : continue
                        sIndex = sOption2[15:]
                        lTemp = []
                        for sOption in ["startresselect-", "startresquantity-", "startreslocation-", "startresforce-", "startresplayer-"] :
                                lTemp.append(copy.deepcopy(selGen["resources"]["resourcesstart"][sOption + sIndex]))
                        lStartRes.append([int(sIndex), lTemp])

        lStartRes.sort()
        lStartRes = [item[1] for item in lStartRes]

        logList = [""]
        logList.append(" bEraseAll : %r" %bEraseAll)
        logList.append(" lResProNoRand : %r" %lResProNoRand)
        logList.append(" lResFooNoRand : %r" %lResFooNoRand)
        logList.append(" lResLuxNoRand : %r" %lResLuxNoRand)
        for item in lStartRes :
                logList.append(repr(item))
        if len(lStartRes) == 0 : logList.append(" No start resources selected : skip")
        writeLog("", False, logList)

        if len(lStartRes) == 0 :
                writeLog("", True, [])
                return

        dictPlotsPerArea = getAreaPlots()
        dictBonus = {}
        for iPlayer in playerList :
                dictBonus[iPlayer] = {}
                dictBonus[iPlayer]["zone1"] = []
                dictBonus[iPlayer]["zone2"] = []
                dictBonus[iPlayer]["zone3_1"] = [] # same area
                dictBonus[iPlayer]["zone3_2"] = [] # diff area
                dictBonus[iPlayer]["areaList"] = getListPlotsPerArea(startPlots[iPlayer], dictPlotsPerArea)
                dictBonus[iPlayer]["nbBonus1"] = {}
                dictBonus[iPlayer]["nbBonus2"] = {}
                dictBonus[iPlayer]["nbBonus3"] = {}
                for iBonus in range(nbRes) :
                        dictBonus[iPlayer]["nbBonus1"][iBonus] = 0
                        dictBonus[iPlayer]["nbBonus2"][iBonus] = 0
                        dictBonus[iPlayer]["nbBonus3"][iBonus] = 0

        lImprovementPlots = []
        for iX in range(iW) :
                for iY in range(iH) :
                        if map.plot(iX, iY).getImprovementType() == -1 : continue
                        lImprovementPlots.append((iX, iY))

        bOneCityChallenge = bool(game.isOption(gc.getInfoTypeForString("GAMEOPTION_ONE_CITY_CHALLENGE")))

        iZone1Limit = 2
        iZone2Limit = 6
        if bOneCityChallenge : iZone2Limit = 4

        minDist = iW*iH
        maxDist = 0
        for iPlayer in playerList :
                distTemp = iW*iH
                look = False
                for iPlayer2 in playerList :
                        if iPlayer >= iPlayer2 : continue
                        distA = calculateAirDistance(startPlots[iPlayer], startPlots[iPlayer2])
                        distTemp = min(distTemp, distA)
                        look = True
                if look :
                        minDist = min(minDist, distTemp)
                        maxDist = max(maxDist, distTemp)

        iZone3Limit = max(8, int(minDist * 2.15 / 3.0))
        if bOneCityChallenge : iZone3Limit = 6

        rings = generateRings(max(7, iZone3Limit))
        cityRings = rings[1] + rings[2]
        bLakes = copy.copy(selGen["resources"]["resourcesgen"]["resspreadlake"])

        for iPlayer in playerList :
                iBonus = map.plot(startX[iPlayer], startY[iPlayer]).getBonusType(-1)
                if iBonus != -1 :
                        if bEraseAll :
                                map.plot(startX[iPlayer], startY[iPlayer]).setBonusType(-1)
                        else :
                                dictBonus[iPlayer]["nbBonus1"][iBonus] += 1
                                dictBonus[iPlayer]["nbBonus2"][iBonus] += 1
                                dictBonus[iPlayer]["nbBonus3"][iBonus] += 1

                for iRing in range(1, iZone1Limit + 1) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                if wTP == -1 : continue
                                if wTP in lImprovementPlots : continue

                                iX, iY = wTP
                                pPlot = map.plot(iX, iY)

                                if pPlot.isPeak() : continue
                                if pPlot.isImpassable() : continue

                                iBonus = pPlot.getBonusType(-1)
                                if iBonus != -1 :
                                        if bEraseAll :
                                                pPlot.setBonusType(-1)
                                        else :
                                                dictBonus[iPlayer]["nbBonus1"][iBonus] += 1
                                                dictBonus[iPlayer]["nbBonus2"][iBonus] += 1
                                                dictBonus[iPlayer]["nbBonus3"][iBonus] += 1
                                                continue

                                if pPlot.isWater() :
                                        bConnectedSL = True
                                        if pPlot.isLake() :
                                                if not bLakes : continue
                                                if iRing > 1 :
                                                        lPlots = getListPlotsPerArea(wTP, dictPlotsPerArea)
                                                        if (len(lPlots) < 5) or (bOneCityChallenge) : # small lake, check if water connected to start plot
                                                                bCArea = False
                                                                for dXX, dYY in rings[1] :
                                                                        wTP2 = toWrap(startX[iPlayer] + dXX, startY[iPlayer] + dYY)
                                                                        if wTP2 == -1 : continue
                                                                        if wTP2 in lPlots :
                                                                                bCArea = True
                                                                                break
                                                                if not bCArea : bConnectedSL = False

                                        if bConnectedSL : dictBonus[iPlayer]["zone1"].append(wTP)
                                        continue

                                if bOneCityChallenge :
                                        if not wTP in dictBonus[iPlayer]["areaList"] : continue
                                dictBonus[iPlayer]["zone1"].append(wTP)

        lZonePlots = []
        for iPlayer in playerList : lZonePlots += copy.deepcopy(dictBonus[iPlayer]["zone1"])
                                                        
        for iPlayer in playerList :
                for iRing in range(iZone1Limit, iZone2Limit + 1) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                if wTP == -1 : continue
                                if wTP in lImprovementPlots : continue
                                if wTP in lZonePlots : continue

                                iX, iY = wTP
                                pPlot = map.plot(iX, iY)

                                if pPlot.isPeak() : continue
                                if pPlot.isImpassable() : continue

                                bValid = True
                                for iPlayer2 in playerList :
                                        if wTP in dictBonus[iPlayer2]["zone2"] :
                                                distA = calculateAirDistance(startPlots[iPlayer], wTP)
                                                distB = calculateAirDistance(wTP, startPlots[iPlayer2])
                                                if distA <= distB :
                                                        dictBonus[iPlayer2]["zone2"].remove(wTP)
                                                        iBonus = pPlot.getBonusType(-1)
                                                        if iBonus != -1 :
                                                                dictBonus[iPlayer2]["nbBonus2"][iBonus] -= 1
                                                                dictBonus[iPlayer2]["nbBonus3"][iBonus] -= 1
                                                if distA >= distB :
                                                        bValid = False
                                if not bValid : continue

                                iBonus = pPlot.getBonusType(-1)
                                if iBonus != -1 :
                                        dictBonus[iPlayer]["nbBonus2"][iBonus] += 1
                                        dictBonus[iPlayer]["nbBonus3"][iBonus] += 1
                                        continue

                                if pPlot.isWater() :
                                        if (pPlot.isLake()) and (not bLakes) : continue
                                        
                                        bFoundLand = False
                                        for dXX, dYY in cityRings :
                                                wTP2 = toWrap(iX + dXX, iY + dYY)
                                                if wTP2 == -1 : continue
                                                if not map.plot(wTP2[0], wTP2[1]).isWater() :
                                                        bFoundLand = True
                                                        break
                                        if not bFoundLand : continue
                                        
                                        dictBonus[iPlayer]["zone2"].append(wTP)
                                        continue

                                if bOneCityChallenge :
                                        if not wTP in dictBonus[iPlayer]["areaList"] : continue
                                dictBonus[iPlayer]["zone2"].append(wTP)

        for iPlayer in playerList : lZonePlots += copy.deepcopy(dictBonus[iPlayer]["zone2"])
                                                        
        for iPlayer in playerList :
                for iRing in range(iZone2Limit, iZone3Limit + 1) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                if wTP == -1 : continue
                                if wTP in lImprovementPlots : continue
                                if wTP in lZonePlots : continue

                                iX, iY = wTP
                                pPlot = map.plot(iX, iY)

                                if pPlot.isPeak() : continue
                                if pPlot.isImpassable() : continue

                                bValid = True
                                bSameArea = bool(wTP in dictBonus[iPlayer]["areaList"])
                                for iPlayer2 in playerList :
                                        if bSameArea :
                                                if wTP in dictBonus[iPlayer2]["zone3_2"] :
                                                        dictBonus[iPlayer2]["zone3_2"].remove(wTP)
                                                        iBonus = pPlot.getBonusType(-1)
                                                        if iBonus != -1 :
                                                                dictBonus[iPlayer2]["nbBonus3"][iBonus] -= 1
                                                elif wTP in dictBonus[iPlayer2]["zone3_1"] :
                                                        distA = min(map.calculatePathDistance(pPlot, map.plot(startX[iPlayer], startY[iPlayer])), calculateAirDistance(startPlots[iPlayer], wTP) * 1.8)
                                                        map.resetPathDistance()
                                                        distB = min(map.calculatePathDistance(pPlot, map.plot(startX[iPlayer2], startY[iPlayer2])), calculateAirDistance(startPlots[iPlayer2], wTP) * 1.8)
                                                        map.resetPathDistance()

                                                        if distA <= distB :
                                                                dictBonus[iPlayer2]["zone3_1"].remove(wTP)
                                                                iBonus = pPlot.getBonusType(-1)
                                                                if iBonus != -1 :
                                                                        dictBonus[iPlayer2]["nbBonus3"][iBonus] -= 1
                                                        if distA >= distB :
                                                                bValid = False
                                        else :
                                                if wTP in dictBonus[iPlayer2]["zone3_1"] :
                                                        bValid = False
                                                elif wTP in dictBonus[iPlayer2]["zone3_2"] :
                                                        distA = calculateAirDistance(startPlots[iPlayer], wTP)
                                                        distB = calculateAirDistance(startPlots[iPlayer2], wTP)

                                                        if distA <= distB :
                                                                dictBonus[iPlayer2]["zone3_2"].remove(wTP)
                                                                iBonus = pPlot.getBonusType(-1)
                                                                if iBonus != -1 :
                                                                        dictBonus[iPlayer2]["nbBonus3"][iBonus] -= 1
                                                        if distA >= distB :
                                                                bValid = False
                                if not bValid : continue

                                iBonus = pPlot.getBonusType(-1)
                                if iBonus != -1 :
                                        dictBonus[iPlayer]["nbBonus3"][iBonus] += 1
                                        continue

                                if pPlot.isWater() :
                                        if (pPlot.isLake()) and (not bLakes) : continue

                                        bFoundLand = False
                                        for dXX, dYY in cityRings :
                                                wTP2 = toWrap(iX + dXX, iY + dYY)
                                                if wTP2 == -1 : continue
                                                if not map.plot(wTP2[0], wTP2[1]).isWater() :
                                                        bFoundLand = True
                                                        break
                                        if not bFoundLand : continue

                                        dictBonus[iPlayer]["zone3_2"].append(wTP)
                                        continue

                                if bOneCityChallenge :
                                        if not bSameArea : continue
                                if bSameArea :
                                        dictBonus[iPlayer]["zone3_1"].append(wTP)
                                else :
                                        dictBonus[iPlayer]["zone3_2"].append(wTP)
        
        logList = [""]
        for iPlayer in playerList :
                logList.append(" Player %d : zone1 %d, zone2 %d, zone3_1 %d, zone 3_2 %d" %(iPlayer, len(dictBonus[iPlayer]["zone1"]), len(dictBonus[iPlayer]["zone2"]), len(dictBonus[iPlayer]["zone3_1"]), len(dictBonus[iPlayer]["zone3_2"])))
        writeLog("", False, logList)
                                        
        for iPlayer in playerList :
                del dictBonus[iPlayer]["areaList"]
                for sTag in ["zone1", "zone2", "zone3_1", "zone3_2"] :
                        sNewTag = sTag + "bonus"
                        dictBonus[iPlayer][sNewTag] = {}
                        for iBonus in lRes :
                                dictBonus[iPlayer][sNewTag][iBonus] = [[], []]

                        for coord in dictBonus[iPlayer][sTag] :
                                iX, iY = coord
                                pPlot = map.plot(iX, iY)

                                terrainPlot = pPlot.getTerrainType()
                                featurePlot = pPlot.getFeatureType()
                                idHill = 0
                                if pPlot.isHills() : idHill = 1

                                pPlacement = (terrainPlot, featurePlot + 1, idHill)

                                for iBonus in lRes :
                                        if pPlot.canHaveBonus(iBonus, True) : dictBonus[iPlayer][sNewTag][iBonus][0].append(coord)
                                        elif pPlacement in lBonusExtend[iBonus] : dictBonus[iPlayer][sNewTag][iBonus][1].append(coord)

##        # verify region
##        for iPlayer in playerList :
##                for sTag in ["zone1", "zone2", "zone3_1", "zone3_2"] :
##                        sText = "Z" + sTag[4:] + "_P" + str(iPlayer)
##                        for iX, iY in dictBonus[iPlayer][sTag] :
##                                CyEngine().addSign(map.plot(iX, iY), 0, sText)

        logList = ["", " impl Start Resources :"]

        def getPlotForBonus(iP, iB, sZo) :
                for i in range(2) :
                        lP = [co for co in dictBonus[iP][sZo + "bonus"][iB][i] if co in dictBonus[iP][sZo]]
                        if len(lP) > 0 :
                                coc = lP[getRandNum(len(lP), " FoR : Start res plot choice for bonus")]
                                return coc
                return -1

        def getBonusListInZone(iP, sZo) :
                lB = []
                lZ = ["nbBonus1"]
                if sZo == "zone2" : lZ.append("nbBonus2")
                elif sZo in ["zone3_1", "zone3_2"] : lZ += ["nbBonus2", "nbBonus3"]
                for sT in lZ :
                        for iB in dictBonus[iPlayer][sT].keys() :
                                if dictBonus[iPlayer][sT][iB] > 0 : lB.append(iB)
                return lB

        def placeBonuses(dP, lZ, dB, lL) :

                if "zone3_1" in lZ : lT = ["nbBonus3"]
                elif "zone2" in lZ : lT = ["nbBonus2", "nbBonus3"]
                elif "zone1" in lZ : lT = ["nbBonus1", "nbBonus2", "nbBonus3"]

                for iP in dP.keys() :
                        iB, co = dP[iP]
                        lL.append(" place %s for player %d" %(gc.getBonusInfo(iB).getType(), iP))

                        map.plot(co[0], co[1]).setBonusType(iB)

                        for sZ in lZ :
                                if co in dB[iP][sZ] : dB[iP][sZ].remove(co)

                        for sT in lT : dB[iP][sT][iB] += 1
                lL.append("")
                return [dB, lL]

        def getSameBonusForPlayers(lP, lB, lZo) :
                while True :
                        dR = {}

                        if len(lB) == 0 : return -1

                        iBo = int(lB[getRandNum(len(lB), " FoR : bonus choice (same)")])
                        lB.remove(iBo)

                        bFAll = True
                        for iPl in lP :
                                bF = False
                                for szZo in lZo :
                                        cLo = getPlotForBonus(iPl, iBo, szZo)
                                        if cLo != -1 :
                                                bF = True
                                                dR[iPl] = [iBo, cLo]
                                                break

                                if not bF :
                                        bFAll = False
                                        break

                        if bFAll : return dR

        def getBonusForPlayer(iPl, lB, lZo) :
                while True :
                        if len(lB) == 0 : return -1

                        iBo = int(lB[getRandNum(len(lB), " FoR : bonus choice (for player)")])
                        lB.remove(iBo)

                        for szZo in lZo :
                                cLo = getPlotForBonus(iPl, iBo, szZo)
                                if cLo != -1 :
                                        return [iBo, cLo]

        lResProRand = [item for item in lResPro if not item in lResProNoRand]
        lResFooRand = [item for item in lResFoo if not item in lResFooNoRand]
        lResLuxRand = [item for item in lResLux if not item in lResLuxNoRand]

        for iPass in range(3) :
                for bonusSelection, bonusQuantity, bonusLocation, bonusApply, playerApply in lStartRes :
                        if bonusLocation != iPass : continue

                        lApplyPlayers = []
                        if 0 in playerApply : lApplyPlayers += copy.copy(playerHUList)
                        if 1 in playerApply : lApplyPlayers += copy.copy(playerAIList)

                        if bonusLocation == 0 : lZones = ["zone1"]
                        elif bonusLocation == 1 : lZones = ["zone2"]
                        elif bonusLocation == 2 : lZones = ["zone3_1", "zone3_2"]

                        nbBonus = bonusQuantity[0]

                        bForce = False
                        if bonusApply == 0 : bForce = True

                        logList.append("")
                        logList.append("")
                        logList.append(" Start Add for : players %r, bonus %r, quantity %d, zone %r, bForce %r" %(lApplyPlayers, bonusSelection, nbBonus, lZones, bForce))

                        if bForce :
                                for iQuantity in range(bonusQuantity[0]) :
                                        
                                        if bonusSelection in ["allstratsame", "allhealthsame", "allhappsame"] :
                                                dPlayerBonus = {}
                                                for iPlayer in lApplyPlayers : dPlayerBonus[iPlayer] = getBonusListInZone(iPlayer, lZones[0])

                                                if bonusSelection == "allstratsame" : lBonusRand = copy.copy(lResProRand)
                                                elif bonusSelection == "allhealthsame" : lBonusRand = copy.copy(lResFooRand)
                                                elif bonusSelection == "allhappsame" : lBonusRand = copy.copy(lResLuxRand)

                                                lAllBonus = copy.copy(lBonusRand)
                                                lNoneBonus = copy.copy(lBonusRand)

                                                for iPlayer in lApplyPlayers :
                                                        lAllBonus = [item for item in lAllBonus if item in dPlayerBonus[iPlayer]]
                                                        lNoneBonus = [item for item in lNoneBonus if not item in dPlayerBonus[iPlayer]]

                                                lOtherBonus = [item for item in lBonusRand if (not item in lAllBonus) and (not item in lNoneBonus)]

                                                dResult = getSameBonusForPlayers(lApplyPlayers, lNoneBonus, lZones)
                                                if dResult != -1 :
                                                        logList.append("... A bonus not present in the players zone added :")
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                dResult = getSameBonusForPlayers(lApplyPlayers, lAllBonus, lZones)
                                                if dResult != -1 :
                                                        logList.append("... A bonus present in all of the players zone added :")
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                dResult = getSameBonusForPlayers(lApplyPlayers, lOtherBonus, lZones)
                                                if dResult != -1 :
                                                        logList.append("... A random bonus added :")
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                logList.append("... can't find another bonus to add, go to next selection.")
                                                break

                                        elif bonusSelection in ["allstratdiff", "allhealthdiff", "allhappdiff"] :

                                                if bonusSelection == "allstratdiff" : lBonusRand = copy.copy(lResProRand)
                                                elif bonusSelection == "allhealthdiff" : lBonusRand = copy.copy(lResFooRand)
                                                elif bonusSelection == "allhappdiff" : lBonusRand = copy.copy(lResLuxRand)

                                                dResult = {}
                                                bFoundAll = True
                                                for iPlayer in lApplyPlayers :
                                                        lZoneBonus = getBonusListInZone(iPlayer, lZones[0])

                                                        lNoBonus = [item for item in lBonusRand if not item in lZoneBonus]
                                                        lOtherBonus = [item for item in lBonusRand if item in lZoneBonus]

                                                        rPlayer = getBonusForPlayer(iPlayer, lNoBonus, lZones)
                                                        if rPlayer != -1 :
                                                                dResult[iPlayer] = rPlayer
                                                                continue

                                                        rPlayer = getBonusForPlayer(iPlayer, lOtherBonus, lZones)
                                                        if rPlayer != -1 :
                                                                dResult[iPlayer] = rPlayer
                                                                continue

                                                        bFoundAll = False
                                                        break

                                                if bFoundAll :
                                                        logList.append("... A bonus added for all player :")
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                logList.append("... can't find another bonus to add, go to next selection.")
                                                break

                                        else :
                                                iBonus = gc.getInfoTypeForString(bonusSelection[0])
                                                if iBonus == -1 :
                                                        logList.append("... iBonus = -1 (%s) ??? , go to next selection." %bonusSelection[0])
                                                        break

                                                if not iBonus in lRes :
                                                        logList.append("... iBonus not in lRes (%s) ??? , go to next selection." %bonusSelection[0])
                                                        break

                                                dResult = {}
                                                bFoundAll = True
                                                for iPlayer in lApplyPlayers :

                                                        rPlayer = getBonusForPlayer(iPlayer, [iBonus], lZones)
                                                        if rPlayer != -1 :
                                                                dResult[iPlayer] = rPlayer
                                                                continue

                                                        bFoundAll = False
                                                        break

                                                if bFoundAll :
                                                        logList.append("... A bonus added for all player :")
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                logList.append("... can't place another bonus for all players, go to next selection.")
                                                break

                        else :
                                iQuantity = bonusQuantity[0]

                                if bonusSelection in ["allstratsame", "allstratdiff"] :
                                        lBonusRef = lResPro
                                        lBonusRand = lResProRand
                                elif bonusSelection in ["allhealthsame", "allhealthdiff"] :
                                        lBonusRef = lResFoo
                                        lBonusRand = lResFooRand
                                elif bonusSelection in ["allhappsame", "allhappdiff"] :
                                        lBonusRef = lResLux
                                        lBonusRand = lResLuxRand

                                if bonusSelection in ["allstratsame", "allhealthsame", "allhappsame"] :

                                        while True :
                                                dPlayerBonus = {}
                                                for iPlayer in lApplyPlayers :
                                                        dPlayerBonus[iPlayer] = {}
                                                        dPlayerBonus[iPlayer]["bonuslist"] = [item for item in getBonusListInZone(iPlayer, lZones[0]) if item in lBonusRef]
                                                        dPlayerBonus[iPlayer]["nbBonusToPlace"] = iQuantity - len(dPlayerBonus[iPlayer]["bonuslist"])

                                                bPlaceOne = False
                                                maxBonusToPlace = max([dPlayerBonus[iPlayer]["nbBonusToPlace"] for iPlayer in lApplyPlayers])
                                                for i in range(max(0, maxBonusToPlace)) :
                                                        iBonusMin = i + 1
                                                        lPlayerPlace = [iPlayer for iPlayer in lApplyPlayers if dPlayerBonus[iPlayer]["nbBonusToPlace"] >= iBonusMin]
                                                        lPlayerNoPlace = [iPlayer for iPlayer in lApplyPlayers if dPlayerBonus[iPlayer]["nbBonusToPlace"] < iBonusMin]

                                                        lBonusPlayerCommon = copy.copy(lBonusRand)
                                                        for iPlayer in lPlayerNoPlace :
                                                                lBonusPlayerCommon = [item for item in lBonusPlayerCommon if item in dPlayerBonus[iPlayer]["bonuslist"]]
                                                        lOtherBonus = [item for item in lBonusRand if not item in lBonusPlayerCommon]

                                                        for iPlayer in lPlayerPlace :
                                                                lBonusPlayerCommon = [item for item in lBonusPlayerCommon if not item in dPlayerBonus[iPlayer]["bonuslist"]]
                                                                lOtherBonus = [item for item in lOtherBonus if not item in dPlayerBonus[iPlayer]["bonuslist"]]

                                                        dResult = getSameBonusForPlayers(lPlayerPlace, lBonusPlayerCommon, lZones)
                                                        if dResult != -1 :
                                                                logList.append("... A bonus common for players %r has been added for players %r :" %(lPlayerNoPlace, lPlayerPlace))
                                                                dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                                bPlaceOne = True
                                                                break

                                                        dResult = getSameBonusForPlayers(lPlayerPlace, lOtherBonus, lZones)
                                                        if dResult != -1 :
                                                                logList.append("... A bonus NOT common for players %r has been added for players %r :" %(lPlayerNoPlace, lPlayerPlace))
                                                                dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                                bPlaceOne = True
                                                                break

                                                if not bPlaceOne :
                                                        if maxBonusToPlace > 0 :
                                                                logList.append("... can t find a common bonus, continue to next selection")
                                                        else :
                                                                logList.append("... all bonuses has been placed, continue to next selection")
                                                        break

                                elif bonusSelection in ["allstratdiff", "allhealthdiff", "allhappdiff"] :

                                        while True :
                                                dPlayerBonus = {}
                                                for iPlayer in lApplyPlayers :
                                                        dPlayerBonus[iPlayer] = {}
                                                        dPlayerBonus[iPlayer]["bonuslist"] = [item for item in getBonusListInZone(iPlayer, lZones[0]) if item in lBonusRef]
                                                        dPlayerBonus[iPlayer]["nbBonusToPlace"] = iQuantity - len(dPlayerBonus[iPlayer]["bonuslist"])

                                                maxBonusToPlace = max([dPlayerBonus[iPlayer]["nbBonusToPlace"] for iPlayer in lApplyPlayers])

                                                if maxBonusToPlace <= 0 :
                                                        logList.append("... No more bonus to add, continue to next selection")
                                                        break

                                                lPlayerPlace = [iPlayer for iPlayer in lApplyPlayers if dPlayerBonus[iPlayer]["nbBonusToPlace"] == maxBonusToPlace]

                                                dResult = {}
                                                bFoundAll = True
                                                for iPlayer in lPlayerPlace :
                                                        lOtherBonus = [item for item in lBonusRand if not item in dPlayerBonus[iPlayer]["bonuslist"]]

                                                        rPlayer = getBonusForPlayer(iPlayer, lOtherBonus, lZones)
                                                        if rPlayer != -1 :
                                                                dResult[iPlayer] = rPlayer
                                                                continue

                                                        bFoundAll = False
                                                        break

                                                if bFoundAll :
                                                        logList.append("... A bonus added for players %r " %(lPlayerPlace, ))
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                logList.append("... A bonus can t be added for players %r, continue to next selection " %(lPlayerPlace, ))
                                                break

                                else :

                                        iBonus = gc.getInfoTypeForString(bonusSelection[0])
                                        if iBonus == -1 :
                                                logList.append("... iBonus = -1 (%s) ??? , go to next selection." %bonusSelection[0])
                                                continue

                                        if not iBonus in lRes :
                                                logList.append("... iBonus not in lRes (%s) ??? , go to next selection." %bonusSelection[0])
                                                continue

                                        if bonusLocation == 0 : sZoneTag = "nbBonus1"
                                        elif bonusLocation == 1 : sZoneTag = "nbBonus2"
                                        elif bonusLocation == 2 : sZoneTag = "nbBonus3"

                                        while True :

                                                dPlayerBonus = {}
                                                for iPlayer in lApplyPlayers :
                                                        dPlayerBonus[iPlayer] = {}
                                                        dPlayerBonus[iPlayer]["nbBonusToPlace"] = iQuantity - dictBonus[iPlayer][sZoneTag][iBonus]

                                                maxBonusToPlace = max([dPlayerBonus[iPlayer]["nbBonusToPlace"] for iPlayer in lApplyPlayers])

                                                if maxBonusToPlace <= 0 :
                                                        logList.append("... No more bonus to add, continue to next selection")
                                                        break

                                                lPlayerPlace = [iPlayer for iPlayer in lApplyPlayers if dPlayerBonus[iPlayer]["nbBonusToPlace"] == maxBonusToPlace]

                                                dResult = {}
                                                bFoundAll = True
                                                for iPlayer in lPlayerPlace :

                                                        rPlayer = getBonusForPlayer(iPlayer, [iBonus], lZones)
                                                        if rPlayer != -1 :
                                                                dResult[iPlayer] = rPlayer
                                                                continue

                                                        bFoundAll = False
                                                        break

                                                if bFoundAll :
                                                        logList.append("... A bonus added for players %r " %(lPlayerPlace, ))
                                                        dictBonus, logList = placeBonuses(dResult, lZones, dictBonus, logList)
                                                        continue

                                                logList.append("... A bonus can t be added for players %r, continue to next selection " %(lPlayerPlace, ))
                                                break

        writeLog("", True, logList)

##!_!## additional functions for map generation
def StoAddGameElements():
        global dice
        dice = game.getSorenRand()

        writeLog(" = StoAddGameElements = ", False, [""])

        initPlayerList(True) # reinit starting locations , list of players , teams in case a player has disapeared (no more start loc , onGameStart impl)

        try :
                if bStandardAssignment :
                        CyInterface().addImmediateMessage("Warning !! default player starting locations implementation must have been run !!", "")
        except :
                writeLog("", False, ["", " message standart assignment : Error ..."])
                writeError()

        if is_BtS_FFH2 :
                try :
                        addFFH2Units()
                except :
                        writeLog("", False, ["", " addFFH2Units : Error ..."])
                        writeError()

        try :
                addGold()
        except :
                writeLog("", False, ["", " addGold : Error ..."])
                writeError()

        try :
                revealMap()
        except :
                writeLog("", False, ["", " revealMap : Error ..."])
                writeError()

        try :
                addTechs()
        except :
                writeLog("", False, [" addTechs : Error ..."])
                writeError()

        try :
                addUnits()
        except :
                writeLog("", False, [" addUnits : Error ..."])
                writeError()

        try :
                addBarbCities()
        except :
                writeLog("", False, [" addBarbCities : Error ..."])
                writeError()

        try :
                addAnimals()
        except :
                writeLog("", False, [" addAnimals : Error ..."])
                writeError()

        writeLog("", True, [""])

def addFFH2Units():
        barbPlayerID = gc.getBARBARIAN_PLAYER()
        for iUnit, iX, iY in unitsToPlaceOnImprovements :
                pUnit = spawnUnit(barbPlayerID, iUnit, iX, iY)

def addAnimals():
        animPer = getRandSel(selGen["game"]["animals"]["animalspercent"], False)

        logList = [""]
        if animPer == 0 :
                writeLog("", False, ["", " addAnimals() : animal percent = 0 ...", ""])
                return

        if not isBarb :
                writeLog("", False, ["", " addAnimals() : no barb option on ...", ""])
                return

        animNoPlace = copy.copy(selGen["game"]["animals"]["animalsnoplace"])
        animUnitRange = copy.copy(selGen["game"]["animals"]["animunitrange"][0])
        animXP = copy.copy(selGen["game"]["animals"]["xpanimals"][0])
        nbTilesMin = copy.copy(selGen["game"]["animals"]["nbtilesminisland"][0])

        logList.append(" addAnimals() : animPer %r" %animPer)
        logList.append(" addAnimals() : animNoPlace %r" %animNoPlace)
        logList.append(" addAnimals() : animUnitRange %r" %animUnitRange)
        logList.append(" addAnimals() : animXP %r" %animXP)
        logList.append(" addAnimals() : nbTilesMin %r" %nbTilesMin)
        logList.append("")

        animPer = animPer/100.0
        animPlace = [gc.getInfoTypeForString(item) for item in XMLEntriesList["units"]["animland"] if not item in animNoPlace]
        
        if animPlace == [] :
                writeLog("", False, ["", " addAnimals() : no animals to place ...", ""])
                return

        iBarbPlayer = gc.getBARBARIAN_PLAYER()

        powerAnim = {}
        maxPower = -1
        for iAnimal in animPlace :
                power = max(2, gc.getUnitInfo(iAnimal).getCombat())
                if power > maxPower : maxPower = power
                powerAnim[iAnimal] = power

        rings = generateRings(maxPower)

        lPlotsNoAnim = []
        lPlotsAnim = []
        dictPlotsPerArea = getAreaPlots()

        for lTp in dictPlotsPerArea["land"] :
                if len(lTp) < nbTilesMin : lPlotsNoAnim += copy.copy(lTp)

        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)

                        if pPlot.isOwned() :
                                pass
                        elif pPlot.isUnit() :
                                pUnit = pPlot.getUnit(0)
                                if pUnit.isNone() :
                                        pass
                                elif pUnit.getOwner() != iBarbPlayer :
                                        for dX in range(-1*animUnitRange, animUnitRange + 1) :
                                                for dY in range(-1*animUnitRange, animUnitRange + 1) :
                                                        wTP = toWrap(iX + dX, iY + dY)
                                                        if wTP != -1 :
                                                                if not wTP in lPlotsNoAnim : lPlotsNoAnim.append(wTP)
                                        continue
                        else :
                                continue

                        if not (iX, iY) in lPlotsNoAnim : lPlotsNoAnim.append((iX, iY))

        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)

                        if pPlot.isWater() : continue
                        if pPlot.isPeak() : continue
                        if pPlot.isImpassable() : continue
                        if pPlot.getImprovementType() != -1 : continue
                        if (iX, iY) in lPlotsNoAnim : continue

                        lPlotsAnim.append((iX, iY))

        if len(lPlotsAnim) == 0 :
                logList.append(" addAnimals() : map full , can't place an animal Oo ? ...")
                logList.append("")
                writeLog("", False, logList)
                return
        else :
                logList.append(" addAnimals() : nb anim plots %r" %(len(lPlotsAnim), ))

        plotValues = [[0 for iY in range(iH)] for iX in range(iW)]
        nbAnimPlaced = 0
        nbAnimToPlace = len(lPlotsAnim)*animPer
        while True :
                if nbAnimPlaced >= nbAnimToPlace : break
                if len(lPlotsAnim) == 0 : break
                val = min([plotValues[iX][iY] for iX, iY in lPlotsAnim])
                tpList = [(iX, iY) for iX, iY in lPlotsAnim if plotValues[iX][iY] == val]
                iChoice = getRandNum(len(tpList), " FoR : anim plot rand")
                iAnimal = animPlace[getRandNum(len(animPlace), " FoR : anim rand")]
                iX, iY = tpList[iChoice]
                for iRing in range(1, powerAnim[iAnimal]+1) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        plotValues[wTP[0]][wTP[1]] = max(powerAnim[iAnimal] - iRing + 1, plotValues[wTP[0]][wTP[1]])

                pUnit = spawnUnit(iBarbPlayer, iAnimal, iX, iY)
                if pUnit != -1 :
                        if (animXP > 0) and (pUnit.canAcquirePromotionAny()) :
                                pUnit.setExperience(animXP, -1)

                lPlotsAnim.remove((iX, iY))
                nbAnimPlaced += 1

        logList.append(" addAnimals() : nb anim placed %r" %nbAnimPlaced)
        logList.append("")
        writeLog("", False, logList)

def addBarbCities():
        cityPer = getRandSel(selGen["game"]["barbcities"]["cityper"], False)

        minBarbCities = 0
        if is_BtS_FFH2 :
                BarbWorld = gc.getInfoTypeForString("GAMEOPTION_BARBARIAN_WORLD")
                if BarbWorld != -1 :
                        if game.isOption(BarbWorld) : minBarbCities = len(playerList)

        logList = [""]
        if (cityPer == 0) and (minBarbCities == 0) :
                writeLog("", False, ["", " addBarbCities : city percent = 0 ...", ""])
                return

        if not isBarb :
                writeLog("", False, ["", " addBarbCities : no barb option on ...", ""])
                return

        cityBuildings = copy.copy(selGen["game"]["barbcities"]["citybuilding"])
        BBRange = copy.copy(selGen["game"]["barbcities"]["barbbarbrange"][0])
        BHRange = copy.copy(selGen["game"]["barbcities"]["barbhumrange"][0])
        defender = copy.copy(selGen["game"]["barbcities"]["defender"])
        nbDefender = copy.copy(selGen["game"]["barbcities"]["nbdefender"][0])
        xpDefender = copy.copy(selGen["game"]["barbcities"]["xpdefender"][0])
        nbTilesMin = copy.copy(selGen["game"]["barbcities"]["nbtilesminisland"][0])

        logList.append(" addBarbCities : cityPer %r" %cityPer)
        logList.append(" addBarbCities : minBarbCities %r" %minBarbCities)
        logList.append(" addBarbCities : cityBuildings %r" %cityBuildings)
        logList.append(" addBarbCities : BBRange %r" %BBRange)
        logList.append(" addBarbCities : BHRange %r" %BHRange)
        logList.append(" addBarbCities : defender %r" %defender)
        logList.append(" addBarbCities : nbDefender %r" %nbDefender)
        logList.append(" addBarbCities : xpDefender %r" %xpDefender)
        logList.append(" addBarbCities : nbTilesMin %r" %nbTilesMin)
        logList.append("")

        cityPer = cityPer/100.0
        cityBuildings = [gc.getInfoTypeForString(item) for item in cityBuildings]

        bDefender = bool( (defender != []) and (nbDefender > 0) )
        if bDefender : iDefender = gc.getInfoTypeForString(defender[0])

        iBarbPlayer = gc.getBARBARIAN_PLAYER()
        pPlayer = gc.getPlayer(iBarbPlayer)

        rings = generateRings(max(BBRange, BHRange))

        lPlotsNoCity = []
        for iPlayer in playerList :
                for iRing in range(BHRange) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                if wTP != -1 :
                                        lPlotsNoCity.append(wTP)

        lFeaturesNoCity = []
        for iFeature in range(gc.getNumFeatureInfos()) :
                if gc.getFeatureInfo(iFeature).isNoCity() : lFeaturesNoCity.append(iFeature)

        lGoodyImprovements = []
        for iImprovement in range(gc.getNumImprovementInfos()) :
                if gc.getImprovementInfo(iImprovement).isGoody() : lGoodyImprovements.append(iImprovement)

        logList.append(" addBarbCities : lFeaturesNoCity %r" %([gc.getFeatureInfo(iFeature).getType() for iFeature in lFeaturesNoCity], ))
        logList.append(" addBarbCities : lGoodyImprovements %r" %([gc.getImprovementInfo(iImprovement).getType() for iImprovement in lGoodyImprovements], ))
        logList.append("")

        lPlotsCity = []
        nbCountAreaPlots = 0

        dictPlotsPerArea = getAreaPlots()
        lNoLandPlots = []
        for lTp in dictPlotsPerArea["land"] :
                if len(lTp) < nbTilesMin : lNoLandPlots += copy.copy(lTp)

        for iX in range(iW) :
                for iY in range(iH) :
                        pPlot = map.plot(iX, iY)
                        if pPlot.isWater():
                                for iRing in range(BBRange) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        if not map.plot(wTP[0], wTP[1]).isWater() :
                                                                if wTP in lNoLandPlots : continue
                                                                nbCountAreaPlots += 1
                                                                break
                                continue

                        if (iX, iY) in lNoLandPlots : continue

                        nbCountAreaPlots += 1

                        if (iX, iY) in lPlotsNoCity : continue
                        if pPlot.isPeak() : continue
                        if pPlot.getFeatureType() in lFeaturesNoCity : continue
                        iPlotImprovement = pPlot.getImprovementType()
                        if (iPlotImprovement != -1) and (not iPlotImprovement in lGoodyImprovements) : continue
                        if not wrapX :
                                if iX < 2 : continue
                                if iX > iW-3 : continue
                        if not wrapY :
                                if iY < 2 : continue
                                if iY > iH-3 : continue

                        lPlotsCity.append((iX, iY))

        if len(lPlotsCity) == 0 :
                logList.append(" addBarbCities : map full , can't place a city ...")
                logList.append("")
                writeLog("", False, logList)
                return

        cityNames = []
        for iCiv in range(gc.getNumCivilizationInfos()) :
                civXML = gc.getCivilizationInfo(iCiv)
                for iIndex in range(civXML.getNumCityNames()) :
                        sName = ""
                        try :
                                uName = CyTranslator().getText(civXML.getCityNames(iIndex),())
                                sName = getSText(uName)
                        except :
                                writeLog("", False, [" addBarbCities : encodage Error ..."])
                                writeError()
                                
                        if sName != "" : cityNames.append(sName)

        sylBarb = []
        sylBarb.append(['sto','mori','kog','lob','zox','cor','kog','kono','xol','bino','zoll','spor','lob','jok','tob','roq','fobo','no','wog','sod'])
        sylBarb.append(['niu','rul','yu','ru','ung','bug','fun','jul','xinu','tlu','yug','mung','urli','dul','xul','molu','neru','halu','miy'])
        sylBarb.append(['shra','xaw','hay','shi','sri','sag','asa','sic','ino','hal','fral','kami','eni','des','noen','ari','slia','pix','ubu','ex'])
        nbSylBarb = len(sylBarb)
        lenBarb = [len(sylBarb[i]) for i in range(nbSylBarb)]
        def getCityName():
                nameTP = ""
                choSyl = getRandNum(nbSylBarb, " FoR : list syl choice for barb city name")
                for i in range(getRandNum(3, " FoR : len barb city name") + 1) :
                        sylTP = sylBarb[choSyl][getRandNum(lenBarb[choSyl], " FoR : syl barb city name")]
                        nameTP += sylTP
                nameTP = nameTP.capitalize()
                if nameTP in cityNames :
                        while nameTP in cityNames :
                                sylTP = sylBarb[choSyl][getRandNum(lenBarb[choSyl], " FoR : additionnal syl barb city name")]
                                nameTP += sylTP
                cityNames.append(nameTP)
                return nameTP

        def fullBarbCity(city):
                for iBuilding in cityBuildings :
                        try:
                                if BtS : city.setNumRealBuilding(iBuilding, 1)
                                else : city.setHasRealBuilding(iBuilding, True)
                        except:
                                writeLog("", False, [" addBarbCities : add building %r Error ..." %(gc.getBuildingInfo(iBuilding).getType(), )])
                                writeError()

                cityName = getCityName()
                try:
                        city.setName(cityName, False)
                except:
                        writeLog("", False, [" addBarbCities : city name error ..."])
                        writeError()

                if bDefender :
                        for i in range(nbDefender) :
                                pUnit = spawnUnit(iBarbPlayer, iDefender, city.getX(), city.getY())
                                if pUnit != -1 :
                                        try:
                                                pUnit.setUnitAIType(UnitAITypes.UNITAI_CITY_DEFENSE)
                                        except:
                                                writeLog("", False, [" addBarbCities : unitAIType error ..."])
                                                writeError()
                                        if (xpDefender > 0) and (pUnit.canAcquirePromotionAny()) :
                                                pUnit.setExperience(xpDefender, -1)

        nbCityPlaced = 0
        lenPlotsToReach = int(len(lPlotsCity)*(1 - cityPer)) # area that not be filled with cities
        ## 1rst try to equalize city placements
        areaCity = 0
        for iRing in range(BBRange) : areaCity += len(rings[iRing])

        nbCityBarbEstim = max(1.0, (nbCountAreaPlots*cityPer/areaCity) - len(playerList), minBarbCities)
        nbCityPerPlot = nbCityBarbEstim/len(lPlotsCity)

        # step calculation, in order to have a good region separation 
        pas = sqrt(iW*iH/nbCityBarbEstim)
        if pas > iW :
                nbX = iW
                nbY = max(1, int(iH/nbCityBarbEstim))
        elif pas > iH :
                nbX = max(1, int(iW/nbCityBarbEstim))
                nbY = iH
        else :
                nbX = max(1, int(iW/pas))
                nbY = max(1, int(iH/pas))
        pasX = int(iW/nbX)
        pasY = int(iH/nbY)
        if iW%nbX != 0 : pasX += 1
        if iH%nbY != 0 : pasY += 1
        pasX = max(8, pasX)
        pasY = max(8, pasY)
        nbX = max(1, int(iW/pasX))
        nbY = max(1, int(iH/pasY))
        if iW%pasX != 0 : nbX += 1
        if iH%pasY != 0 : nbY += 1

        forTo = {}
        regionsPlotsEqui = [[[] for j in range(nbY)] for i in range(nbX)]
        for (iX, iY) in lPlotsCity :
                xRest = iX/pasX
                yRest = iY/pasY
                regionsPlotsEqui[xRest][yRest].append((iX, iY))
                forTo[(iX, iY)] = (xRest, yRest)

        nbToPlaceEqui = [[nbCityPerPlot*len(regionsPlotsEqui[i][j]) for j in range(nbY)] for i in range(nbX)]
        nbPlacedEqui = [[0 for j in range(nbY)] for i in range(nbX)]

        nbAttempts = int(nbCityBarbEstim/(nbX*nbY))

        logList.append(" addBarbCities : nbCityBarbEstim %r" %nbCityBarbEstim)
        logList.append(" addBarbCities : nbX %r" %nbX)
        logList.append(" addBarbCities : nbY %r" %nbY)
        logList.append(" addBarbCities : nbAttempts %r" %nbAttempts)
        logList.append("")

        for attempt in range(nbAttempts) :
                for pX in range(nbX) :
                        for pY in range(nbY) :
                                if len(regionsPlotsEqui[pX][pY]) == 0 : continue
                                if nbToPlaceEqui[pX][pY] <= nbPlacedEqui[pX][pY] : continue

                                iChoice = getRandNum(len(regionsPlotsEqui[pX][pY]), " FoR : equi barb city placement")
                                iX, iY = regionsPlotsEqui[pX][pY][iChoice]
                                lPlotsCity.remove((iX, iY))
                                dpX, dpY = forTo[(iX, iY)]
                                regionsPlotsEqui[dpX][dpY].remove((iX, iY))

                                for iRing in range(2) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        pTempPlot = map.plot(wTP[0], wTP[1])
                                                        if pTempPlot.getImprovementType() in lGoodyImprovements : pTempPlot.setImprovementType(-1)

                                try :
                                        pCity = pPlayer.initCity(iX, iY)
                                except:
                                        writeLog("", False, [" addBarbCities : init city Error ..."])
                                        writeError()
                                        continue

                                for iRing in range(BBRange) :
                                        for dX, dY in rings[iRing] :
                                                wTP = toWrap(iX + dX, iY + dY)
                                                if wTP != -1 :
                                                        if wTP in lPlotsCity:
                                                                lPlotsCity.remove(wTP)
                                                                dpX, dpY = forTo[wTP]
                                                                regionsPlotsEqui[dpX][dpY].remove(wTP)

                                nbCityPlaced += 1
                                nbPlacedEqui[pX][pY] += 1
                                fullBarbCity(pCity)

        logList.append(" addBarbCities : equi placement , nb cities placed %r" %nbCityPlaced)
        logList.append("")

        # place the rest of the cities
        while True:
                if (lenPlotsToReach >= len(lPlotsCity)) and (minBarbCities <= nbCityPlaced) : break
                if len(lPlotsCity) == 0 : break

                iChoice = getRandNum(len(lPlotsCity), " FoR : barb city placement")
                iX, iY = lPlotsCity[iChoice]
                lPlotsCity.remove((iX, iY))

                for iRing in range(2) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        pTempPlot = map.plot(wTP[0], wTP[1])
                                        if pTempPlot.getImprovementType() in lGoodyImprovements : pTempPlot.setImprovementType(-1)

                try :
                        pCity = pPlayer.initCity(iX, iY)
                except:
                        writeLog("", False, [" addBarbCities : init city Error ..."])
                        writeError()
                        continue

                for iRing in range(BBRange) :
                        for dX, dY in rings[iRing] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        if wTP in lPlotsCity:
                                                lPlotsCity.remove(wTP)

                nbCityPlaced += 1
                fullBarbCity(pCity)

        # give some extra gold for barb player to maintain its units for the start of the game
        goldRate = pPlayer.calculateGoldRate()
        if goldRate < 0 :
                extraGold = -1*goldRate*250
                pPlayer.changeGold(extraGold)
                logList.append(" addBarbCities : change gold %r" %extraGold)

        logList.append(" addBarbCities : end placement , nb cities placed %r" %nbCityPlaced)
        logList.append("")
        writeLog("", False, logList)

def addUnits():
        lAddUnits = []
        for sKey in selGen["game"]["startunit"].keys() :
                if not "startunitselect-" in sKey : continue
                pSel = copy.copy(selGen["game"]["startunit"][sKey])
                if pSel == [] : continue
                buff = [pSel[0]]
                selID = sKey.split("-")[1]
                buff.append(copy.copy(selGen["game"]["startunit"]["startunittype-%s" %selID]))
                buff.append(copy.copy(selGen["game"]["startunit"]["startunitquantity-%s" %selID][0]))
                buff.append(copy.copy(selGen["game"]["startunit"]["startunitxp-%s" %selID][0]))
                buff.append(copy.copy(selGen["game"]["startunit"]["startunitplayers-%s" %selID]))
                lAddUnits.append(buff)

        dictPlotsPerArea = getAreaPlots()
        rings = generateRings(1)
        logList = []
        for sUnitType, iAdaptType, nbUnits, nbXP, applyPlayers in lAddUnits :
                logList.append("")
                logList.append(" addUnits : unit %r , iAdaptType %r , nbUnits %r , nbXP %r , applyPlayers %r" %(sUnitType, iAdaptType, nbUnits, nbXP, applyPlayers))
                lPlayers = []
                if 0 in applyPlayers : lPlayers += copy.copy(playerHUList)
                if 1 in applyPlayers : lPlayers += copy.copy(playerAIList)

                for iPlayer in lPlayers :
                        pPlayer = gc.getPlayer(iPlayer)
                        iUnit = gc.getInfoTypeForString(sUnitType)
                        iUnitClass = gc.getUnitInfo(iUnit).getUnitClassType()
                        civXML =  gc.getCivilizationInfo(pPlayer.getCivilizationType())

                        if iAdaptType == 0 :
                                iSpawnUnit = iUnit
                        elif iAdaptType == 1 :
                                iGoodUnit = civXML.getCivilizationUnits(iUnitClass)
                                if iGoodUnit == -1 :
                                        iSpawnUnit = iUnit
                                else :
                                        iSpawnUnit = iGoodUnit
                        else :
                                iGoodUnit = civXML.getCivilizationUnits(iUnitClass)
                                if iGoodUnit == -1 :
                                        logList.append(" addUnits : player %r don't have an unit for class %r" %(iPlayer, gc.getUnitClassInfo(iUnitClass).getType()))
                                        continue
                                else :
                                        iSpawnUnit = iGoodUnit

                        unitXML = gc.getUnitInfo(iSpawnUnit)
                        unitDomain = unitXML.getDomainType()
                        unitMinArea = unitXML.getMinAreaSize()

                        if unitDomain == DomainTypes.DOMAIN_SEA :
                                sX, sY = (-1, -1)
                                for dX, dY in rings[1] :
                                        wTP = toWrap(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                        if wTP != -1 :
                                                if map.plot(wTP[0], wTP[1]).isWater() :
                                                        lAreaPlots = getListPlotsPerArea((wTP[0], wTP[1]), dictPlotsPerArea)
                                                        if len(lAreaPlots) >= unitMinArea :
                                                                sX, sY = wTP
                                                                break
                        else :
                                sX, sY = startPlots[iPlayer]

                        if sX == -1 :
                                logList.append(" addUnits : player %r can't spawn unit %r" %(iPlayer, unitXML.getType()))
                        else :
                                for i in range(nbUnits) :
                                        pUnit = spawnUnit(iPlayer, iSpawnUnit, sX, sY)

                                        if pUnit == -1 :
                                                break
                                        elif (nbXP > 0) and (pUnit.canAcquirePromotionAny()) :
                                                pUnit.setExperience(nbXP, -1)

                                if pUnit != -1 :
                                        logList.append(" addUnits : player %r spawn unit %r" %(iPlayer, unitXML.getType()))
                                else :
                                        logList.append(" addUnits : player %r spawn unit %r ... an error has been raised" %(iPlayer, unitXML.getType()))

        logList.append("")
        writeLog("", False, logList)

def spawnUnit(iPlayer, iUnit, iX, iY, lProms = []):
        pUnit = -1
        try :
                pPlayer = gc.getPlayer(iPlayer)
                if BtS :
                        pUnit = pPlayer.initUnit(iUnit, iX, iY, UnitAITypes.NO_UNITAI, DirectionTypes.NO_DIRECTION)
                        for iProm in lProms : pUnit.setHasPromotion(iProm, True)
                        if is_BtS_FFH2 :
                                if gc.getUnitInfo(iUnit).getType() in XMLEntriesList["units"]["animland"] :
                                        iHN = gc.getInfoTypeForString("PROMOTION_HIDDEN_NATIONALITY")
                                        if iHN != 1 : pUnit.setHasPromotion(iHN, True)
                else :
                        pUnit = pPlayer.initUnit(iUnit, iX, iY, UnitAITypes.NO_UNITAI)
                        for iProm in lProms : pUnit.setHasPromotion(iProm, True)
        except :
                writeLog("", False, [" spawnUnit : init unit Error : player %r , unit %r , coords (%r, %r)" %(iPlayer, gc.getUnitInfo(iUnit).getType(), iX, iY)])
                writeError()

        return pUnit

def addTechs():
        userInputRemove = copy.copy(selGen["game"]["techno"]["starttechs"])
        userInputNotRemove = copy.copy(selGen["game"]["techno"]["technoreplace"])
        userInputNotRandom = copy.copy(selGen["game"]["techno"]["technorandom"])

        lAddTechs  = []
        for sKey in selGen["game"]["techno"].keys() :
                if not "addtech-" in sKey : continue
                pSel = copy.copy(selGen["game"]["techno"][sKey])
                if pSel == [] : continue
                buff = [pSel]
                selID = sKey.split("-")[1]
                buff.append(copy.copy(selGen["game"]["techno"]["techquantity-%s" %selID]))
                buff.append(copy.copy(selGen["game"]["techno"]["techplayers-%s" %selID]))
                lAddTechs.append(buff)

        lTechs = copy.copy(XMLEntriesList["techslist"])
        lTechsReapeat = [ sTech for sTech in lTechs if gc.getTechInfo(gc.getInfoTypeForString(sTech)).isRepeat() ]

        logList = [""]
        logList.append(" addTechs : base list : %r" %lTechs)
        logList.append(" addTechs : techs repeat : %r" %lTechsReapeat)
        logList.append(" addTechs : userInputRemove : %r" %userInputRemove)
        logList.append(" addTechs : userInputNotRemove : %r" %userInputNotRemove)
        logList.append(" addTechs : userInputNotRandom : %r" %userInputNotRandom)
        logList.append(" addTechs : lAddTechs : %r" %lAddTechs)
        writeLog("", False, logList)

        lTechsNotRemove = [ gc.getInfoTypeForString(item) for item in userInputNotRemove ]
        lTechsNotRandom = [ gc.getInfoTypeForString(item) for item in userInputNotRandom ]
        lTechs = [ gc.getInfoTypeForString(item) for item in lTechs ]
        lTechsReapeat = [ gc.getInfoTypeForString(item) for item in lTechsReapeat ]

        logList = ["", " addTechs : Techs list per team :"]
        for iTeam in teamList :
                pTeam = gc.getTeam(iTeam)
                lTechsOwned = []
                for iTech in range(gc.getNumTechInfos()) :
                        if pTeam.isHasTech(iTech) :
                                lTechsOwned.append(gc.getTechInfo(iTech).getType())
                logList.append(" addTechs : team %r , starting techs : %r " %(iTeam, lTechsOwned))
        writeLog("", False, logList)
                
        logList = ["", " addTechs : Techs removed :"]
        if userInputRemove == 1 :
                for iTeam in teamList :
                        pTeam = gc.getTeam(iTeam)
                        for iTech in lTechs :
                                if iTech in lTechsNotRemove : continue
                                if pTeam.isHasTech(iTech) :
                                        pTeam.setHasTech(iTech, False, PlayerTypes.NO_PLAYER, False, False)
                                        logList.append(" addTechs : team : %r , %s removed" %(iTeam, gc.getTechInfo(iTech).getType()))
        else :
                logList.append(" addTechs : None")
        writeLog("", False, logList)
                
        logList = ["", " addTechs : Techs added :", ""]
        for techID, nbTech, appliedTeams in lAddTechs :
                logList.append(" addTechs : entries , %r, %r, %r" %(techID, nbTech, appliedTeams))
                if techID in ["alltechsame", "alltechdiff"] :
                        lTeams = []
                        if 0 in appliedTeams : lTeams += copy.copy(teamHUList)
                        if 1 in appliedTeams : lTeams += copy.copy(teamAIList)
                        logList.append("")
                        logList.append(" addTechs : teams , %r" %lTeams)
                        if lTeams == [] : continue

                        for iPass in range(nbTech[0]):
                                logList.append("")
                                logList.append(" addTechs : pass , %r / %r" %(iPass, nbTech[0]-1))
                                dTechsOwned = {}
                                dTechsCanHave = {}
                                for iTeam in lTeams :
                                        dTechsOwned[iTeam] = [iTech for iTech in lTechs if gc.getTeam(iTeam).isHasTech(iTech)]
                                        logList.append(" addTechs : teams %r has techs %r" %(iTeam, [gc.getTechInfo(iTech).getType() for iTech in dTechsOwned[iTeam]]))
                                        dTechsCanHave[iTeam] = [iTech for iTech in lTechs if (not iTech in lTechsNotRandom) and (teamCanResearch(iTeam, iTech))]
                                        logList.append(" addTechs : teams %r can learn techs %r" %(iTeam, [gc.getTechInfo(iTech).getType() for iTech in dTechsCanHave[iTeam]]))

                                logList.append("")

                                if techID == "alltechsame" :
                                        commonTechs = []
                                        for iTech in lTechs :
                                                bCommon = True
                                                for iTeam in lTeams :
                                                        if not iTech in dTechsCanHave[iTeam] :
                                                                bCommon = False
                                                                break
                                                if bCommon : commonTechs.append(iTech)

                                        if len(commonTechs) > 0 :
                                                logList.append(" addTechs : common techs : %r" %([gc.getTechInfo(iTech).getType() for iTech in commonTechs], ))
                                                lSortTechs = [[gc.getTechInfo(iTech).getResearchCost(), iTech] for iTech in commonTechs]
                                                lSortTechs.sort()
                                                logList.append(" addTechs : common techs : %r" %([[item[0], gc.getTechInfo(item[1]).getType()] for item in lSortTechs], ))
                                                maxVal = lSortTechs[0][0]*1.80
                                                lRandTechs = [item[1] for item in lSortTechs if item[0] <= maxVal]
                                                logList.append(" addTechs : common random techs : %r" %([gc.getTechInfo(iTech).getType() for iTech in lRandTechs], ))
                                                iIndexTech = getRandNum(len(lRandTechs), " FoR : same tech selection")
                                                iChosenTech = lRandTechs[iIndexTech]
                                                logList.append(" addTechs : techs %r chosen" %(gc.getTechInfo(iChosenTech).getType(), ))
                                                for iTeam in lTeams :
                                                        gc.getTeam(iTeam).setHasTech(iChosenTech, True, PlayerTypes.NO_PLAYER, False, False)
                                        else :
                                                logList.append(" addTechs : no common techs to learn ...")

                                else :
                                        for iTeam in lTeams :
                                                if len(dTechsCanHave[iTeam]) == 0 :
                                                        logList.append(" addTechs : team %r , no more techs to learn ..." %iTeam)
                                                        logList.append("")
                                                        lTeams.remove(iTeam)
                                                        
                                        if lTeams == [] :
                                                logList.append(" addTechs : no more teams to learn a tech ... break")
                                                break

                                        lTeamEstimate = [[ gc.getTechInfo(iTech).getResearchCost() for iTech in dTechsCanHave[iTeam] ] for iTeam in lTeams ]
                                        minValTeam = [ min(item) for item in lTeamEstimate ]
                                        maxValTeam = [ max(item) for item in lTeamEstimate ]

                                        logList.append(" addTechs : techs value per team : %r" %lTeamEstimate)
                                        logList.append(" addTechs : min techs value per team : %r" %minValTeam)
                                        logList.append(" addTechs : max techs value per team : %r" %maxValTeam)
                                        logList.append("")

                                        minValue = max(minValTeam)
                                        maxValue = min(maxValTeam)

                                        for iTeam in lTeams :
                                                iIndexTeam = lTeams.index(iTeam)

                                                if maxValTeam[iIndexTeam] <= minValue :
                                                        logList.append(" addTechs : team %r , force maximum value for tech" %iTeam)
                                                        lRandTechs = [iTech for iTech in dTechsCanHave[iTeam] if gc.getTechInfo(iTech).getResearchCost() == maxValTeam[iIndexTeam]]
                                                elif minValTeam[iIndexTeam] >= maxValue :
                                                        logList.append(" addTechs : team %r , force minimum value for tech" %iTeam)
                                                        lRandTechs = [iTech for iTech in dTechsCanHave[iTeam] if gc.getTechInfo(iTech).getResearchCost() == minValTeam[iIndexTeam]]
                                                else :
                                                        lRandTechs = [iTech for iTech in dTechsCanHave[iTeam] if (gc.getTechInfo(iTech).getResearchCost() >= minValue) and (gc.getTechInfo(iTech).getResearchCost() <= maxValue)]
                                                        if lRandTechs == [] :
                                                                logList.append(" addTechs : team %r , can find a value in the range ... assign all possible tech for random" %iTeam)
                                                                lRandTechs = dTechsCanHave[iTeam]
                                                        else :
                                                                logList.append(" addTechs : team %r , techs in the range ." %iTeam)

                                                logList.append(" addTechs : team %r , random techs : %r" %(iTeam, [gc.getTechInfo(iTech).getType() for iTech in lRandTechs]))
                                                iIndexTech = getRandNum(len(lRandTechs), " FoR : different tech selection")
                                                iChosenTech = lRandTechs[iIndexTech]
                                                logList.append(" addTechs : team %r , techs %r chosen" %(iTeam, gc.getTechInfo(iChosenTech).getType()))
                                                gc.getTeam(iTeam).setHasTech(iChosenTech, True, PlayerTypes.NO_PLAYER, False, False)
                                                logList.append("")

                else :
                        iTech = gc.getInfoTypeForString(techID[0])
                        lTeams = []
                        if 0 in appliedTeams : lTeams += copy.copy(teamHUList)
                        if 1 in appliedTeams : lTeams += copy.copy(teamAIList)
                        for iTeam in lTeams :
                                nTechs = 1
                                if iTech in lTechsReapeat : nTechs = nbTech[0]
                                for i in range(nTechs) :
                                        gc.getTeam(iTeam).setHasTech(iTech, True, PlayerTypes.NO_PLAYER, False, False)
                        logList.append("")
                        logList.append(" addTechs : teams %r , %r * %r added" %(lTeams, nTechs, gc.getTechInfo(iTech).getType()))

                logList.append("")
        writeLog("", False, logList)

def playerCanResearch(iPlayer, iTech):
        pPlayer = gc.getPlayer(iPlayer)
        pTeam = gc.getTeam(pPlayer.getTeam())
        techXML = gc.getTechInfo(iTech)

        if not techXML.getType() in XMLEntriesList["techslist"] : return False
        if pTeam.isHasTech(iTech) : return False
        try : #try to use can ever research , can bug because of python callback impl
                if not pPlayer.canEverResearch(iTech) : return False
        except :
                writeLog("", False, [" addTechs : Error with canEverResearch (probably python call back error) ..."])
                writeError()
        try : #try to use can research , can bug because of python callback impl . Return false in case of a non advanced start game (no city founded)
                if pPlayer.canResearch(iTech, False) : return True
        except :
                writeLog("", False, [" addTechs : Error with canResearch (probably python call back error) ..."])
                writeError()

        # looking for prerequires for the tech :
        bFoundPossible = False
        bFoundValid = False

        for iOrPrereq in range(gc.getDefineINT("NUM_OR_TECH_PREREQS")) :
                iTechPrereq = techXML.getPrereqOrTechs(iOrPrereq)
                if iTechPrereq == -1 : continue
                bFoundPossible = True
                if pTeam.isHasTech(iTechPrereq) :
                        bFoundValid = True
                        break

        if bFoundPossible and (not bFoundValid) : return False
        
        for iAndPrereq in range(gc.getDefineINT("NUM_AND_TECH_PREREQS")) :
                iTechPrereq = techXML.getPrereqAndTechs(iAndPrereq)
                if iTechPrereq == -1 : continue
                if not pTeam.isHasTech(iTechPrereq) : return False

        return True

def teamCanResearch(iTeam, iTech):
        for iPlayer in playerList :
                if gc.getPlayer(iPlayer).getTeam() != iTeam : continue
                if playerCanResearch(iPlayer, iTech) : return True
        return False

def revealMap():
        userInputRange = getRandSel(selGen["game"]["reveal"]["startrange"], False)
        userInputSea = copy.copy(selGen["game"]["reveal"]["seareveal"])
        userInputLand = copy.copy(selGen["game"]["reveal"]["landreveal"])
        userInputStart = copy.copy(selGen["game"]["reveal"]["startlocs"])

        logList = [""]
        logList.append(" reaveal : start range : %r" %userInputRange)
        logList.append(" reaveal : sea : %r" %userInputSea)
        logList.append(" reaveal : land : %r" %userInputLand)
        logList.append(" reaveal : start loc : %r" %userInputStart)
        writeLog("", False, logList)

        rings = generateRings(max(2, userInputRange))
        cityRings = rings[0] + rings[1] + rings[2]
        noTeam = TeamTypes.NO_TEAM

        if userInputRange > 0 :
                for iPlayer in playerList :
                        iTeam = gc.getPlayer(iPlayer).getTeam()
                        for iRing in range(userInputRange + 1) :
                                for dX, dY in rings[iRing] :
                                        pPlot = map.plot(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                        if pPlot.isNone() : continue
                                        pPlot.setRevealed(iTeam, True, False, noTeam)

        if userInputStart :
                for iTeam in teamList :
                        for iPlayer in playerList :
                                if gc.getPlayer(iPlayer).getTeam() == iTeam : continue
                                for dX, dY in cityRings :
                                        pPlot = map.plot(startX[iPlayer] + dX, startY[iPlayer] + dY)
                                        if pPlot.isNone() : continue
                                        pPlot.setRevealed(iTeam, True, False, noTeam)

                for iPlayer in playerHUList :
                        iTeam = gc.getPlayer(iPlayer).getTeam()
                        for iLoopPlayer in playerList :
                                if gc.getPlayer(iLoopPlayer).getTeam() == iTeam : continue
                                CyEngine().addSign(map.plot(startX[iLoopPlayer],startY[iLoopPlayer]), iPlayer, "Start Plot")

        if userInputSea or userInputLand :
                for iX in range(iW) :
                        for iY in range(iH) :
                                pPlot = map.plot(iX, iY)
                                bWater = pPlot.isWater()
                                if (bWater and userInputSea) or ((not bWater) and userInputLand) :
                                        for iTeam in teamList :
                                                pPlot.setRevealed(iTeam, True, False, noTeam)

def addGold():
        userInputGold = getRandSel(selGen["game"]["gold"]["gold"], False)
        userInputPlayers = selGen["game"]["gold"]["goldplayers"]

        writeLog("", False, ["", " gold : added : %r" %userInputGold])
        writeLog("", False, [" gold : apply players : %r" %userInputPlayers])

        if userInputGold != 0 :
                if 0 in userInputPlayers :
                        for iPlayer in playerHUList :
                                gc.getPlayer(iPlayer).changeGold(userInputGold)
                if 1 in userInputPlayers :
                        for iPlayer in playerAIList :
                                gc.getPlayer(iPlayer).changeGold(userInputGold)

# the list of plots per area ... got some problems with areas sometimes so ...
def getAreaPlots():
        waterPlots = []
        landPlots = []
        areaPlots = { "water" : [], "land" : [] }
        listPlots = []
        rings = generateRings(1)
        ring = { True : [(-1, 0), (0, 1), (0, -1), (1, 0)], False : rings[1] }
        for iX in range(iW) : listPlots += [(iX, iY) for iY in range(iH)]
        areaTp = []
        toCheck = []
        while True :
                if areaTp == [] :
                        if listPlots == [] : break
                        fPlot = copy.copy(listPlots[0])
                        areaTp = []
                        toCheck = [fPlot]
                        bWater = bool(map.plot(fPlot[0], fPlot[1]).isWater())
                        del listPlots[0]

                toCheckNext = []
                areaTp += copy.copy(toCheck)
                for iX, iY in toCheck :
                        for dX, dY in ring[bWater] :
                                wTP = toWrap(iX + dX, iY + dY)
                                if wTP != -1 :
                                        if wTP in areaTp : continue
                                        if wTP in toCheck : continue
                                        if wTP in toCheckNext : continue
                                        if (map.plot(wTP[0], wTP[1]).isWater() != bWater) : continue
                                        toCheckNext.append(wTP)
                                        listPlots.remove(wTP)

                if toCheckNext == [] :
                        if bWater : areaPlots["water"].append(copy.copy(areaTp))
                        else : areaPlots["land"].append(copy.copy(areaTp))
                        areaTp = []
                        continue

                toCheck = copy.copy(toCheckNext)

        return areaPlots

def getListPlotsPerArea(cPlot, areaDict):
        for sId in ["water", "land"] :
                for lList in areaDict[sId] :
                        if cPlot in lList : return lList
        return []

def getOceanMinSize() :
        sizeMin = gc.getDefineINT("LAKE_MAX_AREA_SIZE") + 1
        for iBuilding in range(gc.getNumBuildingInfos()) :
                buildingXML = gc.getBuildingInfo(iBuilding)
                if buildingXML.isWater() :
                        size = buildingXML.getMinAreaSize()
                        if size > sizeMin : sizeMin = int(size)
        for iUnit in range(gc.getNumUnitInfos()) :
                unitXML = gc.getUnitInfo(iUnit)
                if unitXML.getDomainType() == DomainTypes.DOMAIN_SEA :
                        size = unitXML.getMinAreaSize()
                        if size > sizeMin : sizeMin = int(size)
        return sizeMin

def shuffleList(lList):
        if len(lList) <= 1 : return lList
        newList = []
        while True :
                if len(lList) == 1 :
                        newList.append(lList[0])
                        break
                iChoice = getRandNum(len(lList), " FoR : shuffle list Rand")
                newList.append(lList[iChoice])
                del lList[iChoice]
        return newList

def calculateAirDistance((x1, y1), (x2, y2)):
        distTP = iW*iH
        for w in range(-1, 2) :
                for h in range(-1, 2) :
                        dx1 = x1 + w*iW
                        dy1 = y1 + h*iH
                        if toWrap(dx1, dy1) == -1 : continue
                        loopDist = sqrt((dx1 - x2)**2 + (dy1 - y2)**2)
                        if loopDist < distTP : distTP = loopDist
        return distTP

def genNatureRes():
	natResGen = []
	for iBonus in range(gc.getNumBonusInfos()) :
                bonusXML = gc.getBonusInfo(iBonus)
                bonusHealth = bonusXML.getHealth()
                bonusHappiness = bonusXML.getHappiness()
                bWater = False
                bLand = False
                if bonusXML.getPlacementOrder() < 0 :
                        natResGen.append([-1, bLand, bWater])
                        continue
                for iTerrain in range(gc.getNumTerrainInfos()) :
                        if bonusXML.isTerrain(iTerrain) or bonusXML.isFeatureTerrain(iTerrain):
                                if gc.getTerrainInfo(iTerrain).isWater() : bWater = True
                                else : bLand = True
                if bonusHealth > 0 : natResGen.append([1, bLand, bWater])
                elif bonusHappiness > 0 : natResGen.append([2, bLand, bWater])
                elif bWater or bLand : natResGen.append([0, bLand, bWater])
                else :
                        natResGen.append([-1, bLand, bWater])
                        writeLog("", False, ["", " genNatureRes : failed to find nature for ressources : %s" %(bonusXML.getType(), ), ""])
        return natResGen

def initCustomMapOption():
        global cmo
        cmo = []
        try :
                for sKey in sortKeys(selGen, "maps", idMap) :
                        if sKey in ["selected", "waterper", "wrap", "start", "lakesize", "startterra", "border"] : continue
                        cmo.append(getRandSel(selGen["maps"][idMap][sKey]))

                writeLog("", False, ["", " initCustomMapOption , selgen : %r, cmo : %r" %([" %s : %r" %(sKey, selGen["maps"][idMap][sKey]) for sKey in sortKeys(selGen, "maps", idMap)], cmo)])
        except :
                writeError()

def initWrap():
        global wrapX
        global wrapY

        if idMap == "tectonics" :
                wrapX = True
                if cmo[0] == 5 : wrapX = False
                wrapY = False
        else :
                iWrap = getRandSel(selGen["maps"][idMap]["wrap"])
                wrapX = False
                if iWrap in [1, 2] : wrapX = True
                wrapY = False
                if iWrap == 2 : wrapY = True

        logList = []
        logList.append(" wrapX : %r" %wrapX)
        logList.append(" wrapY : %r" %wrapY)
        logList.append("")
        writeLog("", False, logList)

def initGenerationGlobals():
        global gc
        global isNetMP
        global isGameMP
        global isPbemOrHseat
        global map
        global game
        global dice
        global isBarb
        global canUseGameOptions

	gc = CyGlobalContext()
	map = CyMap()
	game = CyGame()
        isNetMP = game.isNetworkMultiPlayer()
        isGameMP = game.isGameMultiPlayer()
        isPbemOrHseat = bool(game.isPbem() or game.isHotSeat())
        dice = game.getMapRand()

        initMOD()
        initXMLLists(True)
        initCanUseGameOptions()
        initDefaultSelection()
        initValueLimits()
        initPlayerList()

        noBarbOption = gc.getInfoTypeForString("GAMEOPTION_NO_BARBARIANS")
        lockModifiedAssetsOption = gc.getInfoTypeForString("GAMEOPTION_LOCK_MODS")

        isBarb = True
        if noBarbOption != -1 :
                if game.isOption(noBarbOption) : isBarb = False

        logList = []
        if lockModifiedAssetsOption != -1 :
                if game.isOption(lockModifiedAssetsOption) :
                        if canUseGameOptions :
                                popup = PyPopup.PyPopup()
                                popup.setHeaderString(getUText("Warning !"))
                                popup.setBodyString(getUText("You have selected the option 'Lock Modified Assets'. So none of the game options can be applied."))
                                popup.launch()
                                logList.append(" the game locks modified assets : canUseGameOptions turn to False")
                                canUseGameOptions = False

        logList.append(" running Warlords : %r" %Wrds)
        logList.append(" running BtS : %r" %BtS)
        logList.append(" canUseGameOptions : %r" %canUseGameOptions)
        logList.append(" isNetMP : %r" %isNetMP)
        logList.append(" isGameMP : %r" %isGameMP)
        logList.append(" isPbemOrHseat : %r" %isPbemOrHseat)
        logList.append(" isBarb : %r" %isBarb)
        logList.append(" active player : %d" %int(CyGame().getActivePlayer()))
        logList.append("")
        writeLog("", False, logList)

def initPlayerList(bStartPlot = False):
        global playerList
        global playerHUList
        global playerAIList
        global teamList
        global teamHUList
        global teamAIList
        global startPlots
        global startX
        global startY
        global nbPlayer

        playerList = []
        playerHUList = []
        playerAIList = []
        startPlots = {}
        startX = {}
        startY = {}
        for iPlayer in range(gc.getMAX_PLAYERS()):
                pPlayer = gc.getPlayer(iPlayer)
                if pPlayer.isEverAlive() and (iPlayer != gc.getBARBARIAN_PLAYER()):
                        if bStartPlot :
                                startPlot = pPlayer.getStartingPlot()
                                if startPlot.isNone() : continue
                                staX = startPlot.getX()
                                staY = startPlot.getY()
                                if (staX, staY) == (-1, -1) : continue
                                startPlots[iPlayer] = (staX, staY)
                                startX[iPlayer] = staX
                                startY[iPlayer] = staY
                        playerList.append(iPlayer)
                        if pPlayer.isHuman():
                                playerHUList.append(iPlayer)
                        else :
                                playerAIList.append(iPlayer)

        nbPlayer = len(playerList)

        teamList = list(set([gc.getPlayer(iPlayer).getTeam() for iPlayer in playerList]))
        teamHUList = list(set([gc.getPlayer(iPlayer).getTeam() for iPlayer in playerHUList]))
        teamAIList = [iTeam for iTeam in teamList if not iTeam in teamHUList]

        logList = []
        logList.append(" playerList : %r" %playerList)
        logList.append(" playerHUList : %r" %playerHUList)
        logList.append(" playerAIList : %r" %playerAIList)
        logList.append(" teamList : %r" %teamList)
        logList.append(" teamHUList : %r" %teamHUList)
        logList.append(" teamAIList : %r" %teamAIList)
        if bStartPlot :
                logList.append(" startPlots : %r" %startPlots)
                logList.append(" startX : %r" %startX)
                logList.append(" startY : %r" %startY)
        logList.append(" nbPlayer : %r" %nbPlayer)
        logList.append("")
        writeLog("", False, logList)

def initBeforeGenerationGlobals():
        global iW
        global iH

	iW = map.getGridWidth()
	iH = map.getGridHeight()

        logList = []
        logList.append(" iW : %r" %iW)
        logList.append(" iH : %r" %iH)
        logList.append("")
        writeLog("", False, logList)

def getRandSel(lList, sel = True, valType = "int"):
        try :
                if sel :
                        if len(lList) == 1 : return lList[0]
                        iRand = getRandNum(len(lList), "FoR : getRandomSelection sel")
                        return lList[iRand]
                elif valType == "int" :
                        if len(lList) == 1 : return lList[0]
                        minVal, maxVal = lList
                        val = minVal + getRandNum(maxVal-minVal+1, "FoR : getRandomSelection range int")
                        return val
                else :
                        if len(lList) == 1 : return lList[0]
                        minVal, maxVal = lList
                        iRand = getRandNum(10000, "FoR : getRandomSelection range float")
                        val = minVal + (iRand/9999.0)*(maxVal-minVal)
                        return val
        except :
                writeLog("", False, ["", " getRandomSelection entries : %r, %r, %r" %(lList, sel, valType)])
                writeError()
                return -1

def getRandNum(iLen, sLog):
        return dice.get(iLen, sLog)

def toWrap(x, y):
        if wrapX : x = x%iW
        if wrapY : y = y%iH
        if x < 0 : return -1
        if x >= iW : return -1
        if y < 0 : return -1
        if y >= iH : return -1
        return (x,y)

def generateRings(dist):
        tuppleTemp = [[] for i in range(dist+1)]
        for i in range(-1*dist, dist+1) :
                for j in range(-1*dist, dist+1) :
                        k = int(round(sqrt(i**2 + j**2)))
                        if k <= dist :
                                tuppleTemp[k].append((i,j))
        result = []
        for i in range(dist+1) :
                result.append(tuple(tuppleTemp[i]))
        resultat = tuple(result)
        return resultat

def sortList(lList, iKey):
        if (sys.platform == 'darwin') :
                def cmpi(x,y):
                        return cmp(x[iKey], y[iKey])
                lList.sort(cmpi)
        else :
                lList = sorted(lList, key = operator.itemgetter(iKey))
        return lList

# list of sets of p elements into a list of n element
def Cnp(n, p, l = None, res = None):
        if l is None: l = []
        if res is None: res = []
        if p == 0 :
            res.append(l)
            return 
        if n == 0 : return  
        l1 = list(l)
        l1.append(n - 1)
        Cnp(n - 1, p - 1, l1, res)
        Cnp(n - 1, p, l, res)
        return res

##!_!## globals set up
def initMOD():
        global modName
        global modXMLPath
        global modPath
        global modModularPath
        global XMLCustomAssetsPath
        modName = "None"
        modXMLPath = ""
        modPath = ""
        modModularPath = ""
        XMLCustomAssetsPath = ""

        try :
                #try to parse the different folders of civ to check XML types.
                #i will guess that the MOD has at least one unique type in this list to recognize it if i can't get the mod with replay info.
                #this is just to recognize a mod and enable a default implementation for it or for the load/save name.
                #if this is not enough for one MOD ,will add some others requirements.
                #MODs to recognize : _ BtS_FFH2
                XMLInfosMap = getXMLInfosMap()

                writeLog("initMOD", False, [" init Folder paths :", ""])

                docPath = ""
                civPath = os.getcwd()

                # try to set doc path
                try :
                        basePath = civFilePath()
                        if basePath != "" :
                                if (sys.platform == 'darwin'):
                                        civFolder = "Civilization IV"
                                        if Wrds:
                                                civFolder = "Civilization IV Warlords"
                                        if BtS:
                                                civFolder = "Civilization IV Beyond the Sword"
                                        docPath = os.path.join(basePath, civFolder)
                                else:
                                        userFolder = regRead(_winreg.HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders","Personal")
                                        civFolder = os.path.basename(regRead(_winreg.HKEY_LOCAL_MACHINE,"Software\\Firaxis Games\\Sid Meier's Civilization 4","INSTALLDIR"))
                                        if Wrds:
                                                civFolder = "Warlords"
                                        if BtS:
                                                civFolder = "Beyond the Sword"
                                        docPath = os.path.join(basePath, civFolder)
                                if not os.path.isdir(docPath) :
                                        writeLog("", False, [" %r is not an already existing folder" %docPath])
                                        docPath = ""
                                else :
                                        writeLog("", False, [" %r is recognized" %docPath])
                        else :
                                writeLog("", False, [" civFilePath does not return the document path"])
                except :
                        writeLog("", False, [" cannot set doc path"])
                        writeError()

                #check xml custom assets folder
                XMLCustomAssetsFolder = ""
                if docPath != "" :
                        XMLCustomAssetsFolder = os.path.join(docPath, "CustomAssets", "xml")
                        if not os.path.isdir(XMLCustomAssetsFolder) :
                                writeLog("", False, ["", " cannot set XMLCustomAssetsFolder"])
                                XMLCustomAssetsFolder = ""
                        else :
                                writeLog("", False, ["", " XMLCustomAssetsFolder : %r" %XMLCustomAssetsFolder])

                #make the list of MODS and store path infos
                modsInfo = {}
                modsLocPathList = []
                if docPath != "" :
                        docMODFolder = os.path.join(docPath, "MODS")
                        if os.path.isdir(docMODFolder) :
                                modsLocPathList.append(docMODFolder)
                        else :
                                writeLog("", False, ["", " docMODListPath : cannot set MODS folder"])

                MODFolder = os.path.join(civPath, "Mods")
                if os.path.isdir(MODFolder) :
                        modsLocPathList.append(MODFolder)
                else :
                        writeLog("", False, ["", " MODListPath : cannot set Mods folder"])

                for MODFolderLoop in modsLocPathList :
                        for item in os.listdir(MODFolderLoop) :
                                modPathTP = os.path.join(MODFolderLoop, item)
                                if os.path.isdir(modPathTP) :
                                        modINIFile = os.path.join(modPathTP, "%s.ini" %item)
                                        if os.path.isfile(modINIFile) :
                                                iPublicMaps = parseINIFile(modINIFile, "AllowPublicMaps")
                                                if iPublicMaps != 0 :
                                                        modsInfo[item] = {}
                                                        modsInfo[item]["modPath"] = modPathTP

                                                        modsInfo[item]["modXMLPath"] = ""
                                                        xmlFolder = os.path.join(modPathTP, "Assets", "XML")
                                                        if os.path.isdir(xmlFolder) :
                                                                modsInfo[item]["modXMLPath"] = xmlFolder

                                                        modsInfo[item]["isCustomAssets"] = True
                                                        iCustomAssets = parseINIFile(modINIFile, "NoCustomAssets")
                                                        if iCustomAssets == 1 :
                                                                modsInfo[item]["isCustomAssets"] = False

                                                        modsInfo[item]["modModulesPath"] = ""
                                                        iModular = parseINIFile(modINIFile, "ModularLoading")
                                                        if iModular == 1 :
                                                                modulesFolder = os.path.join(modPathTP, "Assets", "Modules")
                                                                if os.path.isdir(modulesFolder) :
                                                                        modsInfo[item]["modModulesPath"] = modulesFolder

                logList = [""]
                for item in modsInfo.keys() :
                        logList.append(" mod : %r" %item)
                        logList.append(" modPath        : %r" %modsInfo[item]["modPath"])
                        logList.append(" modXMLPath     : %r" %modsInfo[item]["modXMLPath"])
                        logList.append(" modModulesPath : %r" %modsInfo[item]["modModulesPath"])
                        logList.append(" CustomAssets   : %r" %modsInfo[item]["isCustomAssets"])
                        logList.append("")
                logList.append("")
                writeLog("", False, logList)

                # create a dummy replay info to get the mod name ... don't work with pbem and hotseat games .
                # looking at the SDK this should do not cause problems with other games .tested in sg game and directIP mp game .
                if not isPbemOrHseat :
                        replayInfo = CyReplayInfo()
                        iActivePlayer = CyGame().getActivePlayer()

                        if iActivePlayer != -1 : CyGame().setActivePlayer(-1, False)
                        replayInfo.createInfo(-1)
                        if iActivePlayer != -1 : CyGame().setActivePlayer(iActivePlayer, False)

                        modNameFull = replayInfo.getModName()

                        if modNameFull != "" :
                                if (sys.platform == 'darwin'):
                                        listPaths = [item for item in modNameFull.split("\\") if item != ""]
                                        modNameTP = listPaths[-1]
                                else :
                                        head, modNameTP = os.path.split(os.path.normpath(modNameFull))
                                if modNameTP in modsInfo.keys() :
                                        modName = modNameTP
                                        modXMLPath = modsInfo[modName]["modXMLPath"]
                                        modPath = modsInfo[modName]["modPath"]
                                        modModularPath = modsInfo[modName]["modModulesPath"]
                                        if modsInfo[modName]["isCustomAssets"] : XMLCustomAssetsPath = XMLCustomAssetsFolder
                                        writeLog("", True, ["", " MOD name recognized : %s" %modName])
                                else :
                                        writeLog("", True, ["", " MOD name not recognized ... no MOD name will be taken in count"])
                        else :
                                writeLog("", True, ["", " Running default civilisation : modName None"])
                        recognizeMOD()
                        return

                writeLog("", False, ["", " the game isPbem Or Hotseat . will try to recognize the MOD with the xml values ...", ""])
                # make the list of path for civ versions
                defaultXMLFolders = []
                if BtS :
                        xmlFolder = os.path.join(civPath, "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                        else :
                                writeLog("", False, [" BtS : cannot set BtS XML folder ..."])

                        head, tail = os.path.split(civPath)

                        xmlFolder = os.path.join(head, "Warlords", "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                        else :
                                writeLog("", False, [" BtS : cannot set Warlords XML folder ..."])
                        
                        xmlFolder = os.path.join(head, "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                        else :
                                writeLog("", False, [" BtS : cannot set Vanilla XML folder ..."])

                        if len(defaultXMLFolders) == 3 : writeLog("", False, [" BtS : All default XML folders set"])
                        
                elif Wrds :
                        xmlFolder = os.path.join(civPath, "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                        else :
                                writeLog("", False, [" Warlords : cannot set Warlords XML folder ..."])

                        head, tail = os.path.split(civPath)

                        xmlFolder = os.path.join(head, "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                        else :
                                writeLog("", False, [" Warlords : cannot set Vanilla XML folder ..."])

                        if len(defaultXMLFolders) == 2 : writeLog("", False, [" Warlords : All default XML folders set"])
                        
                else :
                        xmlFolder = os.path.join(civPath, "Assets", "XML")
                        if os.path.isdir(xmlFolder) :
                                defaultXMLFolders.append(xmlFolder)
                                writeLog("", False, [" Vanilla : default XML folder set"])
                        else :
                                writeLog("", False, [" Vanilla : cannot set XML folder ..."])

                writeLog("", False, ["", " Begin XML Mod recognizance :", ""])

                modList = [item for item in modsInfo.keys()]
                bMod = False
                for info in XMLInfosMap.keys() :
                        writeLog("", False, ["", " Check info : %s" %info, ""])

                        elementList = [getSText(XMLInfosMap[info]["GET"](i).getType()) for i in range(XMLInfosMap[info]["NUM"]())]
                        elementList.sort()

                        xmlDir = XMLInfosMap[info]["DIR"]
                        xmlFile = XMLInfosMap[info]["FILE"]

                        parsedElementDict = {}
                        bDefaultElementList = False

                        #first check if the list of elements is default
                        for pathDef in defaultXMLFolders :
                                pathTP = os.path.join(pathDef, xmlDir, xmlFile)
                                if os.path.isfile(pathTP) :
                                        parsedElementDict = parseXMLFile(pathTP)
                                        break

                        parsedElementList = parsedElementDict.keys()
                        parsedElementList.sort()
                        if elementList == parsedElementList :
                                bDefaultElementList = True
                                writeLog("", False, [" default settings for %s" %info, ""])
                        else :
                                writeLog("", False, [" not default settings for %s ... continue" %info])

                        #check if the file is defined is the custom folder
                        if XMLCustomAssetsFolder != "" :
                                pathTP = os.path.join(XMLCustomAssetsFolder, xmlDir, xmlFile)
                                if os.path.isfile(pathTP) :
                                        parsedElementDict = parseXMLFile(pathTP)
                                        parsedElementList = parsedElementDict.keys()
                                        parsedElementList.sort()

                                        if elementList == parsedElementList :
                                                bDefaultElementList = True
                                                writeLog("", False, [" custom assets settings for %s" %info, ""])
                                        else :
                                                writeLog("", False, [" not custom assets settings for %s ... continue" %info])
                                else :
                                        writeLog("", False, [" no file in custom assets for %s ... continue" %info])

                        writeLog("", False, ["", " checking mods for %s :" %info, ""])

                        if not bDefaultElementList : bMod = True

                        # search the mods xml files to compare
                        for modNameTP in [item for item in modList] :
                                xmlFolder = modsInfo[modNameTP]["modXMLPath"]
                                if xmlFolder == "" : #this mod do not have a xml folder so can't check it
                                        modList.remove(modNameTP)
                                        continue
                                pathTP = os.path.join(xmlFolder, xmlDir, xmlFile)
                                if os.path.isfile(pathTP) :
                                        CAPath = ""
                                        if modsInfo[modNameTP]["isCustomAssets"] : CAPath = XMLCustomAssetsFolder

                                        parsedElementDict = getXMLValues(info, "", "", CAPath, xmlFolder, modsInfo[modNameTP]["modModulesPath"])
                                        parsedElementList = parsedElementDict.keys()
                                        parsedElementList.sort()

                                        if elementList == parsedElementList :
                                                writeLog("", False, [" mod %s settings for %s" %(modNameTP, info)])
                                        else :
                                                writeLog("", False, [" not mod %s settings for %s ... continue" %(modNameTP, info)])
                                                modList.remove(modNameTP)
                                else :
                                        writeLog("", False, [" no file in mod %s assets for %s ... continue" %(modNameTP, info)])
                                        if not bDefaultElementList : modList.remove(modNameTP)

                        writeLog("", False, [""])

                if bMod :
                        if len(modList) == 1 :
                                modName = modList[0]
                                modXMLPath = modsInfo[modName]["modXMLPath"]
                                modPath = modsInfo[modName]["modPath"]
                                if modsInfo[modName]["isCustomAssets"] : XMLCustomAssetsPath = XMLCustomAssetsFolder
                                modModularPath = modsInfo[modName]["modModulesPath"]
                                writeLog("", True, ["", " MOD name recognized with xml : %s" %modName])
                        elif len(modList) > 1 :
                                writeLog("", True, ["", " multiple mods match xml files , mod not chosen : %r" %modList])
                        else :
                                writeLog("", True, ["", " mod not found ..."])
                else :
                        writeLog("", True, ["", " default xml type for all checked ... mod not chosen"])

        except :
                writeLog("", False, ["", " error during initMOD() : launch recognize mod to initialize vars", ""])
                writeError()

        recognizeMOD()

def recognizeMOD() :
        global is_BtS_FFH2

        is_BtS_FFH2 = False
        if BtS and "Fall from Heaven 2" in modName : is_BtS_FFH2 = True
        writeLog("", False, ["", " recognizeMOD : running BtS FFH2 : %r" %is_BtS_FFH2, ""])
        
def getXMLInfosMap():
        XMLInfoTemp = {	"bonus": {"NUM": gc.getNumBonusInfos, "GET": gc.getBonusInfo, "DIR": "Terrain", "FILE": "CIV4BonusInfos.xml"},
                        "improvement": {"NUM": gc.getNumImprovementInfos, "GET": gc.getImprovementInfo, "DIR": "Terrain", "FILE": "CIV4ImprovementInfos.xml"},
                        "feature" : {"NUM": gc.getNumFeatureInfos, "GET": gc.getFeatureInfo, "DIR": "Terrain", "FILE": "CIV4FeatureInfos.xml"},
                        "terrain": {"NUM": gc.getNumTerrainInfos, "GET": gc.getTerrainInfo, "DIR": "Terrain", "FILE": "CIV4TerrainInfos.xml"},
                        "religion": {"NUM": gc.getNumReligionInfos, "GET": gc.getReligionInfo, "DIR": "GameInfo", "FILE": "CIV4ReligionInfo.xml"},
                        "civic": {"NUM": gc.getNumCivicInfos, "GET": gc.getCivicInfo, "DIR": "GameInfo", "FILE": "CIV4CivicInfos.xml"},
                        "tech": {"NUM": gc.getNumTechInfos, "GET": gc.getTechInfo, "DIR": "Technologies", "FILE": "CIV4TechInfos.xml"},
                        "building": {"NUM": gc.getNumBuildingInfos, "GET": gc.getBuildingInfo, "DIR": "Buildings", "FILE": "CIV4BuildingInfos.xml"},
                        "civilization": {"NUM": gc.getNumCivilizationInfos, "GET": gc.getCivilizationInfo, "DIR": "Civilizations", "FILE": "CIV4CivilizationInfos.xml"},
                        "leader": {"NUM": gc.getNumLeaderHeadInfos, "GET": gc.getLeaderHeadInfo, "DIR": "Civilizations", "FILE": "CIV4LeaderHeadInfos.xml"},
                        "trait": {"NUM": gc.getNumTraitInfos, "GET": gc.getTraitInfo, "DIR": "Civilizations", "FILE": "CIV4TraitInfos.xml"},
                        "unit": {"NUM": gc.getNumUnitInfos, "GET": gc.getUnitInfo, "DIR": "Units", "FILE": "CIV4UnitInfos.xml"},
                        "promotion": {"NUM":gc.getNumPromotionInfos, "GET": gc.getPromotionInfo, "DIR": "Units", "FILE": "CIV4PromotionInfos.xml"} ,
                        "world": {"NUM":gc.getNumWorldInfos, "GET": gc.getWorldInfo, "DIR": "GameInfo", "FILE": "CIV4WorldInfo.xml"}
                        }
        return XMLInfoTemp

def parseINIFile(filePath, sTag):
        try :
                Sfile = open(filePath, "r")
                lLinesFile = Sfile.readlines()
                Sfile.close()
                for item in lLinesFile :
                        if item[0:len(sTag)] == sTag :
                                if "1" in item[len(sTag):] : return 1
                                elif "0" in item[len(sTag):] : return 0
                                else : return -1
        except :
                writeLog("", False, [" parseINIFile : %r , %s" %(filePath, sTag)])
                writeError()
        return -1

def getXMLValues(XMLinfo, sTagBegin, sTagEnd, XMLCAPath = -1, MXMLPath = -1, MMPath = -1):
        rDict = {}
        try :
                XMLInfosMap = getXMLInfosMap()
                xmlDir = XMLInfosMap[XMLinfo]["DIR"]
                xmlFile = XMLInfosMap[XMLinfo]["FILE"]

                if XMLCAPath == -1 : XMLCAPath = XMLCustomAssetsPath
                if MXMLPath == -1 : MXMLPath = modXMLPath
                if MMPath == -1 : MMPath = modModularPath

                if XMLCAPath != "" :
                        pathTP = os.path.join(XMLCAPath, xmlDir, xmlFile)
                        if os.path.isfile(pathTP) :
                                rDict = parseXMLFile(pathTP, sTagBegin, sTagEnd)
                                writeLog("", False, [" getXMLValues : use custom assets file (%s , %r , %r, %r, %r, %r)" %(XMLinfo, sTagBegin, sTagEnd, XMLCAPath, MXMLPath, MMPath)])

                if (MXMLPath != "") and (rDict == {}) :
                        pathTP = os.path.join(MXMLPath, xmlDir, xmlFile)
                        if os.path.isfile(pathTP) :
                                rDict = parseXMLFile(pathTP, sTagBegin, sTagEnd)
                                writeLog("", False, [" getXMLValues : use mod xml file (%s , %r , %r, %r, %r, %r)" %(XMLinfo, sTagBegin, sTagEnd, XMLCAPath, MXMLPath, MMPath)])

                if MMPath != "" :
                        writeLog("", False, [" getXMLValues : use modular search (%s , %r , %r, %r, %r, %r)" %(XMLinfo, sTagBegin, sTagEnd, XMLCAPath, MXMLPath, MMPath)])
                        def loopOverFiles(basePath):
                                listDir = [ folder for folder in os.listdir(basePath) if os.path.isdir(os.path.join(basePath, folder)) ]
                                listDir = [ getSText(folder) for folder in listDir ]
                                listDir.sort()
                                for folder in listDir :
                                        loopOverFiles(os.path.join(basePath, folder))
                                listFiles = [ files for files in os.listdir(basePath) if os.path.isfile(os.path.join(basePath, files)) ]
                                listFiles = [ getSText(files) for files in listFiles ]
                                listFiles.sort()
                                for files in listFiles :
                                        if not xmlFile in files : continue
                                        rResTemp = parseXMLFile(os.path.join(basePath, files), sTagBegin, sTagEnd)
                                        for item in rResTemp.keys() :
                                                rDict[item] = copy.copy(rResTemp[item])
                        loopOverFiles(MMPath)
        except :
                writeLog("", False, [" getXMLValues ERROR : %s , %r , %r, %r, %r, %r" %(XMLinfo, sTagBegin, sTagEnd, XMLCAPath, MXMLPath, MMPath)])
                writeError()
        return rDict

def parseXMLFile(filePath, sTagBegin="", sTagEnd=""):
        result = {}
        try :
                Sfile = open(filePath, "r")
                sTextFile = Sfile.read()
                Sfile.close()
                textList = sTextFile.split("<Type>")[1:]
                for item in textList :
                        elementType = item[0:item.index("</Type>")]
                        if sTagBegin == "" :
                                result[elementType] = ""
                        else :
                                if sTagBegin in item :
                                        itemTp = item.split(sTagBegin)[1]
                                        elementValue = itemTp[0:itemTp.index(sTagEnd)]
                                        result[elementType] = elementValue
                                else :
                                        result[elementType] = ""
        except :
                writeLog("", False, [" parseXMLFile ERROR : %r , %s , %s" %(filePath, sTagBegin, sTagEnd)])
                writeError()
        return result

def initXMLLists(bForce = False):
        global XMLEntriesList
        global parsedXMLValuesEntries

        # make the list of xml values for resources , units , tech , etc ...
        if (XMLEntriesList != {}) and (not bForce) : return

        parsedXMLValuesEntries = {}

        # resources lists
        XMLEntriesList["list"] = []
        XMLEntriesList["reslist"] = []
        XMLEntriesList["groupreslist"] = []
        XMLEntriesList["strategic"] = []
        XMLEntriesList["health"] = []
        XMLEntriesList["happiness"] = []
        XMLEntriesList["land"] = []
        XMLEntriesList["water"] = []

        barbarianCivXML = gc.getCivilizationInfo( gc.getInfoTypeForString("CIVILIZATION_BARBARIAN") )

	for iBonus in range(gc.getNumBonusInfos()) :
                bonusXML = gc.getBonusInfo(iBonus)

                if bonusXML.getPlacementOrder()<0 : continue # don't take in count the resources not placed during map generation

                # check if the bonus is placed with a standart method
                if (bonusXML.getConstAppearance()<=0) and (bonusXML.getRandAppearance1()<=0) and (bonusXML.getRandAppearance2()<=0) and (bonusXML.getRandAppearance3()<=0) and (bonusXML.getRandAppearance4()<=0) : continue
                if (bonusXML.getTilesPer()<=0) and (bonusXML.getPercentPerPlayer()<=0) : continue

                bonusType = getSText(bonusXML.getType())

                bLand = False
                bWater = False
                for iTerrain in range(gc.getNumTerrainInfos()):
                        if bonusXML.isTerrain(iTerrain) or bonusXML.isFeatureTerrain(iTerrain):
                                if gc.getTerrainInfo(iTerrain).isWater() : bWater = True
                                else : bLand = True

                if (not bLand) and (not bWater) : continue # don't know where to place this bonus
                if bLand : XMLEntriesList["land"].append(str(bonusType))
                if bWater : XMLEntriesList["water"].append(str(bonusType))

                XMLEntriesList["reslist"].append(str(bonusType))
                XMLEntriesList["list"].append(str(bonusType))

                uniqueBonus = bonusXML.getUniqueRange()
                groupRangeBonus = bonusXML.getGroupRange()

                if (uniqueBonus == 0) and (groupRangeBonus > 0) : XMLEntriesList["groupreslist"].append(str(bonusType))

                healthBonus = bonusXML.getHealth()
                happinessBonus = bonusXML.getHappiness()

                if happinessBonus > 0 : XMLEntriesList["happiness"].append(str(bonusType)) # if a bonus is health and happiness , it count as a happiness bonus
                elif healthBonus > 0 : XMLEntriesList["health"].append(str(bonusType))
                else : XMLEntriesList["strategic"].append(str(bonusType)) # every no health , no happiness bonus is considered as a strategic bonus

        # building lists
        XMLEntriesList["buildingsbarb"] = []

        for iBuildingClass in range(gc.getNumBuildingClassInfos()) :
                buildingClassXML = gc.getBuildingClassInfo(iBuildingClass)

                if buildingClassXML.getMaxGlobalInstances() != -1 : continue
                if buildingClassXML.getMaxPlayerInstances() != -1 : continue

                iBuilding = barbarianCivXML.getCivilizationBuildings(iBuildingClass)

                if iBuilding == -1 : continue

                buildingXML = gc.getBuildingInfo(iBuilding)

                if buildingXML.getDefenseModifier() <= 0 : continue
                if buildingXML.getProductionCost() <= 0 : continue

                buildingType = getSText(buildingXML.getType())
                XMLEntriesList["list"].append(str(buildingType))
                XMLEntriesList["buildingsbarb"].append(str(buildingType))

        # tech lists
        XMLEntriesList["techslist"] = []
        XMLEntriesList["techsstartciv"] = []
        XMLEntriesList["techsrepeat"] = []

        for iTech in range(gc.getNumTechInfos()) :
                techXML = gc.getTechInfo(iTech)

                if techXML.isDisable() : continue
                if techXML.getResearchCost() <= 0 : continue # don't take in count the tech not granted by researsh

                bReligionFounding = False
                for iReligion in range(gc.getNumReligionInfos()) :
                        if gc.getReligionInfo(iReligion).getTechPrereq() == iTech :
                                bReligionFounding = True
                                break
                if bReligionFounding : continue # don't take in count the techs that grants some religions

                techType = getSText(techXML.getType())
                XMLEntriesList["list"].append(str(techType))
                XMLEntriesList["techslist"].append(str(techType))

                if techXML.isRepeat() : XMLEntriesList["techsrepeat"].append(str(techType))

                for iCiv in range(gc.getNumCivilizationInfos()) :
                        civXML = gc.getCivilizationInfo(iCiv)

                        if not civXML.isPlayable() : continue

                        if civXML.isCivilizationFreeTechs(iTech) :
                                XMLEntriesList["techsstartciv"].append(str(techType))
                                break

        # unit combat list
        XMLEntriesList["unitcombatlist"] = []

        for iCombat in range(gc.getNumUnitCombatInfos()) :
                combatXML = gc.getUnitCombatInfo(iCombat)

                combatType = getSText(combatXML.getType())
                XMLEntriesList["list"].append(str(combatType))
                XMLEntriesList["unitcombatlist"].append(str(combatType))

        # unit class list
        # unit lists
        XMLEntriesList["unitclasslist"] = []
        XMLEntriesList["units"] = {
                "list" : [] ,
                "barbdefender" : [] ,
                "barbfight" : [] ,
                "animland" : [] ,
                "peace" : [] , # just to sort national , world unit
                "peacedd" : [] , # peace dropdown
                "land" : [] ,
                "landdd" : [] ,
                "water" : [] ,
                "waterdd" : [] ,
                "air" : [] ,
                "airdd" : [] ,
                "other" : [] ,
                "otherdd" : [] ,
                "national" : [] ,
                "team" : [] ,
                "world" : [] ,
                "combatnone" : []
                }

        for sCombatType in XMLEntriesList["unitcombatlist"] : XMLEntriesList["units"][sCombatType] = []

        # for mods that use some type i don't wan't to appear in the list
        # FFH : SPECIALUNIT_SPELL
        specialUnitTypeToRemove = ["SPECIALUNIT_SPELL"]
        specialUnitTypeToRemove = [ gc.getInfoTypeForString(item) for item in specialUnitTypeToRemove ]
        specialUnitTypeToRemove = [ item for item in specialUnitTypeToRemove if item != -1]

        tempBarbList = []
        
        for iUnit in  range(gc.getNumUnitInfos()) :
                unitXML = gc.getUnitInfo(iUnit)

                if unitXML.getSpecialUnitType() in specialUnitTypeToRemove : continue

                if unitXML.isPrereqReligion() : continue
                if unitXML.getHolyCity() >= 0 : continue
                if unitXML.getPrereqReligion() >= 0 : continue
                if unitXML.getReligionType() >= 0 : continue
                if unitXML.getStateReligion() >= 0 : continue

                bSpreadReligion = False
                for iReligion in range(gc.getNumReligionInfos()) :
                        if unitXML.getReligionSpreads(iReligion) :
                                bSpreadReligion = True
                                break
                if bSpreadReligion : continue

                bRequiresReligionTech = False
                techPrereqList = []

                iBuildingRequ = unitXML.getPrereqBuilding()

                if iBuildingRequ != -1 :
                        buildingXML = gc.getBuildingInfo(iBuildingRequ)

                        if buildingXML.getHolyCity() >= 0 : continue
                        if buildingXML.getPrereqReligion() >= 0 : continue
                        if buildingXML.getReligionType() >= 0 : continue
                        if buildingXML.getStateReligion() >= 0 : continue

                        techPrereqList.append(buildingXML.getPrereqAndTech())
                        for i in range(gc.getDefineINT("NUM_BUILDING_AND_TECH_PREREQS")) : techPrereqList.append(buildingXML.getPrereqAndTechs(i))

                techPrereqList.append(unitXML.getPrereqAndTech())
                for i in range(gc.getDefineINT("NUM_UNIT_AND_TECH_PREREQS")) : techPrereqList.append(unitXML.getPrereqAndTechs(i))
                techPrereqList = [ item for item in techPrereqList if item != -1]

                for iReligion in range(gc.getNumReligionInfos()) :
                        if gc.getReligionInfo(iReligion).getTechPrereq() in techPrereqList :
                                bRequiresReligionTech = True
                                break

                if bRequiresReligionTech : continue

                iUnitClass = unitXML.getUnitClassType()
                unitClassXML = gc.getUnitClassInfo(iUnitClass)
                classType = getSText(unitClassXML.getType())
                if not classType in XMLEntriesList["unitclasslist"] :
                        XMLEntriesList["list"].append(str(classType))
                        XMLEntriesList["unitclasslist"].append(str(classType))

                unitType = getSText(unitXML.getType())
                XMLEntriesList["list"].append(str(unitType))
                XMLEntriesList["units"]["list"].append(str(unitType))

                unitDomain = unitXML.getDomainType()
                unitDefaultAI = unitXML.getDefaultUnitAIType()

                # domain list
                if unitDomain == DomainTypes.DOMAIN_LAND : XMLEntriesList["units"]["land"].append(str(unitType))
                elif unitDomain == DomainTypes.DOMAIN_SEA : XMLEntriesList["units"]["water"].append(str(unitType))
                elif unitDomain == DomainTypes.DOMAIN_AIR : XMLEntriesList["units"]["air"].append(str(unitType))
                else : XMLEntriesList["units"]["other"].append(str(unitType))

                # land animals
                if (unitXML.isAnimal()) and (unitDomain == DomainTypes.DOMAIN_LAND) : XMLEntriesList["units"]["animland"].append(str(unitType))

                # combat type
                iCombatType = unitXML.getUnitCombatType()
                if iCombatType == -1 :
                        XMLEntriesList["units"]["combatnone"].append(str(unitType))
                else :
                        unitCombatType = getSText(gc.getUnitCombatInfo(iCombatType).getType())
                        XMLEntriesList["units"][unitCombatType].append(str(unitType))

                # others
                bPeaceUnit = True
                if unitXML.isMilitaryHappiness() or unitXML.isMilitaryProduction() or unitXML.isMilitarySupport() or unitXML.isAnimal() : bPeaceUnit = False
                if unitDefaultAI in [UnitAITypes.UNITAI_WORKER, UnitAITypes.UNITAI_WORKER_SEA] : bPeaceUnit = True
                if unitXML.isFound() : bPeaceUnit = True

                if bPeaceUnit : XMLEntriesList["units"]["peace"].append(str(unitType))

                bLimited = False
                if unitClassXML.getMaxGlobalInstances() != -1 :
                        bLimited = True
                        XMLEntriesList["units"]["world"].append(str(unitType))
                if unitClassXML.getMaxPlayerInstances() != -1 :
                        bLimited = True
                        XMLEntriesList["units"]["national"].append(str(unitType))
                if unitClassXML.getMaxTeamInstances() != -1 :
                        bLimited = True
                        XMLEntriesList["units"]["team"].append(str(unitType))

                if not bLimited :
                        if bPeaceUnit : XMLEntriesList["units"]["peacedd"].append(str(unitType))
                        elif unitDomain == DomainTypes.DOMAIN_LAND : XMLEntriesList["units"]["landdd"].append(str(unitType))
                        elif unitDomain == DomainTypes.DOMAIN_SEA : XMLEntriesList["units"]["waterdd"].append(str(unitType))
                        elif unitDomain == DomainTypes.DOMAIN_AIR : XMLEntriesList["units"]["airdd"].append(str(unitType))
                        else : XMLEntriesList["units"]["otherdd"].append(str(unitType))

                        if (not bPeaceUnit) and (unitDomain == DomainTypes.DOMAIN_LAND) and (not unitXML.isAnimal()):
                                if barbarianCivXML.getCivilizationUnits(iUnitClass) == iUnit :
                                        if unitDefaultAI == UnitAITypes.UNITAI_CITY_DEFENSE :
                                                XMLEntriesList["units"]["barbdefender"].append(str(unitType))
                                        elif unitXML.getUnitAIType(UnitAITypes.UNITAI_CITY_DEFENSE) :
                                                XMLEntriesList["units"]["barbfight"].append(str(unitType))
                                        else :
                                                tempBarbList.append(str(unitType))

        if XMLEntriesList["units"]["barbdefender"] == [] :
                XMLEntriesList["units"]["barbdefender"] = copy.deepcopy(XMLEntriesList["units"]["barbfight"])
                XMLEntriesList["units"]["barbfight"] = copy.deepcopy(tempBarbList)

        if XMLEntriesList["units"]["barbfight"] == [] :
                XMLEntriesList["units"]["barbfight"] = copy.deepcopy(tempBarbList)

        if is_BtS_FFH2 :
                # lairs and unique improvements list for FfH 2
                XMLEntriesList["improvements"] = []
                XMLEntriesList["lairs"] = []
                XMLEntriesList["uniqueimprovements"] = []
                XMLEntriesList["bonusconvert"] = [] # description only
                XMLEntriesList["unitspawn"] = [] # decription only

                dictLairs = getXMLValues("improvement", "<iAppearanceProbability>", "</iAppearanceProbability>")
                dictUnitsSpawn = getXMLValues("improvement", "<SpawnUnitType>", "</SpawnUnitType>")
                dictBonuses = getXMLValues("improvement", "<BonusConvert>", "</BonusConvert>")
                for sType in dictLairs.keys() :
                        if gc.getInfoTypeForString(sType) == -1 :
                                writeLog("", False, [" XMLEntriesList ERROR, lairs : sType not recognized %r" %sType])
                                continue
                        if dictLairs[sType] == "" : continue

                        try :
                                iProb = int(dictLairs[sType])
                        except :
                                writeLog("", False, [" XMLEntriesList ERROR, lairs : prob can't be converted to int %r" %(dictLairs[sType], )])
                                continue

                        if iProb > 0 :
                                XMLEntriesList["improvements"].append(str(sType))
                                XMLEntriesList["lairs"].append(str(sType))
                                XMLEntriesList["list"].append(str(sType))
                                parsedXMLValuesEntries[sType] = {}
                                parsedXMLValuesEntries[sType]["iAppearanceProbability"] = int(iProb)
                                parsedXMLValuesEntries[sType]["SpawnUnitType"] = ""
                                parsedXMLValuesEntries[sType]["BonusConvert"] = ""
                                
                                if sType in dictUnitsSpawn.keys() :
                                        if dictUnitsSpawn[sType] == "" : pass
                                        if gc.getInfoTypeForString(dictUnitsSpawn[sType]) == -1 : pass
                                        else :
                                                if not dictUnitsSpawn[sType] in XMLEntriesList["list"] :
                                                        XMLEntriesList["list"].append(str(dictUnitsSpawn[sType]))
                                                        XMLEntriesList["unitspawn"].append(str(dictUnitsSpawn[sType]))

                                                parsedXMLValuesEntries[sType]["SpawnUnitType"] = copy.copy(dictUnitsSpawn[sType])

                                if sType in dictBonuses.keys() :
                                        if dictBonuses[sType] == "" : pass
                                        if gc.getInfoTypeForString(dictBonuses[sType]) == -1 : pass
                                        else :
                                                if not dictBonuses[sType] in XMLEntriesList["list"] :
                                                        XMLEntriesList["list"].append(str(dictBonuses[sType]))
                                                        XMLEntriesList["bonusconvert"].append(str(dictBonuses[sType]))

                                                parsedXMLValuesEntries[sType]["BonusConvert"] = copy.copy(dictBonuses[sType])

                dictUniques = getXMLValues("improvement", "<bUnique>", "</bUnique>")
                for sType in dictUniques.keys() :
                        if gc.getInfoTypeForString(sType) == -1 :
                                writeLog("", False, [" XMLEntriesList ERROR, uniqueimprovements : sType not recognized %r" %sType])
                                continue
                        if dictUniques[sType] == "" : continue

                        try :
                                iUnique = int(dictUniques[sType])
                        except :
                                writeLog("", False, [" XMLEntriesList ERROR, uniqueimprovements : iUnique can't be converted to int %r" %(dictUniques[sType], )])
                                continue

                        if iUnique == 1 :
                                XMLEntriesList["uniqueimprovements"].append(str(sType))
                                if sType in XMLEntriesList["improvements"] : continue
                                XMLEntriesList["improvements"].append(str(sType))
                                XMLEntriesList["list"].append(str(sType))
                                parsedXMLValuesEntries[sType] = {}
                                parsedXMLValuesEntries[sType]["iAppearanceProbability"] = 0
                                parsedXMLValuesEntries[sType]["SpawnUnitType"] = ""
                                parsedXMLValuesEntries[sType]["BonusConvert"] = ""
                                
                                if sType in dictUnitsSpawn.keys() :
                                        if dictUnitsSpawn[sType] == "" : pass
                                        if gc.getInfoTypeForString(dictUnitsSpawn[sType]) == -1 : pass
                                        else :
                                                if not dictUnitsSpawn[sType] in XMLEntriesList["list"] :
                                                        XMLEntriesList["list"].append(str(dictUnitsSpawn[sType]))
                                                        XMLEntriesList["unitspawn"].append(str(dictUnitsSpawn[sType]))

                                                parsedXMLValuesEntries[sType]["SpawnUnitType"] = copy.copy(dictUnitsSpawn[sType])

                                if sType in dictBonuses.keys() :
                                        if dictBonuses[sType] == "" : pass
                                        if gc.getInfoTypeForString(dictBonuses[sType]) == -1 : pass
                                        else :
                                                if not dictBonuses[sType] in XMLEntriesList["list"] :
                                                        XMLEntriesList["list"].append(str(dictBonuses[sType]))
                                                        XMLEntriesList["bonusconvert"].append(str(dictBonuses[sType]))

                                                parsedXMLValuesEntries[sType]["BonusConvert"] = copy.copy(dictBonuses[sType])

                # world infos for unique features chances
                XMLEntriesList["worldinfos"] = []
                dictUniqueChances = getXMLValues("world", "<iUniqueFeatureChance>", "</iUniqueFeatureChance>")
                for iWorldInfo in range(gc.getNumWorldInfos()) :
                        worldInfoXML = gc.getWorldInfo(iWorldInfo)
                        worldInfoType = getSText(worldInfoXML.getType())
                        XMLEntriesList["list"].append(str(worldInfoType))
                        XMLEntriesList["worldinfos"].append(str(worldInfoType))
                        parsedXMLValuesEntries[worldInfoType] = {}
                        parsedXMLValuesEntries[worldInfoType]["iUniqueFeatureChance"] = 0

                        if worldInfoType in dictUniqueChances.keys() :

                                if dictUniqueChances[worldInfoType] == "" : continue

                                try :
                                        iUniqueChance = int(dictUniqueChances[worldInfoType])
                                except :
                                        writeLog("", False, [" XMLEntriesList ERROR, worldinfos : iUniqueChance can't be converted to int %r" %(dictUniqueChances[worldInfoType], )])
                                        continue

                                parsedXMLValuesEntries[worldInfoType]["iUniqueFeatureChance"] = int(iUniqueChance)

        logList = []
        logList.append("")
        for iKey in XMLEntriesList.keys() :
                if type(XMLEntriesList[iKey]) is types.DictType :
                        logList.append("")
                        for iKey2 in XMLEntriesList[iKey].keys() :
                                logList.append(" %s , %s : %r" %(iKey, iKey2, XMLEntriesList[iKey][iKey2]))
                        logList.append("")
                else :
                        logList.append(" %s : %r" %(iKey, XMLEntriesList[iKey]))
        writeLog("initXMLLists", True, logList)

def initXMLDescriptions() :
        global XMLDescriptions
        global bInitDescription
        
        if not bInitDescription : return
        bInitDescription = False

        writeLog("initXMLDescriptions", False, [""])

        # description lists
        initialLanguage = int(CyGame().getCurrentLanguage())

        for sType in XMLEntriesList["list"] :
                XMLDescriptions[str(sType)] = "ini"

        # used to check if a unitclass has multiple units to add the unit class description in the unit descrition
        nbUnitPerClass = [ 0 for i in range(gc.getNumUnitClassInfos()) ]
        for unitType in XMLEntriesList["units"]["list"] :
                unitXML = gc.getUnitInfo(gc.getInfoTypeForString(unitType))
                iUnitClass = unitXML.getUnitClassType()
                nbUnitPerClass[iUnitClass] += 1

        TXT_MAX_WORLDUNIT = ["Max %d", "Max %d", "Max %d", "Mas %d", "Mx %d"]
        TXT_MAX_TEAMUNIT = ["Max %d per team", "Max %d par quipe", "Max %d pro Team", "Mas %d per gruppo", "Mx %d por equipo"]
        TXT_MAX_PLAYERUNIT = ["Max %d per player", "Max %d par joueur", "Max %d pro Spieler", "Mas %d per giocatore", "Mx %d por jugador"]

        if initialLanguage != language :
                CyGame().setCurrentLanguage(language)

        # improvement descriptions
        if is_BtS_FFH2 :
                for improvementType in XMLEntriesList["improvements"] :

                        improvementXML = gc.getImprovementInfo(gc.getInfoTypeForString(improvementType))

                        try :
                                sDescription = getSText(improvementXML.getDescription())
                        except :
                                writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, improvementType), ""])
                                sDescription = ""

                        if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                                sDescription = str(improvementType)[12:]
                                sDescription = sDescription.replace("_", " ")
                                sDescription = sDescription.capitalize()
                        XMLDescriptions[str(improvementType)] = str(sDescription)

        # world info descriptions
        if is_BtS_FFH2 :
                for worldInfoType in XMLEntriesList["worldinfos"] :

                        worldInfoXML = gc.getWorldInfo(gc.getInfoTypeForString(worldInfoType))

                        try :
                                sDescription = getSText(worldInfoXML.getDescription())
                        except :
                                writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, worldInfoType), ""])
                                sDescription = ""

                        if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                                sDescription = str(worldInfoType)[10:]
                                sDescription = sDescription.replace("_", " ")
                                sDescription = sDescription.capitalize()
                        XMLDescriptions[str(worldInfoType)] = str(sDescription)

        # resources descriptions
        for bonusType in XMLEntriesList["reslist"] :

                bonusXML = gc.getBonusInfo(gc.getInfoTypeForString(bonusType))

                try :
                        sDescription = getSText(bonusXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, bonusType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(bonusType)[6:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()
                XMLDescriptions[str(bonusType)] = str(sDescription)

        if is_BtS_FFH2 :
                for bonusType in XMLEntriesList["bonusconvert"] :

                        bonusXML = gc.getBonusInfo(gc.getInfoTypeForString(bonusType))

                        try :
                                sDescription = getSText(bonusXML.getDescription())
                        except :
                                writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, bonusType), ""])
                                sDescription = ""

                        if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                                sDescription = str(bonusType)[6:]
                                sDescription = sDescription.replace("_", " ")
                                sDescription = sDescription.capitalize()
                        XMLDescriptions[str(bonusType)] = str(sDescription)

        # building descriptions
        for buldingType in XMLEntriesList["buildingsbarb"] :

                buildingXML = gc.getBuildingInfo(gc.getInfoTypeForString(buldingType))

                try :
                        sDescription = getSText(buildingXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, buldingType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(buldingType)[9:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()
                XMLDescriptions[str(buldingType)] = str(sDescription)

        # tech descriptions
        for techType in XMLEntriesList["techslist"] :

                techXML = gc.getTechInfo(gc.getInfoTypeForString(techType))

                try :
                        sDescription = getSText(techXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, techType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(techType)[5:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()
                XMLDescriptions[str(techType)] = str(sDescription)

        # unit combat descriptions
        for combatType in XMLEntriesList["unitcombatlist"] :

                combatXML = gc.getUnitCombatInfo(gc.getInfoTypeForString(combatType))

                try :
                        sDescription = getSText(combatXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, combatType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(combatType)[11:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()
                XMLDescriptions[str(combatType)] = str(sDescription)

        # unit class descriptions
        for unitClassType in XMLEntriesList["unitclasslist"] :

                unitClassXML = gc.getUnitClassInfo(gc.getInfoTypeForString(unitClassType))

                try :
                        sDescription = getSText(unitClassXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, unitClassType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(unitClassType)[10:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()
                XMLDescriptions[str(unitClassType)] = str(sDescription)

        # unit descriptions
        for unitType in XMLEntriesList["units"]["list"] :

                unitXML = gc.getUnitInfo(gc.getInfoTypeForString(unitType))

                try :
                        sDescription = getSText(unitXML.getDescription())
                except :
                        writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, unitType), ""])
                        sDescription = ""

                if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                        sDescription = str(unitType)[5:]
                        sDescription = sDescription.replace("_", " ")
                        sDescription = sDescription.capitalize()

                bAddClassDescription = False
                bAddWorldNb = False
                bAddTeamNb = False
                bAddPlayerNb = False
                
                iUnitClass = unitXML.getUnitClassType()
                unitClassXML = gc.getUnitClassInfo(iUnitClass)

                if nbUnitPerClass[iUnitClass] > 1 : bAddClassDescription = True
                if unitType in XMLEntriesList["units"]["world"] : bAddWorldNb = True
                if unitType in XMLEntriesList["units"]["team"] : bAddTeamNb = True
                if unitType in XMLEntriesList["units"]["national"] : bAddPlayerNb = True

                if bAddClassDescription or bAddWorldNb or bAddTeamNb or bAddPlayerNb :
                        sDescription += " "

                if bAddClassDescription :
                        classType = getSText(unitClassXML.getType())
                        sDescription += "(%s)" %XMLDescriptions[classType]

                if bAddWorldNb or bAddTeamNb or bAddPlayerNb :
                        sList = []
                        if bAddWorldNb : sList.append(TXT_MAX_WORLDUNIT[language] %unitClassXML.getMaxGlobalInstances())
                        if bAddTeamNb : sList.append(TXT_MAX_TEAMUNIT[language] %unitClassXML.getMaxTeamInstances())
                        if bAddPlayerNb : sList.append(TXT_MAX_PLAYERUNIT[language] %unitClassXML.getMaxPlayerInstances())
                        sDescription += "(%s)" %" , ".join(sList)
                        
                XMLDescriptions[str(unitType)] = str(sDescription)

        if is_BtS_FFH2 :
                for unitType in XMLEntriesList["unitspawn"] :

                        unitXML = gc.getUnitInfo(gc.getInfoTypeForString(unitType))

                        try :
                                sDescription = getSText(unitXML.getDescription())
                        except :
                                writeLog("", False, ["an error to convert description , language : %d , type : %s" %(language, unitType), ""])
                                sDescription = ""

                        if (sDescription == "") or (sDescription[0:8] == "TXT_KEY_"):
                                sDescription = str(unitType)[5:]
                                sDescription = sDescription.replace("_", " ")
                                sDescription = sDescription.capitalize()
                        XMLDescriptions[str(unitType)] = str(sDescription)

        if initialLanguage != language :
                CyGame().setCurrentLanguage(initialLanguage)

        logList = []
        listKeys = XMLDescriptions.keys()
        listKeys.sort()
        for iKey in listKeys : logList.append(" %s : %r" %(iKey, XMLDescriptions[iKey]))
        writeLog("", True, logList)

# this function is used to sort element type in function of the language descriptions for the screen .
def sortXMLLists():
        global XMLEntriesList

        # resources sort
        XMLEntriesList["reslist"] = []
        for idRes in ["strategic", "health", "happiness"] :
                tpList = [ [XMLDescriptions[item], item] for item in XMLEntriesList[idRes] ]
                tpList.sort()
                XMLEntriesList[idRes] = [item[1] for item in tpList]
                XMLEntriesList["reslist"] += [item[1] for item in tpList]

        # buildings sort
        buildingListTemp = [[item, XMLDescriptions[item], -1] for item in XMLEntriesList["buildingsbarb"]]
        for item in buildingListTemp :
                iTech = gc.getBuildingInfo(gc.getInfoTypeForString(item[0])).getPrereqAndTech()
                if iTech == -1 :
                        item[2] = 0
                else :
                        item[2] = max(0, gc.getTechInfo(iTech).getResearchCost())

        buildingListTemp = sortList(buildingListTemp, 1)
        buildingListTemp = sortList(buildingListTemp, 2)

        XMLEntriesList["buildingsbarb"] = [item[0] for item in buildingListTemp]

        # tech sort
        techListTemp = [[item, XMLDescriptions[item], gc.getTechInfo(gc.getInfoTypeForString(item)).getResearchCost()] for item in XMLEntriesList["techslist"]]
        techListTemp = sortList(techListTemp, 1)
        techListTemp = sortList(techListTemp, 2)

        XMLEntriesList["techslist"] = [item[0] for item in techListTemp]

        techListTemp = [[item, XMLDescriptions[item]] for item in XMLEntriesList["techsstartciv"]]
        techListTemp = sortList(techListTemp, 1)

        XMLEntriesList["techsstartciv"] = [item[0] for item in techListTemp]

        # unit combat sort
        combatListTemp = [[item, XMLDescriptions[item]] for item in XMLEntriesList["unitcombatlist"]]
        combatListTemp = sortList(combatListTemp, 1)

        XMLEntriesList["unitcombatlist"] = [item[0] for item in combatListTemp]

        # unit sort
        # 1rst group units per unit class ( to make them always grouped in the list )      
        unitsPerClass = [ [] for i in range(gc.getNumUnitClassInfos()) ]
        for unitType in XMLEntriesList["units"]["list"] :
                unitXML = gc.getUnitInfo(gc.getInfoTypeForString(unitType))
                iUnitClass = unitXML.getUnitClassType()
                unitsPerClass[iUnitClass].append(unitType)

        # 2nd sort each class group by default unit , then description
        for iUnitClass in range(gc.getNumUnitClassInfos()) :
                if len(unitsPerClass[iUnitClass]) < 2 : continue
                iDefaultUnitType = gc.getUnitClassInfo(iUnitClass).getDefaultUnitIndex()
                if iDefaultUnitType != -1 :
                        sDefaultUnitType = getSText(gc.getUnitInfo(iDefaultUnitType).getType())
                        if sDefaultUnitType in unitsPerClass[iUnitClass] :
                                tpList0 = [sDefaultUnitType]
                        else :
                                tpList0 = []
                else :
                        tpList0 = []

                tpList1 = [[item, XMLDescriptions[item]] for item in unitsPerClass[iUnitClass] if not item in tpList0]
                if len(tpList1) > 1 : tpList1 = sortList(tpList1, 1)

                unitsPerClass[iUnitClass] = tpList0 + [item[0] for item in tpList1]

        # 3rd sort the units lists by class group, element group (peace, land, ...) , power , description
        listTag = ["barbdefender", "barbfight", "animland", "peacedd", "landdd", "waterdd", "airdd", "otherdd", "national", "team", "world", "combatnone"]
        listTag += [item for item in XMLEntriesList["unitcombatlist"]]
        for sTag in listTag :
                if len(XMLEntriesList["units"][sTag]) < 2 : continue

                classList = []
                elementList = []

                for unitType in XMLEntriesList["units"][sTag] :
                        iUnitClass = gc.getUnitInfo(gc.getInfoTypeForString(unitType)).getUnitClassType()

                        if iUnitClass in classList : continue

                        classList.append(iUnitClass)

                        # choose the default unit , or the first in the list to represent the group
                        for unitTypeR in unitsPerClass[iUnitClass] :
                                if not unitTypeR in XMLEntriesList["units"][sTag] : continue
                                unitR = unitTypeR
                                break

                        if unitR in XMLEntriesList["units"]["peace"] : iGroup = 0
                        else : iGroup = 10

                        if unitR in XMLEntriesList["units"]["land"] : iGroup += 1
                        elif unitR in XMLEntriesList["units"]["water"] : iGroup += 2
                        elif unitR in XMLEntriesList["units"]["air"] : iGroup += 3
                        else : iGroup += 4

                        # after sort by power , sort by description , the first unit is almost every time the class description
                        sDescription = XMLDescriptions[unitR]

                        iPower = gc.getUnitInfo(gc.getInfoTypeForString(unitR)).getPowerValue()

                        elementList.append([iUnitClass, sDescription, iPower, iGroup])

                if len(elementList) > 1 :
                        elementList = sortList(elementList, 1)
                        elementList = sortList(elementList, 2)
                        elementList = sortList(elementList, 3)

                endListClass = [item[0] for item in elementList]
                tpList = []

                for iUnitClass in endListClass :
                        for unitType in unitsPerClass[iUnitClass] :
                                if unitType in XMLEntriesList["units"][sTag] : tpList.append(unitType)

                XMLEntriesList["units"][sTag] = [item for item in tpList]

        logList = []
        for iKey in XMLEntriesList.keys() :
                if type(XMLEntriesList[iKey]) is types.DictType :
                        logList.append("")
                        for iKey2 in XMLEntriesList[iKey].keys() :
                                logList.append(" %s , %s : %r" %(iKey, iKey2, XMLEntriesList[iKey][iKey2]))
                        logList.append("")
                else :
                                logList.append(" %s : %r" %(iKey, XMLEntriesList[iKey]))
        writeLog("sortXMLLists", True, logList)

def initMenuGlobals():
        global bScreen
        bScreen = True

        initVersions()

        createStoDir()

        initStoFolder()
        initDebugFiles()
        initMenuDebug()

        initLanguage()

def initPreGameGlobals():
        global gc

	gc = CyGlobalContext()

        initMOD()

        initXMLLists()

        initXMLDescriptions()

        sortXMLLists()

        initCanUseGameOptions()

def initStoFolder():
        global StoFolder

        StoFolder = StoFilePath()

def initMenuDebug():
        global debugFile
        debugFile = "MenuDbg.txt"

def initGenerationDebug():
        global debugFile
        debugFile = "MapGenerationDbg.txt"

def initLanguage():
        global language

        language = loadConfig("language")

        if language == -1 :
                language = CyGame().getCurrentLanguage()
                if not language in range(5) : language = 0
                saveConfig("language", language)

def initVersions():
        global BtS
        global Wrds
        global BorW

        BtS = False
        if (os.path.basename(os.getcwd()) == "Beyond the Sword") : BtS = True

        Wrds = False
        if (os.path.basename(os.getcwd()) == "Warlords") : Wrds = True
        
        BorW = False
        if BtS or Wrds : BorW = True

def Sto_FullOfResources_AddGameElements_Event_Begin(argsList):
        return

def Sto_FullOfResources_AddGameElements_Event_Apply(playerID, userData, popupReturn):
        StoAddGameElements()
        return initStoRemoveEvent()

def initStoAddEvent():
        # search for all event id
        listEventInteger = []
        for item in dir(CvUtil) :
                objTemp = getattr(CvUtil, item)
                if type(objTemp) is types.IntType : listEventInteger.append(int(objTemp))

        # all checks done , add the event
        popUpID = -1
        for i in range(5000, 10000) :
                if not i in listEventInteger :
                        popUpID = i
                        break

        setattr(CvUtil , "Sto_FullOfResources_AddGameElements_EventID", popUpID)
        CvUtil.SilentEvents.append(getattr(CvUtil, "Sto_FullOfResources_AddGameElements_EventID"))
        setattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Begin", Sto_FullOfResources_AddGameElements_Event_Begin)
        setattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Apply", Sto_FullOfResources_AddGameElements_Event_Apply)
        objEvents = getattr(CvEventInterface.getEventManager(), 'Events')
        objEvents[getattr(CvUtil, "Sto_FullOfResources_AddGameElements_EventID")] = "Sto_FullOfResources_AddGameElements_EventID", getattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Apply"), getattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Begin")

def initStoRemoveEvent():
        objEvents = getattr(CvEventInterface.getEventManager(), 'Events')
        del objEvents[getattr(CvUtil, "Sto_FullOfResources_AddGameElements_EventID")]
        delattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Begin")
        delattr(CvEventInterface.getEventManager(), "__Sto_FullOfResources_AddGameElements_Event_Apply")
        CvUtil.SilentEvents.remove(getattr(CvUtil, "Sto_FullOfResources_AddGameElements_EventID"))
        delattr(CvUtil , "Sto_FullOfResources_AddGameElements_EventID")
        return 0

def initCanUseGameOptions():
        global canUseGameOptions

        ## check if the additionnal game options can be added at the beginning of the game
        canUseGameOptions = False

        # check if CvEventInterface have getEventManager .
        try :
                if not hasattr(CvEventInterface, 'getEventManager'):
                        writeLog("", False, [" initCanUseGameOptions : CvEventInterface don't have getEventManager", ""])
                        return
        except :
                writeLog("", False, [" initCanUseGameOptions : CvEventInterface probably not imported ...", ""])
                return

        # check if CvEventManager have Events .
        if not hasattr(CvEventInterface.getEventManager(), 'Events'):
                writeLog("", False, [" initCanUseGameOptions : CvEventManager don't have Events", ""])
                return

        objEvents = getattr(CvEventInterface.getEventManager(), 'Events')

        # check if Events is a dictionnary.
        if not type(objEvents) is types.DictType :
                writeLog("", False, [" initCanUseGameOptions : Events is not a dictionnary", ""])
                return

        # search for all event id
        listEventInteger = []
        for item in dir(CvUtil) :
                objTemp = getattr(CvUtil, item)
                if type(objTemp) is types.IntType : listEventInteger.append(int(objTemp))

        # search an ID for each event to add :
        popUpID=-1
        for i in range(5000, 10000):
                if not i in listEventInteger :
                        popUpID = i
                        break

        if popUpID == -1 :
                writeLog("", False, [" initCanUseGameOptions : No popup id available", ""])
                return

        # check if CvUtil have SilentEvents.
        if not "SilentEvents" in dir(CvUtil) :
                writeLog("", False, [" initCanUseGameOptions : CvUtil don t have SilentEvents", ""])
                return

        # check if SilentEvents is a list.
        if not type(CvUtil.SilentEvents) is types.ListType :
                writeLog("", False, [" initCanUseGameOptions : SilentEvents is not a list", ""])
                return

        canUseGameOptions = True

##!_!## debug set up
def initDebugFiles():
        global firstInitDebugFiles

        if firstInitDebugFiles :
                firstInitDebugFiles = False
                try :
                        Sfile = open(os.path.join(StoFolder,"MenuDbg.txt"),"w")
                        Sfile.write("__ MenuDbg : Full of resources, version %s __\n\n\n" %getVersion())
                        Sfile.close()
                        Sfile = open(os.path.join(StoFolder,"MapGenerationDbg.txt"),"w")
                        Sfile.write("__ MapGenerationDbg : Full of resources, version %s __\n\n\n" %getVersion())
                        Sfile.close()
                except :
                        print " FoR : initDebugFiles : ERROR"

def writeLog(sBegin, bEnd, listLines):
        if not bScreen :
                if not selGen["game"]["log"]["writelog"] :
                        return
        buffLines = []
        if sBegin != "" :
                sTp = "_ %s _" %sBegin
                buffLines = [sTp + "_"*max(40 - len(sTp), 1), ""]
        buffLines += listLines
        if bEnd :
                buffLines += ["", "_"*40, "", ""]

        try :
                sText = "\n".join(buffLines) + "\n"
                Sfile = open(os.path.join(StoFolder, debugFile), "a")
                Sfile.write(sText)
                Sfile.close()
        except :
                writeError()
                for sText in buffLines : sys.stdout.write(" Error writeLog : %s\n" %sText)

def writeError():
        try :
                Sfile = open(os.path.join(StoFolder, debugFile), "a")
                Sfile.write("\n" +"_ ERROR _".ljust(40,"_") + "\n")
                traceback.print_exc(None, Sfile)
                Sfile.write("_".ljust(40,"_") + "\n\n")
                Sfile.close()
        except :
                print " FoR : LoOl : Error writeError "

##!_!## Screen set up
def launchSetUpScreen():
        global selection
        global isNetMP
        global isGameMP
        global isPbemOrHseat
        global bCanWriteLog
        global bFfH2Tab

        isNetMP = CyGame().isNetworkMultiPlayer()
        isGameMP = CyGame().isGameMultiPlayer()
        isPbemOrHseat = bool(CyGame().isPbem() or CyGame().isHotSeat())
        bCanWriteLog = bool(not CyGame().isPbem())

        logList = []
        logList.append(" isNetMP : %r" %isNetMP)
        logList.append(" isGameMP : %r" %isGameMP)
        logList.append(" isPbemOrHseat : %r" %isPbemOrHseat)
        logList.append(" bCanWriteLog : %r" %bCanWriteLog)
        logList.append(" active player : %d" %int(CyGame().getActivePlayer()))
        logList.append(" game turn : %d" %int(CyGame().getGameTurn()))

        # in case one of the map option is called during the game : check if the game is already initialized (not in the menu)
        if CyGame().isFinalInitialized() :
                logList.append(" the game is final initialized : don't launch the screen")
                writeLog("launchSetUpScreen", True, logList)
                return

        # only the hosting player edit the settings , and the custom map options are called when exiting the game in mp .
        if CyGame().getActivePlayer() != 0 :
                logList.append(" Active player != 0 : don't launch the screen")
                writeLog("launchSetUpScreen", True, logList)
                return

        # if the game is MP , prevent the screen to appear when you load a game
        if isGameMP :
                if not CyGame().getGameTurn() in [-1, 0] : #should not be equal to -1, just in case
                        logList.append(" MP game , game turn != 0 : don't launch the screen , loading a game")
                        writeLog("launchSetUpScreen", True, logList)
                        return

        initPreGameGlobals()

        initDefaultSelection()
        initValueLimits()

        logList.append(" running Warlords %r" %Wrds)
        logList.append(" running BtS %r" %BtS)
        logList.append(" canUseGameOptions %r" %canUseGameOptions)
        logList.append(" language %d" %language)

        # if there is no setting defined , initialize selection
        if selection == {} :
                selection = dict(loadSelection())
                sortMultiBox()
        else :
                selection = checkSettings(selection) #use if you change the game type (MP,SP) for the writelog option

        bFfH2Tab = False
        if "ffh2" in selection.keys() : bFfH2Tab = True
        logList.append(" bFfH2Tab %r" %bFfH2Tab)

        if not "optionsScreen" in dir(CvScreensInterface) :
                logList.append(" optionsScreen is not in CvScreensInterface : don't launch the screen")
                writeLog("launchSetUpScreen", True, logList)
                launchPopUP([["TXT_FAILED_POPUP_INIT", ""]])
                return

        # check if the screen can be launched :
        # 1 : check if the original file is not MODDED to prevent a non reversible change
        # 2 : check if the screen in place is not already a Sto screen ... ( in order to restore the option screen )
        # can happen if the user use the 'Esc' key instead of the exit button to exit the screen. So the user can launch the screen again instead of restart CivIV

        canLaunchScreen = False
        for instance in ["CvOptionsScreen.CvOptionsScreen ", ".CvStoFullOfResourcesScreen ", ".CvStoLoadFileScreen ", ".CvStoSaveFileScreen "] :
                if instance in repr(CvScreensInterface.optionsScreen) :
                        canLaunchScreen = True
                        break

        if not canLaunchScreen :
                logList.append(" optionsScreen not recognized : don't launch the screen")
                writeLog("launchSetUpScreen", True, logList)
                launchPopUP([["TXT_FAILED_POPUP_INIT", ""]])
                return
        
        if not "showOptionsScreen" in dir(CvScreensInterface) :
                logList.append(" showOptionsScreen is not in CvScreensInterface : don't launch the screen")
                writeLog("launchSetUpScreen", True, logList)
                launchPopUP([["TXT_FAILED_POPUP_INIT", ""]])
                return

        writeLog("launchSetUpScreen", False, logList)

        initScreenCallBack()

        writeLog("", False, [" callBacks Initialized ..."])
        
        CvScreensInterface.optionsScreen = CvStoFullOfResourcesScreen()
        CvScreensInterface.showOptionsScreen()

        writeLog("", True, [" screen showned ..."])

def loadSelection(fileName = "", bForce = True):
        selTp = {}
        if fileName != "" :
                if fileName in getListDirSto() :
                        try :
                                Sfile = open(os.path.join(StoFolder, fileName),"r")
                                selTpt = pickle.load(Sfile)
                                Sfile.close()
                                selTp = selTpt
                        except :
                                writeError()

        if selTp != {} : return checkSettings(selTp)

        if not bForce : return -1

        #First time you enter in the menu , try to read the last settings used ,for the version and the MOD you have played
        # (if the script recognize the MOD ) . Try to find the best file if you're running a new MOD or Version
        lastFileName = getLastFileUsedName(True)

        if lastFileName != "" :
                try :
                        Sfile = open(os.path.join(StoFolder, lastFileName),"r")
                        selTpt = pickle.load(Sfile)
                        Sfile.close()
                        selTp = selTpt
                except :
                        writeError()

        if selTp != {} : return checkSettings(selTp)

        # Can't find any setting saved , return the default settings
        return copy.deepcopy(defSel)

def saveSelection(fileName):
        try:
                Sfile = open(os.path.join(StoFolder,fileName),"w")
                pickle.dump(selection, Sfile)
                Sfile.close()
                return False
        except :
                writeError()
                return True
            
def loadConfig(idConfig):
        confTp = -1
        if "_userConfig.cfg" in getListDirSto() :
                try :
                        Sfile = open(os.path.join(StoFolder,"_userConfig.cfg"),"r")
                        loadDict = pickle.load(Sfile)
                        Sfile.close()
                        if idConfig in loadDict.keys() :
                                confTp = loadDict[idConfig]
                                writeLog("", False, [" loadConfig : read %s " %idConfig, ""])
                        else :
                                writeLog("", False, [" loadConfig : %s is not in _userConfig.cfg" %idConfig, ""])
                except :
                        writeError()
        else :
                writeLog("", False, [" loadConfig , %s : _userConfig.cfg is not in getListDirSto()" %idConfig, ""])

        return confTp

def saveConfig(idConfig, value):
        confDict = {}
        try :
                Sfile = open(os.path.join(StoFolder,"_userConfig.cfg"),"r")
                loadDict = pickle.load(Sfile)
                Sfile.close()
                confDict = loadDict
        except :
                writeError()

        confDict[idConfig] = value

        try:
                Sfile = open(os.path.join(StoFolder,"_userConfig.cfg"),"w")
                pickle.dump(confDict, Sfile)
                Sfile.close()
        except :
                writeError()

def getLastFileUsedName(bSearch=False):
        modN = ""
        if modName != "None" : modN = "%s_" %modName
        fileNameBtS = "_BtS_currentConfig.cfg"
        fileNameBtSMOD = "_BtS_%scurrentConfig.cfg" %modN
        fileNameWrds = "_Warlords_currentConfig.cfg"
        fileNameWrdsMOD = "_Warlords_%scurrentConfig.cfg" %modN
        fileNameVan = "_Vanilla_currentConfig.cfg"
        fileNameVanMOD = "_Vanilla_%scurrentConfig.cfg" %modN

        fileNameLast = "_LastConfig.cfg"

        if not bSearch :
                if BtS : return fileNameBtSMOD
                elif Wrds : return fileNameWrdsMOD
                else : return fileNameVanMOD

        listFiles = getListDirSto()

        if BtS :
                if fileNameBtSMOD in listFiles : return fileNameBtSMOD
                elif fileNameBtS in listFiles : return fileNameBtS
                elif fileNameLast in listFiles : return fileNameLast
        elif Wrds :
                if fileNameWrdsMOD in listFiles : return fileNameWrdsMOD
                elif fileNameWrds in listFiles : return fileNameWrds
                elif fileNameLast in listFiles : return fileNameLast
        else :
                if fileNameVanMOD in listFiles : return fileNameVanMOD
                elif fileNameVan in listFiles : return fileNameVan
                elif fileNameLast in listFiles : return fileNameLast
        return ""

def createStoDir():
        docFolder = civFilePath()

        if docFolder == "" :
                print " FoR : createStoDir : can t reach document folder"
                return

        if os.path.isdir(os.path.join(docFolder, "CivilizationIV Full of Resources")) :
                print " FoR : createStoDir : the folder already exist "
                return

        try :
                os.mkdir( os.path.join(docFolder, "CivilizationIV Full of Resources") )
                print " FoR : createStoDir : the folder should have been created "
        except :
                print " FoR : createStoDir : ERROR while creating the folder "
        
def regRead(registry, path, field):
        pathKey = _winreg.OpenKey(registry, path)
        try:
                fieldValue = _winreg.QueryValueEx(pathKey, field)
                return fieldValue[0]
        finally:
                pathKey.Close()

def civFilePath():
        if (sys.platform == 'darwin'):
                try:
                        userFolder = os.path.join(os.environ['HOME'], "Documents")
                        return userFolder
                except:
                        print " FoR : ERROR civFilePath()"
                        return ""
        else:
                try:
                        userFolder = regRead(_winreg.HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders","Personal")
                        finalFolder =  os.path.join(userFolder, "My Games")
                        return finalFolder
                except:
                        print " FoR : ERROR civFilePath()"
                        return ""

def StoFilePath():
        try:
                userFolder = civFilePath()
                if userFolder == "" :
                        print " FoR : StoFilePath : can t reach document folder "
                        return ""

                StoFol = os.path.join(userFolder, "CivilizationIV Full of Resources")
                return StoFol
        except:
                print " FoR : StoFilePath : ERROR trying to create folder string "
                return ""

def getListDirSto():
        try :
                if StoFolder == "" :
                        writeLog("", False, [" getListDirSto :  can't read StoFolder ", ""])
                        return []
                listDirSto = os.listdir(StoFolder)
                listDirSto = [getSText(item) for item in listDirSto]

                writeLog("", False, [" getListDirSto : %r" %listDirSto, ""])

                return listDirSto
        except :
                writeError()
                return []

def launchPopUP(argList):
        try :
                popup = PyPopup.PyPopup()
                popup.setHeaderString("")

                if len(argList)>1 :
                        resolution = [int(item) for item in CyUserProfile().getResolutionString(CyUserProfile().getResolution()).split("x") if item != "" ]
                        popup.setPosition(int(resolution[0]*0.05), int(resolution[1]*0.05))
                        popup.setSize(int(resolution[0]*0.90), int(resolution[1]*0.90))
                        textPopUp = ""
                        for [szTag, lList] in argList : textPopUp += getSMenuText(szTag, lList) +"\n"
                else :
                        szTag, lList = argList[0]
                        textPopUp = getSMenuText(szTag, lList) +"\n"

                popup.setBodyString(getUText(textPopUp))
                popup.launch()
        except :
                writeError()

# define default selection
def initDefaultSelection():
        global defSel
        defSel = {}

        # set the map settings
        defaultSelMaps = {}
        defaultSelMaps["archipelago"] = {
                "selected" : False ,
                "landmass" : [1] ,
                "waterper" : [78] ,
                "wrap" : [1] ,
                "start" : [0]
                }
        defaultSelMaps["continents"] = {
                "selected" : False ,
                "waterper" : [75] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["customcontinents"] = {
                "selected" : False ,
                "numbercontinents" : [0] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["fractals"] = {
                "selected" : False ,
                "waterper" : [78] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["hub"] = {
                "selected" : False ,
                "areaperplayer" : [0] ,
                "landshape" : [0,1,2] ,
                "neutralter" : [0,1,2,3] ,
                "isthmuswidth" : [1] ,
                "wrap" : [0] ,
                "start" : [0,1]
                }
        defaultSelMaps["inlandsea"] = {
                "selected" : False ,
                "wrap" : [0] ,
                "start" : [1]
                }
        defaultSelMaps["islands"] = {
                "selected" : False ,
                "largeislands" : [0] ,
                "tinyislands" : [2] ,
                "wrap" : [1] ,
                "start" : [0]
                }
        defaultSelMaps["lakes"] = {
                "selected" : False ,
                "waterper" : [9] ,
                "lakesize" : [0] ,
                "wrap" : [0]
                }
        defaultSelMaps["maze"] = {
                "selected" : False ,
                "mazewidth" : [2] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["pangaea"] = {
                "selected" : False ,
                "shoreline" : [0] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["ring"] = {
                "selected" : False ,
                "areaperplayer" : [0] ,
                "landshape" : [0,1,2] ,
                "neutralter" : [0,1,2,3] ,
                "isthmuswidth" : [1] ,
                "wrap" : [0] ,
                "start" : [0,1]
                }
        defaultSelMaps["shuffle"] = {
                "selected" : False ,
                "waterper" : [78] ,
                "wrap" : [1] ,
                "start" : [True,True]
                }
        defaultSelMaps["terra"] = {
                "selected" : False ,
                "wrap" : [1] ,
                "startterra" : [0,1,2]
                }
        defaultSelMaps["wheel"] = {
                "selected" : False ,
                "areaperplayer" : [0] ,
                "landshape" : [0,1,2] ,
                "ringwidth" : [1] ,
                "spokewidth" : [1] ,
                "wrap" : [0] ,
                "start" : [0,1]
                }
        defaultSelMaps["chess"] = {
                "selected" : False ,
                "waterper" : [25] ,
                "wrap" : [1] ,
                "start" : [0,1] ,
                "border" : [0]
                }
        defaultSelMaps["bigandsmall"] = {
                "selected" : False ,
                "continentsize" : [1] ,
                "islandsize" : [0] ,
                "islandoverlap" : [0] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["hemispheres"] = {
                "selected" : False ,
                "hemcontinentsize" : [1] ,
                "islandsize" : [1] ,
                "hemnumbercontinents" : [0] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["mediumandsmall"] = {
                "selected" : False ,
                "mascontinentsize" : [4] ,
                "islandsize" : [1] ,
                "islandoverlap" : [0] ,
                "wrap" : [1] ,
                "start" : [0,1]
                }
        defaultSelMaps["tectonics"] = {
                "selected" : False ,
                "teclandmass" : [0] ,
                "tecaridity" : [1] ,
                "start" : [0,1]
                }

        defSel["maps"] = dict(defaultSelMaps)

        # set the terrain settings
        defaultSelTerrain = {}
        defaultSelTerrain["terrains"] = {
                "grass" : [1] ,
                "plains" : [1] ,
                "desert" : [3] ,
                "tundra" : [3] ,
                "snow" : [3]
                }
        defaultSelTerrain["forest"] = {
                "forestpercent" : [40]
                }
        defaultSelTerrain["jungle"] = {
                "junglepercent" : [80]
                }
        defaultSelTerrain["peak"] = {
                "peakpercent" : "standard" ,
                "peakcoast" : False
                }
        defaultSelTerrain["hill"] = {
                "hillpercent" : "standard"
                }
        defaultSelTerrain["river"] = {
                "riveredge" : [int(gc.getDefineINT("PLOTS_PER_RIVER_EDGE"))]
                }
        iOasis = gc.getInfoTypeForString("FEATURE_OASIS")
        if iOasis != -1 :
                defaultSelTerrain["oasis"] = {
                        "oasispercent" : [int( gc.getFeatureInfo(iOasis).getAppearanceProbability()/100.0 )]
                        }
        iIce = gc.getInfoTypeForString("FEATURE_ICE")
        if iIce != -1 :
                defaultSelTerrain["ice"] = {
                        "iceremove" : 0
                        }
        iGoodyHut = gc.getInfoTypeForString("IMPROVEMENT_GOODY_HUT")
        if iGoodyHut != -1 :
                goodyper = gc.getImprovementInfo(iGoodyHut).getTilesPerGoody()
                if goodyper > 0 :
                        defaultSelTerrain["goodyhut"] = {
                                "goodypercent" : [normalizeFloat(100.0/goodyper)]
                                }
        defaultSelTerrain["island"] = {
                "nbtilesminisland" : [1]
                }
        defSel["terrain"] = dict(defaultSelTerrain)
        
        # set the resources settings
        defaultSelResources = {}
        defaultSelResources["resourcesgen"]={
                "erasedefres" : False ,
                "landpercent" : "standard" ,
                "landprop" : [80, 100, 70] ,
                "waterpercent" : "standard" ,
                "waterprop" : [5, 80, 10] ,
                "standardgen" : [] ,
                "groupres" : copy.deepcopy(XMLEntriesList["groupreslist"]) ,
                "resspreadclimate" : True ,
                "resspreadlake" : False ,
                "resmultiply-0" : [ [], 1 ]
                }
        defaultSelResources["resourcesstart"]={
                "removestartres" : False ,
                "strategicnorandom" : [] ,
                "healthnorandom" : [] ,
                "happinessnorandom" : [] ,
                "startresselect-0" : [] ,
                "startresquantity-0" : [1] ,
                "startreslocation-0" : 0 ,
                "startresforce-0" : 0 ,
                "startresplayer-0" : [0, 1]
                }
        defSel["resources"] = dict(defaultSelResources)

        # set the start location settings
        defaultSelStart = {}
        defaultSelStart["normalize"] = {
                "startplot" : 0 ,
                "addriver" : 0 ,
                "removepeak" : 0 ,
                "addlake" : 0 ,
                "removebadfeature" : 0 ,
                "removebadterrain" : 0 ,
                "addfoodbonus" : 0 ,
                "addgoodterrain" : 0 ,
                "addextra" : 0 ,
                "startsametile" : 0
                }
        defaultSelStart["relocate"] = {
                "swaphuman" : False ,
                "isolatehuman" : False
                }
        defSel["startlocs"] = dict(defaultSelStart)

        # set the game settings
        defaultSelGame = {}
        defaultSelGame["log"] = {
                "writelog" : copy.copy(bCanWriteLog)
                }
        defaultSelGame["barbcities"] = {
                "cityper" : [0] ,
                "citybuilding" : [] ,
                "barbbarbrange" : [5] ,
                "barbhumrange" : [7] ,
                "defender" : [] ,
                "nbdefender" : [1] ,
                "xpdefender" : [10] ,
                "nbtilesminisland" : [5]
                }
        defaultSelGame["animals"] = {
                "animalspercent" : [0] ,
                "animalsnoplace" : [] ,
                "animunitrange" : [3] ,
                "xpanimals" : [0] ,
                "nbtilesminisland" : [5]
                }
        defaultSelGame["gold"] = {
                "gold" : [0] ,
                "goldplayers" : [0, 1]
                }
        defaultSelGame["reveal"] = {
                "startrange" : [0] ,
                "seareveal" : False ,
                "landreveal" : False ,
                "startlocs" : False
                }
        defaultSelGame["techno"] = {
                "starttechs" : 0 ,
                "technoreplace" : [] ,
                "technorandom" : [] ,
                "addtech-0" : [] ,
                "techquantity-0" : [1] ,
                "techplayers-0" : [0, 1]
                }
        defaultSelGame["startunit"] = {
                "startunitselect-0" : [] ,
                "startunittype-0" : 1 ,
                "startunitquantity-0" : [1] ,
                "startunitxp-0" : [0] ,
                "startunitplayers-0" : [0, 1]
                }
        defSel["game"] = dict(defaultSelGame)

        if is_BtS_FFH2 :
                defaultSelFFH2 = {}
                if len(XMLEntriesList["lairs"]) > 0 :
                        defaultSelFFH2["lairs"] = { "mindistlairstart" : [2] }
                        for sType in XMLEntriesList["lairs"] : defaultSelFFH2["lairs"][getTypeForm(sType)] = "standard"
        
                if len(XMLEntriesList["uniqueimprovements"]) > 0 :
                        defaultSelFFH2["uniqueimprovements"] = { "mindistuniquestart" : [3] }
                        for sType in XMLEntriesList["uniqueimprovements"] :
                                defaultSelFFH2["uniqueimprovements"][getTypeForm(sType)] = "standard"
                                if (parsedXMLValuesEntries[sType]["SpawnUnitType"]) != "" or (sType == "IMPROVEMENT_PYRE_OF_THE_SERAPHIC") :
                                        defaultSelFFH2["uniqueimprovements"][getTypeForm(sType) + "placement"] = 0

                if defaultSelFFH2 != {} :
                        defSel["ffh2"] = dict(defaultSelFFH2)
        
## return the limit of the values that the user of the script can enter in the screen .
def initValueLimits():
        global valueLimits
        valueLimits ={}

        # set the map settings
        limitMaps = {}
        limitMaps["porder"] = 0
        limitMaps["archipelago"] = {
                "description" : "Archipelago" ,
                "porder" : 0 ,
                "landmass" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ARCHI_LANDMASS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "waterper" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : [60, 90] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["bigandsmall"] = {
                "description" : "Big and Small" ,
                "porder" : 1 ,
                "continentsize" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_CONTINENTS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "islandsize" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISLANDS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "islandoverlap" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISLAND_OVERLAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["chess"] = {
                "description" : "Chess" ,
                "porder" : 2 ,
                "waterper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0, 50] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "border" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_CHESS_BORDER" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["continents"] = {
                "description" : "Continents" ,
                "porder" : 3 ,
                "waterper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [60, 82] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["customcontinents"] = {
                "description" : "Custom Continents" ,
                "porder" : 4 ,
                "numbercontinents" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 7 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_CC_NB_CONTINENTS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["fractals"] = {
                "description" : "Fractals" ,
                "porder" : 5 ,
                "waterper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [60, 85] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["hemispheres"] = {
                "description" : "Hemispheres" ,
                "porder" : 6 ,
                "hemcontinentsize" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_HEM_CONTINENTS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "islandsize" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISLANDS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "hemnumbercontinents" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_HEM_NB_CONTINENTS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["hub"] = {
                "description" : "Hub" ,
                "porder" : 7 ,
                "areaperplayer" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_AREAS_PER_PLAYER" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landshape" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_LAND_SHAPE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "neutralter" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_NEUTRAL_TERRITORY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "isthmuswidth" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISTHMUS_WIDTH" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 5 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["inlandsea"] = {
                "description" : "Inland Sea" ,
                "porder" : 8 ,
                "wrap" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["islands"] = {
                "description" : "Islands" ,
                "porder" : 9 ,
                "largeislands" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_LARGE_ISLANDS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "tinyislands" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_TINY_ISLANDS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["lakes"] = {
                "description" : "Lakes" ,
                "porder" : 10 ,
                "waterper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [5, 45] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "lakesize" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_LAKES_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["maze"] = {
                "description" : "Maze" ,
                "porder" : 11 ,
                "mazewidth" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_MAZE_WIDTH" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["mediumandsmall"] = {
                "description" : "Medium and Small" ,
                "porder" : 12 ,
                "mascontinentsize" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_MAS_CONTINENTS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "islandsize" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISLANDS_SIZE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "islandoverlap" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISLAND_OVERLAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["pangaea"] = {
                "description" : "Pangaea" ,
                "porder" : 13 ,
                "shoreline" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_SHORELINE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["ring"] = {
                "description" : "Ring" ,
                "porder" : 14 ,
                "areaperplayer" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_AREAS_PER_PLAYER" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landshape" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_LAND_SHAPE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "neutralter" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_NEUTRAL_TERRITORY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "isthmuswidth" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_ISTHMUS_WIDTH" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 5 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["shuffle"] = {
                "description" : "Shuffle" ,
                "porder" : 15 ,
                "waterper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [60, 85] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_MAPS_WATER_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["tectonics"] = {
                "description" : "Tectonics" ,
                "porder" : 16 ,
                "teclandmass" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 8 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_TECTONICS_LANDMASS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "tecaridity" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_TECTONICS_ARIDITY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["terra"] = {
                "description" : "Terra" ,
                "porder" : 17 ,
                "wrap" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startterra" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START_TERRA" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitMaps["wheel"] = {
                "description" : "Wheel" ,
                "porder" : 18 ,
                "areaperplayer" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_AREAS_PER_PLAYER" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landshape" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_LAND_SHAPE" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "ringwidth" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_RING_WIDTH" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "spokewidth" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_SPOKE_WIDTH" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "wrap" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_WRAP" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "start" : {
                        "porder"    : 5 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_MAPS_START" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        valueLimits["maps"] = dict(limitMaps)

        # set the terrain settings
        limitTerrain = {}
        limitTerrain["porder"] = 1
        limitTerrain["terrains"] = {
                "description" : getSMenuText("TXT_TERRAIN_DES") ,
                "porder" : 0 ,
                "grass" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_TERRAIN_GRASS" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "plains" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 4 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_TERRAIN_PLAIN" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "desert" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_TERRAIN_DESERT" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "tundra" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_TERRAIN_TUNDRA" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "snow" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : 5 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_TERRAIN_SNOW" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitTerrain["forest"] = {
                "description" : getSMenuText("TXT_TERRAIN_FOREST") ,
                "porder" : 1 ,
                "forestpercent" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0,100] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_TERRAIN_FOREST_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitTerrain["jungle"] = {
                "description" : getSMenuText("TXT_TERRAIN_JUNGLE") ,
                "porder" : 2 ,
                "junglepercent" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0,100] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_TERRAIN_JUNGLE_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : ["TXT_TERRAIN_TIP_JUNGLE", (copy.deepcopy(defSel["terrain"]["jungle"]["junglepercent"][0]),)] ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitTerrain["peak"] = {
                "description" : getSMenuText("TXT_TERRAIN_PEAK") ,
                "porder" : 3 ,
                "peakpercent" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0,15] ,
                        "drawfunc"  : "StandardValueRandomFloat" ,
                        "txttag"    : "TXT_TERRAIN_PEAK_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "peakcoast" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_TERRAIN_PEAKCOAST" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitTerrain["hill"] = {
                "description" : getSMenuText("TXT_TERRAIN_HILL") ,
                "porder" : 4 ,
                "hillpercent" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [5,50] ,
                        "drawfunc"  : "StandardValueRandom" ,
                        "txttag"    : "TXT_TERRAIN_HILL_PERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitTerrain["river"] = {
                "description" : getSMenuText("TXT_TERRAIN_RIVER") ,
                "porder" : 5 ,
                "riveredge" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [1, int(gc.getDefineINT("PLOTS_PER_RIVER_EDGE"))+4] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_TERRAIN_RIVEREDGE" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : ["TXT_TERRAIN_TIP_RIVEREDGE", (copy.deepcopy(defSel["terrain"]["river"]["riveredge"][0]),)] ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        iOasis = gc.getInfoTypeForString("FEATURE_OASIS")
        if iOasis != -1 :
                limitTerrain["oasis"] = {
                        "description" : getSMenuText("TXT_TERRAIN_OASIS") ,
                        "porder" : 6 ,
                        "oasispercent" : {
                                "porder"    : 0 ,
                                "parent"    : "" ,
                                "limit"     : [0,50] ,
                                "drawfunc"  : "ValueRandom" ,
                                "txttag"    : "TXT_TERRAIN_OASIS_PERCENT" ,
                                "cbfunc"    : "Sto_Value_Random" ,
                                "tooltip"   : "" ,
                                "listitem"  : None ,
                                "listcomp"  : None ,
                                "nbperline" : None
                                }
                        }
        iIce = gc.getInfoTypeForString("FEATURE_ICE")
        if iIce != -1 :
                limitTerrain["ice"] = {
                        "description" : getSMenuText("TXT_TERRAIN_ICE") ,
                        "porder" : 7 ,
                        "iceremove" : {
                                "porder"    : 0 ,
                                "parent"    : "" ,
                                "limit"     : 3 ,
                                "drawfunc"  : "SelectionRB" ,
                                "txttag"    : "TXT_TERRAIN_ICE" ,
                                "cbfunc"    : "Sto_Selection_MultiRB" ,
                                "tooltip"   : "" ,
                                "listitem"  : None ,
                                "listcomp"  : None ,
                                "nbperline" : None
                                }
                        }
        iGoodyHut = gc.getInfoTypeForString("IMPROVEMENT_GOODY_HUT")
        if iGoodyHut != -1 :
                goodyper = gc.getImprovementInfo(iGoodyHut).getTilesPerGoody()
                if goodyper > 0 :
                        limitTerrain["goodyhut"] = {
                                "description" : getSMenuText("TXT_TERRAIN_GOODY_HUT") ,
                                "porder" : 8 ,
                                "goodypercent" : {
                                        "porder"    : 0 ,
                                        "parent"    : "" ,
                                        "limit"     : [0,20] ,
                                        "drawfunc"  : "ValueRandomFloat" ,
                                        "txttag"    : "TXT_TERRAIN_GOODY_PERCENT" ,
                                        "cbfunc"    : "Sto_Value_Random" ,
                                        "tooltip"   : "" ,
                                        "listitem"  : None ,
                                        "listcomp"  : None ,
                                        "nbperline" : None
                                        }
                                }
        limitTerrain["island"] = {
                "description" : getSMenuText("TXT_TERRAIN_ISLAND") ,
                "porder" : 9 ,
                "nbtilesminisland" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [1,7] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_TERRAIN_NBTILESMIN" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : ["TXT_TERRAIN_TIP_NBTILESMIN", ""] ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        valueLimits["terrain"] = dict(limitTerrain)

        # set the resources settings
        limitResources = {}
        limitResources["porder"] = 2
        limitResources["resourcesgen"]={
                "description" : getSMenuText("TXT_RESOURCES_RESGEN") ,
                "porder" : 0 ,
                "erasedefres" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_RESOURCES_ERASE_DEF_RES" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landpercent" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : [5,50] ,
                        "drawfunc"  : "StandardValueRandom" ,
                        "txttag"    : "TXT_RESOURCES_LANDPERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landprop" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : [[0, 100], [0, 100], [0, 100]] ,
                        "drawfunc"  : "MultiValues" ,
                        "txttag"    : "TXT_RESOURCES_LANDPROP" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "waterpercent" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : [5,50] ,
                        "drawfunc"  : "StandardValueRandom" ,
                        "txttag"    : "TXT_RESOURCES_WATPERCENT" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "waterprop" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : [[0, 100], [0, 100], [0, 100]] ,
                        "drawfunc"  : "MultiValues" ,
                        "txttag"    : "TXT_RESOURCES_WATERPROP" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "standardgen" : {
                        "porder"    : 5 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "standardgen" ,
                        "txttag"    : "TXT_RESOURCES_STANDARDFOR" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["reslist"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "groupres" : {
                        "porder"    : 6 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "standardgen" ,
                        "txttag"    : "TXT_RESOURCES_GROUPRES" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["reslist"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "resspreadclimate" : {
                        "porder"    : 7 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_RESOURCES_SPREAD_CLIMATE" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "resspreadlake" : {
                        "porder"    : 8 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_RESOURCES_SPREAD_LAKES" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "resmultiply" : {
                        "porder"    : 9 ,
                        "parent"    : "" ,
                        "limit"     : [1,20] ,
                        "drawfunc"  : "resmultiply" ,
                        "txttag"    : "TXT_RESOURCES_RESMULTIPLY" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : copy.deepcopy(XMLEntriesList["reslist"]) + ["allstrat", "allhealth", "allhapp"] ,
                        "nbperline" : None
                        }
                }
        limitResources["resourcesstart"]={
                "description" : getSMenuText("TXT_RESOURCES_RESSTART") ,
                "porder" : 1 ,
                "removestartres" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_RESOURCES_START_REMOVE" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "strategicnorandom" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_RESOURCES_STRAT_NORANDOM" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["strategic"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "healthnorandom" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_RESOURCES_HEALTH_NORANDOM" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["health"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "happinessnorandom" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_RESOURCES_HAPPINESS_NORANDOM" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["happiness"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "startresselect" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "startresselect" ,
                        "txttag"    : "TXT_RESOURCES_START_RES" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : copy.deepcopy(XMLEntriesList["reslist"]) + ["allstratsame", "allstratdiff", "allhealthsame", "allhealthdiff", "allhappsame", "allhappdiff"] ,
                        "nbperline" : None
                        } ,
                "startresquantity" : {
                        "porder"    : 1 ,
                        "parent"    : "startresselect" ,
                        "limit"     : [1,25] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_QUANTITY" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startreslocation" : {
                        "porder"    : 2 ,
                        "parent"    : "startresselect" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_RESOURCES_START_LOCATION" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startresforce" : {
                        "porder"    : 3 ,
                        "parent"    : "startresselect" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_RESOURCES_START_FORCE" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startresplayer" : {
                        "porder"    : 4 ,
                        "parent"    : "startresselect" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_PLAYER_APPLY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        valueLimits["resources"] = dict(limitResources)

        # set the start location settings
        limitStart = {}
        limitStart["porder"] = 3
        limitStart["normalize"] = {
                "description" : getSMenuText("TXT_STARTLOCS_NORMALIZE") ,
                "porder" : 0 ,
                "startplot" : {
                        "porder"    : 0 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_START" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "addriver" : {
                        "porder"    : 1 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_RIVER" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "removepeak" : {
                        "porder"    : 2 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_PEAK" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "addlake" : {
                        "porder"    : 3 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_LAKE" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "removebadfeature" : {
                        "porder"    : 4 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_BADFEAT" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "removebadterrain" : {
                        "porder"    : 5 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_BADTER" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "addfoodbonus" : {
                        "porder"    : 6 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_FOODBONUS" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "addgoodterrain" : {
                        "porder"    : 7 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_GOODTER" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "addextra" : {
                        "porder"    : 8 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_EXTRA" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startsametile" : {
                        "porder"    : 9 ,
                        "parent"    : None ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_STARTLOCS_NORM_SAMETILE" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitStart["relocate"] = {
                "description" : getSMenuText("TXT_STARTLOCS_RELOCATE") ,
                "porder" : 1 ,
                "swaphuman" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_STARTLOCS_SWAPHUMANS" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "isolatehuman" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_STARTLOCS_ISOLATEHUMANS" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        valueLimits["startlocs"] = dict(limitStart)

        # set the games settings
        limitGame = {}
        limitGame["porder"] = 4
        limitGame["log"] = {
                "description" : getSMenuText("TXT_GAME_LOG_FILE") ,
                "porder" : 0 ,
                "writelog" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_GAME_LOG_WRITE" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["barbcities"] = {
                "description" : getSMenuText("TXT_GAME_BARB_CITIES") ,
                "porder" : 1 ,
                "cityper" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0, 100] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_GAME_BARB_CITYPER" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "citybuilding" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_GAME_CITYBUILD" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["buildingsbarb"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "barbbarbrange" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : [5, 30] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_BARBAR_RANGE" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "barbhumrange" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : [5, 30] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_BARHUM_RANGE" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "defender" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "defender" ,
                        "txttag"    : "TXT_GAME_BAR_DEFENDER" ,
                        "cbfunc"    : "Sto_Defender" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : copy.deepcopy(XMLEntriesList["units"]["barbdefender"]) + copy.deepcopy(XMLEntriesList["units"]["barbfight"]) ,
                        "nbperline" : None
                        } ,
                "nbdefender" : {
                        "porder"    : 5 ,
                        "parent"    : "" ,
                        "limit"     : [0, 20] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_QUANTITY" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "xpdefender" : {
                        "porder"    : 6 ,
                        "parent"    : "" ,
                        "limit"     : [0, 1000] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_XP" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "nbtilesminisland" : {
                        "porder"    : 7 ,
                        "parent"    : "" ,
                        "limit"     : [1,15] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_TERRAIN_NBTILESMIN" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["animals"] = {
                "description" : getSMenuText("TXT_GAME_ANIMALS") ,
                "porder" : 2 ,
                "animalspercent" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0, 40] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_GAME_ANIMPER" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "animalsnoplace" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_GAME_ANIMNOTPLACED" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["units"]["animland"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "animunitrange" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : [2, 15] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_ANIMUNIT_RANGE" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "xpanimals" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : [0, 1000] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_XP" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "nbtilesminisland" : {
                        "porder"    : 4 ,
                        "parent"    : "" ,
                        "limit"     : [1,15] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_TERRAIN_NBTILESMIN" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["gold"] = {
                "description" : getSMenuText("TXT_GAME_GOLD") ,
                "porder" : 3 ,
                "gold" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0, 10000] ,
                        "drawfunc"  : "ValueRandom" ,
                        "txttag"    : "TXT_GAME_GOLD" ,
                        "cbfunc"    : "Sto_Value_Random" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "goldplayers" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_PLAYER_APPLY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["reveal"] = {
                "description" : getSMenuText("TXT_GAME_REVEAL") ,
                "porder" : 4 ,
                "startrange" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : [0, 50] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_REVEAL_STARTRANGE" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "seareveal" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_GAME_SEAREVEAL" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "landreveal" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_GAME_LANDREVEAL" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startlocs" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectOne" ,
                        "txttag"    : "TXT_GAME_STARTREVEAL" ,
                        "cbfunc"    : "Sto_Selection_OneCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["techno"] = {
                "description" : getSMenuText("TXT_GAME_TECHNOS") ,
                "porder" : 5 ,
                "starttechs" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_GAME_STARTTECH" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "technoreplace" : {
                        "porder"    : 1 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_GAME_TECH_NOREPLACE" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["techsstartciv"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "technorandom" : {
                        "porder"    : 2 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "SelectionSpecial" ,
                        "txttag"    : "TXT_GAME_TECH_NORANDOM" ,
                        "cbfunc"    : "Sto_Selection_Special" ,
                        "tooltip"   : "" ,
                        "listitem"  : copy.deepcopy(XMLEntriesList["techslist"]) ,
                        "listcomp"  : None ,
                        "nbperline" : 6
                        } ,
                "addtech" : {
                        "porder"    : 3 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "addtech" ,
                        "txttag"    : "TXT_GAME_ADDTECH" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : copy.deepcopy(XMLEntriesList["techslist"]) + ["alltechsame", "alltechdiff"] ,
                        "nbperline" : None
                        } ,
                "techquantity" : {
                        "porder"    : 1 ,
                        "parent"    : "addtech" ,
                        "limit"     : [1, 15] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_QUANTITY" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "techplayers" : {
                        "porder"    : 2 ,
                        "parent"    : "addtech" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_PLAYER_APPLY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        limitGame["startunit"] = {
                "description" : getSMenuText("TXT_GAME_UNITS") ,
                "porder" : 6 ,
                "startunitselect" : {
                        "porder"    : 0 ,
                        "parent"    : "" ,
                        "limit"     : None ,
                        "drawfunc"  : "startunitselect" ,
                        "txttag"    : "TXT_GAME_ADDUNIT" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : copy.deepcopy(XMLEntriesList["units"]["list"]) ,
                        "nbperline" : None
                        } ,
                "startunittype" : {
                        "porder"    : 1 ,
                        "parent"    : "startunitselect" ,
                        "limit"     : 3 ,
                        "drawfunc"  : "SelectionRB" ,
                        "txttag"    : "TXT_GAME_UNIT_TYPE" ,
                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startunitquantity" : {
                        "porder"    : 2 ,
                        "parent"    : "startunitselect" ,
                        "limit"     : [1, 30] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_QUANTITY" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startunitxp" : {
                        "porder"    : 3 ,
                        "parent"    : "startunitselect" ,
                        "limit"     : [0, 1000] ,
                        "drawfunc"  : "Value" ,
                        "txttag"    : "TXT_GAME_XP" ,
                        "cbfunc"    : "Sto_DummyCallback" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        } ,
                "startunitplayers" : {
                        "porder"    : 4 ,
                        "parent"    : "startunitselect" ,
                        "limit"     : 2 ,
                        "drawfunc"  : "Selection" ,
                        "txttag"    : "TXT_PLAYER_APPLY" ,
                        "cbfunc"    : "Sto_Selection_MultiCB" ,
                        "tooltip"   : "" ,
                        "listitem"  : None ,
                        "listcomp"  : None ,
                        "nbperline" : None
                        }
                }
        valueLimits["game"] = dict(limitGame)

        # set the FfH2 settings
        if is_BtS_FFH2 :
                if (len(XMLEntriesList["lairs"]) > 0) or (len(XMLEntriesList["uniqueimprovements"]) > 0) :
                        limitFFH2 = {}
                        limitFFH2["porder"] = 5

                        if (len(XMLEntriesList["lairs"]) > 0) :

                                limitFFH2["lairs"] = {
                                        "description" : getSMenuText("TXT_FFH2_LAIRS") ,
                                        "porder" : 0 ,
                                        "mindistlairstart" : {
                                                "porder"    : 0 ,
                                                "parent"    : "" ,
                                                "limit"     : [1, 6] ,
                                                "drawfunc"  : "Value" ,
                                                "txttag"    : "TXT_FFH2_MINSTARTDIST" ,
                                                "cbfunc"    : "Sto_DummyCallback" ,
                                                "tooltip"   : "" ,
                                                "listitem"  : None ,
                                                "listcomp"  : None ,
                                                "nbperline" : None
                                                }
                                        }

                                iOrder = 1
                                for sType in XMLEntriesList["lairs"] :

                                        sText = str(copy.copy(XMLDescriptions[sType]))

                                        if (parsedXMLValuesEntries[sType]["SpawnUnitType"] != "") or (parsedXMLValuesEntries[sType]["BonusConvert"] != "") :
                                                sText += " "
                                        if parsedXMLValuesEntries[sType]["SpawnUnitType"] != "" :
                                                sDescr = XMLDescriptions[parsedXMLValuesEntries[sType]["SpawnUnitType"]]
                                                if "(" in sDescr : sDescr = sDescr[0:sDescr.index("(")]
                                                if sDescr[-1] == "" : sDescr = sDescr[0:-1]
                                                sText += "(%s)" %sDescr
                                        if parsedXMLValuesEntries[sType]["BonusConvert"] != "" :
                                                sText += "(%s)" %(XMLDescriptions[parsedXMLValuesEntries[sType]["BonusConvert"]], )
                                        sText += " :"

                                        limitFFH2["lairs"][getTypeForm(sType)] = {
                                                "porder"    : int(iOrder) ,
                                                "parent"    : "" ,
                                                "limit"     : [0, 20] ,
                                                "drawfunc"  : "StandardValueRandomFloat" ,
                                                "txttag"    : str(sText) ,
                                                "cbfunc"    : "Sto_Value_Random" ,
                                                "tooltip"   : "" ,
                                                "listitem"  : None ,
                                                "listcomp"  : None ,
                                                "nbperline" : None
                                                }

                                        iOrder += 1

                        if (len(XMLEntriesList["uniqueimprovements"]) > 0) :

                                limitFFH2["uniqueimprovements"] = {
                                        "description" : getSMenuText("TXT_FFH2_UNIQUEIMPROVEMENTS") ,
                                        "porder" : 1 ,
                                        "mindistuniquestart" : {
                                                "porder"    : 0 ,
                                                "parent"    : "" ,
                                                "limit"     : [1, 10] ,
                                                "drawfunc"  : "Value" ,
                                                "txttag"    : "TXT_FFH2_MINSTARTDIST" ,
                                                "cbfunc"    : "Sto_DummyCallback" ,
                                                "tooltip"   : "" ,
                                                "listitem"  : None ,
                                                "listcomp"  : None ,
                                                "nbperline" : None
                                                }
                                        }

                                iOrder = 1
                                for sType in XMLEntriesList["uniqueimprovements"] :

                                        sText = str(copy.copy(XMLDescriptions[sType]))

                                        if (parsedXMLValuesEntries[sType]["SpawnUnitType"] != "") or (parsedXMLValuesEntries[sType]["BonusConvert"] != "") :
                                                sText += " "
                                        if parsedXMLValuesEntries[sType]["SpawnUnitType"] != "" :
                                                sDescr = XMLDescriptions[parsedXMLValuesEntries[sType]["SpawnUnitType"]]
                                                if "(" in sDescr : sDescr = sDescr[0:sDescr.index("(")]
                                                if sDescr[-1] == "" : sDescr = sDescr[0:-1]
                                                sText += "(%s)" %sDescr
                                        if parsedXMLValuesEntries[sType]["BonusConvert"] != "" :
                                                sText += "(%s)" %(XMLDescriptions[parsedXMLValuesEntries[sType]["BonusConvert"]], )
                                        sText += " :"

                                        limitFFH2["uniqueimprovements"][getTypeForm(sType)] = {
                                                "porder"    : int(iOrder) ,
                                                "parent"    : "" ,
                                                "limit"     : [0, 100] ,
                                                "drawfunc"  : "StandardValueRandom" ,
                                                "txttag"    : str(sText) ,
                                                "cbfunc"    : "Sto_Value_Random" ,
                                                "tooltip"   : "" ,
                                                "listitem"  : None ,
                                                "listcomp"  : None ,
                                                "nbperline" : None
                                                }

                                        iOrder += 1

                                        if (parsedXMLValuesEntries[sType]["SpawnUnitType"] != "")  or (sType == "IMPROVEMENT_PYRE_OF_THE_SERAPHIC") :
                                                limitFFH2["uniqueimprovements"][getTypeForm(sType) + "placement"] = {
                                                        "porder"    : int(iOrder) ,
                                                        "parent"    : "" ,
                                                        "limit"     : 3 ,
                                                        "drawfunc"  : "SelectionRB" ,
                                                        "txttag"    : "TXT_FFH2_PLACEMENT" ,
                                                        "cbfunc"    : "Sto_Selection_MultiRB" ,
                                                        "tooltip"   : "" ,
                                                        "listitem"  : None ,
                                                        "listcomp"  : None ,
                                                        "nbperline" : None
                                                        }

                                                iOrder += 1

                        valueLimits["ffh2"] = dict(limitFFH2)

# check that all entries are used in the current version and add/remove settings if running a version with different options .
def checkSettings(settingsEntry):

        settings = copy.deepcopy(settingsEntry)

        for sBase in settings.keys() :
                if not sBase in defSel.keys() :
                        del(settings[sBase])
                        continue
                for sOption1 in settings[sBase].keys() :
                        if not sOption1 in defSel[sBase].keys() :
                                del(settings[sBase][sOption1])
                                continue
                        for sOption2 in settings[sBase][sOption1].keys() :
                                if sOption2 == "selected" : continue
                                #remove settings that should not be present in the dict
                                if "-" in sOption2 :
                                        baseTag, iIndex = splitTag(sOption2)
                                        if not "%s-0" %baseTag in defSel[sBase][sOption1].keys() :
                                                del(settings[sBase][sOption1][sOption2])
                                                continue
                                else :
                                        if not sOption2 in defSel[sBase][sOption1].keys() :
                                                del(settings[sBase][sOption1][sOption2])
                                                continue
                                        baseTag = str(sOption2)
                                        iIndex = -1
                                #check the log option if it's still valid .
                                if baseTag == "writelog" :
                                        if (settings[sBase][sOption1][baseTag]) and (not bCanWriteLog) :
                                                settings[sBase][sOption1][baseTag] = False
                                        elif (not settings[sBase][sOption1][baseTag]) and (not isGameMP) :
                                                settings[sBase][sOption1][baseTag] = True

                                #check entries type and limits
                                drawFunction = valueLimits[sBase][sOption1][baseTag]["drawfunc"]
                                val = copy.deepcopy(settings[sBase][sOption1][sOption2])
                                valLim = copy.deepcopy(valueLimits[sBase][sOption1][baseTag]["limit"])
                                bValid = True

                                if drawFunction == "Selection" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        else :
                                                for item in val :
                                                        if not item in range(valLim):
                                                                settings[sBase][sOption1][sOption2].remove(item)
                                                if settings[sBase][sOption1][sOption2] == [] :
                                                        bValid = False
                                elif drawFunction == "ValueRandom" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        elif (len(val) == 0) or (len(val) > 2) :
                                                bValid = False
                                        else :
                                                for item in val :
                                                        if not type(item) is types.IntType :
                                                                bValid = False
                                        if bValid :
                                                if len(val) == 2 :
                                                        if val[0] >= val[1] :
                                                                bValid = False
                                                minVal, maxVal = valLim
                                                for item in val :
                                                        if minVal > item :
                                                                bValid = False
                                                        if maxVal < item :
                                                                bValid = False
                                elif drawFunction == "ValueRandomFloat" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        elif (len(val) == 0) or (len(val) > 2) :
                                                bValid = False
                                        else :
                                                for item in val :
                                                        if not ((type(item) is types.IntType) or (type(item) is types.FloatType)):
                                                                bValid = False
                                        if bValid :
                                                if len(val) == 2 :
                                                        if val[0] >= val[1] :
                                                                bValid = False
                                                minVal, maxVal = valLim
                                                for item in val :
                                                        if minVal > item :
                                                                bValid = False
                                                        if maxVal < item :
                                                                bValid = False
                                elif drawFunction == "SelectOne" :
                                        if not type(val) is types.BooleanType :
                                                bValid = False
                                elif drawFunction == "SelectionRB" :
                                        if not type(val) is types.IntType :
                                                bValid = False
                                        elif not ((val >= 0) and (val < valLim)) :
                                                bValid = False
                                elif drawFunction == "Value" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        elif len(val) != 1 :
                                                bValid = False
                                        elif not type(val[0]) is types.IntType :
                                                bValid = False
                                        else :
                                                minVal, maxVal = valLim
                                                if minVal > val[0] :
                                                        bValid = False
                                                if maxVal < val[0] :
                                                        bValid = False
                                elif drawFunction == "StandardValueRandom" :
                                        if val != "standard" :
                                                if not type(val) is types.ListType :
                                                        bValid = False
                                                elif (len(val) == 0) or (len(val) > 2) :
                                                        bValid = False
                                                else :
                                                        for item in val :
                                                                if not type(item) is types.IntType :
                                                                        bValid = False
                                                if bValid :
                                                        if len(val) == 2 :
                                                                if val[0] >= val[1] :
                                                                        bValid = False
                                                        minVal, maxVal = valLim
                                                        for item in val :
                                                                if minVal > item :
                                                                        bValid = False
                                                                if maxVal < item :
                                                                        bValid = False
                                elif drawFunction == "StandardValueRandomFloat" :
                                        if val != "standard" :
                                                if not type(val) is types.ListType :
                                                        bValid = False
                                                elif (len(val) == 0) or (len(val) > 2) :
                                                        bValid = False
                                                else :
                                                        for item in val :
                                                                if not ((type(item) is types.IntType) or (type(item) is types.FloatType)):
                                                                        bValid = False
                                                if bValid :
                                                        if len(val) == 2 :
                                                                if val[0] >= val[1] :
                                                                        bValid = False
                                                        minVal, maxVal = valLim
                                                        for item in val :
                                                                if minVal > item :
                                                                        bValid = False
                                                                if maxVal < item :
                                                                        bValid = False
                                elif drawFunction == "MultiValues" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        elif len(val) != len(valLim) :
                                                bValid = False
                                        else :
                                                for item in val :
                                                        if not type(item) is types.IntType :
                                                                bValid = False
                                        if bValid :
                                                for i in range(len(valLim)) :
                                                        minVal, maxVal = valLim[i]
                                                        if minVal > val[i] :
                                                                bValid = False
                                                        if maxVal < val[i] :
                                                                bValid = False
                                elif drawFunction in ["standardgen", "SelectionSpecial"] :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        else :
                                                for item in val :
                                                        if not item in valueLimits[sBase][sOption1][baseTag]["listitem"]:
                                                                settings[sBase][sOption1][sOption2].remove(item)
                                elif drawFunction in ["startresselect", "defender", "addtech", "startunitselect"] :
                                        if type(val) is types.StringType :
                                                if not val in valueLimits[sBase][sOption1][baseTag]["listcomp"] :
                                                        bValid = False
                                        elif type(val) is types.ListType :
                                                if len(val) == 0 :
                                                        pass
                                                elif len(val) != 1 :
                                                        bValid = False
                                                elif not val[0] in valueLimits[sBase][sOption1][baseTag]["listcomp"] :
                                                        settings[sBase][sOption1][sOption2] = []
                                        else :
                                                bValid = False
                                elif drawFunction == "resmultiply" :
                                        if not type(val) is types.ListType :
                                                bValid = False
                                        elif len(val) != 2 :
                                                bValid = False
                                        else :
                                                if type(val[0]) is types.StringType :
                                                        if not val[0] in valueLimits[sBase][sOption1][baseTag]["listcomp"] :
                                                                bValid = False
                                                elif type(val[0]) is types.ListType :
                                                        if len(val[0]) == 0 :
                                                                pass
                                                        elif len(val[0]) != 1 :
                                                                bValid = False
                                                        elif not val[0][0] in valueLimits[sBase][sOption1][baseTag]["listcomp"] :
                                                                settings[sBase][sOption1][sOption2][0] = []
                                                else :
                                                        bValid = False

                                                minVal, maxVal = valLim
                                                if not ((type(val[1]) is types.IntType) or (type(val[1]) is types.FloatType)):
                                                        bValid = False
                                                elif minVal > val[1] :
                                                        bValid = False
                                                elif maxVal < val[1] :
                                                        bValid = False
                                else :
                                        #oups! where's my mind ?
                                        #you can ask yourself if someone that listen the pixies CAN listen the miss (dubitative)
                                        writeLog("", False, [" %s, %s, %s, %s function not recognized in check settings" %(sBase, sOption1, sOption2, drawFunction), ""])

                                if not bValid :
                                        writeLog("", False, [" %s, %s, %s, %s : %r . function not valid in check settings" %(sBase, sOption1, sOption2, drawFunction, val), ""])
                                        if iIndex == -1 :
                                                settings[sBase][sOption1][sOption2] = copy.deepcopy(defSel[sBase][sOption1][sOption2])
                                        else :
                                                settings[sBase][sOption1][sOption2] = copy.deepcopy(defSel[sBase][sOption1]["%s-0" %baseTag])

        # add the settings not present in the selection , assigned to the default value
        for sBase in defSel.keys() :
                if not sBase in settings.keys() :
                        settings[sBase] = copy.deepcopy(defSel[sBase])
                        continue
                for sOption1 in defSel[sBase].keys() :
                        if not sOption1 in settings[sBase].keys() :
                                settings[sBase][sOption1] = copy.deepcopy(defSel[sBase][sOption1])
                                continue
                        for sOption2 in defSel[sBase][sOption1].keys() :
                                if not sOption2 in settings[sBase][sOption1].keys() :
                                        settings[sBase][sOption1][sOption2] = copy.deepcopy(defSel[sBase][sOption1][sOption2])

        # add the settings not present in the selection for the multiboxes in case an option has been added , assigned to the default value
        for sBase in defSel.keys() :
                for sOption1 in defSel[sBase].keys() :
                        for sOption2 in defSel[sBase][sOption1].keys() :
                                if "-" in sOption2 :
                                        baseTag, iIndex = splitTag(sOption2)
                                        parentTag = valueLimits[sBase][sOption1][baseTag]["parent"]
                                        if parentTag == "" : continue

                                        listKeys = settings[sBase][sOption1].keys()
                                        for sOptionLoop in listKeys :
                                                if not "-" in sOptionLoop : continue
                                                baseTagLoop, iIndexLoop = splitTag(sOptionLoop)
                                                if baseTagLoop != parentTag : continue

                                                tagLoop = "%s-%d" %(baseTag, iIndexLoop)
                                                if not tagLoop in listKeys :
                                                        settings[sBase][sOption1][tagLoop] = copy.deepcopy(defSel[sBase][sOption1]["%s-0" %baseTag])

        return settings

# when exiting or redraw the screen sort and select the non empty multi boxes :
def sortMultiBox():
        global selection

        buffValues = dict(getParents())
        for parentTag in buffValues.keys() :
                buffValues[parentTag]["parentdict"] = {}

        for optionTag0 in selection.keys() :
                for optionTag1 in selection[optionTag0].keys() :
                        for optionTag2 in selection[optionTag0][optionTag1].keys() :
                                if "-" in optionTag2 :
                                        baseTag, iIndex = splitTag(optionTag2)
                                        parentTag = valueLimits[optionTag0][optionTag1][baseTag]["parent"]
                                        if parentTag == "" :
                                                buffValues[baseTag]["parentdict"][iIndex] = copy.deepcopy(selection[optionTag0][optionTag1][optionTag2])
                                        else :
                                                buffValues[parentTag][optionTag2] = copy.deepcopy(selection[optionTag0][optionTag1][optionTag2])
                                        del(selection[optionTag0][optionTag1][optionTag2])

        for parentTag in buffValues.keys() :
                optionTag0 = buffValues[parentTag]["tag0"]
                optionTag1 = buffValues[parentTag]["tag1"]
                defVal = copy.deepcopy(defSel[optionTag0][optionTag1]["%s-0" %parentTag])

                index = 0
                listIndex = buffValues[parentTag]["parentdict"].keys()
                listIndex.sort()

                listChildrens = getChildrens(optionTag0, optionTag1, parentTag)

                for iIndex in listIndex :
                        bCopy = True
                        if type(defVal) is types.ListType :
                                if len(defVal) > 1 :
                                        if buffValues[parentTag]["parentdict"][iIndex][0] == [] :
                                                bCopy = False
                                else :
                                        if buffValues[parentTag]["parentdict"][iIndex] == [] :
                                                bCopy = False

                        if bCopy :
                                selection[optionTag0][optionTag1]["%s-%d" %(parentTag, index)] = copy.deepcopy(buffValues[parentTag]["parentdict"][iIndex])
                                for childTag in listChildrens :
                                        selection[optionTag0][optionTag1]["%s-%d" %(childTag, index)] = copy.deepcopy(buffValues[parentTag]["%s-%d" %(childTag, iIndex)])
                                index += 1

                if index < 100 :
                        selection[optionTag0][optionTag1]["%s-%d" %(parentTag, index)] = copy.deepcopy(defVal)
                        for childTag in listChildrens :
                                selection[optionTag0][optionTag1]["%s-%d" %(childTag, index)] = copy.deepcopy(defSel[optionTag0][optionTag1]["%s-0" %childTag])

# function to keep a good order in the directory showing
def sortKeys(baseDict, key1 = "" , key2 = "") :
        if key1 == "" and key2 == "" :
                baseList = baseDict.keys()
                baseSort = [[valueLimits[key]["porder"], key] for key in baseList]
        elif key2 == "" :
                baseList = baseDict[key1].keys()
                baseSort = [[valueLimits[key1][key]["porder"], key] for key in baseList]
        else :
                baseList = baseDict[key1][key2].keys()
                baseSort = []
                for key in baseList :
                        if key == "selected" : continue
                        if "-" in key :
                                baseTag, iIndex = splitTag(key)
                                parentTag = valueLimits[key1][key2][baseTag]["parent"]
                                if parentTag != "" :
                                        iOrder = valueLimits[key1][key2][parentTag]["porder"] + iIndex + 0.01*valueLimits[key1][key2][baseTag]["porder"]
                                else :
                                        iOrder = iIndex + valueLimits[key1][key2][baseTag]["porder"]
                                baseSort.append([iOrder, key])
                        else :
                                baseSort.append([valueLimits[key1][key2][key]["porder"], key])
        baseSort.sort()
        result = [item[1] for item in baseSort]
        return result

def getChildrens(baseTag, optionTag1, parentTag):
        listChildren = []
        for optionTag2 in defSel[baseTag][optionTag1].keys():
                if "-" in optionTag2 :
                        baseTagLoop, iIndexLoop = splitTag(optionTag2)
                        if parentTag == valueLimits[baseTag][optionTag1][baseTagLoop]["parent"] :
                                listChildren.append([valueLimits[baseTag][optionTag1][baseTagLoop]["porder"], baseTagLoop])
        if len(listChildren) >1 :
                listChildren.sort()

        listChildren = [item[1] for item in listChildren]
        return listChildren

def getParents():
        dictParent = {}
        for optionTag0 in defSel.keys() :
                for optionTag1 in defSel[optionTag0].keys() :
                        for optionTag2 in defSel[optionTag0][optionTag1].keys() :
                                if "-" in optionTag2 :
                                        baseTag, iIndex = splitTag(optionTag2)
                                        parentTag = valueLimits[optionTag0][optionTag1][baseTag]["parent"]
                                        if parentTag == "" :
                                                dictParent[baseTag] = {}
                                                dictParent[baseTag]["tag0"] = optionTag0
                                                dictParent[baseTag]["tag1"] = optionTag1
        return dictParent

def splitTag(tag):
        head , tail = tag.split("-")
        return [head , int(tail)]

# when reset a tab , the multiboxes can't be deleted , so add some empty box to selection
def addEmptyMultiBox(tag = ""):
        try :
                dictParents = dict(getParents())
                for parentTag in dictParents.keys() :
                        optionTag0 = dictParents[parentTag]["tag0"]
                        if tag != "" :
                                if optionTag0 != tag :
                                        continue
                        optionTag1 = dictParents[parentTag]["tag1"]
                        listChildrens = getChildrens(optionTag0, optionTag1, parentTag)
                        for i in range(nbMultiBox[parentTag]) :
                                selection[optionTag0][optionTag1]["%s-%d" %(parentTag, i)] = copy.deepcopy(defSel[optionTag0][optionTag1]["%s-0" %parentTag])
                                for childTag in listChildrens :
                                        selection[optionTag0][optionTag1]["%s-%d" %(childTag, i)] = copy.deepcopy(defSel[optionTag0][optionTag1]["%s-0" %childTag])
        except :
                writeError()

# keep the number multibox in a global :
def initNbMultiBox():
        global nbMultiBox

        nbMultiBox = {}
        for parentTag in getParents().keys() : nbMultiBox[parentTag] = 0

# create the callBack functions to add in order to apply the menu entries
def getCallBackList():
        cbList = [
                ["Sto_DummyCallback", Sto_DummyCallback_Script] ,
                ["Sto_Apply_Language", Sto_Apply_Language_Script] ,
                ["Sto_Reset_All_Apply", Sto_Reset_All_Apply_Script] ,
                ["Sto_Reset_Table_Apply", Sto_Reset_Table_Apply_Script] ,
                ["Sto_Map_Selected", Sto_Map_Selected_Script] ,
                ["Sto_Selection_MultiCB", Sto_Selection_MultiCB_Script] ,
                ["Sto_Value_Random", Sto_Value_Random_Script] ,
                ["Sto_Reset_Option", Sto_Reset_Option_Script] ,
                ["Sto_Load_File", Sto_Load_File_Script] ,
                ["Sto_Load_File_Apply", Sto_Load_File_Apply_Script] ,
                ["Sto_Save_File", Sto_Save_File_Script] ,
                ["Sto_Save_File_Apply", Sto_Save_File_Apply_Script] ,
                ["Sto_SaveFile_EditBox", Sto_SaveFile_EditBox_Script] ,
                ["Sto_SaveFile_DropdownBox", Sto_SaveFile_DropdownBox_Script] ,
                ["Sto_Exit_Load_Screen", Sto_Exit_Load_Screen_Script] ,
                ["Sto_Exit_Apply", Sto_Exit_Apply_Script] ,
                ["Sto_Refresh_Apply", Sto_Refresh_Apply_Script] ,
                ["Sto_Selection_OneCB", Sto_Selection_OneCB_Script] ,
                ["Sto_Help_Option", Sto_Help_Option_Script] ,
                ["Sto_Selection_Special", Sto_Selection_Special_Script] ,
                ["Sto_Standard_For_All_Buttons", Sto_Standard_For_All_Buttons_Script] ,
                ["Sto_Select_ResMultiply", Sto_Select_ResMultiply_Script] ,
                ["Sto_Select_StartResource", Sto_Select_StartResource_Script] ,
                ["Sto_Selection_MultiRB", Sto_Selection_MultiRB_Script] ,
                ["Sto_Defender", Sto_Defender_Script] ,
                ["Sto_Select_Tech_Select", Sto_Select_Tech_Select_Script] ,
                ["Sto_Select_Unit_Select", Sto_Select_Unit_Select_Script] ,
                ["Sto_Open_Browser", Sto_Open_Browser_Script] ,
                ["Sto_Check_Update", Sto_Check_Update_Script]
                ]
        return cbList

def initScreenCallBack():
        callbackList = getCallBackList()
        for [ funcName , funcScript ] in callbackList : setattr(CvOptionsScreenCallbackInterface, funcName, funcScript)

def deleteScreenCallBack():
        callbackList = getCallBackList()
        for [ funcName , funcScript ] in callbackList : delattr(CvOptionsScreenCallbackInterface, funcName)

def getScreen():
        return CvScreensInterface.optionsScreen

def getTab():
        return CvScreensInterface.optionsScreen.getTabControl()

def destroyScreen():
        sortMultiBox()
        getTab().destroy()

# list of function to add to CvOptionsScreenCallbackInterface
def Sto_Select_Unit_Select_Script(argsList):
        try :
                global selection
                iValue, szName = argsList

                iValue = int(iValue)
                unitTag , rest = szName.split("*")
                dum, baseTag, gameID, optionID = rest.split("_")
                iIndex = int(optionID.split("-")[1])

                tab = getTab()

                if iValue == 0 : valSel = []
                else : valSel = [ str(XMLEntriesList["units"][unitTag][iValue-1]) ]

                listTag = ["peacedd", "landdd", "waterdd", "airdd", "otherdd", "national", "team", "world", "combatnone"]
                listTag += [item for item in XMLEntriesList["unitcombatlist"]]

                for uTag in listTag :
                        if XMLEntriesList["units"][uTag] == [] : continue

                        szWidgetName = "%s*UnitDropdown_%s_%s_%s" %(uTag, baseTag, gameID, optionID)

                        if len(valSel) == 1 :
                                unitType = valSel[0]
                                if unitType in XMLEntriesList["units"][uTag] : tab.setValue(szWidgetName, XMLEntriesList["units"][uTag].index(unitType)+1)
                                else : tab.setValue(szWidgetName, 0)
                        else :
                                tab.setValue(szWidgetName, 0)

                selection[baseTag][gameID][optionID] = valSel

                if (iValue != 0) and (iIndex == nbMultiBox["startunitselect"]-1) and (nbMultiBox["startunitselect"] <= 99):
                        selection[baseTag][gameID]["startunitselect-%d" %nbMultiBox["startunitselect"]] = copy.deepcopy(defSel[baseTag][gameID]["startunitselect-0"])
                        for childTag in getChildrens(baseTag, gameID, "startunitselect"):
                                selection[baseTag][gameID]["%s-%d" %(childTag, nbMultiBox["startunitselect"])] = copy.deepcopy(defSel[baseTag][gameID]["%s-0" %childTag])
                        getScreen().drawStartUnit()
        except :
                writeError()

        return 1

def Sto_Select_Tech_Select_Script(argsList):
        try :
                global selection
                iValue, szName = argsList

                iValue = int(iValue)
                typeElement , sIndex = szName.split("_")
                iIndex = int(sIndex)

                baseTag = "game"
                gameID = "techno"
                optionID = "addtech-%s" %sIndex
                tab = getTab()

                if iValue == 0 : valSel = []
                elif iValue == 1 : valSel = "alltechsame"
                elif iValue == 2 : valSel = "alltechdiff"
                else : valSel = [ str(XMLEntriesList["techslist"][iValue-3]) ]

                selection[baseTag][gameID][optionID] = valSel

                getScreen().checkEditBox()
                getScreen().refreshScreen()

                if (iValue != 0) and (iIndex == nbMultiBox["addtech"]-1) and (nbMultiBox["addtech"] <= 99):
                        selection[baseTag][gameID]["addtech-%d" %nbMultiBox["addtech"]] = copy.deepcopy(defSel[baseTag][gameID]["addtech-0"])
                        for childTag in getChildrens(baseTag, gameID, "addtech"):
                                selection[baseTag][gameID]["%s-%d" %(childTag, nbMultiBox["addtech"])] = copy.deepcopy(defSel[baseTag][gameID]["%s-0" %childTag])
                        getScreen().drawAddTech()
        except :
                writeError()

        return 1

def Sto_Defender_Script(argsList):
        try :
                global selection
                iValue, szName = argsList

                iValue = int(iValue)

                typeElement, baseTag, optionTag1, optionTag2 = szName.split("_")

                tab = getTab()

                if typeElement == "gameCityDef" :
                        if iValue == 0 : valSel = []
                        else : valSel = [ str(XMLEntriesList["units"]["barbdefender"][iValue-1]) ]

                        if XMLEntriesList["units"]["barbfight"] != [] :
                                szWidgetName = "gameCityFight_%s_%s_%s" %(baseTag, optionTag1, optionTag2)
                                tab.setValue(szWidgetName, 0)

                elif typeElement == "gameCityFight" :
                        if iValue == 0 : valSel = []
                        else : valSel = [ str(XMLEntriesList["units"]["barbfight"][iValue-1]) ]

                        if XMLEntriesList["units"]["barbdefender"] != [] :
                                szWidgetName = "gameCityDef_%s_%s_%s" %(baseTag, optionTag1, optionTag2)
                                tab.setValue(szWidgetName, 0)

                selection[baseTag][optionTag1][optionTag2] = valSel
        except :
                writeError()

        return 1

def Sto_Select_StartResource_Script(argsList):
        try :
                global selection
                iValue, szName = argsList

                iValue = int(iValue)
                typeElement , sIndex = szName.split("_")
                iIndex = int(sIndex)

                baseTag = "resources"
                resourceID = "resourcesstart"
                optionID = "startresselect-%s" %sIndex
                tab = getTab()

                if iValue == 0 :
                        valSel = []

                elif typeElement == "StratStartDropdown" :
                        if iValue == 1 : valSel = "allstratsame"
                        elif iValue == 2 : valSel = "allstratdiff"
                        else : valSel = [ str(XMLEntriesList["strategic"][iValue-3]) ]

                        tab.setValue("HealthStartDropdown_%s" %sIndex, 0)
                        tab.setValue("HappStartDropdown_%s" %sIndex, 0)

                elif typeElement == "HealthStartDropdown" :
                        if iValue == 1 : valSel = "allhealthsame"
                        elif iValue == 2 : valSel = "allhealthdiff"
                        else : valSel = [ str(XMLEntriesList["health"][iValue-3]) ]

                        tab.setValue("StratStartDropdown_%s" %sIndex, 0)
                        tab.setValue("HappStartDropdown_%s" %sIndex, 0)

                elif typeElement == "HappStartDropdown" :

                        if iValue == 1 : valSel = "allhappsame"
                        elif iValue == 2 : valSel = "allhappdiff"
                        else : valSel = [ str(XMLEntriesList["happiness"][iValue-3]) ]

                        tab.setValue("HealthStartDropdown_%s" %sIndex, 0)
                        tab.setValue("StratStartDropdown_%s" %sIndex, 0)

                selection[baseTag][resourceID][optionID] = valSel

                if (iValue != 0) and (iIndex == nbMultiBox["startresselect"]-1) and (nbMultiBox["startresselect"] <= 99):
                        selection[baseTag][resourceID]["startresselect-%d" %nbMultiBox["startresselect"]] = copy.deepcopy(defSel[baseTag][resourceID]["startresselect-0"])
                        for childTag in getChildrens(baseTag, resourceID, "startresselect"):
                                selection[baseTag][resourceID]["%s-%d" %(childTag, nbMultiBox["startresselect"])] = copy.deepcopy(defSel[baseTag][resourceID]["%s-0" %childTag])
                        getScreen().drawStartResources()
        except :
                writeError()

        return 1

def Sto_Select_ResMultiply_Script(argsList):
        try :
                global selection
                iValue, szName = argsList

                iValue = int(iValue)
                typeElement , sIndex = szName.split("_")
                iIndex = int(sIndex)

                baseTag = "resources"
                resourceID = "resourcesgen"
                optionID = "resmultiply-%s" %sIndex
                tab = getTab()

                if iValue == 0 :
                        valSel = []

                elif typeElement == "StratDropdown" :
                        if iValue == 1 : valSel = "allstrat"
                        else : valSel = [ str(XMLEntriesList["strategic"][iValue-2]) ]

                        tab.setValue("HealthDropdown_%s" %sIndex, 0)
                        tab.setValue("HappDropdown_%s" %sIndex, 0)

                elif typeElement == "HealthDropdown" :
                        if iValue == 1 : valSel = "allhealth"
                        else : valSel = [ str(XMLEntriesList["health"][iValue-2]) ]

                        tab.setValue("StratDropdown_%s" %sIndex, 0)
                        tab.setValue("HappDropdown_%s" %sIndex, 0)

                elif typeElement == "HappDropdown" :

                        if iValue == 1 : valSel = "allhapp"
                        else : valSel = [ str(XMLEntriesList["happiness"][iValue-2]) ]

                        tab.setValue("HealthDropdown_%s" %sIndex, 0)
                        tab.setValue("StratDropdown_%s" %sIndex, 0)

                selection[baseTag][resourceID][optionID][0] = valSel

                if (iValue != 0) and (iIndex == nbMultiBox["resmultiply"]-1) and (nbMultiBox["resmultiply"] <= 99):
                        selection[baseTag][resourceID]["resmultiply-%d" %nbMultiBox["resmultiply"]] = copy.deepcopy(defSel[baseTag][resourceID]["resmultiply-0"])
                        for childTag in getChildrens(baseTag, resourceID, "resmultiply"):
                                selection[baseTag][resourceID]["%s-%d" %(childTag, nbMultiBox["resmultiply"])] = copy.deepcopy(defSel[baseTag][resourceID]["%s-0" %childTag])
                        getScreen().drawMultiplyResources()
        except :
                writeError()

        return 1

def Sto_Standard_For_All_Buttons_Script(argsList):
        try :
                global selection
                szName = argsList[0]

                typeTag, baseTag, option1, option2 = szName.split("_")

                getScreen().checkEditBox() # before a reinit , check and save the edit box entries

                if typeTag == "AllStrat" : baseList = [item for item in XMLEntriesList["strategic"]]
                elif typeTag == "AllHealth" : baseList = [item for item in XMLEntriesList["health"]]
                elif typeTag == "AllHapp" : baseList = [item for item in XMLEntriesList["happiness"]]
                
                elementList = selection[baseTag][option1][option2]

                baseList.sort()
                tpList = [item for item in elementList if item in baseList ]
                tpList.sort()
                
                if tpList == baseList :
                        for elementType in baseList : selection[baseTag][option1][option2].remove(elementType)
                else :
                        for elementType in baseList :
                                if not elementType in elementList : selection[baseTag][option1][option2].append(elementType)

                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Check_Update_Script(argsList):
        try :
                urlFile = urllib.urlopen("http://forums.civfanatics.com/showthread.php?t=151629")
                lines = urlFile.readlines()
                urlFile.close()
                bFoundLine = False
                for line in lines :
                        if "##^^FoR_Current_Version : " in line :
                                part = line.split("##^^FoR_Current_Version : ")[1]
                                if "^^##" in part :
                                        bFoundLine = True
                                        sVersion = part[0:part.index("^^##")]
                                        try :
                                                if float(sVersion) > float(getVersion()) :
                                                        launchPopUP([["TXT_CHECK_UPDATE_TO_UPDATE", ""], ])
                                                else :
                                                        launchPopUP([["TXT_CHECK_UPDATE_OK", ""], ])
                                        except :
                                                launchPopUP([["TXT_CHECK_UPDATE_FAILED", ""], ])
                                                writeError()
                                break
                if not bFoundLine : launchPopUP([["TXT_CHECK_UPDATE_FAILED", ""], ])
        except :
                launchPopUP(launchPopUP([["TXT_CHECK_UPDATE_FAILED", ""], ]))
                writeError()

        return 1

def Sto_Open_Browser_Script(argsList):
        try :
                webbrowser.open("http://forums.civfanatics.com/showthread.php?t=151629", 1, 0)
        except :
                writeError()

        return 1

def Sto_Help_Option_Script(argsList):
        try :
                szName = argsList[0]

                baseID = szName.split("_")[1]
                optionID = szName.split("_")[2]

                if optionID == "resourcesgen" :
                        txtList = [["TXT_HELP_RESGEN01", ""], ["", ""], ["TXT_HELP_RESGEN0", ""], ["TXT_HELP_RESGEN1", ""], ["", ""], ["TXT_HELP_RESGEN2", ""], ["TXT_HELP_RESGEN3", ""],
                                   ["TXT_HELP_RESGEN4", ""], ["", ""], ["TXT_HELP_RESGEN5", (getSMenuText("TXT_RESOURCES_GROUPRES"),)], ["TXT_HELP_RESGEN6", ""], ["", ""],
                                   ["TXT_HELP_RESGEN7", ""], ["TXT_HELP_RESGEN8", ""], ["TXT_HELP_RESGEN9", ""]]
                        launchPopUP(txtList)
                elif optionID == "resourcesstart" :
                        txtList = [["TXT_HELP_RESSTART0", ""], ["TXT_HELP_RESSTART1", ""], ["TXT_HELP_RESSTART2", ""], ["", ""], ["TXT_HELP_RESSTART3", ""],
                                   ["TXT_HELP_RESSTART4", ""], ["TXT_HELP_RESSTART5", ""], ["TXT_HELP_RESSTART6", ""], ["", ""], ["TXT_HELP_RESSTART7", ""],
                                   ["TXT_HELP_RESSTART8", ""], ["TXT_HELP_RESSTART9", (getSMenuText("TXT_RESOURCES_START_FORCE_SEL0"),)], ["TXT_HELP_RESSTART10", (getSMenuText("TXT_RESOURCES_START_FORCE_SEL1"),)]]
                        launchPopUP(txtList)
                elif optionID == "barbcities" :
                        txtList = [["TXT_HELP_CITIES0", ""], ["TXT_HELP_CITIES1", ""], ["TXT_HELP_CITIES2", ""], ["TXT_HELP_CITIES3", ""],
                                   ["TXT_HELP_CITIES4", ""], ["TXT_HELP_CITIES5", ""]]
                        launchPopUP(txtList)
                elif optionID == "animals" :
                        txtList = [["TXT_HELP_ANIMAL0", ""], ["TXT_HELP_ANIMAL1", ""], ["TXT_HELP_ANIMAL2", ""]]
                        launchPopUP(txtList)
                elif optionID == "techno" :
                        txtList = [["TXT_HELP_TECH0", ""], ["TXT_HELP_TECH1", ""], ["TXT_HELP_TECH2", ""], ["TXT_HELP_TECH3", ""]]
                        launchPopUP(txtList)
                elif optionID == "startunit" :
                        txtList = [["TXT_HELP_UNIT0", ""], ["TXT_HELP_UNIT1", ""], ["", ""], ["TXT_HELP_UNIT2", (getSMenuText("TXT_GAME_UNIT_TYPE"),)],
                                   ["TXT_HELP_UNIT3", ""], ["TXT_HELP_UNIT4", (getSMenuText("TXT_GAME_UNIT_TYPE_SEL0"),)],
                                   ["TXT_HELP_UNIT5", (getSMenuText("TXT_GAME_UNIT_TYPE_SEL1"),)], ["TXT_HELP_UNIT6", (getSMenuText("TXT_GAME_UNIT_TYPE_SEL2"),)]]
                        launchPopUP(txtList)
                elif optionID == "normalize" :
                        txtList = [["TXT_HELP_NORM0", ""], ["TXT_HELP_NORM1", (getSMenuText("TXT_STARTLOCS_NORM_START_SEL0"),)], ["", ""],
                                   ["TXT_STARTLOCS_NORM_START", ""], ["TXT_HELP_NORM2", ""],
                                   ["TXT_HELP_NORM2_1", (getSMenuText("TXT_STARTLOCS_SWAPHUMANS_SEL0"),)], 
                                   ["TXT_HELP_NORM2_1", (getSMenuText("TXT_STARTLOCS_ISOLATEHUMANS_SEL0"),)], ["", ""], 
                                   ["TXT_STARTLOCS_NORM_RIVER", ""], ["TXT_HELP_NORM3", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_PEAK", ""], ["TXT_HELP_NORM4", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_LAKE", ""], ["TXT_HELP_NORM5", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_BADFEAT", ""], ["TXT_HELP_NORM6", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_BADTER", ""], ["TXT_HELP_NORM7", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_FOODBONUS", ""], ["TXT_HELP_NORM8", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_GOODTER", ""], ["TXT_HELP_NORM9", ""], ["", ""],
                                   ["TXT_STARTLOCS_NORM_EXTRA", ""], ["TXT_HELP_NORM10", ""], ["", ""]]
                        launchPopUP(txtList)
                elif optionID == "lairs" :
                        txtList = [["TXT_FFH2_LAIRS", ""], ["", ""]]
                        for sType in XMLEntriesList["lairs"] :
                                sDescr = str(copy.copy(XMLDescriptions[sType]))
                                fPercent = normalizeFloat(parsedXMLValuesEntries[sType]["iAppearanceProbability"] * 100 / 10000.0)
                                txtList.append(["TXT_FFH2_LAIR_PERCENT", (sDescr, fPercent)])
                        if "IMPROVEMENT_TOWER" in XMLEntriesList["lairs"] : txtList += [["", ""], ["TXT_FFH2_TOWERS", (XMLDescriptions["IMPROVEMENT_TOWER"], )]]
                        launchPopUP(txtList)
                elif optionID == "uniqueimprovements" :
                        txtList = [["TXT_FFH2_UIMPR_VAR", ""], ["", ""]]
                        iBaseChance = gc.getDefineINT("IMPROVEMENT_UNIQUE_CHANCE")
                        for sType in XMLEntriesList["worldinfos"] :
                                sDescr = str(copy.copy(XMLDescriptions[sType]))
                                iPercent = iBaseChance + parsedXMLValuesEntries[sType]["iUniqueFeatureChance"]
                                txtList.append(["TXT_FFH2_UIMPR_SIZE", (sDescr, iPercent)])
                        if "IMPROVEMENT_MAELSTROM" in XMLEntriesList["uniqueimprovements"] : txtList += [["", ""], ["TXT_FFH2_MAELSTROM", (XMLDescriptions["IMPROVEMENT_MAELSTROM"], )]]
                        launchPopUP(txtList)
        except :
                writeError()

        return 1

def Sto_Selection_OneCB_Script(argsList):
        try :
                global selection
                bValue, szName = argsList

                dum, baseTag, option1, option2 = szName.split("_")
                selection[baseTag][option1][option2] = bool(bValue)

                bRefresh = False
                if option2 == "erasedefres" :
                        if bool(bValue) :
                                if selection["resources"]["resourcesgen"]["waterpercent"] == "standard" : selection["resources"]["resourcesgen"]["waterpercent"] = [-1]
                                if selection["resources"]["resourcesgen"]["landpercent"] == "standard" : selection["resources"]["resourcesgen"]["landpercent"] = [-1]
                        
                        bRefresh = True

                elif option2 in ["swaphuman", "isolatehuman"] :
                        if (bool(bValue)) and (option2 == "swaphuman"):
                                selection["startlocs"]["relocate"]["isolatehuman"] = False

                        if (bool(bValue)) and (option2 == "isolatehuman"):
                                selection["startlocs"]["relocate"]["swaphuman"] = False

                        bRefresh = True

                if bRefresh :
                        getScreen().checkEditBox()
                        getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_SaveFile_EditBox_Script(argsList):
        try :
                uText , szName = argsList

                sText = getSText(uText)
                allowedChar = str(string.ascii_letters + string.digits + "_- ")

                while True :
                        if sText == "" :
                                break
                        if sText[0] == "_" :
                                sText = sText[1:]
                                continue
                        break
                lToReplace = ""
                for s in sText :
                        if (( not s in allowedChar ) and ( not s in lToReplace )) : lToReplace += s

                for s in lToReplace : sText = sText.replace(s, "")

                getTab().setText("SaveFileEditBox", getUText(sText))
                
                listFile = [ item[0:-4] for item in getListDirSto() if ((".cfg" in item) and (item[0] != "_")) ]
                listFile.sort()

                if sText in listFile : iIndex = listFile.index(sText) +1
                else : iIndex = 0

                getTab().setValue("ListFilesDropdown", iIndex)
        except :
                writeError()

        return 1

def Sto_SaveFile_DropdownBox_Script(argsList):
        try :
                iValue, szName = argsList

                iValue = int(iValue)

                listFile = [ item for item in getListDirSto() if ((".cfg" in item) and (item[0] != "_")) ]
                listFile.sort()

                if iValue == 0 :
                        getTab().setText("SaveFileEditBox", getUMenuText("TXT_NEW_FILE"))
                else :
                        getTab().setText("SaveFileEditBox", getUText(listFile[iValue-1][0:-4]))
        except :
                writeError()

        return 1

def Sto_Save_File_Apply_Script(argsList):
        try :
                fileName = getSText(getTab().getText("SaveFileEditBox"))+".cfg"
                writeLog("", False, [" Sto_Save_File_Apply : fileName : %s" %fileName, ""])

                if fileName == ".cfg" :
                        launchPopUP([["TXT_ENTER_FILE_NAME", ""]])
                        return 1
                elif fileName == getSMenuText("TXT_NEW_FILE")+".cfg" :
                        launchPopUP([["TXT_CHANGE_FILE_NAME", ""]])
                        return 1

                dB = saveSelection(fileName)

                if dB :
                        launchPopUP([["TXT_FAILED_POPUP_SAVE", ""]])
                        return 1

                saveConfig("LastFileSaved", fileName)

                getTab().destroy()
                CvScreensInterface.optionsScreen = CvStoFullOfResourcesScreen()
                CvScreensInterface.showOptionsScreen()
        except :
                writeError()

        return 1

def Sto_Save_File_Script(argsList):
        try :
                getScreen().checkEditBox() # before a reinit , check and save the edit box entries

                destroyScreen() # destroy the screen

                CvScreensInterface.optionsScreen = CvStoSaveFileScreen() # redirect to the save screen ( i can't use popup with entries before the game )
                CvScreensInterface.showOptionsScreen() # launch the screen
        except :
                writeError()

        return 1

def Sto_Exit_Load_Screen_Script(argsList):
        try :
                getTab().destroy()
                CvScreensInterface.optionsScreen = CvStoFullOfResourcesScreen()
                CvScreensInterface.showOptionsScreen()
        except :
                writeError()

        return 1

def Sto_Load_File_Apply_Script(argsList):
        try :
                global selection

                listFile = [ item for item in getListDirSto() if ((".cfg" in item) and (item != "_userConfig.cfg")) ]
                listFile.sort()

                fileNameIndex = getTab().getValue("ListFilesDropdown")

                fileName = listFile[int(fileNameIndex)]
                writeLog("", False, [" Sto_Load_File_Apply_Script : fileName : %s" %fileName, ""])

                selTp = loadSelection(fileName, False)

                if selTp == -1 :
                        launchPopUP([["TXT_FAILED_POPUP_LOAD", ""]])
                        return 1

                selection = dict(selTp)
                sortMultiBox()

                getTab().destroy()
                CvScreensInterface.optionsScreen = CvStoFullOfResourcesScreen()
                CvScreensInterface.showOptionsScreen()
        except :
                writeError()

        return 1

def Sto_Load_File_Script(argsList):
        try :
                listFile = [ item for item in getListDirSto() if ((".cfg" in item) and (item != "_userConfig.cfg")) ]
                if listFile == [] :
                        launchPopUP([["TXT_NO_FILE_TO_LOAD", ""]])
                        return 1
                        
                getScreen().checkEditBox() # before a reinit , check and save the edit box entries

                destroyScreen() # destroy the screen

                CvScreensInterface.optionsScreen = CvStoLoadFileScreen() # redirect to the load screen ( i can't use popup with entries before the game )
                CvScreensInterface.showOptionsScreen() # launch the screen
        except :
                writeError()

        return 1

def Sto_Selection_MultiRB_Script(argsList):
        try :
                global selection
                bSelected, szName = argsList

                if bSelected :
                        baseTag, optionTag1, optionTag2, sIndex = szName.split("_")

                        selection[baseTag][optionTag1][optionTag2] = int(sIndex)

                getScreen().checkEditBox()
                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Value_Random_Script(argsList):
        try :
                global selection
                bSelected, szName = argsList

                if bSelected :
                        rbName , baseTag, optionTag1, optionTag2 = szName.split("_")

                        if rbName == "RBStandard" : selection[baseTag][optionTag1][optionTag2] = "standard"
                        elif rbName == "RBValue" : selection[baseTag][optionTag1][optionTag2] = [-1]
                        else : selection[baseTag][optionTag1][optionTag2] = [-1,-1]

                getScreen().checkEditBox()
                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Selection_Special_Script(argsList):
        try :
                global selection
                bValue, szName = argsList

                item , tagList = szName.split("*")

                baseTag, optionTag1, optionTag2, sLabel = tagList.split("_")

                if bValue : selection[baseTag][optionTag1][optionTag2].append(item)
                else : selection[baseTag][optionTag1][optionTag2].remove(item)
        except :
                writeError()

        return 1

def Sto_Selection_MultiCB_Script(argsList):
        try :
                global selection
                bValue, szName = argsList

                baseTag, optionTag1, optionTag2, sIndex, sNbSelection = szName.split("_")
                nbSelection = int(sNbSelection)

                if bValue : selection[baseTag][optionTag1][optionTag2].append(int(sIndex))
                else : selection[baseTag][optionTag1][optionTag2].remove(int(sIndex))

                if selection[baseTag][optionTag1][optionTag2] == [] :
                        getScreen().checkEditBox()
                        selection[baseTag][optionTag1][optionTag2] = list(range(nbSelection))
                        getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Reset_Option_Script(argsList):
        try :
                global selection
                szName = argsList[0]

                baseID = szName.split("_")[1]
                optionID = szName.split("_")[2]

                getScreen().checkEditBox() # before a reinit , check and save the edit box entries

                if baseID == "maps" :
                        bSel = bool(copy.deepcopy(selection[baseID][optionID]["selected"]))

                selection[baseID][optionID] = copy.deepcopy(defSel[baseID][optionID])

                if baseID == "maps" :
                        selection[baseID][optionID]["selected"] = bSel

                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Map_Selected_Script(argsList):
        try :
                global selection
                bValue, szName = argsList

                mapID = szName.split("_")[1]
                selection["maps"][mapID]["selected"] = bool(bValue)

                getScreen().refreshMapOptionsTab()
        except :
                writeError()

        return 1

def Sto_Exit_Apply_Script(argsList):
        try :
                getScreen().checkEditBox() # check if current EB are good and save in selection

                # save back up
                dB = saveSelection("_LastConfig.cfg")
                dB = saveSelection(getLastFileUsedName())
                if isNetMP : dB = saveSelection("_Multiplayer_Config.cfg")

                destroyScreen()
                CvScreensInterface.optionsScreen = CvOptionsScreen.CvOptionsScreen()
                deleteScreenCallBack()

                if dB : launchPopUP([["TXT_FAILED_POPUP_SAVE", ""]])
        except :
                writeError()

        return 1

def Sto_Refresh_Apply_Script(argsList):
        try :
                getScreen().checkEditBox() # check if current EB are good and save in selection
                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Reset_All_Apply_Script(argsList):
        try :
                global selection

                selection = copy.deepcopy(defSel)
                addEmptyMultiBox()

                getScreen().refreshScreen()
        except :
                writeError()

        return 1

def Sto_Reset_Table_Apply_Script(argsList):
        try :
                global selection

                szName = argsList[0]

                tag = szName.split("_")[1]
                getScreen().checkEditBox() # check if current EB are good and save in selection

                selection[tag] = copy.deepcopy(defSel[tag])
                addEmptyMultiBox(tag)

                getScreen().refreshScreen()
                        
        except :
                writeError()
                
        return 1

def Sto_Apply_Language_Script(argsList):
        try :
                global language
                global bInitDescription
                bInitDescription = True

                iValue, szName = argsList

                saveConfig("language", iValue)
                language = iValue

                getScreen().checkEditBox() # check if current EB are good and save in selection

                initXMLDescriptions()

                initValueLimits() # reset the descriptions

                sortXMLLists() # sort the xml lists in function of the descriptions

                #delete screen and redraw it
                destroyScreen()
                CvScreensInterface.showOptionsScreen()

        except :
                writeError()

        return 1

# just in case
def Sto_DummyCallback_Script(argsList):
        return

# Main screen
class CvStoFullOfResourcesScreen:
	
	def __init__(self):
		
		self.callbackIFace = "CvOptionsScreenCallbackInterface"
		
	def getTabControl(self):
		return self.pTabControl
		
	def initText(self):
		
		self.szTabControlName = getUMenuText("TXT_TITTLE")
		
		self.szInfosTabName = getUMenuText("TXT_INFOS")
		self.szMapOptionsTabName = getUMenuText("TXT_MAPS")
		self.szTerrainOptionsTabName = getUMenuText("TXT_TERRAIN")
		self.szResourcesOptionsTabName = getUMenuText("TXT_RESOURCES")
		self.szStartOptionsTabName = getUMenuText("TXT_STARTLOC")
		self.szGameOptionsTabName = getUMenuText("TXT_GAME_OPTIONS")
		self.szFfH2OptionsTabName = getUText("Fall from Heaven 2 :")

	def refreshScreen(self):
                try : self.refreshMapOptionsTab()
                except : writeError()
                try : self.refreshTerrainOptionsTab()
                except : writeError()
                try : self.refreshResourcesOptionsTab()
                except : writeError()
                try : self.refreshStartOptionsTab()
                except : writeError()
                try : self.refreshGameOptionsTab()
                except : writeError()
                if bFfH2Tab :
                        try : self.refreshFfH2OptionsTab()
                        except : writeError()

	def checkEditBox(self):
                try : self.checkEditBoxMapOptionsTab()
                except : writeError()
                try : self.checkEditBoxTerrainOptionsTab()
                except : writeError()
                try : self.checkEditBoxResourcesOptionsTab()
                except : writeError()
                try : self.checkEditBoxStartOptionsTab()
                except : writeError()
                try : self.checkEditBoxGameOptionsTab()
                except : writeError()
                if bFfH2Tab :
                        try : self.checkEditBoxFfH2OptionsTab()
                        except : writeError()

	def interfaceScreen (self):
		self.initText()
		
                initNbMultiBox()

		self.pTabControl = CyGTabCtrl(self.szTabControlName, false, false)
		self.pTabControl.setModal(1)

		# enlarge the screen at the maximum
		resolution = [int(item) for item in CyUserProfile().getResolutionString(CyUserProfile().getResolution()).split("x") if item != "" ]
		self.pTabControl.setSize(int(resolution[0]*0.95), int(resolution[1]*0.95))
		self.pTabControl.setControlsExpanding(false)
		
		self.pTabControl.attachTabItem("InfoForm", self.szInfosTabName)
		self.pTabControl.attachTabItem("MapForm", self.szMapOptionsTabName)
		self.pTabControl.attachTabItem("TerrainForm", self.szTerrainOptionsTabName)
		self.pTabControl.attachTabItem("ResourcesForm", self.szResourcesOptionsTabName)
		self.pTabControl.attachTabItem("StartForm", self.szStartOptionsTabName)
		self.pTabControl.attachTabItem("GameForm", self.szGameOptionsTabName)
                if bFfH2Tab :
                        self.pTabControl.attachTabItem("FfH2Form", self.szFfH2OptionsTabName)

		# no need to check errors , CTD occurs if there is an error		
		self.drawInfosTab()
		self.drawMapOptionsTab()
		self.drawTerrainOptionsTab()
		self.drawResourcesOptionsTab()
		self.drawStartOptionsTab()
		self.drawGameOptionsTab()
                if bFfH2Tab :
                        self.drawFfH2OptionsTab()

	def selectDrawFunction(self, optionFunction, argList = []):
                dictFunctions = {
                        "Selection" : self.drawBoxOptionSelection ,
                        "ValueRandom" : self.drawBoxOptionEDValueRandom ,
                        "ValueRandomFloat" : self.drawBoxOptionEDValueRandom ,
                        "SelectOne" : self.drawBoxOptionSelectOne ,
                        "SelectionRB" : self.drawBoxOptionSelectionMultiRB ,
                        "Value" : self.drawBoxOptionValue ,
                        "StandardValueRandom" : self.drawBoxOptionStandardValueRandom ,
                        "StandardValueRandomFloat" : self.drawBoxOptionStandardValueRandom ,
                        "MultiValues" : self.drawBoxOptionMultiValues ,
                        "standardgen" : self.drawBoxOptionSelectionSpecialDefaultResources ,
                        "SelectionSpecial" : self.drawBoxOptionSelectionSpecial ,
                        "startresselect" : self.drawStartResources ,
                        "defender" : self.drawBoxOptionDefender ,
                        "addtech" : self.drawAddTech ,
                        "startunitselect" : self.drawStartUnit ,
                        "resmultiply" : self.drawMultiplyResources
                        }
                if argList != [] :
                        dictFunctions[optionFunction](argList)
                else :
                        dictFunctions[optionFunction]()

	def selectRefreshFunction(self, optionFunction, argList = []):
                dictFunctions = {
                        "Selection" : self.refreshSelection ,
                        "ValueRandom" : self.refreshValueRandom ,
                        "ValueRandomFloat" : self.refreshValueRandom ,
                        "SelectOne" : self.refreshSelectOne ,
                        "SelectionRB" : self.refreshSelectionMultiRB ,
                        "Value" : self.refreshValue ,
                        "StandardValueRandom" : self.refreshStandardValueRandom ,
                        "StandardValueRandomFloat" : self.refreshStandardValueRandom ,
                        "MultiValues" : self.refreshMultiValues ,
                        "standardgen" : self.refreshSelectionSpecialDefaultResources ,
                        "SelectionSpecial" : self.refreshSelectionSpecial ,
                        "startresselect" : self.refreshStartResources ,
                        "defender" : self.refreshOptionDefender ,
                        "addtech" : self.refreshAddTech ,
                        "startunitselect" : self.refreshStartUnit ,
                        "resmultiply" : self.refreshMultiplyResources
                        }
                if argList != [] :
                        dictFunctions[optionFunction](argList)
                else :
                        dictFunctions[optionFunction]()

	def selectCheckEditBoxFunction(self, optionFunction, argList = []):
                dictFunctions = {
                        "ValueRandom" : self.checkEditBoxValueRandom ,
                        "ValueRandomFloat" : self.checkEditBoxValueRandomFloat ,
                        "Value" : self.checkEditBoxValue ,
                        "StandardValueRandom" : self.checkEditBoxStandardValueRandom ,
                        "StandardValueRandomFloat" : self.checkEditBoxStandardValueRandomFloat ,
                        "MultiValues" : self.checkEditBoxMultiValues ,
                        "resmultiply" : self.checkEditBoxMultiplyResources
                        }
                if not optionFunction in dictFunctions : return
                if argList != [] :
                        dictFunctions[optionFunction](argList)
                else :
                        dictFunctions[optionFunction]()

        def drawInfosTab(self):
		
                # draw the tab ,
		tab = self.pTabControl
		tab.attachVBox("InfoForm", "InfoVBoxParent")
		
		# Add Map Options
		
		tab.attachPanel("InfoVBoxParent", "InfoPanelCenter")
		tab.setStyle("InfoPanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("InfoPanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("InfoPanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("InfoPanelCenter", "InfoPanel")
		tab.setLayoutFlag("InfoPanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("InfoPanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("InfoPanel", "InfoVBox")
		tab.setLayoutFlag("InfoVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("InfoVBox", "LAYOUT_SIZE_VEXPANDING")

                txtList = [
                    "newBox", ["TXT_INFOS_0", ""],
                    "newBox", ["TXT_INFOS_1", ""], "newBox", "button1", "newBox", "button2",
                    "sep", "newBox", ["TXT_INFOS_2", ""],
                    "newBox", ["TXT_INFOS_3", ""], ["TXT_INFOS_4", ""], "newBox", ["TXT_INFOS_5", (getSMenuText("TXT_REFRESH"),)], "newBox",
                    ["TXT_INFOS_6", ""], ["TXT_INFOS_7", (getSMenuText("TXT_EXIT"), getSMenuText("TXT_EXIT0"))], ["TXT_INFOS_8", ""], "newBox",
                    ["TXT_INFOS_9", ""], ["TXT_INFOS_9_0", ""], "newBox", ["TXT_INFOS_10", ""], "newBox", ["TXT_INFOS_11", ""],
                    "newBox", ["TXT_INFOS_11_0", ""], ["TXT_INFOS_11_1", ""], "newBox", ["TXT_INFOS_11_2", ""],
                    "newBox", ["TXT_INFOS_11_2_0", ""], ["TXT_INFOS_11_2_1", ""], ["TXT_INFOS_11_2_2", ""],
                    "newBox", ["TXT_INFOS_11_3", ""],
                    "newBox", ["TXT_INFOS_11_4", ""], ["TXT_INFOS_11_5", ""], ["TXT_INFOS_11_6", ""], ["TXT_INFOS_11_7", ""],
                    "sep", "newBox", ["TXT_INFOS_12", ""],
                    "newBox", ["TXT_INFOS_13", ""], "newBox", ["TXT_INFOS_14", ""], "endChapter",
                    ["TXT_INFOS_15", ""], ["TXT_INFOS_16", ""], "endChapter", ["TXT_INFOS_17", ""], ["TXT_INFOS_18", ""], ["TXT_INFOS_19", ""]
                    ]

                iBoxIndex = 0
                iTextIndex = 0
                iSepIndex = 0
                txtTotTemp = ""
                def writeText(szBox, szText, iIndex) :
                        txtTemp = ""
                        for txtPart in szText.split(" ") :
                                if txtPart == "" : continue
                                if len(txtTemp) + len(txtPart) > 130 :
                                        uLabelText = getUText(txtTemp)
                                        labelHBox = "%dInfoLabelHBox%d" %(iIndex, iBoxIndex)
                                        tab.attachHBox(szBox, labelHBox)
                                        tab.setLayoutFlag(labelHBox, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(labelHBox, "LAYOUT_SIZE_HEXPANDING")
                                        tab.attachLabel(labelHBox, "%dInfoLabelVLabel%d" %(iIndex, iBoxIndex), uLabelText)
                                        txtTemp = ""
                                        iIndex += 1
                                txtTemp += txtPart+" "
                        if len(txtTemp) > 0 :
                                uLabelText = getUText(txtTemp)
                                labelHBox = "%dInfoLabelHBox%d" %(iIndex, iBoxIndex)
                                tab.attachHBox(szBox, labelHBox)
                                tab.setLayoutFlag(labelHBox, "LAYOUT_SIZE_VEXPANDING")
                                tab.setLayoutFlag(labelHBox, "LAYOUT_SIZE_HEXPANDING")
                                tab.attachLabel(labelHBox, "%dInfoLabelVLabel%d" %(iIndex, iBoxIndex), uLabelText)
                                iIndex += 1
                        return iIndex

                for item in txtList :
                        if (txtTotTemp != "") and (item in ["newBox", "sep", "endChapter", "button1", "button2"]) :
                                iTextIndex = writeText(newBox, txtTotTemp, iTextIndex)
                                txtTotTemp = ""

                        if item == "newBox" :
                                tab.attachFixedSpacer("InfoVBox", 5)

                                newBox = "InfoLabelVBox%d" %iBoxIndex
                                tab.attachVBox("InfoVBox", newBox)
                                tab.setLayoutFlag(newBox, "LAYOUT_SIZE_HEXPANDING")
                                tab.setLayoutFlag(newBox, "LAYOUT_SIZE_VEXPANDING")

                                iBoxIndex += 1
                                iTextIndex = 0

                        elif item == "sep" :
                                tab.attachFixedSpacer("InfoVBox", 15)
                                tab.attachHSeparator("InfoVBox", "InfoVSeparator%d" %iSepIndex)
                                tab.attachFixedSpacer("InfoVBox", 10)

                                iSepIndex += 1

                        elif item == "button1" :
                                tab.setLayoutFlag(newBox, "LAYOUT_LEFT")

                                szOptionDesc = getUMenuText("TXT_OPEN_BROWSER")
                                szCallbackFunction = "Sto_Open_Browser"
                                szWidgetName = "open_browser_%d_%d" %(iTextIndex, iBoxIndex)
                                tab.attachButton(newBox, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        elif item == "button2" :
                                tab.setLayoutFlag(newBox, "LAYOUT_LEFT")

                                szOptionDesc = getUMenuText("TXT_CHECK_UPDATE")
                                szCallbackFunction = "Sto_Check_Update"
                                szWidgetName = "Check_Update_%d_%d" %(iTextIndex, iBoxIndex)
                                tab.attachButton(newBox, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        elif not item in ["endChapter"] :
                                szTag, lList = item
                                if txtTotTemp != "" : txtTotTemp += " "
                                txtTotTemp += getSMenuText(szTag, lList)

                if txtTotTemp != "" : iTextIndex = writeText(newBox, txtTotTemp, iTextIndex)

                tab.attachFixedSpacer("InfoVBox", 10)
                self.drawLowerPanel("InfoVBoxParent", "InfoTab")

	def drawMapOptionsTab(self):

                # draw the tab ,
		tab = self.pTabControl

                baseTag = "maps"

		tab.attachVBox("MapForm", "MapVBoxParent")
		
		# Add Map Options
		
		tab.attachPanel("MapVBoxParent", "MapPanelCenter")
		tab.setStyle("MapPanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("MapPanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("MapPanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("MapPanelCenter", "MapPanel")
		tab.setLayoutFlag("MapPanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("MapPanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("MapPanel", "MapVBox")
		tab.setLayoutFlag("MapVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("MapVBox", "LAYOUT_SIZE_VEXPANDING")

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for mapID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][mapID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = "^_^"
                for mapID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, mapID) :
                                labelTag = valueLimits[baseTag][mapID][optionID]["txttag"]
                                while len(getSMenuText(labelTag))>len(tittleBar2) : tittleBar2 += "^_^"
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 1 : tittleBar3 += "^_^^_^^_^^_^^_^^_^^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                elif language == 4 : tittleBar3 += "^_^^_^^_^^_^^_^^_^^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each map box
		listMaps = sortKeys(selection, baseTag)
                nbMaps = len(listMaps)

		for iMap in range(nbMaps):

                        mapID = listMaps[iMap]
                        
                        tab.attachHSeparator("MapVBox", "%sHSeparator0" %mapID)
                        tab.attachHSeparator("MapVBox", "%sHSeparator01" %mapID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %mapID
                        vBox1 = "%sVBox1" %mapID
                        vBox2 = "%sVBox2" %mapID
                        vBox3 = "%sVBox3" %mapID

                        tab.attachHBox("MapVBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %mapID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %mapID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %mapID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %mapID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , map CB , resetbutton in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %mapID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %mapID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %mapID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %mapID)

                        # map CB
                        szBoxName = "mapCB_%s" %mapID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szOptionDesc = getUText(valueLimits[baseTag][mapID]["description"])
                        szCallbackFunction = "Sto_Map_Selected"
                        szWidgetName = "selected_%s" %mapID
                        bBoxOn = copy.deepcopy(selection[baseTag][mapID]["selected"])
                        tab.attachCheckBox(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName, bBoxOn)

                        # Reset Button
                        szBoxName = "%sTitlleHBox" %mapID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szOptionDesc = getUMenuText("TXT_RESET")
                        szCallbackFunction = "Sto_Reset_Option"
                        szWidgetName = "reset_%s_%s" %(baseTag, mapID)
                        tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %mapID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %mapID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %mapID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %mapID)

                        szBoxName = "%sTittleHBox3" %mapID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %mapID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %mapID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %mapID)

                        # list of options
                        listOptionsLoop = sortKeys(selection, baseTag, mapID)
                        nbOptionsLoop = len(listOptionsLoop)

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                #box1 : add option label
                                szNameHSupport = "%s%sDescSupport2" %(mapID,optionID)
                                tab.attachHBox(vBox2, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                szLabelName = "%s%sOptionLabel" %(mapID,optionID)
                                labelTag = valueLimits[baseTag][mapID][optionID]["txttag"]
                                szLabelText = getUMenuText(labelTag)
                                tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                if not bBoxOn : tab.setEnabled(szLabelName, False)

                                if iOption != (nbOptionsLoop-1) : tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(mapID,optionID))

                                #box2 : add option selection

                                szNameHSupport = "%s%sDescSupport3" %(mapID,optionID)
                                tab.attachHBox(vBox3, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                optionFunction = valueLimits[baseTag][mapID][optionID]["drawfunc"]
                                self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, mapID, optionID, bBoxOn))

                                if iOption != (nbOptionsLoop-1) : tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(mapID,optionID))

                        # end map separator
                        tab.attachHSeparator("MapVBox", "%sHSeparator1" %mapID)
                        tab.attachHSeparator("MapVBox", "%sHSeparator11" %mapID)
                        tab.attachFixedSpacer("MapVBox", 10)
                        if iMap != (nbMaps-1) : tab.attachFixedSpacer("MapVBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("MapVBoxParent", baseTag)

	def refreshMapOptionsTab(self):
		
		tab = self.pTabControl

                baseTag = "maps"
		for optionTag1 in selection[baseTag].keys() :

                        bBoxOn = copy.deepcopy(selection[baseTag][optionTag1]["selected"])

                        szWidgetName = "selected_%s" %optionTag1
                        tab.setValue(szWidgetName, bBoxOn)

                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                if optionTag2 == "selected" : continue
                                
                                szLabelName = "%s%sOptionLabel" %(optionTag1,optionTag2)
                                tab.setEnabled(szLabelName, bBoxOn)

                                optionFunction = valueLimits[baseTag][optionTag1][optionTag2]["drawfunc"]
                                self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))
		
	def checkEditBoxMapOptionsTab(self):
		
                baseTag = "maps"
		for optionTag1 in selection[baseTag].keys() :
                        for optionTag2 in selection[baseTag][optionTag1].keys() :
                        
                                if optionTag2 == "selected" : continue
                                
                                optionFunction = valueLimits[baseTag][optionTag1][optionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

	def drawTerrainOptionsTab(self):

                # draw the tab ,
		tab = self.pTabControl

                baseTag = "terrain"

		tab.attachVBox("TerrainForm", "TerrainVBoxParent")
		
		# Add terrain Options
		
		tab.attachPanel("TerrainVBoxParent", "TerrainPanelCenter")
		tab.setStyle("TerrainPanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("TerrainPanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("TerrainPanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("TerrainPanelCenter", "TerrainPanel")
		tab.setLayoutFlag("TerrainPanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("TerrainPanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("TerrainPanel", "TerrainVBox")
		tab.setLayoutFlag("TerrainVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("TerrainVBox", "LAYOUT_SIZE_VEXPANDING")

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for terrainID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][terrainID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = "^_^"
                for terrainID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, terrainID) :
                                labelTag = valueLimits[baseTag][terrainID][optionID]["txttag"]
                                while len(getSMenuText(labelTag))>len(tittleBar2) : tittleBar2 += "^_^"
                if language == 0 : tittleBar2 = tittleBar2[0:-3]
                elif language == 1 : tittleBar2 = tittleBar2[0:-9]
                elif language == 2 : tittleBar2 = tittleBar2[0:-3]
                elif language == 3 : tittleBar2 = tittleBar2[0:-9]
                elif language == 4 : tittleBar2 = tittleBar2[0:-9]
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += "^_^"
                elif language == 1 : tittleBar3 += "^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^^_^^_^^_^"
                elif language == 4 : tittleBar3 += "^_^^_^^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each terrain box
		listTerrains = sortKeys(selection, baseTag)
                nbTerrains = len(listTerrains)

                bBoxOn = True

		for iTerrain in range(nbTerrains):

                        terrainID = listTerrains[iTerrain]
                        
                        tab.attachHSeparator("TerrainVBox", "%sHSeparator0" %terrainID)
                        tab.attachHSeparator("TerrainVBox", "%sHSeparator01" %terrainID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %terrainID
                        vBox1 = "%sVBox1" %terrainID
                        vBox2 = "%sVBox2" %terrainID
                        vBox3 = "%sVBox3" %terrainID

                        tab.attachHBox("TerrainVBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %terrainID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %terrainID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %terrainID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %terrainID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , resetbutton in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %terrainID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %terrainID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %terrainID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %terrainID)

                        # terrain tittle
                        szBoxName = "TerrainLabel_%s" %terrainID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szLabelDesc = getUText(valueLimits[baseTag][terrainID]["description"])
                        szWidgetName = "TerrainLabelTitlle_%s" %terrainID
                        tab.attachLabel(szBoxName, szWidgetName, szLabelDesc)

                        # Reset Button
                        if terrainID in ["terrains"] :
                                szBoxName = "%sTitlleHBox" %terrainID
                                tab.attachHBox(vBox1, szBoxName)
                                tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                                szOptionDesc = getUMenuText("TXT_RESET")
                                szCallbackFunction = "Sto_Reset_Option"
                                szWidgetName = "reset_%s_%s" %(baseTag, terrainID)
                                tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %terrainID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %terrainID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %terrainID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %terrainID)

                        szBoxName = "%sTittleHBox3" %terrainID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %terrainID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %terrainID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %terrainID)

                        listOptionsLoop = sortKeys(selection, baseTag, terrainID)
                        nbOptionsLoop = len(listOptionsLoop)

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                #box1 : add option label
                                szNameHSupport = "%s%sDescSupport2" %(terrainID,optionID)
                                tab.attachHBox(vBox2, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                szLabelName = "%s%sOptionLabel" %(terrainID,optionID)
                                labelTag = valueLimits[baseTag][terrainID][optionID]["txttag"]
                                szLabelText = getUMenuText(labelTag)
                                tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                if iOption != (nbOptionsLoop-1) : tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(terrainID,optionID))

                                #box2 : add option selection
                                szNameHSupport = "%s%sDescSupport3" %(terrainID,optionID)
                                tab.attachHBox(vBox3, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                optionFunction = valueLimits[baseTag][terrainID][optionID]["drawfunc"]
                                self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, terrainID, optionID, bBoxOn))

                                if iOption != (nbOptionsLoop-1) : tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(terrainID,optionID))

                        # end terrain separator
                        tab.attachHSeparator("TerrainVBox", "%sHSeparator1" %terrainID)
                        tab.attachHSeparator("TerrainVBox", "%sHSeparator11" %terrainID)
                        tab.attachFixedSpacer("TerrainVBox", 10)
                        if iTerrain != (nbTerrains-1) : tab.attachFixedSpacer("TerrainVBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("TerrainVBoxParent", baseTag)

	def refreshTerrainOptionsTab(self):
		
		tab = self.pTabControl
                baseTag = "terrain"
                bBoxOn = True

		for optionTag1 in selection[baseTag].keys() :
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                optionFunction = valueLimits[baseTag][optionTag1][optionTag2]["drawfunc"]
                                self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

	def checkEditBoxTerrainOptionsTab(self):
		
                baseTag = "terrain"
		for optionTag1 in selection[baseTag].keys() :
                        for optionTag2 in selection[baseTag][optionTag1].keys() :
                        
                                optionFunction = valueLimits[baseTag][optionTag1][optionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

	def drawResourcesOptionsTab(self):

                baseTag = "resources"

                bEraseAll = copy.copy(selection["resources"]["resourcesgen"]["erasedefres"])

                bWater = True
                if selection[baseTag]["resourcesgen"]["waterpercent"] == "standard" : bWater = False

                bLand = True
                if selection[baseTag]["resourcesgen"]["landpercent"] == "standard" : bLand = False

                # draw the tab ,
		tab = self.pTabControl

		tab.attachVBox("ResourcesForm", "ResourceVBoxParent")
		
		# Add resources Options
		
		tab.attachPanel("ResourceVBoxParent", "ResourcePanelCenter")
		tab.setStyle("ResourcePanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("ResourcePanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("ResourcePanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("ResourcePanelCenter", "ResourcePanel")
		tab.setLayoutFlag("ResourcePanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("ResourcePanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("ResourcePanel", "ResourceVBox")
		tab.setLayoutFlag("ResourceVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("ResourceVBox", "LAYOUT_SIZE_VEXPANDING")

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for resourceID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][resourceID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = "^_^"
                for resourceID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, resourceID) :
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                labelTag = valueLimits[baseTag][resourceID][baseOptionID]["txttag"]
                                while len(getSMenuText(labelTag))>len(tittleBar2) : tittleBar2 += "^_^"
                if language == 0 : tittleBar2 = tittleBar2[0:-6]
                elif language == 1 : tittleBar2 = tittleBar2[0:-9]
                elif language == 2 : tittleBar2 = tittleBar2[0:-9]
                elif language == 3 : tittleBar2 = tittleBar2[0:-9]
                elif language == 4 : tittleBar2 = tittleBar2[0:-9]
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 1 : tittleBar3 += "^_^^_^^_^^_^^_^^_^^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^^_^^_^^_^"
                elif language == 4 : tittleBar3 += "^_^^_^^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each resource box
		listResource = sortKeys(selection, baseTag)
                nbResource = len(listResource)
                listParents = getParents().keys()

		for iResource in range(nbResource):

                        resourceID = listResource[iResource]
                        
                        tab.attachHSeparator("ResourceVBox", "%sHSeparator0" %resourceID)
                        tab.attachHSeparator("ResourceVBox", "%sHSeparator01" %resourceID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %resourceID
                        vBox1 = "%sVBox1" %resourceID
                        vBox2 = "%sVBox2" %resourceID
                        vBox3 = "%sVBox3" %resourceID

                        tab.attachHBox("ResourceVBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %resourceID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %resourceID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %resourceID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %resourceID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , help button in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %resourceID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %resourceID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %resourceID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %resourceID)

                        # resource tittle
                        szBoxName = "ResourceLabel_%s" %resourceID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szLabelDesc = getUText(valueLimits[baseTag][resourceID]["description"])
                        szWidgetName = "ResourceLabelTitlle_%s" %resourceID
                        tab.attachLabel(szBoxName, szWidgetName, szLabelDesc)

                        # help Button
                        if resourceID in ["resourcesgen", "resourcesstart"] :
                                szBoxName = "%sTitlleHBox" %resourceID
                                tab.attachHBox(vBox1, szBoxName)
                                tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                                szOptionDesc = getUMenuText("TXT_HELP")
                                szCallbackFunction = "Sto_Help_Option"
                                szWidgetName = "Help_%s_%s" %(baseTag, resourceID)
                                tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %resourceID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %resourceID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %resourceID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %resourceID)

                        szBoxName = "%sTittleHBox3" %resourceID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %resourceID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %resourceID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %resourceID)

                        listOptionsLoop = sortKeys(selection, baseTag, resourceID)
                        nbOptionsLoop = len(listOptionsLoop)

                        # double the separator when adding a multiline option
                        bLastOptionMultiLine = False

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                # blank functions drawn with other optionID
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                        if not baseOptionID in listParents : continue

                                bBoxOn = True
                                if (optionID == "landprop") and (not bLand) and (not bEraseAll) : bBoxOn = False
                                if (optionID == "waterprop") and (not bWater) and (not bEraseAll) : bBoxOn = False
                                bLandOn = copy.copy(bLand)
                                bWaterOn = copy.copy(bWater)
                                if (optionID == "standardgen") and (bEraseAll) :
                                        bLandOn = False
                                        bWaterOn = False

                                optionFunction = valueLimits[baseTag][resourceID][baseOptionID]["drawfunc"]
                                
                                if (optionFunction == "SelectionSpecial") :
                                        nbElement = len(valueLimits[baseTag][resourceID][baseOptionID]["listitem"])
                                        nbPerLine = valueLimits[baseTag][resourceID][baseOptionID]["nbperline"]
                                        if nbElement > nbPerLine :
                                                bThisOptionMultiLine = True
                                        else :
                                                bThisOptionMultiLine = False
                                elif (optionFunction == "standardgen") :
                                        bThisOptionMultiLine = True
                                else :
                                        bThisOptionMultiLine = False

                                if (bThisOptionMultiLine) and (not bLastOptionMultiLine) and (iOption != 0) :
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator4" %(resourceID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator5" %(resourceID,optionID))

                                if optionFunction in listParents:
                                        self.selectDrawFunction(optionFunction)

                                elif optionFunction == "standardgen" :
                                        self.selectDrawFunction(optionFunction, (vBox2, vBox3, baseTag, resourceID, optionID, bLandOn, bWaterOn))

                                elif optionFunction == "SelectionSpecial" :
                                        self.selectDrawFunction(optionFunction, (vBox2, vBox3, baseTag, resourceID, optionID, bBoxOn))

                                else :
                                        #box1 : add option label
                                        szNameHSupport = "%s%sDescSupport2" %(resourceID,optionID)
                                        tab.attachHBox(vBox2, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                        szLabelName = "%s%sOptionLabel" %(resourceID,optionID)
                                        labelTag = valueLimits[baseTag][resourceID][baseOptionID]["txttag"]
                                        szLabelText = getUMenuText(labelTag)
                                        tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        #box2 : add option selection

                                        szNameHSupport = "%s%sDescSupport3" %(resourceID,optionID)
                                        tab.attachHBox(vBox3, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                        self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, resourceID, optionID, bBoxOn))

                                if (iOption < (nbOptionsLoop-1)) and (not optionFunction in listParents):
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(resourceID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(resourceID,optionID))
                                        if bThisOptionMultiLine :
                                                tab.attachHSeparator(vBox2, "%s%sHSeparator6" %(resourceID,optionID))
                                                tab.attachHSeparator(vBox3, "%s%sHSeparator7" %(resourceID,optionID))

                                bLastOptionMultiLine = bool(bThisOptionMultiLine)

                        # end resource separator
                        tab.attachHSeparator("ResourceVBox", "%sHSeparator1" %resourceID)
                        tab.attachHSeparator("ResourceVBox", "%sHSeparator11" %resourceID)
                        tab.attachFixedSpacer("ResourceVBox", 10)
                        if iResource != (nbResource-1) : tab.attachFixedSpacer("ResourceVBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("ResourceVBoxParent", baseTag)

	def refreshResourcesOptionsTab(self):
		
		tab = self.pTabControl

                baseTag = "resources"

                bEraseAll = copy.copy(selection["resources"]["resourcesgen"]["erasedefres"])

                bWater = True
                if selection[baseTag]["resourcesgen"]["waterpercent"] == "standard" : bWater = False

                bLand = True
                if selection[baseTag]["resourcesgen"]["landpercent"] == "standard" : bLand = False

		for optionTag1 in selection[baseTag].keys() :

                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                bBoxOn = True
                                if (optionTag2 == "landprop") and (not bLand) and (not bEraseAll) : bBoxOn = False
                                if (optionTag2 == "waterprop") and (not bWater) and (not bEraseAll) : bBoxOn = False
                                bLandOn = copy.copy(bLand)
                                bWaterOn = copy.copy(bWater)
                                if (optionTag2 == "standardgen") and (bEraseAll) :
                                        bLandOn = False
                                        bWaterOn = False

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                
                                if ("-" in optionTag2) or (optionFunction == "SelectionSpecial") :
                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

                                elif optionFunction == "standardgen" :
                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bLandOn, bWaterOn))

                                else :
                                        szLabelName = "%s%sOptionLabel" %(optionTag1, optionTag2)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

	def checkEditBoxResourcesOptionsTab(self):
		
		tab = self.pTabControl
                baseTag = "resources"

		for optionTag1 in selection[baseTag].keys() :
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

	def drawStartOptionsTab(self):

                baseTag = "startlocs"

                # draw the tab ,
		tab = self.pTabControl

		tab.attachVBox("StartForm", "StartVBoxParent")
		
		# Add Starts Options
		
		tab.attachPanel("StartVBoxParent", "StartPanelCenter")
		tab.setStyle("StartPanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("StartPanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("StartPanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("StartPanelCenter", "StartPanel")
		tab.setLayoutFlag("StartPanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("StartPanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("StartPanel", "StartVBox")
		tab.setLayoutFlag("StartVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("StartVBox", "LAYOUT_SIZE_VEXPANDING")

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for StartID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][StartID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = "^_^"
                for StartID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, StartID) :
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                labelTag = valueLimits[baseTag][StartID][baseOptionID]["txttag"]
                                while len(getSMenuText(labelTag))>len(tittleBar2) : tittleBar2 += "^_^"
                if language == 0 : tittleBar2 = tittleBar2[0:-6]
                elif language == 1 : tittleBar2 = tittleBar2[0:-9]
                elif language == 2 : tittleBar2 = tittleBar2[0:-3]
                elif language == 3 : tittleBar2 = tittleBar2[0:-9]
                elif language == 4 : tittleBar2 = tittleBar2[0:-12]
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += ""
                elif language == 1 : tittleBar3 += "^_^^_^^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^"
                elif language == 4 : tittleBar3 += "^_^^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each Start box
		listStart = sortKeys(selection, baseTag)
                nbStart = len(listStart)
                listParents = getParents().keys()

		for iStart in range(nbStart):

                        StartID = listStart[iStart]
                        
                        tab.attachHSeparator("StartVBox", "%sHSeparator0" %StartID)
                        tab.attachHSeparator("StartVBox", "%sHSeparator01" %StartID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %StartID
                        vBox1 = "%sVBox1" %StartID
                        vBox2 = "%sVBox2" %StartID
                        vBox3 = "%sVBox3" %StartID

                        tab.attachHBox("StartVBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %StartID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %StartID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %StartID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %StartID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , help button in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %StartID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %StartID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %StartID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %StartID)

                        # Start tittle
                        szBoxName = "StartLabel_%s" %StartID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szLabelDesc = getUText(valueLimits[baseTag][StartID]["description"])
                        szWidgetName = "StartLabelTitlle_%s" %StartID
                        tab.attachLabel(szBoxName, szWidgetName, szLabelDesc)

                        # help Button
                        if StartID in ["normalize"] :
                                szBoxName = "%sTitlleHBox" %StartID
                                tab.attachHBox(vBox1, szBoxName)
                                tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                                szOptionDesc = getUMenuText("TXT_HELP")
                                szCallbackFunction = "Sto_Help_Option"
                                szWidgetName = "Help_%s_%s" %(baseTag, StartID)
                                tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %StartID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %StartID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %StartID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %StartID)

                        szBoxName = "%sTittleHBox3" %StartID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %StartID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %StartID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %StartID)

                        listOptionsLoop = sortKeys(selection, baseTag, StartID)
                        nbOptionsLoop = len(listOptionsLoop)

                        # double the separator when adding a multiline option
                        bLastOptionMultiLine = False

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                # blank functions drawn with other optionID
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                        if not baseOptionID in listParents : continue

                                bBoxOn = True

                                optionFunction = valueLimits[baseTag][StartID][baseOptionID]["drawfunc"]
                                
                                if (optionFunction == "SelectionSpecial") :
                                        nbElement = len(valueLimits[baseTag][StartID][baseOptionID]["listitem"])
                                        nbPerLine = valueLimits[baseTag][StartID][baseOptionID]["nbperline"]
                                        if nbElement > nbPerLine :
                                                bThisOptionMultiLine = True
                                        else :
                                                bThisOptionMultiLine = False
                                else :
                                        bThisOptionMultiLine = False

                                if (bThisOptionMultiLine) and (not bLastOptionMultiLine) and (iOption != 0) :
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator4" %(StartID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator5" %(StartID,optionID))

                                if optionFunction in listParents:
                                        self.selectDrawFunction(optionFunction)

                                elif optionFunction == "SelectionSpecial" :
                                        self.selectDrawFunction(optionFunction, (vBox2, vBox3, baseTag, StartID, optionID, bBoxOn))

                                else :
                                        #box1 : add option label
                                        szNameHSupport = "%s%sDescSupport2" %(StartID,optionID)
                                        tab.attachHBox(vBox2, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                        szLabelName = "%s%sOptionLabel" %(StartID,optionID)
                                        labelTag = valueLimits[baseTag][StartID][baseOptionID]["txttag"]
                                        szLabelText = getUMenuText(labelTag)
                                        tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        #box2 : add option selection

                                        szNameHSupport = "%s%sDescSupport3" %(StartID,optionID)
                                        tab.attachHBox(vBox3, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                        self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, StartID, optionID, bBoxOn))

                                if (iOption < (nbOptionsLoop-1)) and (not optionFunction in listParents):
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(StartID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(StartID,optionID))
                                        if bThisOptionMultiLine :
                                                tab.attachHSeparator(vBox2, "%s%sHSeparator6" %(StartID,optionID))
                                                tab.attachHSeparator(vBox3, "%s%sHSeparator7" %(StartID,optionID))

                                bLastOptionMultiLine = bool(bThisOptionMultiLine)

                        # end Start separator
                        tab.attachHSeparator("StartVBox", "%sHSeparator1" %StartID)
                        tab.attachHSeparator("StartVBox", "%sHSeparator11" %StartID)
                        tab.attachFixedSpacer("StartVBox", 10)
                        if iStart != (nbStart-1) : tab.attachFixedSpacer("StartVBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("StartVBoxParent", baseTag)

	def refreshStartOptionsTab(self):
		
		tab = self.pTabControl
                baseTag = "startlocs"

		for optionTag1 in selection[baseTag].keys() :

                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                bBoxOn = True

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                
                                if ("-" in optionTag2) or (optionFunction == "SelectionSpecial") :
                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

                                else :
                                        szLabelName = "%s%sOptionLabel" %(optionTag1, optionTag2)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

	def checkEditBoxStartOptionsTab(self):
		
		tab = self.pTabControl
                baseTag = "startlocs"

		for optionTag1 in selection[baseTag].keys() :
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

	def drawGameOptionsTab(self):

                baseTag = "game"

                # draw the tab ,
		tab = self.pTabControl

		tab.attachVBox("GameForm", "GameVBoxParent")
		
		# Add Games Options
		
		tab.attachPanel("GameVBoxParent", "GamePanelCenter")
		tab.setStyle("GamePanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("GamePanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("GamePanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("GamePanelCenter", "GamePanel")
		tab.setLayoutFlag("GamePanel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("GamePanel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("GamePanel", "GameVBox")
		tab.setLayoutFlag("GameVBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("GameVBox", "LAYOUT_SIZE_VEXPANDING")

		if not canUseGameOptions :
                        tab.attachLabel("GameVBox", "noGameOptions", getUMenuText("TXT_NO_GAME_OPTIONS"))
                        tab.attachHBox("GameVBox", "GameVBoxH")
                        tab.setLayoutFlag("GameVBoxH", "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag("GameVBoxH", "LAYOUT_LEFT")
                        tab.attachLabel("GameVBoxH", "noGameOptions0", getUMenuText("TXT_NO_GAME_OPTIONS0"))

                        tab.attachHBox("GameVBox", "GameVBoxH2")
                        tab.setLayoutFlag("GameVBoxH2", "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag("GameVBoxH2", "LAYOUT_LEFT")
                        szOptionDesc = getUMenuText("TXT_OPEN_BROWSER")
                        szCallbackFunction = "Sto_Open_Browser"
                        szWidgetName = "noGameOptions1"
                        tab.attachButton("GameVBoxH2", szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)
                        return

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for gameID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][gameID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = ""
                for gameID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, gameID) :
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                labelTag = valueLimits[baseTag][gameID][baseOptionID]["txttag"]
                                while len(getSMenuText(labelTag))>len(tittleBar2) : tittleBar2 += "^_^"
                if language == 0 : tittleBar2 = tittleBar2[0:-9]
                elif language == 1 : tittleBar2 = tittleBar2[0:-9]
                elif language == 2 : tittleBar2 = tittleBar2[0:-9]
                elif language == 3 : tittleBar2 = tittleBar2[0:-9]
                elif language == 4 : tittleBar2 = tittleBar2[0:-9]
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += "^_^^_^^_^"
                elif language == 1 : tittleBar3 += "^_^^_^^_^^_^^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^^_^^_^^_^"
                elif language == 4 : tittleBar3 += "^_^^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each Game box
		listGame = sortKeys(selection, baseTag)
                nbGame = len(listGame)
                listParents = getParents().keys()

		for iGame in range(nbGame):

                        gameID = listGame[iGame]

                        if (gameID == "animals") and (XMLEntriesList["units"]["animland"] == []) : continue
                        
                        tab.attachHSeparator("GameVBox", "%sHSeparator0" %gameID)
                        tab.attachHSeparator("GameVBox", "%sHSeparator01" %gameID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %gameID
                        vBox1 = "%sVBox1" %gameID
                        vBox2 = "%sVBox2" %gameID
                        vBox3 = "%sVBox3" %gameID

                        tab.attachHBox("GameVBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %gameID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %gameID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %gameID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %gameID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , help button in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %gameID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %gameID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %gameID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %gameID)

                        # Game tittle
                        szBoxName = "GameLabel_%s" %gameID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szLabelDesc = getUText(valueLimits[baseTag][gameID]["description"])
                        szWidgetName = "GameLabelTitlle_%s" %gameID
                        tab.attachLabel(szBoxName, szWidgetName, szLabelDesc)

                        # help Button
                        if gameID in ["barbcities", "animals", "techno", "startunit"] :
                                szBoxName = "%sTitlleHBox" %gameID
                                tab.attachHBox(vBox1, szBoxName)
                                tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                                szOptionDesc = getUMenuText("TXT_HELP")
                                szCallbackFunction = "Sto_Help_Option"
                                szWidgetName = "Help_%s_%s" %(baseTag, gameID)
                                tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %gameID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %gameID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %gameID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %gameID)

                        szBoxName = "%sTittleHBox3" %gameID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %gameID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %gameID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %gameID)

                        listOptionsLoop = sortKeys(selection, baseTag, gameID)
                        nbOptionsLoop = len(listOptionsLoop)

                        # double the separator when adding a multiline option
                        bLastOptionMultiLine = False

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                # blank functions drawn with other optionID
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                        if not baseOptionID in listParents : continue

                                if (optionID == "citybuilding") and (XMLEntriesList["buildingsbarb"] == []) :
                                        continue
                                elif (optionID == "defender") and (XMLEntriesList["units"]["barbdefender"] == []) and (XMLEntriesList["units"]["barbfight"] == []) :
                                        continue
                                elif (optionID == "technoreplace") and (XMLEntriesList["techsstartciv"] == []) :
                                        continue

                                optionFunction = valueLimits[baseTag][gameID][baseOptionID]["drawfunc"]
                                
                                bBoxOn = True

                                if optionID == "writelog" :
                                        if not bCanWriteLog : bBoxOn = False
                                        if not isGameMP : bBoxOn = False

                                if (optionFunction == "SelectionSpecial") :
                                        nbElement = len(valueLimits[baseTag][gameID][baseOptionID]["listitem"])
                                        nbPerLine = valueLimits[baseTag][gameID][baseOptionID]["nbperline"]
                                        if nbElement > nbPerLine :
                                                bThisOptionMultiLine = True
                                        else :
                                                bThisOptionMultiLine = False
                                else :
                                        bThisOptionMultiLine = False

                                if (bThisOptionMultiLine) and (not bLastOptionMultiLine) and (iOption != 0) :
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator4" %(gameID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator5" %(gameID,optionID))

                                if optionFunction in listParents:
                                        self.selectDrawFunction(optionFunction)

                                elif optionFunction == "SelectionSpecial" :
                                        self.selectDrawFunction(optionFunction, (vBox2, vBox3, baseTag, gameID, optionID, bBoxOn))

                                else :
                                        #box1 : add option label
                                        szNameHSupport = "%s%sDescSupport2" %(gameID,optionID)
                                        tab.attachHBox(vBox2, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                        szLabelName = "%s%sOptionLabel" %(gameID,optionID)
                                        labelTag = valueLimits[baseTag][gameID][baseOptionID]["txttag"]
                                        szLabelText = getUMenuText(labelTag)
                                        tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        #box2 : add option selection

                                        szNameHSupport = "%s%sDescSupport3" %(gameID,optionID)
                                        tab.attachHBox(vBox3, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                        self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, gameID, optionID, bBoxOn))

                                if (iOption < (nbOptionsLoop-1)) and (not optionFunction in listParents):
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(gameID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(gameID,optionID))
                                        if bThisOptionMultiLine :
                                                tab.attachHSeparator(vBox2, "%s%sHSeparator6" %(gameID,optionID))
                                                tab.attachHSeparator(vBox3, "%s%sHSeparator7" %(gameID,optionID))

                                bLastOptionMultiLine = bool(bThisOptionMultiLine)

                        # end Game separator
                        tab.attachHSeparator("GameVBox", "%sHSeparator1" %gameID)
                        tab.attachHSeparator("GameVBox", "%sHSeparator11" %gameID)
                        tab.attachFixedSpacer("GameVBox", 10)
                        if iGame != (nbGame-1) : tab.attachFixedSpacer("GameVBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("GameVBoxParent", baseTag)

	def refreshGameOptionsTab(self):

		if not canUseGameOptions : return

                baseTag = "game"
		tab = self.pTabControl

		for optionTag1 in selection[baseTag].keys() :

                        if (optionTag1 == "animals") and (XMLEntriesList["units"]["animland"] == []) : continue
                        
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                if (optionTag2 == "citybuilding") and (XMLEntriesList["buildingsbarb"] == []) :
                                        continue
                                elif (optionTag2 == "defender") and (XMLEntriesList["units"]["barbdefender"] == []) and (XMLEntriesList["units"]["barbfight"] == []) :
                                        continue
                                elif (optionTag2 == "technoreplace") and (XMLEntriesList["techsstartciv"] == []) :
                                        continue

                                bBoxOn = True

                                if optionTag2 == "writelog" :
                                        if not bCanWriteLog : bBoxOn = False
                                        if not isGameMP : bBoxOn = False

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                
                                if ("-" in optionTag2) or (optionFunction == "SelectionSpecial") :
                                        if "techquantity" in optionTag2 :
                                                tSel = selection[baseTag][optionTag1]["addtech-%d" %iIndex]
                                                if type(tSel) is types.ListType :
                                                        if len(tSel) == 1 :
                                                                if not tSel[0] in XMLEntriesList["techsrepeat"] :
                                                                        bBoxOn = False
                                                        else :
                                                                bBoxOn = False
                                                szLabelName = "%s%sOptionLabel" %(optionTag1, optionTag2)
                                                tab.setEnabled(szLabelName, bBoxOn)
                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

                                else :
                                        szLabelName = "%s%sOptionLabel" %(optionTag1, optionTag2)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

	def checkEditBoxGameOptionsTab(self):

		if not canUseGameOptions : return

                baseTag = "game"
		tab = self.pTabControl

		for optionTag1 in selection[baseTag].keys() :

                        if (optionTag1 == "animals") and (XMLEntriesList["units"]["animland"] == []) : continue
                        
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                if (optionTag2 == "citybuilding") and (XMLEntriesList["buildingsbarb"] == []) :
                                        continue
                                elif (optionTag2 == "defender") and (XMLEntriesList["units"]["barbdefender"] == []) and (XMLEntriesList["units"]["barbfight"] == []) :
                                        continue
                                elif (optionTag2 == "technoreplace") and (XMLEntriesList["techsstartciv"] == []) :
                                        continue

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

	def drawFfH2OptionsTab(self):

                baseTag = "ffh2"

                # draw the tab ,
		tab = self.pTabControl

		tab.attachVBox("FfH2Form", "FfH2VBoxParent")
		
		# Add Games Options
		
		tab.attachPanel("FfH2VBoxParent", "FfH2PanelCenter")
		tab.setStyle("FfH2PanelCenter", "Panel_Tan15_Style")
		tab.setLayoutFlag("FfH2PanelCenter", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("FfH2PanelCenter", "LAYOUT_SIZE_VEXPANDING")
		
		tab.attachScrollPanel("FfH2PanelCenter", "FfH2Panel")
		tab.setLayoutFlag("FfH2Panel", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("FfH2Panel", "LAYOUT_SIZE_VEXPANDING")

		tab.attachVBox("FfH2Panel", "FfH2VBox")
		tab.setLayoutFlag("FfH2VBox", "LAYOUT_SIZE_HEXPANDING")
		tab.setLayoutFlag("FfH2VBox", "LAYOUT_SIZE_VEXPANDING")

		# add a texture to egalize column ( can't find another way for the moment ... will check that later )
                tittleBar1 = "^_^"
                for FfH2ID in selection[baseTag].keys() :
                        while len(valueLimits[baseTag][FfH2ID]["description"])>len(tittleBar1) : tittleBar1 += "^_^"
                tittleBar1 = getUText(tittleBar1)

                tittleBar2 = ""

                for FfH2ID in sortKeys(selection, baseTag) :
                        for optionID in sortKeys(selection, baseTag, FfH2ID) :
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                labelTag = valueLimits[baseTag][FfH2ID][baseOptionID]["txttag"]
                                if labelTag[0:4] == "TXT_" :
                                        szLabelText = getSMenuText(labelTag)
                                else :
                                        szLabelText = labelTag
                                while len(szLabelText) > len(tittleBar2) : tittleBar2 += "^_^"
                if language == 0 : tittleBar2 = tittleBar2[0:-6]
                elif language == 1 : tittleBar2 = tittleBar2[0:-9]
                elif language == 2 : tittleBar2 = tittleBar2[0:-6]
                elif language == 3 : tittleBar2 = tittleBar2[0:-6]
                elif language == 4 : tittleBar2 = tittleBar2[0:-9]
                tittleBar2 = getUText(tittleBar2)

                tittleBar3 = "^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^^_^"
                if language == 0 : tittleBar3 += "^_^^_^^_^"
                elif language == 1 : tittleBar3 += "^_^^_^^_^^_^^_^"
                elif language == 2 : tittleBar3 += "^_^^_^^_^^_^^_^"
                elif language == 3 : tittleBar3 += "^_^^_^"
                elif language == 4 : tittleBar3 += "^_^^_^"
                tittleBar3 = getUText(tittleBar3)

                # draw each FfH2 box
		listFfH2 = sortKeys(selection, baseTag)
                nbFfH2 = len(listFfH2)
                listParents = getParents().keys()

		for iFfH2 in range(nbFfH2):

                        FfH2ID = listFfH2[iFfH2]

                        if (FfH2ID == "lairs") and (XMLEntriesList["lairs"] == []) : continue
                        if (FfH2ID == "uniqueimprovements") and (XMLEntriesList["uniqueimprovements"] == []) : continue
                        
                        tab.attachHSeparator("FfH2VBox", "%sHSeparator0" %FfH2ID)
                        tab.attachHSeparator("FfH2VBox", "%sHSeparator01" %FfH2ID)

                        #create Hbox with 3 Vbox in
                        szBoxName = "%sHBox" %FfH2ID
                        vBox1 = "%sVBox1" %FfH2ID
                        vBox2 = "%sVBox2" %FfH2ID
                        vBox3 = "%sVBox3" %FfH2ID

                        tab.attachHBox("FfH2VBox", szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_SIZE_HEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator0" %FfH2ID)

                        tab.attachVBox(szBoxName, vBox1)

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator1" %FfH2ID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox2)
                        tab.setLayoutFlag(vBox2, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachFixedSpacer(szBoxName, 5)
                        tab.attachVSeparator(szBoxName, "%sVSeparator2" %FfH2ID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        tab.attachVBox(szBoxName, vBox3)
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_HEXPANDING")
                        tab.setLayoutFlag(vBox3, "LAYOUT_SIZE_VEXPANDING")

                        tab.attachVSeparator(szBoxName, "%sVSeparator3" %FfH2ID)
                        tab.attachFixedSpacer(szBoxName, 5)

                        ## create tittle , help button in box 1
                        # Tittle
                        szBoxName = "%sTittleHBox1" %FfH2ID
                        tab.attachHBox(vBox1, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel1" %FfH2ID, tittleBar1)

                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle1" %FfH2ID)
                        tab.attachHSeparator(vBox1, "%sHSeparatorTittle11" %FfH2ID)

                        # FfH2 tittle
                        szBoxName = "FfH2Label_%s" %FfH2ID
                        tab.attachHBox(vBox1, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                        szLabelDesc = getUText(valueLimits[baseTag][FfH2ID]["description"])
                        szWidgetName = "FfH2LabelTitlle_%s" %FfH2ID
                        tab.attachLabel(szBoxName, szWidgetName, szLabelDesc)

                        # help Button
                        if FfH2ID in ["lairs", "uniqueimprovements"] :
                                szBoxName = "%sTitlleHBox" %FfH2ID
                                tab.attachHBox(vBox1, szBoxName)
                                tab.setLayoutFlag(szBoxName, "LAYOUT_HCENTER")

                                szOptionDesc = getUMenuText("TXT_HELP")
                                szCallbackFunction = "Sto_Help_Option"
                                szWidgetName = "Help_%s_%s" %(baseTag, FfH2ID)
                                tab.attachButton(szBoxName, szWidgetName, szOptionDesc, self.callbackIFace, szCallbackFunction, szWidgetName)

                        ## create tittles , list of options ,selections in box 2 et 3
                        # Tittles
                        szBoxName = "%sTittleHBox2" %FfH2ID
                        tab.attachHBox(vBox2, szBoxName)

                        tab.attachLabel(szBoxName, "%sTittleLabel2" %FfH2ID, tittleBar2)

                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle2" %FfH2ID)
                        tab.attachHSeparator(vBox2, "%sHSeparatorTittle22" %FfH2ID)

                        szBoxName = "%sTittleHBox3" %FfH2ID
                        tab.attachHBox(vBox3, szBoxName)
                        tab.setLayoutFlag(szBoxName, "LAYOUT_LEFT")

                        tab.attachLabel(szBoxName, "%sTittleLabel3" %FfH2ID, tittleBar3)

                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle3" %FfH2ID)
                        tab.attachHSeparator(vBox3, "%sHSeparatorTittle33" %FfH2ID)

                        listOptionsLoop = sortKeys(selection, baseTag, FfH2ID)
                        nbOptionsLoop = len(listOptionsLoop)

                        # double the separator when adding a multiline option
                        bLastOptionMultiLine = False

                        for iOption in range(nbOptionsLoop) :

                                optionID = listOptionsLoop[iOption]

                                # blank functions drawn with other optionID
                                baseOptionID = str(optionID)
                                if "-" in optionID :
                                        baseOptionID, iIndex = splitTag(optionID)
                                        if not baseOptionID in listParents : continue

                                optionFunction = valueLimits[baseTag][FfH2ID][baseOptionID]["drawfunc"]
                                
                                bBoxOn = True

                                if (optionFunction == "SelectionSpecial") :
                                        nbElement = len(valueLimits[baseTag][FfH2ID][baseOptionID]["listitem"])
                                        nbPerLine = valueLimits[baseTag][FfH2ID][baseOptionID]["nbperline"]
                                        if nbElement > nbPerLine :
                                                bThisOptionMultiLine = True
                                        else :
                                                bThisOptionMultiLine = False
                                else :
                                        bThisOptionMultiLine = False

                                if (bThisOptionMultiLine) and (not bLastOptionMultiLine) and (iOption != 0) :
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator4" %(FfH2ID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator5" %(FfH2ID,optionID))

                                if optionFunction in listParents:
                                        self.selectDrawFunction(optionFunction)

                                elif optionFunction == "SelectionSpecial" :
                                        self.selectDrawFunction(optionFunction, (vBox2, vBox3, baseTag, FfH2ID, optionID, bBoxOn))

                                else :
                                        #box1 : add option label
                                        szNameHSupport = "%s%sDescSupport2" %(FfH2ID,optionID)
                                        tab.attachHBox(vBox2, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                        szLabelName = "%s%sOptionLabel" %(FfH2ID,optionID)
                                        labelTag = valueLimits[baseTag][FfH2ID][baseOptionID]["txttag"]
                                        if labelTag[0:4] == "TXT_" :
                                                szLabelText = getUMenuText(labelTag)
                                        else :
                                                szLabelText = getUText(labelTag)
                                        tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        #box2 : add option selection

                                        szNameHSupport = "%s%sDescSupport3" %(FfH2ID,optionID)
                                        tab.attachHBox(vBox3, szNameHSupport)
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                        self.selectDrawFunction(optionFunction, (szNameHSupport, baseTag, FfH2ID, optionID, bBoxOn))

                                if (iOption < (nbOptionsLoop-1)) and (not optionFunction in listParents):
                                        tab.attachHSeparator(vBox2, "%s%sHSeparator2" %(FfH2ID,optionID))
                                        tab.attachHSeparator(vBox3, "%s%sHSeparator3" %(FfH2ID,optionID))
                                        if bThisOptionMultiLine :
                                                tab.attachHSeparator(vBox2, "%s%sHSeparator6" %(FfH2ID,optionID))
                                                tab.attachHSeparator(vBox3, "%s%sHSeparator7" %(FfH2ID,optionID))

                                bLastOptionMultiLine = bool(bThisOptionMultiLine)

                        # end FfH2 separator
                        tab.attachHSeparator("FfH2VBox", "%sHSeparator1" %FfH2ID)
                        tab.attachHSeparator("FfH2VBox", "%sHSeparator11" %FfH2ID)
                        tab.attachFixedSpacer("FfH2VBox", 10)
                        if iFfH2 != (nbFfH2-1) : tab.attachFixedSpacer("FfH2VBox", 10)

                # draw the language dropdown ,buttons resets , load save , exit buttons
                self.drawLowerPanel("FfH2VBoxParent", baseTag)

	def refreshFfH2OptionsTab(self):

                baseTag = "ffh2"
		tab = self.pTabControl

		for optionTag1 in selection[baseTag].keys() :

                        if (optionTag1 == "lairs") and (XMLEntriesList["lairs"] == []) : continue
                        if (optionTag1 == "uniqueimprovements") and (XMLEntriesList["uniqueimprovements"] == []) : continue
                        
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                bBoxOn = True

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                
                                if ("-" in optionTag2) or (optionFunction == "SelectionSpecial") :
                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

                                else :
                                        szLabelName = "%s%sOptionLabel" %(optionTag1, optionTag2)
                                        tab.setEnabled(szLabelName, bBoxOn)

                                        self.selectRefreshFunction(optionFunction, (baseTag, optionTag1, optionTag2, bBoxOn))

	def checkEditBoxFfH2OptionsTab(self):

                baseTag = "ffh2"
		tab = self.pTabControl

		for optionTag1 in selection[baseTag].keys() :

                        if (optionTag1 == "lairs") and (XMLEntriesList["lairs"] == []) : continue
                        if (optionTag1 == "uniqueimprovements") and (XMLEntriesList["uniqueimprovements"] == []) : continue
                        
                        for optionTag2 in selection[baseTag][optionTag1].keys() :

                                baseOptionTag2 = str(optionTag2)
                                if "-" in optionTag2 :
                                        baseOptionTag2, iIndex = splitTag(optionTag2)

                                optionFunction = valueLimits[baseTag][optionTag1][baseOptionTag2]["drawfunc"]
                                self.selectCheckEditBoxFunction(optionFunction, (baseTag, optionTag1, optionTag2))

        #additionnal draw functions
        def drawStartUnit(self):
                global nbMultiBox

                baseTag = "game"
                gameID = "startunit"
                optionID = "startunitselect-%d" %nbMultiBox["startunitselect"]
                baseOptionID = "startunitselect"
                bBoxOn = True

                vBox2 = "%sVBox2" %gameID
                vBox3 = "%sVBox3" %gameID

                # draw the tab ,
		tab = self.pTabControl

                #units dropdowns
                listTag = ["peacedd", "landdd", "waterdd", "airdd", "otherdd", "national", "team", "world", "combatnone"]
                listTag += [item for item in XMLEntriesList["unitcombatlist"]]

                listLabelSelection = ["TXT_UNIT_PEACE", "TXT_UNIT_LAND", "TXT_UNIT_WATER", "TXT_UNIT_AIR", "TXT_UNIT_OTHER",
                                      "TXT_UNIT_NATIONAL", "TXT_UNIT_TEAM", "TXT_UNIT_WORLD", "TXT_UNIT_COMBATNONE"]
                listLabelSelection = [getUMenuText(item) for item in listLabelSelection]
                listLabelSelection += [getUText(XMLDescriptions[item]) for item in XMLEntriesList["unitcombatlist"]]

                nbDD = 0

                for unitTag in listTag :
                        if XMLEntriesList["units"][unitTag] == [] : continue

                        if nbDD % 2 == 0 :
                
                                #box1 : add option label
                                szNameHSupport = "%s%sDescSupport2%d" %(gameID, optionID, nbDD)
                                tab.attachHBox(vBox2, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                                szLabelName = "%s%sOptionLabel%d" %(gameID, optionID, nbDD)
                                if nbDD == 0 : szLabelText = getUMenuText(valueLimits[baseTag][gameID][baseOptionID]["txttag"])
                                else : szLabelText = getUMenuText("TXT_DUM")
                                tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                                tab.setEnabled(szLabelName, bBoxOn)

                                #box2 : add option selection

                                szNameHSupport = "%s%sDescSupport3%d" %(gameID, optionID, nbDD)
                                tab.attachHBox(vBox3, szNameHSupport)
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                                tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                                tab.attachHSeparator(vBox2, "%s%s%dHSeparator20" %(gameID, optionID, nbDD))
                                tab.attachHSeparator(vBox3, "%s%s%dHSeparator30" %(gameID, optionID, nbDD))

                        #dropdowns
                        szDropdownDesc = "%s*UnitDropdownDesc_%d" %(unitTag, nbMultiBox["startunitselect"])

                        listDropdownElements = [listLabelSelection[listTag.index(unitTag)]]
                        listDropdownElements += [getUText(XMLDescriptions[elementType]) for elementType in XMLEntriesList["units"][unitTag]]
                        aszDropdownElements = tuple(listDropdownElements)

                        szCallbackFunction = "Sto_Select_Unit_Select"
                        szWidgetName = "%s*UnitDropdown_%s_%s_%s" %(unitTag, baseTag, gameID, optionID)

                        idSel = selection[baseTag][gameID][optionID]
                        if len(idSel) == 1 :
                                elementType = idSel[0]
                                if elementType in XMLEntriesList["units"][unitTag] : iInitialSelection = XMLEntriesList["units"][unitTag].index(elementType) + 1
                                else : iInitialSelection = 0
                        else :
                                iInitialSelection = 0

                        tab.attachDropDown(szNameHSupport, szWidgetName, szDropdownDesc, aszDropdownElements, self.callbackIFace, szCallbackFunction, szWidgetName, iInitialSelection)
                        tab.setLayoutFlag(szWidgetName, "LAYOUT_LEFT")
                        tab.setEnabled(szWidgetName, bBoxOn)

                        nbDD += 1

                listChildrens = getChildrens(baseTag, gameID, "startunitselect")

                for i in range(len(listChildrens)) :
                        childTag = listChildrens[i]
                        optionID = "%s-%d" %(childTag, nbMultiBox["startunitselect"])

                        if i != 0 :
                                tab.attachHSeparator(vBox2, "%s%sHSeparator20" %(gameID, optionID))
                                tab.attachHSeparator(vBox3, "%s%sHSeparator30" %(gameID, optionID))

                        optionFunction = valueLimits[baseTag][gameID][childTag]["drawfunc"]

                        #box1 : add option label
                        szNameHSupport = "%s%sDescSupport2" %(gameID, optionID)
                        tab.attachHBox(vBox2, szNameHSupport)
                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_RIGHT")

                        labelTag = valueLimits[baseTag][gameID][childTag]["txttag"]
                        szLabelName = "%s%sOptionLabel" %(gameID, optionID)
                        szLabelText = getUMenuText(labelTag)
                        tab.attachLabel(szNameHSupport, szLabelName, szLabelText)
                        tab.setEnabled(szLabelName, bBoxOn)

                        #box2 : add option selection

                        szNameHSupport = "%s%sDescSupport3" %(gameID, optionID)
                        tab.attachHBox(vBox3, szNameHSupport)
                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_SIZE_VEXPANDING")
                        tab.setLayoutFlag(szNameHSupport, "LAYOUT_LEFT")

                        self.selectDrawFunction(optionFunction, (szNameH