# FILE: LandMassesTerrain.py
# PURPOSE: A script for using LandMasses's terrain generator.
# VERSION 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables.
#--------------------------------------------------------------------------------------------------------------------------#

cachedMenuChoices = []
isamodule = False

#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Distinguish between the different fine terrain types.
#--------------------------------------------------------------------------------------------------------------------------#

def generateTerrainTypes(module = False):

        global isamodule

        if not module:
                isamodule = False
        elif module:
                isamodule = True

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	if isamodule:
                settings = open('LandMasses Terrain.cfg', 'r')
                SavedSettings = pickle.load(settings)
                Settings = []
                for Option in range(len(selection_names_and_values)):
                        for Choice in range(len(selection_names_and_values[Option])):
                                if SavedSettings[Option][1] == selection_names_and_values[Option][Choice][0]:
                                        Settings.append(selection_names_and_values[Option][Choice][1])
                                        break
                [Climate, Desert, Plains, TerrainHomogeneity] = Settings
        elif not isamodule:
                Climate = getSelectedMapValue("Climate:")
                Desert = getSelectedMapValue("Desert:")
                Plains = getSelectedMapValue("Plains:")
                TerrainHomogeneity = getSelectedMapValue("Terrain Clumping:")

        # If 'Random' has been selected for any of the options.

        if Climate == -1:
                Climate = dice.get(3, "Cool, temperate, or warm.")

        if Desert == 1:
                Desert = (1 + dice.get(3, "Less, normal, or more desert."))*16

        if Plains == 1:
                Plains = (1 + dice.get(3, "Less, normal, or more plains."))*9

        if TerrainHomogeneity == 1:
                TerrainHomogeneity = 2 + dice.get(5, "very varied, varied, normal, clumped, or very clumped.")

        # How much snow and tundra is to be generated.

        if Climate == 0:
                SnowLatitude = 0.8
                TundraLatitude = 0.7
        elif Climate == 1:
                SnowLatitude = 0.7
                TundraLatitude = 0.6
        elif Climate == 2:
                SnowLatitude = 0.6
                TundraLatitude = 0.5

        TerrainGen = TerrainGenerator(Desert, Plains, SnowLatitude, TundraLatitude, 0.1, 0.2, 0.5, -1, -1,
                                      TerrainHomogeneity)
        TerrainTypes = TerrainGen.generateTerrain()
        return TerrainTypes

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Climate:"),
                    unicode("Desert:"),
                    unicode("Plains:"),
                    unicode("Terrain Clumping:"),
                    ]

selection_names_and_values = [
        [
                ["Warm", 0],
                ["Temperate", 1],
                ["Cool", 2],
                ["Random", -1],
		],
        [
                ["Less desert", 16],
                ["Normal desert", 32],
                ["More desert", 48],
                ["Random", 1],
		],
        [
                ["Less plains", 9],
                ["Normal plains", 18],
                ["More plains", 27],
                ["Random", 1],
		],
        [
                ["Very clumped terrain", 2],
                ["Clumped terrain", 3],
                ["Normal", 4],
                ["Varied terrain", 5],
                ["Very varied terrain", 6],
                ["Random", 1],
                ],
        ]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 0

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("LandMasses Map Size")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():

        global isamodule

        if isamodule == True:
                return
    
	cymap = CyMap()
	settings = open('LandMasses Terrain.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to LandMasses Terrain.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('LandMasses Terrain.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find LandMasses Terrain.cfg"
	except EOFError:
		print "    Bad contents in LandMasses Terrain.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
