# FILE: Modules
# PURPOSE: To allow the user to combine the affects of various different map scripts.
# VERSION: 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import LandMassesMapSize
import LandMassesLands
import LandMassesTerrain
import LandMassesFeatures
import LandMassesBonuses
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables
#--------------------------------------------------------------------------------------------------------------------------#
	
#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Determine the map size.
#--------------------------------------------------------------------------------------------------------------------------#

def getGridSize(argsList):

        gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	MapSize = getSelectedMapValue("Map Size:")

	# If the Land Masses method of generating a map size has been selected:

	if MapSize == 1:
                Width, Height = LandMassesMapSize.getGridSize(argsList, True)
                return (Width, Height)

        # If standard map sizes have been selected.

        else:
                grid_sizes = {
		WorldSizeTypes.WORLDSIZE_DUEL:		(10,6),
		WorldSizeTypes.WORLDSIZE_TINY:		(13,8),
		WorldSizeTypes.WORLDSIZE_SMALL:		(16,10),
		WorldSizeTypes.WORLDSIZE_STANDARD:	(21,13),
		WorldSizeTypes.WORLDSIZE_LARGE:		(26,16),
		WorldSizeTypes.WORLDSIZE_HUGE:		(32,20)
	}

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Distinguish between the different base terrain types - ocean, flatland, hill or peak.
#--------------------------------------------------------------------------------------------------------------------------#

def generatePlotTypes():

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()

	Lands = getSelectedMapValue("Lands:")

	# If LandMasses method of generating land has been selected.

	if Lands == 1:
                PlotTypes = LandMassesLands.generatePlotTypes(True)

        # If standard land generation has been selected.

        else:

                fractal_world = FractalWorld()
                fractal_world.initFractal(polar = True)
                PlotTypes = fractal_world.generatePlotTypes(water_percent = 75)

	return PlotTypes

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Distinguish between the different fine terrain types.
#--------------------------------------------------------------------------------------------------------------------------#

def generateTerrainTypes():

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()

	TerrainType = getSelectedMapValue("Terrain:")

	# If LandMasses method of generating terrain has been selected.

	if TerrainType == 1:
                TerrainTypes = LandMassesTerrain.generateTerrainTypes(True)

        # If standard terrain generation has been selected.

        else:
                terraingen = TerrainGenerator()
                TerrainTypes = terraingen.generateTerrain()

	return TerrainTypes

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3A: Add rivers.
#--------------------------------------------------------------------------------------------------------------------------#

def addRivers():

        CyPythonMgr().allowDefaultImpl()
	return
	
#--------------------------------------------------------------------------------------------------------------------------#
# Step 3B: Add lakes.
#--------------------------------------------------------------------------------------------------------------------------#

def addLakes():

        CyPythonMgr().allowDefaultImpl()
	return

#--------------------------------------------------------------------------------------------------------------------------#
# Step 4: Add features.
#--------------------------------------------------------------------------------------------------------------------------#

def addFeatures():

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()

	FeatureType = getSelectedMapValue("Features:")

	# If LandMasses method of generating feature has been selected.

	if FeatureType == 1:
                FeatureTypes = LandMassesFeatures.addFeatures(True)

        # If standard feature generation has been selected.

        else:
                featuregen = FeatureGenerator()
                FeatureTypes = featuregen.addFeatures()
	
	return 0

#--------------------------------------------------------------------------------------------------------------------------#
# Step 5: Add bonuses.
#--------------------------------------------------------------------------------------------------------------------------#

def addBonuses():

        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()

	Bonuses = getSelectedMapValue("Bonuses:")

	# If LandMasses method of placing bonuses has been selected.

	if Bonuses == 1:
                BonusesAdded = LandMassesBonuses.addBonuses(True)

        # If standard method of placing bonuses has been selected.

        else:
                CyPythonMgr().allowDefaultImpl()
        
	return 0

#--------------------------------------------------------------------------------------------------------------------------#
# Step 6: Place huts.
#--------------------------------------------------------------------------------------------------------------------------#

def addGoodies():
	CyPythonMgr().allowDefaultImpl()
	return

#--------------------------------------------------------------------------------------------------------------------------#
# Step 7: Players are placed.
#--------------------------------------------------------------------------------------------------------------------------#

def assignStartingPlots():
	CyPythonMgr().allowDefaultImpl()
	return

#--------------------------------------------------------------------------------------------------------------------------#
# Step 8: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Map Size:"),
                    unicode("Lands:"),
                    unicode("Terrain:"),
                    unicode("Rivers:"),
                    unicode("Lakes:"),
                    unicode("Features:"),
                    unicode("Bonuses:"),
                    unicode("Huts:"),
                    unicode("Civ Placement:"),
                    ]

selection_names_and_values = [
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ],
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ],
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ],
        [
                ["Standard", 0],
                ],
        [
                ["Standard", 0],
                ],
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ],
        [
                ["Standard", 0],
                ["LandMasses", 1],
                ],
        [
                ["Standard", 0],
                ],
        [
                ["Standard", 0],
                ],
        ]
        
#--------------------------------------------------------------------------------------------------------------------------#
# Step 9: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 1

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("Modules")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():
    
	cymap = CyMap()
	settings = open('Modules.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to Modules.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('Modules.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find Modules.cfg"
	except EOFError:
		print "    Bad contents in Modules.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
